/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xmind.core.IFileEntry;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookExtension;
import org.xmind.core.internal.WorkbookExtensionManager;
import org.xmind.core.internal.dom.ManifestImpl;
import org.xmind.core.internal.dom.WorkbookExtensionImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkbookExtensionManagerImpl
extends WorkbookExtensionManager {
    private WorkbookImpl ownedWorkbook;
    private Map<String, WorkbookExtensionImpl> extensions = new HashMap<String, WorkbookExtensionImpl>();

    protected void setOwnedWorkbook(WorkbookImpl ownedWorkbook) {
        this.ownedWorkbook = ownedWorkbook;
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.ownedWorkbook;
    }

    @Override
    public IWorkbookExtension createExtension(String providerName) {
        return this.createExtension(providerName, null);
    }

    protected IWorkbookExtension createExtension(String providerName, Document doc) {
        if (providerName == null || "".equals(providerName)) {
            return null;
        }
        IWorkbookExtension ext = this.extensions.get(providerName);
        if (ext == null) {
            if (doc == null) {
                doc = this.createExtensionDocument(providerName);
            }
            this.ensureExtensionElement(providerName);
            this.ensureFileEntry(providerName);
            ext = new WorkbookExtensionImpl(doc, this.ownedWorkbook);
            this.extensions.put(providerName, (WorkbookExtensionImpl)ext);
            ((WorkbookExtensionImpl)ext).addNotify(this.ownedWorkbook);
            this.ownedWorkbook.updateModificationInfo();
        }
        return ext;
    }

    private void ensureExtensionElement(String provider) {
        Element e;
        Element[] es;
        Element extsEle = DOMUtils.ensureChildElement(this.getWorkbookElement(), "extensions");
        Element[] elementArray = es = DOMUtils.getChildElementsByTag(extsEle, "extension");
        int n = es.length;
        int n2 = 0;
        while (n2 < n) {
            e = elementArray[n2];
            if (provider.equals(e.getAttribute("provider"))) {
                return;
            }
            ++n2;
        }
        e = DOMUtils.createElement(extsEle, "extension");
        e.setAttribute("provider", provider);
    }

    private Document createExtensionDocument(String provider) {
        Document doc = DOMUtils.createDocument(this.getExtensionTag(provider));
        doc.getDocumentElement().setAttribute("provider", provider);
        return doc;
    }

    private void ensureFileEntry(String provider) {
        String path;
        ManifestImpl m = this.ownedWorkbook.getManifest();
        IFileEntry entry = m.getFileEntry(path = "extensions/" + provider + ".xml");
        if (entry == null) {
            m.createFileEntry(path).increaseReference();
        }
    }

    private Element getWorkbookElement() {
        return this.ownedWorkbook.getWorkbookElement();
    }

    private String getExtensionTag(String providerName) {
        int index;
        if (providerName.contains(".") && (index = providerName.lastIndexOf(".")) > 0 && index < providerName.length()) {
            return providerName.substring(index + 1);
        }
        return providerName;
    }

    @Override
    public List<IWorkbookExtension> getExtensions() {
        return new ArrayList<IWorkbookExtension>(this.extensions.values());
    }

    @Override
    public IWorkbookExtension getExtension(String provider) {
        if (provider != null && !"".equals(provider)) {
            for (IWorkbookExtension e : this.getExtensions()) {
                if (!provider.equals(e.getProviderName())) continue;
                return e;
            }
        }
        return null;
    }

    @Override
    public void deleteExtension(String providerName) {
    }

    @Override
    public List<String> getProviders() {
        Element es = DOMUtils.getFirstChildElementByTag(this.getWorkbookElement(), "extensions");
        if (es != null) {
            Element[] eles = DOMUtils.getChildElementsByTag(es, "extension");
            ArrayList<String> providers = new ArrayList<String>();
            Element[] elementArray = eles;
            int n = eles.length;
            int n2 = 0;
            while (n2 < n) {
                Element ele = elementArray[n2];
                String provider = ele.getAttribute("provider");
                if (provider != null && !"".equals(provider)) {
                    providers.add(provider);
                }
                ++n2;
            }
            return providers;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isOrphan() {
        return false;
    }
}

