/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.IAdaptable;
import org.xmind.core.IControlPoint;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.Relationship;
import org.xmind.core.internal.dom.ControlPointImpl;
import org.xmind.core.internal.dom.InternalDOMUtils;
import org.xmind.core.internal.dom.SheetImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.internal.dom.WorkbookUtilsImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipImpl
extends Relationship
implements ICoreEventSource {
    private Element implementation;
    private WorkbookImpl ownedWorkbook;
    private Map<Integer, ControlPointImpl> controlPoints = null;

    public RelationshipImpl(Element implementation, WorkbookImpl ownedWorkbook) {
        this.implementation = DOMUtils.addIdAttribute(implementation);
        this.ownedWorkbook = ownedWorkbook;
    }

    public Element getImplementation() {
        return this.implementation;
    }

    @Override
    public String getId() {
        return this.implementation.getAttribute("id");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof RelationshipImpl)) {
            return false;
        }
        RelationshipImpl r = (RelationshipImpl)obj;
        return this.implementation == r.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    @Override
    public String toString() {
        return "REL#" + this.getId() + "(" + this.getTitleText() + ")";
    }

    @Override
    public String getEnd1Id() {
        return DOMUtils.getAttribute(this.implementation, "end1");
    }

    @Override
    public void setEnd1Id(String id) {
        String oldId = this.getEnd1Id();
        DOMUtils.setAttribute(this.implementation, "end1", id);
        String newId = this.getEnd1Id();
        this.fireValueChange("relationshipEnd1", oldId, newId);
        this.updateModificationInfo();
    }

    @Override
    public String getEnd2Id() {
        return DOMUtils.getAttribute(this.implementation, "end2");
    }

    @Override
    public void setEnd2Id(String id) {
        String oldId = this.getEnd2Id();
        DOMUtils.setAttribute(this.implementation, "end2", id);
        String newId = this.getEnd2Id();
        this.fireValueChange("relationshipEnd2", oldId, newId);
        this.updateModificationInfo();
    }

    @Override
    public IRelationshipEnd getEnd1() {
        return this.findEnd(this.getEnd1Id());
    }

    @Override
    public IRelationshipEnd getEnd2() {
        return this.findEnd(this.getEnd2Id());
    }

    private IRelationshipEnd findEnd(String endId) {
        if (endId == null) {
            return null;
        }
        IAdaptable obj = this.ownedWorkbook.getAdaptableRegistry().getAdaptable(endId, this.implementation.getOwnerDocument());
        if (obj instanceof IRelationshipEnd) {
            return (IRelationshipEnd)((Object)obj);
        }
        return null;
    }

    @Override
    public ISheet getParent() {
        Node p = this.implementation.getParentNode();
        if (DOMUtils.isElementByTag(p, "relationships") && DOMUtils.isElementByTag(p = p.getParentNode(), "sheet")) {
            return (ISheet)this.ownedWorkbook.getAdaptableRegistry().getAdaptable(p);
        }
        return null;
    }

    @Override
    public void setTitleText(String titleText) {
        String oldText = this.getLocalTitleText();
        DOMUtils.setText(this.implementation, "title", titleText);
        String newText = this.getLocalTitleText();
        this.fireValueChange("titleText", oldText, newText);
        this.updateModificationInfo();
    }

    @Override
    protected String getLocalTitleText() {
        return DOMUtils.getTextContentByTag(this.implementation, "title");
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.ownedWorkbook;
    }

    @Override
    public boolean isOrphan() {
        return DOMUtils.isOrphanNode(this.implementation);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (ICoreEventSource.class.equals(adapter)) {
            return adapter.cast(this);
        }
        if (adapter.isAssignableFrom(Element.class)) {
            return adapter.cast(this.implementation);
        }
        return super.getAdapter(adapter);
    }

    @Override
    public boolean checkAvailable() {
        ISheet sheet1;
        IRelationshipEnd end1 = this.getEnd1();
        IRelationshipEnd end2 = this.getEnd2();
        return end1 != null && end2 != null && (sheet1 = end1.getOwnedSheet()) != null && sheet1.equals(end2.getOwnedSheet());
    }

    @Override
    public String getStyleId() {
        return DOMUtils.getAttribute(this.implementation, "style-id");
    }

    @Override
    public void setStyleId(String styleId) {
        String oldValue = this.getStyleId();
        WorkbookImpl workbook = this.getRealizedWorkbook();
        WorkbookUtilsImpl.decreaseStyleRef(workbook, this);
        DOMUtils.setAttribute(this.implementation, "style-id", styleId);
        WorkbookUtilsImpl.increaseStyleRef(workbook, this);
        String newValue = this.getStyleId();
        this.fireValueChange("style", oldValue, newValue);
        this.updateModificationInfo();
    }

    @Override
    public IControlPoint getControlPoint(int index) {
        ControlPointImpl controlPoint;
        if (this.controlPoints == null) {
            this.controlPoints = new HashMap<Integer, ControlPointImpl>();
        }
        if ((controlPoint = this.controlPoints.get(index)) == null) {
            controlPoint = new ControlPointImpl(this, index);
            this.controlPoints.put(index, controlPoint);
        }
        return controlPoint;
    }

    protected WorkbookImpl getRealizedWorkbook() {
        ISheet sheet = this.getParent();
        if (sheet != null && this.ownedWorkbook == sheet.getParent()) {
            return this.ownedWorkbook;
        }
        return null;
    }

    protected void addNotify(WorkbookImpl workbook, SheetImpl parent) {
        this.getImplementation().setIdAttribute("id", true);
        workbook.getAdaptableRegistry().registerById(this, this.getId(), this.getImplementation().getOwnerDocument());
        WorkbookUtilsImpl.increaseStyleRef(workbook, this);
    }

    protected void removeNotify(WorkbookImpl workbook, SheetImpl parent) {
        WorkbookUtilsImpl.decreaseStyleRef(workbook, this);
        workbook.getAdaptableRegistry().unregisterById(this, this.getId(), this.getImplementation().getOwnerDocument());
        this.getImplementation().setIdAttribute("id", false);
    }

    @Override
    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }

    @Override
    public ICoreEventSupport getCoreEventSupport() {
        return this.ownedWorkbook.getCoreEventSupport();
    }

    private void fireValueChange(String type, Object oldValue, Object newValue) {
        this.getCoreEventSupport().dispatchValueChange(this, type, oldValue, newValue);
    }

    @Override
    public long getModifiedTime() {
        return InternalDOMUtils.getModifiedTime(this, this.implementation);
    }

    @Override
    public String getModifiedBy() {
        return InternalDOMUtils.getModifiedBy(this, this.implementation);
    }

    protected void updateModificationInfo() {
        InternalDOMUtils.updateModificationInfo(this);
        ISheet sheet = this.getParent();
        if (sheet != null) {
            ((SheetImpl)sheet).updateModificationInfo();
        }
    }
}

