/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import org.w3c.dom.Element;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.Numbering;
import org.xmind.core.internal.dom.TopicImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberingImpl
extends Numbering
implements ICoreEventSource {
    private Element topicElement;
    private TopicImpl ownedTopic;

    public NumberingImpl(Element topicElement, TopicImpl ownedTopic) {
        this.topicElement = topicElement;
        this.ownedTopic = ownedTopic;
    }

    public Element getNumberingElement() {
        return DOMUtils.getFirstChildElementByTag(this.topicElement, "numbering");
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (ICoreEventSource.class.equals(adapter)) {
            return adapter.cast(this);
        }
        if (adapter.isAssignableFrom(Element.class)) {
            return adapter.cast(this.getNumberingElement());
        }
        return super.getAdapter(adapter);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof NumberingImpl)) {
            return false;
        }
        NumberingImpl that = (NumberingImpl)obj;
        return this.topicElement == that.topicElement;
    }

    public int hashCode() {
        return this.topicElement.hashCode();
    }

    public String toString() {
        return "Numbering of " + this.ownedTopic;
    }

    @Override
    public String getNumberFormat() {
        Element e = this.getNumberingElement();
        if (e == null) {
            return null;
        }
        return DOMUtils.getAttribute(e, "number-format");
    }

    @Override
    public String getSeparator() {
        Element e = this.getNumberingElement();
        if (e == null) {
            return null;
        }
        return DOMUtils.getAttribute(e, "number-separator");
    }

    @Override
    public String getPrefix() {
        return this.getText("prefix");
    }

    @Override
    public String getSuffix() {
        return this.getText("suffix");
    }

    @Override
    public String getDepth() {
        Element e = this.getNumberingElement();
        if (e == null) {
            return null;
        }
        return DOMUtils.getAttribute(e, "number-depth");
    }

    @Override
    public boolean prependsParentNumbers() {
        Element e = this.getNumberingElement();
        if (e == null) {
            return true;
        }
        String value = DOMUtils.getAttribute(e, "prepending-numbers");
        return !"none".equals(value);
    }

    @Override
    public ITopic getParent() {
        return this.ownedTopic;
    }

    @Override
    public ISheet getOwnedSheet() {
        return this.ownedTopic.getOwnedSheet();
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.ownedTopic.getOwnedWorkbook();
    }

    @Override
    public boolean isOrphan() {
        return this.ownedTopic.isOrphan();
    }

    private void setAttribute(String key, String value) {
        if (value == null) {
            Element e = this.getNumberingElement();
            if (e != null) {
                e.removeAttribute(key);
                if (!e.hasAttributes() && !e.hasChildNodes()) {
                    this.topicElement.removeChild(e);
                }
            }
        } else {
            Element e = DOMUtils.ensureChildElement(this.topicElement, "numbering");
            e.setAttribute(key, value);
        }
    }

    private String getText(String key) {
        Element e = this.getNumberingElement();
        if (e != null) {
            return DOMUtils.getTextContentByTag(e, key);
        }
        return null;
    }

    private void setText(String key, String value) {
        if (value == null) {
            Element t;
            Element e = this.getNumberingElement();
            if (e != null && (t = DOMUtils.getFirstChildElementByTag(e, key)) != null) {
                e.removeChild(t);
                if (!e.hasAttributes() && !e.hasChildNodes()) {
                    this.topicElement.removeChild(e);
                }
            }
        } else {
            Element e = DOMUtils.ensureChildElement(this.topicElement, "numbering");
            Element t = DOMUtils.ensureChildElement(e, key);
            t.setTextContent(value);
        }
    }

    @Override
    public void setFormat(String format) {
        String oldValue = this.getNumberFormat();
        this.setAttribute("number-format", format);
        String newValue = this.getNumberFormat();
        this.fireValueChange("numberingFormat", oldValue, newValue);
        this.ownedTopic.updateModificationInfo();
    }

    @Override
    public void setPrefix(String prefix) {
        String oldValue = this.getPrefix();
        this.setText("prefix", prefix);
        String newValue = this.getPrefix();
        this.fireValueChange("numberingPrefix", oldValue, newValue);
        this.ownedTopic.updateModificationInfo();
    }

    @Override
    public void setPrependsParentNumbers(boolean prepend) {
        Boolean oldValue = this.prependsParentNumbers();
        this.setAttribute("prepending-numbers", prepend ? null : "none");
        Boolean newValue = this.prependsParentNumbers();
        this.fireValueChange("parentNumberingPrepending", oldValue, newValue);
        this.ownedTopic.updateModificationInfo();
    }

    @Override
    public void setSuffix(String suffix) {
        String oldValue = this.getSuffix();
        this.setText("suffix", suffix);
        String newValue = this.getSuffix();
        this.fireValueChange("numberingSuffix", oldValue, newValue);
        this.ownedTopic.updateModificationInfo();
    }

    @Override
    public void setSeparator(String separator) {
        String oldValue = this.getSeparator();
        this.setAttribute("number-separator", separator);
        String newValue = this.getSeparator();
        this.fireValueChange("numberingSeparator", oldValue, newValue);
        this.ownedTopic.updateModificationInfo();
    }

    @Override
    public void setDepth(String depth) {
        String oldValue = String.valueOf(this.getComputedDepth());
        this.setAttribute("number-depth", depth);
        String newValue = String.valueOf(this.getComputedDepth());
        this.fireValueChange("numberingDepth", oldValue, newValue);
        this.ownedTopic.updateModificationInfo();
    }

    private void fireValueChange(String eventType, Object oldValue, Object newValue) {
        this.getCoreEventSupport().dispatchValueChange(this, eventType, oldValue, newValue);
    }

    @Override
    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }

    @Override
    public ICoreEventSupport getCoreEventSupport() {
        return this.ownedTopic.getCoreEventSupport();
    }
}

