/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.viewers;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ImageLabel
extends Composite {
    public static final int SCALE_NONE = 0;
    public static final int SCALE_TO_FIT = 1;
    public static final int SCALE_NO_EXPAND = 1024;
    private Image image = null;
    private int hAlignment = 0x1000000;
    private int vAlignment = 0x1000000;
    private int scaleHint = 0;

    public ImageLabel(Composite parent, int style) {
        super(parent, style);
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                ImageLabel.this.onPaint(event);
            }
        });
    }

    private void onPaint(Event event) {
        this.paintImageLabel(event.gc);
    }

    protected void paintImageLabel(GC gc) {
        if (this.image == null) {
            return;
        }
        Rectangle imgArea = this.image.getBounds();
        if (imgArea.width == 0 || imgArea.height == 0) {
            return;
        }
        Rectangle target = this.computePaintArea(imgArea, this.getClientArea());
        gc.setAntialias(1);
        gc.drawImage(this.image, imgArea.x, imgArea.y, imgArea.width, imgArea.height, target.x, target.y, target.width, target.height);
    }

    protected Rectangle computePaintArea(Rectangle imgArea, Rectangle clientArea) {
        Rectangle target = new Rectangle(clientArea.x, clientArea.y, imgArea.width, imgArea.height);
        if ((this.scaleHint & 1) != 0) {
            if (clientArea.width * imgArea.height > clientArea.height * imgArea.width) {
                target.height = clientArea.height;
                target.width = imgArea.width * clientArea.height / imgArea.height;
            } else {
                target.width = clientArea.width;
                target.height = imgArea.height * clientArea.width / imgArea.width;
            }
            if ((this.scaleHint & 0x400) != 0 && (target.width > imgArea.width || target.height > imgArea.height)) {
                target.width = imgArea.width;
                target.height = imgArea.height;
            }
        }
        if ((this.hAlignment & 0x1000000) != 0) {
            target.x += (clientArea.width - target.width) / 2;
        } else if ((this.hAlignment & 0x20000) != 0) {
            target.x += clientArea.width - target.width;
        }
        if ((this.vAlignment & 0x1000000) != 0) {
            target.y += (clientArea.height - target.height) / 2;
        } else if ((this.vAlignment & 0x20000) != 0) {
            target.y += clientArea.height - target.height;
        }
        return target;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size;
        if (wHint != -1 && hHint != -1) {
            size = new Point(wHint, hHint);
        } else if (this.image == null) {
            size = new Point(0, 0);
        } else {
            Rectangle b = this.image.getBounds();
            if (b.width == 0 || b.height == 0) {
                size = new Point(0, 0);
            } else {
                size = new Point(b.width, b.height);
                if (wHint != -1) {
                    size.x = wHint;
                    size.y = b.height * wHint / b.width;
                } else if (hHint != -1) {
                    size.y = hHint;
                    size.x = b.width * hHint / b.height;
                }
            }
        }
        Rectangle trimmed = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trimmed.width, trimmed.height);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image == this.image) {
            return;
        }
        this.image = image;
        this.redraw();
    }

    public int getHorizontalAlignment() {
        return this.hAlignment;
    }

    public void setHorizontalAlignment(int alignment) {
        this.checkWidget();
        if (alignment == this.hAlignment) {
            return;
        }
        this.hAlignment = alignment;
        this.redraw();
    }

    public int getVerticalAlignment() {
        return this.vAlignment;
    }

    public void setVerticalAlignment(int alignment) {
        this.checkWidget();
        if (alignment == this.vAlignment) {
            return;
        }
        this.vAlignment = alignment;
        this.redraw();
    }

    public int getScaleHint() {
        return this.scaleHint;
    }

    public void setScaleHint(int hint) {
        this.checkWidget();
        if ((hint & 1) == 0) {
            hint = 0;
        }
        if (hint == this.scaleHint) {
            return;
        }
        this.scaleHint = hint;
        this.redraw();
    }
}

