/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.properties;

import java.beans.PropertyChangeSupport;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.xmind.ui.properties.Messages;

public class PropertyEditingSection {
    public static final String PROP_TITLE = "title";
    public static final String PROP_EXPANDED = "expanded";
    private Composite composite = null;
    private Composite client = null;
    private Composite title = null;
    private Label titleLabel = null;
    private Control separator = null;
    private boolean expanded = true;
    private String titleText = "";
    private Color titleColor = null;
    private PropertyChangeSupport eventSupport = new PropertyChangeSupport(this);

    public PropertyEditingSection(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.composite.setLayout((Layout)gridLayout);
        Control titleControl = this.createTitle(this.composite);
        GridData titleLayoutData = new GridData(4, 4, true, false);
        titleLayoutData.widthHint = -1;
        titleLayoutData.heightHint = -1;
        titleControl.setLayoutData((Object)titleLayoutData);
        Control separatorControl = this.createSeparator(this.composite);
        GridData separatorLayoutData = new GridData(4, 4, true, false);
        separatorLayoutData.widthHint = -1;
        separatorLayoutData.heightHint = -1;
        separatorControl.setLayoutData((Object)separatorLayoutData);
        Control bodyControl = this.createClientBody(this.composite);
        GridData bodyLayoutData = new GridData(4, 4, true, true);
        bodyLayoutData.widthHint = -1;
        bodyLayoutData.heightHint = -1;
        bodyControl.setLayoutData((Object)bodyLayoutData);
    }

    private Control createTitle(Composite parent) {
        this.title = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 3;
        this.title.setLayout((Layout)gridLayout);
        Control labelControl = this.createTitleLabel(this.title);
        GridData labelLayoutData = new GridData(4, 4, true, true);
        labelLayoutData.widthHint = -1;
        labelLayoutData.heightHint = -1;
        labelControl.setLayoutData((Object)labelLayoutData);
        this.enableClickListener((Control)this.title, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        return this.title;
    }

    private Control createTitleLabel(Composite parent) {
        this.titleLabel = new Label(parent, 64);
        this.titleLabel.setText(this.titleText);
        return this.titleLabel;
    }

    private Control createSeparator(Composite parent) {
        this.separator = new Label(parent, 258);
        return this.separator;
    }

    private Control createClientBody(Composite parent) {
        this.client = new Composite(parent, 0);
        return this.client;
    }

    private void enableClickListener(Control control, Listener listener) {
        control.addListener(3, listener);
        control.setCursor(control.getDisplay().getSystemCursor(21));
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length) {
                this.enableClickListener(children[i], listener);
                ++i;
            }
        }
    }

    protected void paintChevron(Display display, GC gc, int x, int y, int width, int height, Color color) {
        if (color != null) {
            gc.setBackground(color);
        } else {
            gc.setBackground(display.getSystemColor(21));
        }
        int cx = x + width / 2;
        int cy = y + height / 2;
        if (this.isExpanded()) {
            gc.fillPolygon(new int[]{cx - 5, cy - 3, cx + 3, cy - 3, cx - 1, cy + 7});
        } else {
            gc.fillPolygon(new int[]{cx - 4, cy - 4, cx + 6, cy, cx - 4, cy + 4});
        }
    }

    public Control getControl() {
        return this.composite;
    }

    public Composite getClient() {
        return this.client;
    }

    public void setBackground(Color color) {
        if (this.composite == null || this.composite.isDisposed()) {
            return;
        }
        this.composite.setBackground(color);
        this.client.setBackground(color);
        this.title.setBackground(color);
        this.titleLabel.setBackground(color);
        this.separator.setBackground(color);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void toggleExpanded() {
        this.setExpanded(!this.isExpanded());
    }

    public void setExpanded(boolean expanded) {
        boolean oldExpanded = this.isExpanded();
        if (oldExpanded == expanded) {
            return;
        }
        this.expanded = expanded;
        if (this.composite == null || this.composite.isDisposed()) {
            return;
        }
        this.client.setVisible(expanded);
        this.separator.setVisible(expanded);
        ((GridData)this.client.getLayoutData()).exclude = !expanded;
        ((GridData)this.separator.getLayoutData()).exclude = !expanded;
        this.composite.layout(true);
        this.eventSupport.firePropertyChange(PROP_EXPANDED, oldExpanded, expanded);
    }

    public String getTitleText() {
        return this.titleText;
    }

    public void setTitleText(String titleText) {
        String string = this.titleText = titleText == null ? "" : titleText;
        if (this.titleLabel == null || this.titleLabel.isDisposed()) {
            return;
        }
        if ("".equals(this.titleText)) {
            this.titleLabel.setText(Messages.PropertyEditingSection_UntitledCategory);
            this.titleLabel.setForeground(Display.getCurrent().getSystemColor(15));
        } else {
            this.titleLabel.setText(this.getTitleText());
            this.titleLabel.setForeground(this.titleColor);
        }
    }

    public void setTitleColor(Color color) {
        this.titleColor = color;
        if (this.titleLabel != null && !this.titleLabel.isDisposed()) {
            if ("".equals(this.titleText)) {
                this.titleLabel.setForeground(Display.getCurrent().getSystemColor(15));
            } else {
                this.titleLabel.setForeground(color);
            }
        }
    }

    public void setTitleFont(Font font) {
        if (this.titleLabel != null && !this.titleLabel.isDisposed()) {
            this.titleLabel.setFont(font);
        }
    }

    public PropertyChangeSupport getEventSupport() {
        return this.eventSupport;
    }
}

