/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.audio.internal.device;

import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.TargetDataLine;
import org.xmind.core.audio.AudioValues;
import org.xmind.core.audio.IAudioDevice;
import org.xmind.core.audio.IAudioSource;
import org.xmind.core.audio.IAudioTarget;
import org.xmind.core.audio.device.AudioChannelBase;
import org.xmind.core.audio.internal.device.AudioUtils;
import org.xmind.core.audio.internal.device.RawDataRecorder;

public class RawDataChannel
extends AudioChannelBase
implements Runnable {
    private static final boolean DEBUG = RawDataRecorder.DEBUG;
    private TargetDataLine line;
    private OutputStream output;
    private boolean stopped = false;
    private boolean disposed = false;
    private long start = -1L;
    private boolean started = false;
    private boolean done = false;

    public RawDataChannel(IAudioDevice device, IAudioSource source, IAudioTarget target, TargetDataLine line, OutputStream output) {
        super(device, source, target);
        this.line = line;
        this.output = output;
    }

    synchronized void open() {
        this.start = System.currentTimeMillis();
        this.started = false;
        if (DEBUG) {
            System.out.println("[RawDataChannel] Create record thread and start it");
        }
        Thread thread = new Thread((Runnable)this, this.getJobName());
        thread.start();
        if (DEBUG) {
            System.out.println("[RawDataChannel] Wait until the thread started");
        }
        while (!this.started) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        if (DEBUG) {
            System.out.println("[RawDataChannel] The thread started");
        }
    }

    protected String getJobName() {
        return "Record Raw Audio Data";
    }

    public boolean isOpen() {
        return super.isOpen() && this.line.isOpen();
    }

    public boolean isRunning() {
        return super.isRunning() && this.line.isRunning();
    }

    public synchronized void close() throws Exception {
        if (this.isOpen()) {
            if (DEBUG) {
                System.out.println("[RawDataChannel] Mark thread stop");
            }
            this.stopped = true;
            while (!this.done && !this.disposed) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            this.done = true;
            if (!this.disposed) {
                this.fireStopped();
            }
        } else {
            ((RawDataRecorder)this.getDevice()).channelClosed(this);
            this.done = true;
        }
        super.close();
    }

    synchronized void dispose() {
        this.disposed = true;
        ((RawDataRecorder)this.getDevice()).channelClosed(this);
        try {
            super.close();
        }
        catch (Throwable throwable) {}
        this.release();
    }

    public void run() {
        this.started = true;
        if (DEBUG) {
            System.out.println("[RawDataChannel] Record Thread Started");
        }
        if (!this.line.isOpen()) {
            return;
        }
        byte[] data = new byte[this.line.getBufferSize() / 5];
        Throwable exception = null;
        this.line.start();
        try {
            while (!this.stopped && !this.disposed) {
                int numBytesRead = this.line.read(data, 0, data.length);
                this.output.write(data, 0, numBytesRead);
                this.fireValueChanged(this.createValues(data, numBytesRead));
            }
        }
        catch (Throwable e) {
            exception = e;
        }
        if (DEBUG) {
            if (this.disposed) {
                System.out.println("[RawDataChannel] Record Channel Disposed");
            } else if (this.stopped) {
                System.out.println("[RawDataChannel] Record Thread Stopped");
            } else {
                System.out.println("[RawDataChannel] Error Occurred While Recording");
            }
        }
        if (!this.disposed) {
            Throwable releaseException = this.release();
            if (exception == null) {
                exception = releaseException;
            }
        }
        ((RawDataRecorder)this.getDevice()).channelClosed(this);
        if (exception != null) {
            if (DEBUG) {
                exception.printStackTrace();
            }
            this.handleError(exception);
        } else if (!this.disposed) {
            block20: {
                try {
                    this.encode();
                }
                catch (Throwable e) {
                    if (exception != null) break block20;
                    exception = e;
                }
            }
            if (exception != null) {
                if (DEBUG) {
                    exception.printStackTrace();
                }
                this.handleError(exception);
            }
        }
        this.done = true;
    }

    protected void encode() throws Exception {
    }

    private Throwable release() {
        IOException exception = null;
        if (this.line != null) {
            this.line.stop();
            this.line.close();
        }
        if (this.output != null) {
            try {
                this.output.flush();
                this.output.close();
            }
            catch (IOException e) {
                exception = e;
            }
        }
        return exception;
    }

    private AudioValues createValues(byte[] data, int num) {
        AudioValues values = new AudioValues();
        values.level = AudioUtils.calculateLevel(data, num);
        values.time = this.line.getMicrosecondPosition() / 1000L;
        if (this.start < 0L) {
            this.start = System.currentTimeMillis();
        }
        values.duration = System.currentTimeMillis() - this.start;
        return values;
    }

    public void jumpTo(double rate) {
    }
}

