/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.ideafactory;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.graphics.AlphaGraphics;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;
import org.xmind.ui.resources.FontUtils;

public class IdeaBaseFigure
extends Figure {
    public static Object PRESELECTED = "PRESELECTED";
    public static Object SELECTED = "SELECTED";
    public static Object PRESSED = "PRESSED";
    public static Object CONTENT = "CONTENT";
    private double alpha = 255.0;
    private LayeredPane pane = new LayeredPane();

    public IdeaBaseFigure(String ideaContent) {
        this();
        this.setText(ideaContent);
    }

    public IdeaBaseFigure() {
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.setOpaque(false);
        this.add((IFigure)this.pane);
        this.addLayers();
        this.setCursor(Display.getCurrent().getSystemCursor(21));
    }

    protected void addLayers() {
        this.addContentLayer();
        this.addFeedbackLayers();
    }

    protected void addFeedbackLayers() {
        this.addSelectFeedbackLayer();
        this.addPressFeedbackLayer();
        this.addPreselectFeedbackLayer();
    }

    protected void addPreselectFeedbackLayer() {
        this.pane.add((IFigure)new PreselectFeedbackLayer(), PRESELECTED, -1);
    }

    protected void addPressFeedbackLayer() {
        this.pane.add((IFigure)new PressFeedbackLayer(), PRESSED, -1);
    }

    protected void addSelectFeedbackLayer() {
        this.pane.add((IFigure)new SelectFeedbackLayer(), SELECTED, -1);
    }

    protected void addContentLayer() {
        this.pane.add((IFigure)new IdeaFigure(), CONTENT, -1);
    }

    public void setContentLayer(IFigure content) {
        this.removeOldContent();
        this.pane.add(content, CONTENT, -1);
    }

    private void removeOldContent() {
        Layer content = this.pane.getLayer(CONTENT);
        if (content != null) {
            this.pane.remove((IFigure)content);
        }
    }

    public void setContentLayerAfter(Layer content, Object after) {
        this.removeOldContent();
        this.pane.addLayerAfter(content, CONTENT, after);
    }

    public void setContentLayerBefore(Layer content, Object before) {
        this.removeOldContent();
        this.pane.addLayerBefore(content, CONTENT, before);
    }

    public IFigure getContent() {
        return this.pane.getLayer(CONTENT);
    }

    public String getText() {
        IFigure content = this.getContent();
        if (content instanceof IdeaFigure) {
            return ((IdeaFigure)content).getText();
        }
        return null;
    }

    public void setText(String text) {
        IFigure content = this.getContent();
        if (content instanceof IdeaFigure) {
            ((IdeaFigure)content).setText(text);
        }
    }

    public void setTextAlpha(int alpha) {
        IFigure content = this.getContent();
        if (content instanceof IdeaFigure) {
            ((IdeaFigure)content).setAlpha(alpha);
        }
    }

    public void paint(Graphics graphics) {
        AlphaGraphics g = new AlphaGraphics(graphics);
        g.setMainAlpha((int)this.alpha);
        g.setAntialias(1);
        super.paint((Graphics)g);
        g.dispose();
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
        this.repaint();
    }

    public double getAlpha() {
        return this.alpha;
    }

    public boolean isPreselected() {
        Layer layer = this.pane.getLayer(PRESELECTED);
        return layer != null && layer.isVisible();
    }

    public void setPreselected(boolean value) {
        Layer layer = this.pane.getLayer(PRESELECTED);
        if (layer != null) {
            layer.setVisible(value);
        }
    }

    public boolean isSelected() {
        Layer layer = this.pane.getLayer(SELECTED);
        return layer != null && layer.isVisible();
    }

    public void setSelected(boolean value) {
        Layer layer = this.pane.getLayer(SELECTED);
        if (layer != null) {
            layer.setVisible(value);
        }
    }

    public boolean isPressed() {
        Layer layer = this.pane.getLayer(PRESSED);
        return layer != null && layer.isVisible();
    }

    public void setPressed(boolean value) {
        Layer layer = this.pane.getLayer(PRESSED);
        if (layer != null) {
            layer.setVisible(value);
        }
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        int h;
        Object constraint;
        LayoutManager layout;
        Dimension psize = super.getPreferredSize(wHint, hHint);
        if (this.getParent() != null && (layout = this.getParent().getLayoutManager()) != null && (constraint = layout.getConstraint((IFigure)this)) instanceof GridData && (h = ((GridData)constraint).horizontalSpan) > 1) {
            psize = psize.getCopy();
            psize.width /= h;
        }
        return psize;
    }

    private static class IdeaFigure
    extends Layer {
        private int alpha = 255;
        private String text;
        private Dimension computedSize;

        public IdeaFigure() {
            this.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)1));
            this.setBorder((Border)new MarginBorder(5, 7, 5, 7));
        }

        public void setAlpha(int alpha) {
            this.alpha = alpha;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
            this.repaint();
        }

        public Dimension getPreferredSize(int wHint, int hHint) {
            if (this.computedSize == null) {
                this.computeSize(wHint, hHint);
            }
            return this.computedSize;
        }

        private void computeSize(int wHint, int hHint) {
            this.computedSize = GraphicsUtils.getAdvanced().getTextSize(this.text == null || "".equals(this.text) ? "..." : this.text, this.getFont()).expand(10, 8);
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            graphics.setAntialias(1);
            graphics.setTextAntialias(1);
            Rectangle rect = this.getBounds().getCopy();
            float corner = Math.min(rect.width, rect.height) * 7 / 30;
            graphics.setAlpha(this.alpha);
            graphics.setLineStyle(1);
            org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
            shape.addRoundedRectangle((float)rect.x, (float)rect.y, (float)(rect.width - 1), (float)(rect.height - 1), corner);
            graphics.fillPath((Path)shape);
            graphics.drawPath((Path)shape);
            shape.dispose();
            graphics.setForegroundColor(ColorConstants.black);
            graphics.setLineStyle(1);
            graphics.setLineWidth(2);
            graphics.setFillRule(2);
            graphics.setFont(this.getFont());
            Dimension textSize = GraphicsUtils.getAdvanced().getTextSize(this.text, this.getFont());
            Rectangle b = this.getBounds();
            graphics.drawText(this.text, b.x + (b.width - textSize.width) / 2, b.y + (b.height - textSize.height) / 2);
        }
    }

    private class PreselectFeedbackLayer
    extends Layer {
        public PreselectFeedbackLayer() {
            this.setVisible(false);
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            graphics.setAlpha(128);
            graphics.setForegroundColor(Display.getCurrent().getSystemColor(16));
            graphics.setBackgroundColor(Display.getCurrent().getSystemColor(1));
            Rectangle b = this.getBounds();
            Rectangle box = b.getResized(-1, -1).expand(-1, -1);
            graphics.fillRectangle(box);
            graphics.drawRectangle(box);
        }
    }

    private class PressFeedbackLayer
    extends Layer {
        public PressFeedbackLayer() {
            this.setVisible(false);
        }

        protected void paintFigure(Graphics graphics) {
            Rectangle b;
            super.paintFigure(graphics);
            Rectangle box = b = this.getBounds();
            graphics.setAlpha(128);
            graphics.setForegroundColor(Display.getCurrent().getSystemColor(16));
            graphics.setBackgroundColor(Display.getCurrent().getSystemColor(2));
            graphics.setLineStyle(1);
            graphics.setLineWidth(5);
            graphics.setFillRule(2);
            graphics.fillRectangle(box);
            graphics.drawRectangle(box);
        }
    }

    private class SelectFeedbackLayer
    extends Layer {
        public SelectFeedbackLayer() {
            this.setVisible(false);
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            Rectangle b = this.getBounds();
            Rectangle box = b.getResized(-1, -1).expand(-1, -1);
            graphics.setAlpha(255);
            graphics.setForegroundColor(Display.getCurrent().getSystemColor(15));
            graphics.setBackgroundColor(Display.getCurrent().getSystemColor(26));
            graphics.fillRectangle(box);
            graphics.drawRectangle(box);
        }
    }
}

