/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.share.dialog;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.xmind.gef.draw2d.RotatableWrapLabel;

public class TitleInfoField {
    private Label label;
    private boolean grabVerticalSpace;
    private boolean readOnly;
    private boolean singleLine;
    private RotatableWrapLabel text;
    private FigureCanvas canvas;

    public TitleInfoField(boolean grabVerticalSpace, boolean readOnly, boolean singleLine) {
        this.grabVerticalSpace = grabVerticalSpace;
        this.readOnly = readOnly;
        this.singleLine = singleLine;
    }

    public void fill(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, this.grabVerticalSpace));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 3;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.label = new Label(composite, 0);
        this.label.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createTitleLabel(composite);
    }

    private void createTitleLabel(Composite parent) {
        this.canvas = new FigureCanvas(parent, 2048);
        this.canvas.setEnabled(true);
        this.canvas.setVisible(true);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        GridData textData = new GridData(4, 4, true, this.grabVerticalSpace);
        if (this.grabVerticalSpace) {
            textData.heightHint = 100;
        }
        this.canvas.setLayoutData((Object)textData);
        this.text = new RotatableWrapLabel(this.getTextStyle());
        this.text.setSingleLine(true);
        this.text.setAbbreviated(true);
        this.text.setEnabled(true);
        this.text.setRequestFocusEnabled(true);
        this.canvas.setContents((IFigure)this.text);
    }

    private int getTextStyle() {
        int style = 0x800 | (this.singleLine ? 4 : 2);
        if (this.readOnly) {
            style |= 8;
        }
        return style;
    }

    public void setName(String name) {
        this.label.setText(name == null ? "" : name);
    }

    public void setText(String text) {
        this.text.setText(text == null ? "" : text);
    }

    public String getName() {
        if (this.label == null || this.label.isDisposed()) {
            return "";
        }
        return this.label.getText();
    }

    public String getText() {
        if (this.text == null) {
            return "";
        }
        return this.text.getText();
    }

    public Label getNameWidget() {
        return this.label;
    }

    public RotatableWrapLabel getTextWidget() {
        return this.text;
    }

    public boolean isDisposed() {
        return this.text != null || this.label.isDisposed();
    }

    public void setFocus() {
        this.text.requestFocus();
    }

    public RotatableWrapLabel getTitleLabel() {
        return this.text;
    }

    public FigureCanvas getCanvas() {
        return this.canvas;
    }
}

