// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/visionai/v1alpha1/annotations.proto

package visionai

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum describing all possible types of a stream annotation.
type StreamAnnotationType int32

const (
	// Type UNSPECIFIED.
	StreamAnnotationType_STREAM_ANNOTATION_TYPE_UNSPECIFIED StreamAnnotationType = 0
	// active_zone annotation defines a polygon on top of the content from an
	// image/video based stream, following processing will only focus on the
	// content inside the active zone.
	StreamAnnotationType_STREAM_ANNOTATION_TYPE_ACTIVE_ZONE StreamAnnotationType = 1
	// crossing_line annotation defines a polyline on top of the content from an
	// image/video based Vision AI stream, events happening across the line will
	// be captured. For example, the counts of people who goes acroos the line
	// in Occupancy Analytic Processor.
	StreamAnnotationType_STREAM_ANNOTATION_TYPE_CROSSING_LINE StreamAnnotationType = 2
)

// Enum value maps for StreamAnnotationType.
var (
	StreamAnnotationType_name = map[int32]string{
		0: "STREAM_ANNOTATION_TYPE_UNSPECIFIED",
		1: "STREAM_ANNOTATION_TYPE_ACTIVE_ZONE",
		2: "STREAM_ANNOTATION_TYPE_CROSSING_LINE",
	}
	StreamAnnotationType_value = map[string]int32{
		"STREAM_ANNOTATION_TYPE_UNSPECIFIED":   0,
		"STREAM_ANNOTATION_TYPE_ACTIVE_ZONE":   1,
		"STREAM_ANNOTATION_TYPE_CROSSING_LINE": 2,
	}
)

func (x StreamAnnotationType) Enum() *StreamAnnotationType {
	p := new(StreamAnnotationType)
	*p = x
	return p
}

func (x StreamAnnotationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StreamAnnotationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_enumTypes[0].Descriptor()
}

func (StreamAnnotationType) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1alpha1_annotations_proto_enumTypes[0]
}

func (x StreamAnnotationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StreamAnnotationType.Descriptor instead.
func (StreamAnnotationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{0}
}

// Output format for Personal Protective Equipment Detection Operator.
type PersonalProtectiveEquipmentDetectionOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Current timestamp.
	CurrentTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=current_time,json=currentTime,proto3" json:"current_time,omitempty"`
	// A list of DetectedPersons.
	DetectedPersons []*PersonalProtectiveEquipmentDetectionOutput_DetectedPerson `protobuf:"bytes,2,rep,name=detected_persons,json=detectedPersons,proto3" json:"detected_persons,omitempty"`
}

func (x *PersonalProtectiveEquipmentDetectionOutput) Reset() {
	*x = PersonalProtectiveEquipmentDetectionOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PersonalProtectiveEquipmentDetectionOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersonalProtectiveEquipmentDetectionOutput) ProtoMessage() {}

func (x *PersonalProtectiveEquipmentDetectionOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersonalProtectiveEquipmentDetectionOutput.ProtoReflect.Descriptor instead.
func (*PersonalProtectiveEquipmentDetectionOutput) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{0}
}

func (x *PersonalProtectiveEquipmentDetectionOutput) GetCurrentTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CurrentTime
	}
	return nil
}

func (x *PersonalProtectiveEquipmentDetectionOutput) GetDetectedPersons() []*PersonalProtectiveEquipmentDetectionOutput_DetectedPerson {
	if x != nil {
		return x.DetectedPersons
	}
	return nil
}

// Prediction output format for Generic Object Detection.
type ObjectDetectionPredictionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Current timestamp.
	CurrentTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=current_time,json=currentTime,proto3" json:"current_time,omitempty"`
	// A list of identified boxes.
	IdentifiedBoxes []*ObjectDetectionPredictionResult_IdentifiedBox `protobuf:"bytes,2,rep,name=identified_boxes,json=identifiedBoxes,proto3" json:"identified_boxes,omitempty"`
}

func (x *ObjectDetectionPredictionResult) Reset() {
	*x = ObjectDetectionPredictionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectDetectionPredictionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectDetectionPredictionResult) ProtoMessage() {}

func (x *ObjectDetectionPredictionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectDetectionPredictionResult.ProtoReflect.Descriptor instead.
func (*ObjectDetectionPredictionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{1}
}

func (x *ObjectDetectionPredictionResult) GetCurrentTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CurrentTime
	}
	return nil
}

func (x *ObjectDetectionPredictionResult) GetIdentifiedBoxes() []*ObjectDetectionPredictionResult_IdentifiedBox {
	if x != nil {
		return x.IdentifiedBoxes
	}
	return nil
}

// Prediction output format for Image Object Detection.
type ImageObjectDetectionPredictionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource IDs of the AnnotationSpecs that had been identified, ordered
	// by the confidence score descendingly. It is the id segment instead of full
	// resource name.
	Ids []int64 `protobuf:"varint,1,rep,packed,name=ids,proto3" json:"ids,omitempty"`
	// The display names of the AnnotationSpecs that had been identified, order
	// matches the IDs.
	DisplayNames []string `protobuf:"bytes,2,rep,name=display_names,json=displayNames,proto3" json:"display_names,omitempty"`
	// The Model's confidences in correctness of the predicted IDs, higher value
	// means higher confidence. Order matches the Ids.
	Confidences []float32 `protobuf:"fixed32,3,rep,packed,name=confidences,proto3" json:"confidences,omitempty"`
	// Bounding boxes, i.e. the rectangles over the image, that pinpoint
	// the found AnnotationSpecs. Given in order that matches the IDs. Each
	// bounding box is an array of 4 numbers `xMin`, `xMax`, `yMin`, and
	// `yMax`, which represent the extremal coordinates of the box. They are
	// relative to the image size, and the point 0,0 is in the top left
	// of the image.
	Bboxes []*structpb.ListValue `protobuf:"bytes,4,rep,name=bboxes,proto3" json:"bboxes,omitempty"`
}

func (x *ImageObjectDetectionPredictionResult) Reset() {
	*x = ImageObjectDetectionPredictionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageObjectDetectionPredictionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageObjectDetectionPredictionResult) ProtoMessage() {}

func (x *ImageObjectDetectionPredictionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageObjectDetectionPredictionResult.ProtoReflect.Descriptor instead.
func (*ImageObjectDetectionPredictionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{2}
}

func (x *ImageObjectDetectionPredictionResult) GetIds() []int64 {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *ImageObjectDetectionPredictionResult) GetDisplayNames() []string {
	if x != nil {
		return x.DisplayNames
	}
	return nil
}

func (x *ImageObjectDetectionPredictionResult) GetConfidences() []float32 {
	if x != nil {
		return x.Confidences
	}
	return nil
}

func (x *ImageObjectDetectionPredictionResult) GetBboxes() []*structpb.ListValue {
	if x != nil {
		return x.Bboxes
	}
	return nil
}

// Prediction output format for Image and Text Classification.
type ClassificationPredictionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource IDs of the AnnotationSpecs that had been identified.
	Ids []int64 `protobuf:"varint,1,rep,packed,name=ids,proto3" json:"ids,omitempty"`
	// The display names of the AnnotationSpecs that had been identified, order
	// matches the IDs.
	DisplayNames []string `protobuf:"bytes,2,rep,name=display_names,json=displayNames,proto3" json:"display_names,omitempty"`
	// The Model's confidences in correctness of the predicted IDs, higher value
	// means higher confidence. Order matches the Ids.
	Confidences []float32 `protobuf:"fixed32,3,rep,packed,name=confidences,proto3" json:"confidences,omitempty"`
}

func (x *ClassificationPredictionResult) Reset() {
	*x = ClassificationPredictionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClassificationPredictionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClassificationPredictionResult) ProtoMessage() {}

func (x *ClassificationPredictionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClassificationPredictionResult.ProtoReflect.Descriptor instead.
func (*ClassificationPredictionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{3}
}

func (x *ClassificationPredictionResult) GetIds() []int64 {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *ClassificationPredictionResult) GetDisplayNames() []string {
	if x != nil {
		return x.DisplayNames
	}
	return nil
}

func (x *ClassificationPredictionResult) GetConfidences() []float32 {
	if x != nil {
		return x.Confidences
	}
	return nil
}

// Prediction output format for Image Segmentation.
type ImageSegmentationPredictionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A PNG image where each pixel in the mask represents the category in which
	// the pixel in the original image was predicted to belong to. The size of
	// this image will be the same as the original image. The mapping between the
	// AnntoationSpec and the color can be found in model's metadata. The model
	// will choose the most likely category and if none of the categories reach
	// the confidence threshold, the pixel will be marked as background.
	CategoryMask string `protobuf:"bytes,1,opt,name=category_mask,json=categoryMask,proto3" json:"category_mask,omitempty"`
	// A one channel image which is encoded as an 8bit lossless PNG. The size of
	// the image will be the same as the original image. For a specific pixel,
	// darker color means less confidence in correctness of the cateogry in the
	// categoryMask for the corresponding pixel. Black means no confidence and
	// white means complete confidence.
	ConfidenceMask string `protobuf:"bytes,2,opt,name=confidence_mask,json=confidenceMask,proto3" json:"confidence_mask,omitempty"`
}

func (x *ImageSegmentationPredictionResult) Reset() {
	*x = ImageSegmentationPredictionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageSegmentationPredictionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageSegmentationPredictionResult) ProtoMessage() {}

func (x *ImageSegmentationPredictionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageSegmentationPredictionResult.ProtoReflect.Descriptor instead.
func (*ImageSegmentationPredictionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{4}
}

func (x *ImageSegmentationPredictionResult) GetCategoryMask() string {
	if x != nil {
		return x.CategoryMask
	}
	return ""
}

func (x *ImageSegmentationPredictionResult) GetConfidenceMask() string {
	if x != nil {
		return x.ConfidenceMask
	}
	return ""
}

// Prediction output format for Video Action Recognition.
type VideoActionRecognitionPredictionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The beginning, inclusive, of the video's time segment in which the
	// actions have been identified.
	SegmentStartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=segment_start_time,json=segmentStartTime,proto3" json:"segment_start_time,omitempty"`
	// The end, inclusive, of the video's time segment in which the actions have
	// been identified. Particularly, if the end is the same as the start, it
	// means the identification happens on a specific video frame.
	SegmentEndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=segment_end_time,json=segmentEndTime,proto3" json:"segment_end_time,omitempty"`
	// All of the actions identified in the time range.
	Actions []*VideoActionRecognitionPredictionResult_IdentifiedAction `protobuf:"bytes,3,rep,name=actions,proto3" json:"actions,omitempty"`
}

func (x *VideoActionRecognitionPredictionResult) Reset() {
	*x = VideoActionRecognitionPredictionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoActionRecognitionPredictionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoActionRecognitionPredictionResult) ProtoMessage() {}

func (x *VideoActionRecognitionPredictionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoActionRecognitionPredictionResult.ProtoReflect.Descriptor instead.
func (*VideoActionRecognitionPredictionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{5}
}

func (x *VideoActionRecognitionPredictionResult) GetSegmentStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SegmentStartTime
	}
	return nil
}

func (x *VideoActionRecognitionPredictionResult) GetSegmentEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SegmentEndTime
	}
	return nil
}

func (x *VideoActionRecognitionPredictionResult) GetActions() []*VideoActionRecognitionPredictionResult_IdentifiedAction {
	if x != nil {
		return x.Actions
	}
	return nil
}

// Prediction output format for Video Object Tracking.
type VideoObjectTrackingPredictionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The beginning, inclusive, of the video's time segment in which the
	// current identifications happens.
	SegmentStartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=segment_start_time,json=segmentStartTime,proto3" json:"segment_start_time,omitempty"`
	// The end, inclusive, of the video's time segment in which the current
	// identifications happen. Particularly, if the end is the same as the start,
	// it means the identifications happen on a specific video frame.
	SegmentEndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=segment_end_time,json=segmentEndTime,proto3" json:"segment_end_time,omitempty"`
	// All of the objects detected in the specified time range.
	Objects []*VideoObjectTrackingPredictionResult_DetectedObject `protobuf:"bytes,3,rep,name=objects,proto3" json:"objects,omitempty"`
}

func (x *VideoObjectTrackingPredictionResult) Reset() {
	*x = VideoObjectTrackingPredictionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoObjectTrackingPredictionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoObjectTrackingPredictionResult) ProtoMessage() {}

func (x *VideoObjectTrackingPredictionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoObjectTrackingPredictionResult.ProtoReflect.Descriptor instead.
func (*VideoObjectTrackingPredictionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{6}
}

func (x *VideoObjectTrackingPredictionResult) GetSegmentStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SegmentStartTime
	}
	return nil
}

func (x *VideoObjectTrackingPredictionResult) GetSegmentEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SegmentEndTime
	}
	return nil
}

func (x *VideoObjectTrackingPredictionResult) GetObjects() []*VideoObjectTrackingPredictionResult_DetectedObject {
	if x != nil {
		return x.Objects
	}
	return nil
}

// Prediction output format for Video Classification.
type VideoClassificationPredictionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The beginning, inclusive, of the video's time segment in which the
	// classifications have been identified.
	SegmentStartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=segment_start_time,json=segmentStartTime,proto3" json:"segment_start_time,omitempty"`
	// The end, inclusive, of the video's time segment in which the
	// classifications have been identified. Particularly, if the end is the same
	// as the start, it means the identification happens on a specific video
	// frame.
	SegmentEndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=segment_end_time,json=segmentEndTime,proto3" json:"segment_end_time,omitempty"`
	// All of the classifications identified in the time range.
	Classifications []*VideoClassificationPredictionResult_IdentifiedClassification `protobuf:"bytes,3,rep,name=classifications,proto3" json:"classifications,omitempty"`
}

func (x *VideoClassificationPredictionResult) Reset() {
	*x = VideoClassificationPredictionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoClassificationPredictionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoClassificationPredictionResult) ProtoMessage() {}

func (x *VideoClassificationPredictionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoClassificationPredictionResult.ProtoReflect.Descriptor instead.
func (*VideoClassificationPredictionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{7}
}

func (x *VideoClassificationPredictionResult) GetSegmentStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SegmentStartTime
	}
	return nil
}

func (x *VideoClassificationPredictionResult) GetSegmentEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SegmentEndTime
	}
	return nil
}

func (x *VideoClassificationPredictionResult) GetClassifications() []*VideoClassificationPredictionResult_IdentifiedClassification {
	if x != nil {
		return x.Classifications
	}
	return nil
}

// The prediction result proto for occupancy counting.
type OccupancyCountingPredictionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Current timestamp.
	CurrentTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=current_time,json=currentTime,proto3" json:"current_time,omitempty"`
	// A list of identified boxes.
	IdentifiedBoxes []*OccupancyCountingPredictionResult_IdentifiedBox `protobuf:"bytes,2,rep,name=identified_boxes,json=identifiedBoxes,proto3" json:"identified_boxes,omitempty"`
	// Detection statistics.
	Stats *OccupancyCountingPredictionResult_Stats `protobuf:"bytes,3,opt,name=stats,proto3" json:"stats,omitempty"`
	// Track related information. All the tracks that are live at this timestamp.
	// It only exists if tracking is enabled.
	TrackInfo []*OccupancyCountingPredictionResult_TrackInfo `protobuf:"bytes,4,rep,name=track_info,json=trackInfo,proto3" json:"track_info,omitempty"`
	// Dwell time related information. All the tracks that are live in a given
	// zone with a start and end dwell time timestamp
	DwellTimeInfo []*OccupancyCountingPredictionResult_DwellTimeInfo `protobuf:"bytes,5,rep,name=dwell_time_info,json=dwellTimeInfo,proto3" json:"dwell_time_info,omitempty"`
}

func (x *OccupancyCountingPredictionResult) Reset() {
	*x = OccupancyCountingPredictionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OccupancyCountingPredictionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OccupancyCountingPredictionResult) ProtoMessage() {}

func (x *OccupancyCountingPredictionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OccupancyCountingPredictionResult.ProtoReflect.Descriptor instead.
func (*OccupancyCountingPredictionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{8}
}

func (x *OccupancyCountingPredictionResult) GetCurrentTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CurrentTime
	}
	return nil
}

func (x *OccupancyCountingPredictionResult) GetIdentifiedBoxes() []*OccupancyCountingPredictionResult_IdentifiedBox {
	if x != nil {
		return x.IdentifiedBoxes
	}
	return nil
}

func (x *OccupancyCountingPredictionResult) GetStats() *OccupancyCountingPredictionResult_Stats {
	if x != nil {
		return x.Stats
	}
	return nil
}

func (x *OccupancyCountingPredictionResult) GetTrackInfo() []*OccupancyCountingPredictionResult_TrackInfo {
	if x != nil {
		return x.TrackInfo
	}
	return nil
}

func (x *OccupancyCountingPredictionResult) GetDwellTimeInfo() []*OccupancyCountingPredictionResult_DwellTimeInfo {
	if x != nil {
		return x.DwellTimeInfo
	}
	return nil
}

// message about annotations about Vision AI stream resource.
type StreamAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to AnnotationPayload:
	//
	//	*StreamAnnotation_ActiveZone
	//	*StreamAnnotation_CrossingLine
	AnnotationPayload isStreamAnnotation_AnnotationPayload `protobuf_oneof:"annotation_payload"`
	// ID of the annotation. It must be unique when used in the certain context.
	// For example, all the annotations to one input streams of a Vision AI
	// application.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// User-friendly name for the annotation.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The Vision AI stream resource name.
	SourceStream string `protobuf:"bytes,3,opt,name=source_stream,json=sourceStream,proto3" json:"source_stream,omitempty"`
	// The actual type of Annotation.
	Type StreamAnnotationType `protobuf:"varint,4,opt,name=type,proto3,enum=google.cloud.visionai.v1alpha1.StreamAnnotationType" json:"type,omitempty"`
}

func (x *StreamAnnotation) Reset() {
	*x = StreamAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamAnnotation) ProtoMessage() {}

func (x *StreamAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamAnnotation.ProtoReflect.Descriptor instead.
func (*StreamAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{9}
}

func (m *StreamAnnotation) GetAnnotationPayload() isStreamAnnotation_AnnotationPayload {
	if m != nil {
		return m.AnnotationPayload
	}
	return nil
}

func (x *StreamAnnotation) GetActiveZone() *NormalizedPolygon {
	if x, ok := x.GetAnnotationPayload().(*StreamAnnotation_ActiveZone); ok {
		return x.ActiveZone
	}
	return nil
}

func (x *StreamAnnotation) GetCrossingLine() *NormalizedPolyline {
	if x, ok := x.GetAnnotationPayload().(*StreamAnnotation_CrossingLine); ok {
		return x.CrossingLine
	}
	return nil
}

func (x *StreamAnnotation) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *StreamAnnotation) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *StreamAnnotation) GetSourceStream() string {
	if x != nil {
		return x.SourceStream
	}
	return ""
}

func (x *StreamAnnotation) GetType() StreamAnnotationType {
	if x != nil {
		return x.Type
	}
	return StreamAnnotationType_STREAM_ANNOTATION_TYPE_UNSPECIFIED
}

type isStreamAnnotation_AnnotationPayload interface {
	isStreamAnnotation_AnnotationPayload()
}

type StreamAnnotation_ActiveZone struct {
	// Annotation for type ACTIVE_ZONE
	ActiveZone *NormalizedPolygon `protobuf:"bytes,5,opt,name=active_zone,json=activeZone,proto3,oneof"`
}

type StreamAnnotation_CrossingLine struct {
	// Annotation for type CROSSING_LINE
	CrossingLine *NormalizedPolyline `protobuf:"bytes,6,opt,name=crossing_line,json=crossingLine,proto3,oneof"`
}

func (*StreamAnnotation_ActiveZone) isStreamAnnotation_AnnotationPayload() {}

func (*StreamAnnotation_CrossingLine) isStreamAnnotation_AnnotationPayload() {}

// A wrapper of repeated StreamAnnotation.
type StreamAnnotations struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Multiple annotations.
	StreamAnnotations []*StreamAnnotation `protobuf:"bytes,1,rep,name=stream_annotations,json=streamAnnotations,proto3" json:"stream_annotations,omitempty"`
}

func (x *StreamAnnotations) Reset() {
	*x = StreamAnnotations{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamAnnotations) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamAnnotations) ProtoMessage() {}

func (x *StreamAnnotations) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamAnnotations.ProtoReflect.Descriptor instead.
func (*StreamAnnotations) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{10}
}

func (x *StreamAnnotations) GetStreamAnnotations() []*StreamAnnotation {
	if x != nil {
		return x.StreamAnnotations
	}
	return nil
}

// Normalized Polygon.
type NormalizedPolygon struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The bounding polygon normalized vertices. Top left corner of the image
	// will be [0, 0].
	NormalizedVertices []*NormalizedVertex `protobuf:"bytes,1,rep,name=normalized_vertices,json=normalizedVertices,proto3" json:"normalized_vertices,omitempty"`
}

func (x *NormalizedPolygon) Reset() {
	*x = NormalizedPolygon{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NormalizedPolygon) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NormalizedPolygon) ProtoMessage() {}

func (x *NormalizedPolygon) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NormalizedPolygon.ProtoReflect.Descriptor instead.
func (*NormalizedPolygon) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{11}
}

func (x *NormalizedPolygon) GetNormalizedVertices() []*NormalizedVertex {
	if x != nil {
		return x.NormalizedVertices
	}
	return nil
}

// Normalized Pplyline, which represents a curve consisting of connected
// straight-line segments.
type NormalizedPolyline struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A sequence of vertices connected by straight lines.
	NormalizedVertices []*NormalizedVertex `protobuf:"bytes,1,rep,name=normalized_vertices,json=normalizedVertices,proto3" json:"normalized_vertices,omitempty"`
}

func (x *NormalizedPolyline) Reset() {
	*x = NormalizedPolyline{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NormalizedPolyline) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NormalizedPolyline) ProtoMessage() {}

func (x *NormalizedPolyline) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NormalizedPolyline.ProtoReflect.Descriptor instead.
func (*NormalizedPolyline) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{12}
}

func (x *NormalizedPolyline) GetNormalizedVertices() []*NormalizedVertex {
	if x != nil {
		return x.NormalizedVertices
	}
	return nil
}

// A vertex represents a 2D point in the image.
// NOTE: the normalized vertex coordinates are relative to the original image
// and range from 0 to 1.
type NormalizedVertex struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// X coordinate.
	X float32 `protobuf:"fixed32,1,opt,name=x,proto3" json:"x,omitempty"`
	// Y coordinate.
	Y float32 `protobuf:"fixed32,2,opt,name=y,proto3" json:"y,omitempty"`
}

func (x *NormalizedVertex) Reset() {
	*x = NormalizedVertex{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NormalizedVertex) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NormalizedVertex) ProtoMessage() {}

func (x *NormalizedVertex) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NormalizedVertex.ProtoReflect.Descriptor instead.
func (*NormalizedVertex) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{13}
}

func (x *NormalizedVertex) GetX() float32 {
	if x != nil {
		return x.X
	}
	return 0
}

func (x *NormalizedVertex) GetY() float32 {
	if x != nil {
		return x.Y
	}
	return 0
}

// Message of essential metadata of App Platform.
// This message is usually attached to a certain processor output annotation for
// customer to identify the source of the data.
type AppPlatformMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The application resource name.
	Application string `protobuf:"bytes,1,opt,name=application,proto3" json:"application,omitempty"`
	// The instance resource id. Instance is the nested resource of application
	// under collection 'instances'.
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// The node name of the application graph.
	Node string `protobuf:"bytes,3,opt,name=node,proto3" json:"node,omitempty"`
	// The referred processor resource name of the application node.
	Processor string `protobuf:"bytes,4,opt,name=processor,proto3" json:"processor,omitempty"`
}

func (x *AppPlatformMetadata) Reset() {
	*x = AppPlatformMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppPlatformMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppPlatformMetadata) ProtoMessage() {}

func (x *AppPlatformMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppPlatformMetadata.ProtoReflect.Descriptor instead.
func (*AppPlatformMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{14}
}

func (x *AppPlatformMetadata) GetApplication() string {
	if x != nil {
		return x.Application
	}
	return ""
}

func (x *AppPlatformMetadata) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *AppPlatformMetadata) GetNode() string {
	if x != nil {
		return x.Node
	}
	return ""
}

func (x *AppPlatformMetadata) GetProcessor() string {
	if x != nil {
		return x.Processor
	}
	return ""
}

// For any cloud function based customer processing logic, customer's cloud
// function is expected to receive AppPlatformCloudFunctionRequest as request
// and send back AppPlatformCloudFunctionResponse as response.
// Message of request from AppPlatform to Cloud Function.
type AppPlatformCloudFunctionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The metadata of the AppPlatform for customer to identify the source of the
	// payload.
	AppPlatformMetadata *AppPlatformMetadata `protobuf:"bytes,1,opt,name=app_platform_metadata,json=appPlatformMetadata,proto3" json:"app_platform_metadata,omitempty"`
	// The actual annotations to be processed by the customized Cloud Function.
	Annotations []*AppPlatformCloudFunctionRequest_StructedInputAnnotation `protobuf:"bytes,2,rep,name=annotations,proto3" json:"annotations,omitempty"`
}

func (x *AppPlatformCloudFunctionRequest) Reset() {
	*x = AppPlatformCloudFunctionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppPlatformCloudFunctionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppPlatformCloudFunctionRequest) ProtoMessage() {}

func (x *AppPlatformCloudFunctionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppPlatformCloudFunctionRequest.ProtoReflect.Descriptor instead.
func (*AppPlatformCloudFunctionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{15}
}

func (x *AppPlatformCloudFunctionRequest) GetAppPlatformMetadata() *AppPlatformMetadata {
	if x != nil {
		return x.AppPlatformMetadata
	}
	return nil
}

func (x *AppPlatformCloudFunctionRequest) GetAnnotations() []*AppPlatformCloudFunctionRequest_StructedInputAnnotation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

// Message of the response from customer's Cloud Function to AppPlatform.
type AppPlatformCloudFunctionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The modified annotations that is returned back to AppPlatform.
	// If the annotations fields are empty, then those annotations will be dropped
	// by AppPlatform.
	Annotations []*AppPlatformCloudFunctionResponse_StructedOutputAnnotation `protobuf:"bytes,2,rep,name=annotations,proto3" json:"annotations,omitempty"`
}

func (x *AppPlatformCloudFunctionResponse) Reset() {
	*x = AppPlatformCloudFunctionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppPlatformCloudFunctionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppPlatformCloudFunctionResponse) ProtoMessage() {}

func (x *AppPlatformCloudFunctionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppPlatformCloudFunctionResponse.ProtoReflect.Descriptor instead.
func (*AppPlatformCloudFunctionResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{16}
}

func (x *AppPlatformCloudFunctionResponse) GetAnnotations() []*AppPlatformCloudFunctionResponse_StructedOutputAnnotation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

// The entity info for annotations from person detection prediction result.
type PersonalProtectiveEquipmentDetectionOutput_PersonEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Entity id.
	PersonEntityId int64 `protobuf:"varint,1,opt,name=person_entity_id,json=personEntityId,proto3" json:"person_entity_id,omitempty"`
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PersonEntity) Reset() {
	*x = PersonalProtectiveEquipmentDetectionOutput_PersonEntity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PersonEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersonalProtectiveEquipmentDetectionOutput_PersonEntity) ProtoMessage() {}

func (x *PersonalProtectiveEquipmentDetectionOutput_PersonEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersonalProtectiveEquipmentDetectionOutput_PersonEntity.ProtoReflect.Descriptor instead.
func (*PersonalProtectiveEquipmentDetectionOutput_PersonEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{0, 0}
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PersonEntity) GetPersonEntityId() int64 {
	if x != nil {
		return x.PersonEntityId
	}
	return 0
}

// The entity info for annotations from PPE detection prediction result.
type PersonalProtectiveEquipmentDetectionOutput_PPEEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Label id.
	PpeLabelId int64 `protobuf:"varint,1,opt,name=ppe_label_id,json=ppeLabelId,proto3" json:"ppe_label_id,omitempty"`
	// Human readable string of the label (Examples: helmet, glove, mask).
	PpeLabelString string `protobuf:"bytes,2,opt,name=ppe_label_string,json=ppeLabelString,proto3" json:"ppe_label_string,omitempty"`
	// Human readable string of the super category label (Examples: head_cover,
	// hands_cover, face_cover).
	PpeSupercategoryLabelString string `protobuf:"bytes,3,opt,name=ppe_supercategory_label_string,json=ppeSupercategoryLabelString,proto3" json:"ppe_supercategory_label_string,omitempty"`
	// Entity id.
	PpeEntityId int64 `protobuf:"varint,4,opt,name=ppe_entity_id,json=ppeEntityId,proto3" json:"ppe_entity_id,omitempty"`
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PPEEntity) Reset() {
	*x = PersonalProtectiveEquipmentDetectionOutput_PPEEntity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PPEEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersonalProtectiveEquipmentDetectionOutput_PPEEntity) ProtoMessage() {}

func (x *PersonalProtectiveEquipmentDetectionOutput_PPEEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersonalProtectiveEquipmentDetectionOutput_PPEEntity.ProtoReflect.Descriptor instead.
func (*PersonalProtectiveEquipmentDetectionOutput_PPEEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{0, 1}
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PPEEntity) GetPpeLabelId() int64 {
	if x != nil {
		return x.PpeLabelId
	}
	return 0
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PPEEntity) GetPpeLabelString() string {
	if x != nil {
		return x.PpeLabelString
	}
	return ""
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PPEEntity) GetPpeSupercategoryLabelString() string {
	if x != nil {
		return x.PpeSupercategoryLabelString
	}
	return ""
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PPEEntity) GetPpeEntityId() int64 {
	if x != nil {
		return x.PpeEntityId
	}
	return 0
}

// Bounding Box in the normalized coordinates.
type PersonalProtectiveEquipmentDetectionOutput_NormalizedBoundingBox struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Min in x coordinate.
	Xmin float32 `protobuf:"fixed32,1,opt,name=xmin,proto3" json:"xmin,omitempty"`
	// Min in y coordinate.
	Ymin float32 `protobuf:"fixed32,2,opt,name=ymin,proto3" json:"ymin,omitempty"`
	// Width of the bounding box.
	Width float32 `protobuf:"fixed32,3,opt,name=width,proto3" json:"width,omitempty"`
	// Height of the bounding box.
	Height float32 `protobuf:"fixed32,4,opt,name=height,proto3" json:"height,omitempty"`
}

func (x *PersonalProtectiveEquipmentDetectionOutput_NormalizedBoundingBox) Reset() {
	*x = PersonalProtectiveEquipmentDetectionOutput_NormalizedBoundingBox{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PersonalProtectiveEquipmentDetectionOutput_NormalizedBoundingBox) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersonalProtectiveEquipmentDetectionOutput_NormalizedBoundingBox) ProtoMessage() {}

func (x *PersonalProtectiveEquipmentDetectionOutput_NormalizedBoundingBox) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersonalProtectiveEquipmentDetectionOutput_NormalizedBoundingBox.ProtoReflect.Descriptor instead.
func (*PersonalProtectiveEquipmentDetectionOutput_NormalizedBoundingBox) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{0, 2}
}

func (x *PersonalProtectiveEquipmentDetectionOutput_NormalizedBoundingBox) GetXmin() float32 {
	if x != nil {
		return x.Xmin
	}
	return 0
}

func (x *PersonalProtectiveEquipmentDetectionOutput_NormalizedBoundingBox) GetYmin() float32 {
	if x != nil {
		return x.Ymin
	}
	return 0
}

func (x *PersonalProtectiveEquipmentDetectionOutput_NormalizedBoundingBox) GetWidth() float32 {
	if x != nil {
		return x.Width
	}
	return 0
}

func (x *PersonalProtectiveEquipmentDetectionOutput_NormalizedBoundingBox) GetHeight() float32 {
	if x != nil {
		return x.Height
	}
	return 0
}

// PersonIdentified box contains the location and the entity info of the
// person.
type PersonalProtectiveEquipmentDetectionOutput_PersonIdentifiedBox struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An unique id for this box.
	BoxId int64 `protobuf:"varint,1,opt,name=box_id,json=boxId,proto3" json:"box_id,omitempty"`
	// Bounding Box in the normalized coordinates.
	NormalizedBoundingBox *PersonalProtectiveEquipmentDetectionOutput_NormalizedBoundingBox `protobuf:"bytes,2,opt,name=normalized_bounding_box,json=normalizedBoundingBox,proto3" json:"normalized_bounding_box,omitempty"`
	// Confidence score associated with this box.
	ConfidenceScore float32 `protobuf:"fixed32,3,opt,name=confidence_score,json=confidenceScore,proto3" json:"confidence_score,omitempty"`
	// Person entity info.
	PersonEntity *PersonalProtectiveEquipmentDetectionOutput_PersonEntity `protobuf:"bytes,4,opt,name=person_entity,json=personEntity,proto3" json:"person_entity,omitempty"`
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PersonIdentifiedBox) Reset() {
	*x = PersonalProtectiveEquipmentDetectionOutput_PersonIdentifiedBox{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PersonIdentifiedBox) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersonalProtectiveEquipmentDetectionOutput_PersonIdentifiedBox) ProtoMessage() {}

func (x *PersonalProtectiveEquipmentDetectionOutput_PersonIdentifiedBox) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersonalProtectiveEquipmentDetectionOutput_PersonIdentifiedBox.ProtoReflect.Descriptor instead.
func (*PersonalProtectiveEquipmentDetectionOutput_PersonIdentifiedBox) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{0, 3}
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PersonIdentifiedBox) GetBoxId() int64 {
	if x != nil {
		return x.BoxId
	}
	return 0
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PersonIdentifiedBox) GetNormalizedBoundingBox() *PersonalProtectiveEquipmentDetectionOutput_NormalizedBoundingBox {
	if x != nil {
		return x.NormalizedBoundingBox
	}
	return nil
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PersonIdentifiedBox) GetConfidenceScore() float32 {
	if x != nil {
		return x.ConfidenceScore
	}
	return 0
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PersonIdentifiedBox) GetPersonEntity() *PersonalProtectiveEquipmentDetectionOutput_PersonEntity {
	if x != nil {
		return x.PersonEntity
	}
	return nil
}

// PPEIdentified box contains the location and the entity info of the PPE.
type PersonalProtectiveEquipmentDetectionOutput_PPEIdentifiedBox struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An unique id for this box.
	BoxId int64 `protobuf:"varint,1,opt,name=box_id,json=boxId,proto3" json:"box_id,omitempty"`
	// Bounding Box in the normalized coordinates.
	NormalizedBoundingBox *PersonalProtectiveEquipmentDetectionOutput_NormalizedBoundingBox `protobuf:"bytes,2,opt,name=normalized_bounding_box,json=normalizedBoundingBox,proto3" json:"normalized_bounding_box,omitempty"`
	// Confidence score associated with this box.
	ConfidenceScore float32 `protobuf:"fixed32,3,opt,name=confidence_score,json=confidenceScore,proto3" json:"confidence_score,omitempty"`
	// PPE entity info.
	PpeEntity *PersonalProtectiveEquipmentDetectionOutput_PPEEntity `protobuf:"bytes,4,opt,name=ppe_entity,json=ppeEntity,proto3" json:"ppe_entity,omitempty"`
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PPEIdentifiedBox) Reset() {
	*x = PersonalProtectiveEquipmentDetectionOutput_PPEIdentifiedBox{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PPEIdentifiedBox) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersonalProtectiveEquipmentDetectionOutput_PPEIdentifiedBox) ProtoMessage() {}

func (x *PersonalProtectiveEquipmentDetectionOutput_PPEIdentifiedBox) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersonalProtectiveEquipmentDetectionOutput_PPEIdentifiedBox.ProtoReflect.Descriptor instead.
func (*PersonalProtectiveEquipmentDetectionOutput_PPEIdentifiedBox) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{0, 4}
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PPEIdentifiedBox) GetBoxId() int64 {
	if x != nil {
		return x.BoxId
	}
	return 0
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PPEIdentifiedBox) GetNormalizedBoundingBox() *PersonalProtectiveEquipmentDetectionOutput_NormalizedBoundingBox {
	if x != nil {
		return x.NormalizedBoundingBox
	}
	return nil
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PPEIdentifiedBox) GetConfidenceScore() float32 {
	if x != nil {
		return x.ConfidenceScore
	}
	return 0
}

func (x *PersonalProtectiveEquipmentDetectionOutput_PPEIdentifiedBox) GetPpeEntity() *PersonalProtectiveEquipmentDetectionOutput_PPEEntity {
	if x != nil {
		return x.PpeEntity
	}
	return nil
}

// Detected Person contains the detected person and their associated
// ppes and their protecting information.
type PersonalProtectiveEquipmentDetectionOutput_DetectedPerson struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of detected person.
	PersonId int64 `protobuf:"varint,1,opt,name=person_id,json=personId,proto3" json:"person_id,omitempty"`
	// The info of detected person identified box.
	DetectedPersonIdentifiedBox *PersonalProtectiveEquipmentDetectionOutput_PersonIdentifiedBox `protobuf:"bytes,2,opt,name=detected_person_identified_box,json=detectedPersonIdentifiedBox,proto3" json:"detected_person_identified_box,omitempty"`
	// The info of detected person associated ppe identified boxes.
	DetectedPpeIdentifiedBoxes []*PersonalProtectiveEquipmentDetectionOutput_PPEIdentifiedBox `protobuf:"bytes,3,rep,name=detected_ppe_identified_boxes,json=detectedPpeIdentifiedBoxes,proto3" json:"detected_ppe_identified_boxes,omitempty"`
	// Coverage score for each body part.
	// Coverage score for face.
	FaceCoverageScore *float32 `protobuf:"fixed32,4,opt,name=face_coverage_score,json=faceCoverageScore,proto3,oneof" json:"face_coverage_score,omitempty"`
	// Coverage score for eyes.
	EyesCoverageScore *float32 `protobuf:"fixed32,5,opt,name=eyes_coverage_score,json=eyesCoverageScore,proto3,oneof" json:"eyes_coverage_score,omitempty"`
	// Coverage score for head.
	HeadCoverageScore *float32 `protobuf:"fixed32,6,opt,name=head_coverage_score,json=headCoverageScore,proto3,oneof" json:"head_coverage_score,omitempty"`
	// Coverage score for hands.
	HandsCoverageScore *float32 `protobuf:"fixed32,7,opt,name=hands_coverage_score,json=handsCoverageScore,proto3,oneof" json:"hands_coverage_score,omitempty"`
	// Coverage score for body.
	BodyCoverageScore *float32 `protobuf:"fixed32,8,opt,name=body_coverage_score,json=bodyCoverageScore,proto3,oneof" json:"body_coverage_score,omitempty"`
	// Coverage score for feet.
	FeetCoverageScore *float32 `protobuf:"fixed32,9,opt,name=feet_coverage_score,json=feetCoverageScore,proto3,oneof" json:"feet_coverage_score,omitempty"`
}

func (x *PersonalProtectiveEquipmentDetectionOutput_DetectedPerson) Reset() {
	*x = PersonalProtectiveEquipmentDetectionOutput_DetectedPerson{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PersonalProtectiveEquipmentDetectionOutput_DetectedPerson) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersonalProtectiveEquipmentDetectionOutput_DetectedPerson) ProtoMessage() {}

func (x *PersonalProtectiveEquipmentDetectionOutput_DetectedPerson) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersonalProtectiveEquipmentDetectionOutput_DetectedPerson.ProtoReflect.Descriptor instead.
func (*PersonalProtectiveEquipmentDetectionOutput_DetectedPerson) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{0, 5}
}

func (x *PersonalProtectiveEquipmentDetectionOutput_DetectedPerson) GetPersonId() int64 {
	if x != nil {
		return x.PersonId
	}
	return 0
}

func (x *PersonalProtectiveEquipmentDetectionOutput_DetectedPerson) GetDetectedPersonIdentifiedBox() *PersonalProtectiveEquipmentDetectionOutput_PersonIdentifiedBox {
	if x != nil {
		return x.DetectedPersonIdentifiedBox
	}
	return nil
}

func (x *PersonalProtectiveEquipmentDetectionOutput_DetectedPerson) GetDetectedPpeIdentifiedBoxes() []*PersonalProtectiveEquipmentDetectionOutput_PPEIdentifiedBox {
	if x != nil {
		return x.DetectedPpeIdentifiedBoxes
	}
	return nil
}

func (x *PersonalProtectiveEquipmentDetectionOutput_DetectedPerson) GetFaceCoverageScore() float32 {
	if x != nil && x.FaceCoverageScore != nil {
		return *x.FaceCoverageScore
	}
	return 0
}

func (x *PersonalProtectiveEquipmentDetectionOutput_DetectedPerson) GetEyesCoverageScore() float32 {
	if x != nil && x.EyesCoverageScore != nil {
		return *x.EyesCoverageScore
	}
	return 0
}

func (x *PersonalProtectiveEquipmentDetectionOutput_DetectedPerson) GetHeadCoverageScore() float32 {
	if x != nil && x.HeadCoverageScore != nil {
		return *x.HeadCoverageScore
	}
	return 0
}

func (x *PersonalProtectiveEquipmentDetectionOutput_DetectedPerson) GetHandsCoverageScore() float32 {
	if x != nil && x.HandsCoverageScore != nil {
		return *x.HandsCoverageScore
	}
	return 0
}

func (x *PersonalProtectiveEquipmentDetectionOutput_DetectedPerson) GetBodyCoverageScore() float32 {
	if x != nil && x.BodyCoverageScore != nil {
		return *x.BodyCoverageScore
	}
	return 0
}

func (x *PersonalProtectiveEquipmentDetectionOutput_DetectedPerson) GetFeetCoverageScore() float32 {
	if x != nil && x.FeetCoverageScore != nil {
		return *x.FeetCoverageScore
	}
	return 0
}

// The entity info for annotations from object detection prediction result.
type ObjectDetectionPredictionResult_Entity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Label id.
	LabelId int64 `protobuf:"varint,1,opt,name=label_id,json=labelId,proto3" json:"label_id,omitempty"`
	// Human readable string of the label.
	LabelString string `protobuf:"bytes,2,opt,name=label_string,json=labelString,proto3" json:"label_string,omitempty"`
}

func (x *ObjectDetectionPredictionResult_Entity) Reset() {
	*x = ObjectDetectionPredictionResult_Entity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectDetectionPredictionResult_Entity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectDetectionPredictionResult_Entity) ProtoMessage() {}

func (x *ObjectDetectionPredictionResult_Entity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectDetectionPredictionResult_Entity.ProtoReflect.Descriptor instead.
func (*ObjectDetectionPredictionResult_Entity) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ObjectDetectionPredictionResult_Entity) GetLabelId() int64 {
	if x != nil {
		return x.LabelId
	}
	return 0
}

func (x *ObjectDetectionPredictionResult_Entity) GetLabelString() string {
	if x != nil {
		return x.LabelString
	}
	return ""
}

// Identified box contains location and the entity of the object.
type ObjectDetectionPredictionResult_IdentifiedBox struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An unique id for this box.
	BoxId int64 `protobuf:"varint,1,opt,name=box_id,json=boxId,proto3" json:"box_id,omitempty"`
	// Bounding Box in the normalized coordinates.
	NormalizedBoundingBox *ObjectDetectionPredictionResult_IdentifiedBox_NormalizedBoundingBox `protobuf:"bytes,2,opt,name=normalized_bounding_box,json=normalizedBoundingBox,proto3" json:"normalized_bounding_box,omitempty"`
	// Confidence score associated with this box.
	ConfidenceScore float32 `protobuf:"fixed32,3,opt,name=confidence_score,json=confidenceScore,proto3" json:"confidence_score,omitempty"`
	// Entity of this box.
	Entity *ObjectDetectionPredictionResult_Entity `protobuf:"bytes,4,opt,name=entity,proto3" json:"entity,omitempty"`
}

func (x *ObjectDetectionPredictionResult_IdentifiedBox) Reset() {
	*x = ObjectDetectionPredictionResult_IdentifiedBox{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectDetectionPredictionResult_IdentifiedBox) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectDetectionPredictionResult_IdentifiedBox) ProtoMessage() {}

func (x *ObjectDetectionPredictionResult_IdentifiedBox) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectDetectionPredictionResult_IdentifiedBox.ProtoReflect.Descriptor instead.
func (*ObjectDetectionPredictionResult_IdentifiedBox) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{1, 1}
}

func (x *ObjectDetectionPredictionResult_IdentifiedBox) GetBoxId() int64 {
	if x != nil {
		return x.BoxId
	}
	return 0
}

func (x *ObjectDetectionPredictionResult_IdentifiedBox) GetNormalizedBoundingBox() *ObjectDetectionPredictionResult_IdentifiedBox_NormalizedBoundingBox {
	if x != nil {
		return x.NormalizedBoundingBox
	}
	return nil
}

func (x *ObjectDetectionPredictionResult_IdentifiedBox) GetConfidenceScore() float32 {
	if x != nil {
		return x.ConfidenceScore
	}
	return 0
}

func (x *ObjectDetectionPredictionResult_IdentifiedBox) GetEntity() *ObjectDetectionPredictionResult_Entity {
	if x != nil {
		return x.Entity
	}
	return nil
}

// Bounding Box in the normalized coordinates.
type ObjectDetectionPredictionResult_IdentifiedBox_NormalizedBoundingBox struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Min in x coordinate.
	Xmin float32 `protobuf:"fixed32,1,opt,name=xmin,proto3" json:"xmin,omitempty"`
	// Min in y coordinate.
	Ymin float32 `protobuf:"fixed32,2,opt,name=ymin,proto3" json:"ymin,omitempty"`
	// Width of the bounding box.
	Width float32 `protobuf:"fixed32,3,opt,name=width,proto3" json:"width,omitempty"`
	// Height of the bounding box.
	Height float32 `protobuf:"fixed32,4,opt,name=height,proto3" json:"height,omitempty"`
}

func (x *ObjectDetectionPredictionResult_IdentifiedBox_NormalizedBoundingBox) Reset() {
	*x = ObjectDetectionPredictionResult_IdentifiedBox_NormalizedBoundingBox{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectDetectionPredictionResult_IdentifiedBox_NormalizedBoundingBox) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectDetectionPredictionResult_IdentifiedBox_NormalizedBoundingBox) ProtoMessage() {}

func (x *ObjectDetectionPredictionResult_IdentifiedBox_NormalizedBoundingBox) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectDetectionPredictionResult_IdentifiedBox_NormalizedBoundingBox.ProtoReflect.Descriptor instead.
func (*ObjectDetectionPredictionResult_IdentifiedBox_NormalizedBoundingBox) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{1, 1, 0}
}

func (x *ObjectDetectionPredictionResult_IdentifiedBox_NormalizedBoundingBox) GetXmin() float32 {
	if x != nil {
		return x.Xmin
	}
	return 0
}

func (x *ObjectDetectionPredictionResult_IdentifiedBox_NormalizedBoundingBox) GetYmin() float32 {
	if x != nil {
		return x.Ymin
	}
	return 0
}

func (x *ObjectDetectionPredictionResult_IdentifiedBox_NormalizedBoundingBox) GetWidth() float32 {
	if x != nil {
		return x.Width
	}
	return 0
}

func (x *ObjectDetectionPredictionResult_IdentifiedBox_NormalizedBoundingBox) GetHeight() float32 {
	if x != nil {
		return x.Height
	}
	return 0
}

// Each IdentifiedAction is one particular identification of an action
// specified with the AnnotationSpec id, display_name and the associated
// confidence score.
type VideoActionRecognitionPredictionResult_IdentifiedAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource ID of the AnnotationSpec that had been identified.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The display name of the AnnotationSpec that had been identified.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The Model's confidence in correction of this identification, higher
	// value means higher confidence.
	Confidence float32 `protobuf:"fixed32,3,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *VideoActionRecognitionPredictionResult_IdentifiedAction) Reset() {
	*x = VideoActionRecognitionPredictionResult_IdentifiedAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoActionRecognitionPredictionResult_IdentifiedAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoActionRecognitionPredictionResult_IdentifiedAction) ProtoMessage() {}

func (x *VideoActionRecognitionPredictionResult_IdentifiedAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoActionRecognitionPredictionResult_IdentifiedAction.ProtoReflect.Descriptor instead.
func (*VideoActionRecognitionPredictionResult_IdentifiedAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{5, 0}
}

func (x *VideoActionRecognitionPredictionResult_IdentifiedAction) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *VideoActionRecognitionPredictionResult_IdentifiedAction) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *VideoActionRecognitionPredictionResult_IdentifiedAction) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// Boundingbox for detected object. I.e. the rectangle over the video frame
// pinpointing the found AnnotationSpec. The coordinates are relative to the
// frame size, and the point 0,0 is in the top left of the frame.
type VideoObjectTrackingPredictionResult_BoundingBox struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The leftmost coordinate of the bounding box.
	XMin float32 `protobuf:"fixed32,1,opt,name=x_min,json=xMin,proto3" json:"x_min,omitempty"`
	// The rightmost coordinate of the bounding box.
	XMax float32 `protobuf:"fixed32,2,opt,name=x_max,json=xMax,proto3" json:"x_max,omitempty"`
	// The topmost coordinate of the bounding box.
	YMin float32 `protobuf:"fixed32,3,opt,name=y_min,json=yMin,proto3" json:"y_min,omitempty"`
	// The bottommost coordinate of the bounding box.
	YMax float32 `protobuf:"fixed32,4,opt,name=y_max,json=yMax,proto3" json:"y_max,omitempty"`
}

func (x *VideoObjectTrackingPredictionResult_BoundingBox) Reset() {
	*x = VideoObjectTrackingPredictionResult_BoundingBox{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoObjectTrackingPredictionResult_BoundingBox) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoObjectTrackingPredictionResult_BoundingBox) ProtoMessage() {}

func (x *VideoObjectTrackingPredictionResult_BoundingBox) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoObjectTrackingPredictionResult_BoundingBox.ProtoReflect.Descriptor instead.
func (*VideoObjectTrackingPredictionResult_BoundingBox) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{6, 0}
}

func (x *VideoObjectTrackingPredictionResult_BoundingBox) GetXMin() float32 {
	if x != nil {
		return x.XMin
	}
	return 0
}

func (x *VideoObjectTrackingPredictionResult_BoundingBox) GetXMax() float32 {
	if x != nil {
		return x.XMax
	}
	return 0
}

func (x *VideoObjectTrackingPredictionResult_BoundingBox) GetYMin() float32 {
	if x != nil {
		return x.YMin
	}
	return 0
}

func (x *VideoObjectTrackingPredictionResult_BoundingBox) GetYMax() float32 {
	if x != nil {
		return x.YMax
	}
	return 0
}

// Each DetectedObject is one particular identification of an object
// specified with the AnnotationSpec id and display_name, the bounding box,
// the associated confidence score and the corresponding track_id.
type VideoObjectTrackingPredictionResult_DetectedObject struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource ID of the AnnotationSpec that had been identified.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The display name of the AnnotationSpec that had been identified.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Boundingbox.
	BoundingBox *VideoObjectTrackingPredictionResult_BoundingBox `protobuf:"bytes,3,opt,name=bounding_box,json=boundingBox,proto3" json:"bounding_box,omitempty"`
	// The Model's confidence in correction of this identification, higher
	// value means higher confidence.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// The same object may be identified on muitiple frames which are typical
	// adjacent. The set of frames where a particular object has been detected
	// form a track. This track_id can be used to trace down all frames for an
	// detected object.
	TrackId int64 `protobuf:"varint,5,opt,name=track_id,json=trackId,proto3" json:"track_id,omitempty"`
}

func (x *VideoObjectTrackingPredictionResult_DetectedObject) Reset() {
	*x = VideoObjectTrackingPredictionResult_DetectedObject{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoObjectTrackingPredictionResult_DetectedObject) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoObjectTrackingPredictionResult_DetectedObject) ProtoMessage() {}

func (x *VideoObjectTrackingPredictionResult_DetectedObject) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoObjectTrackingPredictionResult_DetectedObject.ProtoReflect.Descriptor instead.
func (*VideoObjectTrackingPredictionResult_DetectedObject) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{6, 1}
}

func (x *VideoObjectTrackingPredictionResult_DetectedObject) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *VideoObjectTrackingPredictionResult_DetectedObject) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *VideoObjectTrackingPredictionResult_DetectedObject) GetBoundingBox() *VideoObjectTrackingPredictionResult_BoundingBox {
	if x != nil {
		return x.BoundingBox
	}
	return nil
}

func (x *VideoObjectTrackingPredictionResult_DetectedObject) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *VideoObjectTrackingPredictionResult_DetectedObject) GetTrackId() int64 {
	if x != nil {
		return x.TrackId
	}
	return 0
}

// Each IdentifiedClassification is one particular identification of an
// classification specified with the AnnotationSpec id and display_name,
// and the associated confidence score.
type VideoClassificationPredictionResult_IdentifiedClassification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource ID of the AnnotationSpec that had been identified.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The display name of the AnnotationSpec that had been identified.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The Model's confidence in correction of this identification, higher
	// value means higher confidence.
	Confidence float32 `protobuf:"fixed32,3,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *VideoClassificationPredictionResult_IdentifiedClassification) Reset() {
	*x = VideoClassificationPredictionResult_IdentifiedClassification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoClassificationPredictionResult_IdentifiedClassification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoClassificationPredictionResult_IdentifiedClassification) ProtoMessage() {}

func (x *VideoClassificationPredictionResult_IdentifiedClassification) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoClassificationPredictionResult_IdentifiedClassification.ProtoReflect.Descriptor instead.
func (*VideoClassificationPredictionResult_IdentifiedClassification) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{7, 0}
}

func (x *VideoClassificationPredictionResult_IdentifiedClassification) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *VideoClassificationPredictionResult_IdentifiedClassification) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *VideoClassificationPredictionResult_IdentifiedClassification) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// The entity info for annotations from occupancy counting operator.
type OccupancyCountingPredictionResult_Entity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Label id.
	LabelId int64 `protobuf:"varint,1,opt,name=label_id,json=labelId,proto3" json:"label_id,omitempty"`
	// Human readable string of the label.
	LabelString string `protobuf:"bytes,2,opt,name=label_string,json=labelString,proto3" json:"label_string,omitempty"`
}

func (x *OccupancyCountingPredictionResult_Entity) Reset() {
	*x = OccupancyCountingPredictionResult_Entity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OccupancyCountingPredictionResult_Entity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OccupancyCountingPredictionResult_Entity) ProtoMessage() {}

func (x *OccupancyCountingPredictionResult_Entity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OccupancyCountingPredictionResult_Entity.ProtoReflect.Descriptor instead.
func (*OccupancyCountingPredictionResult_Entity) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{8, 0}
}

func (x *OccupancyCountingPredictionResult_Entity) GetLabelId() int64 {
	if x != nil {
		return x.LabelId
	}
	return 0
}

func (x *OccupancyCountingPredictionResult_Entity) GetLabelString() string {
	if x != nil {
		return x.LabelString
	}
	return ""
}

// Identified box contains location and the entity of the object.
type OccupancyCountingPredictionResult_IdentifiedBox struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An unique id for this box.
	BoxId int64 `protobuf:"varint,1,opt,name=box_id,json=boxId,proto3" json:"box_id,omitempty"`
	// Bounding Box in the normalized coordinates.
	NormalizedBoundingBox *OccupancyCountingPredictionResult_IdentifiedBox_NormalizedBoundingBox `protobuf:"bytes,2,opt,name=normalized_bounding_box,json=normalizedBoundingBox,proto3" json:"normalized_bounding_box,omitempty"`
	// Confidence score associated with this box.
	Score float32 `protobuf:"fixed32,3,opt,name=score,proto3" json:"score,omitempty"`
	// Entity of this box.
	Entity *OccupancyCountingPredictionResult_Entity `protobuf:"bytes,4,opt,name=entity,proto3" json:"entity,omitempty"`
	// An unique id to identify a track. It should be consistent across frames.
	// It only exists if tracking is enabled.
	TrackId int64 `protobuf:"varint,5,opt,name=track_id,json=trackId,proto3" json:"track_id,omitempty"`
}

func (x *OccupancyCountingPredictionResult_IdentifiedBox) Reset() {
	*x = OccupancyCountingPredictionResult_IdentifiedBox{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OccupancyCountingPredictionResult_IdentifiedBox) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OccupancyCountingPredictionResult_IdentifiedBox) ProtoMessage() {}

func (x *OccupancyCountingPredictionResult_IdentifiedBox) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OccupancyCountingPredictionResult_IdentifiedBox.ProtoReflect.Descriptor instead.
func (*OccupancyCountingPredictionResult_IdentifiedBox) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{8, 1}
}

func (x *OccupancyCountingPredictionResult_IdentifiedBox) GetBoxId() int64 {
	if x != nil {
		return x.BoxId
	}
	return 0
}

func (x *OccupancyCountingPredictionResult_IdentifiedBox) GetNormalizedBoundingBox() *OccupancyCountingPredictionResult_IdentifiedBox_NormalizedBoundingBox {
	if x != nil {
		return x.NormalizedBoundingBox
	}
	return nil
}

func (x *OccupancyCountingPredictionResult_IdentifiedBox) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *OccupancyCountingPredictionResult_IdentifiedBox) GetEntity() *OccupancyCountingPredictionResult_Entity {
	if x != nil {
		return x.Entity
	}
	return nil
}

func (x *OccupancyCountingPredictionResult_IdentifiedBox) GetTrackId() int64 {
	if x != nil {
		return x.TrackId
	}
	return 0
}

// The statistics info for annotations from occupancy counting operator.
type OccupancyCountingPredictionResult_Stats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Counts of the full frame.
	FullFrameCount []*OccupancyCountingPredictionResult_Stats_ObjectCount `protobuf:"bytes,1,rep,name=full_frame_count,json=fullFrameCount,proto3" json:"full_frame_count,omitempty"`
	// Crossing line counts.
	CrossingLineCounts []*OccupancyCountingPredictionResult_Stats_CrossingLineCount `protobuf:"bytes,2,rep,name=crossing_line_counts,json=crossingLineCounts,proto3" json:"crossing_line_counts,omitempty"`
	// Active zone counts.
	ActiveZoneCounts []*OccupancyCountingPredictionResult_Stats_ActiveZoneCount `protobuf:"bytes,3,rep,name=active_zone_counts,json=activeZoneCounts,proto3" json:"active_zone_counts,omitempty"`
}

func (x *OccupancyCountingPredictionResult_Stats) Reset() {
	*x = OccupancyCountingPredictionResult_Stats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OccupancyCountingPredictionResult_Stats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OccupancyCountingPredictionResult_Stats) ProtoMessage() {}

func (x *OccupancyCountingPredictionResult_Stats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OccupancyCountingPredictionResult_Stats.ProtoReflect.Descriptor instead.
func (*OccupancyCountingPredictionResult_Stats) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{8, 2}
}

func (x *OccupancyCountingPredictionResult_Stats) GetFullFrameCount() []*OccupancyCountingPredictionResult_Stats_ObjectCount {
	if x != nil {
		return x.FullFrameCount
	}
	return nil
}

func (x *OccupancyCountingPredictionResult_Stats) GetCrossingLineCounts() []*OccupancyCountingPredictionResult_Stats_CrossingLineCount {
	if x != nil {
		return x.CrossingLineCounts
	}
	return nil
}

func (x *OccupancyCountingPredictionResult_Stats) GetActiveZoneCounts() []*OccupancyCountingPredictionResult_Stats_ActiveZoneCount {
	if x != nil {
		return x.ActiveZoneCounts
	}
	return nil
}

// The track info for annotations from occupancy counting operator.
type OccupancyCountingPredictionResult_TrackInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An unique id to identify a track. It should be consistent across frames.
	TrackId string `protobuf:"bytes,1,opt,name=track_id,json=trackId,proto3" json:"track_id,omitempty"`
	// Start timestamp of this track.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
}

func (x *OccupancyCountingPredictionResult_TrackInfo) Reset() {
	*x = OccupancyCountingPredictionResult_TrackInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OccupancyCountingPredictionResult_TrackInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OccupancyCountingPredictionResult_TrackInfo) ProtoMessage() {}

func (x *OccupancyCountingPredictionResult_TrackInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OccupancyCountingPredictionResult_TrackInfo.ProtoReflect.Descriptor instead.
func (*OccupancyCountingPredictionResult_TrackInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{8, 3}
}

func (x *OccupancyCountingPredictionResult_TrackInfo) GetTrackId() string {
	if x != nil {
		return x.TrackId
	}
	return ""
}

func (x *OccupancyCountingPredictionResult_TrackInfo) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

// The dwell time info for annotations from occupancy counting operator.
type OccupancyCountingPredictionResult_DwellTimeInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An unique id to identify a track. It should be consistent across frames.
	TrackId string `protobuf:"bytes,1,opt,name=track_id,json=trackId,proto3" json:"track_id,omitempty"`
	// The unique id for the zone in which the object is dwelling/waiting.
	ZoneId string `protobuf:"bytes,2,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// The beginning time when a dwelling object has been identified in a zone.
	DwellStartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=dwell_start_time,json=dwellStartTime,proto3" json:"dwell_start_time,omitempty"`
	// The end time when a dwelling object has exited in a zone.
	DwellEndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=dwell_end_time,json=dwellEndTime,proto3" json:"dwell_end_time,omitempty"`
}

func (x *OccupancyCountingPredictionResult_DwellTimeInfo) Reset() {
	*x = OccupancyCountingPredictionResult_DwellTimeInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OccupancyCountingPredictionResult_DwellTimeInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OccupancyCountingPredictionResult_DwellTimeInfo) ProtoMessage() {}

func (x *OccupancyCountingPredictionResult_DwellTimeInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OccupancyCountingPredictionResult_DwellTimeInfo.ProtoReflect.Descriptor instead.
func (*OccupancyCountingPredictionResult_DwellTimeInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{8, 4}
}

func (x *OccupancyCountingPredictionResult_DwellTimeInfo) GetTrackId() string {
	if x != nil {
		return x.TrackId
	}
	return ""
}

func (x *OccupancyCountingPredictionResult_DwellTimeInfo) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *OccupancyCountingPredictionResult_DwellTimeInfo) GetDwellStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DwellStartTime
	}
	return nil
}

func (x *OccupancyCountingPredictionResult_DwellTimeInfo) GetDwellEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DwellEndTime
	}
	return nil
}

// Bounding Box in the normalized coordinates.
type OccupancyCountingPredictionResult_IdentifiedBox_NormalizedBoundingBox struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Min in x coordinate.
	Xmin float32 `protobuf:"fixed32,1,opt,name=xmin,proto3" json:"xmin,omitempty"`
	// Min in y coordinate.
	Ymin float32 `protobuf:"fixed32,2,opt,name=ymin,proto3" json:"ymin,omitempty"`
	// Width of the bounding box.
	Width float32 `protobuf:"fixed32,3,opt,name=width,proto3" json:"width,omitempty"`
	// Height of the bounding box.
	Height float32 `protobuf:"fixed32,4,opt,name=height,proto3" json:"height,omitempty"`
}

func (x *OccupancyCountingPredictionResult_IdentifiedBox_NormalizedBoundingBox) Reset() {
	*x = OccupancyCountingPredictionResult_IdentifiedBox_NormalizedBoundingBox{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OccupancyCountingPredictionResult_IdentifiedBox_NormalizedBoundingBox) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OccupancyCountingPredictionResult_IdentifiedBox_NormalizedBoundingBox) ProtoMessage() {}

func (x *OccupancyCountingPredictionResult_IdentifiedBox_NormalizedBoundingBox) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OccupancyCountingPredictionResult_IdentifiedBox_NormalizedBoundingBox.ProtoReflect.Descriptor instead.
func (*OccupancyCountingPredictionResult_IdentifiedBox_NormalizedBoundingBox) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{8, 1, 0}
}

func (x *OccupancyCountingPredictionResult_IdentifiedBox_NormalizedBoundingBox) GetXmin() float32 {
	if x != nil {
		return x.Xmin
	}
	return 0
}

func (x *OccupancyCountingPredictionResult_IdentifiedBox_NormalizedBoundingBox) GetYmin() float32 {
	if x != nil {
		return x.Ymin
	}
	return 0
}

func (x *OccupancyCountingPredictionResult_IdentifiedBox_NormalizedBoundingBox) GetWidth() float32 {
	if x != nil {
		return x.Width
	}
	return 0
}

func (x *OccupancyCountingPredictionResult_IdentifiedBox_NormalizedBoundingBox) GetHeight() float32 {
	if x != nil {
		return x.Height
	}
	return 0
}

// The object info and count for annotations from occupancy counting
// operator.
type OccupancyCountingPredictionResult_Stats_ObjectCount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Entity of this object.
	Entity *OccupancyCountingPredictionResult_Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Count of the object.
	Count int32 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *OccupancyCountingPredictionResult_Stats_ObjectCount) Reset() {
	*x = OccupancyCountingPredictionResult_Stats_ObjectCount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OccupancyCountingPredictionResult_Stats_ObjectCount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OccupancyCountingPredictionResult_Stats_ObjectCount) ProtoMessage() {}

func (x *OccupancyCountingPredictionResult_Stats_ObjectCount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OccupancyCountingPredictionResult_Stats_ObjectCount.ProtoReflect.Descriptor instead.
func (*OccupancyCountingPredictionResult_Stats_ObjectCount) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{8, 2, 0}
}

func (x *OccupancyCountingPredictionResult_Stats_ObjectCount) GetEntity() *OccupancyCountingPredictionResult_Entity {
	if x != nil {
		return x.Entity
	}
	return nil
}

func (x *OccupancyCountingPredictionResult_Stats_ObjectCount) GetCount() int32 {
	if x != nil {
		return x.Count
	}
	return 0
}

// Message for Crossing line count.
type OccupancyCountingPredictionResult_Stats_CrossingLineCount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Line annotation from the user.
	Annotation *StreamAnnotation `protobuf:"bytes,1,opt,name=annotation,proto3" json:"annotation,omitempty"`
	// The direction that follows the right hand rule.
	PositiveDirectionCounts []*OccupancyCountingPredictionResult_Stats_ObjectCount `protobuf:"bytes,2,rep,name=positive_direction_counts,json=positiveDirectionCounts,proto3" json:"positive_direction_counts,omitempty"`
	// The direction that is opposite to the right hand rule.
	NegativeDirectionCounts []*OccupancyCountingPredictionResult_Stats_ObjectCount `protobuf:"bytes,3,rep,name=negative_direction_counts,json=negativeDirectionCounts,proto3" json:"negative_direction_counts,omitempty"`
}

func (x *OccupancyCountingPredictionResult_Stats_CrossingLineCount) Reset() {
	*x = OccupancyCountingPredictionResult_Stats_CrossingLineCount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OccupancyCountingPredictionResult_Stats_CrossingLineCount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OccupancyCountingPredictionResult_Stats_CrossingLineCount) ProtoMessage() {}

func (x *OccupancyCountingPredictionResult_Stats_CrossingLineCount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OccupancyCountingPredictionResult_Stats_CrossingLineCount.ProtoReflect.Descriptor instead.
func (*OccupancyCountingPredictionResult_Stats_CrossingLineCount) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{8, 2, 1}
}

func (x *OccupancyCountingPredictionResult_Stats_CrossingLineCount) GetAnnotation() *StreamAnnotation {
	if x != nil {
		return x.Annotation
	}
	return nil
}

func (x *OccupancyCountingPredictionResult_Stats_CrossingLineCount) GetPositiveDirectionCounts() []*OccupancyCountingPredictionResult_Stats_ObjectCount {
	if x != nil {
		return x.PositiveDirectionCounts
	}
	return nil
}

func (x *OccupancyCountingPredictionResult_Stats_CrossingLineCount) GetNegativeDirectionCounts() []*OccupancyCountingPredictionResult_Stats_ObjectCount {
	if x != nil {
		return x.NegativeDirectionCounts
	}
	return nil
}

// Message for the active zone count.
type OccupancyCountingPredictionResult_Stats_ActiveZoneCount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Active zone annotation from the user.
	Annotation *StreamAnnotation `protobuf:"bytes,1,opt,name=annotation,proto3" json:"annotation,omitempty"`
	// Counts in the zone.
	Counts []*OccupancyCountingPredictionResult_Stats_ObjectCount `protobuf:"bytes,2,rep,name=counts,proto3" json:"counts,omitempty"`
}

func (x *OccupancyCountingPredictionResult_Stats_ActiveZoneCount) Reset() {
	*x = OccupancyCountingPredictionResult_Stats_ActiveZoneCount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OccupancyCountingPredictionResult_Stats_ActiveZoneCount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OccupancyCountingPredictionResult_Stats_ActiveZoneCount) ProtoMessage() {}

func (x *OccupancyCountingPredictionResult_Stats_ActiveZoneCount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OccupancyCountingPredictionResult_Stats_ActiveZoneCount.ProtoReflect.Descriptor instead.
func (*OccupancyCountingPredictionResult_Stats_ActiveZoneCount) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{8, 2, 2}
}

func (x *OccupancyCountingPredictionResult_Stats_ActiveZoneCount) GetAnnotation() *StreamAnnotation {
	if x != nil {
		return x.Annotation
	}
	return nil
}

func (x *OccupancyCountingPredictionResult_Stats_ActiveZoneCount) GetCounts() []*OccupancyCountingPredictionResult_Stats_ObjectCount {
	if x != nil {
		return x.Counts
	}
	return nil
}

// A general annotation message that uses struct format to represent different
// concrete annotation protobufs.
type AppPlatformCloudFunctionRequest_StructedInputAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ingestion time of the current annotation.
	IngestionTimeMicros int64 `protobuf:"varint,1,opt,name=ingestion_time_micros,json=ingestionTimeMicros,proto3" json:"ingestion_time_micros,omitempty"`
	// The struct format of the actual annotation.
	Annotation *structpb.Struct `protobuf:"bytes,2,opt,name=annotation,proto3" json:"annotation,omitempty"`
}

func (x *AppPlatformCloudFunctionRequest_StructedInputAnnotation) Reset() {
	*x = AppPlatformCloudFunctionRequest_StructedInputAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppPlatformCloudFunctionRequest_StructedInputAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppPlatformCloudFunctionRequest_StructedInputAnnotation) ProtoMessage() {}

func (x *AppPlatformCloudFunctionRequest_StructedInputAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppPlatformCloudFunctionRequest_StructedInputAnnotation.ProtoReflect.Descriptor instead.
func (*AppPlatformCloudFunctionRequest_StructedInputAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{15, 0}
}

func (x *AppPlatformCloudFunctionRequest_StructedInputAnnotation) GetIngestionTimeMicros() int64 {
	if x != nil {
		return x.IngestionTimeMicros
	}
	return 0
}

func (x *AppPlatformCloudFunctionRequest_StructedInputAnnotation) GetAnnotation() *structpb.Struct {
	if x != nil {
		return x.Annotation
	}
	return nil
}

// A general annotation message that uses struct format to represent different
// concrete annotation protobufs.
type AppPlatformCloudFunctionResponse_StructedOutputAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The struct format of the actual annotation.
	Annotation *structpb.Struct `protobuf:"bytes,1,opt,name=annotation,proto3" json:"annotation,omitempty"`
}

func (x *AppPlatformCloudFunctionResponse_StructedOutputAnnotation) Reset() {
	*x = AppPlatformCloudFunctionResponse_StructedOutputAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppPlatformCloudFunctionResponse_StructedOutputAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppPlatformCloudFunctionResponse_StructedOutputAnnotation) ProtoMessage() {}

func (x *AppPlatformCloudFunctionResponse_StructedOutputAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppPlatformCloudFunctionResponse_StructedOutputAnnotation.ProtoReflect.Descriptor instead.
func (*AppPlatformCloudFunctionResponse_StructedOutputAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP(), []int{16, 0}
}

func (x *AppPlatformCloudFunctionResponse_StructedOutputAnnotation) GetAnnotation() *structpb.Struct {
	if x != nil {
		return x.Annotation
	}
	return nil
}

var File_google_cloud_visionai_v1alpha1_annotations_proto protoreflect.FileDescriptor

var file_google_cloud_visionai_v1alpha1_annotations_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x80, 0x11, 0x0a, 0x2a, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x72,
	0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x71, 0x75, 0x69, 0x70, 0x6d, 0x65, 0x6e,
	0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x12, 0x3d, 0x0a, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0b, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x84, 0x01, 0x0a, 0x10, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x65, 0x72,
	0x73, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x59, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x73,
	0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x71,
	0x75, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x50,
	0x65, 0x72, 0x73, 0x6f, 0x6e, 0x52, 0x0f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x50,
	0x65, 0x72, 0x73, 0x6f, 0x6e, 0x73, 0x1a, 0x38, 0x0a, 0x0c, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x28, 0x0a, 0x10, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e,
	0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0e, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64,
	0x1a, 0xc0, 0x01, 0x0a, 0x09, 0x50, 0x50, 0x45, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x20,
	0x0a, 0x0c, 0x70, 0x70, 0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x70, 0x70, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x49, 0x64,
	0x12, 0x28, 0x0a, 0x10, 0x70, 0x70, 0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x73, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x70, 0x65, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x43, 0x0a, 0x1e, 0x70, 0x70,
	0x65, 0x5f, 0x73, 0x75, 0x70, 0x65, 0x72, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x1b, 0x70, 0x70, 0x65, 0x53, 0x75, 0x70, 0x65, 0x72, 0x63, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12,
	0x22, 0x0a, 0x0d, 0x70, 0x70, 0x65, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x70, 0x70, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x49, 0x64, 0x1a, 0x6d, 0x0a, 0x15, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x12, 0x12, 0x0a, 0x04,
	0x78, 0x6d, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x04, 0x78, 0x6d, 0x69, 0x6e,
	0x12, 0x12, 0x0a, 0x04, 0x79, 0x6d, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x04,
	0x79, 0x6d, 0x69, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x06, 0x68, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x1a, 0xf0, 0x02, 0x0a, 0x13, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x42, 0x6f, 0x78, 0x12, 0x15, 0x0a, 0x06, 0x62, 0x6f,
	0x78, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x62, 0x6f, 0x78, 0x49,
	0x64, 0x12, 0x98, 0x01, 0x0a, 0x17, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64,
	0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x6f, 0x78, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x60, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x72, 0x6f,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x71, 0x75, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x2e,
	0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x42, 0x6f, 0x78, 0x52, 0x15, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x12, 0x29, 0x0a, 0x10,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x63, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x7c, 0x0a, 0x0d, 0x70, 0x65, 0x72, 0x73, 0x6f,
	0x6e, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x57,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x45, 0x71, 0x75, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x6f,
	0x6e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x0c, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x1a, 0xe4, 0x02, 0x0a, 0x10, 0x50, 0x50, 0x45, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x42, 0x6f, 0x78, 0x12, 0x15, 0x0a, 0x06, 0x62, 0x6f,
	0x78, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x62, 0x6f, 0x78, 0x49,
	0x64, 0x12, 0x98, 0x01, 0x0a, 0x17, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64,
	0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x6f, 0x78, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x60, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x72, 0x6f,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x71, 0x75, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x2e,
	0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x42, 0x6f, 0x78, 0x52, 0x15, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x12, 0x29, 0x0a, 0x10,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x63, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x73, 0x0a, 0x0a, 0x70, 0x70, 0x65, 0x5f, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x65, 0x72,
	0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45,
	0x71, 0x75, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x2e, 0x50, 0x50, 0x45, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x52, 0x09, 0x70, 0x70, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x1a, 0xc5, 0x06, 0x0a,
	0x0e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x08, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0xa3, 0x01, 0x0a,
	0x1e, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x62, 0x6f, 0x78, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50,
	0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x71, 0x75, 0x69, 0x70, 0x6d, 0x65,
	0x6e, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x64, 0x42, 0x6f, 0x78, 0x52, 0x1b, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x50,
	0x65, 0x72, 0x73, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x42,
	0x6f, 0x78, 0x12, 0x9e, 0x01, 0x0a, 0x1d, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f,
	0x70, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x62,
	0x6f, 0x78, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x73,
	0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x71,
	0x75, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x2e, 0x50, 0x50, 0x45, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x64, 0x42, 0x6f, 0x78, 0x52, 0x1a, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x50, 0x70, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x42, 0x6f,
	0x78, 0x65, 0x73, 0x12, 0x33, 0x0a, 0x13, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02,
	0x48, 0x00, 0x52, 0x11, 0x66, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65,
	0x53, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x13, 0x65, 0x79, 0x65, 0x73,
	0x5f, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x02, 0x48, 0x01, 0x52, 0x11, 0x65, 0x79, 0x65, 0x73, 0x43, 0x6f, 0x76,
	0x65, 0x72, 0x61, 0x67, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a,
	0x13, 0x68, 0x65, 0x61, 0x64, 0x5f, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x63, 0x6f, 0x72, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x02, 0x48, 0x02, 0x52, 0x11, 0x68, 0x65,
	0x61, 0x64, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x35, 0x0a, 0x14, 0x68, 0x61, 0x6e, 0x64, 0x73, 0x5f, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x02,
	0x48, 0x03, 0x52, 0x12, 0x68, 0x61, 0x6e, 0x64, 0x73, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67,
	0x65, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x13, 0x62, 0x6f, 0x64,
	0x79, 0x5f, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x02, 0x48, 0x04, 0x52, 0x11, 0x62, 0x6f, 0x64, 0x79, 0x43, 0x6f,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x33,
	0x0a, 0x13, 0x66, 0x65, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x02, 0x48, 0x05, 0x52, 0x11, 0x66,
	0x65, 0x65, 0x74, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65,
	0x88, 0x01, 0x01, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x16, 0x0a, 0x14, 0x5f,
	0x65, 0x79, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x63,
	0x6f, 0x72, 0x65, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x5f, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x17, 0x0a, 0x15, 0x5f,
	0x68, 0x61, 0x6e, 0x64, 0x73, 0x5f, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x63, 0x6f, 0x72, 0x65, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x62, 0x6f, 0x64, 0x79, 0x5f, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x16, 0x0a, 0x14,
	0x5f, 0x66, 0x65, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x63, 0x6f, 0x72, 0x65, 0x22, 0xe3, 0x05, 0x0a, 0x1f, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x3d, 0x0a, 0x0c, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x78, 0x0a, 0x10, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x62, 0x6f, 0x78, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x42, 0x6f, 0x78,
	0x52, 0x0f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x42, 0x6f, 0x78, 0x65,
	0x73, 0x1a, 0x46, 0x0a, 0x06, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x19, 0x0a, 0x08, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f,
	0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x1a, 0xbe, 0x03, 0x0a, 0x0d, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x42, 0x6f, 0x78, 0x12, 0x15, 0x0a, 0x06, 0x62,
	0x6f, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x62, 0x6f, 0x78,
	0x49, 0x64, 0x12, 0x9b, 0x01, 0x0a, 0x17, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x64, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x6f, 0x78, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x63, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64,
	0x42, 0x6f, 0x78, 0x2e, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x6f,
	0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x52, 0x15, 0x6e, 0x6f, 0x72, 0x6d, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78,
	0x12, 0x29, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73,
	0x63, 0x6f, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x5e, 0x0a, 0x06, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x1a, 0x6d, 0x0a, 0x15, 0x4e,
	0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x42, 0x6f, 0x78, 0x12, 0x12, 0x0a, 0x04, 0x78, 0x6d, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x04, 0x78, 0x6d, 0x69, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x79, 0x6d, 0x69, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x04, 0x79, 0x6d, 0x69, 0x6e, 0x12, 0x14, 0x0a, 0x05,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x77, 0x69, 0x64,
	0x74, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x06, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x22, 0xb3, 0x01, 0x0a, 0x24, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x03,
	0x52, 0x03, 0x69, 0x64, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x02, 0x52,
	0x0b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x06,
	0x62, 0x62, 0x6f, 0x78, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x62, 0x62, 0x6f, 0x78, 0x65, 0x73,
	0x22, 0x79, 0x0a, 0x1e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x03, 0x52,
	0x03, 0x69, 0x64, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x02, 0x52, 0x0b,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x22, 0x71, 0x0a, 0x21, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x23, 0x0a, 0x0d, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x79, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x92,
	0x03, 0x0a, 0x26, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x48, 0x0a, 0x12, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x10, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x10, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x71, 0x0a, 0x07, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65,
	0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x65, 0x0a, 0x10,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x22, 0xfb, 0x04, 0x0a, 0x23, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x48, 0x0a, 0x12, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x10, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x10, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x6c, 0x0a, 0x07, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e,
	0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x52, 0x07, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x1a, 0x61, 0x0a, 0x0b, 0x42, 0x6f, 0x75,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x12, 0x13, 0x0a, 0x05, 0x78, 0x5f, 0x6d, 0x69,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x04, 0x78, 0x4d, 0x69, 0x6e, 0x12, 0x13, 0x0a,
	0x05, 0x78, 0x5f, 0x6d, 0x61, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x04, 0x78, 0x4d,
	0x61, 0x78, 0x12, 0x13, 0x0a, 0x05, 0x79, 0x5f, 0x6d, 0x69, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x04, 0x79, 0x4d, 0x69, 0x6e, 0x12, 0x13, 0x0a, 0x05, 0x79, 0x5f, 0x6d, 0x61, 0x78,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x04, 0x79, 0x4d, 0x61, 0x78, 0x1a, 0xf2, 0x01, 0x0a,
	0x0e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x72, 0x0a, 0x0c, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x62,
	0x6f, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x42, 0x6f,
	0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x52, 0x0b, 0x62, 0x6f, 0x75, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64,
	0x65, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f,
	0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x49,
	0x64, 0x22, 0xad, 0x03, 0x0a, 0x23, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6c, 0x61, 0x73, 0x73,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x48, 0x0a, 0x12, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x10, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x10, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x86, 0x01, 0x0a, 0x0f, 0x63, 0x6c,
	0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x5c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x64, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0x6d, 0x0a, 0x18, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x21,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63,
	0x65, 0x22, 0xec, 0x13, 0x0a, 0x21, 0x4f, 0x63, 0x63, 0x75, 0x70, 0x61, 0x6e, 0x63, 0x79, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x3d, 0x0a, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x7a, 0x0a, 0x10, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x64, 0x5f, 0x62, 0x6f, 0x78, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x70, 0x61, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x42, 0x6f,
	0x78, 0x52, 0x0f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x42, 0x6f, 0x78,
	0x65, 0x73, 0x12, 0x5d, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x70, 0x61, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x73, 0x12, 0x6a, 0x0a, 0x0a, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x70, 0x61, 0x6e, 0x63, 0x79,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x09, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x77, 0x0a,
	0x0f, 0x64, 0x77, 0x65, 0x6c, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x70, 0x61, 0x6e, 0x63,
	0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x44, 0x77, 0x65, 0x6c, 0x6c, 0x54,
	0x69, 0x6d, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0d, 0x64, 0x77, 0x65, 0x6c, 0x6c, 0x54, 0x69,
	0x6d, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x1a, 0x46, 0x0a, 0x06, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x12, 0x19, 0x0a, 0x08, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x07, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x1a, 0xc8,
	0x03, 0x0a, 0x0d, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x42, 0x6f, 0x78,
	0x12, 0x15, 0x0a, 0x06, 0x62, 0x6f, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x05, 0x62, 0x6f, 0x78, 0x49, 0x64, 0x12, 0x9d, 0x01, 0x0a, 0x17, 0x6e, 0x6f, 0x72, 0x6d,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f,
	0x62, 0x6f, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x70,
	0x61, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x42, 0x6f, 0x78, 0x2e, 0x4e, 0x6f, 0x72, 0x6d, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78,
	0x52, 0x15, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x6f, 0x75, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x60, 0x0a,
	0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f,
	0x63, 0x63, 0x75, 0x70, 0x61, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x69, 0x6e, 0x67,
	0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12,
	0x19, 0x0a, 0x08, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x49, 0x64, 0x1a, 0x6d, 0x0a, 0x15, 0x4e, 0x6f,
	0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x42, 0x6f, 0x78, 0x12, 0x12, 0x0a, 0x04, 0x78, 0x6d, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x04, 0x78, 0x6d, 0x69, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x79, 0x6d, 0x69, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x04, 0x79, 0x6d, 0x69, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x77,
	0x69, 0x64, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x77, 0x69, 0x64, 0x74,
	0x68, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x06, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x1a, 0x83, 0x09, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x12, 0x7d, 0x0a, 0x10, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x66, 0x72, 0x61, 0x6d,
	0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x53, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f,
	0x63, 0x63, 0x75, 0x70, 0x61, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x69, 0x6e, 0x67,
	0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x52, 0x0e, 0x66, 0x75, 0x6c, 0x6c, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x8b, 0x01, 0x0a, 0x14, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f,
	0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x70, 0x61, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x43, 0x72, 0x6f, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x12, 0x63, 0x72,
	0x6f, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x12, 0x85, 0x01, 0x0a, 0x12, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x57, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f,
	0x63, 0x63, 0x75, 0x70, 0x61, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x69, 0x6e, 0x67,
	0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5a, 0x6f, 0x6e,
	0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x10, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5a, 0x6f,
	0x6e, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x1a, 0x85, 0x01, 0x0a, 0x0b, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x60, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x70, 0x61,
	0x6e, 0x63, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x1a, 0x89, 0x03, 0x0a, 0x11, 0x43, 0x72, 0x6f, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6e,
	0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x8f, 0x01, 0x0a, 0x19, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x63,
	0x63, 0x75, 0x70, 0x61, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x50,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x52, 0x17, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x8f, 0x01, 0x0a, 0x19, 0x6e,
	0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x53,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x4f, 0x63, 0x63, 0x75, 0x70, 0x61, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x69, 0x6e,
	0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x52, 0x17, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x1a, 0xd0, 0x01, 0x0a,
	0x0f, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x50, 0x0a, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x6b, 0x0a, 0x06, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x70, 0x61, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x06, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x1a,
	0x61, 0x0a, 0x09, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x19, 0x0a, 0x08,
	0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x74, 0x72, 0x61, 0x63, 0x6b, 0x49, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x1a, 0xcb, 0x01, 0x0a, 0x0d, 0x44, 0x77, 0x65, 0x6c, 0x6c, 0x54, 0x69, 0x6d, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x49, 0x64, 0x12,
	0x17, 0x0a, 0x07, 0x7a, 0x6f, 0x6e, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x7a, 0x6f, 0x6e, 0x65, 0x49, 0x64, 0x12, 0x44, 0x0a, 0x10, 0x64, 0x77, 0x65, 0x6c,
	0x6c, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e,
	0x64, 0x77, 0x65, 0x6c, 0x6c, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0e, 0x64, 0x77, 0x65, 0x6c, 0x6c, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0c, 0x64, 0x77, 0x65, 0x6c, 0x6c, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x22, 0xfb, 0x02, 0x0a, 0x10, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x0b, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f,
	0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x72, 0x6d,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x79, 0x67, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x0a, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x59, 0x0a, 0x0d, 0x63,
	0x72, 0x6f, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x50, 0x6f,
	0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x4c, 0x69, 0x6e, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x48,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x42, 0x14, 0x0a, 0x12, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x74,
	0x0a, 0x11, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x5f, 0x0a, 0x12, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x11, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x22, 0x76, 0x0a, 0x11, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x64, 0x50, 0x6f, 0x6c, 0x79, 0x67, 0x6f, 0x6e, 0x12, 0x61, 0x0a, 0x13, 0x6e, 0x6f, 0x72,
	0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x74, 0x69, 0x63, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x64, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x12, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c,
	0x69, 0x7a, 0x65, 0x64, 0x56, 0x65, 0x72, 0x74, 0x69, 0x63, 0x65, 0x73, 0x22, 0x77, 0x0a, 0x12,
	0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69,
	0x6e, 0x65, 0x12, 0x61, 0x0a, 0x13, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64,
	0x5f, 0x76, 0x65, 0x72, 0x74, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x65, 0x72, 0x74, 0x65,
	0x78, 0x52, 0x12, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x65, 0x72,
	0x74, 0x69, 0x63, 0x65, 0x73, 0x22, 0x2e, 0x0a, 0x10, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x64, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x12, 0x0c, 0x0a, 0x01, 0x78, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x01, 0x78, 0x12, 0x0c, 0x0a, 0x01, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x01, 0x79, 0x22, 0x8a, 0x01, 0x0a, 0x13, 0x41, 0x70, 0x70, 0x50, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x20, 0x0a,
	0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x6f, 0x64, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x22, 0x8e, 0x03, 0x0a, 0x1f, 0x41, 0x70, 0x70, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x67, 0x0a, 0x15, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x13, 0x61, 0x70, 0x70, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x79, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x65, 0x64, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x86, 0x01, 0x0a, 0x17, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x65, 0x64, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x6e, 0x67, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x69, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x69, 0x6d, 0x65, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x37, 0x0a, 0x0a, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xf4, 0x01, 0x0a, 0x20, 0x41, 0x70, 0x70, 0x50, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x7b, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x59, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41,
	0x70, 0x70, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x65, 0x64, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x53, 0x0a, 0x18, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x65,
	0x64, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x37, 0x0a, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0a,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2a, 0x90, 0x01, 0x0a, 0x14, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x26, 0x0a, 0x22, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x5f, 0x41, 0x4e,
	0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x26, 0x0a, 0x22, 0x53,
	0x54, 0x52, 0x45, 0x41, 0x4d, 0x5f, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x5a, 0x4f, 0x4e,
	0x45, 0x10, 0x01, 0x12, 0x28, 0x0a, 0x24, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x5f, 0x41, 0x4e,
	0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x52,
	0x4f, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x5f, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x02, 0x42, 0xe6, 0x01,
	0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x42, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x46, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x3b, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x56, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x49, 0x2e, 0x56, 0x31, 0x41, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x56, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x49, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x56, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x49, 0x3a, 0x3a, 0x56, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescOnce sync.Once
	file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescData = file_google_cloud_visionai_v1alpha1_annotations_proto_rawDesc
)

func file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescGZIP() []byte {
	file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescOnce.Do(func() {
		file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescData)
	})
	return file_google_cloud_visionai_v1alpha1_annotations_proto_rawDescData
}

var file_google_cloud_visionai_v1alpha1_annotations_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes = make([]protoimpl.MessageInfo, 41)
var file_google_cloud_visionai_v1alpha1_annotations_proto_goTypes = []interface{}{
	(StreamAnnotationType)(0),                                                     // 0: google.cloud.visionai.v1alpha1.StreamAnnotationType
	(*PersonalProtectiveEquipmentDetectionOutput)(nil),                            // 1: google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput
	(*ObjectDetectionPredictionResult)(nil),                                       // 2: google.cloud.visionai.v1alpha1.ObjectDetectionPredictionResult
	(*ImageObjectDetectionPredictionResult)(nil),                                  // 3: google.cloud.visionai.v1alpha1.ImageObjectDetectionPredictionResult
	(*ClassificationPredictionResult)(nil),                                        // 4: google.cloud.visionai.v1alpha1.ClassificationPredictionResult
	(*ImageSegmentationPredictionResult)(nil),                                     // 5: google.cloud.visionai.v1alpha1.ImageSegmentationPredictionResult
	(*VideoActionRecognitionPredictionResult)(nil),                                // 6: google.cloud.visionai.v1alpha1.VideoActionRecognitionPredictionResult
	(*VideoObjectTrackingPredictionResult)(nil),                                   // 7: google.cloud.visionai.v1alpha1.VideoObjectTrackingPredictionResult
	(*VideoClassificationPredictionResult)(nil),                                   // 8: google.cloud.visionai.v1alpha1.VideoClassificationPredictionResult
	(*OccupancyCountingPredictionResult)(nil),                                     // 9: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult
	(*StreamAnnotation)(nil),                                                      // 10: google.cloud.visionai.v1alpha1.StreamAnnotation
	(*StreamAnnotations)(nil),                                                     // 11: google.cloud.visionai.v1alpha1.StreamAnnotations
	(*NormalizedPolygon)(nil),                                                     // 12: google.cloud.visionai.v1alpha1.NormalizedPolygon
	(*NormalizedPolyline)(nil),                                                    // 13: google.cloud.visionai.v1alpha1.NormalizedPolyline
	(*NormalizedVertex)(nil),                                                      // 14: google.cloud.visionai.v1alpha1.NormalizedVertex
	(*AppPlatformMetadata)(nil),                                                   // 15: google.cloud.visionai.v1alpha1.AppPlatformMetadata
	(*AppPlatformCloudFunctionRequest)(nil),                                       // 16: google.cloud.visionai.v1alpha1.AppPlatformCloudFunctionRequest
	(*AppPlatformCloudFunctionResponse)(nil),                                      // 17: google.cloud.visionai.v1alpha1.AppPlatformCloudFunctionResponse
	(*PersonalProtectiveEquipmentDetectionOutput_PersonEntity)(nil),               // 18: google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.PersonEntity
	(*PersonalProtectiveEquipmentDetectionOutput_PPEEntity)(nil),                  // 19: google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.PPEEntity
	(*PersonalProtectiveEquipmentDetectionOutput_NormalizedBoundingBox)(nil),      // 20: google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.NormalizedBoundingBox
	(*PersonalProtectiveEquipmentDetectionOutput_PersonIdentifiedBox)(nil),        // 21: google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.PersonIdentifiedBox
	(*PersonalProtectiveEquipmentDetectionOutput_PPEIdentifiedBox)(nil),           // 22: google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.PPEIdentifiedBox
	(*PersonalProtectiveEquipmentDetectionOutput_DetectedPerson)(nil),             // 23: google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.DetectedPerson
	(*ObjectDetectionPredictionResult_Entity)(nil),                                // 24: google.cloud.visionai.v1alpha1.ObjectDetectionPredictionResult.Entity
	(*ObjectDetectionPredictionResult_IdentifiedBox)(nil),                         // 25: google.cloud.visionai.v1alpha1.ObjectDetectionPredictionResult.IdentifiedBox
	(*ObjectDetectionPredictionResult_IdentifiedBox_NormalizedBoundingBox)(nil),   // 26: google.cloud.visionai.v1alpha1.ObjectDetectionPredictionResult.IdentifiedBox.NormalizedBoundingBox
	(*VideoActionRecognitionPredictionResult_IdentifiedAction)(nil),               // 27: google.cloud.visionai.v1alpha1.VideoActionRecognitionPredictionResult.IdentifiedAction
	(*VideoObjectTrackingPredictionResult_BoundingBox)(nil),                       // 28: google.cloud.visionai.v1alpha1.VideoObjectTrackingPredictionResult.BoundingBox
	(*VideoObjectTrackingPredictionResult_DetectedObject)(nil),                    // 29: google.cloud.visionai.v1alpha1.VideoObjectTrackingPredictionResult.DetectedObject
	(*VideoClassificationPredictionResult_IdentifiedClassification)(nil),          // 30: google.cloud.visionai.v1alpha1.VideoClassificationPredictionResult.IdentifiedClassification
	(*OccupancyCountingPredictionResult_Entity)(nil),                              // 31: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Entity
	(*OccupancyCountingPredictionResult_IdentifiedBox)(nil),                       // 32: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.IdentifiedBox
	(*OccupancyCountingPredictionResult_Stats)(nil),                               // 33: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Stats
	(*OccupancyCountingPredictionResult_TrackInfo)(nil),                           // 34: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.TrackInfo
	(*OccupancyCountingPredictionResult_DwellTimeInfo)(nil),                       // 35: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.DwellTimeInfo
	(*OccupancyCountingPredictionResult_IdentifiedBox_NormalizedBoundingBox)(nil), // 36: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.IdentifiedBox.NormalizedBoundingBox
	(*OccupancyCountingPredictionResult_Stats_ObjectCount)(nil),                   // 37: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Stats.ObjectCount
	(*OccupancyCountingPredictionResult_Stats_CrossingLineCount)(nil),             // 38: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Stats.CrossingLineCount
	(*OccupancyCountingPredictionResult_Stats_ActiveZoneCount)(nil),               // 39: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Stats.ActiveZoneCount
	(*AppPlatformCloudFunctionRequest_StructedInputAnnotation)(nil),               // 40: google.cloud.visionai.v1alpha1.AppPlatformCloudFunctionRequest.StructedInputAnnotation
	(*AppPlatformCloudFunctionResponse_StructedOutputAnnotation)(nil),             // 41: google.cloud.visionai.v1alpha1.AppPlatformCloudFunctionResponse.StructedOutputAnnotation
	(*timestamppb.Timestamp)(nil),                                                 // 42: google.protobuf.Timestamp
	(*structpb.ListValue)(nil),                                                    // 43: google.protobuf.ListValue
	(*structpb.Struct)(nil),                                                       // 44: google.protobuf.Struct
}
var file_google_cloud_visionai_v1alpha1_annotations_proto_depIdxs = []int32{
	42, // 0: google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.current_time:type_name -> google.protobuf.Timestamp
	23, // 1: google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.detected_persons:type_name -> google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.DetectedPerson
	42, // 2: google.cloud.visionai.v1alpha1.ObjectDetectionPredictionResult.current_time:type_name -> google.protobuf.Timestamp
	25, // 3: google.cloud.visionai.v1alpha1.ObjectDetectionPredictionResult.identified_boxes:type_name -> google.cloud.visionai.v1alpha1.ObjectDetectionPredictionResult.IdentifiedBox
	43, // 4: google.cloud.visionai.v1alpha1.ImageObjectDetectionPredictionResult.bboxes:type_name -> google.protobuf.ListValue
	42, // 5: google.cloud.visionai.v1alpha1.VideoActionRecognitionPredictionResult.segment_start_time:type_name -> google.protobuf.Timestamp
	42, // 6: google.cloud.visionai.v1alpha1.VideoActionRecognitionPredictionResult.segment_end_time:type_name -> google.protobuf.Timestamp
	27, // 7: google.cloud.visionai.v1alpha1.VideoActionRecognitionPredictionResult.actions:type_name -> google.cloud.visionai.v1alpha1.VideoActionRecognitionPredictionResult.IdentifiedAction
	42, // 8: google.cloud.visionai.v1alpha1.VideoObjectTrackingPredictionResult.segment_start_time:type_name -> google.protobuf.Timestamp
	42, // 9: google.cloud.visionai.v1alpha1.VideoObjectTrackingPredictionResult.segment_end_time:type_name -> google.protobuf.Timestamp
	29, // 10: google.cloud.visionai.v1alpha1.VideoObjectTrackingPredictionResult.objects:type_name -> google.cloud.visionai.v1alpha1.VideoObjectTrackingPredictionResult.DetectedObject
	42, // 11: google.cloud.visionai.v1alpha1.VideoClassificationPredictionResult.segment_start_time:type_name -> google.protobuf.Timestamp
	42, // 12: google.cloud.visionai.v1alpha1.VideoClassificationPredictionResult.segment_end_time:type_name -> google.protobuf.Timestamp
	30, // 13: google.cloud.visionai.v1alpha1.VideoClassificationPredictionResult.classifications:type_name -> google.cloud.visionai.v1alpha1.VideoClassificationPredictionResult.IdentifiedClassification
	42, // 14: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.current_time:type_name -> google.protobuf.Timestamp
	32, // 15: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.identified_boxes:type_name -> google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.IdentifiedBox
	33, // 16: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.stats:type_name -> google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Stats
	34, // 17: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.track_info:type_name -> google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.TrackInfo
	35, // 18: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.dwell_time_info:type_name -> google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.DwellTimeInfo
	12, // 19: google.cloud.visionai.v1alpha1.StreamAnnotation.active_zone:type_name -> google.cloud.visionai.v1alpha1.NormalizedPolygon
	13, // 20: google.cloud.visionai.v1alpha1.StreamAnnotation.crossing_line:type_name -> google.cloud.visionai.v1alpha1.NormalizedPolyline
	0,  // 21: google.cloud.visionai.v1alpha1.StreamAnnotation.type:type_name -> google.cloud.visionai.v1alpha1.StreamAnnotationType
	10, // 22: google.cloud.visionai.v1alpha1.StreamAnnotations.stream_annotations:type_name -> google.cloud.visionai.v1alpha1.StreamAnnotation
	14, // 23: google.cloud.visionai.v1alpha1.NormalizedPolygon.normalized_vertices:type_name -> google.cloud.visionai.v1alpha1.NormalizedVertex
	14, // 24: google.cloud.visionai.v1alpha1.NormalizedPolyline.normalized_vertices:type_name -> google.cloud.visionai.v1alpha1.NormalizedVertex
	15, // 25: google.cloud.visionai.v1alpha1.AppPlatformCloudFunctionRequest.app_platform_metadata:type_name -> google.cloud.visionai.v1alpha1.AppPlatformMetadata
	40, // 26: google.cloud.visionai.v1alpha1.AppPlatformCloudFunctionRequest.annotations:type_name -> google.cloud.visionai.v1alpha1.AppPlatformCloudFunctionRequest.StructedInputAnnotation
	41, // 27: google.cloud.visionai.v1alpha1.AppPlatformCloudFunctionResponse.annotations:type_name -> google.cloud.visionai.v1alpha1.AppPlatformCloudFunctionResponse.StructedOutputAnnotation
	20, // 28: google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.PersonIdentifiedBox.normalized_bounding_box:type_name -> google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.NormalizedBoundingBox
	18, // 29: google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.PersonIdentifiedBox.person_entity:type_name -> google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.PersonEntity
	20, // 30: google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.PPEIdentifiedBox.normalized_bounding_box:type_name -> google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.NormalizedBoundingBox
	19, // 31: google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.PPEIdentifiedBox.ppe_entity:type_name -> google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.PPEEntity
	21, // 32: google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.DetectedPerson.detected_person_identified_box:type_name -> google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.PersonIdentifiedBox
	22, // 33: google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.DetectedPerson.detected_ppe_identified_boxes:type_name -> google.cloud.visionai.v1alpha1.PersonalProtectiveEquipmentDetectionOutput.PPEIdentifiedBox
	26, // 34: google.cloud.visionai.v1alpha1.ObjectDetectionPredictionResult.IdentifiedBox.normalized_bounding_box:type_name -> google.cloud.visionai.v1alpha1.ObjectDetectionPredictionResult.IdentifiedBox.NormalizedBoundingBox
	24, // 35: google.cloud.visionai.v1alpha1.ObjectDetectionPredictionResult.IdentifiedBox.entity:type_name -> google.cloud.visionai.v1alpha1.ObjectDetectionPredictionResult.Entity
	28, // 36: google.cloud.visionai.v1alpha1.VideoObjectTrackingPredictionResult.DetectedObject.bounding_box:type_name -> google.cloud.visionai.v1alpha1.VideoObjectTrackingPredictionResult.BoundingBox
	36, // 37: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.IdentifiedBox.normalized_bounding_box:type_name -> google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.IdentifiedBox.NormalizedBoundingBox
	31, // 38: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.IdentifiedBox.entity:type_name -> google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Entity
	37, // 39: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Stats.full_frame_count:type_name -> google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Stats.ObjectCount
	38, // 40: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Stats.crossing_line_counts:type_name -> google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Stats.CrossingLineCount
	39, // 41: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Stats.active_zone_counts:type_name -> google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Stats.ActiveZoneCount
	42, // 42: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.TrackInfo.start_time:type_name -> google.protobuf.Timestamp
	42, // 43: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.DwellTimeInfo.dwell_start_time:type_name -> google.protobuf.Timestamp
	42, // 44: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.DwellTimeInfo.dwell_end_time:type_name -> google.protobuf.Timestamp
	31, // 45: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Stats.ObjectCount.entity:type_name -> google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Entity
	10, // 46: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Stats.CrossingLineCount.annotation:type_name -> google.cloud.visionai.v1alpha1.StreamAnnotation
	37, // 47: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Stats.CrossingLineCount.positive_direction_counts:type_name -> google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Stats.ObjectCount
	37, // 48: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Stats.CrossingLineCount.negative_direction_counts:type_name -> google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Stats.ObjectCount
	10, // 49: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Stats.ActiveZoneCount.annotation:type_name -> google.cloud.visionai.v1alpha1.StreamAnnotation
	37, // 50: google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Stats.ActiveZoneCount.counts:type_name -> google.cloud.visionai.v1alpha1.OccupancyCountingPredictionResult.Stats.ObjectCount
	44, // 51: google.cloud.visionai.v1alpha1.AppPlatformCloudFunctionRequest.StructedInputAnnotation.annotation:type_name -> google.protobuf.Struct
	44, // 52: google.cloud.visionai.v1alpha1.AppPlatformCloudFunctionResponse.StructedOutputAnnotation.annotation:type_name -> google.protobuf.Struct
	53, // [53:53] is the sub-list for method output_type
	53, // [53:53] is the sub-list for method input_type
	53, // [53:53] is the sub-list for extension type_name
	53, // [53:53] is the sub-list for extension extendee
	0,  // [0:53] is the sub-list for field type_name
}

func init() { file_google_cloud_visionai_v1alpha1_annotations_proto_init() }
func file_google_cloud_visionai_v1alpha1_annotations_proto_init() {
	if File_google_cloud_visionai_v1alpha1_annotations_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PersonalProtectiveEquipmentDetectionOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectDetectionPredictionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageObjectDetectionPredictionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClassificationPredictionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageSegmentationPredictionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoActionRecognitionPredictionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoObjectTrackingPredictionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoClassificationPredictionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OccupancyCountingPredictionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamAnnotations); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NormalizedPolygon); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NormalizedPolyline); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NormalizedVertex); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppPlatformMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppPlatformCloudFunctionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppPlatformCloudFunctionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PersonalProtectiveEquipmentDetectionOutput_PersonEntity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PersonalProtectiveEquipmentDetectionOutput_PPEEntity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PersonalProtectiveEquipmentDetectionOutput_NormalizedBoundingBox); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PersonalProtectiveEquipmentDetectionOutput_PersonIdentifiedBox); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PersonalProtectiveEquipmentDetectionOutput_PPEIdentifiedBox); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PersonalProtectiveEquipmentDetectionOutput_DetectedPerson); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectDetectionPredictionResult_Entity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectDetectionPredictionResult_IdentifiedBox); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectDetectionPredictionResult_IdentifiedBox_NormalizedBoundingBox); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoActionRecognitionPredictionResult_IdentifiedAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoObjectTrackingPredictionResult_BoundingBox); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoObjectTrackingPredictionResult_DetectedObject); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoClassificationPredictionResult_IdentifiedClassification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OccupancyCountingPredictionResult_Entity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OccupancyCountingPredictionResult_IdentifiedBox); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OccupancyCountingPredictionResult_Stats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OccupancyCountingPredictionResult_TrackInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OccupancyCountingPredictionResult_DwellTimeInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OccupancyCountingPredictionResult_IdentifiedBox_NormalizedBoundingBox); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OccupancyCountingPredictionResult_Stats_ObjectCount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OccupancyCountingPredictionResult_Stats_CrossingLineCount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OccupancyCountingPredictionResult_Stats_ActiveZoneCount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppPlatformCloudFunctionRequest_StructedInputAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppPlatformCloudFunctionResponse_StructedOutputAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*StreamAnnotation_ActiveZone)(nil),
		(*StreamAnnotation_CrossingLine)(nil),
	}
	file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes[22].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_visionai_v1alpha1_annotations_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   41,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_visionai_v1alpha1_annotations_proto_goTypes,
		DependencyIndexes: file_google_cloud_visionai_v1alpha1_annotations_proto_depIdxs,
		EnumInfos:         file_google_cloud_visionai_v1alpha1_annotations_proto_enumTypes,
		MessageInfos:      file_google_cloud_visionai_v1alpha1_annotations_proto_msgTypes,
	}.Build()
	File_google_cloud_visionai_v1alpha1_annotations_proto = out.File
	file_google_cloud_visionai_v1alpha1_annotations_proto_rawDesc = nil
	file_google_cloud_visionai_v1alpha1_annotations_proto_goTypes = nil
	file_google_cloud_visionai_v1alpha1_annotations_proto_depIdxs = nil
}
