// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/osconfig/v1/vulnerability.proto

package osconfig

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This metric reflects the context by which vulnerability exploitation is
// possible.
type CVSSv3_AttackVector int32

const (
	// Invalid value.
	CVSSv3_ATTACK_VECTOR_UNSPECIFIED CVSSv3_AttackVector = 0
	// The vulnerable component is bound to the network stack and the set of
	// possible attackers extends beyond the other options listed below, up to
	// and including the entire Internet.
	CVSSv3_ATTACK_VECTOR_NETWORK CVSSv3_AttackVector = 1
	// The vulnerable component is bound to the network stack, but the attack is
	// limited at the protocol level to a logically adjacent topology.
	CVSSv3_ATTACK_VECTOR_ADJACENT CVSSv3_AttackVector = 2
	// The vulnerable component is not bound to the network stack and the
	// attacker's path is via read/write/execute capabilities.
	CVSSv3_ATTACK_VECTOR_LOCAL CVSSv3_AttackVector = 3
	// The attack requires the attacker to physically touch or manipulate the
	// vulnerable component.
	CVSSv3_ATTACK_VECTOR_PHYSICAL CVSSv3_AttackVector = 4
)

// Enum value maps for CVSSv3_AttackVector.
var (
	CVSSv3_AttackVector_name = map[int32]string{
		0: "ATTACK_VECTOR_UNSPECIFIED",
		1: "ATTACK_VECTOR_NETWORK",
		2: "ATTACK_VECTOR_ADJACENT",
		3: "ATTACK_VECTOR_LOCAL",
		4: "ATTACK_VECTOR_PHYSICAL",
	}
	CVSSv3_AttackVector_value = map[string]int32{
		"ATTACK_VECTOR_UNSPECIFIED": 0,
		"ATTACK_VECTOR_NETWORK":     1,
		"ATTACK_VECTOR_ADJACENT":    2,
		"ATTACK_VECTOR_LOCAL":       3,
		"ATTACK_VECTOR_PHYSICAL":    4,
	}
)

func (x CVSSv3_AttackVector) Enum() *CVSSv3_AttackVector {
	p := new(CVSSv3_AttackVector)
	*p = x
	return p
}

func (x CVSSv3_AttackVector) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CVSSv3_AttackVector) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1_vulnerability_proto_enumTypes[0].Descriptor()
}

func (CVSSv3_AttackVector) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1_vulnerability_proto_enumTypes[0]
}

func (x CVSSv3_AttackVector) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CVSSv3_AttackVector.Descriptor instead.
func (CVSSv3_AttackVector) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_vulnerability_proto_rawDescGZIP(), []int{4, 0}
}

// This metric describes the conditions beyond the attacker's control that
// must exist in order to exploit the vulnerability.
type CVSSv3_AttackComplexity int32

const (
	// Invalid value.
	CVSSv3_ATTACK_COMPLEXITY_UNSPECIFIED CVSSv3_AttackComplexity = 0
	// Specialized access conditions or extenuating circumstances do not exist.
	// An attacker can expect repeatable success when attacking the vulnerable
	// component.
	CVSSv3_ATTACK_COMPLEXITY_LOW CVSSv3_AttackComplexity = 1
	// A successful attack depends on conditions beyond the attacker's control.
	// That is, a successful attack cannot be accomplished at will, but requires
	// the attacker to invest in some measurable amount of effort in preparation
	// or execution against the vulnerable component before a successful attack
	// can be expected.
	CVSSv3_ATTACK_COMPLEXITY_HIGH CVSSv3_AttackComplexity = 2
)

// Enum value maps for CVSSv3_AttackComplexity.
var (
	CVSSv3_AttackComplexity_name = map[int32]string{
		0: "ATTACK_COMPLEXITY_UNSPECIFIED",
		1: "ATTACK_COMPLEXITY_LOW",
		2: "ATTACK_COMPLEXITY_HIGH",
	}
	CVSSv3_AttackComplexity_value = map[string]int32{
		"ATTACK_COMPLEXITY_UNSPECIFIED": 0,
		"ATTACK_COMPLEXITY_LOW":         1,
		"ATTACK_COMPLEXITY_HIGH":        2,
	}
)

func (x CVSSv3_AttackComplexity) Enum() *CVSSv3_AttackComplexity {
	p := new(CVSSv3_AttackComplexity)
	*p = x
	return p
}

func (x CVSSv3_AttackComplexity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CVSSv3_AttackComplexity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1_vulnerability_proto_enumTypes[1].Descriptor()
}

func (CVSSv3_AttackComplexity) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1_vulnerability_proto_enumTypes[1]
}

func (x CVSSv3_AttackComplexity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CVSSv3_AttackComplexity.Descriptor instead.
func (CVSSv3_AttackComplexity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_vulnerability_proto_rawDescGZIP(), []int{4, 1}
}

// This metric describes the level of privileges an attacker must possess
// before successfully exploiting the vulnerability.
type CVSSv3_PrivilegesRequired int32

const (
	// Invalid value.
	CVSSv3_PRIVILEGES_REQUIRED_UNSPECIFIED CVSSv3_PrivilegesRequired = 0
	// The attacker is unauthorized prior to attack, and therefore does not
	// require any access to settings or files of the vulnerable system to
	// carry out an attack.
	CVSSv3_PRIVILEGES_REQUIRED_NONE CVSSv3_PrivilegesRequired = 1
	// The attacker requires privileges that provide basic user capabilities
	// that could normally affect only settings and files owned by a user.
	// Alternatively, an attacker with Low privileges has the ability to access
	// only non-sensitive resources.
	CVSSv3_PRIVILEGES_REQUIRED_LOW CVSSv3_PrivilegesRequired = 2
	// The attacker requires privileges that provide significant (e.g.,
	// administrative) control over the vulnerable component allowing access to
	// component-wide settings and files.
	CVSSv3_PRIVILEGES_REQUIRED_HIGH CVSSv3_PrivilegesRequired = 3
)

// Enum value maps for CVSSv3_PrivilegesRequired.
var (
	CVSSv3_PrivilegesRequired_name = map[int32]string{
		0: "PRIVILEGES_REQUIRED_UNSPECIFIED",
		1: "PRIVILEGES_REQUIRED_NONE",
		2: "PRIVILEGES_REQUIRED_LOW",
		3: "PRIVILEGES_REQUIRED_HIGH",
	}
	CVSSv3_PrivilegesRequired_value = map[string]int32{
		"PRIVILEGES_REQUIRED_UNSPECIFIED": 0,
		"PRIVILEGES_REQUIRED_NONE":        1,
		"PRIVILEGES_REQUIRED_LOW":         2,
		"PRIVILEGES_REQUIRED_HIGH":        3,
	}
)

func (x CVSSv3_PrivilegesRequired) Enum() *CVSSv3_PrivilegesRequired {
	p := new(CVSSv3_PrivilegesRequired)
	*p = x
	return p
}

func (x CVSSv3_PrivilegesRequired) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CVSSv3_PrivilegesRequired) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1_vulnerability_proto_enumTypes[2].Descriptor()
}

func (CVSSv3_PrivilegesRequired) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1_vulnerability_proto_enumTypes[2]
}

func (x CVSSv3_PrivilegesRequired) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CVSSv3_PrivilegesRequired.Descriptor instead.
func (CVSSv3_PrivilegesRequired) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_vulnerability_proto_rawDescGZIP(), []int{4, 2}
}

// This metric captures the requirement for a human user, other than the
// attacker, to participate in the successful compromise of the vulnerable
// component.
type CVSSv3_UserInteraction int32

const (
	// Invalid value.
	CVSSv3_USER_INTERACTION_UNSPECIFIED CVSSv3_UserInteraction = 0
	// The vulnerable system can be exploited without interaction from any user.
	CVSSv3_USER_INTERACTION_NONE CVSSv3_UserInteraction = 1
	// Successful exploitation of this vulnerability requires a user to take
	// some action before the vulnerability can be exploited.
	CVSSv3_USER_INTERACTION_REQUIRED CVSSv3_UserInteraction = 2
)

// Enum value maps for CVSSv3_UserInteraction.
var (
	CVSSv3_UserInteraction_name = map[int32]string{
		0: "USER_INTERACTION_UNSPECIFIED",
		1: "USER_INTERACTION_NONE",
		2: "USER_INTERACTION_REQUIRED",
	}
	CVSSv3_UserInteraction_value = map[string]int32{
		"USER_INTERACTION_UNSPECIFIED": 0,
		"USER_INTERACTION_NONE":        1,
		"USER_INTERACTION_REQUIRED":    2,
	}
)

func (x CVSSv3_UserInteraction) Enum() *CVSSv3_UserInteraction {
	p := new(CVSSv3_UserInteraction)
	*p = x
	return p
}

func (x CVSSv3_UserInteraction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CVSSv3_UserInteraction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1_vulnerability_proto_enumTypes[3].Descriptor()
}

func (CVSSv3_UserInteraction) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1_vulnerability_proto_enumTypes[3]
}

func (x CVSSv3_UserInteraction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CVSSv3_UserInteraction.Descriptor instead.
func (CVSSv3_UserInteraction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_vulnerability_proto_rawDescGZIP(), []int{4, 3}
}

// The Scope metric captures whether a vulnerability in one vulnerable
// component impacts resources in components beyond its security scope.
type CVSSv3_Scope int32

const (
	// Invalid value.
	CVSSv3_SCOPE_UNSPECIFIED CVSSv3_Scope = 0
	// An exploited vulnerability can only affect resources managed by the same
	// security authority.
	CVSSv3_SCOPE_UNCHANGED CVSSv3_Scope = 1
	// An exploited vulnerability can affect resources beyond the security scope
	// managed by the security authority of the vulnerable component.
	CVSSv3_SCOPE_CHANGED CVSSv3_Scope = 2
)

// Enum value maps for CVSSv3_Scope.
var (
	CVSSv3_Scope_name = map[int32]string{
		0: "SCOPE_UNSPECIFIED",
		1: "SCOPE_UNCHANGED",
		2: "SCOPE_CHANGED",
	}
	CVSSv3_Scope_value = map[string]int32{
		"SCOPE_UNSPECIFIED": 0,
		"SCOPE_UNCHANGED":   1,
		"SCOPE_CHANGED":     2,
	}
)

func (x CVSSv3_Scope) Enum() *CVSSv3_Scope {
	p := new(CVSSv3_Scope)
	*p = x
	return p
}

func (x CVSSv3_Scope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CVSSv3_Scope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1_vulnerability_proto_enumTypes[4].Descriptor()
}

func (CVSSv3_Scope) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1_vulnerability_proto_enumTypes[4]
}

func (x CVSSv3_Scope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CVSSv3_Scope.Descriptor instead.
func (CVSSv3_Scope) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_vulnerability_proto_rawDescGZIP(), []int{4, 4}
}

// The Impact metrics capture the effects of a successfully exploited
// vulnerability on the component that suffers the worst outcome that is most
// directly and predictably associated with the attack.
type CVSSv3_Impact int32

const (
	// Invalid value.
	CVSSv3_IMPACT_UNSPECIFIED CVSSv3_Impact = 0
	// High impact.
	CVSSv3_IMPACT_HIGH CVSSv3_Impact = 1
	// Low impact.
	CVSSv3_IMPACT_LOW CVSSv3_Impact = 2
	// No impact.
	CVSSv3_IMPACT_NONE CVSSv3_Impact = 3
)

// Enum value maps for CVSSv3_Impact.
var (
	CVSSv3_Impact_name = map[int32]string{
		0: "IMPACT_UNSPECIFIED",
		1: "IMPACT_HIGH",
		2: "IMPACT_LOW",
		3: "IMPACT_NONE",
	}
	CVSSv3_Impact_value = map[string]int32{
		"IMPACT_UNSPECIFIED": 0,
		"IMPACT_HIGH":        1,
		"IMPACT_LOW":         2,
		"IMPACT_NONE":        3,
	}
)

func (x CVSSv3_Impact) Enum() *CVSSv3_Impact {
	p := new(CVSSv3_Impact)
	*p = x
	return p
}

func (x CVSSv3_Impact) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CVSSv3_Impact) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1_vulnerability_proto_enumTypes[5].Descriptor()
}

func (CVSSv3_Impact) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1_vulnerability_proto_enumTypes[5]
}

func (x CVSSv3_Impact) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CVSSv3_Impact.Descriptor instead.
func (CVSSv3_Impact) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_vulnerability_proto_rawDescGZIP(), []int{4, 5}
}

// This API resource represents the vulnerability report for a specified
// Compute Engine virtual machine (VM) instance at a given point in time.
//
// For more information, see [Vulnerability
// reports](https://cloud.google.com/compute/docs/instances/os-inventory-management#vulnerability-reports).
type VulnerabilityReport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The `vulnerabilityReport` API resource name.
	//
	// Format:
	// `projects/{project_number}/locations/{location}/instances/{instance_id}/vulnerabilityReport`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. List of vulnerabilities affecting the VM.
	Vulnerabilities []*VulnerabilityReport_Vulnerability `protobuf:"bytes,2,rep,name=vulnerabilities,proto3" json:"vulnerabilities,omitempty"`
	// Output only. The timestamp for when the last vulnerability report was generated for the
	// VM.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *VulnerabilityReport) Reset() {
	*x = VulnerabilityReport{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityReport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityReport) ProtoMessage() {}

func (x *VulnerabilityReport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityReport.ProtoReflect.Descriptor instead.
func (*VulnerabilityReport) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_vulnerability_proto_rawDescGZIP(), []int{0}
}

func (x *VulnerabilityReport) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VulnerabilityReport) GetVulnerabilities() []*VulnerabilityReport_Vulnerability {
	if x != nil {
		return x.Vulnerabilities
	}
	return nil
}

func (x *VulnerabilityReport) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// A request message for getting the vulnerability report for the specified VM.
type GetVulnerabilityReportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. API resource name for vulnerability resource.
	//
	// Format:
	// `projects/{project}/locations/{location}/instances/{instance}/vulnerabilityReport`
	//
	// For `{project}`, either `project-number` or `project-id` can be provided.
	// For `{instance}`, either Compute Engine `instance-id` or `instance-name`
	// can be provided.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetVulnerabilityReportRequest) Reset() {
	*x = GetVulnerabilityReportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVulnerabilityReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVulnerabilityReportRequest) ProtoMessage() {}

func (x *GetVulnerabilityReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVulnerabilityReportRequest.ProtoReflect.Descriptor instead.
func (*GetVulnerabilityReportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_vulnerability_proto_rawDescGZIP(), []int{1}
}

func (x *GetVulnerabilityReportRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request message for listing vulnerability reports for all VM instances in
// the specified location.
type ListVulnerabilityReportsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name.
	//
	// Format: `projects/{project}/locations/{location}/instances/-`
	//
	// For `{project}`, either `project-number` or `project-id` can be provided.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A pagination token returned from a previous call to
	// `ListVulnerabilityReports` that indicates where this listing
	// should continue from.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// If provided, this field specifies the criteria that must be met by a
	// `vulnerabilityReport` API resource to be included in the response.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListVulnerabilityReportsRequest) Reset() {
	*x = ListVulnerabilityReportsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVulnerabilityReportsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVulnerabilityReportsRequest) ProtoMessage() {}

func (x *ListVulnerabilityReportsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVulnerabilityReportsRequest.ProtoReflect.Descriptor instead.
func (*ListVulnerabilityReportsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_vulnerability_proto_rawDescGZIP(), []int{2}
}

func (x *ListVulnerabilityReportsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListVulnerabilityReportsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListVulnerabilityReportsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListVulnerabilityReportsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// A response message for listing vulnerability reports for all VM instances in
// the specified location.
type ListVulnerabilityReportsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of vulnerabilityReport objects.
	VulnerabilityReports []*VulnerabilityReport `protobuf:"bytes,1,rep,name=vulnerability_reports,json=vulnerabilityReports,proto3" json:"vulnerability_reports,omitempty"`
	// The pagination token to retrieve the next page of vulnerabilityReports
	// object.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListVulnerabilityReportsResponse) Reset() {
	*x = ListVulnerabilityReportsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVulnerabilityReportsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVulnerabilityReportsResponse) ProtoMessage() {}

func (x *ListVulnerabilityReportsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVulnerabilityReportsResponse.ProtoReflect.Descriptor instead.
func (*ListVulnerabilityReportsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_vulnerability_proto_rawDescGZIP(), []int{3}
}

func (x *ListVulnerabilityReportsResponse) GetVulnerabilityReports() []*VulnerabilityReport {
	if x != nil {
		return x.VulnerabilityReports
	}
	return nil
}

func (x *ListVulnerabilityReportsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Common Vulnerability Scoring System version 3.
// For details, see https://www.first.org/cvss/specification-document
type CVSSv3 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The base score is a function of the base metric scores.
	// https://www.first.org/cvss/specification-document#Base-Metrics
	BaseScore float32 `protobuf:"fixed32,1,opt,name=base_score,json=baseScore,proto3" json:"base_score,omitempty"`
	// The Exploitability sub-score equation is derived from the Base
	// Exploitability metrics.
	// https://www.first.org/cvss/specification-document#2-1-Exploitability-Metrics
	ExploitabilityScore float32 `protobuf:"fixed32,2,opt,name=exploitability_score,json=exploitabilityScore,proto3" json:"exploitability_score,omitempty"`
	// The Impact sub-score equation is derived from the Base Impact metrics.
	ImpactScore float32 `protobuf:"fixed32,3,opt,name=impact_score,json=impactScore,proto3" json:"impact_score,omitempty"`
	// This metric reflects the context by which vulnerability exploitation is
	// possible.
	AttackVector CVSSv3_AttackVector `protobuf:"varint,5,opt,name=attack_vector,json=attackVector,proto3,enum=google.cloud.osconfig.v1.CVSSv3_AttackVector" json:"attack_vector,omitempty"`
	// This metric describes the conditions beyond the attacker's control that
	// must exist in order to exploit the vulnerability.
	AttackComplexity CVSSv3_AttackComplexity `protobuf:"varint,6,opt,name=attack_complexity,json=attackComplexity,proto3,enum=google.cloud.osconfig.v1.CVSSv3_AttackComplexity" json:"attack_complexity,omitempty"`
	// This metric describes the level of privileges an attacker must possess
	// before successfully exploiting the vulnerability.
	PrivilegesRequired CVSSv3_PrivilegesRequired `protobuf:"varint,7,opt,name=privileges_required,json=privilegesRequired,proto3,enum=google.cloud.osconfig.v1.CVSSv3_PrivilegesRequired" json:"privileges_required,omitempty"`
	// This metric captures the requirement for a human user, other than the
	// attacker, to participate in the successful compromise of the vulnerable
	// component.
	UserInteraction CVSSv3_UserInteraction `protobuf:"varint,8,opt,name=user_interaction,json=userInteraction,proto3,enum=google.cloud.osconfig.v1.CVSSv3_UserInteraction" json:"user_interaction,omitempty"`
	// The Scope metric captures whether a vulnerability in one vulnerable
	// component impacts resources in components beyond its security scope.
	Scope CVSSv3_Scope `protobuf:"varint,9,opt,name=scope,proto3,enum=google.cloud.osconfig.v1.CVSSv3_Scope" json:"scope,omitempty"`
	// This metric measures the impact to the confidentiality of the information
	// resources managed by a software component due to a successfully exploited
	// vulnerability.
	ConfidentialityImpact CVSSv3_Impact `protobuf:"varint,10,opt,name=confidentiality_impact,json=confidentialityImpact,proto3,enum=google.cloud.osconfig.v1.CVSSv3_Impact" json:"confidentiality_impact,omitempty"`
	// This metric measures the impact to integrity of a successfully exploited
	// vulnerability.
	IntegrityImpact CVSSv3_Impact `protobuf:"varint,11,opt,name=integrity_impact,json=integrityImpact,proto3,enum=google.cloud.osconfig.v1.CVSSv3_Impact" json:"integrity_impact,omitempty"`
	// This metric measures the impact to the availability of the impacted
	// component resulting from a successfully exploited vulnerability.
	AvailabilityImpact CVSSv3_Impact `protobuf:"varint,12,opt,name=availability_impact,json=availabilityImpact,proto3,enum=google.cloud.osconfig.v1.CVSSv3_Impact" json:"availability_impact,omitempty"`
}

func (x *CVSSv3) Reset() {
	*x = CVSSv3{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CVSSv3) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CVSSv3) ProtoMessage() {}

func (x *CVSSv3) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CVSSv3.ProtoReflect.Descriptor instead.
func (*CVSSv3) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_vulnerability_proto_rawDescGZIP(), []int{4}
}

func (x *CVSSv3) GetBaseScore() float32 {
	if x != nil {
		return x.BaseScore
	}
	return 0
}

func (x *CVSSv3) GetExploitabilityScore() float32 {
	if x != nil {
		return x.ExploitabilityScore
	}
	return 0
}

func (x *CVSSv3) GetImpactScore() float32 {
	if x != nil {
		return x.ImpactScore
	}
	return 0
}

func (x *CVSSv3) GetAttackVector() CVSSv3_AttackVector {
	if x != nil {
		return x.AttackVector
	}
	return CVSSv3_ATTACK_VECTOR_UNSPECIFIED
}

func (x *CVSSv3) GetAttackComplexity() CVSSv3_AttackComplexity {
	if x != nil {
		return x.AttackComplexity
	}
	return CVSSv3_ATTACK_COMPLEXITY_UNSPECIFIED
}

func (x *CVSSv3) GetPrivilegesRequired() CVSSv3_PrivilegesRequired {
	if x != nil {
		return x.PrivilegesRequired
	}
	return CVSSv3_PRIVILEGES_REQUIRED_UNSPECIFIED
}

func (x *CVSSv3) GetUserInteraction() CVSSv3_UserInteraction {
	if x != nil {
		return x.UserInteraction
	}
	return CVSSv3_USER_INTERACTION_UNSPECIFIED
}

func (x *CVSSv3) GetScope() CVSSv3_Scope {
	if x != nil {
		return x.Scope
	}
	return CVSSv3_SCOPE_UNSPECIFIED
}

func (x *CVSSv3) GetConfidentialityImpact() CVSSv3_Impact {
	if x != nil {
		return x.ConfidentialityImpact
	}
	return CVSSv3_IMPACT_UNSPECIFIED
}

func (x *CVSSv3) GetIntegrityImpact() CVSSv3_Impact {
	if x != nil {
		return x.IntegrityImpact
	}
	return CVSSv3_IMPACT_UNSPECIFIED
}

func (x *CVSSv3) GetAvailabilityImpact() CVSSv3_Impact {
	if x != nil {
		return x.AvailabilityImpact
	}
	return CVSSv3_IMPACT_UNSPECIFIED
}

// A vulnerability affecting the VM instance.
type VulnerabilityReport_Vulnerability struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains metadata as per the upstream feed of the operating system and
	// NVD.
	Details *VulnerabilityReport_Vulnerability_Details `protobuf:"bytes,1,opt,name=details,proto3" json:"details,omitempty"`
	// Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
	// This field displays the inventory items affected by this vulnerability.
	// If the vulnerability report was not updated after the VM inventory
	// update, these values might not display in VM inventory. For some distros,
	// this field may be empty.
	//
	// Deprecated: Do not use.
	InstalledInventoryItemIds []string `protobuf:"bytes,2,rep,name=installed_inventory_item_ids,json=installedInventoryItemIds,proto3" json:"installed_inventory_item_ids,omitempty"`
	// Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
	// If the vulnerability report was not updated after the VM inventory
	// update, these values might not display in VM inventory. If there is no
	// available fix, the field is empty. The `inventory_item` value specifies
	// the latest `SoftwarePackage` available to the VM that fixes the
	// vulnerability.
	//
	// Deprecated: Do not use.
	AvailableInventoryItemIds []string `protobuf:"bytes,3,rep,name=available_inventory_item_ids,json=availableInventoryItemIds,proto3" json:"available_inventory_item_ids,omitempty"`
	// The timestamp for when the vulnerability was first detected.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The timestamp for when the vulnerability was last modified.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// List of items affected by the vulnerability.
	Items []*VulnerabilityReport_Vulnerability_Item `protobuf:"bytes,6,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *VulnerabilityReport_Vulnerability) Reset() {
	*x = VulnerabilityReport_Vulnerability{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityReport_Vulnerability) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityReport_Vulnerability) ProtoMessage() {}

func (x *VulnerabilityReport_Vulnerability) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityReport_Vulnerability.ProtoReflect.Descriptor instead.
func (*VulnerabilityReport_Vulnerability) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_vulnerability_proto_rawDescGZIP(), []int{0, 0}
}

func (x *VulnerabilityReport_Vulnerability) GetDetails() *VulnerabilityReport_Vulnerability_Details {
	if x != nil {
		return x.Details
	}
	return nil
}

// Deprecated: Do not use.
func (x *VulnerabilityReport_Vulnerability) GetInstalledInventoryItemIds() []string {
	if x != nil {
		return x.InstalledInventoryItemIds
	}
	return nil
}

// Deprecated: Do not use.
func (x *VulnerabilityReport_Vulnerability) GetAvailableInventoryItemIds() []string {
	if x != nil {
		return x.AvailableInventoryItemIds
	}
	return nil
}

func (x *VulnerabilityReport_Vulnerability) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *VulnerabilityReport_Vulnerability) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *VulnerabilityReport_Vulnerability) GetItems() []*VulnerabilityReport_Vulnerability_Item {
	if x != nil {
		return x.Items
	}
	return nil
}

// Contains metadata information for the vulnerability. This information is
// collected from the upstream feed of the operating system.
type VulnerabilityReport_Vulnerability_Details struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The CVE of the vulnerability. CVE cannot be
	// empty and the combination of <cve, classification> should be unique
	// across vulnerabilities for a VM.
	Cve string `protobuf:"bytes,1,opt,name=cve,proto3" json:"cve,omitempty"`
	// The CVSS V2 score of this vulnerability. CVSS V2 score is on a scale of
	// 0 - 10 where 0 indicates low severity and 10 indicates high severity.
	CvssV2Score float32 `protobuf:"fixed32,2,opt,name=cvss_v2_score,json=cvssV2Score,proto3" json:"cvss_v2_score,omitempty"`
	// The full description of the CVSSv3 for this vulnerability from NVD.
	CvssV3 *CVSSv3 `protobuf:"bytes,3,opt,name=cvss_v3,json=cvssV3,proto3" json:"cvss_v3,omitempty"`
	// Assigned severity/impact ranking from the distro.
	Severity string `protobuf:"bytes,4,opt,name=severity,proto3" json:"severity,omitempty"`
	// The note or description describing the vulnerability from the distro.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Corresponds to the references attached to the `VulnerabilityDetails`.
	References []*VulnerabilityReport_Vulnerability_Details_Reference `protobuf:"bytes,6,rep,name=references,proto3" json:"references,omitempty"`
}

func (x *VulnerabilityReport_Vulnerability_Details) Reset() {
	*x = VulnerabilityReport_Vulnerability_Details{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityReport_Vulnerability_Details) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityReport_Vulnerability_Details) ProtoMessage() {}

func (x *VulnerabilityReport_Vulnerability_Details) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityReport_Vulnerability_Details.ProtoReflect.Descriptor instead.
func (*VulnerabilityReport_Vulnerability_Details) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_vulnerability_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *VulnerabilityReport_Vulnerability_Details) GetCve() string {
	if x != nil {
		return x.Cve
	}
	return ""
}

func (x *VulnerabilityReport_Vulnerability_Details) GetCvssV2Score() float32 {
	if x != nil {
		return x.CvssV2Score
	}
	return 0
}

func (x *VulnerabilityReport_Vulnerability_Details) GetCvssV3() *CVSSv3 {
	if x != nil {
		return x.CvssV3
	}
	return nil
}

func (x *VulnerabilityReport_Vulnerability_Details) GetSeverity() string {
	if x != nil {
		return x.Severity
	}
	return ""
}

func (x *VulnerabilityReport_Vulnerability_Details) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *VulnerabilityReport_Vulnerability_Details) GetReferences() []*VulnerabilityReport_Vulnerability_Details_Reference {
	if x != nil {
		return x.References
	}
	return nil
}

// OS inventory item that is affected by a vulnerability or fixed as a
// result of a vulnerability.
type VulnerabilityReport_Vulnerability_Item struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
	// This field displays the inventory items affected by this vulnerability.
	// If the vulnerability report was not updated after the VM inventory
	// update, these values might not display in VM inventory. For some
	// operating systems, this field might be empty.
	InstalledInventoryItemId string `protobuf:"bytes,1,opt,name=installed_inventory_item_id,json=installedInventoryItemId,proto3" json:"installed_inventory_item_id,omitempty"`
	// Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
	// If the vulnerability report was not updated after the VM inventory
	// update, these values might not display in VM inventory. If there is no
	// available fix, the field is empty. The `inventory_item` value specifies
	// the latest `SoftwarePackage` available to the VM that fixes the
	// vulnerability.
	AvailableInventoryItemId string `protobuf:"bytes,2,opt,name=available_inventory_item_id,json=availableInventoryItemId,proto3" json:"available_inventory_item_id,omitempty"`
	// The recommended [CPE URI](https://cpe.mitre.org/specification/) update
	// that contains a fix for this vulnerability.
	FixedCpeUri string `protobuf:"bytes,3,opt,name=fixed_cpe_uri,json=fixedCpeUri,proto3" json:"fixed_cpe_uri,omitempty"`
	// The upstream OS patch, packages or KB that fixes the vulnerability.
	UpstreamFix string `protobuf:"bytes,4,opt,name=upstream_fix,json=upstreamFix,proto3" json:"upstream_fix,omitempty"`
}

func (x *VulnerabilityReport_Vulnerability_Item) Reset() {
	*x = VulnerabilityReport_Vulnerability_Item{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityReport_Vulnerability_Item) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityReport_Vulnerability_Item) ProtoMessage() {}

func (x *VulnerabilityReport_Vulnerability_Item) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityReport_Vulnerability_Item.ProtoReflect.Descriptor instead.
func (*VulnerabilityReport_Vulnerability_Item) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_vulnerability_proto_rawDescGZIP(), []int{0, 0, 1}
}

func (x *VulnerabilityReport_Vulnerability_Item) GetInstalledInventoryItemId() string {
	if x != nil {
		return x.InstalledInventoryItemId
	}
	return ""
}

func (x *VulnerabilityReport_Vulnerability_Item) GetAvailableInventoryItemId() string {
	if x != nil {
		return x.AvailableInventoryItemId
	}
	return ""
}

func (x *VulnerabilityReport_Vulnerability_Item) GetFixedCpeUri() string {
	if x != nil {
		return x.FixedCpeUri
	}
	return ""
}

func (x *VulnerabilityReport_Vulnerability_Item) GetUpstreamFix() string {
	if x != nil {
		return x.UpstreamFix
	}
	return ""
}

// A reference for this vulnerability.
type VulnerabilityReport_Vulnerability_Details_Reference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The url of the reference.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// The source of the reference e.g. NVD.
	Source string `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
}

func (x *VulnerabilityReport_Vulnerability_Details_Reference) Reset() {
	*x = VulnerabilityReport_Vulnerability_Details_Reference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityReport_Vulnerability_Details_Reference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityReport_Vulnerability_Details_Reference) ProtoMessage() {}

func (x *VulnerabilityReport_Vulnerability_Details_Reference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityReport_Vulnerability_Details_Reference.ProtoReflect.Descriptor instead.
func (*VulnerabilityReport_Vulnerability_Details_Reference) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_vulnerability_proto_rawDescGZIP(), []int{0, 0, 0, 0}
}

func (x *VulnerabilityReport_Vulnerability_Details_Reference) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *VulnerabilityReport_Vulnerability_Details_Reference) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

var File_google_cloud_osconfig_v1_vulnerability_proto protoreflect.FileDescriptor

var file_google_cloud_osconfig_v1_vulnerability_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x75, 0x6c, 0x6e, 0x65,
	0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xdd, 0x0a, 0x0a, 0x13, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x6a, 0x0a, 0x0f, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65,
	0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x56,
	0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0f, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x1a, 0xf9, 0x07, 0x0a, 0x0d, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x5d, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x2e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x07, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x43, 0x0a, 0x1c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c,
	0x65, 0x64, 0x5f, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x74, 0x65,
	0x6d, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x19, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74,
	0x6f, 0x72, 0x79, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x73, 0x12, 0x43, 0x0a, 0x1c, 0x61, 0x76,
	0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72,
	0x79, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x19, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x49,
	0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x73, 0x12,
	0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x56, 0x0a, 0x05, 0x69, 0x74, 0x65,
	0x6d, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d,
	0x73, 0x1a, 0xde, 0x02, 0x0a, 0x07, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x10, 0x0a,
	0x03, 0x63, 0x76, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x63, 0x76, 0x65, 0x12,
	0x22, 0x0a, 0x0d, 0x63, 0x76, 0x73, 0x73, 0x5f, 0x76, 0x32, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0b, 0x63, 0x76, 0x73, 0x73, 0x56, 0x32, 0x53, 0x63,
	0x6f, 0x72, 0x65, 0x12, 0x39, 0x0a, 0x07, 0x63, 0x76, 0x73, 0x73, 0x5f, 0x76, 0x33, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x56, 0x53, 0x53, 0x76, 0x33, 0x52, 0x06, 0x63, 0x76, 0x73, 0x73, 0x56, 0x33, 0x12, 0x1a,
	0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6d, 0x0a, 0x0a,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x75, 0x6c, 0x6e,
	0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2e,
	0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52,
	0x0a, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x1a, 0x35, 0x0a, 0x09, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x1a, 0xcb, 0x01, 0x0a, 0x04, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x3d, 0x0a, 0x1b, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f,
	0x72, 0x79, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x18, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x49, 0x6e, 0x76, 0x65, 0x6e,
	0x74, 0x6f, 0x72, 0x79, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x12, 0x3d, 0x0a, 0x1b, 0x61, 0x76,
	0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72,
	0x79, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x18, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74,
	0x6f, 0x72, 0x79, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0d, 0x66, 0x69, 0x78,
	0x65, 0x64, 0x5f, 0x63, 0x70, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x66, 0x69, 0x78, 0x65, 0x64, 0x43, 0x70, 0x65, 0x55, 0x72, 0x69, 0x12, 0x21, 0x0a,
	0x0c, 0x75, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x66, 0x69, 0x78, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x46, 0x69, 0x78,
	0x3a, 0x82, 0x01, 0xea, 0x41, 0x7f, 0x0a, 0x2b, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x12, 0x50, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x7d, 0x2f, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x68, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x56, 0x75, 0x6c, 0x6e,
	0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xb6, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x63, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xae, 0x01, 0x0a, 0x20, 0x4c, 0x69, 0x73,
	0x74, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x62, 0x0a,
	0x15, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x14, 0x76, 0x75, 0x6c,
	0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xea, 0x0b, 0x0a, 0x06, 0x43, 0x56,
	0x53, 0x53, 0x76, 0x33, 0x12, 0x1d, 0x0a, 0x0a, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x63, 0x6f,
	0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09, 0x62, 0x61, 0x73, 0x65, 0x53, 0x63,
	0x6f, 0x72, 0x65, 0x12, 0x31, 0x0a, 0x14, 0x65, 0x78, 0x70, 0x6c, 0x6f, 0x69, 0x74, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x13, 0x65, 0x78, 0x70, 0x6c, 0x6f, 0x69, 0x74, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x6d, 0x70, 0x61, 0x63, 0x74,
	0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0b, 0x69, 0x6d,
	0x70, 0x61, 0x63, 0x74, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x52, 0x0a, 0x0d, 0x61, 0x74, 0x74,
	0x61, 0x63, 0x6b, 0x5f, 0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x56, 0x53, 0x53,
	0x76, 0x33, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52,
	0x0c, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x5e, 0x0a,
	0x11, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x69,
	0x74, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x56, 0x53, 0x53, 0x76, 0x33, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x6b, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x69, 0x74, 0x79, 0x52, 0x10, 0x61, 0x74, 0x74,
	0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x69, 0x74, 0x79, 0x12, 0x64, 0x0a,
	0x13, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x56, 0x53, 0x53, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x69,
	0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x52,
	0x12, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x64, 0x12, 0x5b, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x56, 0x53, 0x53, 0x76, 0x33, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0f, 0x75, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x3c, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x56, 0x53, 0x53, 0x76,
	0x33, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x5e,
	0x0a, 0x16, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x5f, 0x69, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x56, 0x53, 0x53, 0x76, 0x33,
	0x2e, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x52, 0x15, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x12, 0x52,
	0x0a, 0x10, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x6d, 0x70, 0x61,
	0x63, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x56, 0x53, 0x53, 0x76, 0x33, 0x2e, 0x49, 0x6d, 0x70, 0x61, 0x63,
	0x74, 0x52, 0x0f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x69, 0x74, 0x79, 0x49, 0x6d, 0x70, 0x61,
	0x63, 0x74, 0x12, 0x58, 0x0a, 0x13, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x5f, 0x69, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x56, 0x53, 0x53, 0x76,
	0x33, 0x2e, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x52, 0x12, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x22, 0x99, 0x01, 0x0a,
	0x0c, 0x41, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x1d, 0x0a,
	0x19, 0x41, 0x54, 0x54, 0x41, 0x43, 0x4b, 0x5f, 0x56, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15,
	0x41, 0x54, 0x54, 0x41, 0x43, 0x4b, 0x5f, 0x56, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x4e, 0x45,
	0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x54, 0x54, 0x41, 0x43,
	0x4b, 0x5f, 0x56, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x41, 0x44, 0x4a, 0x41, 0x43, 0x45, 0x4e,
	0x54, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x54, 0x54, 0x41, 0x43, 0x4b, 0x5f, 0x56, 0x45,
	0x43, 0x54, 0x4f, 0x52, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x10, 0x03, 0x12, 0x1a, 0x0a, 0x16,
	0x41, 0x54, 0x54, 0x41, 0x43, 0x4b, 0x5f, 0x56, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x50, 0x48,
	0x59, 0x53, 0x49, 0x43, 0x41, 0x4c, 0x10, 0x04, 0x22, 0x6c, 0x0a, 0x10, 0x41, 0x74, 0x74, 0x61,
	0x63, 0x6b, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x69, 0x74, 0x79, 0x12, 0x21, 0x0a, 0x1d,
	0x41, 0x54, 0x54, 0x41, 0x43, 0x4b, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x58, 0x49, 0x54,
	0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x19, 0x0a, 0x15, 0x41, 0x54, 0x54, 0x41, 0x43, 0x4b, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45,
	0x58, 0x49, 0x54, 0x59, 0x5f, 0x4c, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x54,
	0x54, 0x41, 0x43, 0x4b, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x58, 0x49, 0x54, 0x59, 0x5f,
	0x48, 0x49, 0x47, 0x48, 0x10, 0x02, 0x22, 0x92, 0x01, 0x0a, 0x12, 0x50, 0x72, 0x69, 0x76, 0x69,
	0x6c, 0x65, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x12, 0x23, 0x0a,
	0x1f, 0x50, 0x52, 0x49, 0x56, 0x49, 0x4c, 0x45, 0x47, 0x45, 0x53, 0x5f, 0x52, 0x45, 0x51, 0x55,
	0x49, 0x52, 0x45, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x52, 0x49, 0x56, 0x49, 0x4c, 0x45, 0x47, 0x45, 0x53,
	0x5f, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01,
	0x12, 0x1b, 0x0a, 0x17, 0x50, 0x52, 0x49, 0x56, 0x49, 0x4c, 0x45, 0x47, 0x45, 0x53, 0x5f, 0x52,
	0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x5f, 0x4c, 0x4f, 0x57, 0x10, 0x02, 0x12, 0x1c, 0x0a,
	0x18, 0x50, 0x52, 0x49, 0x56, 0x49, 0x4c, 0x45, 0x47, 0x45, 0x53, 0x5f, 0x52, 0x45, 0x51, 0x55,
	0x49, 0x52, 0x45, 0x44, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x10, 0x03, 0x22, 0x6d, 0x0a, 0x0f, 0x55,
	0x73, 0x65, 0x72, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20,
	0x0a, 0x1c, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x41, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x19, 0x0a, 0x15, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x41, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x55,
	0x53, 0x45, 0x52, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x10, 0x02, 0x22, 0x46, 0x0a, 0x05, 0x53, 0x63,
	0x6f, 0x70, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x43, 0x4f, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x43,
	0x4f, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x44, 0x10, 0x01, 0x12,
	0x11, 0x0a, 0x0d, 0x53, 0x43, 0x4f, 0x50, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x44,
	0x10, 0x02, 0x22, 0x52, 0x0a, 0x06, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x12, 0x16, 0x0a, 0x12,
	0x49, 0x4d, 0x50, 0x41, 0x43, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4d, 0x50, 0x41, 0x43, 0x54, 0x5f, 0x48,
	0x49, 0x47, 0x48, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x4d, 0x50, 0x41, 0x43, 0x54, 0x5f,
	0x4c, 0x4f, 0x57, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4d, 0x50, 0x41, 0x43, 0x54, 0x5f,
	0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x03, 0x42, 0xca, 0x01, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x42, 0x12, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x40, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2f, 0x76, 0x31, 0x3b, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0xaa,
	0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4f,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4f, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_osconfig_v1_vulnerability_proto_rawDescOnce sync.Once
	file_google_cloud_osconfig_v1_vulnerability_proto_rawDescData = file_google_cloud_osconfig_v1_vulnerability_proto_rawDesc
)

func file_google_cloud_osconfig_v1_vulnerability_proto_rawDescGZIP() []byte {
	file_google_cloud_osconfig_v1_vulnerability_proto_rawDescOnce.Do(func() {
		file_google_cloud_osconfig_v1_vulnerability_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_osconfig_v1_vulnerability_proto_rawDescData)
	})
	return file_google_cloud_osconfig_v1_vulnerability_proto_rawDescData
}

var file_google_cloud_osconfig_v1_vulnerability_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_osconfig_v1_vulnerability_proto_goTypes = []interface{}{
	(CVSSv3_AttackVector)(0),                                    // 0: google.cloud.osconfig.v1.CVSSv3.AttackVector
	(CVSSv3_AttackComplexity)(0),                                // 1: google.cloud.osconfig.v1.CVSSv3.AttackComplexity
	(CVSSv3_PrivilegesRequired)(0),                              // 2: google.cloud.osconfig.v1.CVSSv3.PrivilegesRequired
	(CVSSv3_UserInteraction)(0),                                 // 3: google.cloud.osconfig.v1.CVSSv3.UserInteraction
	(CVSSv3_Scope)(0),                                           // 4: google.cloud.osconfig.v1.CVSSv3.Scope
	(CVSSv3_Impact)(0),                                          // 5: google.cloud.osconfig.v1.CVSSv3.Impact
	(*VulnerabilityReport)(nil),                                 // 6: google.cloud.osconfig.v1.VulnerabilityReport
	(*GetVulnerabilityReportRequest)(nil),                       // 7: google.cloud.osconfig.v1.GetVulnerabilityReportRequest
	(*ListVulnerabilityReportsRequest)(nil),                     // 8: google.cloud.osconfig.v1.ListVulnerabilityReportsRequest
	(*ListVulnerabilityReportsResponse)(nil),                    // 9: google.cloud.osconfig.v1.ListVulnerabilityReportsResponse
	(*CVSSv3)(nil),                                              // 10: google.cloud.osconfig.v1.CVSSv3
	(*VulnerabilityReport_Vulnerability)(nil),                   // 11: google.cloud.osconfig.v1.VulnerabilityReport.Vulnerability
	(*VulnerabilityReport_Vulnerability_Details)(nil),           // 12: google.cloud.osconfig.v1.VulnerabilityReport.Vulnerability.Details
	(*VulnerabilityReport_Vulnerability_Item)(nil),              // 13: google.cloud.osconfig.v1.VulnerabilityReport.Vulnerability.Item
	(*VulnerabilityReport_Vulnerability_Details_Reference)(nil), // 14: google.cloud.osconfig.v1.VulnerabilityReport.Vulnerability.Details.Reference
	(*timestamppb.Timestamp)(nil),                               // 15: google.protobuf.Timestamp
}
var file_google_cloud_osconfig_v1_vulnerability_proto_depIdxs = []int32{
	11, // 0: google.cloud.osconfig.v1.VulnerabilityReport.vulnerabilities:type_name -> google.cloud.osconfig.v1.VulnerabilityReport.Vulnerability
	15, // 1: google.cloud.osconfig.v1.VulnerabilityReport.update_time:type_name -> google.protobuf.Timestamp
	6,  // 2: google.cloud.osconfig.v1.ListVulnerabilityReportsResponse.vulnerability_reports:type_name -> google.cloud.osconfig.v1.VulnerabilityReport
	0,  // 3: google.cloud.osconfig.v1.CVSSv3.attack_vector:type_name -> google.cloud.osconfig.v1.CVSSv3.AttackVector
	1,  // 4: google.cloud.osconfig.v1.CVSSv3.attack_complexity:type_name -> google.cloud.osconfig.v1.CVSSv3.AttackComplexity
	2,  // 5: google.cloud.osconfig.v1.CVSSv3.privileges_required:type_name -> google.cloud.osconfig.v1.CVSSv3.PrivilegesRequired
	3,  // 6: google.cloud.osconfig.v1.CVSSv3.user_interaction:type_name -> google.cloud.osconfig.v1.CVSSv3.UserInteraction
	4,  // 7: google.cloud.osconfig.v1.CVSSv3.scope:type_name -> google.cloud.osconfig.v1.CVSSv3.Scope
	5,  // 8: google.cloud.osconfig.v1.CVSSv3.confidentiality_impact:type_name -> google.cloud.osconfig.v1.CVSSv3.Impact
	5,  // 9: google.cloud.osconfig.v1.CVSSv3.integrity_impact:type_name -> google.cloud.osconfig.v1.CVSSv3.Impact
	5,  // 10: google.cloud.osconfig.v1.CVSSv3.availability_impact:type_name -> google.cloud.osconfig.v1.CVSSv3.Impact
	12, // 11: google.cloud.osconfig.v1.VulnerabilityReport.Vulnerability.details:type_name -> google.cloud.osconfig.v1.VulnerabilityReport.Vulnerability.Details
	15, // 12: google.cloud.osconfig.v1.VulnerabilityReport.Vulnerability.create_time:type_name -> google.protobuf.Timestamp
	15, // 13: google.cloud.osconfig.v1.VulnerabilityReport.Vulnerability.update_time:type_name -> google.protobuf.Timestamp
	13, // 14: google.cloud.osconfig.v1.VulnerabilityReport.Vulnerability.items:type_name -> google.cloud.osconfig.v1.VulnerabilityReport.Vulnerability.Item
	10, // 15: google.cloud.osconfig.v1.VulnerabilityReport.Vulnerability.Details.cvss_v3:type_name -> google.cloud.osconfig.v1.CVSSv3
	14, // 16: google.cloud.osconfig.v1.VulnerabilityReport.Vulnerability.Details.references:type_name -> google.cloud.osconfig.v1.VulnerabilityReport.Vulnerability.Details.Reference
	17, // [17:17] is the sub-list for method output_type
	17, // [17:17] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_google_cloud_osconfig_v1_vulnerability_proto_init() }
func file_google_cloud_osconfig_v1_vulnerability_proto_init() {
	if File_google_cloud_osconfig_v1_vulnerability_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityReport); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVulnerabilityReportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVulnerabilityReportsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVulnerabilityReportsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CVSSv3); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityReport_Vulnerability); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityReport_Vulnerability_Details); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityReport_Vulnerability_Item); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityReport_Vulnerability_Details_Reference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_osconfig_v1_vulnerability_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_osconfig_v1_vulnerability_proto_goTypes,
		DependencyIndexes: file_google_cloud_osconfig_v1_vulnerability_proto_depIdxs,
		EnumInfos:         file_google_cloud_osconfig_v1_vulnerability_proto_enumTypes,
		MessageInfos:      file_google_cloud_osconfig_v1_vulnerability_proto_msgTypes,
	}.Build()
	File_google_cloud_osconfig_v1_vulnerability_proto = out.File
	file_google_cloud_osconfig_v1_vulnerability_proto_rawDesc = nil
	file_google_cloud_osconfig_v1_vulnerability_proto_goTypes = nil
	file_google_cloud_osconfig_v1_vulnerability_proto_depIdxs = nil
}
