// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudtrace/v1/trace.proto

#include "google/cloud/trace/v1/internal/trace_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace trace_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

TraceServiceTracingStub::TraceServiceTracingStub(
    std::shared_ptr<TraceServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::devtools::cloudtrace::v1::ListTracesResponse>
TraceServiceTracingStub::ListTraces(
    grpc::ClientContext& context,
    google::devtools::cloudtrace::v1::ListTracesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.devtools.cloudtrace.v1.TraceService", "ListTraces");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListTraces(context, request));
}

StatusOr<google::devtools::cloudtrace::v1::Trace>
TraceServiceTracingStub::GetTrace(
    grpc::ClientContext& context,
    google::devtools::cloudtrace::v1::GetTraceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.devtools.cloudtrace.v1.TraceService", "GetTrace");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span, child_->GetTrace(context, request));
}

Status TraceServiceTracingStub::PatchTraces(
    grpc::ClientContext& context,
    google::devtools::cloudtrace::v1::PatchTracesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.devtools.cloudtrace.v1.TraceService", "PatchTraces");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->PatchTraces(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<TraceServiceStub> MakeTraceServiceTracingStub(
    std::shared_ptr<TraceServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<TraceServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace trace_v1_internal
}  // namespace cloud
}  // namespace google
