// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/recommender/v1/recommender_service.proto

#include "google/cloud/recommender/v1/internal/recommender_connection_impl.h"
#include "google/cloud/recommender/v1/internal/recommender_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace recommender_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<recommender_v1::RecommenderRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<recommender_v1::RecommenderRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<recommender_v1::RecommenderBackoffPolicyOption>()->clone();
}

std::unique_ptr<recommender_v1::RecommenderConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<recommender_v1::RecommenderConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

RecommenderConnectionImpl::RecommenderConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<recommender_v1_internal::RecommenderStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      RecommenderConnection::options())) {}

StreamRange<google::cloud::recommender::v1::Insight>
RecommenderConnectionImpl::ListInsights(
    google::cloud::recommender::v1::ListInsightsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListInsights(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::recommender::v1::Insight>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<recommender_v1::RecommenderRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::recommender::v1::ListInsightsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::recommender::v1::ListInsightsRequest const&
                       request) {
              return stub->ListInsights(context, request);
            },
            r, function_name);
      },
      [](google::cloud::recommender::v1::ListInsightsResponse r) {
        std::vector<google::cloud::recommender::v1::Insight> result(
            r.insights().size());
        auto& messages = *r.mutable_insights();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::recommender::v1::Insight>
RecommenderConnectionImpl::GetInsight(
    google::cloud::recommender::v1::GetInsightRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetInsight(request),
      [this](grpc::ClientContext& context,
             google::cloud::recommender::v1::GetInsightRequest const& request) {
        return stub_->GetInsight(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::recommender::v1::Insight>
RecommenderConnectionImpl::MarkInsightAccepted(
    google::cloud::recommender::v1::MarkInsightAcceptedRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->MarkInsightAccepted(request),
      [this](grpc::ClientContext& context,
             google::cloud::recommender::v1::MarkInsightAcceptedRequest const&
                 request) {
        return stub_->MarkInsightAccepted(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::recommender::v1::Recommendation>
RecommenderConnectionImpl::ListRecommendations(
    google::cloud::recommender::v1::ListRecommendationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListRecommendations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::recommender::v1::Recommendation>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<recommender_v1::RecommenderRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::recommender::v1::ListRecommendationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::recommender::v1::
                       ListRecommendationsRequest const& request) {
              return stub->ListRecommendations(context, request);
            },
            r, function_name);
      },
      [](google::cloud::recommender::v1::ListRecommendationsResponse r) {
        std::vector<google::cloud::recommender::v1::Recommendation> result(
            r.recommendations().size());
        auto& messages = *r.mutable_recommendations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::recommender::v1::Recommendation>
RecommenderConnectionImpl::GetRecommendation(
    google::cloud::recommender::v1::GetRecommendationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetRecommendation(request),
      [this](grpc::ClientContext& context,
             google::cloud::recommender::v1::GetRecommendationRequest const&
                 request) {
        return stub_->GetRecommendation(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::recommender::v1::Recommendation>
RecommenderConnectionImpl::MarkRecommendationDismissed(
    google::cloud::recommender::v1::MarkRecommendationDismissedRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->MarkRecommendationDismissed(request),
      [this](grpc::ClientContext& context,
             google::cloud::recommender::v1::
                 MarkRecommendationDismissedRequest const& request) {
        return stub_->MarkRecommendationDismissed(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::recommender::v1::Recommendation>
RecommenderConnectionImpl::MarkRecommendationClaimed(
    google::cloud::recommender::v1::MarkRecommendationClaimedRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->MarkRecommendationClaimed(request),
      [this](grpc::ClientContext& context,
             google::cloud::recommender::v1::
                 MarkRecommendationClaimedRequest const& request) {
        return stub_->MarkRecommendationClaimed(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::recommender::v1::Recommendation>
RecommenderConnectionImpl::MarkRecommendationSucceeded(
    google::cloud::recommender::v1::MarkRecommendationSucceededRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->MarkRecommendationSucceeded(request),
      [this](grpc::ClientContext& context,
             google::cloud::recommender::v1::
                 MarkRecommendationSucceededRequest const& request) {
        return stub_->MarkRecommendationSucceeded(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::recommender::v1::Recommendation>
RecommenderConnectionImpl::MarkRecommendationFailed(
    google::cloud::recommender::v1::MarkRecommendationFailedRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->MarkRecommendationFailed(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::recommender::v1::MarkRecommendationFailedRequest const&
              request) {
        return stub_->MarkRecommendationFailed(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::recommender::v1::RecommenderConfig>
RecommenderConnectionImpl::GetRecommenderConfig(
    google::cloud::recommender::v1::GetRecommenderConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetRecommenderConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::recommender::v1::GetRecommenderConfigRequest const&
                 request) {
        return stub_->GetRecommenderConfig(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::recommender::v1::RecommenderConfig>
RecommenderConnectionImpl::UpdateRecommenderConfig(
    google::cloud::recommender::v1::UpdateRecommenderConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateRecommenderConfig(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::recommender::v1::UpdateRecommenderConfigRequest const&
              request) {
        return stub_->UpdateRecommenderConfig(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::recommender::v1::InsightTypeConfig>
RecommenderConnectionImpl::GetInsightTypeConfig(
    google::cloud::recommender::v1::GetInsightTypeConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetInsightTypeConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::recommender::v1::GetInsightTypeConfigRequest const&
                 request) {
        return stub_->GetInsightTypeConfig(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::recommender::v1::InsightTypeConfig>
RecommenderConnectionImpl::UpdateInsightTypeConfig(
    google::cloud::recommender::v1::UpdateInsightTypeConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateInsightTypeConfig(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::recommender::v1::UpdateInsightTypeConfigRequest const&
              request) {
        return stub_->UpdateInsightTypeConfig(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace recommender_v1_internal
}  // namespace cloud
}  // namespace google
