// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/osconfig/v1/osconfig_zonal_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_INTERNAL_OS_CONFIG_ZONAL_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_INTERNAL_OS_CONFIG_ZONAL_TRACING_CONNECTION_H

#include "google/cloud/osconfig/v1/os_config_zonal_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace osconfig_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class OsConfigZonalServiceTracingConnection
    : public osconfig_v1::OsConfigZonalServiceConnection {
 public:
  ~OsConfigZonalServiceTracingConnection() override = default;

  explicit OsConfigZonalServiceTracingConnection(
      std::shared_ptr<osconfig_v1::OsConfigZonalServiceConnection> child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>
  CreateOSPolicyAssignment(
      google::cloud::osconfig::v1::CreateOSPolicyAssignmentRequest const&
          request) override;

  future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>
  UpdateOSPolicyAssignment(
      google::cloud::osconfig::v1::UpdateOSPolicyAssignmentRequest const&
          request) override;

  StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>
  GetOSPolicyAssignment(
      google::cloud::osconfig::v1::GetOSPolicyAssignmentRequest const& request)
      override;

  StreamRange<google::cloud::osconfig::v1::OSPolicyAssignment>
  ListOSPolicyAssignments(
      google::cloud::osconfig::v1::ListOSPolicyAssignmentsRequest request)
      override;

  StreamRange<google::cloud::osconfig::v1::OSPolicyAssignment>
  ListOSPolicyAssignmentRevisions(
      google::cloud::osconfig::v1::ListOSPolicyAssignmentRevisionsRequest
          request) override;

  future<StatusOr<
      google::cloud::osconfig::v1::OSPolicyAssignmentOperationMetadata>>
  DeleteOSPolicyAssignment(
      google::cloud::osconfig::v1::DeleteOSPolicyAssignmentRequest const&
          request) override;

  StatusOr<google::cloud::osconfig::v1::OSPolicyAssignmentReport>
  GetOSPolicyAssignmentReport(
      google::cloud::osconfig::v1::GetOSPolicyAssignmentReportRequest const&
          request) override;

  StreamRange<google::cloud::osconfig::v1::OSPolicyAssignmentReport>
  ListOSPolicyAssignmentReports(
      google::cloud::osconfig::v1::ListOSPolicyAssignmentReportsRequest request)
      override;

  StatusOr<google::cloud::osconfig::v1::Inventory> GetInventory(
      google::cloud::osconfig::v1::GetInventoryRequest const& request) override;

  StreamRange<google::cloud::osconfig::v1::Inventory> ListInventories(
      google::cloud::osconfig::v1::ListInventoriesRequest request) override;

  StatusOr<google::cloud::osconfig::v1::VulnerabilityReport>
  GetVulnerabilityReport(
      google::cloud::osconfig::v1::GetVulnerabilityReportRequest const& request)
      override;

  StreamRange<google::cloud::osconfig::v1::VulnerabilityReport>
  ListVulnerabilityReports(
      google::cloud::osconfig::v1::ListVulnerabilityReportsRequest request)
      override;

 private:
  std::shared_ptr<osconfig_v1::OsConfigZonalServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<osconfig_v1::OsConfigZonalServiceConnection>
MakeOsConfigZonalServiceTracingConnection(
    std::shared_ptr<osconfig_v1::OsConfigZonalServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_INTERNAL_OS_CONFIG_ZONAL_TRACING_CONNECTION_H
