// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkebackup/v1/gkebackup.proto

#include "google/cloud/gkebackup/v1/backup_for_gke_connection.h"
#include "google/cloud/gkebackup/v1/backup_for_gke_options.h"
#include "google/cloud/gkebackup/v1/internal/backup_for_gke_connection_impl.h"
#include "google/cloud/gkebackup/v1/internal/backup_for_gke_option_defaults.h"
#include "google/cloud/gkebackup/v1/internal/backup_for_gke_stub_factory.h"
#include "google/cloud/gkebackup/v1/internal/backup_for_gke_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace gkebackup_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BackupForGKEConnection::~BackupForGKEConnection() = default;

future<StatusOr<google::cloud::gkebackup::v1::BackupPlan>>
BackupForGKEConnection::CreateBackupPlan(
    google::cloud::gkebackup::v1::CreateBackupPlanRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkebackup::v1::BackupPlan>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::gkebackup::v1::BackupPlan>
BackupForGKEConnection::ListBackupPlans(
    google::cloud::gkebackup::v1::
        ListBackupPlansRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::gkebackup::v1::BackupPlan>>();
}

StatusOr<google::cloud::gkebackup::v1::BackupPlan>
BackupForGKEConnection::GetBackupPlan(
    google::cloud::gkebackup::v1::GetBackupPlanRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::gkebackup::v1::BackupPlan>>
BackupForGKEConnection::UpdateBackupPlan(
    google::cloud::gkebackup::v1::UpdateBackupPlanRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkebackup::v1::BackupPlan>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>
BackupForGKEConnection::DeleteBackupPlan(
    google::cloud::gkebackup::v1::DeleteBackupPlanRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkebackup::v1::Backup>>
BackupForGKEConnection::CreateBackup(
    google::cloud::gkebackup::v1::CreateBackupRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkebackup::v1::Backup>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::gkebackup::v1::Backup>
BackupForGKEConnection::ListBackups(
    google::cloud::gkebackup::v1::
        ListBackupsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::gkebackup::v1::Backup>>();
}

StatusOr<google::cloud::gkebackup::v1::Backup>
BackupForGKEConnection::GetBackup(
    google::cloud::gkebackup::v1::GetBackupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::gkebackup::v1::Backup>>
BackupForGKEConnection::UpdateBackup(
    google::cloud::gkebackup::v1::UpdateBackupRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkebackup::v1::Backup>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>
BackupForGKEConnection::DeleteBackup(
    google::cloud::gkebackup::v1::DeleteBackupRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::gkebackup::v1::VolumeBackup>
BackupForGKEConnection::ListVolumeBackups(
    google::cloud::gkebackup::v1::
        ListVolumeBackupsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::gkebackup::v1::VolumeBackup>>();
}

StatusOr<google::cloud::gkebackup::v1::VolumeBackup>
BackupForGKEConnection::GetVolumeBackup(
    google::cloud::gkebackup::v1::GetVolumeBackupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::gkebackup::v1::RestorePlan>>
BackupForGKEConnection::CreateRestorePlan(
    google::cloud::gkebackup::v1::CreateRestorePlanRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkebackup::v1::RestorePlan>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::gkebackup::v1::RestorePlan>
BackupForGKEConnection::ListRestorePlans(
    google::cloud::gkebackup::v1::
        ListRestorePlansRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::gkebackup::v1::RestorePlan>>();
}

StatusOr<google::cloud::gkebackup::v1::RestorePlan>
BackupForGKEConnection::GetRestorePlan(
    google::cloud::gkebackup::v1::GetRestorePlanRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::gkebackup::v1::RestorePlan>>
BackupForGKEConnection::UpdateRestorePlan(
    google::cloud::gkebackup::v1::UpdateRestorePlanRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkebackup::v1::RestorePlan>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>
BackupForGKEConnection::DeleteRestorePlan(
    google::cloud::gkebackup::v1::DeleteRestorePlanRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkebackup::v1::Restore>>
BackupForGKEConnection::CreateRestore(
    google::cloud::gkebackup::v1::CreateRestoreRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkebackup::v1::Restore>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::gkebackup::v1::Restore>
BackupForGKEConnection::ListRestores(
    google::cloud::gkebackup::v1::
        ListRestoresRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::gkebackup::v1::Restore>>();
}

StatusOr<google::cloud::gkebackup::v1::Restore>
BackupForGKEConnection::GetRestore(
    google::cloud::gkebackup::v1::GetRestoreRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::gkebackup::v1::Restore>>
BackupForGKEConnection::UpdateRestore(
    google::cloud::gkebackup::v1::UpdateRestoreRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkebackup::v1::Restore>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>
BackupForGKEConnection::DeleteRestore(
    google::cloud::gkebackup::v1::DeleteRestoreRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::gkebackup::v1::VolumeRestore>
BackupForGKEConnection::ListVolumeRestores(
    google::cloud::gkebackup::v1::
        ListVolumeRestoresRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::gkebackup::v1::VolumeRestore>>();
}

StatusOr<google::cloud::gkebackup::v1::VolumeRestore>
BackupForGKEConnection::GetVolumeRestore(
    google::cloud::gkebackup::v1::GetVolumeRestoreRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<BackupForGKEConnection> MakeBackupForGKEConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 BackupForGKEPolicyOptionList>(options,
                                                               __func__);
  options =
      gkebackup_v1_internal::BackupForGKEDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = gkebackup_v1_internal::CreateDefaultBackupForGKEStub(
      background->cq(), options);
  return gkebackup_v1_internal::MakeBackupForGKETracingConnection(
      std::make_shared<gkebackup_v1_internal::BackupForGKEConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkebackup_v1
}  // namespace cloud
}  // namespace google
