// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/edgecontainer/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EDGECONTAINER_V1_EDGE_CONTAINER_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EDGECONTAINER_V1_EDGE_CONTAINER_CONNECTION_H

#include "google/cloud/edgecontainer/v1/edge_container_connection_idempotency_policy.h"
#include "google/cloud/edgecontainer/v1/internal/edge_container_retry_traits.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/edgecontainer/v1/service.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace edgecontainer_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `EdgeContainerConnection`.
class EdgeContainerRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<EdgeContainerRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `EdgeContainerConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class EdgeContainerLimitedErrorCountRetryPolicy
    : public EdgeContainerRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit EdgeContainerLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  EdgeContainerLimitedErrorCountRetryPolicy(
      EdgeContainerLimitedErrorCountRetryPolicy&& rhs) noexcept
      : EdgeContainerLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  EdgeContainerLimitedErrorCountRetryPolicy(
      EdgeContainerLimitedErrorCountRetryPolicy const& rhs) noexcept
      : EdgeContainerLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<EdgeContainerRetryPolicy> clone() const override {
    return std::make_unique<EdgeContainerLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = EdgeContainerRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      edgecontainer_v1_internal::EdgeContainerRetryTraits>
      impl_;
};

/**
 * A retry policy for `EdgeContainerConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class EdgeContainerLimitedTimeRetryPolicy : public EdgeContainerRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit EdgeContainerLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  EdgeContainerLimitedTimeRetryPolicy(
      EdgeContainerLimitedTimeRetryPolicy&& rhs) noexcept
      : EdgeContainerLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  EdgeContainerLimitedTimeRetryPolicy(
      EdgeContainerLimitedTimeRetryPolicy const& rhs) noexcept
      : EdgeContainerLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<EdgeContainerRetryPolicy> clone() const override {
    return std::make_unique<EdgeContainerLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = EdgeContainerRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      edgecontainer_v1_internal::EdgeContainerRetryTraits>
      impl_;
};

/**
 * The `EdgeContainerConnection` object for `EdgeContainerClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `EdgeContainerClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `EdgeContainerClient`.
 *
 * To create a concrete instance, see `MakeEdgeContainerConnection()`.
 *
 * For mocking, see `edgecontainer_v1_mocks::MockEdgeContainerConnection`.
 */
class EdgeContainerConnection {
 public:
  virtual ~EdgeContainerConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StreamRange<google::cloud::edgecontainer::v1::Cluster> ListClusters(
      google::cloud::edgecontainer::v1::ListClustersRequest request);

  virtual StatusOr<google::cloud::edgecontainer::v1::Cluster> GetCluster(
      google::cloud::edgecontainer::v1::GetClusterRequest const& request);

  virtual future<StatusOr<google::cloud::edgecontainer::v1::Cluster>>
  CreateCluster(
      google::cloud::edgecontainer::v1::CreateClusterRequest const& request);

  virtual future<StatusOr<google::cloud::edgecontainer::v1::Cluster>>
  UpdateCluster(
      google::cloud::edgecontainer::v1::UpdateClusterRequest const& request);

  virtual future<StatusOr<google::cloud::edgecontainer::v1::OperationMetadata>>
  DeleteCluster(
      google::cloud::edgecontainer::v1::DeleteClusterRequest const& request);

  virtual StatusOr<
      google::cloud::edgecontainer::v1::GenerateAccessTokenResponse>
  GenerateAccessToken(
      google::cloud::edgecontainer::v1::GenerateAccessTokenRequest const&
          request);

  virtual StreamRange<google::cloud::edgecontainer::v1::NodePool> ListNodePools(
      google::cloud::edgecontainer::v1::ListNodePoolsRequest request);

  virtual StatusOr<google::cloud::edgecontainer::v1::NodePool> GetNodePool(
      google::cloud::edgecontainer::v1::GetNodePoolRequest const& request);

  virtual future<StatusOr<google::cloud::edgecontainer::v1::NodePool>>
  CreateNodePool(
      google::cloud::edgecontainer::v1::CreateNodePoolRequest const& request);

  virtual future<StatusOr<google::cloud::edgecontainer::v1::NodePool>>
  UpdateNodePool(
      google::cloud::edgecontainer::v1::UpdateNodePoolRequest const& request);

  virtual future<StatusOr<google::cloud::edgecontainer::v1::OperationMetadata>>
  DeleteNodePool(
      google::cloud::edgecontainer::v1::DeleteNodePoolRequest const& request);

  virtual StreamRange<google::cloud::edgecontainer::v1::Machine> ListMachines(
      google::cloud::edgecontainer::v1::ListMachinesRequest request);

  virtual StatusOr<google::cloud::edgecontainer::v1::Machine> GetMachine(
      google::cloud::edgecontainer::v1::GetMachineRequest const& request);

  virtual StreamRange<google::cloud::edgecontainer::v1::VpnConnection>
  ListVpnConnections(
      google::cloud::edgecontainer::v1::ListVpnConnectionsRequest request);

  virtual StatusOr<google::cloud::edgecontainer::v1::VpnConnection>
  GetVpnConnection(
      google::cloud::edgecontainer::v1::GetVpnConnectionRequest const& request);

  virtual future<StatusOr<google::cloud::edgecontainer::v1::VpnConnection>>
  CreateVpnConnection(
      google::cloud::edgecontainer::v1::CreateVpnConnectionRequest const&
          request);

  virtual future<StatusOr<google::cloud::edgecontainer::v1::OperationMetadata>>
  DeleteVpnConnection(
      google::cloud::edgecontainer::v1::DeleteVpnConnectionRequest const&
          request);
};

/**
 * A factory function to construct an object of type `EdgeContainerConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of EdgeContainerClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `EdgeContainerConnection`. Expected options are any of the types in
 * the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::edgecontainer_v1::EdgeContainerPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `EdgeContainerConnection` created by
 * this function.
 */
std::shared_ptr<EdgeContainerConnection> MakeEdgeContainerConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace edgecontainer_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EDGECONTAINER_V1_EDGE_CONTAINER_CONNECTION_H
