// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/service.proto

#include "google/cloud/dataplex/v1/dataplex_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataplex_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DataplexServiceClient::DataplexServiceClient(
    std::shared_ptr<DataplexServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
DataplexServiceClient::~DataplexServiceClient() = default;

future<StatusOr<google::cloud::dataplex::v1::Lake>>
DataplexServiceClient::CreateLake(std::string const& parent,
                                  google::cloud::dataplex::v1::Lake const& lake,
                                  std::string const& lake_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::CreateLakeRequest request;
  request.set_parent(parent);
  *request.mutable_lake() = lake;
  request.set_lake_id(lake_id);
  return connection_->CreateLake(request);
}

future<StatusOr<google::cloud::dataplex::v1::Lake>>
DataplexServiceClient::CreateLake(
    google::cloud::dataplex::v1::CreateLakeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateLake(request);
}

future<StatusOr<google::cloud::dataplex::v1::Lake>>
DataplexServiceClient::UpdateLake(
    google::cloud::dataplex::v1::Lake const& lake,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::UpdateLakeRequest request;
  *request.mutable_lake() = lake;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateLake(request);
}

future<StatusOr<google::cloud::dataplex::v1::Lake>>
DataplexServiceClient::UpdateLake(
    google::cloud::dataplex::v1::UpdateLakeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateLake(request);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataplexServiceClient::DeleteLake(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::DeleteLakeRequest request;
  request.set_name(name);
  return connection_->DeleteLake(request);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataplexServiceClient::DeleteLake(
    google::cloud::dataplex::v1::DeleteLakeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteLake(request);
}

StreamRange<google::cloud::dataplex::v1::Lake> DataplexServiceClient::ListLakes(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::ListLakesRequest request;
  request.set_parent(parent);
  return connection_->ListLakes(request);
}

StreamRange<google::cloud::dataplex::v1::Lake> DataplexServiceClient::ListLakes(
    google::cloud::dataplex::v1::ListLakesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLakes(std::move(request));
}

StatusOr<google::cloud::dataplex::v1::Lake> DataplexServiceClient::GetLake(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::GetLakeRequest request;
  request.set_name(name);
  return connection_->GetLake(request);
}

StatusOr<google::cloud::dataplex::v1::Lake> DataplexServiceClient::GetLake(
    google::cloud::dataplex::v1::GetLakeRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLake(request);
}

StreamRange<google::cloud::dataplex::v1::Action>
DataplexServiceClient::ListLakeActions(std::string const& parent,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::ListLakeActionsRequest request;
  request.set_parent(parent);
  return connection_->ListLakeActions(request);
}

StreamRange<google::cloud::dataplex::v1::Action>
DataplexServiceClient::ListLakeActions(
    google::cloud::dataplex::v1::ListLakeActionsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLakeActions(std::move(request));
}

future<StatusOr<google::cloud::dataplex::v1::Zone>>
DataplexServiceClient::CreateZone(std::string const& parent,
                                  google::cloud::dataplex::v1::Zone const& zone,
                                  std::string const& zone_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::CreateZoneRequest request;
  request.set_parent(parent);
  *request.mutable_zone() = zone;
  request.set_zone_id(zone_id);
  return connection_->CreateZone(request);
}

future<StatusOr<google::cloud::dataplex::v1::Zone>>
DataplexServiceClient::CreateZone(
    google::cloud::dataplex::v1::CreateZoneRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateZone(request);
}

future<StatusOr<google::cloud::dataplex::v1::Zone>>
DataplexServiceClient::UpdateZone(
    google::cloud::dataplex::v1::Zone const& zone,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::UpdateZoneRequest request;
  *request.mutable_zone() = zone;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateZone(request);
}

future<StatusOr<google::cloud::dataplex::v1::Zone>>
DataplexServiceClient::UpdateZone(
    google::cloud::dataplex::v1::UpdateZoneRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateZone(request);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataplexServiceClient::DeleteZone(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::DeleteZoneRequest request;
  request.set_name(name);
  return connection_->DeleteZone(request);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataplexServiceClient::DeleteZone(
    google::cloud::dataplex::v1::DeleteZoneRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteZone(request);
}

StreamRange<google::cloud::dataplex::v1::Zone> DataplexServiceClient::ListZones(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::ListZonesRequest request;
  request.set_parent(parent);
  return connection_->ListZones(request);
}

StreamRange<google::cloud::dataplex::v1::Zone> DataplexServiceClient::ListZones(
    google::cloud::dataplex::v1::ListZonesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListZones(std::move(request));
}

StatusOr<google::cloud::dataplex::v1::Zone> DataplexServiceClient::GetZone(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::GetZoneRequest request;
  request.set_name(name);
  return connection_->GetZone(request);
}

StatusOr<google::cloud::dataplex::v1::Zone> DataplexServiceClient::GetZone(
    google::cloud::dataplex::v1::GetZoneRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetZone(request);
}

StreamRange<google::cloud::dataplex::v1::Action>
DataplexServiceClient::ListZoneActions(std::string const& parent,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::ListZoneActionsRequest request;
  request.set_parent(parent);
  return connection_->ListZoneActions(request);
}

StreamRange<google::cloud::dataplex::v1::Action>
DataplexServiceClient::ListZoneActions(
    google::cloud::dataplex::v1::ListZoneActionsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListZoneActions(std::move(request));
}

future<StatusOr<google::cloud::dataplex::v1::Asset>>
DataplexServiceClient::CreateAsset(
    std::string const& parent, google::cloud::dataplex::v1::Asset const& asset,
    std::string const& asset_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::CreateAssetRequest request;
  request.set_parent(parent);
  *request.mutable_asset() = asset;
  request.set_asset_id(asset_id);
  return connection_->CreateAsset(request);
}

future<StatusOr<google::cloud::dataplex::v1::Asset>>
DataplexServiceClient::CreateAsset(
    google::cloud::dataplex::v1::CreateAssetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAsset(request);
}

future<StatusOr<google::cloud::dataplex::v1::Asset>>
DataplexServiceClient::UpdateAsset(
    google::cloud::dataplex::v1::Asset const& asset,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::UpdateAssetRequest request;
  *request.mutable_asset() = asset;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateAsset(request);
}

future<StatusOr<google::cloud::dataplex::v1::Asset>>
DataplexServiceClient::UpdateAsset(
    google::cloud::dataplex::v1::UpdateAssetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateAsset(request);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataplexServiceClient::DeleteAsset(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::DeleteAssetRequest request;
  request.set_name(name);
  return connection_->DeleteAsset(request);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataplexServiceClient::DeleteAsset(
    google::cloud::dataplex::v1::DeleteAssetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAsset(request);
}

StreamRange<google::cloud::dataplex::v1::Asset>
DataplexServiceClient::ListAssets(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::ListAssetsRequest request;
  request.set_parent(parent);
  return connection_->ListAssets(request);
}

StreamRange<google::cloud::dataplex::v1::Asset>
DataplexServiceClient::ListAssets(
    google::cloud::dataplex::v1::ListAssetsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListAssets(std::move(request));
}

StatusOr<google::cloud::dataplex::v1::Asset> DataplexServiceClient::GetAsset(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::GetAssetRequest request;
  request.set_name(name);
  return connection_->GetAsset(request);
}

StatusOr<google::cloud::dataplex::v1::Asset> DataplexServiceClient::GetAsset(
    google::cloud::dataplex::v1::GetAssetRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetAsset(request);
}

StreamRange<google::cloud::dataplex::v1::Action>
DataplexServiceClient::ListAssetActions(std::string const& parent,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::ListAssetActionsRequest request;
  request.set_parent(parent);
  return connection_->ListAssetActions(request);
}

StreamRange<google::cloud::dataplex::v1::Action>
DataplexServiceClient::ListAssetActions(
    google::cloud::dataplex::v1::ListAssetActionsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListAssetActions(std::move(request));
}

future<StatusOr<google::cloud::dataplex::v1::Task>>
DataplexServiceClient::CreateTask(std::string const& parent,
                                  google::cloud::dataplex::v1::Task const& task,
                                  std::string const& task_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::CreateTaskRequest request;
  request.set_parent(parent);
  *request.mutable_task() = task;
  request.set_task_id(task_id);
  return connection_->CreateTask(request);
}

future<StatusOr<google::cloud::dataplex::v1::Task>>
DataplexServiceClient::CreateTask(
    google::cloud::dataplex::v1::CreateTaskRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTask(request);
}

future<StatusOr<google::cloud::dataplex::v1::Task>>
DataplexServiceClient::UpdateTask(
    google::cloud::dataplex::v1::Task const& task,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::UpdateTaskRequest request;
  *request.mutable_task() = task;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateTask(request);
}

future<StatusOr<google::cloud::dataplex::v1::Task>>
DataplexServiceClient::UpdateTask(
    google::cloud::dataplex::v1::UpdateTaskRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTask(request);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataplexServiceClient::DeleteTask(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::DeleteTaskRequest request;
  request.set_name(name);
  return connection_->DeleteTask(request);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataplexServiceClient::DeleteTask(
    google::cloud::dataplex::v1::DeleteTaskRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTask(request);
}

StreamRange<google::cloud::dataplex::v1::Task> DataplexServiceClient::ListTasks(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::ListTasksRequest request;
  request.set_parent(parent);
  return connection_->ListTasks(request);
}

StreamRange<google::cloud::dataplex::v1::Task> DataplexServiceClient::ListTasks(
    google::cloud::dataplex::v1::ListTasksRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTasks(std::move(request));
}

StatusOr<google::cloud::dataplex::v1::Task> DataplexServiceClient::GetTask(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::GetTaskRequest request;
  request.set_name(name);
  return connection_->GetTask(request);
}

StatusOr<google::cloud::dataplex::v1::Task> DataplexServiceClient::GetTask(
    google::cloud::dataplex::v1::GetTaskRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTask(request);
}

StreamRange<google::cloud::dataplex::v1::Job> DataplexServiceClient::ListJobs(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::ListJobsRequest request;
  request.set_parent(parent);
  return connection_->ListJobs(request);
}

StreamRange<google::cloud::dataplex::v1::Job> DataplexServiceClient::ListJobs(
    google::cloud::dataplex::v1::ListJobsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListJobs(std::move(request));
}

StatusOr<google::cloud::dataplex::v1::RunTaskResponse>
DataplexServiceClient::RunTask(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::RunTaskRequest request;
  request.set_name(name);
  return connection_->RunTask(request);
}

StatusOr<google::cloud::dataplex::v1::RunTaskResponse>
DataplexServiceClient::RunTask(
    google::cloud::dataplex::v1::RunTaskRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RunTask(request);
}

StatusOr<google::cloud::dataplex::v1::Job> DataplexServiceClient::GetJob(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::GetJobRequest request;
  request.set_name(name);
  return connection_->GetJob(request);
}

StatusOr<google::cloud::dataplex::v1::Job> DataplexServiceClient::GetJob(
    google::cloud::dataplex::v1::GetJobRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetJob(request);
}

Status DataplexServiceClient::CancelJob(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::CancelJobRequest request;
  request.set_name(name);
  return connection_->CancelJob(request);
}

Status DataplexServiceClient::CancelJob(
    google::cloud::dataplex::v1::CancelJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelJob(request);
}

future<StatusOr<google::cloud::dataplex::v1::Environment>>
DataplexServiceClient::CreateEnvironment(
    std::string const& parent,
    google::cloud::dataplex::v1::Environment const& environment,
    std::string const& environment_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::CreateEnvironmentRequest request;
  request.set_parent(parent);
  *request.mutable_environment() = environment;
  request.set_environment_id(environment_id);
  return connection_->CreateEnvironment(request);
}

future<StatusOr<google::cloud::dataplex::v1::Environment>>
DataplexServiceClient::CreateEnvironment(
    google::cloud::dataplex::v1::CreateEnvironmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateEnvironment(request);
}

future<StatusOr<google::cloud::dataplex::v1::Environment>>
DataplexServiceClient::UpdateEnvironment(
    google::cloud::dataplex::v1::Environment const& environment,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::UpdateEnvironmentRequest request;
  *request.mutable_environment() = environment;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateEnvironment(request);
}

future<StatusOr<google::cloud::dataplex::v1::Environment>>
DataplexServiceClient::UpdateEnvironment(
    google::cloud::dataplex::v1::UpdateEnvironmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateEnvironment(request);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataplexServiceClient::DeleteEnvironment(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::DeleteEnvironmentRequest request;
  request.set_name(name);
  return connection_->DeleteEnvironment(request);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataplexServiceClient::DeleteEnvironment(
    google::cloud::dataplex::v1::DeleteEnvironmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteEnvironment(request);
}

StreamRange<google::cloud::dataplex::v1::Environment>
DataplexServiceClient::ListEnvironments(std::string const& parent,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::ListEnvironmentsRequest request;
  request.set_parent(parent);
  return connection_->ListEnvironments(request);
}

StreamRange<google::cloud::dataplex::v1::Environment>
DataplexServiceClient::ListEnvironments(
    google::cloud::dataplex::v1::ListEnvironmentsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListEnvironments(std::move(request));
}

StatusOr<google::cloud::dataplex::v1::Environment>
DataplexServiceClient::GetEnvironment(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::GetEnvironmentRequest request;
  request.set_name(name);
  return connection_->GetEnvironment(request);
}

StatusOr<google::cloud::dataplex::v1::Environment>
DataplexServiceClient::GetEnvironment(
    google::cloud::dataplex::v1::GetEnvironmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEnvironment(request);
}

StreamRange<google::cloud::dataplex::v1::Session>
DataplexServiceClient::ListSessions(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::ListSessionsRequest request;
  request.set_parent(parent);
  return connection_->ListSessions(request);
}

StreamRange<google::cloud::dataplex::v1::Session>
DataplexServiceClient::ListSessions(
    google::cloud::dataplex::v1::ListSessionsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSessions(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1
}  // namespace cloud
}  // namespace google
