// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/network_endpoint_groups/v1/network_endpoint_groups.proto

#include "google/cloud/compute/network_endpoint_groups/v1/network_endpoint_groups_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_network_endpoint_groups_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

NetworkEndpointGroupsClient::NetworkEndpointGroupsClient(
    std::shared_ptr<NetworkEndpointGroupsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
NetworkEndpointGroupsClient::~NetworkEndpointGroupsClient() = default;

StreamRange<
    std::pair<std::string,
              google::cloud::cpp::compute::v1::NetworkEndpointGroupsScopedList>>
NetworkEndpointGroupsClient::AggregatedListNetworkEndpointGroups(
    std::string const& project, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::network_endpoint_groups::v1::
      AggregatedListNetworkEndpointGroupsRequest request;
  request.set_project(project);
  return connection_->AggregatedListNetworkEndpointGroups(request);
}

StreamRange<
    std::pair<std::string,
              google::cloud::cpp::compute::v1::NetworkEndpointGroupsScopedList>>
NetworkEndpointGroupsClient::AggregatedListNetworkEndpointGroups(
    google::cloud::cpp::compute::network_endpoint_groups::v1::
        AggregatedListNetworkEndpointGroupsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AggregatedListNetworkEndpointGroups(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworkEndpointGroupsClient::AttachNetworkEndpoints(
    std::string const& project, std::string const& zone,
    std::string const& network_endpoint_group,
    google::cloud::cpp::compute::v1::
        NetworkEndpointGroupsAttachEndpointsRequest const&
            network_endpoint_groups_attach_endpoints_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::network_endpoint_groups::v1::
      AttachNetworkEndpointsRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_network_endpoint_group(network_endpoint_group);
  *request.mutable_network_endpoint_groups_attach_endpoints_request_resource() =
      network_endpoint_groups_attach_endpoints_request_resource;
  return connection_->AttachNetworkEndpoints(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworkEndpointGroupsClient::AttachNetworkEndpoints(
    google::cloud::cpp::compute::network_endpoint_groups::v1::
        AttachNetworkEndpointsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AttachNetworkEndpoints(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworkEndpointGroupsClient::DeleteNetworkEndpointGroup(
    std::string const& project, std::string const& zone,
    std::string const& network_endpoint_group, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::network_endpoint_groups::v1::
      DeleteNetworkEndpointGroupRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_network_endpoint_group(network_endpoint_group);
  return connection_->DeleteNetworkEndpointGroup(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworkEndpointGroupsClient::DeleteNetworkEndpointGroup(
    google::cloud::cpp::compute::network_endpoint_groups::v1::
        DeleteNetworkEndpointGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNetworkEndpointGroup(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworkEndpointGroupsClient::DetachNetworkEndpoints(
    std::string const& project, std::string const& zone,
    std::string const& network_endpoint_group,
    google::cloud::cpp::compute::v1::
        NetworkEndpointGroupsDetachEndpointsRequest const&
            network_endpoint_groups_detach_endpoints_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::network_endpoint_groups::v1::
      DetachNetworkEndpointsRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_network_endpoint_group(network_endpoint_group);
  *request.mutable_network_endpoint_groups_detach_endpoints_request_resource() =
      network_endpoint_groups_detach_endpoints_request_resource;
  return connection_->DetachNetworkEndpoints(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworkEndpointGroupsClient::DetachNetworkEndpoints(
    google::cloud::cpp::compute::network_endpoint_groups::v1::
        DetachNetworkEndpointsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DetachNetworkEndpoints(request);
}

StatusOr<google::cloud::cpp::compute::v1::NetworkEndpointGroup>
NetworkEndpointGroupsClient::GetNetworkEndpointGroup(
    std::string const& project, std::string const& zone,
    std::string const& network_endpoint_group, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::network_endpoint_groups::v1::
      GetNetworkEndpointGroupRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_network_endpoint_group(network_endpoint_group);
  return connection_->GetNetworkEndpointGroup(request);
}

StatusOr<google::cloud::cpp::compute::v1::NetworkEndpointGroup>
NetworkEndpointGroupsClient::GetNetworkEndpointGroup(
    google::cloud::cpp::compute::network_endpoint_groups::v1::
        GetNetworkEndpointGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNetworkEndpointGroup(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworkEndpointGroupsClient::InsertNetworkEndpointGroup(
    std::string const& project, std::string const& zone,
    google::cloud::cpp::compute::v1::NetworkEndpointGroup const&
        network_endpoint_group_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::network_endpoint_groups::v1::
      InsertNetworkEndpointGroupRequest request;
  request.set_project(project);
  request.set_zone(zone);
  *request.mutable_network_endpoint_group_resource() =
      network_endpoint_group_resource;
  return connection_->InsertNetworkEndpointGroup(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworkEndpointGroupsClient::InsertNetworkEndpointGroup(
    google::cloud::cpp::compute::network_endpoint_groups::v1::
        InsertNetworkEndpointGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertNetworkEndpointGroup(request);
}

StreamRange<google::cloud::cpp::compute::v1::NetworkEndpointGroup>
NetworkEndpointGroupsClient::ListNetworkEndpointGroups(
    std::string const& project, std::string const& zone, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::network_endpoint_groups::v1::
      ListNetworkEndpointGroupsRequest request;
  request.set_project(project);
  request.set_zone(zone);
  return connection_->ListNetworkEndpointGroups(request);
}

StreamRange<google::cloud::cpp::compute::v1::NetworkEndpointGroup>
NetworkEndpointGroupsClient::ListNetworkEndpointGroups(
    google::cloud::cpp::compute::network_endpoint_groups::v1::
        ListNetworkEndpointGroupsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNetworkEndpointGroups(std::move(request));
}

StreamRange<google::cloud::cpp::compute::v1::NetworkEndpointWithHealthStatus>
NetworkEndpointGroupsClient::ListNetworkEndpoints(
    std::string const& project, std::string const& zone,
    std::string const& network_endpoint_group,
    google::cloud::cpp::compute::v1::
        NetworkEndpointGroupsListEndpointsRequest const&
            network_endpoint_groups_list_endpoints_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::network_endpoint_groups::v1::
      ListNetworkEndpointsRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_network_endpoint_group(network_endpoint_group);
  *request.mutable_network_endpoint_groups_list_endpoints_request_resource() =
      network_endpoint_groups_list_endpoints_request_resource;
  return connection_->ListNetworkEndpoints(request);
}

StreamRange<google::cloud::cpp::compute::v1::NetworkEndpointWithHealthStatus>
NetworkEndpointGroupsClient::ListNetworkEndpoints(
    google::cloud::cpp::compute::network_endpoint_groups::v1::
        ListNetworkEndpointsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNetworkEndpoints(std::move(request));
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
NetworkEndpointGroupsClient::TestIamPermissions(
    std::string const& project, std::string const& zone,
    std::string const& resource,
    google::cloud::cpp::compute::v1::TestPermissionsRequest const&
        test_permissions_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::network_endpoint_groups::v1::
      TestIamPermissionsRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_resource(resource);
  *request.mutable_test_permissions_request_resource() =
      test_permissions_request_resource;
  return connection_->TestIamPermissions(request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
NetworkEndpointGroupsClient::TestIamPermissions(
    google::cloud::cpp::compute::network_endpoint_groups::v1::
        TestIamPermissionsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_network_endpoint_groups_v1
}  // namespace cloud
}  // namespace google
