// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/interconnects/v1/interconnects.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_INTERCONNECTS_V1_INTERNAL_INTERCONNECTS_REST_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_INTERCONNECTS_V1_INTERNAL_INTERCONNECTS_REST_CONNECTION_IMPL_H

#include "google/cloud/compute/interconnects/v1/interconnects_connection.h"
#include "google/cloud/compute/interconnects/v1/interconnects_connection_idempotency_policy.h"
#include "google/cloud/compute/interconnects/v1/interconnects_options.h"
#include "google/cloud/compute/interconnects/v1/internal/interconnects_rest_stub.h"
#include "google/cloud/compute/interconnects/v1/internal/interconnects_retry_traits.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/compute/global_operations/v1/global_operations.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace compute_interconnects_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class InterconnectsRestConnectionImpl
    : public compute_interconnects_v1::InterconnectsConnection {
 public:
  ~InterconnectsRestConnectionImpl() override = default;

  InterconnectsRestConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<compute_interconnects_v1_internal::InterconnectsRestStub>
          stub,
      Options options);

  Options options() override { return options_; }

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteInterconnect(google::cloud::cpp::compute::interconnects::v1::
                         DeleteInterconnectRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Interconnect> GetInterconnect(
      google::cloud::cpp::compute::interconnects::v1::
          GetInterconnectRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::InterconnectsGetDiagnosticsResponse>
  GetDiagnostics(google::cloud::cpp::compute::interconnects::v1::
                     GetDiagnosticsRequest const& request) override;

  StatusOr<
      google::cloud::cpp::compute::v1::InterconnectsGetMacsecConfigResponse>
  GetMacsecConfig(google::cloud::cpp::compute::interconnects::v1::
                      GetMacsecConfigRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertInterconnect(google::cloud::cpp::compute::interconnects::v1::
                         InsertInterconnectRequest const& request) override;

  StreamRange<google::cloud::cpp::compute::v1::Interconnect> ListInterconnects(
      google::cloud::cpp::compute::interconnects::v1::ListInterconnectsRequest
          request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  PatchInterconnect(google::cloud::cpp::compute::interconnects::v1::
                        PatchInterconnectRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> SetLabels(
      google::cloud::cpp::compute::interconnects::v1::SetLabelsRequest const&
          request) override;

 private:
  static std::unique_ptr<compute_interconnects_v1::InterconnectsRetryPolicy>
  retry_policy(Options const& options) {
    return options
        .get<compute_interconnects_v1::InterconnectsRetryPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
    return options
        .get<compute_interconnects_v1::InterconnectsBackoffPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<
      compute_interconnects_v1::InterconnectsConnectionIdempotencyPolicy>
  idempotency_policy(Options const& options) {
    return options
        .get<compute_interconnects_v1::
                 InterconnectsConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
    return options
        .get<compute_interconnects_v1::InterconnectsPollingPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<compute_interconnects_v1_internal::InterconnectsRestStub>
      stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_interconnects_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_INTERCONNECTS_V1_INTERNAL_INTERCONNECTS_REST_CONNECTION_IMPL_H
