/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import java.util.ArrayList;
import java.util.List;
import org.jgrapht.event.ConnectedComponentTraversalEvent;
import org.jgrapht.event.EdgeTraversalEvent;
import org.jgrapht.event.TraversalListener;
import org.jgrapht.event.VertexTraversalEvent;
import org.jgrapht.traverse.GraphIterator;

public abstract class AbstractGraphIterator<V, E>
implements GraphIterator<V, E> {
    private List<TraversalListener<V, E>> traversalListeners = new ArrayList<TraversalListener<V, E>>();
    private boolean crossComponentTraversal = true;
    private boolean reuseEvents = false;

    public void setCrossComponentTraversal(boolean bl) {
        this.crossComponentTraversal = bl;
    }

    @Override
    public boolean isCrossComponentTraversal() {
        return this.crossComponentTraversal;
    }

    @Override
    public void setReuseEvents(boolean bl) {
        this.reuseEvents = bl;
    }

    @Override
    public boolean isReuseEvents() {
        return this.reuseEvents;
    }

    @Override
    public void addTraversalListener(TraversalListener<V, E> traversalListener) {
        if (!this.traversalListeners.contains(traversalListener)) {
            this.traversalListeners.add(traversalListener);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeTraversalListener(TraversalListener<V, E> traversalListener) {
        this.traversalListeners.remove(traversalListener);
    }

    protected void fireConnectedComponentFinished(ConnectedComponentTraversalEvent connectedComponentTraversalEvent) {
        int n = this.traversalListeners.size();
        for (int i = 0; i < n; ++i) {
            TraversalListener<V, E> traversalListener = this.traversalListeners.get(i);
            traversalListener.connectedComponentFinished(connectedComponentTraversalEvent);
        }
    }

    protected void fireConnectedComponentStarted(ConnectedComponentTraversalEvent connectedComponentTraversalEvent) {
        int n = this.traversalListeners.size();
        for (int i = 0; i < n; ++i) {
            TraversalListener<V, E> traversalListener = this.traversalListeners.get(i);
            traversalListener.connectedComponentStarted(connectedComponentTraversalEvent);
        }
    }

    protected void fireEdgeTraversed(EdgeTraversalEvent<V, E> edgeTraversalEvent) {
        int n = this.traversalListeners.size();
        for (int i = 0; i < n; ++i) {
            TraversalListener<V, E> traversalListener = this.traversalListeners.get(i);
            traversalListener.edgeTraversed(edgeTraversalEvent);
        }
    }

    protected void fireVertexTraversed(VertexTraversalEvent<V> vertexTraversalEvent) {
        int n = this.traversalListeners.size();
        for (int i = 0; i < n; ++i) {
            TraversalListener<V, E> traversalListener = this.traversalListeners.get(i);
            traversalListener.vertexTraversed(vertexTraversalEvent);
        }
    }

    protected void fireVertexFinished(VertexTraversalEvent<V> vertexTraversalEvent) {
        int n = this.traversalListeners.size();
        for (int i = 0; i < n; ++i) {
            TraversalListener<V, E> traversalListener = this.traversalListeners.get(i);
            traversalListener.vertexFinished(vertexTraversalEvent);
        }
    }
}

