/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.isomorphism;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.util.ArrayUtil;

public class GraphOrdering<V, E> {
    private Map<V, Integer> mapVertexToOrder;
    private Set<LabelsEdge> labelsEdgesSet;

    public GraphOrdering(Graph<V, E> regularGraph) {
        this(regularGraph, regularGraph.vertexSet(), regularGraph.edgeSet());
    }

    public GraphOrdering(Graph<V, E> regularGraph, Set<V> vertexSet, Set<E> edgeSet) {
        this.init(regularGraph, vertexSet, edgeSet);
    }

    private void init(Graph<V, E> g, Set<V> vertexSet, Set<E> edgeSet) {
        this.mapVertexToOrder = new HashMap<V, Integer>(vertexSet.size());
        int counter = 0;
        for (V vertex : vertexSet) {
            this.mapVertexToOrder.put((Integer)vertex, new Integer(counter));
            ++counter;
        }
        this.labelsEdgesSet = new HashSet<LabelsEdge>(edgeSet.size());
        for (Object edge : edgeSet) {
            V sourceVertex = g.getEdgeSource(edge);
            Integer sourceOrder = this.mapVertexToOrder.get(sourceVertex);
            int sourceLabel = sourceOrder;
            int targetLabel = this.mapVertexToOrder.get(g.getEdgeTarget(edge));
            LabelsEdge lablesEdge = new LabelsEdge(sourceLabel, targetLabel);
            this.labelsEdgesSet.add(lablesEdge);
            if (!(g instanceof UndirectedGraph)) continue;
            LabelsEdge oppositeEdge = new LabelsEdge(targetLabel, sourceLabel);
            this.labelsEdgesSet.add(oppositeEdge);
        }
    }

    public boolean equalsByEdgeOrder(GraphOrdering otherGraph) {
        boolean result = ((Object)this.getLabelsEdgesSet()).equals(otherGraph.getLabelsEdgesSet());
        return result;
    }

    public Set<LabelsEdge> getLabelsEdgesSet() {
        return this.labelsEdgesSet;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("mapVertexToOrder=");
        Object[] vertexArray = new Object[this.mapVertexToOrder.size()];
        Set<V> keySet = this.mapVertexToOrder.keySet();
        for (V currVertex : keySet) {
            Integer index = this.mapVertexToOrder.get(currVertex);
            vertexArray[index.intValue()] = currVertex;
        }
        sb.append(ArrayUtil.toString(vertexArray));
        sb.append("labelsOrder=").append(this.labelsEdgesSet.toString());
        return sb.toString();
    }

    private class LabelsEdge {
        private int source;
        private int target;
        private int hashCode;

        public LabelsEdge(int aSource, int aTarget) {
            this.source = aSource;
            this.target = aTarget;
            this.hashCode = new String(this.source + "" + this.target).hashCode();
        }

        public boolean equals(Object obj) {
            LabelsEdge otherEdge = (LabelsEdge)obj;
            return this.source == otherEdge.source && this.target == otherEdge.target;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.source + "->" + this.target;
        }
    }
}

