/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DirectedSubgraph;

public class StrongConnectivityInspector<V, E> {
    private final DirectedGraph<V, E> graph;
    private LinkedList<VertexData<V>> orderedVertices;
    private List<Set<V>> stronglyConnectedSets;
    private List<DirectedSubgraph<V, E>> stronglyConnectedSubgraphs;
    private Map<V, VertexData<V>> vertexToVertexData;

    public StrongConnectivityInspector(DirectedGraph<V, E> directedGraph) {
        if (directedGraph == null) {
            throw new IllegalArgumentException("null not allowed for graph!");
        }
        this.graph = directedGraph;
        this.vertexToVertexData = null;
        this.orderedVertices = null;
        this.stronglyConnectedSets = null;
        this.stronglyConnectedSubgraphs = null;
    }

    public DirectedGraph<V, E> getGraph() {
        return this.graph;
    }

    public boolean isStronglyConnected() {
        return this.stronglyConnectedSets().size() == 1;
    }

    public List<Set<V>> stronglyConnectedSets() {
        if (this.stronglyConnectedSets == null) {
            VertexData<V> vertexData22;
            this.orderedVertices = new LinkedList();
            this.stronglyConnectedSets = new Vector<Set<V>>();
            this.createVertexData();
            for (VertexData<V> vertexData22 : this.vertexToVertexData.values()) {
                if (((VertexData)vertexData22).discovered) continue;
                this.dfsVisit(this.graph, vertexData22, null);
            }
            vertexData22 = new DefaultDirectedGraph(this.graph.getEdgeFactory());
            Graphs.addGraphReversed(vertexData22, this.graph);
            this.resetVertexData();
            for (VertexData<Object> vertexData3 : this.orderedVertices) {
                if (((VertexData)vertexData3).discovered) continue;
                HashSet hashSet = new HashSet();
                this.stronglyConnectedSets.add(hashSet);
                this.dfsVisit((DirectedGraph<V, E>)((Object)vertexData22), vertexData3, hashSet);
            }
            this.orderedVertices = null;
            this.vertexToVertexData = null;
        }
        return this.stronglyConnectedSets;
    }

    public List<DirectedSubgraph<V, E>> stronglyConnectedSubgraphs() {
        if (this.stronglyConnectedSubgraphs == null) {
            List<Set<V>> list = this.stronglyConnectedSets();
            this.stronglyConnectedSubgraphs = new Vector<DirectedSubgraph<V, E>>(list.size());
            Iterator<Set<V>> iterator = list.iterator();
            while (iterator.hasNext()) {
                this.stronglyConnectedSubgraphs.add(new DirectedSubgraph<V, E>(this.graph, iterator.next(), null));
            }
        }
        return this.stronglyConnectedSubgraphs;
    }

    private void createVertexData() {
        this.vertexToVertexData = new HashMap<V, VertexData<V>>(this.graph.vertexSet().size());
        for (Object v : this.graph.vertexSet()) {
            this.vertexToVertexData.put(v, new VertexData(null, v, false, false));
        }
    }

    private void dfsVisit(DirectedGraph<V, E> directedGraph, VertexData<V> vertexData, Set<V> set) {
        Stack<VertexData<V>> stack = new Stack<VertexData<V>>();
        stack.push(vertexData);
        while (!stack.isEmpty()) {
            VertexData vertexData2 = (VertexData)stack.pop();
            if (!vertexData2.discovered) {
                vertexData2.discovered = true;
                if (set != null) {
                    set.add(vertexData2.vertex);
                }
                stack.push(new VertexData(vertexData2, null, true, true));
                for (E e : directedGraph.outgoingEdgesOf(vertexData2.vertex)) {
                    VertexData<V> vertexData3 = this.vertexToVertexData.get(directedGraph.getEdgeTarget(e));
                    if (((VertexData)vertexData3).discovered) continue;
                    stack.push(vertexData3);
                }
                continue;
            }
            if (!vertexData2.finished || set != null) continue;
            this.orderedVertices.addFirst(vertexData2.finishedData);
        }
    }

    private void resetVertexData() {
        for (VertexData<V> vertexData : this.vertexToVertexData.values()) {
            ((VertexData)vertexData).discovered = false;
            ((VertexData)vertexData).finished = false;
        }
    }

    private static final class VertexData<V> {
        private final VertexData<V> finishedData;
        private final V vertex;
        private boolean discovered;
        private boolean finished;

        private VertexData(VertexData<V> vertexData, V v, boolean bl, boolean bl2) {
            this.finishedData = vertexData;
            this.vertex = v;
            this.discovered = bl;
            this.finished = bl2;
        }
    }
}

