/*
 * Decompiled with CFR 0.152.
 */
package fpc.tools.javapp;

import fpc.tools.javapp.ClassData;
import fpc.tools.javapp.ClassIdentifierInfo;
import fpc.tools.javapp.MethodData;
import fpc.tools.javapp.PascalTypeSignature;
import fpc.tools.javapp.TypeSignature;

public class PascalMethodData
extends MethodData {
    private String cachedName;

    public PascalMethodData(ClassData cls) {
        super(cls);
    }

    public String getVisibilitySectionName() {
        if ((this.access & 1) != 0) {
            return "public";
        }
        if ((this.access & 2) != 0) {
            return "strict private";
        }
        if ((this.access & 4) != 0) {
            return "strict protected";
        }
        return "private";
    }

    public String getModifiers() {
        if ((this.access & 0x10) != 0) {
            if (!this.isStatic()) {
                return " virtual; final;";
            }
            return " final;";
        }
        if ((this.access & 0x400) != 0) {
            return " virtual; abstract;";
        }
        if (!this.isStatic()) {
            return " virtual;";
        }
        return "";
    }

    public String getReturnType() {
        String rttype = new PascalTypeSignature(this.getInternalSig(), this.cls, false, false, false).getReturnType();
        return rttype;
    }

    public String getRawBaseReturnType() {
        String rttype = new TypeSignature(this.getInternalSig()).getReturnType();
        int arrPos = rttype.indexOf(91);
        if (arrPos != -1) {
            rttype = rttype.substring(0, arrPos);
        }
        return rttype;
    }

    public String getParameters(boolean useOpenArrays, boolean useConstOpenArrays, boolean useClassRef) {
        String ptype = new PascalTypeSignature(this.getInternalSig(), this.cls, useOpenArrays, useConstOpenArrays, useClassRef).getParameters();
        return ptype;
    }

    public String getExternalName() {
        String realName = super.getName();
        if (realName.equals("<init>") || realName.equals("<clinit>")) {
            return null;
        }
        String pascalName = this.getName();
        if (pascalName.charAt(0) == '&') {
            pascalName = pascalName.substring(1);
        }
        if (!pascalName.equals(realName)) {
            return realName;
        }
        return null;
    }

    public String getName() {
        if (this.cachedName == null) {
            String realName = super.getName();
            this.cachedName = ClassIdentifierInfo.AddMethodIdentifierNameForClass(this.cls.getClassName(), realName);
        }
        return this.cachedName;
    }
}

