/*
 * Decompiled with CFR 0.152.
 */
package fpc.tools.javapp;

import fpc.tools.javapp.AttrData;
import fpc.tools.javapp.CPX;
import fpc.tools.javapp.CPX2;
import fpc.tools.javapp.ClassIdentifierInfo;
import fpc.tools.javapp.FieldData;
import fpc.tools.javapp.InnerClassData;
import fpc.tools.javapp.JavapEnvironment;
import fpc.tools.javapp.MethodData;
import fpc.tools.javapp.PascalClassData;
import fpc.tools.javapp.PascalFieldData;
import fpc.tools.javapp.PascalInnerClassData;
import fpc.tools.javapp.PascalMethodData;
import fpc.tools.javapp.PascalUnit;
import fpc.tools.javapp.Tables;
import fpc.tools.javapp.TypeSignature;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class JavapPrinter {
    JavapEnvironment env;
    PascalClassData cls;
    String lP = "";
    PrintWriter out;
    String prefix;
    boolean doCollectDependencies;
    boolean printOnlySkel;
    private ArrayList<JavapPrinter> innerClassPrinters;
    private final int VIS_PRIVATE = 0;
    private final int VIS_PACKAGE = 1;
    private final int VIS_PROTECTED = 2;
    private final int VIS_PUBLIC = 3;

    public JavapPrinter(InputStream cname, PrintWriter out, JavapEnvironment env, String prefix, PascalClassData outerClass, boolean doCollectDependencies, boolean printOnlySkel) {
        this.out = out;
        this.cls = new PascalClassData(cname, outerClass, env, doCollectDependencies);
        this.env = env;
        this.prefix = prefix;
        this.doCollectDependencies = doCollectDependencies;
        this.printOnlySkel = printOnlySkel;
        this.innerClassPrinters = new ArrayList();
        this.collectInnerClasses();
    }

    public void print() {
        this.printclassHeader();
        if (!this.printOnlySkel) {
            this.printfields();
            this.printMethods();
        }
        this.printend();
    }

    public void printclassHeader() {
        String vis = this.cls.getVisibilitySectionName();
        String shortname = !this.cls.isInnerClass() ? this.cls.getShortPascalClassName() : this.cls.getShortClassName();
        if (!this.cls.isInnerClass() && vis != null) {
            if (!PascalClassData.currentUnit.parentIsKnownInterface(this.cls.getClassName())) {
                this.out.println(String.valueOf(this.prefix.substring(4)) + vis);
            }
            this.out.println(String.valueOf(this.prefix.substring(2)) + "type");
        }
        this.out.print(this.prefix);
        if (this.cls.isInterface()) {
            this.out.print(String.valueOf(shortname) + " = interface ");
        } else if (this.cls.isClass()) {
            this.out.print(String.valueOf(shortname) + " = class ");
            String[] accflags = this.cls.getModifiers();
            this.printAccess(accflags);
        }
        this.out.print("external ");
        String pkgname = this.cls.getClassPackageName();
        if (pkgname != null) {
            this.out.print("'" + pkgname + "' ");
        }
        this.out.print("name '" + this.cls.getExternalShortClassName() + "' ");
        if (!this.printOnlySkel) {
            String[] interfacelist;
            boolean printedOpeningBracket = false;
            String superClass = this.cls.getSuperClassName();
            if (superClass != null && (this.cls.isClass() || !PascalClassData.getShortPascalClassName(superClass).equals("JLObject"))) {
                String fullPascalSuperClass;
                printedOpeningBracket = true;
                String reducedPascalSuperClass = fullPascalSuperClass = PascalClassData.getFullPascalClassName(superClass);
                if (!PascalClassData.currentUnit.isExternalInnerClass(superClass) && this.cls.outerClass != null) {
                    reducedPascalSuperClass = fullPascalSuperClass.replace(String.valueOf(this.cls.outerClass.getShortPascalClassName()) + ".", "");
                }
                if (reducedPascalSuperClass.equals(fullPascalSuperClass)) {
                    this.out.print("(" + PascalClassData.getShortPascalClassName(superClass));
                } else {
                    this.out.print("(" + reducedPascalSuperClass);
                }
            }
            if ((interfacelist = this.cls.getPascalSuperInterfaces()).length > 0) {
                if (!printedOpeningBracket) {
                    this.out.print("(");
                    printedOpeningBracket = true;
                    this.out.print(interfacelist[0]);
                } else {
                    this.out.print(", " + interfacelist[0]);
                }
                int j = 1;
                while (j < interfacelist.length) {
                    this.out.print(", " + interfacelist[j]);
                    ++j;
                }
            }
            if (printedOpeningBracket) {
                this.out.print(")");
            }
        }
        this.printClassAttributes();
    }

    public void printverbosecls() {
        this.out.println(String.valueOf(this.prefix) + "  minor version: " + this.cls.getMinor_version());
        this.out.println(String.valueOf(this.prefix) + "  major version: " + this.cls.getMajor_version());
        this.out.println(String.valueOf(this.prefix) + "  Constant pool:");
        this.printcp();
        this.env.showallAttr = true;
    }

    public void printClassAttributes() {
        this.out.println();
        AttrData[] clsattrs = this.cls.getAttributes();
        int i = 0;
        while (i < clsattrs.length) {
            String clsattrname = clsattrs[i].getAttrName();
            if (clsattrname.equals("InnerClasses")) {
                this.printInnerClasses();
            }
            ++i;
        }
    }

    public void printfields() {
        FieldData[] fields = this.cls.getFields();
        String prevVis = "";
        String prevMod = "";
        this.prefix = String.valueOf(this.prefix) + "    ";
        int f = 0;
        while (f < fields.length) {
            String[] accflags;
            PascalFieldData field = (PascalFieldData)fields[f];
            if (!field.isSynthetic() && this.checkAccess(accflags = field.getAccess())) {
                String newVis = field.getVisibilitySectionName();
                String newMod = field.getModifiers();
                if (!(!this.cls.isClass() || newVis.equals(prevVis) && newMod.equals(prevMod))) {
                    this.out.println(String.valueOf(this.prefix.substring(4)) + newVis);
                    prevVis = newVis;
                    prevMod = "";
                }
                if (!newMod.equals(prevMod)) {
                    this.out.println(String.valueOf(this.prefix.substring(2)) + newMod);
                    prevMod = newMod;
                }
                String fieldName = field.getName();
                this.out.print(this.prefix);
                if (fieldName.contains("$")) {
                    this.out.print("// ");
                }
                if (!field.isFormalConst()) {
                    this.out.print(String.valueOf(fieldName) + ": " + field.getType());
                } else {
                    this.out.print(fieldName);
                    this.printConstantValue(field);
                }
                this.printFieldAttributes(field);
                if (!field.isFormalConst()) {
                    this.out.print("; external name '" + fieldName.substring(1) + "'");
                }
                this.out.println(";");
            }
            ++f;
        }
        this.prefix = this.prefix.substring(4);
    }

    public void printFieldAttributes(FieldData field) {
        if (field.isDeprecated()) {
            this.out.print(" deprecated");
        }
    }

    public void printMethods() {
        MethodData[] methods = this.cls.getMethods();
        String prevVis = "";
        this.prefix = String.valueOf(this.prefix) + "  ";
        int m = 0;
        while (m < methods.length) {
            String[] accflags;
            PascalMethodData method = (PascalMethodData)methods[m];
            if (!method.isSynthetic() && this.checkAccess(accflags = method.getAccess())) {
                String newVis = method.getVisibilitySectionName();
                if (this.cls.isClass() && !newVis.equals(prevVis)) {
                    this.out.println(String.valueOf(this.prefix.substring(2)) + newVis);
                    prevVis = newVis;
                }
                this.printMethodSignature(method);
            }
            ++m;
        }
        this.prefix = this.prefix.substring(2);
    }

    public void printMethodSignature(PascalMethodData method) {
        boolean varargs;
        StringBuilder sigStart = new StringBuilder();
        sigStart.append(this.prefix);
        String pascalName = method.getName();
        boolean bl = varargs = (method.access & 0x80) != 0;
        if (pascalName.equals("<init>")) {
            sigStart.append("constructor create");
            StringBuilder sigEnd = new StringBuilder();
            sigEnd.append("; overload;");
            String dynArrParas = method.getParameters(false, true, false);
            String openArrParas = method.getParameters(true, true, false);
            String dynArrParasClassRef = method.getParameters(false, false, true);
            this.out.print(sigStart + dynArrParas + sigEnd);
            this.printExceptions(method);
            this.out.println();
            if (!dynArrParas.equals(dynArrParasClassRef)) {
                this.out.print(sigStart + dynArrParasClassRef + sigEnd);
                this.printExceptions(method);
                this.out.println();
            }
            if (!dynArrParas.equals(openArrParas)) {
                this.out.print(sigStart + openArrParas + sigEnd);
                this.printExceptions(method);
                this.out.println();
                String openArrParasClassRef = method.getParameters(true, true, true);
                if (!openArrParas.equals(openArrParasClassRef)) {
                    this.out.print(sigStart + openArrParasClassRef + sigEnd);
                    this.printExceptions(method);
                    this.out.println();
                }
            }
        } else if (pascalName.equals("<clinit>")) {
            sigStart.append("class constructor classcreate");
        } else {
            String externalName;
            String rettype = method.getReturnType();
            if (method.isStatic()) {
                sigStart.append("class ");
            }
            if (rettype.equals("")) {
                sigStart.append("procedure ");
            } else {
                sigStart.append("function ");
            }
            sigStart.append(pascalName);
            StringBuilder sigEnd = new StringBuilder();
            if (!rettype.equals("")) {
                sigEnd.append(": " + rettype);
            }
            if (method.isStatic()) {
                sigEnd.append("; static");
            }
            if ((externalName = method.getExternalName()) != null) {
                sigEnd.append("; external name '" + externalName + "'");
            }
            sigEnd.append("; overload;");
            if (!this.cls.isInterface()) {
                sigEnd.append(method.getModifiers());
            }
            String dynArrParas = method.getParameters(false, false, false);
            String openArrParas = method.getParameters(true, varargs, false);
            String dynArrParasClassRef = method.getParameters(false, false, true);
            this.out.print(sigStart + dynArrParas + sigEnd);
            this.printExceptions(method);
            this.out.println();
            if (!dynArrParas.equals(dynArrParasClassRef)) {
                this.out.print(sigStart + dynArrParasClassRef + sigEnd);
                this.printExceptions(method);
                this.out.println();
            }
            if (!dynArrParas.equals(openArrParas)) {
                this.out.print(sigStart + openArrParas + sigEnd);
                this.printExceptions(method);
                this.out.println();
                String openArrParasClassRef = method.getParameters(true, varargs, true);
                if (!openArrParas.equals(openArrParasClassRef)) {
                    this.out.print(sigStart + openArrParasClassRef + sigEnd);
                    this.printExceptions(method);
                    this.out.println();
                }
            }
        }
    }

    public void printMethodAttributes(MethodData method) {
        Vector methodattrs = method.getAttributes();
        int k = 0;
        while (k < methodattrs.size()) {
            String methodattrname = ((AttrData)methodattrs.elementAt(k)).getAttrName();
            if (!methodattrname.equals("Code")) {
                if (methodattrname.equals("Exceptions")) {
                    this.out.println(String.valueOf(this.prefix) + "  Exceptions: ");
                    this.printExceptions(method);
                } else if (methodattrname.equals("Deprecated")) {
                    this.out.println(String.valueOf(this.prefix) + "  Deprecated: " + method.isDeprecated());
                } else if (methodattrname.equals("Synthetic")) {
                    this.out.println(String.valueOf(this.prefix) + "  Synthetic: " + method.isSynthetic());
                } else {
                    this.printAttrData((AttrData)methodattrs.elementAt(k));
                }
            }
            ++k;
        }
        this.out.println();
    }

    public void printExceptions(MethodData method) {
        int[] exc_index_table = method.get_exc_index_table();
        if (exc_index_table != null) {
            this.out.print("  // throws ");
            int l = exc_index_table.length;
            int k = 0;
            while (k < l) {
                this.out.print(this.javaclassname(this.cls.getClassName(exc_index_table[k])));
                if (k < l - 1) {
                    this.out.print(", ");
                }
                ++k;
            }
        }
    }

    public void printcodeSequence(MethodData method) {
    }

    public void printVerboseHeader(MethodData method) {
    }

    void printExceptionTable(MethodData method) {
    }

    public void printLineNumTable(MethodData method) {
    }

    public void printLocVarTable(MethodData method) {
    }

    public void printStackMap(MethodData method) {
    }

    public void printStackMapTable(MethodData method) {
    }

    void printMap(String name, int[] map) {
        this.out.print(name);
        int i = 0;
        while (i < map.length) {
            int fulltype = map[i];
            int type = fulltype & 0xFF;
            int argument = fulltype >> 8;
            switch (type) {
                case 7: {
                    this.out.print(" ");
                    this.PrintConstant(argument);
                    break;
                }
                case 8: {
                    this.out.print(" " + Tables.mapTypeName(type));
                    this.out.print(" " + argument);
                    break;
                }
                default: {
                    this.out.print(" " + Tables.mapTypeName(type));
                }
            }
            this.out.print(i == map.length - 1 ? (char)' ' : ',');
            ++i;
        }
        this.out.println("]");
    }

    public void printConstantValue(FieldData field) {
        int cpx = field.getConstantValueIndex();
        if (cpx == 0) {
            return;
        }
        byte tag = 0;
        try {
            tag = this.cls.getTag(cpx);
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
        switch (tag) {
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return;
            }
        }
        this.out.print(" = " + this.cls.StringValue(cpx));
    }

    public void collectInnerClasses() {
        InnerClassData[] innerClasses = this.cls.getInnerClasses();
        if (innerClasses != null && innerClasses.length > 0) {
            String curClassName = this.cls.getClassName();
            int i = 0;
            while (i < innerClasses.length) {
                String[] accflags = innerClasses[i].getAccess();
                PascalInnerClassData inner = (PascalInnerClassData)innerClasses[i];
                String innerClassName = this.cls.StringValue(inner.inner_class_info_index);
                if (innerClassName.startsWith(String.valueOf(curClassName) + "$") && (innerClassName.charAt(curClassName.length() + 1) < '0' || innerClassName.charAt(curClassName.length() + 1) > '9')) {
                    boolean accessOk = this.checkAccess(accflags);
                    boolean isStaticInner = inner.isStatic();
                    JavapPrinter innerPrinter = new JavapPrinter(this.env.getFileInputStream(this.javaclassname(innerClassName)), this.out, this.env, String.valueOf(this.prefix) + "    ", this.cls, this.doCollectDependencies && accessOk && isStaticInner, this.printOnlySkel || !accessOk || !isStaticInner);
                    this.innerClassPrinters.add(innerPrinter);
                }
                ++i;
            }
        }
    }

    private boolean checkInnerVisibility(int access, int visOk) {
        switch (visOk) {
            case 0: {
                return (access & 2) != 0;
            }
            case 1: {
                return (access & 7) == 0;
            }
            case 2: {
                return (access & 4) != 0;
            }
            case 3: {
                return (access & 1) != 0;
            }
        }
        return false;
    }

    private String visibilitySectionName(int vis) {
        switch (vis) {
            case 0: {
                return "strict private";
            }
            case 1: {
                return "public";
            }
            case 2: {
                return "protected";
            }
            case 3: {
                return "public";
            }
        }
        return "";
    }

    public void printInnerClasses() {
        if (this.innerClassPrinters.size() > 1) {
            this.orderInnerClasses();
        }
        if (this.innerClassPrinters.size() > 0) {
            int protpub = 1;
            while (protpub <= 3) {
                JavapPrinter innerPrinter;
                boolean first = true;
                int i = 0;
                while (i < this.innerClassPrinters.size()) {
                    innerPrinter = this.innerClassPrinters.get(i);
                    if (this.checkInnerVisibility(innerPrinter.cls.access, protpub)) {
                        String shortInnerName = PascalClassData.getShortClassName(innerPrinter.cls.getClassName());
                        String shortInnerSafeName = ClassIdentifierInfo.AddIdentifierNameForClass(this.cls.getClassName(), shortInnerName);
                        if (first) {
                            if (!this.cls.isInterface()) {
                                this.out.print(this.prefix);
                                this.out.println(this.visibilitySectionName(protpub));
                            }
                            this.out.println(String.valueOf(innerPrinter.prefix.substring(2)) + "type");
                            first = false;
                        }
                        this.out.print(String.valueOf(innerPrinter.prefix) + shortInnerSafeName + " = ");
                        if (innerPrinter.cls.isClass()) {
                            this.out.println("class;");
                        } else {
                            this.out.println("interface;");
                        }
                        PascalUnit.printArrayTypes(this.out, innerPrinter.prefix, shortInnerName, shortInnerSafeName);
                    }
                    ++i;
                }
                i = 0;
                while (i < this.innerClassPrinters.size()) {
                    innerPrinter = this.innerClassPrinters.get(i);
                    if (this.checkInnerVisibility(innerPrinter.cls.access, protpub)) {
                        innerPrinter.print();
                    }
                    ++i;
                }
                ++protpub;
            }
        }
    }

    private void orderInnerClasses() {
        boolean haveDependencies = false;
        int i = 0;
        while (i < this.innerClassPrinters.size()) {
            if (!this.innerClassPrinters.get((int)i).cls.getDependencies().isEmpty()) {
                haveDependencies = true;
                break;
            }
            ++i;
        }
        if (haveDependencies) {
            SimpleDirectedGraph<String, DefaultEdge> classDependencies = new SimpleDirectedGraph<String, DefaultEdge>(DefaultEdge.class);
            int i2 = 0;
            while (i2 < this.innerClassPrinters.size()) {
                JavapPrinter innerPrinter = this.innerClassPrinters.get(i2);
                String currentClass = innerPrinter.cls.getClassName();
                if (!classDependencies.containsVertex(currentClass)) {
                    classDependencies.addVertex(currentClass);
                }
                HashSet<String> dependencies = innerPrinter.cls.getDependencies();
                for (String dep : dependencies) {
                    if (!classDependencies.containsVertex(dep)) {
                        classDependencies.addVertex(dep);
                    }
                    classDependencies.addEdge(dep, currentClass);
                }
                ++i2;
            }
            TopologicalOrderIterator printerStepper = new TopologicalOrderIterator(classDependencies);
            ArrayList<JavapPrinter> orderedInnerClassPrinters = new ArrayList<JavapPrinter>(this.innerClassPrinters.size());
            block3: while (printerStepper.hasNext()) {
                String currentName = (String)printerStepper.next();
                int i3 = 0;
                while (i3 < this.innerClassPrinters.size()) {
                    if (this.innerClassPrinters.get((int)i3).cls.getClassName().equals(currentName)) {
                        orderedInnerClassPrinters.add(this.innerClassPrinters.get(i3));
                        continue block3;
                    }
                    ++i3;
                }
            }
            this.innerClassPrinters = orderedInnerClassPrinters;
        }
    }

    public void printcp() {
        int cpx = 1;
        while (cpx < this.cls.getCpoolCount()) {
            this.out.print("const #" + cpx + " = ");
            cpx += this.PrintlnConstantEntry(cpx);
        }
        this.out.println();
    }

    public int PrintlnConstantEntry(int cpx) {
        int size = 1;
        byte tag = 0;
        try {
            tag = this.cls.getTag(cpx);
        }
        catch (IndexOutOfBoundsException e) {
            this.out.println("  <Incorrect CP index>");
            return 1;
        }
        this.out.print(String.valueOf(this.cls.StringTag(cpx)) + "\t");
        Object x = this.cls.getCpoolEntryobj(cpx);
        if (x == null) {
            switch (tag) {
                case 5: 
                case 6: {
                    size = 2;
                }
            }
            this.out.println("null;");
            return size;
        }
        String str = this.cls.StringValue(cpx);
        switch (tag) {
            case 7: 
            case 8: {
                this.out.println("#" + ((CPX)x).cpx + ";\t//  " + str);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                this.out.println("#" + ((CPX2)x).cpx1 + ".#" + ((CPX2)x).cpx2 + ";\t//  " + str);
                break;
            }
            case 12: {
                this.out.println("#" + ((CPX2)x).cpx1 + ":#" + ((CPX2)x).cpx2 + ";//  " + str);
                break;
            }
            case 5: 
            case 6: {
                size = 2;
            }
            default: {
                this.out.println(String.valueOf(str) + ";");
            }
        }
        return size;
    }

    public boolean checkAccess(String[] accflags) {
        return TypeSignature.checkAccess(accflags, this.env);
    }

    public void printAccess(String[] accflags) {
        int j = 0;
        while (j < accflags.length) {
            this.out.print(String.valueOf(accflags[j]) + " ");
            ++j;
        }
    }

    public void printFixedWidthInt(long x, int length) {
        CharArrayWriter baStream = new CharArrayWriter();
        PrintWriter pStream = new PrintWriter(baStream);
        pStream.print(x);
        String str = baStream.toString();
        int cnt = length - str.length();
        while (cnt > 0) {
            this.out.print(' ');
            --cnt;
        }
        this.out.print(str);
    }

    void PrintConstant(int cpx) {
        if (cpx == 0) {
            this.out.print("#0");
            return;
        }
        byte tag = 0;
        try {
            tag = this.cls.getTag(cpx);
        }
        catch (IndexOutOfBoundsException e) {
            this.out.print("#" + cpx);
            return;
        }
        switch (tag) {
            case 9: 
            case 10: 
            case 11: {
                CPX2 x = this.cls.getCpoolEntry(cpx);
                if (x.cpx1 != this.cls.getthis_cpx()) break;
                cpx = x.cpx2;
            }
        }
        this.out.print(String.valueOf(this.cls.TagString(tag)) + " " + this.cls.StringValue(cpx));
    }

    protected static int align(int n) {
        return n + 3 & 0xFFFFFFFC;
    }

    public void printend() {
        this.out.println(String.valueOf(this.prefix) + "end;");
        this.out.println();
    }

    public String javaclassname(String name) {
        return name.replace('/', '.');
    }

    public String javaparentclassname(String name) {
        int index = name.lastIndexOf(36);
        if (index == -1) {
            return "";
        }
        return name.substring(0, index);
    }

    public int javaclassnestinglevel(String name) {
        int count = 0;
        int i = 1;
        while (i < name.length()) {
            if (name.charAt(i) == '$') {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void printAttrData(AttrData attr) {
        byte[] data = attr.getData();
        int i = 0;
        int j = 0;
        this.out.print("  " + attr.getAttrName() + ": ");
        this.out.println("length = " + PascalClassData.toHex(attr.datalen));
        this.out.print("   ");
        while (i < data.length) {
            String databytestring = PascalClassData.toHex(data[i]);
            if (databytestring.equals("0x")) {
                this.out.print("00");
            } else if (databytestring.substring(2).length() == 1) {
                this.out.print("0" + databytestring.substring(2));
            } else {
                this.out.print(databytestring.substring(2));
            }
            if (++j == 16) {
                this.out.println();
                this.out.print("   ");
                j = 0;
            } else {
                this.out.print(" ");
            }
            ++i;
        }
        this.out.println();
    }
}

