/*
 * Decompiled with CFR 0.152.
 */
package fpc.tools.javapp;

import fpc.tools.javapp.PascalKeywords;
import java.util.HashMap;

public class ClassIdentifierInfo {
    protected static HashMap<String, ClassIdentifierInfo> identifierStore = new HashMap();
    String[] superClasses;
    HashMap<String, String> identifiers = new HashMap();

    protected ClassIdentifierInfo(String[] superClasses) {
        this.superClasses = superClasses;
    }

    public static void registerClassInfo(String className, String superClass, String[] superIntf) {
        if (identifierStore.get(className) == null) {
            String[] combinedSuperInfo;
            if (superIntf.length == 0) {
                combinedSuperInfo = new String[superClass != null ? 1 : 0];
            } else {
                combinedSuperInfo = new String[superIntf.length + 1];
                int i = 0;
                while (i < superIntf.length) {
                    combinedSuperInfo[i] = superIntf[i];
                    ++i;
                }
            }
            if (superClass != null) {
                combinedSuperInfo[combinedSuperInfo.length - 1] = superClass;
            }
            ClassIdentifierInfo classIdInfo = new ClassIdentifierInfo(combinedSuperInfo);
            identifierStore.put(className, classIdInfo);
        }
    }

    private static String getMapIdentifer(String id) {
        String testName = id.equals("<init>") ? "CREATE" : (id.equals("<clinit") ? "CLASSCONSTRUCTOR" : id.toUpperCase());
        return testName;
    }

    private String checkSafeIdentifierName(String id, String testName, boolean checkSupers) {
        String orgName;
        if (checkSupers) {
            int i = 0;
            while (i < this.superClasses.length) {
                id = ClassIdentifierInfo.getSafeIdentifierNameForClassInternal(this.superClasses[i], id, testName, checkSupers);
                ++i;
            }
        }
        if ((id = PascalKeywords.escapeIfPascalKeyword(id)).contains("$")) {
            System.out.println("  Warning, cannot represent identifier '" + id + "', hiding");
            id = id.replace("$", "__");
        }
        while ((orgName = this.identifiers.get(testName)) != null && !orgName.equals(id)) {
            id = String.valueOf(id) + "_";
            testName = String.valueOf(testName) + "_";
        }
        return id;
    }

    private String addIdentifier(String id) {
        String testName = ClassIdentifierInfo.getMapIdentifer(id);
        id = this.checkSafeIdentifierName(id, testName, true);
        this.identifiers.put(testName, id);
        return id;
    }

    private String addMethodIdentifier(String id) {
        String testName = ClassIdentifierInfo.getMapIdentifer(id);
        id = this.checkSafeIdentifierName(id, testName, false);
        this.identifiers.put(testName, id);
        return id;
    }

    public static String AddIdentifierNameForClass(String className, String identifier) {
        ClassIdentifierInfo classIdInfo = identifierStore.get(className);
        if (classIdInfo == null) {
            throw new IllegalStateException("Class info for " + className + " not registered");
        }
        return classIdInfo.addIdentifier(identifier);
    }

    public static String AddMethodIdentifierNameForClass(String className, String identifier) {
        ClassIdentifierInfo classIdInfo;
        if (identifier.equals("create")) {
            identifier = "create_";
        }
        if ((classIdInfo = identifierStore.get(className)) == null) {
            throw new IllegalStateException("Class info for " + className + " not registered");
        }
        return classIdInfo.addMethodIdentifier(identifier);
    }

    private static String getSafeIdentifierNameForClassInternal(String className, String identifier, String testName, boolean checkSupers) {
        ClassIdentifierInfo classIdInfo = identifierStore.get(className);
        if (classIdInfo == null) {
            throw new IllegalStateException("Class info for " + className + " not registered");
        }
        return classIdInfo.checkSafeIdentifierName(identifier, testName, checkSupers);
    }

    public static String getSafeIdentifierNameForClass(String className, String identifier) {
        return ClassIdentifierInfo.getSafeIdentifierNameForClassInternal(className, identifier, ClassIdentifierInfo.getMapIdentifer(identifier), false);
    }

    public static String getSafeMethodIdentifierNameForClass(String className, String identifier) {
        if (identifier.equals("create")) {
            identifier = "create_";
        }
        return ClassIdentifierInfo.getSafeIdentifierNameForClassInternal(className, identifier, ClassIdentifierInfo.getMapIdentifer(identifier), true);
    }
}

