/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.common;

import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class CommonDictionary<V> {
    DoubleArrayTrie<V> trie;

    protected abstract V[] loadValueArray(ByteArray var1);

    public boolean load(String path) {
        this.trie = new DoubleArrayTrie();
        long start = System.currentTimeMillis();
        if (this.loadDat(ByteArray.createByteArray(path + ".bin"))) {
            return true;
        }
        TreeMap<String, V> map = new TreeMap<String, V>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(IOUtil.newInputStream(path), "UTF-8"));
            while ((line = br.readLine()) != null) {
                String[] paramArray = line.split("\\s");
                map.put(paramArray[0], this.createValue(paramArray));
            }
            br.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6" + path + "\u5931\u8d25" + e);
            return false;
        }
        this.onLoaded(map);
        Set entrySet = map.entrySet();
        ArrayList<String> keyList = new ArrayList<String>(entrySet.size());
        ArrayList valueList = new ArrayList(entrySet.size());
        for (Map.Entry entry : entrySet) {
            keyList.add((String)entry.getKey());
            valueList.add(entry.getValue());
        }
        int resultCode = this.trie.build(keyList, valueList);
        if (resultCode != 0) {
            Predefine.logger.warning("trie\u5efa\u7acb\u5931\u8d25");
            return false;
        }
        Predefine.logger.info(path + "\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
        this.saveDat(path + ".bin", valueList);
        return true;
    }

    protected boolean loadDat(ByteArray byteArray) {
        V[] valueArray = this.loadValueArray(byteArray);
        if (valueArray == null) {
            return false;
        }
        return this.trie.load(byteArray.getBytes(), byteArray.getOffset(), valueArray);
    }

    protected boolean saveDat(String path, List<V> valueArray) {
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(IOUtil.newOutputStream(path)));
            out.writeInt(valueArray.size());
            for (V item : valueArray) {
                this.saveValue(item, out);
            }
            this.trie.save(out);
            out.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u4fdd\u5b58\u5931\u8d25" + TextUtility.exceptionToString(e));
            return false;
        }
        return true;
    }

    protected abstract void saveValue(V var1, DataOutputStream var2) throws IOException;

    public V get(String key) {
        return this.trie.get(key);
    }

    public boolean contains(String key) {
        return this.get(key) != null;
    }

    public int size() {
        return this.trie.size();
    }

    protected abstract V createValue(String[] var1);

    protected void onLoaded(TreeMap<String, V> map) {
    }
}

