#!/bin/sh

ARCH=`arch`
OSYS=`uname`
VERSION=1.0.3


echo "building packages for $ARCH"


echo "creating static english binary tar"
strip ./elem-static-en
tar -zcvf elem-bin-static-en-$VERSION-$OSYS-$ARCH.tgz ./elem-static-en ./README ./COPYING

echo "creating static german binary tar"
strip ./elem-static-de
tar -zcvf elem-bin-static-de-$VERSION-$OSYS-$ARCH.tgz ./elem-static-de ./README ./COPYING

echo "creating dynamic english binary tar"
strip ./elem-en
tar -zcvf elem-bin-en-$VERSION-$OSYS-$ARCH.tgz ./elem-en ./README ./COPYING

echo "creating dynamic german binary tar"
strip ./elem-de
tar -zcvf elem-bin-de-$VERSION-$OSYS-$ARCH.tgz ./elem-de ./README ./COPYING


echo "creating source tar"
make clean
cd ..
tar -zcvf elem-src-$VERSION-$OSYS.tgz ./elem
mv elem-src-$VERSION-$OSYS.tgz elem/
cd elem
