// Copyright 2023 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package cloudsearch provides access to the Cloud Search API.
//
// For product documentation, see: https://developers.google.com/cloud-search/docs/guides/
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/cloudsearch/v1"
//	...
//	ctx := context.Background()
//	cloudsearchService, err := cloudsearch.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate. To restrict scopes, use option.WithScopes:
//
//	cloudsearchService, err := cloudsearch.NewService(ctx, option.WithScopes(cloudsearch.CloudSearchStatsIndexingScope))
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//	cloudsearchService, err := cloudsearch.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	cloudsearchService, err := cloudsearch.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package cloudsearch // import "google.golang.org/api/cloudsearch/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "cloudsearch:v1"
const apiName = "cloudsearch"
const apiVersion = "v1"
const basePath = "https://cloudsearch.googleapis.com/"
const mtlsBasePath = "https://cloudsearch.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// Index and serve your organization's data with Cloud Search
	CloudSearchScope = "https://www.googleapis.com/auth/cloud_search"

	// Index and serve your organization's data with Cloud Search
	CloudSearchDebugScope = "https://www.googleapis.com/auth/cloud_search.debug"

	// Index and serve your organization's data with Cloud Search
	CloudSearchIndexingScope = "https://www.googleapis.com/auth/cloud_search.indexing"

	// Search your organization's data in the Cloud Search index
	CloudSearchQueryScope = "https://www.googleapis.com/auth/cloud_search.query"

	// Index and serve your organization's data with Cloud Search
	CloudSearchSettingsScope = "https://www.googleapis.com/auth/cloud_search.settings"

	// Index and serve your organization's data with Cloud Search
	CloudSearchSettingsIndexingScope = "https://www.googleapis.com/auth/cloud_search.settings.indexing"

	// Index and serve your organization's data with Cloud Search
	CloudSearchSettingsQueryScope = "https://www.googleapis.com/auth/cloud_search.settings.query"

	// Index and serve your organization's data with Cloud Search
	CloudSearchStatsScope = "https://www.googleapis.com/auth/cloud_search.stats"

	// Index and serve your organization's data with Cloud Search
	CloudSearchStatsIndexingScope = "https://www.googleapis.com/auth/cloud_search.stats.indexing"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud_search",
		"https://www.googleapis.com/auth/cloud_search.debug",
		"https://www.googleapis.com/auth/cloud_search.indexing",
		"https://www.googleapis.com/auth/cloud_search.query",
		"https://www.googleapis.com/auth/cloud_search.settings",
		"https://www.googleapis.com/auth/cloud_search.settings.indexing",
		"https://www.googleapis.com/auth/cloud_search.settings.query",
		"https://www.googleapis.com/auth/cloud_search.stats",
		"https://www.googleapis.com/auth/cloud_search.stats.indexing",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Debug = NewDebugService(s)
	s.Indexing = NewIndexingService(s)
	s.Media = NewMediaService(s)
	s.Operations = NewOperationsService(s)
	s.Query = NewQueryService(s)
	s.Settings = NewSettingsService(s)
	s.Stats = NewStatsService(s)
	s.V1 = NewV1Service(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Debug *DebugService

	Indexing *IndexingService

	Media *MediaService

	Operations *OperationsService

	Query *QueryService

	Settings *SettingsService

	Stats *StatsService

	V1 *V1Service
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewDebugService(s *Service) *DebugService {
	rs := &DebugService{s: s}
	rs.Datasources = NewDebugDatasourcesService(s)
	rs.Identitysources = NewDebugIdentitysourcesService(s)
	return rs
}

type DebugService struct {
	s *Service

	Datasources *DebugDatasourcesService

	Identitysources *DebugIdentitysourcesService
}

func NewDebugDatasourcesService(s *Service) *DebugDatasourcesService {
	rs := &DebugDatasourcesService{s: s}
	rs.Items = NewDebugDatasourcesItemsService(s)
	return rs
}

type DebugDatasourcesService struct {
	s *Service

	Items *DebugDatasourcesItemsService
}

func NewDebugDatasourcesItemsService(s *Service) *DebugDatasourcesItemsService {
	rs := &DebugDatasourcesItemsService{s: s}
	rs.Unmappedids = NewDebugDatasourcesItemsUnmappedidsService(s)
	return rs
}

type DebugDatasourcesItemsService struct {
	s *Service

	Unmappedids *DebugDatasourcesItemsUnmappedidsService
}

func NewDebugDatasourcesItemsUnmappedidsService(s *Service) *DebugDatasourcesItemsUnmappedidsService {
	rs := &DebugDatasourcesItemsUnmappedidsService{s: s}
	return rs
}

type DebugDatasourcesItemsUnmappedidsService struct {
	s *Service
}

func NewDebugIdentitysourcesService(s *Service) *DebugIdentitysourcesService {
	rs := &DebugIdentitysourcesService{s: s}
	rs.Items = NewDebugIdentitysourcesItemsService(s)
	rs.Unmappedids = NewDebugIdentitysourcesUnmappedidsService(s)
	return rs
}

type DebugIdentitysourcesService struct {
	s *Service

	Items *DebugIdentitysourcesItemsService

	Unmappedids *DebugIdentitysourcesUnmappedidsService
}

func NewDebugIdentitysourcesItemsService(s *Service) *DebugIdentitysourcesItemsService {
	rs := &DebugIdentitysourcesItemsService{s: s}
	return rs
}

type DebugIdentitysourcesItemsService struct {
	s *Service
}

func NewDebugIdentitysourcesUnmappedidsService(s *Service) *DebugIdentitysourcesUnmappedidsService {
	rs := &DebugIdentitysourcesUnmappedidsService{s: s}
	return rs
}

type DebugIdentitysourcesUnmappedidsService struct {
	s *Service
}

func NewIndexingService(s *Service) *IndexingService {
	rs := &IndexingService{s: s}
	rs.Datasources = NewIndexingDatasourcesService(s)
	return rs
}

type IndexingService struct {
	s *Service

	Datasources *IndexingDatasourcesService
}

func NewIndexingDatasourcesService(s *Service) *IndexingDatasourcesService {
	rs := &IndexingDatasourcesService{s: s}
	rs.Items = NewIndexingDatasourcesItemsService(s)
	return rs
}

type IndexingDatasourcesService struct {
	s *Service

	Items *IndexingDatasourcesItemsService
}

func NewIndexingDatasourcesItemsService(s *Service) *IndexingDatasourcesItemsService {
	rs := &IndexingDatasourcesItemsService{s: s}
	return rs
}

type IndexingDatasourcesItemsService struct {
	s *Service
}

func NewMediaService(s *Service) *MediaService {
	rs := &MediaService{s: s}
	return rs
}

type MediaService struct {
	s *Service
}

func NewOperationsService(s *Service) *OperationsService {
	rs := &OperationsService{s: s}
	rs.Lro = NewOperationsLroService(s)
	return rs
}

type OperationsService struct {
	s *Service

	Lro *OperationsLroService
}

func NewOperationsLroService(s *Service) *OperationsLroService {
	rs := &OperationsLroService{s: s}
	return rs
}

type OperationsLroService struct {
	s *Service
}

func NewQueryService(s *Service) *QueryService {
	rs := &QueryService{s: s}
	rs.Sources = NewQuerySourcesService(s)
	return rs
}

type QueryService struct {
	s *Service

	Sources *QuerySourcesService
}

func NewQuerySourcesService(s *Service) *QuerySourcesService {
	rs := &QuerySourcesService{s: s}
	return rs
}

type QuerySourcesService struct {
	s *Service
}

func NewSettingsService(s *Service) *SettingsService {
	rs := &SettingsService{s: s}
	rs.Datasources = NewSettingsDatasourcesService(s)
	rs.Searchapplications = NewSettingsSearchapplicationsService(s)
	return rs
}

type SettingsService struct {
	s *Service

	Datasources *SettingsDatasourcesService

	Searchapplications *SettingsSearchapplicationsService
}

func NewSettingsDatasourcesService(s *Service) *SettingsDatasourcesService {
	rs := &SettingsDatasourcesService{s: s}
	return rs
}

type SettingsDatasourcesService struct {
	s *Service
}

func NewSettingsSearchapplicationsService(s *Service) *SettingsSearchapplicationsService {
	rs := &SettingsSearchapplicationsService{s: s}
	return rs
}

type SettingsSearchapplicationsService struct {
	s *Service
}

func NewStatsService(s *Service) *StatsService {
	rs := &StatsService{s: s}
	rs.Index = NewStatsIndexService(s)
	rs.Query = NewStatsQueryService(s)
	rs.Session = NewStatsSessionService(s)
	rs.User = NewStatsUserService(s)
	return rs
}

type StatsService struct {
	s *Service

	Index *StatsIndexService

	Query *StatsQueryService

	Session *StatsSessionService

	User *StatsUserService
}

func NewStatsIndexService(s *Service) *StatsIndexService {
	rs := &StatsIndexService{s: s}
	rs.Datasources = NewStatsIndexDatasourcesService(s)
	return rs
}

type StatsIndexService struct {
	s *Service

	Datasources *StatsIndexDatasourcesService
}

func NewStatsIndexDatasourcesService(s *Service) *StatsIndexDatasourcesService {
	rs := &StatsIndexDatasourcesService{s: s}
	return rs
}

type StatsIndexDatasourcesService struct {
	s *Service
}

func NewStatsQueryService(s *Service) *StatsQueryService {
	rs := &StatsQueryService{s: s}
	rs.Searchapplications = NewStatsQuerySearchapplicationsService(s)
	return rs
}

type StatsQueryService struct {
	s *Service

	Searchapplications *StatsQuerySearchapplicationsService
}

func NewStatsQuerySearchapplicationsService(s *Service) *StatsQuerySearchapplicationsService {
	rs := &StatsQuerySearchapplicationsService{s: s}
	return rs
}

type StatsQuerySearchapplicationsService struct {
	s *Service
}

func NewStatsSessionService(s *Service) *StatsSessionService {
	rs := &StatsSessionService{s: s}
	rs.Searchapplications = NewStatsSessionSearchapplicationsService(s)
	return rs
}

type StatsSessionService struct {
	s *Service

	Searchapplications *StatsSessionSearchapplicationsService
}

func NewStatsSessionSearchapplicationsService(s *Service) *StatsSessionSearchapplicationsService {
	rs := &StatsSessionSearchapplicationsService{s: s}
	return rs
}

type StatsSessionSearchapplicationsService struct {
	s *Service
}

func NewStatsUserService(s *Service) *StatsUserService {
	rs := &StatsUserService{s: s}
	rs.Searchapplications = NewStatsUserSearchapplicationsService(s)
	return rs
}

type StatsUserService struct {
	s *Service

	Searchapplications *StatsUserSearchapplicationsService
}

func NewStatsUserSearchapplicationsService(s *Service) *StatsUserSearchapplicationsService {
	rs := &StatsUserSearchapplicationsService{s: s}
	return rs
}

type StatsUserSearchapplicationsService struct {
	s *Service
}

func NewV1Service(s *Service) *V1Service {
	rs := &V1Service{s: s}
	return rs
}

type V1Service struct {
	s *Service
}

// AbuseReportingConfig: Abuse reporting configuration outlining what is
// supported in this conference.
type AbuseReportingConfig struct {
	// RecordingAllowed: Whether the current call may include video
	// recordings in its abuse reports.
	RecordingAllowed bool `json:"recordingAllowed,omitempty"`

	// WrittenUgcAllowed: Whether the current call may include user
	// generated content (chat, polls, Q&A...) in its abuse reports.
	WrittenUgcAllowed bool `json:"writtenUgcAllowed,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RecordingAllowed") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RecordingAllowed") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AbuseReportingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseReportingConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AckInfo: Information about how devices in a meeting have acked for a
// session/operation.
type AckInfo struct {
	// UnackedDeviceCount: Output only. Number of meeting devices that have
	// not acked yet.
	UnackedDeviceCount int64 `json:"unackedDeviceCount,omitempty"`

	// UnackedDeviceIds: Output only. IDs of meeting devices (at most ten
	// are provided) that have not acked yet.
	UnackedDeviceIds []string `json:"unackedDeviceIds,omitempty"`

	// ForceSendFields is a list of field names (e.g. "UnackedDeviceCount")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UnackedDeviceCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AckInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AckInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AclFixRequest: The request set by clients to instruct Backend how the
// user intend to fix the ACL. Technically it's not a request to ACL
// Fixer, because Backend uses /DriveService.Share to modify Drive ACLs.
type AclFixRequest struct {
	// RecipientEmails: For Spaces messages: This field is ignored. For DMs
	// messages: The list of email addresses that should be added to the
	// Drive item's ACL. In general, the list should not be empty when the
	// boolean "should_fix" field is set; otherwise, the list should be
	// empty. During transition - when clients do not specify this field but
	// the "should_fix" is true, we follow the legacy behavior: share to all
	// users in the DM regardless of emails. This behavior is being phased
	// out.
	RecipientEmails []string `json:"recipientEmails,omitempty"`

	// Possible values:
	//   "UNKNOWN"
	//   "READER"
	//   "COMMENTER"
	//   "WRITER"
	Role string `json:"role,omitempty"`

	// ShouldFix: Whether to attempt to fix the ACL by adding the room or DM
	// members to the Drive file's ACL.
	ShouldFix bool `json:"shouldFix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RecipientEmails") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RecipientEmails") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AclFixRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AclFixRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AclFixStatus: The message reconstructed based on information in the
// response of /PermissionFixOptionsService.Query (or the Apiary API
// that wraps it). Indicates the ability of the requester to change the
// access to the Drive file for the room roster or the DM members. Used
// in GetMessagePreviewMetadataResponse only.
type AclFixStatus struct {
	// Possible values:
	//   "UNKNOWN"
	//   "ALREADY_ACCESSIBLE"
	//   "CAN_FIX"
	//   "CANNOT_FIX"
	//   "ACL_FIXER_ERROR"
	Fixability string `json:"fixability,omitempty"`

	// FixableEmailAddress: List of recipient email addresses for which
	// access can be granted. This field contains the same email addresses
	// from the GetMessagePreviewMetadata request if all recipients can be
	// successfully added to the ACL as determined by Drive ACL Fixer. For
	// now, the field is non-empty if and only if the "fixability" value is
	// "CAN_FIX".
	FixableEmailAddress []string `json:"fixableEmailAddress,omitempty"`

	// OutOfDomainWarningEmailAddress: List of recipient email addresses for
	// which an out-of-domain-sharing warning must be shown, stating that
	// these email addresses are not in the Google Apps organization that
	// the requested item belong to. Empty if all recipients are in the same
	// Google Apps organization.
	OutOfDomainWarningEmailAddress []string `json:"outOfDomainWarningEmailAddress,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Fixability") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Fixability") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AclFixStatus) MarshalJSON() ([]byte, error) {
	type NoMethod AclFixStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AclInfo: Next tag: 4
type AclInfo struct {
	// GroupsCount: Number of groups which have at least read access to the
	// document.
	GroupsCount int64 `json:"groupsCount,omitempty"`

	// Scope: The scope to which the content was shared.
	//
	// Possible values:
	//   "LIMITED" - Explicit set of people and groups.
	//   "DASHER_DOMAIN_WITH_LINK" - Anybody at the same domain with the
	// link.
	//   "DASHER_DOMAIN" - Now it works only for google.com. Anybody at the
	// same domain. Now it works only
	//   "PUBLIC_WITH_LINK" - for google.com. Anybody with the link.
	//   "PUBLIC" - Anybody.
	//   "TEAM_DRIVE" - Special tag to indicate TeamDrive scope.
	Scope string `json:"scope,omitempty"`

	// UsersCount: Number of users which have at least read access to the
	// document.
	UsersCount int64 `json:"usersCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GroupsCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GroupsCount") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AclInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AclInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ActionParameter: List of string parameters that developers can
// specify when the above action method (in apps script) is invoked. An
// example use case is for 3 snooze buttons: snooze now, snooze 1 day,
// snooze next week. Developers can have action method = snooze() and
// pass the snooze type and snooze time in list of string parameters.
type ActionParameter struct {
	Key string `json:"key,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ActionParameter) MarshalJSON() ([]byte, error) {
	type NoMethod ActionParameter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AddonComposeUiActionMarkup struct {
	// Possible values:
	//   "UNSPECIFIED" - Default. When unspecified, no action is taken.
	//   "DISMISS" - Dismisses the add-on compose UI.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddonComposeUiActionMarkup) MarshalJSON() ([]byte, error) {
	type NoMethod AddonComposeUiActionMarkup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AffectedMembership: Earlier we used to populate just the
// affected_members list and inferred the new membership state (roles
// didn't exist back then) from the Type. go/dynamite-finra required
// backend to know the previous membership state to reconstruct
// membership history. The proper solution involved cleaning up up Type
// enum, but it was used in many, many places. This was added as a
// stop-gap solution to unblock FINRA without breaking everything. Later
// role update and target audience update started relying on this to
// communicate information to clients about what transition happened. So
// this is now required to be populated and should be in sync with
// affected_members for new messages.
type AffectedMembership struct {
	AffectedMember *MemberId `json:"affectedMember,omitempty"`

	// Possible values:
	//   "ROLE_UNKNOWN"
	//   "ROLE_NONE" - This role is used when a user is forcibly removed
	// from a room by another user. They will no longer be able to search
	// for the room, but their history will be retained.
	//   "ROLE_INVITEE" - This role is used for two purposes. 1. A group is
	// invited to a room, making it discoverable for its members. 2. A user
	// was part of a room, but willingly left the room.
	//   "ROLE_MEMBER" - --- Following roles are for joined members of a
	// roster. --- Default role for any joined user. Has basic capabilities
	// within a room.
	//   "ROLE_OWNER" - Role assigned to room creators and explicitly
	// promoted members. Has broad powers to manage the room.
	PriorMembershipRole string `json:"priorMembershipRole,omitempty"`

	// Possible values:
	//   "MEMBER_UNKNOWN" - Default state, do not use
	//   "MEMBER_INVITED" - An invitation to the space has been sent
	//   "MEMBER_JOINED" - User has joined the space
	//   "MEMBER_NOT_A_MEMBER" - User is not a member
	//   "MEMBER_FAILED" - This state should never be stored in Spanner. It
	// is a state for responses to the clients to indicate that membership
	// mutations have failed and the member is in its previous state.
	PriorMembershipState string `json:"priorMembershipState,omitempty"`

	// Possible values:
	//   "ROLE_UNKNOWN"
	//   "ROLE_NONE" - This role is used when a user is forcibly removed
	// from a room by another user. They will no longer be able to search
	// for the room, but their history will be retained.
	//   "ROLE_INVITEE" - This role is used for two purposes. 1. A group is
	// invited to a room, making it discoverable for its members. 2. A user
	// was part of a room, but willingly left the room.
	//   "ROLE_MEMBER" - --- Following roles are for joined members of a
	// roster. --- Default role for any joined user. Has basic capabilities
	// within a room.
	//   "ROLE_OWNER" - Role assigned to room creators and explicitly
	// promoted members. Has broad powers to manage the room.
	TargetMembershipRole string `json:"targetMembershipRole,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AffectedMember") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AffectedMember") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AffectedMembership) MarshalJSON() ([]byte, error) {
	type NoMethod AffectedMembership
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AllAuthenticatedUsersProto: Represents a principal who has
// authenticated as any kind of user which the application understands.
// This is typically used for "wiki-like" security, where anyone is
// allowed access so long as they can be held accountable for that
// access. Since the purpose is knowing whom to blame, it is up to the
// application to decide what kinds of users it knows how to blame. For
// example, an application might choose to include GAIA users in "all
// authenticated users", but not include MDB users. Nothing here.
type AllAuthenticatedUsersProto struct {
}

// Annotation: NOTE WHEN ADDING NEW PROTO FIELDS: Be sure to add datapol
// annotations to new fields with potential PII, so they get scrubbed
// when logging protos for errors. NEXT TAG: 29
type Annotation struct {
	BabelPlaceholderMetadata *BabelPlaceholderMetadata `json:"babelPlaceholderMetadata,omitempty"`

	// CardCapabilityMetadata:
	// LINT.ThenChange(//depot/google3/java/com/google/apps/dynamite/v1/backe
	// nd/action/common/SystemMessageHelper.java)
	CardCapabilityMetadata *CardCapabilityMetadata `json:"cardCapabilityMetadata,omitempty"`

	// ChipRenderType: Whether the annotation should be rendered as a chip.
	// If this is missing or unspecified, fallback to should_not_render on
	// the metadata.
	//
	// Possible values:
	//   "CHIP_RENDER_TYPE_UNSPECIFIED"
	//   "RENDER" - Clients must render the annotation as a chip, and if
	// they cannot render this many Annotations, show a fallback card.
	//   "RENDER_IF_POSSIBLE" - Client can render the annotation if it has
	// room to render it.
	//   "DO_NOT_RENDER" - Client should not render the annotation as a
	// chip.
	ChipRenderType string `json:"chipRenderType,omitempty"`

	ConsentedAppUnfurlMetadata *ConsentedAppUnfurlMetadata `json:"consentedAppUnfurlMetadata,omitempty"`

	CustomEmojiMetadata *CustomEmojiMetadata `json:"customEmojiMetadata,omitempty"`

	DataLossPreventionMetadata *DataLossPreventionMetadata `json:"dataLossPreventionMetadata,omitempty"`

	// DriveMetadata: Chip annotations
	DriveMetadata *DriveMetadata `json:"driveMetadata,omitempty"`

	FormatMetadata *FormatMetadata `json:"formatMetadata,omitempty"`

	GroupRetentionSettingsUpdated *GroupRetentionSettingsUpdatedMetaData `json:"groupRetentionSettingsUpdated,omitempty"`

	// GsuiteIntegrationMetadata: Metadata for 1P integrations like tasks,
	// calendar. These are supported only through integration server as 1P
	// integrations use the integration API (which in turn uses backend API
	// with special permissions) to post messages. Clients should never set
	// this. LINT.IfChange
	GsuiteIntegrationMetadata *GsuiteIntegrationMetadata `json:"gsuiteIntegrationMetadata,omitempty"`

	IncomingWebhookChangedMetadata *IncomingWebhookChangedMetadata `json:"incomingWebhookChangedMetadata,omitempty"`

	// IntegrationConfigUpdated:
	// LINT.ThenChange(//depot/google3/java/com/google/apps/dynamite/v1/backe
	// nd/action/common/SystemMessageHelper.java)
	IntegrationConfigUpdated *IntegrationConfigUpdatedMetadata `json:"integrationConfigUpdated,omitempty"`

	// Length: Length of the text_body substring beginning from start_index
	// the Annotation corresponds to.
	Length int64 `json:"length,omitempty"`

	// LocalId: * A client-assigned ID for this annotation. This is helpful
	// in matching the back-filled annotations to the original annotations
	// on client side, without having to re-parse the message. There is no
	// guarantee an annotation has a local_id, it's a purely client used and
	// controlled field with no guarantee of uniqueness.
	LocalId string `json:"localId,omitempty"`

	// MembershipChanged: Metadata for system messages. Clients should never
	// set this. LINT.IfChange
	MembershipChanged *MembershipChangedMetadata `json:"membershipChanged,omitempty"`

	ReadReceiptsSettingsMetadata *ReadReceiptsSettingsUpdatedMetadata `json:"readReceiptsSettingsMetadata,omitempty"`

	// RequiredMessageFeaturesMetadata: Metadata that defines all of the
	// required features that must be rendered in the message. Clients can
	// use this to see whether they support the entire message, or show a
	// fallback chip otherwise. See go/message-quoting-client-to-server for
	// details. LINT.ThenChange(
	// //depot/google3/java/com/google/apps/dynamite/v1/allshared/parser/Anno
	// tationSanitizer.java,
	// //depot/google3/java/com/google/apps/dynamite/v1/backend/action/common
	// /SystemMessageHelper.java,
	// //depot/google3/java/com/google/caribou/eli/mediation/chat/AnnotationC
	// onverter.java )
	RequiredMessageFeaturesMetadata *RequiredMessageFeaturesMetadata `json:"requiredMessageFeaturesMetadata,omitempty"`

	RoomUpdated *RoomUpdatedMetadata `json:"roomUpdated,omitempty"`

	// ServerInvalidated: Whether or not the annotation is invalidated by
	// the server. Example of situations for invalidation include: when the
	// URL is malformed, or when Drive item ID is rejected by Drive Service.
	ServerInvalidated bool `json:"serverInvalidated,omitempty"`

	SlashCommandMetadata *SlashCommandMetadata `json:"slashCommandMetadata,omitempty"`

	// StartIndex: Start index (0-indexed) of the Message text the
	// Annotation corresponds to, inclusive.
	StartIndex int64 `json:"startIndex,omitempty"`

	// Type: Type of the Annotation.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value for the enum. DO NOT USE.
	//   "URL" - These can have overlaps, i.e. same message can have
	// multiple of these. For example a Drive link to a PDF can have URL,
	// DRIVE_FILE and PDF all set Links
	//   "DRIVE_FILE" - Any drive file
	//   "DRIVE_DOC"
	//   "DRIVE_SHEET"
	//   "DRIVE_SLIDE"
	//   "DRIVE_FORM"
	//   "USER_MENTION"
	//   "SLASH_COMMAND"
	//   "CONSENTED_APP_UNFURL"
	//   "VIDEO" - Any video, not just youtube, the url decides how to play
	//   "FORMAT_DATA" - UI should not be concerned with FORMAT_DATA
	//   "IMAGE"
	//   "PDF"
	//   "VIDEO_CALL" - For Thor integration
	//   "UPLOAD_METADATA" - Blobstore uploads
	//   "GSUITE_INTEGRATION" - Generic annotation for gsuite integrations
	//   "CUSTOM_EMOJI"
	//   "CARD_CAPABILITY" - Card capability for in-stream widgets.
	//   "DATA_LOSS_PREVENTION"
	//   "REQUIRED_MESSAGE_FEATURES_METADATA" - Clients can use this to see
	// whether they support the entire message, or show a fallback chip
	// otherwise.
	//   "MEMBERSHIP_CHANGED" - Annotation types for system messages.
	// Clients should never set this.
	//   "ROOM_UPDATED"
	//   "GROUP_RETENTION_SETTINGS_UPDATED"
	//   "BABEL_PLACEHOLDER"
	//   "READ_RECEIPTS_SETTINGS_UPDATED"
	//   "INCOMING_WEBHOOK_CHANGED"
	//   "INTEGRATION_CONFIG_UPDATED"
	//   "INVITATION" - Message-level annotations. First message of an
	// invite. Should not be set by clients.
	Type string `json:"type,omitempty"`

	// UniqueId: * A unique server-assigned ID for this annotation. This is
	// helpful in matching annotation objects when fetched from service. All
	// uploads should have a unique_id after the message they are attached
	// to is successfully sent. Url annotations that originally were uploads
	// (i.e. policy violations) will have a unique_id after the message they
	// are attached to is successfully sent. No other url annotations should
	// have a unique_id. All drive annotations should have a unique_id after
	// the message they are attached to is successfully sent.
	UniqueId string `json:"uniqueId,omitempty"`

	UploadMetadata *UploadMetadata `json:"uploadMetadata,omitempty"`

	UrlMetadata *UrlMetadata `json:"urlMetadata,omitempty"`

	// UserMentionMetadata: Metadata that clients can set for annotations.
	// LINT.IfChange In-text annotations
	UserMentionMetadata *UserMentionMetadata `json:"userMentionMetadata,omitempty"`

	VideoCallMetadata *VideoCallMetadata `json:"videoCallMetadata,omitempty"`

	YoutubeMetadata *YoutubeMetadata `json:"youtubeMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BabelPlaceholderMetadata") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BabelPlaceholderMetadata")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Annotation) MarshalJSON() ([]byte, error) {
	type NoMethod Annotation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppId: Identifier of an App.
type AppId struct {
	// AppType: Enum indicating the type of App this is.
	//
	// Possible values:
	//   "APP_TYPE_UNSPECIFIED"
	//   "APP" - 3P APP eg. external Bots(Asana Bot), 1P Bots(Drive Bot).
	//   "GSUITE_APP" - 1P APP eg. Tasks, Meet, Docs, Calendar..
	//   "INCOMING_WEBHOOK" - Asynchronous messages via an incoming webhook.
	AppType string `json:"appType,omitempty"`

	// GsuiteAppType: Enum indicating which 1P App this is when app_type is
	// GSUITE_APP. Determined & set by the 1P API as a convenience for all
	// users of this identifier(Eg. clients, chime, backend etc.) to map to
	// 1P properties.
	//
	// Possible values:
	//   "GSUITE_APP_TYPE_UNSPECIFIED"
	//   "TASKS_APP"
	//   "CALENDAR_APP"
	//   "DOCS_APP"
	//   "SHEETS_APP"
	//   "SLIDES_APP"
	//   "MEET_APP"
	//   "ASSISTIVE_SUGGESTION_APP" - Powered by Bullseye
	//   "CONTACTS_APP"
	//   "ACTIVITY_FEED_APP"
	//   "DRIVE_APP"
	//   "CHAT_IN_MEET_APP"
	GsuiteAppType string `json:"gsuiteAppType,omitempty"`

	// Id: Numeric identifier of the App. Set to Project number for 1/3P
	// Apps. For Webhook, this is WebhookId. Determined & set by the 1P API
	// from App credentials on the side channel.
	Id int64 `json:"id,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "AppType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppId) MarshalJSON() ([]byte, error) {
	type NoMethod AppId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedActivityFeedAnnotationData: Next Id: 7
type AppsDynamiteSharedActivityFeedAnnotationData struct {
	// ActivityFeedMessageCreateTime: Timestamp of when the Activity Feed
	// message that contains this annotation was created. This is roughly
	// when the activity happened, such as when a reaction happened, but
	// will have at least some small delay, since the Activity Feed message
	// is created asynchronously after. This timestamp should only be used
	// for display when the activity create time is not available in the
	// Chat UI, like the time of a reaction.
	ActivityFeedMessageCreateTime string `json:"activityFeedMessageCreateTime,omitempty"`

	// ActivityFeedMessageId: Unique id of the Activity Feed message used by
	// clients to implement click-to-source. This is the same messageId as
	// the top-level id field for the Activity Feed item.
	ActivityFeedMessageId *MessageId `json:"activityFeedMessageId,omitempty"`

	ChatItem *AppsDynamiteSharedChatItem `json:"chatItem,omitempty"`

	// SharedUserInfo: Only populated on read path and should not be
	// persisted in storage.
	SharedUserInfo *UserInfo `json:"sharedUserInfo,omitempty"`

	// UserInfo: Use shared_user_info instead.
	UserInfo *AppsDynamiteSharedActivityFeedAnnotationDataUserInfo `json:"userInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ActivityFeedMessageCreateTime") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ActivityFeedMessageCreateTime") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedActivityFeedAnnotationData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedActivityFeedAnnotationData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedActivityFeedAnnotationDataUserInfo: UserId of the
// AF item updater to show and the updater count to show.
type AppsDynamiteSharedActivityFeedAnnotationDataUserInfo struct {
	// UpdaterCountDisplayType: Describes how updater_count_to_show should
	// be used.
	//
	// Possible values:
	//   "UPDATER_COUNT_DISPLAY_TYPE_UNSPECIFIED"
	//   "EXACT_COUNT" - A precise updater count is known and the value set
	// in updater_count_to_show should be used.
	//   "NONZERO_COUNT" - A precise updater count could not be calculated,
	// but there is at least one. Any value set in updater_count_to_show
	// should NOT be used.
	UpdaterCountDisplayType string `json:"updaterCountDisplayType,omitempty"`

	// UpdaterCountToShow: The number of updaters for clients to show,
	// currently set to the total number of updaters minus the one set in
	// updater_to_show.
	UpdaterCountToShow int64 `json:"updaterCountToShow,omitempty"`

	// UpdaterToShow: The updater for clients to show.
	UpdaterToShow *UserId `json:"updaterToShow,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "UpdaterCountDisplayType") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UpdaterCountDisplayType")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedActivityFeedAnnotationDataUserInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedActivityFeedAnnotationDataUserInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedAppProfile: Optional field for apps overriding
// display info
type AppsDynamiteSharedAppProfile struct {
	// AvatarEmoji: Displayed user avatar emoji.
	AvatarEmoji string `json:"avatarEmoji,omitempty"`

	// AvatarUrl: Displayed user avatar url.
	AvatarUrl string `json:"avatarUrl,omitempty"`

	// Name: Displayed user name.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AvatarEmoji") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AvatarEmoji") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedAppProfile) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedAppProfile
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedAssistantAnnotationData: This is the internal
// version of the API proto at
// google3/google/chat/v1/gsuite_message_integration.proto Data used to
// render Assistant suggestions. See go/bullseye-rendering.
type AppsDynamiteSharedAssistantAnnotationData struct {
	// Suggestion: The suggestion to render in the card.
	Suggestion *AppsDynamiteSharedAssistantSuggestion `json:"suggestion,omitempty"`

	// Unfulfillable: Set when the initial query was unfulfillable. Only an
	// on-demand unfulfillable query will result in a response (not a
	// proactive query). 1. On-demand: user explicitly invokes the bot 2.
	// Proactive: bot makes proactive suggestion (when available) by
	// listening to all user messages.
	Unfulfillable *AppsDynamiteSharedAssistantUnfulfillableRequest `json:"unfulfillable,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Suggestion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Suggestion") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedAssistantAnnotationData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedAssistantAnnotationData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedAssistantDebugContext: Represents info regarding
// suggestion debug information.
type AppsDynamiteSharedAssistantDebugContext struct {
	// Query: The query that triggered the resulting suggestion.
	Query string `json:"query,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Query") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Query") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedAssistantDebugContext) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedAssistantDebugContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedAssistantFeedbackContext: Data needed to render
// feedback on the Assistant card
type AppsDynamiteSharedAssistantFeedbackContext struct {
	// FeedbackChips: Specifies a list of feedback chips to show
	FeedbackChips []*AppsDynamiteSharedAssistantFeedbackContextFeedbackChip `json:"feedbackChips,omitempty"`

	// ThumbsFeedback: Whether the thumbs feedback is provided
	//
	// Possible values:
	//   "THUMBS_FEEDBACK_UNSPECIFIED" - Unspecified thumbs state
	//   "NONE_SELECTED" - Thumbs are not selected
	//   "UP" - Thumbs up selected
	//   "DOWN" - Thumbs down selected
	ThumbsFeedback string `json:"thumbsFeedback,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FeedbackChips") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FeedbackChips") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedAssistantFeedbackContext) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedAssistantFeedbackContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedAssistantFeedbackContextFeedbackChip: Suggestion
// chips for users to indicate positive or negative feedback
type AppsDynamiteSharedAssistantFeedbackContextFeedbackChip struct {
	// FeedbackChipType: What type of chip to display
	//
	// Possible values:
	//   "FEEDBACK_CHIP_TYPE_UNSPECIFIED" - Unspecified type of feedback
	// chip
	//   "WRONG_TRIGGER" - Bad/noisy triggering
	//   "WRONG_FILE" - Incorrect files were presented
	//   "CORRECT_TRIGGER" - The Assistant card triggered appropriately
	//   "CORRECT_FILE" - The correct files were presented
	//   "DISRUPTIVE" - The feature is disruptive
	//   "OTHER" - Other reason
	FeedbackChipType string `json:"feedbackChipType,omitempty"`

	// State: Whether the chip has been selected
	//
	// Possible values:
	//   "FEEDBACK_CHIP_STATE_UNSPECIFIED" - Unspecified selection state
	//   "SELECTED" - Chip is selected
	//   "UNSELECTED" - Chip is not selected
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FeedbackChipType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FeedbackChipType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedAssistantFeedbackContextFeedbackChip) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedAssistantFeedbackContextFeedbackChip
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedAssistantSessionContext: Session context specific
// for Assistant suggestions.
type AppsDynamiteSharedAssistantSessionContext struct {
	// ContextualSessionId: Unique identifier populated by the contextual
	// request handler for each vertical (Ex: File Suggestions, Smart
	// Scheduling, etc.) that can be used to track sessions end-to-end. May
	// span multiple users (sender-specific).
	ContextualSessionId string `json:"contextualSessionId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContextualSessionId")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContextualSessionId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedAssistantSessionContext) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedAssistantSessionContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedAssistantSuggestion: Data for an Assistant
// suggestion.
type AppsDynamiteSharedAssistantSuggestion struct {
	// DebugContext: Info regarding suggestion debug information.
	DebugContext *AppsDynamiteSharedAssistantDebugContext `json:"debugContext,omitempty"`

	// FeedbackContext: Data for rendering feedback.
	FeedbackContext *AppsDynamiteSharedAssistantFeedbackContext `json:"feedbackContext,omitempty"`

	// FindDocumentSuggestion: Suggestion type that suggests documents
	// (docs, slides, sheets).
	FindDocumentSuggestion *AppsDynamiteSharedFindDocumentSuggestion `json:"findDocumentSuggestion,omitempty"`

	// SerializedSuggestions: String representation of the suggestions
	// provided.
	SerializedSuggestions string `json:"serializedSuggestions,omitempty"`

	// SessionContext: Session context specific to the Assistant suggestion.
	SessionContext *AppsDynamiteSharedAssistantSessionContext `json:"sessionContext,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DebugContext") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DebugContext") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedAssistantSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedAssistantSuggestion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedAssistantUnfulfillableRequest: Data for a response
// to an unfulfillable request.
type AppsDynamiteSharedAssistantUnfulfillableRequest struct {
}

type AppsDynamiteSharedAvatarInfo struct {
	Emoji *AppsDynamiteSharedEmoji `json:"emoji,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Emoji") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Emoji") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedAvatarInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedAvatarInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedBackendUploadMetadata: Metadata used only in
// Dynamite backend for uploaded attachments.
type AppsDynamiteSharedBackendUploadMetadata struct {
	// BlobPath: Blobstore path for the uploaded attachment
	BlobPath string `json:"blobPath,omitempty"`

	// ContentName: The original file name for the content, not the full
	// path.
	ContentName string `json:"contentName,omitempty"`

	// ContentSize: Scotty reported content size by default.
	// http://google3/uploader/agent/scotty_agent.proto?l=101&rcl=140889785
	ContentSize int64 `json:"contentSize,omitempty,string"`

	// ContentType: Type is from Scotty's best_guess by default:
	// http://google3/uploader/agent/scotty_agent.proto?l=51&rcl=140889785
	ContentType string `json:"contentType,omitempty"`

	// DlpScanOutcome: The results of the Data Loss Prevention (DLP) scan of
	// the attachment. DEPRECATED: use dlp_scan_summary instead.
	//
	// Possible values:
	//   "SCAN_UNKNOWN_OUTCOME"
	//   "SCAN_SUCCEEDED_NO_VIOLATION" - This means no violation is detected
	// on the given message/attachment.
	//   "SCAN_SUCCEEDED_BLOCK" - Violation is detected. The
	// message/attachment will be blocked (or deleted if this happens in
	// failure recovery), the user will be warned, and the violation will be
	// logged to BIP.
	//   "SCAN_SUCCEEDED_WARN" - Violation is detected. The user will be
	// warned, and the violation will be logged to BIP.
	//   "SCAN_SUCCEEDED_AUDIT_ONLY" - Violation is detected and will be
	// logged to BIP (no user-facing action performed).
	//   "SCAN_FAILURE_EXCEPTION" - Rule fetch and evaluation were attempted
	// but an exception occurred.
	//   "SCAN_FAILURE_RULE_FETCH_FAILED" - Rule fetch was attempted but
	// failed, so rule evaluation could not be performed.
	//   "SCAN_FAILURE_TIMEOUT" - Rule fetch and evaluation were attempted
	// but the scanning timed out.
	//   "SCAN_FAILURE_ALL_RULES_FAILED" - Rule fetch completed and
	// evaluation were attempted, but all of the rules failed to be
	// evaluated.
	//   "SCAN_FAILURE_ILLEGAL_STATE_FOR_ATTACHMENTS" - An
	// IllegalStateException is thrown when executing DLP on attachments.
	// This could happen if the space row is missing.
	//   "SCAN_SKIPPED_EXPERIMENT_DISABLED" - Rule fetch and evaluation is
	// skipped because DLP is not enabled for the user.
	//   "SCAN_SKIPPED_CONSUMER" - Rule fetch and evaluation are skipped
	// because the user sending message is consumer.
	//   "SCAN_SKIPPED_NON_HUMAN_USER" - Rule fetch and evaluation are
	// skipped because the user sending message is a non-human user (i.e. a
	// bot).
	//   "SCAN_SKIPPED_NO_MESSAGE" - Rule fetch and evaluation are skipped
	// because there is no message to scan. Deprecated: this should not
	// happen since there must be message or attachment for DLP scan.
	//   "SCAN_SKIPPED_USER_ACKNOWLEDGED_WARNING" - Rule fetch and
	// evaluation are skipped because the user has acknowledged the warning
	// on the message that triggered the Warn violation and sent the message
	// anyway.
	//   "SCAN_SKIPPED_MESSAGE_FROM_UNSUPPORTED_ORIGIN" - Scanning was
	// skipped because the message originated from Interop or Babel.
	//   "SCAN_SKIPPED_MESSAGE_SENT_DURING_SPACE_MIGRATION" - Scanning was
	// skipped because the message was sent while the space is in migration
	// mode. See go/migration-mode for details.
	//   "SCAN_RULE_EVALUATION_SKIPPED_NO_RULES_FOUND" - Rule fetch
	// happened, but rule evaluation is skipped because no rules were found.
	//
	// "SCAN_RULE_EVALUATION_SKIPPED_NO_APPLICABLE_RULES_FOR_ACTION_PARAMS"
	// - Rule fetch happened, but rule evaluation is skipped because none of
	// the rules are applicable to the given action params.
	//   "SCAN_RULE_EVALUATION_SKIPPED_NO_APPLICABLE_RULES_FOR_TRIGGER" -
	// Rule fetch happened, but rule evaluation is skipped because none of
	// the rules are applicable to the given trigger.
	//   "SCAN_RULE_EVALUATION_SKIPPED_CHANGELING_PERMANENT_ERROR" - Rule
	// fetch happened, but rule evaluation is skipped because Changeling
	// returned permanent failure while converting the attachment to text.
	//   "SCAN_RULE_EVALUATION_SKIPPED_CHANGELING_EMPTY_RESPONSE" - Rule
	// fetch happened, but rule evaluation is skipped because Changeling
	// returned an empty response while converting the attachment to text.
	//   "SCAN_RULE_EVALUATION_SKIPPED_UNSUPPORTED_FILE_TYPE" - Rule fetch
	// happened, but rule evaluation is skipped because file type is
	// unsupported.
	//   "SCAN_SUCCEEDED_WITH_FAILURES_NO_VIOLATION" - Rules were fetched
	// but some evaluations failed. No violation was found in the rules that
	// were successfully evaluated.
	//   "SCAN_SUCCEEDED_WITH_FAILURES_BLOCK" - Rules were fetched but some
	// evaluations failed. A blocking violation was found in the rules that
	// were successfully evaluated. The message/attachment will be blocked,
	// the user will be notified, and the violation will be logged to BIP. A
	// blocking violation takes precedence over all other violation types.
	//   "SCAN_SUCCEEDED_WITH_FAILURES_WARN" - Rules were fetched but some
	// evaluations failed. A warn violation was found in the rules that were
	// successfully evaluated. The user will be warned, and the violation
	// will be logged to BIP.
	//   "SCAN_SUCCEEDED_WITH_FAILURES_AUDIT_ONLY" - Rules were fetched but
	// some evaluations failed. An audit-only violation was found in the
	// rules that were successfully evaluated. The violation will be logged
	// to BIP (no user-facing action performed).
	DlpScanOutcome string `json:"dlpScanOutcome,omitempty"`

	// DlpScanSummary: Summary of a Data Loss Prevention (DLP) scan of the
	// attachment. Attachments are evaluated in the backend when they are
	// uploaded.
	DlpScanSummary *DlpScanSummary `json:"dlpScanSummary,omitempty"`

	// GroupId: GroupId to which this attachment is uploaded.
	GroupId *GroupId `json:"groupId,omitempty"`

	// IsClientSideTranscodedVideo: If the uploaded file is a video that has
	// been transcoded on the client side Next tag: 18
	IsClientSideTranscodedVideo bool `json:"isClientSideTranscodedVideo,omitempty"`

	// OriginalDimension: Original dimension of the content. Only set for
	// image attachments.
	OriginalDimension *AppsDynamiteSharedDimension `json:"originalDimension,omitempty"`

	// QuoteReplyMessageId: The message id of a quote reply referencing this
	// attachment. When present, this attachment has been quoted in a reply
	// message. Normally, the attachment is fetched through the message id
	// in the blob_path, but in the case of a quote reply, the blob_path
	// would contain the quoted message id. Thus this message id field is
	// needed to fetch the quote reply message instead. This field is
	// conditionally populated at read time for quotes and never persisted
	// in storage. See go/message-quoting-attachments for more context.
	QuoteReplyMessageId *MessageId `json:"quoteReplyMessageId,omitempty"`

	// Sha256: The SHA256 hash of the attachment bytes.
	Sha256 string `json:"sha256,omitempty"`

	// UploadIp: User IP address at upload time. Ex. "123.1.2.3". Used by
	// Ares abuse scanning.
	UploadIp string `json:"uploadIp,omitempty"`

	// UploadTimestampUsec: Timestamp of when user finished uploading the
	// content.
	UploadTimestampUsec int64 `json:"uploadTimestampUsec,omitempty,string"`

	// VideoId: VideoID of the video attachments. This ID shall meets the
	// Youtube ID format of 16 hex characters. For example,
	// '4c14b8825af6059b' is a valid ID.
	VideoId string `json:"videoId,omitempty"`

	// VideoThumbnailBlobId: Full Blobstore ID for the video thumbnail.
	VideoThumbnailBlobId string `json:"videoThumbnailBlobId,omitempty"`

	// VirusScanResult: Result for a virus scan.
	//
	// Possible values:
	//   "UNKNOWN_VIRUS_SCAN_RESULT"
	//   "CLEAN"
	//   "INFECTED"
	//   "ERROR"
	//   "POLICY_VIOLATION" - The document violates Google's policy for
	// executables and archives.
	VirusScanResult string `json:"virusScanResult,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BlobPath") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BlobPath") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedBackendUploadMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedBackendUploadMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsDynamiteSharedCalendarEventAnnotationData struct {
	CalendarEvent *AppsDynamiteSharedCalendarEventAnnotationDataCalendarEvent `json:"calendarEvent,omitempty"`

	// EventCreation: Notification about the creation of an event.
	EventCreation *AppsDynamiteSharedCalendarEventAnnotationDataEventCreation `json:"eventCreation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CalendarEvent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CalendarEvent") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedCalendarEventAnnotationData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedCalendarEventAnnotationData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsDynamiteSharedCalendarEventAnnotationDataCalendarEvent struct {
	// EndTime: The end time of the event.
	EndTime *AppsDynamiteSharedCalendarEventAnnotationDataCalendarEventTime `json:"endTime,omitempty"`

	// EventId: ID of the event.
	EventId string `json:"eventId,omitempty"`

	// StartTime: The start time of the event.
	StartTime *AppsDynamiteSharedCalendarEventAnnotationDataCalendarEventTime `json:"startTime,omitempty"`

	// Title: Title of the event (at the time the message was generated).
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedCalendarEventAnnotationDataCalendarEvent) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedCalendarEventAnnotationDataCalendarEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsDynamiteSharedCalendarEventAnnotationDataCalendarEventTime struct {
	// AllDay: All day event.
	AllDay *Date `json:"allDay,omitempty"`

	// Timed: Non all day event.
	Timed string `json:"timed,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllDay") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllDay") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedCalendarEventAnnotationDataCalendarEventTime) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedCalendarEventAnnotationDataCalendarEventTime
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedCalendarEventAnnotationDataEventCreation: Creation
// of an event (no extra data for now).
type AppsDynamiteSharedCalendarEventAnnotationDataEventCreation struct {
}

// AppsDynamiteSharedCallAnnotationData: Data used to render Meet or
// Google Voice chips in Chat. See
// go/dynamite-calling-artifacts-in-chat.
type AppsDynamiteSharedCallAnnotationData struct {
	// CallEndedTimestamp: Timestamp when the call ended. Used to render the
	// call ended system message.
	CallEndedTimestamp string `json:"callEndedTimestamp,omitempty"`

	// CallMetadata: Required. Call metadata required to create the call
	// artifacts. For now, the metadata contains only the call id to
	// identify the call. This field allows additional data (e.g. voice call
	// type) to be added if needed in the future.
	CallMetadata *AppsDynamiteSharedCallMetadata `json:"callMetadata,omitempty"`

	// CallStatus: Required. Indicates the call status for the space. Used
	// to determine the chip's state.
	//
	// Possible values:
	//   "CALL_STATUS_UNSPECIFIED" - Default value for the enum. DO NOT USE.
	//   "CALL_STARTED" - Indicates that the call has started.
	//   "CALL_MISSED" - Indicates that the call is missed.
	//   "CALL_ENDED" - Indicates that the call has ended.
	CallStatus string `json:"callStatus,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CallEndedTimestamp")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CallEndedTimestamp") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedCallAnnotationData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedCallAnnotationData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedCallMetadata: Metadata required to generate call
// artifacts. This can either be the metadata for a Meet or, in the
// future, Google Voice call.
type AppsDynamiteSharedCallMetadata struct {
	// MeetMetadata: Metadata specific for the Meet call.
	MeetMetadata *AppsDynamiteSharedMeetMetadata `json:"meetMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MeetMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MeetMetadata") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedCallMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedCallMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedCardClickSuggestion: Card click which identifies
// one suggestion provided by the app/bot.
type AppsDynamiteSharedCardClickSuggestion struct {
	// ActionId: Identify the button/action that created the suggestion. A
	// simple example would be a card button within the stream, or the id
	// which can identify a specific suggestion.
	ActionId string `json:"actionId,omitempty"`

	// SuggestionMessageId: The message_id for the message that was posted
	// by the app/bot.
	SuggestionMessageId *MessageId `json:"suggestionMessageId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ActionId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActionId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedCardClickSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedCardClickSuggestion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedChatItem: Next Id: 5
type AppsDynamiteSharedChatItem struct {
	// ActivityInfo: Information needed to render the specific type of feed
	// item.
	ActivityInfo []*AppsDynamiteSharedChatItemActivityInfo `json:"activityInfo,omitempty"`

	// GroupInfo: Only populated on read path and should not be persisted in
	// storage.
	GroupInfo *AppsDynamiteSharedChatItemGroupInfo `json:"groupInfo,omitempty"`

	// MessageInfo: Additional information about the original chat message
	// that isn't captured in the top-level message proto.
	MessageInfo *AppsDynamiteSharedMessageInfo `json:"messageInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ActivityInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActivityInfo") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedChatItem) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedChatItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsDynamiteSharedChatItemActivityInfo struct {
	FeedItemNudge *AppsDynamiteSharedChatItemActivityInfoFeedItemNudge `json:"feedItemNudge,omitempty"`

	FeedItemReactions *AppsDynamiteSharedChatItemActivityInfoFeedItemReactions `json:"feedItemReactions,omitempty"`

	FeedItemThreadReply *AppsDynamiteSharedChatItemActivityInfoFeedItemThreadReply `json:"feedItemThreadReply,omitempty"`

	FeedItemUserMention *AppsDynamiteSharedChatItemActivityInfoFeedItemUserMention `json:"feedItemUserMention,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FeedItemNudge") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FeedItemNudge") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedChatItemActivityInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedChatItemActivityInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedChatItemActivityInfoFeedItemNudge: Existence of
// this attribute indicates that the AF item is for a message nudge
// item.
type AppsDynamiteSharedChatItemActivityInfoFeedItemNudge struct {
	// NudgeType: Nudge type of the nudge feed item.
	//
	// Possible values:
	//   "UNDEFINED"
	//   "REPLY" - The message receiver is nudged since the message may
	// require a reply.
	//   "FOLLOW_UP" - The message creator is nudged since the message may
	// require a follow-up.
	NudgeType string `json:"nudgeType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NudgeType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NudgeType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedChatItemActivityInfoFeedItemNudge) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedChatItemActivityInfoFeedItemNudge
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedChatItemActivityInfoFeedItemReactions: Existence of
// this attribute indicates that the AF item is for message reactions,
// but it is intentionally left empty since the list of reactions can be
// found in the top-level Message.Reactions.
type AppsDynamiteSharedChatItemActivityInfoFeedItemReactions struct {
}

// AppsDynamiteSharedChatItemActivityInfoFeedItemThreadReply: Existence
// of this attribute indicates that the AF item is for thread reply.
type AppsDynamiteSharedChatItemActivityInfoFeedItemThreadReply struct {
	// ReplyType: Reply type of the thread reply feed item. The field is not
	// persisted in storage. It's populated when constructing Activity Feed
	// payload.
	//
	// Possible values:
	//   "UNSPECIFIED"
	//   "ROOT" - The thread reply feed item is for the root message poster.
	//   "FOLLOWER" - The thread reply feed item is for a thread follower
	// who's not the root message poster.
	ReplyType string `json:"replyType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ReplyType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ReplyType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedChatItemActivityInfoFeedItemThreadReply) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedChatItemActivityInfoFeedItemThreadReply
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedChatItemActivityInfoFeedItemUserMention: Existence
// of this attribute indicates that the AF item is for a user mention
// item.
type AppsDynamiteSharedChatItemActivityInfoFeedItemUserMention struct {
	// Type: User mention type
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Mention type not specified.
	//   "DIRECT" - Mentioned directly by name.
	//   "ALL" - Mentioned by @all.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedChatItemActivityInfoFeedItemUserMention) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedChatItemActivityInfoFeedItemUserMention
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedChatItemGroupInfo: Information about the space that
// the item originated from. This will be used to display Activity Feed
// items from rooms, and only contain the necessary information, such as
// the space name and group attributes. NEXT TAG: 6
type AppsDynamiteSharedChatItemGroupInfo struct {
	// AttributeCheckerGroupType: This is needed to determine what type of
	// group the source message came from to support click-to-source.
	//
	// Possible values:
	//   "ATTRIBUTE_CHECKER_GROUP_TYPE_UNSPECIFIED" - LINT.IfChange
	//   "ONE_TO_ONE_HUMAN_DM" - A 1:1 DM that has two human users.
	// Deprecated. Use IMMUTABLE_MEMBERSHIP_HUMAN_DM instead.
	//   "ONE_TO_ONE_BOT_DM" - A 1:1 DM between a human user and a bot.
	//   "IMMUTABLE_MEMBERSHIP_GROUP_DM" - A group DM that has multiple
	// human users with immutable group membership. Deprecated. Use
	// IMMUTABLE_MEMBERSHIP_HUMAN_DM instead.
	//   "FLAT_ROOM" - A flat room that contains a single thread.
	//   "THREADED_ROOM" - A threaded room. Topics in this room are
	// threaded, and users can reply to any topic.
	//   "IMMUTABLE_MEMBERSHIP_HUMAN_DM" - A DM with immutable group
	// membership. It can be a 1:1 DM or a group DM with multiple human
	// users.
	//   "POST_ROOM" - A post room. Topics in this room are organized in a
	// post/reply style. See the design doc for more details:
	// go/PostRoomsInDynamite. Deprecated. Post rooms are no longer
	// supported.
	//   "ACTIVITY_FEED" - Represents an Activity Feed space. These groups
	// are modeled like flat rooms and contain items for users to catch up
	// on important things. Each user should only have one group of this
	// type. See go/activity-feed. Deprecated: The go/activity-feed project
	// is cancelled and this should no longer be used.
	// LINT.ThenChange(//depot/google3/logs/proto/apps_dynamite/dynamite_visu
	// al_element_entry.proto:LoggingGroupType,//depot/google3/java/com/googl
	// e/apps/dynamite/v1/web/ui/group/groups.js:LoggingGroupType)
	AttributeCheckerGroupType string `json:"attributeCheckerGroupType,omitempty"`

	GroupName string `json:"groupName,omitempty"`

	// GroupReadTimeUsec: Timestamp of when the group containing the message
	// has been read by the user.
	GroupReadTimeUsec int64 `json:"groupReadTimeUsec,omitempty,string"`

	// InlineThreadingEnabled: Indicates whether the group has inline
	// replies enabled. If enabled, clients will render the space with
	// inline replies.
	InlineThreadingEnabled bool `json:"inlineThreadingEnabled,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AttributeCheckerGroupType") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AttributeCheckerGroupType") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedChatItemGroupInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedChatItemGroupInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedContentReportType: Denotes a type of content report
// a user can send.
type AppsDynamiteSharedContentReportType struct {
	// SystemViolation: Required. Google-defined system violation, covering
	// the most common violations.
	//
	// Possible values:
	//   "VIOLATION_UNSPECIFIED" - Default value if unset. Do not use
	// directly. This value should not appear as a selectable violation
	// during content reporting.
	//   "HARASSMENT" - "Harassment, offensive, or rude behavior"
	//   "DISCRIMINATION" - "Discrimination or harmful stereotypes against
	// anyone, including protected groups"
	//   "EXPLICIT_CONTENT" - "Explicit content that's graphic, violent, or
	// otherwise inappropriate"
	//   "SPAM" - "Spam"
	//   "CONFIDENTIAL_INFORMATION" - "Confidential information"
	//   "SENSITIVE_INFORMATION" - "Sensitive information"
	//   "FRAUD" - Phishing, impersonation/misrepresentation, or deceiving
	// other users into sharing information under false pretenses.
	//   "MALWARE" - Malware, viruses, Trojan horses, corrupted files,
	// destructive code, etc.
	//   "ILLEGAL_ACTIVITIES" - Promoting, organizing, or engaging in
	// illegal activities.
	//   "OTHER" - "Something else"
	SystemViolation string `json:"systemViolation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SystemViolation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SystemViolation") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedContentReportType) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedContentReportType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedCustomEmoji: Proto representation of a custom
// emoji. May be used in both APIs and in Spanner, but certain fields
// should be restricted to one or the other. See the per-field
// documentation for details. NEXT_TAG: 14
type AppsDynamiteSharedCustomEmoji struct {
	// BlobId: ID for the underlying image data in Blobstore. This field
	// should *only* be present in Spanner or within the server, but should
	// not be exposed in public APIs.
	BlobId string `json:"blobId,omitempty"`

	// ContentType: Content type of the file used to upload the emoji. Used
	// for takeout. Written to Spanner when the emoji is created.
	ContentType string `json:"contentType,omitempty"`

	// CreateTimeMicros: Time when the Emoji was created, in microseconds.
	// This field may be present in Spanner, within the server, or in public
	// APIs.
	CreateTimeMicros int64 `json:"createTimeMicros,omitempty,string"`

	// CreatorUserId: This field should *never* be persisted to Spanner.
	CreatorUserId *UserId `json:"creatorUserId,omitempty"`

	// DeleteTimeMicros: Time when the emoji was deleted, in microseconds.
	// This field may be present in Spanner, within the server, or in public
	// APIs. Only present if the emoji has been deleted.
	DeleteTimeMicros int64 `json:"deleteTimeMicros,omitempty,string"`

	// EphemeralUrl: Output only. A short-lived URL clients can use for
	// directly accessing a custom emoji image. This field is intended for
	// API consumption, and should *never* be persisted to Spanner.
	EphemeralUrl string `json:"ephemeralUrl,omitempty"`

	// OwnerCustomerId: This field should *never* be persisted to Spanner.
	OwnerCustomerId *CustomerId `json:"ownerCustomerId,omitempty"`

	// ReadToken: Opaque token that clients use to construct the URL for
	// accessing the custom emoji’s image data. This field is intended for
	// API consumption, and should *never* be persisted to Spanner.
	ReadToken string `json:"readToken,omitempty"`

	// Shortcode: User-provided, human-readable ID for the custom emoji.
	// Users are expected to observe this field in the UI instead of the
	// UUID. This shortcode should be unique within an organization, but has
	// no global uniqueness guarantees, unlike the UUID. This field should
	// *never* be persisted to Spanner.
	Shortcode string `json:"shortcode,omitempty"`

	// State: Snapshot of the current state of the emoji, which may differ
	// from the source-of-truth in the CustomEmojis table. This field should
	// *never* be persisted to Spanner.
	//
	// Possible values:
	//   "EMOJI_STATE_UNSPECIFIED"
	//   "EMOJI_ENABLED" - Emoji is visible and available to be used,
	// subject to access control requirements.
	//   "EMOJI_SYSTEM_DISABLED" - Emoji can no longer be used (e.g. due to
	// a shortcode conflict), but is not removed from existing embeddings.
	//   "EMOJI_HIDDEN" - Emoji is hidden from pickers, so new usages are
	// not allowed, but is not removed from existing embeddings.
	//   "EMOJI_DELETED" - Emoji is removed everywhere and is not available
	// to end-users.
	State string `json:"state,omitempty"`

	UpdateTimeMicros int64 `json:"updateTimeMicros,omitempty,string"`

	// Uuid: Unique key for a custom emoji resource. Required. This field is
	// *always* populated.
	Uuid string `json:"uuid,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BlobId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BlobId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedCustomEmoji) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedCustomEmoji
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedDimension: Dimension for the uploaded attachments.
type AppsDynamiteSharedDimension struct {
	Height int64 `json:"height,omitempty"`

	Width int64 `json:"width,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Height") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Height") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedDimension) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedDimension
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedDlpMetricsMetadata: LINT.IfChange
type AppsDynamiteSharedDlpMetricsMetadata struct {
	// DlpStatus: [required] Describes the DLP status of message send and
	// attachment upload events.
	//
	// Possible values:
	//   "DLP_STATUS_UNKNOWN"
	//   "DLP_DISABLED" - Rule fetch and evaluation are skipped because DLP
	// experiment is not enabled.
	//   "DLP_ENABLED_NO_RULE_FETCH" - Rule fetch and evaluation are skipped
	// because there is no rule to be fetched (e.g. message is sent from a
	// consumer, or there is no message.)
	//   "DLP_ENABLED_RULES_FETCHED_NO_RULES" - Rule fetch happened, but
	// rule evalution is skipped because the fetch returned no rules.
	//   "DLP_ENABLED_RULES_FETCHED_NO_APPLICABLE_RULES" - Rule fetch
	// happened, but rule evaluation is skipped because none of the rules
	// are applicable.
	//   "DLP_ENABLED_RULES_FETCHED_AND_EVALUATED" - Rule fetch and
	// evaluation were performed and completed successfully.
	//   "DLP_ENABLED_SCAN_TIMEOUT" - DLP scan was attempted but timed out.
	//   "DLP_ENABLED_SCAN_FAILED" - Generic DLP failure. This case covers
	// any other errors/exceptions in the Chat backend that caused the DLP
	// scan to fail.
	DlpStatus string `json:"dlpStatus,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DlpStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DlpStatus") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedDlpMetricsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedDlpMetricsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedDocument: Data for rendering a document.
type AppsDynamiteSharedDocument struct {
	// FileId: Unique file ID.
	FileId string `json:"fileId,omitempty"`

	// Justification: Justification to explain why this document is being
	// suggested.
	Justification *AppsDynamiteSharedJustification `json:"justification,omitempty"`

	// LastModifiedTime: Time the document was last modified.
	LastModifiedTime string `json:"lastModifiedTime,omitempty"`

	// MimeType: Used to determine which icon to render (e.g. docs, slides,
	// sheets)
	MimeType string `json:"mimeType,omitempty"`

	// Title: Title of the document.
	Title string `json:"title,omitempty"`

	// Url: URL of the document.
	Url string `json:"url,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FileId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FileId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedDocument) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedDocument
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsDynamiteSharedEmoji struct {
	// CustomEmoji: A custom emoji.
	CustomEmoji *AppsDynamiteSharedCustomEmoji `json:"customEmoji,omitempty"`

	// Unicode: A basic emoji represented by a unicode string.
	Unicode string `json:"unicode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CustomEmoji") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomEmoji") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedEmoji) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedEmoji
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedFindDocumentSuggestion: Data for a FindDocument
// suggestion type.
type AppsDynamiteSharedFindDocumentSuggestion struct {
	// DocumentSuggestions: List of documents to render as suggestions.
	DocumentSuggestions []*AppsDynamiteSharedDocument `json:"documentSuggestions,omitempty"`

	// ShowActionButtons: Whether to show the action buttons in the card for
	// the suggestions.
	ShowActionButtons bool `json:"showActionButtons,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DocumentSuggestions")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DocumentSuggestions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedFindDocumentSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedFindDocumentSuggestion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedGroupDetails: NEXT TAG: 3 A GroupDetails proto will
// store the information pertaining to single Group.
type AppsDynamiteSharedGroupDetails struct {
	// Description: A simple text that describes the purpose of a single
	// Group, the general theme of the topics to be posted and/or the
	// denominator of the Group participants.
	Description string `json:"description,omitempty"`

	// Guidelines: A simple text describing the rules and expectations from
	// members when participating in conversation.
	Guidelines string `json:"guidelines,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedGroupDetails) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedGroupDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsDynamiteSharedGroupVisibility struct {
	// Possible values:
	//   "UNKNOWN" - Do not use.
	//   "PRIVATE" - Explicitly invited users may join the room.
	//   "PUBLIC" - Anyone in the domain may join the room.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "State") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedGroupVisibility) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedGroupVisibility
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedJustification: Data for rendering a justification
// for a document.
type AppsDynamiteSharedJustification struct {
	// ActionTime: Time the action took place.
	ActionTime string `json:"actionTime,omitempty"`

	// ActionType: Type of action performed on the document.
	//
	// Possible values:
	//   "ACTION_TYPE_UNSPECIFIED" - Unspecified action.
	//   "COMMENTED" - Commented on document.
	//   "CREATED" - Created document.
	//   "EDITED" - Edited document.
	//   "PRESENTED" - Presented document.
	//   "SHARED" - Shared document.
	//   "VIEWED" - Viewed document.
	//   "COMMENT_RESOLVED" - Resolved comment on document.
	//   "SENT" - Sent document over chat/email.
	ActionType string `json:"actionType,omitempty"`

	// DocumentOwner: Owner of the document.
	DocumentOwner *AppsDynamiteSharedJustificationPerson `json:"documentOwner,omitempty"`

	// Topics: Words or phrases from the user's query that describes the
	// document content. (Ex: Users query is "Can you share the document
	// about Bullseye?" the extracted topic would be "Bullseye").
	Topics []string `json:"topics,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ActionTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActionTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedJustification) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedJustification
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedJustificationPerson: Data for rendering a person
// associated with a document.
type AppsDynamiteSharedJustificationPerson struct {
	// IsRecipient: Whether the person is the recipient of the suggestions.
	IsRecipient bool `json:"isRecipient,omitempty"`

	// User: Obfuscated user ID.
	User *UserId `json:"user,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IsRecipient") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IsRecipient") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedJustificationPerson) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedJustificationPerson
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedMeetMetadata: Metadata specific for a Meet call
// that are required to generate call artifacts.
type AppsDynamiteSharedMeetMetadata struct {
	// MeetingCode: Required. A globally unique code (e.g. "cxv-zbgj-wzw")
	// that points to a meeting space. Note: Meeting codes may be
	// regenerated, which will cause old meeting codes to become invalid.
	MeetingCode string `json:"meetingCode,omitempty"`

	// MeetingUrl: Required. A URL, in the format
	// "https://meet.google.com/*" (e.g.
	// https://meet.google.com/cxv-zbgj-wzw), to identify and access the
	// meeting space.
	MeetingUrl string `json:"meetingUrl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MeetingCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MeetingCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedMeetMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedMeetMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedMessageInfo: Information that references a Dynamite
// chat message. This is only used for Activity Feed messages.
type AppsDynamiteSharedMessageInfo struct {
	// MessageId: Id of the source chat message. This is kept here because
	// the top-level message ID to refers the AF message ID.
	MessageId *MessageId `json:"messageId,omitempty"`

	// MessageType: The type of the source chat message.
	//
	// Possible values:
	//   "MESSAGE_TYPE_UNSPECIFIED" - Default value where type is not
	// specified.
	//   "INLINE_REPLY" - The source chat message is a threaded reply to
	// another message.
	MessageType string `json:"messageType,omitempty"`

	// TopicReadTimeUsec: Timestamp of when the topic containing the message
	// has been read by the user. This is populated if the message
	// references an inline reply, in which case the space may be marked as
	// read but the topic still has unread messages.
	TopicReadTimeUsec int64 `json:"topicReadTimeUsec,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "MessageId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MessageId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedMessageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedMessageInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedMessageIntegrationPayload: The payload(restricted
// to 1P applications) to be stored with a specific message.
type AppsDynamiteSharedMessageIntegrationPayload struct {
	// ProjectNumber: Pantheon project number used to identify the calling
	// app.
	ProjectNumber int64 `json:"projectNumber,omitempty,string"`

	TasksMessageIntegrationPayload *AppsDynamiteSharedTasksMessageIntegrationPayload `json:"tasksMessageIntegrationPayload,omitempty"`

	// Type: An enum indicating which 1P application's payload this is. This
	// field is required to add 1P payload.
	//
	// Possible values:
	//   "PAYLOAD_TYPE_UNSPECIFIED"
	//   "TASKS"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ProjectNumber") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ProjectNumber") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedMessageIntegrationPayload) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedMessageIntegrationPayload
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedOrganizationInfo: Contains info about the entity
// that something is, or is owned by.
type AppsDynamiteSharedOrganizationInfo struct {
	ConsumerInfo *AppsDynamiteSharedOrganizationInfoConsumerInfo `json:"consumerInfo,omitempty"`

	CustomerInfo *AppsDynamiteSharedOrganizationInfoCustomerInfo `json:"customerInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConsumerInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConsumerInfo") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedOrganizationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedOrganizationInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedOrganizationInfoConsumerInfo: Intentionally empty.
// Used to disambiguate consumer and customer use cases in oneof below.
type AppsDynamiteSharedOrganizationInfoConsumerInfo struct {
}

type AppsDynamiteSharedOrganizationInfoCustomerInfo struct {
	CustomerId *CustomerId `json:"customerId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CustomerId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomerId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedOrganizationInfoCustomerInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedOrganizationInfoCustomerInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedOriginAppSuggestion: Stores the suggestion provided
// by apps/bots.
type AppsDynamiteSharedOriginAppSuggestion struct {
	AppId *AppId `json:"appId,omitempty"`

	CardClickSuggestion *AppsDynamiteSharedCardClickSuggestion `json:"cardClickSuggestion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AppId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedOriginAppSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedOriginAppSuggestion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsDynamiteSharedPhoneNumber struct {
	// Type: The phone number type, e.g., work, mobile, etc.
	Type string `json:"type,omitempty"`

	// Value: The actual phone number.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedPhoneNumber) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedPhoneNumber
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsDynamiteSharedReaction struct {
	// Count: The total number of users who have reacted.
	Count int64 `json:"count,omitempty"`

	// CreateTimestamp: When the first emoji of this type was added.
	CreateTimestamp int64 `json:"createTimestamp,omitempty,string"`

	// CurrentUserParticipated: Whether the current user reacted using this
	// emoji. Note: Unlike most properties of messages, this is different
	// per-user.
	CurrentUserParticipated bool `json:"currentUserParticipated,omitempty"`

	Emoji *AppsDynamiteSharedEmoji `json:"emoji,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Count") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedReaction) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedReaction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedRetentionSettings: The settings of retention period
// of a message or topic.
type AppsDynamiteSharedRetentionSettings struct {
	// ExpiryTimestamp: The timestamp after which the message/topic should
	// be removed, in microseconds since the epoch, when state ==
	// EPHEMERAL_ONE_DAY. The value should not be set in other cases.
	ExpiryTimestamp int64 `json:"expiryTimestamp,omitempty,string"`

	// State: The retention state.
	//
	// Possible values:
	//   "UNKNOWN_RETENTION_STATE"
	//   "PERMANENT" - The message/topic should be kept permanently.
	//   "EPHEMERAL_ONE_DAY" - The message/topic should be kept with a
	// 24-hour TTL.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExpiryTimestamp") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExpiryTimestamp") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedRetentionSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedRetentionSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedSegmentedMembershipCount: Contains info on
// membership count for member types: HUMAN_USER, APP_USER &
// ROSTER_MEMBER different states: INVITED, JOINED
type AppsDynamiteSharedSegmentedMembershipCount struct {
	// Possible values:
	//   "MEMBER_TYPE_UNSPECIFIED" - default value
	//   "HUMAN_USER" - member is a human user
	//   "ROSTER_MEMBER" - member is a roster
	MemberType string `json:"memberType,omitempty"`

	// MembershipCount: count of members with given type and state
	MembershipCount int64 `json:"membershipCount,omitempty"`

	// Possible values:
	//   "MEMBER_UNKNOWN" - Default state, do not use
	//   "MEMBER_INVITED" - An invitation to the space has been sent
	//   "MEMBER_JOINED" - User has joined the space
	//   "MEMBER_NOT_A_MEMBER" - User is not a member
	//   "MEMBER_FAILED" - This state should never be stored in Spanner. It
	// is a state for responses to the clients to indicate that membership
	// mutations have failed and the member is in its previous state.
	MembershipState string `json:"membershipState,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MemberType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MemberType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedSegmentedMembershipCount) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedSegmentedMembershipCount
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsDynamiteSharedSegmentedMembershipCounts struct {
	Value []*AppsDynamiteSharedSegmentedMembershipCount `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Value") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedSegmentedMembershipCounts) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedSegmentedMembershipCounts
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedSpaceInfo: Defines the representation of a single
// matching space.
type AppsDynamiteSharedSpaceInfo struct {
	AvatarInfo *AppsDynamiteSharedAvatarInfo `json:"avatarInfo,omitempty"`

	AvatarUrl string `json:"avatarUrl,omitempty"`

	Description string `json:"description,omitempty"`

	GroupId *GroupId `json:"groupId,omitempty"`

	// InviterEmail: The email address of the user that invited the calling
	// user to the room, if available. This field will only be populated for
	// direct invites, it will be empty if the user was indirectly invited
	// to the group.
	InviterEmail string `json:"inviterEmail,omitempty"`

	// IsExternal: Whether this is a space that enables guest access
	IsExternal bool `json:"isExternal,omitempty"`

	Name string `json:"name,omitempty"`

	NumMembers int64 `json:"numMembers,omitempty"`

	// UserMembershipState: searching user's membership state in this space
	//
	// Possible values:
	//   "MEMBER_UNKNOWN" - Default state, do not use
	//   "MEMBER_INVITED" - An invitation to the space has been sent
	//   "MEMBER_JOINED" - User has joined the space
	//   "MEMBER_NOT_A_MEMBER" - User is not a member
	//   "MEMBER_FAILED" - This state should never be stored in Spanner. It
	// is a state for responses to the clients to indicate that membership
	// mutations have failed and the member is in its previous state.
	UserMembershipState string `json:"userMembershipState,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AvatarInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AvatarInfo") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedSpaceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedSpaceInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedTasksAnnotationData: This is the internal version
// of the API proto at
// google3/google/chat/v1/gsuite_message_integration.proto
type AppsDynamiteSharedTasksAnnotationData struct {
	AssigneeChange *AppsDynamiteSharedTasksAnnotationDataAssigneeChange `json:"assigneeChange,omitempty"`

	CompletionChange *AppsDynamiteSharedTasksAnnotationDataCompletionChange `json:"completionChange,omitempty"`

	Creation *AppsDynamiteSharedTasksAnnotationDataCreation `json:"creation,omitempty"`

	DeletionChange *AppsDynamiteSharedTasksAnnotationDataDeletionChange `json:"deletionChange,omitempty"`

	// TaskId: ID of task. Will be used to create deep links to Tasks.
	TaskId string `json:"taskId,omitempty"`

	// TaskProperties: Task properties after the update has been applied.
	TaskProperties *AppsDynamiteSharedTasksAnnotationDataTaskProperties `json:"taskProperties,omitempty"`

	UserDefinedMessage *AppsDynamiteSharedTasksAnnotationDataUserDefinedMessage `json:"userDefinedMessage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AssigneeChange") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AssigneeChange") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedTasksAnnotationData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedTasksAnnotationData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsDynamiteSharedTasksAnnotationDataAssigneeChange struct {
	// OldAssignee: Obfuscated user ID of previous assignee. Not set if the
	// task was originally not assigned.
	OldAssignee *UserId `json:"oldAssignee,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OldAssignee") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OldAssignee") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedTasksAnnotationDataAssigneeChange) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedTasksAnnotationDataAssigneeChange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsDynamiteSharedTasksAnnotationDataCompletionChange struct {
}

type AppsDynamiteSharedTasksAnnotationDataCreation struct {
}

type AppsDynamiteSharedTasksAnnotationDataDeletionChange struct {
}

// AppsDynamiteSharedTasksAnnotationDataTaskProperties: All relevant
// task properties for a Chat message.
type AppsDynamiteSharedTasksAnnotationDataTaskProperties struct {
	// Assignee: Obfuscated user ID of new assignee. Not set if the task
	// doesn't have an assignee.
	Assignee *UserId `json:"assignee,omitempty"`

	// Completed: Whether the task is marked as completed.
	Completed bool `json:"completed,omitempty"`

	// Deleted: Whether the task is marked as deleted.
	Deleted bool `json:"deleted,omitempty"`

	// Description: The description of the task. If Task original
	// description's length is greater than 1024, then Task BE sends the
	// truncated description to Dynamite Integration Server.
	Description string `json:"description,omitempty"`

	// StartDate: Set if the task has a date but no time. Source of truth in
	// Tasks BE: http://shortn/_wyT7eB4Ixv
	StartDate *Date `json:"startDate,omitempty"`

	// StartTime: Set if the task has both a date and a time. Source of
	// truth in Tasks BE: http://shortn/_u6cr0F5ttE
	StartTime string `json:"startTime,omitempty"`

	// Title: The title of the task.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Assignee") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Assignee") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedTasksAnnotationDataTaskProperties) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedTasksAnnotationDataTaskProperties
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedTasksAnnotationDataUserDefinedMessage: Used for
// task card attachments on custom user messages that should be kept as
// is without generating an i18n event message, e.g. the user starts a
// conversation from an existing task. IMPORTANT: please don't populate
// this field yet as it could break existing flows until it's
// implemented. See code at http://shortn/_CM74CdENMx used by
// http://shortn/_5o85POJY8Q.
type AppsDynamiteSharedTasksAnnotationDataUserDefinedMessage struct {
}

// AppsDynamiteSharedTasksMessageIntegrationPayload: A payload
// containing Tasks metadata for rendering a live card. Currently not
// used by the Tasks integration.
type AppsDynamiteSharedTasksMessageIntegrationPayload struct {
}

// AppsDynamiteSharedUserBlockRelationship: User-block relationship
type AppsDynamiteSharedUserBlockRelationship struct {
	HasBlockedRequester bool `json:"hasBlockedRequester,omitempty"`

	IsBlockedByRequester bool `json:"isBlockedByRequester,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HasBlockedRequester")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HasBlockedRequester") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedUserBlockRelationship) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedUserBlockRelationship
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedVideoReference: Reference to a transcoded video
// attachment.
type AppsDynamiteSharedVideoReference struct {
	// Format: Available transcode format. Value is defined in
	// video/storage/proto/content_header.proto
	Format []int64 `json:"format,omitempty"`

	// Status: Transcode status
	//
	// Possible values:
	//   "UNKNOWN_STATUS"
	//   "SUCCESS"
	//   "ERROR"
	//   "NOT_APPLICABLE"
	//   "THUMBNAIL_SUCCESS"
	//   "GO_LIVE_SUCCESS"
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Format") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Format") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedVideoReference) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedVideoReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageAction: An action that describes the behavior when
// the form is submitted. For example, an Apps Script can be invoked to
// handle the form.
type AppsDynamiteStorageAction struct {
	// Function: Apps Script function to invoke when the containing element
	// is clicked/activated.
	Function string `json:"function,omitempty"`

	// Possible values:
	//   "INTERACTION_UNSPECIFIED" - Default value if interaction is not
	// specified.
	//   "OPEN_DIALOG" - A dialog opens by clicking the button.
	Interaction string `json:"interaction,omitempty"`

	// Possible values:
	//   "SPINNER" - Displays a spinner to indicate that content is loading.
	//   "NONE" - Nothing is displayed.
	LoadIndicator string `json:"loadIndicator,omitempty"`

	// Parameters: List of action parameters.
	Parameters []*AppsDynamiteStorageActionActionParameter `json:"parameters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Function") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Function") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageAction) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageActionActionParameter: List of string parameters
// to supply when the action method is invoked. For example, consider
// three snooze buttons: snooze now, snooze 1 day, snooze next week. You
// might use action method = snooze(), passing the snooze type and
// snooze time in the list of string parameters.
type AppsDynamiteStorageActionActionParameter struct {
	// Key: The name of the parameter for the action script.
	Key string `json:"key,omitempty"`

	// Value: The value of the parameter.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageActionActionParameter) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageActionActionParameter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageBorderStyle: Represents the complete border style
// applied to widgets.
type AppsDynamiteStorageBorderStyle struct {
	// CornerRadius: The corner radius for the border.
	CornerRadius int64 `json:"cornerRadius,omitempty"`

	// StrokeColor: The colors to use when the type is `BORDER_TYPE_STROKE`.
	StrokeColor *Color `json:"strokeColor,omitempty"`

	// Type: The border type.
	//
	// Possible values:
	//   "BORDER_TYPE_UNSPECIFIED" - No value specified.
	//   "NO_BORDER" - No border.
	//   "STROKE" - Outline.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CornerRadius") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CornerRadius") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageBorderStyle) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageBorderStyle
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageButton: A button. Can be a text button or an image
// button.
type AppsDynamiteStorageButton struct {
	// AltText: The alternative text used for accessibility. Has no effect
	// when an icon is set; use `icon.alt_text` instead.
	AltText string `json:"altText,omitempty"`

	// Color: If set, the button is filled with a solid background.
	Color *Color `json:"color,omitempty"`

	// Disabled: If true, the button is displayed in a disabled state and
	// doesn't respond to user actions.
	Disabled bool `json:"disabled,omitempty"`

	// Icon: The icon image.
	Icon *AppsDynamiteStorageIcon `json:"icon,omitempty"`

	// OnClick: The action to perform when the button is clicked.
	OnClick *AppsDynamiteStorageOnClick `json:"onClick,omitempty"`

	// Text: The text of the button.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AltText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AltText") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageButton) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageButton
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageButtonList: A list of buttons layed out
// horizontally.
type AppsDynamiteStorageButtonList struct {
	Buttons []*AppsDynamiteStorageButton `json:"buttons,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Buttons") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Buttons") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageButtonList) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageButtonList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageCard: A card is a UI element that can contain UI
// widgets such as text and images. For more information, see Cards .
// For example, the following JSON creates a card that has a header with
// the name, position, icons, and link for a contact, followed by a
// section with contact information like email and phone number. ``` {
// "header": { "title": "Heba Salam", "subtitle": "Software Engineer",
// "imageStyle": "ImageStyle.AVATAR", "imageUrl":
// "https://example.com/heba_salam.png", "imageAltText": "Avatar for
// Heba Salam" }, "sections" : [ { "header": "Contact Info", "widgets":
// [ { "decorated_text": { "icon": { "knownIcon": "EMAIL" }, "content":
// "heba.salam@example.com" } }, { "decoratedText": { "icon": {
// "knownIcon": "PERSON" }, "content": "Online" } }, { "decoratedText":
// { "icon": { "knownIcon": "PHONE" }, "content": "+1 (555) 555-1234" }
// }, { "buttons": [ { "textButton": { "text": "Share", }, "onClick": {
// "openLink": { "url": "https://example.com/share" } } }, {
// "textButton": { "text": "Edit", }, "onClick": { "action": {
// "function": "goToView", "parameters": [ { "key": "viewType", "value":
// "EDIT" } ], "loadIndicator": "LoadIndicator.SPINNER" } } } ] } ],
// "collapsible": true, "uncollapsibleWidgetsCount": 3 } ],
// "cardActions": [ { "actionLabel": "Send Feedback", "onClick": {
// "openLink": { "url": "https://example.com/feedback" } } } ], "name":
// "contact-card-K3wB6arF2H9L" } ```
type AppsDynamiteStorageCard struct {
	// CardActions: The actions of this card. They are added to a card's
	// generated toolbar menu. For example, the following JSON constructs a
	// card action menu with Settings and Send Feedback options: ```
	// "card_actions": [ { "actionLabel": "Setting", "onClick": { "action":
	// { "functionName": "goToView", "parameters": [ { "key": "viewType",
	// "value": "SETTING" } ], "loadIndicator": "LoadIndicator.SPINNER" } }
	// }, { "actionLabel": "Send Feedback", "onClick": { "openLink": {
	// "url": "https://example.com/feedback" } } } ] ```
	CardActions []*AppsDynamiteStorageCardCardAction `json:"cardActions,omitempty"`

	// Header: The header of the card. A header usually contains a title and
	// an image.
	Header *AppsDynamiteStorageCardCardHeader `json:"header,omitempty"`

	// Name: Name of the card, which is used as a identifier for the card in
	// card navigation.
	Name string `json:"name,omitempty"`

	// Sections: Sections are separated by a line divider.
	Sections []*AppsDynamiteStorageCardSection `json:"sections,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CardActions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CardActions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageCard) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageCard
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageCardCardAction: A card action is the action
// associated with the card. For example, an invoice card might include
// actions such as delete invoice, email invoice, or open the invoice in
// a browser.
type AppsDynamiteStorageCardCardAction struct {
	// ActionLabel: The label that displays as the action menu item.
	ActionLabel string `json:"actionLabel,omitempty"`

	// OnClick: The onclick action for this action item.
	OnClick *AppsDynamiteStorageOnClick `json:"onClick,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ActionLabel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActionLabel") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageCardCardAction) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageCardCardAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsDynamiteStorageCardCardHeader struct {
	// ImageAltText: The alternative text of this image which is used for
	// accessibility.
	ImageAltText string `json:"imageAltText,omitempty"`

	// ImageType: The image's type.
	//
	// Possible values:
	//   "SQUARE" - Applies no cropping to the image.
	//   "CIRCLE" - Applies a circular mask to the image.
	ImageType string `json:"imageType,omitempty"`

	// ImageUrl: The URL of the image in the card header.
	ImageUrl string `json:"imageUrl,omitempty"`

	// Subtitle: The subtitle of the card header.
	Subtitle string `json:"subtitle,omitempty"`

	// Title: The title of the card header. The title must be specified. The
	// header has a fixed height: if both a title and subtitle are
	// specified, each takes up one line. If only the title is specified, it
	// takes up both lines.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ImageAltText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ImageAltText") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageCardCardHeader) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageCardCardHeader
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageCardSection: A section contains a collection of
// widgets that are rendered vertically in the order that they are
// specified. Across all platforms, cards have a narrow fixed width, so
// there is currently no need for layout properties, for example, float.
type AppsDynamiteStorageCardSection struct {
	// Collapsible: Indicates whether this section is collapsible. If a
	// section is collapsible, the description must be given.
	Collapsible bool `json:"collapsible,omitempty"`

	// Header: The header of the section. Formatted text is supported.
	Header string `json:"header,omitempty"`

	// UncollapsibleWidgetsCount: The number of uncollapsible widgets. For
	// example, when a section contains five widgets and the
	// `numUncollapsibleWidget` is set to `2`, the first two widgets are
	// always shown and the last three are collapsed as default. The
	// `numUncollapsibleWidget` is taken into account only when collapsible
	// is set to `true`.
	UncollapsibleWidgetsCount int64 `json:"uncollapsibleWidgetsCount,omitempty"`

	// Widgets: A section must contain at least 1 widget.
	Widgets []*AppsDynamiteStorageWidget `json:"widgets,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Collapsible") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Collapsible") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageCardSection) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageCardSection
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageColumns: Represents a Columns widget that displays
// a single row of columns.
type AppsDynamiteStorageColumns struct {
	// ColumnItems: Each card supports up to 2 columns.
	ColumnItems []*AppsDynamiteStorageColumnsColumn `json:"columnItems,omitempty"`

	// WrapStyle: Controls how the column resizes based on screen width.
	//
	// Possible values:
	//   "WRAP_STYLE_UNSPECIFIED" - Unspecified.
	//   "NOWRAP" - Column widgets don't wrap.
	//   "WRAP" - Column Widgets wrap.
	WrapStyle string `json:"wrapStyle,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ColumnItems") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ColumnItems") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageColumns) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageColumns
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageColumnsColumn: Represents a Column that consists
// of widgets stacked vertically.
type AppsDynamiteStorageColumnsColumn struct {
	// HorizontalAlignment: The horizontal alignment of the column.
	//
	// Possible values:
	//   "HORIZONTAL_ALIGNMENT_UNSPECIFIED" - Unspecified alignment.
	//   "START" - Alignment to the start position.
	//   "CENTER" - Alignment to the center position.
	//   "END" - Alignment to the end position.
	HorizontalAlignment string `json:"horizontalAlignment,omitempty"`

	// HorizontalSizeStyle: Specifies how the column content is sized
	// horizontally.
	//
	// Possible values:
	//   "HORIZONTAL_SIZE_STYLE_UNSPECIFIED" - Unspecified.
	//   "FILL_AVAILABLE_SPACE" - Fills up the available horizontal width.
	// Default value if unspecified.
	//   "FILL_MINIMUM_SPACE" - Fills up the minimum horizontal width.
	HorizontalSizeStyle string `json:"horizontalSizeStyle,omitempty"`

	// VerticalAlignment: The vertical alignment of the column.
	//
	// Possible values:
	//   "VERTICAL_ALIGNMENT_UNSPECIFIED" - Unspecified.
	//   "CENTER" - Aligns the widget in the center of the column. Default
	// value if unspecified.
	//   "TOP" - Aligns the widget at the top of the column.
	//   "BOTTOM" - Aligns the widget at the bottom of the column.
	VerticalAlignment string `json:"verticalAlignment,omitempty"`

	// Widgets:
	// LINT.ThenChange(//depot/google3/google/apps/card/v1/card.proto) Array
	// of widgets included in the column.
	Widgets []*AppsDynamiteStorageColumnsColumnWidgets `json:"widgets,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HorizontalAlignment")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HorizontalAlignment") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageColumnsColumn) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageColumnsColumn
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageColumnsColumnWidgets: LINT.IfChange The `column`
// widget can contain these widgets.
type AppsDynamiteStorageColumnsColumnWidgets struct {
	// ButtonList: ButtonList widget.
	ButtonList *AppsDynamiteStorageButtonList `json:"buttonList,omitempty"`

	// DateTimePicker: DateTimePicker widget.
	DateTimePicker *AppsDynamiteStorageDateTimePicker `json:"dateTimePicker,omitempty"`

	// DecoratedText: DecoratedText widget.
	DecoratedText *AppsDynamiteStorageDecoratedText `json:"decoratedText,omitempty"`

	// Image: Image widget.
	Image *AppsDynamiteStorageImage `json:"image,omitempty"`

	// SelectionInput: SelectionInput widget.
	SelectionInput *AppsDynamiteStorageSelectionInput `json:"selectionInput,omitempty"`

	// TextInput: TextInput widget.
	TextInput *AppsDynamiteStorageTextInput `json:"textInput,omitempty"`

	// TextParagraph: Text paragraph widget.
	TextParagraph *AppsDynamiteStorageTextParagraph `json:"textParagraph,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ButtonList") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ButtonList") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageColumnsColumnWidgets) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageColumnsColumnWidgets
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageDateTimePicker: The widget that lets users to
// specify a date and time.
type AppsDynamiteStorageDateTimePicker struct {
	// Label: The label for the field that displays to the user.
	Label string `json:"label,omitempty"`

	// Name: The name of the text input that's used in formInput, and
	// uniquely identifies this input.
	Name string `json:"name,omitempty"`

	// OnChangeAction: Triggered when the user clicks Save or Clear from the
	// date/time picker dialog. This is only triggered if the value changed
	// as a result of the Save/Clear operation.
	OnChangeAction *AppsDynamiteStorageAction `json:"onChangeAction,omitempty"`

	// TimezoneOffsetDate: The number representing the time zone offset from
	// UTC, in minutes. If set, the `value_ms_epoch` is displayed in the
	// specified time zone. If not set, it uses the user's time zone setting
	// on the client side.
	TimezoneOffsetDate int64 `json:"timezoneOffsetDate,omitempty"`

	// Type: The type of the date/time picker.
	//
	// Possible values:
	//   "DATE_AND_TIME" - The user can select a date and time.
	//   "DATE_ONLY" - The user can only select a date.
	//   "TIME_ONLY" - The user can only select a time.
	Type string `json:"type,omitempty"`

	// ValueMsEpoch: The value to display as the default value before user
	// input or previous user input. It is represented in milliseconds
	// (Epoch time). For `DATE_AND_TIME` type, the full epoch value is used.
	// For `DATE_ONLY` type, only date of the epoch time is used. For
	// `TIME_ONLY` type, only time of the epoch time is used. For example,
	// you can set epoch time to `3 * 60 * 60 * 1000` to represent 3am.
	ValueMsEpoch int64 `json:"valueMsEpoch,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Label") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Label") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageDateTimePicker) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageDateTimePicker
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageDecoratedText: A widget that displays text with
// optional decorations such as a label above or below the text, an icon
// in front of the text, a selection widget or a button after the text.
type AppsDynamiteStorageDecoratedText struct {
	// BottomLabel: The formatted text label that shows below the main text.
	BottomLabel string `json:"bottomLabel,omitempty"`

	// Button: A button that can be clicked to trigger an action.
	Button *AppsDynamiteStorageButton `json:"button,omitempty"`

	// EndIcon: An icon displayed after the text.
	EndIcon *AppsDynamiteStorageIcon `json:"endIcon,omitempty"`

	// Icon: Deprecated in favor of start_icon.
	Icon *AppsDynamiteStorageIcon `json:"icon,omitempty"`

	// OnClick: Only the top and bottom label and content region are
	// clickable.
	OnClick *AppsDynamiteStorageOnClick `json:"onClick,omitempty"`

	// StartIcon: The icon displayed in front of the text.
	StartIcon *AppsDynamiteStorageIcon `json:"startIcon,omitempty"`

	// SwitchControl: A switch widget can be clicked to change its state or
	// trigger an action.
	SwitchControl *AppsDynamiteStorageDecoratedTextSwitchControl `json:"switchControl,omitempty"`

	// Text: Required. The main widget formatted text. See Text formatting
	// for details.
	Text string `json:"text,omitempty"`

	// TopLabel: The formatted text label that shows above the main text.
	TopLabel string `json:"topLabel,omitempty"`

	// WrapText: The wrap text setting. If `true`, the text is wrapped and
	// displayed in multiline. Otherwise, the text is truncated.
	WrapText bool `json:"wrapText,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BottomLabel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BottomLabel") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageDecoratedText) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageDecoratedText
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsDynamiteStorageDecoratedTextSwitchControl struct {
	// ControlType: The control type, either switch or checkbox.
	//
	// Possible values:
	//   "SWITCH"
	//   "CHECKBOX" - Deprecated in favor of `CHECK_BOX`.
	//   "CHECK_BOX"
	ControlType string `json:"controlType,omitempty"`

	// Name: The name of the switch widget that's used in formInput.
	Name string `json:"name,omitempty"`

	// OnChangeAction: The action when the switch state is changed.
	OnChangeAction *AppsDynamiteStorageAction `json:"onChangeAction,omitempty"`

	// Selected: If the switch is selected.
	Selected bool `json:"selected,omitempty"`

	// Value: The value is what is passed back in the callback.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ControlType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ControlType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageDecoratedTextSwitchControl) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageDecoratedTextSwitchControl
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageDivider: A divider that appears in between
// widgets.
type AppsDynamiteStorageDivider struct {
}

// AppsDynamiteStorageGrid: Represents a Grid widget that displays items
// in a configurable grid layout.
type AppsDynamiteStorageGrid struct {
	// BorderStyle: The border style to apply to each grid item.
	BorderStyle *AppsDynamiteStorageBorderStyle `json:"borderStyle,omitempty"`

	// ColumnCount: The number of columns to display in the grid. A default
	// value is used if this field isn't specified, and that default value
	// is different depending on where the grid is shown (dialog versus
	// companion).
	ColumnCount int64 `json:"columnCount,omitempty"`

	// Items: The items to display in the grid.
	Items []*AppsDynamiteStorageGridGridItem `json:"items,omitempty"`

	// OnClick: This callback is reused by each individual grid item, but
	// with the item's identifier and index in the items list added to the
	// callback's parameters.
	OnClick *AppsDynamiteStorageOnClick `json:"onClick,omitempty"`

	// Title: The text that displays in the grid header.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BorderStyle") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BorderStyle") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageGrid) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageGrid
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageGridGridItem: Represents a single item in the grid
// layout.
type AppsDynamiteStorageGridGridItem struct {
	// Id: A user-specified identifier for this grid item. This identifier
	// is returned in the parent Grid's onClick callback parameters.
	Id string `json:"id,omitempty"`

	// Image: The image that displays in the grid item.
	Image *AppsDynamiteStorageImageComponent `json:"image,omitempty"`

	// Layout: The layout to use for the grid item.
	//
	// Possible values:
	//   "GRID_ITEM_LAYOUT_UNSPECIFIED" - No layout specified.
	//   "TEXT_BELOW" - The title and subtitle are shown below the grid
	// item's image.
	//   "TEXT_ABOVE" - The title and subtitle are shown above the grid
	// item's image.
	Layout string `json:"layout,omitempty"`

	// Subtitle: The grid item's subtitle.
	Subtitle string `json:"subtitle,omitempty"`

	// TextAlignment: The horizontal alignment of the grid item's text.
	//
	// Possible values:
	//   "HORIZONTAL_ALIGNMENT_UNSPECIFIED" - Unspecified alignment.
	//   "START" - Alignment to the start position.
	//   "CENTER" - Alignment to the center position.
	//   "END" - Alignment to the end position.
	TextAlignment string `json:"textAlignment,omitempty"`

	// Title: The grid item's title.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageGridGridItem) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageGridGridItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsDynamiteStorageIcon struct {
	// AltText: The description of the icon, used for accessibility. The
	// default value is provided if you don't specify one.
	AltText string `json:"altText,omitempty"`

	// IconUrl: The icon specified by a URL.
	IconUrl string `json:"iconUrl,omitempty"`

	// ImageType: The crop style applied to the image. In some cases,
	// applying a `CIRCLE` crop causes the image to be drawn larger than a
	// standard icon.
	//
	// Possible values:
	//   "SQUARE" - Applies no cropping to the image.
	//   "CIRCLE" - Applies a circular mask to the image.
	ImageType string `json:"imageType,omitempty"`

	// KnownIcon: The icon specified by the string name of a list of known
	// icons
	KnownIcon string `json:"knownIcon,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AltText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AltText") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageIcon) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageIcon
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageImage: An image that is specified by a URL and can
// have an onClick action.
type AppsDynamiteStorageImage struct {
	// AltText: The alternative text of this image, used for accessibility.
	AltText string `json:"altText,omitempty"`

	// ImageUrl: An image URL.
	ImageUrl string `json:"imageUrl,omitempty"`

	OnClick *AppsDynamiteStorageOnClick `json:"onClick,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AltText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AltText") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageImage) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageImage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsDynamiteStorageImageComponent struct {
	// AltText: The accessibility label for the image.
	AltText string `json:"altText,omitempty"`

	// BorderStyle: The border style to apply to the image.
	BorderStyle *AppsDynamiteStorageBorderStyle `json:"borderStyle,omitempty"`

	// CropStyle: The crop style to apply to the image.
	CropStyle *AppsDynamiteStorageImageCropStyle `json:"cropStyle,omitempty"`

	// ImageUri: The image URL.
	ImageUri string `json:"imageUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AltText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AltText") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageImageComponent) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageImageComponent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageImageCropStyle: Represents the crop style applied
// to an image.
type AppsDynamiteStorageImageCropStyle struct {
	// AspectRatio: The aspect ratio to use if the crop type is
	// `RECTANGLE_CUSTOM`.
	AspectRatio float64 `json:"aspectRatio,omitempty"`

	// Type: The crop type.
	//
	// Possible values:
	//   "IMAGE_CROP_TYPE_UNSPECIFIED" - No value specified.
	//   "SQUARE" - Applies a square crop.
	//   "CIRCLE" - Applies a circular crop.
	//   "RECTANGLE_CUSTOM" - Applies a rectangular crop with a custom
	// aspect ratio.
	//   "RECTANGLE_4_3" - Applies a rectangular crop with a 4:3 aspect
	// ratio.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AspectRatio") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AspectRatio") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageImageCropStyle) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageImageCropStyle
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AppsDynamiteStorageImageCropStyle) UnmarshalJSON(data []byte) error {
	type NoMethod AppsDynamiteStorageImageCropStyle
	var s1 struct {
		AspectRatio gensupport.JSONFloat64 `json:"aspectRatio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AspectRatio = float64(s1.AspectRatio)
	return nil
}

type AppsDynamiteStorageOnClick struct {
	// Action: If specified, an action is triggered by this onClick.
	Action *AppsDynamiteStorageAction `json:"action,omitempty"`

	// HostAppAction: Triggers host app action on click directly without
	// invoking form actions. This is currently not available to end-users
	// and is used internal only.
	HostAppAction *HostAppActionMarkup `json:"hostAppAction,omitempty"`

	// OpenDynamicLinkAction: An add-on triggers this action when the action
	// needs to open a link. This differs from the open_link above in that
	// this needs to talk to server to get the link. Thus some preparation
	// work is required for web client to do before the open link action
	// response comes back.
	OpenDynamicLinkAction *AppsDynamiteStorageAction `json:"openDynamicLinkAction,omitempty"`

	// OpenLink: If specified, this onClick triggers an open link action.
	OpenLink *AppsDynamiteStorageOpenLink `json:"openLink,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageOnClick) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageOnClick
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsDynamiteStorageOpenLink struct {
	// AppUri: Represents the platform specific uri/intent to open on each
	// client. For example: A companion_url will open in a companion window
	// on the web. An iOS URL and android intent will open in the
	// corresponding hosting apps. If these platform specific URLs can't be
	// handled correctly, i.e. if the companion isn't supported on web and
	// the hosting apps aren't available on the mobile platforms then the
	// `uri` will open in a new browser window on all the platforms.
	AppUri *AppsDynamiteStorageOpenLinkAppUri `json:"appUri,omitempty"`

	// Possible values:
	//   "NOTHING" - Doesn’t reload the card after the child window
	// closes. Reloads the card after the child window closes. If used in
	// conjunction with
	// [OpenAs.OVERLAY](/workspace/add-ons/reference/rpc/google.apps.card.v1#
	// openas), the child window acts as a modal dialog and the main card is
	// blocked until the child window closes.
	//   "RELOAD"
	OnClose string `json:"onClose,omitempty"`

	// Possible values:
	//   "FULL_SIZE" - The link opens as a full size window (if that's the
	// frame used by the client.
	//   "OVERLAY" - The link opens as an overlay, such as a pop-up.
	OpenAs string `json:"openAs,omitempty"`

	// Url: The URL to open.
	Url string `json:"url,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AppUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppUri") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageOpenLink) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageOpenLink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageOpenLinkAppUri: Represents the platform specific
// uri/intent to open for each client.
type AppsDynamiteStorageOpenLinkAppUri struct {
	// AndroidIntent: An intent object to be opened in the corresponding
	// android hosting app.
	AndroidIntent *AppsDynamiteStorageOpenLinkAppUriIntent `json:"androidIntent,omitempty"`

	// CompanionUri: A companion uri string to be opened in the chat
	// companion window. on the web.
	CompanionUri string `json:"companionUri,omitempty"`

	// IosUri: A uri string to be opened in the corresponding iOS hosting
	// app.
	IosUri string `json:"iosUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AndroidIntent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AndroidIntent") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageOpenLinkAppUri) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageOpenLinkAppUri
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageOpenLinkAppUriIntent: Android intent.
type AppsDynamiteStorageOpenLinkAppUriIntent struct {
	// ExtraData: A list of extra data for the android intent. For example,
	// for a calendar event edit intent, the event title information can be
	// passed as extra data.
	ExtraData []*AppsDynamiteStorageOpenLinkAppUriIntentExtraData `json:"extraData,omitempty"`

	// IntentAction: An android intent action string for the {@link
	// android.content.Intent} object. For example: for the view intent
	// action type, a valid value will be
	// android.content.Intent.ACTION_VIEW.
	IntentAction string `json:"intentAction,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExtraData") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExtraData") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageOpenLinkAppUriIntent) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageOpenLinkAppUriIntent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageOpenLinkAppUriIntentExtraData: Extra data for an
// android intent. Valid keys are defined in the hosting app contract.
type AppsDynamiteStorageOpenLinkAppUriIntentExtraData struct {
	// Key: A key for the intent extra data.
	Key string `json:"key,omitempty"`

	// Value: Value for the given extra data key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageOpenLinkAppUriIntentExtraData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageOpenLinkAppUriIntentExtraData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageSelectionInput: A widget that creates a UI item
// (for example, a drop-down list) with options for users to select.
type AppsDynamiteStorageSelectionInput struct {
	Items []*AppsDynamiteStorageSelectionInputSelectionItem `json:"items,omitempty"`

	// Label: The label displayed ahead of the switch control.
	Label string `json:"label,omitempty"`

	// Name: The name of the text input which is used in formInput.
	Name string `json:"name,omitempty"`

	// OnChangeAction: If specified, the form is submitted when the
	// selection changes. If not specified, you must specify a separate
	// button.
	OnChangeAction *AppsDynamiteStorageAction `json:"onChangeAction,omitempty"`

	// Possible values:
	//   "CHECK_BOX" - The selection type is a checkbox.
	//   "RADIO_BUTTON" - The selection type is a radio button.
	//   "SWITCH" - The selection type is a switch.
	//   "DROPDOWN" - The selection type is a dropdown.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Items") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageSelectionInput) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageSelectionInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageSelectionInputSelectionItem: The item in the
// switch control. A radio button, at most one of the items is selected.
type AppsDynamiteStorageSelectionInputSelectionItem struct {
	// Selected: If more than one item is selected for `RADIO_BUTTON` and
	// `DROPDOWN`, the first selected item is treated as selected and the
	// ones after are ignored.
	Selected bool `json:"selected,omitempty"`

	// Text: The text to be displayed.
	Text string `json:"text,omitempty"`

	// Value: The value associated with this item. The client should use
	// this as a form input value.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Selected") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Selected") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageSelectionInputSelectionItem) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageSelectionInputSelectionItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageSuggestions: A container wrapping elements
// necessary for showing suggestion items used in text input
// autocomplete.
type AppsDynamiteStorageSuggestions struct {
	// Items: A list of suggestions items which will be used in are used in
	// autocomplete.
	Items []*AppsDynamiteStorageSuggestionsSuggestionItem `json:"items,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Items") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageSuggestions) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageSuggestions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageSuggestionsSuggestionItem: A suggestion item. Only
// supports text for now.
type AppsDynamiteStorageSuggestionsSuggestionItem struct {
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Text") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Text") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageSuggestionsSuggestionItem) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageSuggestionsSuggestionItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageTextInput: A text input is a UI item where users
// can input text. A text input can also have an onChange action and
// suggestions.
type AppsDynamiteStorageTextInput struct {
	// AutoCompleteAction: The refresh function that returns suggestions
	// based on the user's input text. If the callback is not specified,
	// autocomplete is done in client side based on the initial suggestion
	// items.
	AutoCompleteAction *AppsDynamiteStorageAction `json:"autoCompleteAction,omitempty"`

	// HintText: The hint text.
	HintText string `json:"hintText,omitempty"`

	// InitialSuggestions: The initial suggestions made before any user
	// input.
	InitialSuggestions *AppsDynamiteStorageSuggestions `json:"initialSuggestions,omitempty"`

	// Label: At least one of label and hintText must be specified.
	Label string `json:"label,omitempty"`

	// Name: The name of the text input which is used in formInput.
	Name string `json:"name,omitempty"`

	// OnChangeAction: The onChange action, for example, invoke a function.
	OnChangeAction *AppsDynamiteStorageAction `json:"onChangeAction,omitempty"`

	// Type: The style of the text, for example, a single line or multiple
	// lines.
	//
	// Possible values:
	//   "SINGLE_LINE" - The text is put into a single line.
	//   "MULTIPLE_LINE" - The text is put into multiple lines.
	Type string `json:"type,omitempty"`

	// Value: The default value when there is no input from the user.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutoCompleteAction")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoCompleteAction") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageTextInput) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageTextInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageTextParagraph: A paragraph of text that supports
// formatting. See Text formatting
// (workspace/add-ons/concepts/widgets#text_formatting") for details.
type AppsDynamiteStorageTextParagraph struct {
	// Text: The text that's shown in the widget.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Text") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Text") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageTextParagraph) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageTextParagraph
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteStorageWidget: A widget is a UI element that presents
// texts, images, etc.
type AppsDynamiteStorageWidget struct {
	// ButtonList: A list of buttons. For example, the following JSON
	// creates two buttons. The first is a filled text button and the second
	// is an image button that opens a link: ``` "buttonList": { "buttons":
	// [ "button": { "text": "Edit", "Color": { "Red": 255 "Green": 255
	// "Blue": 255 } "disabled": true }, "button": { "icon": { "knownIcon":
	// "INVITE" "altText": "check calendar" }, "onClick": { "openLink": {
	// "url": "https://example.com/calendar" } } }, ] } ```
	ButtonList *AppsDynamiteStorageButtonList `json:"buttonList,omitempty"`

	// Columns: Displays a single row of columns with widgets stacked
	// vertically in each column. For example, the following JSON creates a
	// 2 column widget each containing a single item. ``` "columns": {
	// "wrapStyle": "WRAP", "columnItems": [ { "horizontalSizeStyle":
	// "FILL_AVAILABLE_SPACE", "horizontalAlignment": "CENTER",
	// "verticalAlignment" : "CENTER", "widgets": [ { "textParagraph": {
	// "text": "First column text paragraph", } } ] }, {
	// "horizontalSizeStyle": "FILL_AVAILABLE_SPACE", "horizontalAlignment":
	// "CENTER", "verticalAlignment" : "CENTER", "widgets": [ {
	// "textParagraph": { "text": "Second column text paragraph", } } ] }, ]
	// } } ```
	Columns *AppsDynamiteStorageColumns `json:"columns,omitempty"`

	// DateTimePicker: Displays a selection/input widget for date/time. For
	// example, the following JSON creates a date/time picker for an
	// appointment time: ``` "date_time_picker": { "name":
	// "appointment_time", "label": "Book your appointment at:", "type":
	// "DateTimePickerType.DATE_AND_TIME", "valueMsEpoch": "796435200000" }
	// ```
	DateTimePicker *AppsDynamiteStorageDateTimePicker `json:"dateTimePicker,omitempty"`

	// DecoratedText: Displays a decorated text item in this widget. For
	// example, the following JSON creates a decorated text widget showing
	// email address: ``` "decoratedText": { "icon": { "knownIcon": "EMAIL"
	// }, "topLabel": "Email Address", "content": "heba.salam@example.com",
	// "bottomLabel": "This is a new Email address!", "switchWidget": {
	// "name": "has_send_welcome_email_to_heba_salam", "selected": false,
	// "controlType": "ControlType.CHECKBOX" } } ```
	DecoratedText *AppsDynamiteStorageDecoratedText `json:"decoratedText,omitempty"`

	// Divider: Displays a divider. For example, the following JSON creates
	// a divider: ``` "divider": { } ```
	Divider *AppsDynamiteStorageDivider `json:"divider,omitempty"`

	// Grid: Displays a grid with a collection of items. For example, the
	// following JSON creates a 2 column grid with a single item: ```
	// "grid": { "title": "A fine collection of items", "numColumns": 2,
	// "borderStyle": { "type": "STROKE", "cornerRadius": 4.0 }, "items": [
	// "image": { "imageUri": "https://www.example.com/image.png",
	// "cropStyle": { "type": "SQUARE" }, "borderStyle": { "type": "STROKE"
	// } }, "title": "An item", "textAlignment": "CENTER" ], "onClick": {
	// "openLink": { "url":"https://www.example.com" } } } ```
	Grid *AppsDynamiteStorageGrid `json:"grid,omitempty"`

	// HorizontalAlignment: The horizontal alignment of this widget.
	//
	// Possible values:
	//   "HORIZONTAL_ALIGNMENT_UNSPECIFIED" - Unspecified alignment.
	//   "START" - Alignment to the start position.
	//   "CENTER" - Alignment to the center position.
	//   "END" - Alignment to the end position.
	HorizontalAlignment string `json:"horizontalAlignment,omitempty"`

	// Image: Displays an image in this widget. For example, the following
	// JSON creates an image with alternative text: ``` "image": {
	// "imageUrl": "https://example.com/heba_salam.png" "altText": "Avatar
	// for Heba Salam" } ```
	Image *AppsDynamiteStorageImage `json:"image,omitempty"`

	// SelectionInput: Displays a switch control in this widget. For
	// example, the following JSON creates a dropdown selection for size:
	// ``` "switchControl": { "name": "size", "label": "Size" "type":
	// "SelectionType.DROPDOWN", "items": [ { "text": "S", "value": "small",
	// "selected": false }, { "text": "M", "value": "medium", "selected":
	// true }, { "text": "L", "value": "large", "selected": false }, {
	// "text": "XL", "value": "extra_large", "selected": false } ] } ```
	SelectionInput *AppsDynamiteStorageSelectionInput `json:"selectionInput,omitempty"`

	// TextInput: Displays a text input in this widget. For example, the
	// following JSON creates a text input for mail address: ```
	// "textInput": { "name": "mailing_address", "label": "Mailing Address"
	// } ``` As another example, the following JSON creates a text input for
	// programming language with static suggestions: ``` "textInput": {
	// "name": "preferred_programing_language", "label": "Preferred
	// Language", "initialSuggestions": { "items": [ { "text": "C++" }, {
	// "text": "Java" }, { "text": "JavaScript" }, { "text": "Python" } ] }
	// } ```
	TextInput *AppsDynamiteStorageTextInput `json:"textInput,omitempty"`

	// TextParagraph: Displays a text paragraph in this widget. For example,
	// the following JSON creates a bolded text: ``` "textParagraph": {
	// "text": " *bold text*" } ```
	TextParagraph *AppsDynamiteStorageTextParagraph `json:"textParagraph,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ButtonList") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ButtonList") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteStorageWidget) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteStorageWidget
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteV1ApiCompatV1Action: Interactive objects inside a
// message. Documentation: - https://api.slack.com/docs/message-buttons
type AppsDynamiteV1ApiCompatV1Action struct {
	// Confirm: Confirmation dialog config.
	Confirm *AppsDynamiteV1ApiCompatV1ActionConfirm `json:"confirm,omitempty"`

	// Name: Unique identifier for this action.
	Name string `json:"name,omitempty"`

	// Style: Button style ("default", "primary", or "danger").
	Style string `json:"style,omitempty"`

	// Text: User-facing label for the action.
	Text string `json:"text,omitempty"`

	// Type: Action type - currently only "button".
	Type string `json:"type,omitempty"`

	// Value: Payload for this action. Will be sent to the action handler
	// along with name.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Confirm") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Confirm") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteV1ApiCompatV1Action) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteV1ApiCompatV1Action
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteV1ApiCompatV1ActionConfirm: Confirmation dialog config.
type AppsDynamiteV1ApiCompatV1ActionConfirm struct {
	// DismissText: "Cancel" button label.
	DismissText string `json:"dismiss_text,omitempty"`

	// OkText: "OK" button label.
	OkText string `json:"ok_text,omitempty"`

	// Text: Confirmation dialog body text.
	Text string `json:"text,omitempty"`

	// Title: Confirmation dialog title.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DismissText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DismissText") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteV1ApiCompatV1ActionConfirm) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteV1ApiCompatV1ActionConfirm
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteV1ApiCompatV1Attachment: Richly formatted attachments.
// Documentation: - https://api.slack.com/docs/message-attachments
type AppsDynamiteV1ApiCompatV1Attachment struct {
	// Actions: Array of actions (currently only buttons).
	Actions []*AppsDynamiteV1ApiCompatV1Action `json:"actions,omitempty"`

	// AttachmentType: Undocumented - used in interactive button examples.
	// The only valid value appears to be "default".
	AttachmentType string `json:"attachment_type,omitempty"`

	// AuthorIcon: Avatar URL for the user.
	AuthorIcon string `json:"author_icon,omitempty"`

	// AuthorLink: URL that the user name should link to.
	AuthorLink string `json:"author_link,omitempty"`

	// AuthorName: User name to display as the author of the message.
	AuthorName string `json:"author_name,omitempty"`

	// CallbackId: Unique identifier for the collection of buttons within
	// this attachment. Will be sent back to the action handler URL when a
	// button is clicked.
	CallbackId string `json:"callback_id,omitempty"`

	// Color: A color "bar" to display to the left of the attachment.
	Color string `json:"color,omitempty"`

	// Fallback: Fallback plain-text string for clients that don't support
	// attachments.
	Fallback string `json:"fallback,omitempty"`

	// Fields: Columns of text inside the attachment body.
	Fields []*AppsDynamiteV1ApiCompatV1Field `json:"fields,omitempty"`

	// Footer: A string displayed at the bottom of the attachment.
	Footer string `json:"footer,omitempty"`

	// FooterIcon: Avatar URL displayed to the left of the footer.
	FooterIcon string `json:"footer_icon,omitempty"`

	// ImageUrl: URL of an image to display in an image chip.
	ImageUrl string `json:"image_url,omitempty"`

	// MrkdwnIn: List of fields to apply formatting to.
	MrkdwnIn []string `json:"mrkdwn_in,omitempty"`

	// Pretext: A string to show above the attachment.
	Pretext string `json:"pretext,omitempty"`

	// Text: Main text.
	Text string `json:"text,omitempty"`

	// ThumbUrl: URL of a thumbnail image to display to the right of the
	// attachment body.
	ThumbUrl string `json:"thumb_url,omitempty"`

	// Title: Title string of this attachment.
	Title string `json:"title,omitempty"`

	// TitleLink: URL that the title string should link to.
	TitleLink string `json:"title_link,omitempty"`

	// Ts: UNIX timestamp of the attachment.
	Ts int64 `json:"ts,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Actions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Actions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteV1ApiCompatV1Attachment) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteV1ApiCompatV1Attachment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteV1ApiCompatV1Field: A column of text in an attachment.
// Documentation: - https://api.slack.com/docs/message-attachments
type AppsDynamiteV1ApiCompatV1Field struct {
	// Short: Whether the field can be shown side-by-side with another
	// field.
	Short bool `json:"short,omitempty"`

	// Title: The heading text, shown in bold.
	Title string `json:"title,omitempty"`

	// Value: The text value of the field.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Short") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Short") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteV1ApiCompatV1Field) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteV1ApiCompatV1Field
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsExtensionsMarkupCalendarClientActionMarkupAddAttachmentsActionMarkup struct {
	AddonAttachments []*AppsExtensionsMarkupCalendarClientActionMarkupAddAttachmentsActionMarkupAddonAttachment `json:"addonAttachments,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AddonAttachments") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddonAttachments") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsExtensionsMarkupCalendarClientActionMarkupAddAttachmentsActionMarkup) MarshalJSON() ([]byte, error) {
	type NoMethod AppsExtensionsMarkupCalendarClientActionMarkupAddAttachmentsActionMarkup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsExtensionsMarkupCalendarClientActionMarkupAddAttachmentsActionMarkupAddonAttachment struct {
	// IconUrl: Link to the resource's icon.
	IconUrl string `json:"iconUrl,omitempty"`

	// MimeType: MIME type of the content in resource_url.
	MimeType string `json:"mimeType,omitempty"`

	ResourceUrl string `json:"resourceUrl,omitempty"`

	// Title: Title of the attachment.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IconUrl") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IconUrl") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsExtensionsMarkupCalendarClientActionMarkupAddAttachmentsActionMarkupAddonAttachment) MarshalJSON() ([]byte, error) {
	type NoMethod AppsExtensionsMarkupCalendarClientActionMarkupAddAttachmentsActionMarkupAddonAttachment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsExtensionsMarkupCalendarClientActionMarkupConferenceDataMarkup:
// Markup that defines conference data associated to a Google Calendar
// event.
type AppsExtensionsMarkupCalendarClientActionMarkupConferenceDataMarkup struct {
	// ConferenceId: Unique identifier for this conference data. Maximum 512
	// characters long.
	ConferenceId string `json:"conferenceId,omitempty"`

	// ConferenceSolutionId: An identifier of the conferencing solution.
	// Must match a value from the deployment's
	// `calendar.conferenceSolution.id` field.
	ConferenceSolutionId string `json:"conferenceSolutionId,omitempty"`

	// EntryPoints: Entry points to the conference. Maximum 300 entry points
	// are allowed.
	EntryPoints []*AppsExtensionsMarkupCalendarClientActionMarkupConferenceDataMarkupEntryPointMarkup `json:"entryPoints,omitempty"`

	// Error: If set, it means an error occurred during conference creation.
	Error *AppsExtensionsMarkupCalendarClientActionMarkupConferenceDataMarkupError `json:"error,omitempty"`

	// Note: Additional notes (such as instructions from the administrator,
	// legal notices) to display to the user. Can contain HTML. Max length
	// 2048 characters.
	Note string `json:"note,omitempty"`

	// Parameters: Additional add-on parameters. Maximum 300 parameters are
	// allowed.
	Parameters []*AppsExtensionsMarkupCalendarClientActionMarkupConferenceDataMarkupParameter `json:"parameters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConferenceId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConferenceId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsExtensionsMarkupCalendarClientActionMarkupConferenceDataMarkup) MarshalJSON() ([]byte, error) {
	type NoMethod AppsExtensionsMarkupCalendarClientActionMarkupConferenceDataMarkup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsExtensionsMarkupCalendarClientActionMarkupConferenceDataMarkupEntr
// yPointMarkup: A way to join the conference.
type AppsExtensionsMarkupCalendarClientActionMarkupConferenceDataMarkupEntryPointMarkup struct {
	// AccessCode: An access code for accessing the conference. Maximum 128
	// characters long.
	AccessCode string `json:"accessCode,omitempty"`

	// Features: Features of the entry point, such as being toll or
	// toll-free. One entry point can have multiple features.
	//
	// Possible values:
	//   "UNKNOWN_FEATURE" - Unknown feature.
	//   "TOLL" - Applies to `PHONE` entry point. A call to a toll number is
	// charged to the calling party. A number can't be toll and toll-free at
	// the same time.
	//   "TOLL_FREE" - Applies to `PHONE` entry point. For the calling
	// party, a call to a toll-free number is free of charge. A number can't
	// be toll and toll-free at the same time.
	Features []string `json:"features,omitempty"`

	// Label: The label of the entry point to display to the user. Maximum
	// 512 characters long.
	Label string `json:"label,omitempty"`

	// MeetingCode: A meeting code for accessing the conference. Maximum 128
	// characters long.
	MeetingCode string `json:"meetingCode,omitempty"`

	// Passcode: A passcode for accessing the conference. Maximum 128
	// characters long.
	Passcode string `json:"passcode,omitempty"`

	// Password: A password for accessing the conference. Maximum 128
	// characters long.
	Password string `json:"password,omitempty"`

	// Pin: A PIN for accessing the conference. Maximum 128 characters long.
	Pin string `json:"pin,omitempty"`

	// RegionCode: The CLDR/ISO 3166 region code for the country associated
	// with this entry point. Applicable only to `Type.PHONE`.
	RegionCode string `json:"regionCode,omitempty"`

	// Type: The type of the entry point. Required.
	//
	// Possible values:
	//   "UNKNOWN" - Unknown conference type.
	//   "VIDEO" - A video conference.
	//   "PHONE" - A phone conference.
	//   "MORE" - Used to provide a link to further conference joining
	// information.
	//   "SIP" - A conference using [Session Initiation
	// Protocol](https://en.wikipedia.org/wiki/Session_Initiation_Protocol)
	Type string `json:"type,omitempty"`

	// Uri: A URI for joining the conference. Supports tel: and http(s): and
	// should be at most 1300 characters long. Required.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessCode") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsExtensionsMarkupCalendarClientActionMarkupConferenceDataMarkupEntryPointMarkup) MarshalJSON() ([]byte, error) {
	type NoMethod AppsExtensionsMarkupCalendarClientActionMarkupConferenceDataMarkupEntryPointMarkup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsExtensionsMarkupCalendarClientActionMarkupConferenceDataMarkupErro
// r: Represents an error that occurred during conference creation.
type AppsExtensionsMarkupCalendarClientActionMarkupConferenceDataMarkupError struct {
	// AuthenticationUrl: If the error type is `AUTHENTICATION`, the add-on
	// can provide a URL allowing users to log in. Maximum 1300 characters
	// long.
	AuthenticationUrl string `json:"authenticationUrl,omitempty"`

	// Type: The type of error. Required.
	//
	// Possible values:
	//   "UNKNOWN" - Unknown error.
	//   "AUTHENTICATION" - An authentication error.
	//   "TEMPORARY" - A temporary error.
	//   "PERMANENT" - A permanent error.
	//   "PERMISSION_DENIED" - The user isn't allowed to perform some action
	// in the third-party conferencing system.
	//   "CONFERENCE_SOLUTION_FORBIDDEN" - The user isn't allowed to use the
	// selected conference solution (but might be allowed to use other
	// solutions offered by the add-on).
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AuthenticationUrl")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuthenticationUrl") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsExtensionsMarkupCalendarClientActionMarkupConferenceDataMarkupError) MarshalJSON() ([]byte, error) {
	type NoMethod AppsExtensionsMarkupCalendarClientActionMarkupConferenceDataMarkupError
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsExtensionsMarkupCalendarClientActionMarkupConferenceDataMarkupPara
// meter: Solution-specific parameters that are persisted with the event
// data and, if an update or delete is needed, are passed to the add-on.
// For example: `[{key: 'sessionKey', value: '123'}, {key: 'meetingId',
// value: '456'}]`
type AppsExtensionsMarkupCalendarClientActionMarkupConferenceDataMarkupParameter struct {
	// Key: The key of the parameter. Maximum 50 characters long. Required.
	Key string `json:"key,omitempty"`

	// Value: The value of the parameter. Maximum 1024 characters long.
	// Required.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsExtensionsMarkupCalendarClientActionMarkupConferenceDataMarkupParameter) MarshalJSON() ([]byte, error) {
	type NoMethod AppsExtensionsMarkupCalendarClientActionMarkupConferenceDataMarkupParameter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsExtensionsMarkupCalendarClientActionMarkupEditAttendeesActionMarkup struct {
	// AddAttendeeEmails: A list of attendees to add to the Google Calendar
	// event.
	AddAttendeeEmails []string `json:"addAttendeeEmails,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AddAttendeeEmails")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddAttendeeEmails") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsExtensionsMarkupCalendarClientActionMarkupEditAttendeesActionMarkup) MarshalJSON() ([]byte, error) {
	type NoMethod AppsExtensionsMarkupCalendarClientActionMarkupEditAttendeesActionMarkup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsExtensionsMarkupCalendarClientActionMarkupEditConferenceDataActionMarkup struct {
	// ConferenceData: The conference data to add to the Google Calendar
	// event.
	ConferenceData *AppsExtensionsMarkupCalendarClientActionMarkupConferenceDataMarkup `json:"conferenceData,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConferenceData") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConferenceData") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsExtensionsMarkupCalendarClientActionMarkupEditConferenceDataActionMarkup) MarshalJSON() ([]byte, error) {
	type NoMethod AppsExtensionsMarkupCalendarClientActionMarkupEditConferenceDataActionMarkup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Attachment: Attachments that follow the message text.
type Attachment struct {
	// AddOnData: Revised version of Gmail AddOn attachment approved by API
	// design review.
	AddOnData *GoogleChatV1ContextualAddOnMarkup `json:"addOnData,omitempty"`

	// AppId: The userId for the bot/app that created this data, to be used
	// for attribution of attachments when the attachment was not created by
	// the message sender.
	AppId *UserId `json:"appId,omitempty"`

	// AttachmentId: To identify an attachment within repeated in a message
	AttachmentId string `json:"attachmentId,omitempty"`

	// CardAddOnData: Card AddOn attachment with the possibility for
	// specifying editable widgets.
	CardAddOnData *AppsDynamiteStorageCard `json:"cardAddOnData,omitempty"`

	// DeprecatedAddOnData: Deprecated version of Gmail AddOn attachment.
	DeprecatedAddOnData *ContextualAddOnMarkup `json:"deprecatedAddOnData,omitempty"`

	// SlackData: Slack attachment.
	SlackData *AppsDynamiteV1ApiCompatV1Attachment `json:"slackData,omitempty"`

	// SlackDataImageUrlHeight: The height of image url as fetched by fife.
	// This field is asynchronously filled.
	SlackDataImageUrlHeight int64 `json:"slackDataImageUrlHeight,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AddOnData") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddOnData") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Attachment) MarshalJSON() ([]byte, error) {
	type NoMethod Attachment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Attribute: An Attribute is a piece of data attached an Item.
// Attributes are opaque to the Starbox and have no effect on, nor are
// they effected by, message storage, indexing, or search.
type Attribute struct {
	// Name: The name of the attribute. Required - If a write is attempted
	// with an empty string, the server will return an error.
	Name string `json:"name,omitempty"`

	Value *CaribouAttributeValue `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Attribute) MarshalJSON() ([]byte, error) {
	type NoMethod Attribute
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AttributeRemoved: An attribute was deleted from some (subset of the)
// messages in this thread.
type AttributeRemoved struct {
	AttributeId string `json:"attributeId,omitempty"`

	MessageKeys []*MultiKey `json:"messageKeys,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AttributeId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttributeId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AttributeRemoved) MarshalJSON() ([]byte, error) {
	type NoMethod AttributeRemoved
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AttributeSet: An attribute was added to some (subset of the) messages
// in this thread.
type AttributeSet struct {
	AttributeId string `json:"attributeId,omitempty"`

	// AttributeValue: The serialized attribute_value as persisted in the
	// storage layer. The application is responsible for deserializing it to
	// an Attribute.Value if appropriate.
	AttributeValue string `json:"attributeValue,omitempty"`

	MessageKeys []*MultiKey `json:"messageKeys,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AttributeId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttributeId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AttributeSet) MarshalJSON() ([]byte, error) {
	type NoMethod AttributeSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type Attributes struct {
	Attribute []*Attribute `json:"attribute,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Attribute") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attribute") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Attributes) MarshalJSON() ([]byte, error) {
	type NoMethod Attributes
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AuditLoggingSettings: Represents the settings for Cloud audit logging
type AuditLoggingSettings struct {
	// LogAdminReadActions: Indicates whether audit logging is on/off for
	// admin activity read APIs i.e. Get/List DataSources, Get/List
	// SearchApplications etc.
	LogAdminReadActions bool `json:"logAdminReadActions,omitempty"`

	// LogDataReadActions: Indicates whether audit logging is on/off for
	// data access read APIs i.e. ListItems, GetItem etc.
	LogDataReadActions bool `json:"logDataReadActions,omitempty"`

	// LogDataWriteActions: Indicates whether audit logging is on/off for
	// data access write APIs i.e. IndexItem etc.
	LogDataWriteActions bool `json:"logDataWriteActions,omitempty"`

	// Project: The resource name of the GCP Project to store audit logs.
	// Cloud audit logging will be enabled after project_name has been
	// updated through CustomerService. Format: projects/{project_id}
	Project string `json:"project,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LogAdminReadActions")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LogAdminReadActions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AuditLoggingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AuditLoggingSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AuthorizedItemId: A combination of an identifier for a Drive resource
// (e.g. file, folder, or drive) and any secrets needed to access it.
// The secrets should never be logged, and this proto annotates those
// secret fields to ensure that they are not. Clients are encouraged to
// use this proto rather than defining their own, to ensure that secrets
// are correctly annotated.
type AuthorizedItemId struct {
	// Id: Serialized ID of the Drive resource
	Id string `json:"id,omitempty"`

	// ResourceKey: Resource key of the Drive item. This field should be
	// unset if, depending on the context, the item does not have a resource
	// key, or if none was specified. This must never be logged.
	ResourceKey string `json:"resourceKey,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AuthorizedItemId) MarshalJSON() ([]byte, error) {
	type NoMethod AuthorizedItemId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AutoComplete struct {
	Items []*AutoCompleteItem `json:"items,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Items") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoComplete) MarshalJSON() ([]byte, error) {
	type NoMethod AutoComplete
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AutoCompleteItem struct {
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Text") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Text") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoCompleteItem) MarshalJSON() ([]byte, error) {
	type NoMethod AutoCompleteItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BabelMessageProps: Container for Babel (Hangouts Classic) only
// message properties. The properties here will not be consumed by
// Dynamite clients. They are relevant only for Hangouts Classic.
type BabelMessageProps struct {
	// ClientGeneratedId: Babel clients locally generate this ID to dedupe
	// against the async fanout.
	ClientGeneratedId int64 `json:"clientGeneratedId,omitempty,string"`

	// ContentExtension: Stores additional Babel-specific properties (such
	// as event metadata).
	ContentExtension *ChatContentExtension `json:"contentExtension,omitempty"`

	// DeliveryMedium: Stores the delivery source of messages (such as phone
	// number for SMS).
	DeliveryMedium *DeliveryMedium `json:"deliveryMedium,omitempty"`

	// EventId: Primary identifier used by Hangouts Classic for its events
	// (messages).
	EventId string `json:"eventId,omitempty"`

	// MessageContent: Stores message segments (text content) and
	// attachments (media URLs).
	MessageContent *ChatConserverMessageContent `json:"messageContent,omitempty"`

	// WasUpdatedByBackfill: Whether or not these message properties were
	// backfilled by go/dinnertrain.
	WasUpdatedByBackfill bool `json:"wasUpdatedByBackfill,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ClientGeneratedId")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClientGeneratedId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BabelMessageProps) MarshalJSON() ([]byte, error) {
	type NoMethod BabelMessageProps
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BabelPlaceholderMetadata: Annotation metadata for Babel-only items
// that signals which type of placeholder message should be displayed in
// Babel clients.
type BabelPlaceholderMetadata struct {
	DeleteMetadata *DeleteMetadata `json:"deleteMetadata,omitempty"`

	EditMetadata *EditMetadata `json:"editMetadata,omitempty"`

	HangoutVideoMetadata *HangoutVideoEventMetadata `json:"hangoutVideoMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeleteMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeleteMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BabelPlaceholderMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod BabelPlaceholderMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BooleanOperatorOptions: Used to provide a search operator for boolean
// properties. This is optional. Search operators let users restrict the
// query to specific fields relevant to the type of item being searched.
type BooleanOperatorOptions struct {
	// OperatorName: Indicates the operator name required in the query in
	// order to isolate the boolean property. For example, if operatorName
	// is *closed* and the property's name is *isClosed*, then queries like
	// *closed:<value>* show results only where the value of the property
	// named *isClosed* matches *<value>*. By contrast, a search that uses
	// the same *<value>* without an operator returns all items where
	// *<value>* matches the value of any String properties or text within
	// the content field for the item. The operator name can only contain
	// lowercase letters (a-z). The maximum length is 32 characters.
	OperatorName string `json:"operatorName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OperatorName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OperatorName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BooleanOperatorOptions) MarshalJSON() ([]byte, error) {
	type NoMethod BooleanOperatorOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BooleanPropertyOptions: The options for boolean properties.
type BooleanPropertyOptions struct {
	// OperatorOptions: If set, describes how the boolean should be used as
	// a search operator.
	OperatorOptions *BooleanOperatorOptions `json:"operatorOptions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OperatorOptions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OperatorOptions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BooleanPropertyOptions) MarshalJSON() ([]byte, error) {
	type NoMethod BooleanPropertyOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BorderStyle: Represents a complete border style that can be applied
// to widgets.
type BorderStyle struct {
	// CornerRadius: The corner radius for the border.
	CornerRadius int64 `json:"cornerRadius,omitempty"`

	// StrokeColor: The colors to use when the type is STROKE.
	StrokeColor string `json:"strokeColor,omitempty"`

	// Type: The border type.
	//
	// Possible values:
	//   "BORDER_TYPE_NOT_SET" - No value specified.
	//   "NO_BORDER" - No border.
	//   "STROKE" - Outline.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CornerRadius") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CornerRadius") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BorderStyle) MarshalJSON() ([]byte, error) {
	type NoMethod BorderStyle
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BotInfo: Bot-specific profile information.
type BotInfo struct {
	// Possible values:
	//   "UNSPECIFIED_STATUS"
	//   "ALLOWED"
	//   "ALL_APPS_DISABLED_BY_ADMIN" - For both ALL_APPS_DISABLED_BY_ADMIN
	// and APP_NOT_ALLOWLISTED_BY_ADMIN, the app should still be visible in
	// the catalog, but usage of the app will be disabled. Indicates that
	// all apps have been disabled by the dasher admin.
	//   "APP_NOT_ALLOWLISTED_BY_ADMIN" - Indicates that the customer is
	// using allowlisting, but that the bot is not allowlisted.
	AppAllowlistStatus string `json:"appAllowlistStatus,omitempty"`

	// AppId: Identifier of the application associated with the bot.
	AppId *AppId `json:"appId,omitempty"`

	// BotAvatarUrl: URL for the avatar picture of the User in dynamite.
	// This field should be populated if the request is
	// FetchBotCategories/ListBotCatalogEntries
	BotAvatarUrl string `json:"botAvatarUrl,omitempty"`

	// BotName: Non-unique, user-defined display name of the Bot. This field
	// should be populated if the request is
	// FetchBotCategories/ListBotCatalogEntries.
	BotName string `json:"botName,omitempty"`

	// Description: Short description for the bot.
	Description string `json:"description,omitempty"`

	// DeveloperName: Name of bot developer.
	DeveloperName string `json:"developerName,omitempty"`

	// MarketPlaceBannerUrl: URL for the banner image in GSuite Market
	// Place. The banner will be 220x140.
	MarketPlaceBannerUrl string `json:"marketPlaceBannerUrl,omitempty"`

	// Status: Indicates whether bot is enabled/disabled.
	//
	// Possible values:
	//   "UNKNOWN_STATUS"
	//   "ENABLED"
	//   "DISABLED_BY_DEVELOPER" - Bot has been disabled by the bot
	// developer. No one can @mention or interact with the bot.
	Status string `json:"status,omitempty"`

	// SupportHomeScreen: If the app supports a home screen.
	SupportHomeScreen bool `json:"supportHomeScreen,omitempty"`

	// SupportUrls: Urls with additional information related to the bot.
	// This field should always be set even if all the fields within it are
	// empty, so that it is convenient for clients to work with this field
	// in javascript.
	SupportUrls *SupportUrls `json:"supportUrls,omitempty"`

	// SupportedUses: The supported uses are limited according to the user
	// that made the request. If the user does not have permission to use
	// the bot, the list will be empty. This could occur for non whitelisted
	// bots in the catalog.
	//
	// Possible values:
	//   "UNKNOWN"
	//   "CAN_ADD_TO_DM"
	//   "CAN_ADD_TO_ROOM"
	//   "CAN_ADD_TO_HUMAN_DM"
	SupportedUses []string `json:"supportedUses,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AppAllowlistStatus")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppAllowlistStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BotInfo) MarshalJSON() ([]byte, error) {
	type NoMethod BotInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BotResponse: Information about a bot response, branched from
// shared/bot_response.proto without frontend User proto as we never
// store it.
type BotResponse struct {
	BotId *UserId `json:"botId,omitempty"`

	// Possible values:
	//   "UNKNOWN_SETUP_TYPE"
	//   "CONFIGURATION" - Bot requires configuration.
	//   "AUTHENTICATION" - Bot requires authentication.
	RequiredAction string `json:"requiredAction,omitempty"`

	// Possible values:
	//   "UNKNOWN_RESPONSE_TYPE"
	//   "ERROR" - Bot fails to respond because of deadline_exceeded or
	// failing to parse bot message.
	//   "SETUP_REQUIRED" - Bot requires auth or config
	//   "DISABLED_BY_ADMIN" - Bot fails to respond because it is disabled
	// by domain admin
	//   "DISABLED_BY_DEVELOPER" - Bot fails to respond because it is
	// disabled by the bot's developer
	//   "PRIVATE" - Message to bot should be permanently private.
	//   "APP_SUGGESTION" - A suggestion to promote an app.
	ResponseType string `json:"responseType,omitempty"`

	// SetupUrl: URL for setting up bot.
	SetupUrl string `json:"setupUrl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BotId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BotId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BotResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BotResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BroadcastAccess: Broadcast access information of a meeting space.
type BroadcastAccess struct {
	// AccessPolicy: The policy that controls the broadcast's viewer access.
	//
	// Possible values:
	//   "BROADCASTING_ACCESS_POLICY_UNSPECIFIED" - Used only when broadcast
	// is not enabled, or an unknown enum value is used.
	//   "ORGANIZATION" - Only authenticated Google accounts belonging to
	// the same organization as the meeting organizer can access the
	// broadcast.
	//   "PUBLIC" - Anyone with the broadcast view URL can access the
	// broadcast.
	AccessPolicy string `json:"accessPolicy,omitempty"`

	// ViewUrl: A URL that can be used to access the broadcast of the
	// meeting. This field will be empty if broadcast is not enabled. It
	// will be populated by the backend. Clients cannot modify the value.
	ViewUrl string `json:"viewUrl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessPolicy") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessPolicy") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BroadcastAccess) MarshalJSON() ([]byte, error) {
	type NoMethod BroadcastAccess
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BroadcastSessionInfo: Information about a broadcast session.
type BroadcastSessionInfo struct {
	// BroadcastSessionId: A unique server-generated ID for the broadcast
	// session.
	BroadcastSessionId string `json:"broadcastSessionId,omitempty"`

	// BroadcastStats: Output only. Current broadcast session's statistics.
	BroadcastStats *BroadcastStats `json:"broadcastStats,omitempty"`

	// IngestionId: Input only. Deprecated field, should not be used.
	IngestionId string `json:"ingestionId,omitempty"`

	// SessionStateInfo: Broadcast session's state information.
	SessionStateInfo *SessionStateInfo `json:"sessionStateInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BroadcastSessionId")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BroadcastSessionId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BroadcastSessionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod BroadcastSessionInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BroadcastStats: Statistics of the broadcast session.
type BroadcastStats struct {
	// EstimatedViewerCount: Estimated concurrent viewer count.
	EstimatedViewerCount int64 `json:"estimatedViewerCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "EstimatedViewerCount") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EstimatedViewerCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BroadcastStats) MarshalJSON() ([]byte, error) {
	type NoMethod BroadcastStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type Button struct {
	ImageButton *ImageButton `json:"imageButton,omitempty"`

	TextButton *TextButton `json:"textButton,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ImageButton") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ImageButton") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Button) MarshalJSON() ([]byte, error) {
	type NoMethod Button
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CalendarClientActionMarkup struct {
	// AddAttachmentsActionMarkup: An action that adds attachments to the
	// Google Calendar event.
	AddAttachmentsActionMarkup *AppsExtensionsMarkupCalendarClientActionMarkupAddAttachmentsActionMarkup `json:"addAttachmentsActionMarkup,omitempty"`

	// EditAttendeesActionMarkup: An action that adds attendees to the
	// Google Calendar event.
	EditAttendeesActionMarkup *AppsExtensionsMarkupCalendarClientActionMarkupEditAttendeesActionMarkup `json:"editAttendeesActionMarkup,omitempty"`

	// EditConferenceDataActionMarkup: An action that adds conference data
	// to the Google Calendar event.
	EditConferenceDataActionMarkup *AppsExtensionsMarkupCalendarClientActionMarkupEditConferenceDataActionMarkup `json:"editConferenceDataActionMarkup,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AddAttachmentsActionMarkup") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AddAttachmentsActionMarkup") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CalendarClientActionMarkup) MarshalJSON() ([]byte, error) {
	type NoMethod CalendarClientActionMarkup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CallInfo: Contains information regarding an ongoing conference (aka
// call) for a meeting space.
type CallInfo struct {
	// AbuseReportingConfig: Abuse reporting configuration for the ongoing
	// conference.
	AbuseReportingConfig *AbuseReportingConfig `json:"abuseReportingConfig,omitempty"`

	// ArtifactOwner: Output only. Display name of the owner of artifacts
	// generated in this conference. The expected use of this in clients is
	// to present info like "This recording will be sent to John Doe's
	// Drive". This field can be empty if preferred display name
	// determination fails for any reason.
	ArtifactOwner *UserDisplayInfo `json:"artifactOwner,omitempty"`

	// AttachedDocuments: Output only. Documents attached to an ongoing
	// conference.
	AttachedDocuments []*DocumentInfo `json:"attachedDocuments,omitempty"`

	// AvailableAccessTypes: List of available access types of the
	// conference.
	//
	// Possible values:
	//   "ACCESS_TYPE_UNSPECIFIED" - Default value. This value is unused.
	//   "ACCESS_TYPE_OPEN" - Anyone with meeting join information (url,
	// phone access...) can join, no knocking required. (Subject to
	// organization policies)
	//   "ACCESS_TYPE_TRUSTED" - Members of the Host's organization, invited
	// external users, and dial-in users can join without knocking, everyone
	// else must knock. (Subject to organization policies)
	//   "ACCESS_TYPE_RESTRICTED" - Only participants invited by a host can
	// automatically join, everyone else must knock and be admitted.
	// (Subject to organization policies) Participants cannot dial out from
	// the meeting. And only hosts can accept knocks.
	AvailableAccessTypes []string `json:"availableAccessTypes,omitempty"`

	// AvailableReactions: Output only. The set of reactions that clients
	// are allowed to send and can expect to receive. Note that a device in
	// the conference should have the MAY_SEND_REACTIONS privilege to be
	// able to send reactions.
	AvailableReactions []*ReactionInfo `json:"availableReactions,omitempty"`

	// BroadcastSessionInfo: Information about active broadcast session in
	// the ongoing conference.
	BroadcastSessionInfo *BroadcastSessionInfo `json:"broadcastSessionInfo,omitempty"`

	// CalendarEventId: Output only. The calendar event ID of a Google
	// Calendar event that the meeting space is associated with. If the
	// meeting space is not associated with an event in Google Calendar,
	// this field is empty. For recurring events, it refers to the recurring
	// instance associated with the current call, as determined by the
	// server.
	CalendarEventId string `json:"calendarEventId,omitempty"`

	// CoActivity: The current co-activity session, or unset if there is
	// none in progress. A co-activity session can be initiated by devices
	// in JOINED state . Initiator of the co-activity is expected to
	// populate this field to start the session. Once clients detect that
	// the co-activity has finished, any JOINED device can clear this field
	// to end the co-activity session. In the case of switching activities,
	// the initiator of the new activity merely needs to override this with
	// the new co-activity data, and all connected clients are expected to
	// handle the transition gracefully.
	CoActivity *CoActivity `json:"coActivity,omitempty"`

	// Collaboration: The current collaboration session, or unset if no
	// collaboration is in progress.
	Collaboration *Collaboration `json:"collaboration,omitempty"`

	// CseInfo: CSE information for the ongoing conference.
	CseInfo *CseInfo `json:"cseInfo,omitempty"`

	// MaxJoinedDevices: Output only. The maximum number of devices that may
	// be in the joined state simultaneously in this conference. This can be
	// used by clients to guess whether it will be possible to join, but the
	// only way to know is to try to join. It can also be used to inform
	// users about the limit that is in effect. This limit is normally set
	// when the conference is created and not changed during the lifetime of
	// the conference. But there are some cases where it may change, so
	// clients should be aware that the information may be stale.
	MaxJoinedDevices int64 `json:"maxJoinedDevices,omitempty"`

	// OrganizationName: Output only. The name or description of the
	// organization or domain that the organizer belongs to. The expected
	// use of this in clients is to present messages like "John Doe (outside
	// of Google.com) is trying to join this call", where "Google.com" is
	// the organization name. The field will be empty if the organization
	// name could not be determined, possibly because of a backend error.
	OrganizationName string `json:"organizationName,omitempty"`

	// PaygateInfo: Paygate information to clients.
	PaygateInfo *PaygateInfo `json:"paygateInfo,omitempty"`

	// Presenter: The current presenter in the call, or unset if there is no
	// current presenter. Clients can set this to change the presenter.
	Presenter *Presenter `json:"presenter,omitempty"`

	// RecordingInfo: Deprecated, use RecordingSessionInfo instead. Info
	// about recording for this conference. This will always be set in
	// server responses, with a valid recording status. This is superseded
	// by streaming_sessions field, which contains the same information
	// about this recording as well as additional information about other
	// application type at the same time. This will be deprecated and
	// removed at some point.
	RecordingInfo *RecordingInfo `json:"recordingInfo,omitempty"`

	// RecordingSessionInfo: Information about active recording session in
	// the ongoing conference.
	RecordingSessionInfo *RecordingSessionInfo `json:"recordingSessionInfo,omitempty"`

	// Settings: Settings of the ongoing conference.
	Settings *CallSettings `json:"settings,omitempty"`

	// StreamingSessions: Output only. Info about streaming sessions
	// (recording or broadcast) for this conference. This should contain all
	// active sessions. Currently, it's guaranteed to have at most one
	// recording and at most one broadcast (at most two sessions in total).
	// For each application type (recording or broadcast), latest inactive
	// session is included if there's no active one.
	StreamingSessions []*StreamingSessionInfo `json:"streamingSessions,omitempty"`

	// TranscriptionSessionInfo: Information about active transcription
	// session in the ongoing conference.
	TranscriptionSessionInfo *TranscriptionSessionInfo `json:"transcriptionSessionInfo,omitempty"`

	// ViewerCount: The number of devices viewing the conference -
	// MeetingDevices that are in VIEWER role and JOINED state in the
	// conference.
	ViewerCount int64 `json:"viewerCount,omitempty"`

	// YouTubeBroadcastSessionInfos: Information about active YouTube
	// broadcast sessions in the ongoing conference.
	YouTubeBroadcastSessionInfos []*YouTubeBroadcastSessionInfo `json:"youTubeBroadcastSessionInfos,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AbuseReportingConfig") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AbuseReportingConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CallInfo) MarshalJSON() ([]byte, error) {
	type NoMethod CallInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CallSettings: Effective settings of the ongoing conference.
type CallSettings struct {
	// AccessLock: Indicates whether the access lock is currently on or off.
	AccessLock bool `json:"accessLock,omitempty"`

	// AccessType: The current access type of the conference.
	//
	// Possible values:
	//   "ACCESS_TYPE_UNSPECIFIED" - Default value. This value is unused.
	//   "ACCESS_TYPE_OPEN" - Anyone with meeting join information (url,
	// phone access...) can join, no knocking required. (Subject to
	// organization policies)
	//   "ACCESS_TYPE_TRUSTED" - Members of the Host's organization, invited
	// external users, and dial-in users can join without knocking, everyone
	// else must knock. (Subject to organization policies)
	//   "ACCESS_TYPE_RESTRICTED" - Only participants invited by a host can
	// automatically join, everyone else must knock and be admitted.
	// (Subject to organization policies) Participants cannot dial out from
	// the meeting. And only hosts can accept knocks.
	AccessType string `json:"accessType,omitempty"`

	// AllowJoiningBeforeHost: Whether users can join this conference before
	// a host (Host or Cohost).
	AllowJoiningBeforeHost bool `json:"allowJoiningBeforeHost,omitempty"`

	// AttendanceReportEnabled: Indicates whether the attendance report is
	// currently enabled or disabled.
	AttendanceReportEnabled bool `json:"attendanceReportEnabled,omitempty"`

	// AudioLock: Indicates whether the audio lock is currently on or off.
	AudioLock bool `json:"audioLock,omitempty"`

	// ChatLock: Indicates whether the chat lock is currently on or off.
	ChatLock bool `json:"chatLock,omitempty"`

	// CseEnabled: Whether Client-side Encryption is enabled for this
	// conference.
	CseEnabled bool `json:"cseEnabled,omitempty"`

	// ModerationEnabled: Indicates whether moderation is currently on or
	// off.
	ModerationEnabled bool `json:"moderationEnabled,omitempty"`

	// PresentLock: Indicates whether the present lock is currently on or
	// off.
	PresentLock bool `json:"presentLock,omitempty"`

	// ReactionsLock: Indicates whether the reactions lock is currently on
	// or off.
	ReactionsLock bool `json:"reactionsLock,omitempty"`

	// VideoLock: Indicates whether the video lock is currently on or off.
	VideoLock bool `json:"videoLock,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessLock") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessLock") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CallSettings) MarshalJSON() ([]byte, error) {
	type NoMethod CallSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CapTokenHolderProto: Represents a principal which possesses a
// particular secret string whose cryptographic hash is specified here.
// CapTokens ("Capability Tokens") are used in ACLProto. It's expected
// that ACLs with CapTokenHolders will strongly enforce them by
// Keystore-wrapping crypto keys for the corresponding CapTokens.
type CapTokenHolderProto struct {
	// TokenHmacSha1Prefix: The hash of the corresponding capability token.
	// The value is defined to be identical to the one in acl.proto's
	// CapTokenMetadata: 10-byte prefix of HMAC-SHA1 of the token. The HMAC
	// key is the following fixed (non-secret) 512-bit value: 79b1c8f4
	// 82baf523 b8a9ab4a e960f438 c45be041 11f1f222 e8a3f64d aeb05e3d
	// c3576acc ec649194 aede422c 4e48e0d1 ff21234a a6ed6b49 a7fa592e
	// efd7bba3
	TokenHmacSha1Prefix string `json:"tokenHmacSha1Prefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TokenHmacSha1Prefix")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TokenHmacSha1Prefix") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CapTokenHolderProto) MarshalJSON() ([]byte, error) {
	type NoMethod CapTokenHolderProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type Card struct {
	CardActions []*CardAction `json:"cardActions,omitempty"`

	// Possible values:
	//   "DISPLAY_STYLE_UNSPECIFIED"
	//   "PEEK"
	//   "REPLACE"
	DisplayStyle string `json:"displayStyle,omitempty"`

	FixedFooter *FixedFooter `json:"fixedFooter,omitempty"`

	Header *CardHeader `json:"header,omitempty"`

	// Name: Name of the card used in CardNavigation.pop_to_card_name.
	Name string `json:"name,omitempty"`

	// PeekCardHeader: When displaying contextual content, the peek card
	// header acts as a placeholder so that the user can navigate forward
	// between the homepage cards and the contextual cards.
	PeekCardHeader *CardHeader `json:"peekCardHeader,omitempty"`

	Sections []*Section `json:"sections,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CardActions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CardActions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Card) MarshalJSON() ([]byte, error) {
	type NoMethod Card
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CardAction: When an AddOn Card is shown in detailed view, a card
// action is the action associated with the card. For an invoice card, a
// typical action would be: delete invoice, email invoice or open the
// invoice in browser.
type CardAction struct {
	// ActionLabel: The label used to be displayed in the action menu item.
	ActionLabel string `json:"actionLabel,omitempty"`

	OnClick *OnClick `json:"onClick,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ActionLabel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActionLabel") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CardAction) MarshalJSON() ([]byte, error) {
	type NoMethod CardAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CardCapabilityMetadata struct {
	// RequiredCapabilities: NEXT TAG : 2
	//
	// Possible values:
	//   "UNKNOWN"
	//   "SUPPORTS_BASE_CARDS" - NEXT TAG : 2
	RequiredCapabilities []string `json:"requiredCapabilities,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "RequiredCapabilities") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RequiredCapabilities") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CardCapabilityMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod CardCapabilityMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CardHeader struct {
	// ImageAltText: The alternative text of this image which will be used
	// for accessibility.
	ImageAltText string `json:"imageAltText,omitempty"`

	// Possible values:
	//   "CROP_TYPE_NOT_SET" - No value specified.
	//   "SQUARE" - Applies a square crop.
	//   "CIRCLE" - Applies a circular crop.
	//   "RECTANGLE_CUSTOM" - Applies a rectangular crop with a custom
	// aspect ratio.
	//   "RECTANGLE_4_3" - Applies a rectangular crop with a 4:3 aspect
	// ratio.
	ImageStyle string `json:"imageStyle,omitempty"`

	ImageUrl string `json:"imageUrl,omitempty"`

	Subtitle string `json:"subtitle,omitempty"`

	// Title: The title must be specified. The header has a fixed height: if
	// both a title and subtitle is specified, each will take up 1 line. If
	// only the title is specified, it will take up both lines. The header
	// is rendered in collapsed and detailed view.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ImageAltText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ImageAltText") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CardHeader) MarshalJSON() ([]byte, error) {
	type NoMethod CardHeader
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CaribouAttributeValue struct {
	// BooleanValue: Tags 1 through 15 are reserved for the most commonly
	// used fields.
	BooleanValue bool `json:"booleanValue,omitempty"`

	IntValue int64 `json:"intValue,omitempty"`

	LongValue int64 `json:"longValue,omitempty,string"`

	// RawByteValue: Generally, applications should avoid storing raw bytes
	// and instead store structured data as protocol buffer extensions. This
	// both reduces the amount of ad-hoc attribute parsing code as well as
	// eliminates an intermediate copy of the data when deserializing the
	// value. The rawByteValue field is mainly provided for compatibility
	// with attributes stored before the introduction of the
	// Attribute.Value.
	RawByteValue string `json:"rawByteValue,omitempty"`

	StringValue string `json:"stringValue,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BooleanValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BooleanValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CaribouAttributeValue) MarshalJSON() ([]byte, error) {
	type NoMethod CaribouAttributeValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ChatClientActionMarkup: Actions handled by Chat Clients.
type ChatClientActionMarkup struct {
}

// ChatConserverDynamitePlaceholderMetadata: Metadata used as inputs to
// the localization that is performed on Dynamite-originated messages
// that are incompatible with Hangouts clients. See
// go/localization-of-system-messages for more details.
type ChatConserverDynamitePlaceholderMetadata struct {
	AttachmentMetadata *ChatConserverDynamitePlaceholderMetadataAttachmentMetadata `json:"attachmentMetadata,omitempty"`

	BotMessageMetadata *ChatConserverDynamitePlaceholderMetadataBotMessageMetadata `json:"botMessageMetadata,omitempty"`

	CalendarEventMetadata *ChatConserverDynamitePlaceholderMetadataCalendarEventMetadata `json:"calendarEventMetadata,omitempty"`

	DeleteMetadata *ChatConserverDynamitePlaceholderMetadataDeleteMetadata `json:"deleteMetadata,omitempty"`

	EditMetadata *ChatConserverDynamitePlaceholderMetadataEditMetadata `json:"editMetadata,omitempty"`

	// SpaceUrl: The space URL embedded in the localized string.
	SpaceUrl string `json:"spaceUrl,omitempty"`

	TasksMetadata *ChatConserverDynamitePlaceholderMetadataTasksMetadata `json:"tasksMetadata,omitempty"`

	VideoCallMetadata *ChatConserverDynamitePlaceholderMetadataVideoCallMetadata `json:"videoCallMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AttachmentMetadata")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttachmentMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ChatConserverDynamitePlaceholderMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod ChatConserverDynamitePlaceholderMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ChatConserverDynamitePlaceholderMetadataAttachmentMetadata: An
// attachment uploaded in Dynamite and its filename.
type ChatConserverDynamitePlaceholderMetadataAttachmentMetadata struct {
	Filename string `json:"filename,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filename") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filename") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ChatConserverDynamitePlaceholderMetadataAttachmentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod ChatConserverDynamitePlaceholderMetadataAttachmentMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ChatConserverDynamitePlaceholderMetadataBotMessageMetadata: A bot
// sent a message in Dynamite.
type ChatConserverDynamitePlaceholderMetadataBotMessageMetadata struct {
}

// ChatConserverDynamitePlaceholderMetadataCalendarEventMetadata: A
// Calendar event message in Dynamite.
type ChatConserverDynamitePlaceholderMetadataCalendarEventMetadata struct {
}

// ChatConserverDynamitePlaceholderMetadataDeleteMetadata: A message was
// deleted in Dynamite.
type ChatConserverDynamitePlaceholderMetadataDeleteMetadata struct {
}

// ChatConserverDynamitePlaceholderMetadataEditMetadata: An edit was
// made in Dynamite.
type ChatConserverDynamitePlaceholderMetadataEditMetadata struct {
}

// ChatConserverDynamitePlaceholderMetadataTasksMetadata: A Tasks
// message in Dynamite.
type ChatConserverDynamitePlaceholderMetadataTasksMetadata struct {
}

// ChatConserverDynamitePlaceholderMetadataVideoCallMetadata: A Meet
// initiated in Dynamite and its URL.
type ChatConserverDynamitePlaceholderMetadataVideoCallMetadata struct {
	MeetingUrl string `json:"meetingUrl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MeetingUrl") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MeetingUrl") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ChatConserverDynamitePlaceholderMetadataVideoCallMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod ChatConserverDynamitePlaceholderMetadataVideoCallMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ChatConserverMessageContent: The content of a chat message, which
// includes 0 or more segments along with 0 or more embeds, which
// represent various attachment types (like photos).
type ChatConserverMessageContent struct {
	// Attachment: Items attached to this message, such as photos. This
	// should *NOT* be set by clients. It will be automatically set from
	// media uploaded along with this request and using the information
	// provided in existing_media.
	Attachment []*SocialCommonAttachmentAttachment `json:"attachment,omitempty"`

	// Segment: The text part of the message content. Segments are
	// concatenated together to yield the full message. A message can have
	// zero or more segments.
	Segment []*Segment `json:"segment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Attachment") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attachment") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ChatConserverMessageContent) MarshalJSON() ([]byte, error) {
	type NoMethod ChatConserverMessageContent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ChatContentExtension: NEXT ID: 12
type ChatContentExtension struct {
	// Annotation: Annotations to decorate this event.
	Annotation []*EventAnnotation `json:"annotation,omitempty"`

	// DynamitePlaceholderMetadata: This metadata informs how the
	// placeholder string will be localized dynamically in Hangouts. See
	// go/localization-of-system-messages. This is only used as part of
	// REGULAR_CHAT_MESSAGE events.
	DynamitePlaceholderMetadata *ChatConserverDynamitePlaceholderMetadata `json:"dynamitePlaceholderMetadata,omitempty"`

	// EventOtrStatus: Is this event OnTR or OffTR? Since some events can be
	// ON_THE_RECORD and have an expiration_timestamp (for example
	// enterprise retention users) we need to store the otr status.
	//
	// Possible values:
	//   "OFF_THE_RECORD" - The conversation is completely off the record.
	//   "ON_THE_RECORD" - The conversation is completely on the record.
	EventOtrStatus string `json:"eventOtrStatus,omitempty"`

	// GroupLinkSharingModificationEvent: Group-link sharing toggle event.
	GroupLinkSharingModificationEvent *GroupLinkSharingModificationEvent `json:"groupLinkSharingModificationEvent,omitempty"`

	// HangoutEvent: Audio/video Hangout event.
	HangoutEvent *HangoutEvent `json:"hangoutEvent,omitempty"`

	// InviteAcceptedEvent: Invite accepted events. Note: this is only used
	// ephemerally to sync to Gmail. No actual cent is stored in Papyrus.
	InviteAcceptedEvent *InviteAcceptedEvent `json:"inviteAcceptedEvent,omitempty"`

	// MembershipChangeEvent: Join/leave events.
	MembershipChangeEvent *MembershipChangeEvent `json:"membershipChangeEvent,omitempty"`

	// OtrChatMessageEvent: Metadata for off-the-record message.
	OtrChatMessageEvent *OtrChatMessageEvent `json:"otrChatMessageEvent,omitempty"`

	OtrModificationEvent *OtrModificationEvent `json:"otrModificationEvent,omitempty"`

	RenameEvent *RenameEvent `json:"renameEvent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Annotation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Annotation") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ChatContentExtension) MarshalJSON() ([]byte, error) {
	type NoMethod ChatContentExtension
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ChatProto: Represents the invitees or other users associated with a
// Babel Chat (see http://goto/babel). Corresponds to GroupType CHAT in
// //social/graph/storage/proto/data.proto.
type ChatProto struct {
	// ChatId: Chat IDs consist of alphanumeric characters and colons.
	// Currently required.
	ChatId string `json:"chatId,omitempty"`

	// MemberType: The type of Chat members to consider, e.g. "all members"
	// vs. "invitee" These are defined by legacy_relation_id values in
	// social.graph.storage.EdgeTypeEnum.EdgeType enum options in
	// social/graph/storage/proto/id.proto. See chat.pb (defined in
	// production/config/cdd/socialgraph/mixer_config/prod/node_type_config)
	// for all valid edge types associated with chat. Currently required.
	MemberType int64 `json:"memberType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ChatId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChatId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ChatProto) MarshalJSON() ([]byte, error) {
	type NoMethod ChatProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CheckAccessResponse struct {
	// HasAccess: Returns true if principal has access. Returns false
	// otherwise.
	HasAccess bool `json:"hasAccess,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "HasAccess") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HasAccess") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CheckAccessResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CheckAccessResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CircleProto: Represents a Google+ Circle. Currently (12/2011), a
// Circle is identical to the ContactGroup with matching parameters, but
// Circle must only be used for true Circles and not other Focus groups,
// and should be preferred over ContactGroup where applicable. Soon it
// may become more efficient to check membership in a Circle than in a
// ContactGroup (see http://go/superglue). Support for this principal
// type is currently (12/2011) incomplete -- e.g., Keystore does not
// support it yet (see b/5703421).
type CircleProto struct {
	// CircleId: Circle ID is unique only relative to the owner's Gaia ID.
	// Currently required.
	CircleId int64 `json:"circleId,omitempty,string"`

	// OwnerGaiaId: The owner of the circle. Currently required.
	OwnerGaiaId int64 `json:"ownerGaiaId,omitempty,string"`

	// RequiredConsistencyTimestampUsec: If present, then tests for
	// membership in this circle must use data known to be at least as fresh
	// as the given (FBS-assigned) timestamp. See
	// http://go/fbs-consistent-read-after-important-write Before using
	// this, be sure that any service checking authorization against this
	// circle supports checking consistency timestamps. For example, as of
	// 12/2011, Keystore only supports this for the Moonshine configuration,
	// and in others authorization checks will fail if the timestamp is
	// present.
	RequiredConsistencyTimestampUsec int64 `json:"requiredConsistencyTimestampUsec,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "CircleId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CircleId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CircleProto) MarshalJSON() ([]byte, error) {
	type NoMethod CircleProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ClientContext: Represents the context of the client on behalf of
// which a HistoryRecord is produced. The ClientContext message can be
// used to hold context about the service client (e.g. the internal
// server making fusebox requests) or the user client (e.g. the IP
// address of the end user).
type ClientContext struct {
	// ClientOperationId: The client operation to which this history record
	// belongs. The notion of a client operation is provided to keep track
	// of client operations which might span multiple transactions in the
	// lower level.
	ClientOperationId string `json:"clientOperationId,omitempty"`

	// ClientType: E.g. "pinto", "imap", "bigtop", "upload"
	ClientType string `json:"clientType,omitempty"`

	// SessionContext: Contains information about the session which created
	// this history record. This will be empty if the history record was
	// generated by an internal request.
	SessionContext *SessionContext `json:"sessionContext,omitempty"`

	// UserIp: Textual representation of the user's IP address, if
	// available.
	UserIp string `json:"userIp,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ClientOperationId")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClientOperationId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ClientContext) MarshalJSON() ([]byte, error) {
	type NoMethod ClientContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudPrincipalProto: Principal associated with a Cloud Principal
// representing third party user.
type CloudPrincipalProto struct {
	// Id: Format: "{identity-pool}:{subject}#" Details:
	// go/cloud-principal-identifiers
	Id string `json:"id,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudPrincipalProto) MarshalJSON() ([]byte, error) {
	type NoMethod CloudPrincipalProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ClusterInfo: ClusterInfo contains clustering related information for
// a particular thread that would be sent as part of the conversation
// view. Today, this information would be used by iOS notification
// server to identify whether the thread belongs to a cluster. If the
// thread belongs to a grouped cluster, it would identify whether the
// cluster is throttled.
type ClusterInfo struct {
	// ClusterId: IDs of the highest priority clusters to which the thread
	// belongs to. If this field is not present, the thread does not belong
	// to any cluster and would be shown in the inbox, unclustered.
	ClusterId []string `json:"clusterId,omitempty"`

	// Throttled: If the thread belongs to a grouped cluster and all of
	// those clusters are throttled, then this field is set to true.
	Throttled bool `json:"throttled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClusterId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ClusterInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CoActivity: Metadata about a co-activity session.
type CoActivity struct {
	// ActivityTitle: The title of the activity in this co-activity session.
	// For example, this might be the title of the video being co-watched,
	// or the name of the round of a game being co-played.
	ActivityTitle string `json:"activityTitle,omitempty"`

	// CoActivityApp: Identifies the app handling this co-activity.
	//
	// Possible values:
	//   "CO_ACTIVITY_APP_UNSPECIFIED" - Should never be used.
	//   "CO_ACTIVITY_APP_YOU_TUBE_MAIN" - Main YouTube app, for watching
	// videos.
	//   "CO_ACTIVITY_APP_SPOTIFY" - Spotify music.
	//   "CO_ACTIVITY_APP_UNO" - Uno game.
	//   "CO_ACTIVITY_APP_HEADSUP" - HeadsUp game.
	//   "CO_ACTIVITY_APP_KAHOOT" - Kahoot! educational software.
	//   "CO_ACTIVITY_APP_GQUEUES" - GQueues task manager.
	//   "CO_ACTIVITY_APP_YOU_TUBE_MUSIC" - YouTube Music
	//   "CO_ACTIVITY_APP_SAMSUNG_NOTES" - Samsung Notes
	//   "CO_ACTIVITY_APP_HAPPY_AARDVARK" - .
	CoActivityApp string `json:"coActivityApp,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ActivityTitle") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActivityTitle") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CoActivity) MarshalJSON() ([]byte, error) {
	type NoMethod CoActivity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Collaboration: Information about a collaboration session.
type Collaboration struct {
	// AttachmentId: The attachment being collaborated on.
	AttachmentId string `json:"attachmentId,omitempty"`

	// Initiator: Display info of the user who initiated the collaboration
	// session.
	Initiator *UserDisplayInfo `json:"initiator,omitempty"`

	// Uri: The uri of the artifact being collaborated on.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AttachmentId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttachmentId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Collaboration) MarshalJSON() ([]byte, error) {
	type NoMethod Collaboration
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Color: Represents a color in the RGBA color space. This
// representation is designed for simplicity of conversion to/from color
// representations in various languages over compactness. For example,
// the fields of this representation can be trivially provided to the
// constructor of `java.awt.Color` in Java; it can also be trivially
// provided to UIColor's `+colorWithRed:green:blue:alpha` method in iOS;
// and, with just a little work, it can be easily formatted into a CSS
// `rgba()` string in JavaScript. This reference page doesn't carry
// information about the absolute color space that should be used to
// interpret the RGB value (e.g. sRGB, Adobe RGB, DCI-P3, BT.2020,
// etc.). By default, applications should assume the sRGB color space.
// When color equality needs to be decided, implementations, unless
// documented otherwise, treat two colors as equal if all their red,
// green, blue, and alpha values each differ by at most 1e-5. Example
// (Java): import com.google.type.Color; // ... public static
// java.awt.Color fromProto(Color protocolor) { float alpha =
// protocolor.hasAlpha() ? protocolor.getAlpha().getValue() : 1.0;
// return new java.awt.Color( protocolor.getRed(),
// protocolor.getGreen(), protocolor.getBlue(), alpha); } public static
// Color toProto(java.awt.Color color) { float red = (float)
// color.getRed(); float green = (float) color.getGreen(); float blue =
// (float) color.getBlue(); float denominator = 255.0; Color.Builder
// resultBuilder = Color .newBuilder() .setRed(red / denominator)
// .setGreen(green / denominator) .setBlue(blue / denominator); int
// alpha = color.getAlpha(); if (alpha != 255) { result.setAlpha(
// FloatValue .newBuilder() .setValue(((float) alpha) / denominator)
// .build()); } return resultBuilder.build(); } // ... Example (iOS /
// Obj-C): // ... static UIColor* fromProto(Color* protocolor) { float
// red = [protocolor red]; float green = [protocolor green]; float blue
// = [protocolor blue]; FloatValue* alpha_wrapper = [protocolor alpha];
// float alpha = 1.0; if (alpha_wrapper != nil) { alpha = [alpha_wrapper
// value]; } return [UIColor colorWithRed:red green:green blue:blue
// alpha:alpha]; } static Color* toProto(UIColor* color) { CGFloat red,
// green, blue, alpha; if (![color getRed:&red green:&green blue:&blue
// alpha:&alpha]) { return nil; } Color* result = [[Color alloc] init];
// [result setRed:red]; [result setGreen:green]; [result setBlue:blue];
// if (alpha <= 0.9999) { [result
// setAlpha:floatWrapperWithValue(alpha)]; } [result autorelease];
// return result; } // ... Example (JavaScript): // ... var
// protoToCssColor = function(rgb_color) { var redFrac = rgb_color.red
// || 0.0; var greenFrac = rgb_color.green || 0.0; var blueFrac =
// rgb_color.blue || 0.0; var red = Math.floor(redFrac * 255); var green
// = Math.floor(greenFrac * 255); var blue = Math.floor(blueFrac * 255);
// if (!('alpha' in rgb_color)) { return rgbToCssColor(red, green,
// blue); } var alphaFrac = rgb_color.alpha.value || 0.0; var rgbParams
// = [red, green, blue].join(','); return ['rgba(', rgbParams, ',',
// alphaFrac, ')'].join(”); }; var rgbToCssColor = function(red, green,
// blue) { var rgbNumber = new Number((red << 16) | (green << 8) |
// blue); var hexString = rgbNumber.toString(16); var missingZeros = 6 -
// hexString.length; var resultBuilder = ['#']; for (var i = 0; i <
// missingZeros; i++) { resultBuilder.push('0'); }
// resultBuilder.push(hexString); return resultBuilder.join(”); }; //
// ...
type Color struct {
	// Alpha: The fraction of this color that should be applied to the
	// pixel. That is, the final pixel color is defined by the equation:
	// `pixel color = alpha * (this color) + (1.0 - alpha) * (background
	// color)` This means that a value of 1.0 corresponds to a solid color,
	// whereas a value of 0.0 corresponds to a completely transparent color.
	// This uses a wrapper message rather than a simple float scalar so that
	// it is possible to distinguish between a default value and the value
	// being unset. If omitted, this color object is rendered as a solid
	// color (as if the alpha value had been explicitly given a value of
	// 1.0).
	Alpha float64 `json:"alpha,omitempty"`

	// Blue: The amount of blue in the color as a value in the interval [0,
	// 1].
	Blue float64 `json:"blue,omitempty"`

	// Green: The amount of green in the color as a value in the interval
	// [0, 1].
	Green float64 `json:"green,omitempty"`

	// Red: The amount of red in the color as a value in the interval [0,
	// 1].
	Red float64 `json:"red,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Alpha") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alpha") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Color) MarshalJSON() ([]byte, error) {
	type NoMethod Color
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *Color) UnmarshalJSON(data []byte) error {
	type NoMethod Color
	var s1 struct {
		Alpha gensupport.JSONFloat64 `json:"alpha"`
		Blue  gensupport.JSONFloat64 `json:"blue"`
		Green gensupport.JSONFloat64 `json:"green"`
		Red   gensupport.JSONFloat64 `json:"red"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Alpha = float64(s1.Alpha)
	s.Blue = float64(s1.Blue)
	s.Green = float64(s1.Green)
	s.Red = float64(s1.Red)
	return nil
}

// CommunalLabelTag: An individual instance (or "tag") of a label
// configured as a communal type that's associated with a message.
type CommunalLabelTag struct {
	// CreatorUserId: Gaia ID of the user who added the tag, if any. Not
	// present for any tags automatically created by server-side processing.
	CreatorUserId int64 `json:"creatorUserId,omitempty,string"`

	// LabelId: A string ID representing the label. Possible ID values are
	// documented at go/chat-labels-howto:ids. Example: "^*t_p" for
	// "Pinned".
	LabelId string `json:"labelId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreatorUserId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreatorUserId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CommunalLabelTag) MarshalJSON() ([]byte, error) {
	type NoMethod CommunalLabelTag
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CompositeFilter struct {
	// LogicOperator: The logic operator of the sub filter.
	//
	// Possible values:
	//   "AND" - Logical operators, which can only be applied to sub
	// filters.
	//   "OR"
	//   "NOT" - NOT can only be applied on a single sub filter.
	LogicOperator string `json:"logicOperator,omitempty"`

	// SubFilters: Sub filters.
	SubFilters []*Filter `json:"subFilters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LogicOperator") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LogicOperator") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CompositeFilter) MarshalJSON() ([]byte, error) {
	type NoMethod CompositeFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ConsentedAppUnfurlMetadata: Annotation metadata app unfurl consent.
type ConsentedAppUnfurlMetadata struct {
	// ClientSpecifiedAppId: Client specified AppId, which will not be
	// sanitized and is untrusted.
	ClientSpecifiedAppId *UserId `json:"clientSpecifiedAppId,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ClientSpecifiedAppId") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClientSpecifiedAppId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ConsentedAppUnfurlMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod ConsentedAppUnfurlMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ContactGroupProto: A group of contacts for a given user, as described
// in http://cs/p#google3/focus/backend/proto/backend.proto Historically
// (and in still-existing ACLs), this was used to represent Google+
// circles as well as contact groups, but this use is now deprecated.
// New code should use the CIRCLE principal type to represent Google+
// circles.
type ContactGroupProto struct {
	// GroupId: Group ID is unique only relative to the owner's Gaia ID.
	GroupId int64 `json:"groupId,omitempty,string"`

	OwnerGaiaId int64 `json:"ownerGaiaId,omitempty,string"`

	// RequiredConsistencyTimestampUsec: If present, then tests for
	// membership in this ContactGroup must use data known to be at least as
	// fresh as the given (FBS-assigned) timestamp. See
	// http://go/fbs-consistent-read-after-important-write Before using
	// this, be sure that any service checking authorization against this
	// group supports checking consistency timestamps. For example, as of
	// 12/2011, Keystore only supports this for the Moonshine configuration,
	// and in others authorization checks will fail if the timestamp is
	// present.
	RequiredConsistencyTimestampUsec int64 `json:"requiredConsistencyTimestampUsec,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "GroupId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GroupId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ContactGroupProto) MarshalJSON() ([]byte, error) {
	type NoMethod ContactGroupProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ContentReport struct {
	// ReportCreateTimestamp: The time at which the report is generated.
	// Always populated when it is in a response.
	ReportCreateTimestamp string `json:"reportCreateTimestamp,omitempty"`

	// ReportJustification: Additional user-provided justification on the
	// report. Optional.
	ReportJustification *ContentReportJustification `json:"reportJustification,omitempty"`

	// ReportType: Type of the report. Always populated when it is in a
	// response.
	ReportType *AppsDynamiteSharedContentReportType `json:"reportType,omitempty"`

	// ReporterUserId: User ID of the reporter. Always populated when it is
	// in a response.
	ReporterUserId *UserId `json:"reporterUserId,omitempty"`

	// RevisionCreateTimestamp: Create timestamp of the revisions of the
	// message when it's reported. Always populated when it is in a
	// response.
	RevisionCreateTimestamp string `json:"revisionCreateTimestamp,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ReportCreateTimestamp") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ReportCreateTimestamp") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ContentReport) MarshalJSON() ([]byte, error) {
	type NoMethod ContentReport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ContentReportJustification struct {
	// UserJustification: Optional. User-generated free-text justification
	// for the content report.
	UserJustification string `json:"userJustification,omitempty"`

	// ForceSendFields is a list of field names (e.g. "UserJustification")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserJustification") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ContentReportJustification) MarshalJSON() ([]byte, error) {
	type NoMethod ContentReportJustification
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ContentReportSummary: Summarized info of content reports. Usually
// less expensive to fetch than to fetch all detailed reports. Set only
// when the request asks for it.
type ContentReportSummary struct {
	// NumberReports: Total number of reports attached to this (revision of)
	// message.
	NumberReports int64 `json:"numberReports,omitempty"`

	// NumberReportsAllRevisions: Totoal number of reports attached to all
	// revisions of this message (i.e. since creation). Set only when the
	// request asks for it.
	NumberReportsAllRevisions int64 `json:"numberReportsAllRevisions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NumberReports") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NumberReports") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ContentReportSummary) MarshalJSON() ([]byte, error) {
	type NoMethod ContentReportSummary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ContextAttribute: A named attribute associated with an item which can
// be used for influencing the ranking of the item based on the context
// in the request.
type ContextAttribute struct {
	// Name: The name of the attribute. It should not be empty. The maximum
	// length is 32 characters. The name must start with a letter and can
	// only contain letters (A-Z, a-z) or numbers (0-9). The name will be
	// normalized (lower-cased) before being matched.
	Name string `json:"name,omitempty"`

	// Values: Text values of the attribute. The maximum number of elements
	// is 10. The maximum length of an element in the array is 32
	// characters. The value will be normalized (lower-cased) before being
	// matched.
	Values []string `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ContextAttribute) MarshalJSON() ([]byte, error) {
	type NoMethod ContextAttribute
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ContextualAddOnMarkup: The markup for developers to specify the
// contents of a contextual AddOn. A contextual AddOn is triggered in
// context of an email. For that email, there can be N items that are
// associated with the email (e.g. contacts, sales lead, meeting
// information). Each item is represented as a "card". A card has two
// views, collapsed and detailed. If there are more than 1 card, the
// cards are show as a list of collapsed views. The end user can expand
// into the detailed view for each of those cards. In the detailed view,
// developers have the freedom to use a variety of "widgets" to
// construct it. The model here is to restrict (make consistent for end
// users) the navigation of the N cards but providing developers the
// freedom to build the detailed view that can best represent their use
// case/content. Go http://go/aoig-widgets1 to see the mocks. Post v1,
// we plan to support new AddOn use cases that will require different
// and separate 'templates'. For example, a compose triggered AddOn
// which will support a new set of use cases with different user
// interaction patterns. As a result, we will likely need a very
// different template than this one.
type ContextualAddOnMarkup struct {
	// Cards: A card must contain a header and at least 1 section.
	Cards []*Card `json:"cards,omitempty"`

	// Toolbar: Deprecated.
	Toolbar *Toolbar `json:"toolbar,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cards") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cards") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ContextualAddOnMarkup) MarshalJSON() ([]byte, error) {
	type NoMethod ContextualAddOnMarkup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CseInfo: Information needed for Client-side Encryption.
type CseInfo struct {
	// CseDomain: CSE domain name claimed by the meeting owner's company.
	// This field is expected to be used for display purposes only, i.e.,
	// "Extra encryption added by $cse_domain". It can differ from the
	// `cse_domain` as defined elsewhere on the User, in the case of
	// cross-domain meetings.
	CseDomain string `json:"cseDomain,omitempty"`

	// WrappedKey: The wrapped CSE key used by this conference.
	WrappedKey string `json:"wrappedKey,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CseDomain") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CseDomain") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CseInfo) MarshalJSON() ([]byte, error) {
	type NoMethod CseInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CustomEmojiMetadata struct {
	CustomEmoji *AppsDynamiteSharedCustomEmoji `json:"customEmoji,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CustomEmoji") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomEmoji") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CustomEmojiMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod CustomEmojiMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CustomFunctionReturnValueMarkup: The result of a user running a
// custom function.
type CustomFunctionReturnValueMarkup struct {
	// ErrorMessage: The error message to show to the user if something went
	// wrong.
	ErrorMessage string `json:"errorMessage,omitempty"`

	// Value: The value that resulted from running the custom function.
	Value interface{} `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorMessage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorMessage") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CustomFunctionReturnValueMarkup) MarshalJSON() ([]byte, error) {
	type NoMethod CustomFunctionReturnValueMarkup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CustomerId: Represents a GSuite customer ID. Obfuscated with
// CustomerIdObfuscator.
type CustomerId struct {
	CustomerId string `json:"customerId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CustomerId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomerId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CustomerId) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CustomerIndexStats: Aggregation of items by status code as of the
// specified date.
type CustomerIndexStats struct {
	// Date: The date for which statistics were calculated.
	Date *Date `json:"date,omitempty"`

	// ItemCountByStatus: Number of items aggregrated by status code.
	ItemCountByStatus []*ItemCountByStatus `json:"itemCountByStatus,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Date") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Date") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CustomerIndexStats) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerIndexStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CustomerQueryStats struct {
	// Date: The date for which query stats were calculated. Stats
	// calculated on the next day close to midnight are returned.
	Date *Date `json:"date,omitempty"`

	QueryCountByStatus []*QueryCountByStatus `json:"queryCountByStatus,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Date") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Date") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CustomerQueryStats) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerQueryStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CustomerSearchApplicationStats: Search application stats for a
// customer for the given date.
type CustomerSearchApplicationStats struct {
	// Count: The count of search applications for the date.
	Count int64 `json:"count,omitempty,string"`

	// Date: The date for which search application stats were calculated.
	Date *Date `json:"date,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Count") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CustomerSearchApplicationStats) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerSearchApplicationStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CustomerSessionStats struct {
	// Date: The date for which session stats were calculated. Stats are
	// calculated on the following day, close to midnight PST, and then
	// returned.
	Date *Date `json:"date,omitempty"`

	// SearchSessionsCount: The count of search sessions on the day
	SearchSessionsCount int64 `json:"searchSessionsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Date") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Date") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CustomerSessionStats) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerSessionStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CustomerSettings: Represents settings at a customer level.
type CustomerSettings struct {
	// AuditLoggingSettings: Audit Logging settings for the customer. If
	// update_mask is empty then this field will be updated based on
	// UpdateCustomerSettings request.
	AuditLoggingSettings *AuditLoggingSettings `json:"auditLoggingSettings,omitempty"`

	// VpcSettings: VPC SC settings for the customer. If update_mask is
	// empty then this field will be updated based on UpdateCustomerSettings
	// request.
	VpcSettings *VPCSettings `json:"vpcSettings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AuditLoggingSettings") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuditLoggingSettings") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CustomerSettings) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CustomerUserStats struct {
	// Date: The date for which session stats were calculated. Stats
	// calculated on the next day close to midnight are returned.
	Date *Date `json:"date,omitempty"`

	// OneDayActiveUsersCount: The count of unique active users in the past
	// one day
	OneDayActiveUsersCount int64 `json:"oneDayActiveUsersCount,omitempty,string"`

	// SevenDaysActiveUsersCount: The count of unique active users in the
	// past seven days
	SevenDaysActiveUsersCount int64 `json:"sevenDaysActiveUsersCount,omitempty,string"`

	// ThirtyDaysActiveUsersCount: The count of unique active users in the
	// past thirty days
	ThirtyDaysActiveUsersCount int64 `json:"thirtyDaysActiveUsersCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Date") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Date") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CustomerUserStats) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerUserStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DataLossPreventionMetadata: Annotation metadata for Data Loss
// Prevention that pertains to DLP violation on message send or edit
// events. It is used for client -> BE communication and other
// downstream process in BE (e.g. storage and audit logging), and it
// should never be returned to the client.
type DataLossPreventionMetadata struct {
	// DlpScanSummary: The DLP scan summary that should only be set after
	// the message is scanned in the Chat backend.
	DlpScanSummary *DlpScanSummary `json:"dlpScanSummary,omitempty"`

	// WarnAcknowledged: Flag set by client on message resend to bypass WARN
	// violation.
	WarnAcknowledged bool `json:"warnAcknowledged,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DlpScanSummary") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DlpScanSummary") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DataLossPreventionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod DataLossPreventionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DataSource: Datasource is a logical namespace for items to be
// indexed. All items must belong to a datasource. This is the
// prerequisite before items can be indexed into Cloud Search.
type DataSource struct {
	// DisableModifications: If true, sets the datasource to read-only mode.
	// In read-only mode, the Indexing API rejects any requests to index or
	// delete items in this source. Enabling read-only mode does not stop
	// the processing of previously accepted data.
	DisableModifications bool `json:"disableModifications,omitempty"`

	// DisableServing: Disable serving any search or assist results.
	DisableServing bool `json:"disableServing,omitempty"`

	// DisplayName: Required. Display name of the datasource The maximum
	// length is 300 characters.
	DisplayName string `json:"displayName,omitempty"`

	// IndexingServiceAccounts: List of service accounts that have indexing
	// access.
	IndexingServiceAccounts []string `json:"indexingServiceAccounts,omitempty"`

	// ItemsVisibility: This field restricts visibility to items at the
	// datasource level. Items within the datasource are restricted to the
	// union of users and groups included in this field. Note that, this
	// does not ensure access to a specific item, as users need to have ACL
	// permissions on the contained items. This ensures a high level access
	// on the entire datasource, and that the individual items are not
	// shared outside this visibility.
	ItemsVisibility []*GSuitePrincipal `json:"itemsVisibility,omitempty"`

	// Name: The name of the datasource resource. Format:
	// datasources/{source_id}. The name is ignored when creating a
	// datasource.
	Name string `json:"name,omitempty"`

	// OperationIds: IDs of the Long Running Operations (LROs) currently
	// running for this schema.
	OperationIds []string `json:"operationIds,omitempty"`

	// ReturnThumbnailUrls: Can a user request to get thumbnail URI for
	// Items indexed in this data source.
	ReturnThumbnailUrls bool `json:"returnThumbnailUrls,omitempty"`

	// ShortName: A short name or alias for the source. This value will be
	// used to match the 'source' operator. For example, if the short name
	// is *<value>* then queries like *source:<value>* will only return
	// results for this source. The value must be unique across all
	// datasources. The value must only contain alphanumeric characters
	// (a-zA-Z0-9). The value cannot start with 'google' and cannot be one
	// of the following: mail, gmail, docs, drive, groups, sites, calendar,
	// hangouts, gplus, keep, people, teams. Its maximum length is 32
	// characters.
	ShortName string `json:"shortName,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "DisableModifications") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisableModifications") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DataSource) MarshalJSON() ([]byte, error) {
	type NoMethod DataSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DataSourceIndexStats: Aggregation of items by status code as of the
// specified date.
type DataSourceIndexStats struct {
	// Date: The date for which index stats were calculated. If the date of
	// request is not the current date then stats calculated on the next day
	// are returned. Stats are calculated close to mid night in this case.
	// If date of request is current date, then real time stats are
	// returned.
	Date *Date `json:"date,omitempty"`

	// ItemCountByStatus: Number of items aggregrated by status code.
	ItemCountByStatus []*ItemCountByStatus `json:"itemCountByStatus,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Date") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Date") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DataSourceIndexStats) MarshalJSON() ([]byte, error) {
	type NoMethod DataSourceIndexStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DataSourceRestriction: Restriction on Datasource.
type DataSourceRestriction struct {
	// FilterOptions: Filter options restricting the results. If multiple
	// filters are present, they are grouped by object type before joining.
	// Filters with the same object type are joined conjunctively, then the
	// resulting expressions are joined disjunctively. The maximum number of
	// elements is 20. NOTE: Suggest API supports only few filters at the
	// moment: "objecttype", "type" and "mimetype". For now, schema specific
	// filters cannot be used to filter suggestions.
	FilterOptions []*FilterOptions `json:"filterOptions,omitempty"`

	// Source: The source of restriction.
	Source *Source `json:"source,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FilterOptions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FilterOptions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DataSourceRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod DataSourceRestriction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Date: Represents a whole calendar date, for example a date of birth.
// The time of day and time zone are either specified elsewhere or are
// not significant. The date is relative to the Proleptic Gregorian
// Calendar
// (https://en.wikipedia.org/wiki/Proleptic_Gregorian_calendar). The
// date must be a valid calendar date between the year 1 and 9999.
type Date struct {
	// Day: Day of month. Must be from 1 to 31 and valid for the year and
	// month.
	Day int64 `json:"day,omitempty"`

	// Month: Month of date. Must be from 1 to 12.
	Month int64 `json:"month,omitempty"`

	// Year: Year of date. Must be from 1 to 9999.
	Year int64 `json:"year,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Day") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Day") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Date) MarshalJSON() ([]byte, error) {
	type NoMethod Date
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DateOperatorOptions: Optional. Provides a search operator for date
// properties. Search operators let users restrict the query to specific
// fields relevant to the type of item being searched.
type DateOperatorOptions struct {
	// GreaterThanOperatorName: Indicates the operator name required in the
	// query in order to isolate the date property using the greater-than
	// operator. For example, if greaterThanOperatorName is *closedafter*
	// and the property's name is *closeDate*, then queries like
	// *closedafter:<value>* show results only where the value of the
	// property named *closeDate* is later than *<value>*. The operator name
	// can only contain lowercase letters (a-z). The maximum length is 32
	// characters.
	GreaterThanOperatorName string `json:"greaterThanOperatorName,omitempty"`

	// LessThanOperatorName: Indicates the operator name required in the
	// query in order to isolate the date property using the less-than
	// operator. For example, if lessThanOperatorName is *closedbefore* and
	// the property's name is *closeDate*, then queries like
	// *closedbefore:<value>* show results only where the value of the
	// property named *closeDate* is earlier than *<value>*. The operator
	// name can only contain lowercase letters (a-z). The maximum length is
	// 32 characters.
	LessThanOperatorName string `json:"lessThanOperatorName,omitempty"`

	// OperatorName: Indicates the actual string required in the query in
	// order to isolate the date property. For example, suppose an issue
	// tracking schema object has a property named *closeDate* that
	// specifies an operator with an operatorName of *closedon*. For
	// searches on that data, queries like *closedon:<value>* show results
	// only where the value of the *closeDate* property matches *<value>*.
	// By contrast, a search that uses the same *<value>* without an
	// operator returns all items where *<value>* matches the value of any
	// String properties or text within the content field for the indexed
	// datasource. The operator name can only contain lowercase letters
	// (a-z). The maximum length is 32 characters.
	OperatorName string `json:"operatorName,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "GreaterThanOperatorName") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GreaterThanOperatorName")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DateOperatorOptions) MarshalJSON() ([]byte, error) {
	type NoMethod DateOperatorOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DatePropertyOptions: The options for date properties.
type DatePropertyOptions struct {
	// OperatorOptions: If set, describes how the date should be used as a
	// search operator.
	OperatorOptions *DateOperatorOptions `json:"operatorOptions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OperatorOptions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OperatorOptions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DatePropertyOptions) MarshalJSON() ([]byte, error) {
	type NoMethod DatePropertyOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DateTimePicker struct {
	// Label: The label for the field, which is displayed to the user.
	Label string `json:"label,omitempty"`

	// Name: The name of the text field which is used in FormInput, and
	// uniquely identifies this input.
	Name string `json:"name,omitempty"`

	// OnChange: Triggered when the user clicks on the Save, or Clear button
	// from the date / time picker dialog. Will only be triggered if the
	// value changed as a result of the Save / Clear operation.
	OnChange *FormAction `json:"onChange,omitempty"`

	// TimezoneOffsetDate: The number representing the time-zone offset from
	// UTC, in minutes. If set, the value_ms_epoch will be displayed in the
	// specified time zone. If not set, it will use the user's timezone
	// setting in client side.
	TimezoneOffsetDate int64 `json:"timezoneOffsetDate,omitempty"`

	// Type: The type of the DateTimePicker.
	//
	// Possible values:
	//   "UNSPECIFIED_TYPE"
	//   "DATE_AND_TIME"
	//   "DATE_ONLY"
	//   "TIME_ONLY"
	Type string `json:"type,omitempty"`

	// ValueMsEpoch: The value to display which can be the default value
	// before user input or previous user input. It is represented in
	// milliseconds (Epoch time). - For DATE_AND_TIME type, the full epoch
	// value is used. - For DATE_ONLY type, only date of the epoch time is
	// used. - For TIME_ONLY type, only time of the epoch time is used. For
	// example, you can set epoch time to 3 * 60 * 60 * 1000 to represent
	// 3am.
	ValueMsEpoch int64 `json:"valueMsEpoch,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Label") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Label") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DateTimePicker) MarshalJSON() ([]byte, error) {
	type NoMethod DateTimePicker
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DateValues: List of date values.
type DateValues struct {
	Values []*Date `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Values") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DateValues) MarshalJSON() ([]byte, error) {
	type NoMethod DateValues
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DebugOptions: Shared request debug options for all cloudsearch RPC
// methods.
type DebugOptions struct {
	// EnableDebugging: If you are asked by Google to help with debugging,
	// set this field. Otherwise, ignore this field.
	EnableDebugging bool `json:"enableDebugging,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EnableDebugging") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnableDebugging") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DebugOptions) MarshalJSON() ([]byte, error) {
	type NoMethod DebugOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeepLinkData: Deep-linking data is used to construct a deep-link URI
// for an activity or frame's embed, such that on click, the user is
// taken to the right place in a mobile app. If the app is not
// installed, the user is taken to the app store. If not on mobile, an
// analogous web uri is used.
type DeepLinkData struct {
	// AppId: Application ID (or project ID) from Google API Console.
	AppId int64 `json:"appId,omitempty,string"`

	// Client: The data for a Google API Console client is entered by a
	// developer during client registration and is stored in
	// PackagingService.
	Client []*PackagingServiceClient `json:"client,omitempty"`

	// DeepLinkId: The ID for non-URL content. Embeds may either have no
	// analogous web presence or prefer a native mobile experience if
	// supported. In the case of no web presence, instead of setting the
	// "url" field of an embed, such developers will set this field and
	// other content fields, e.g. thumbnail, title, description. If set,
	// this field is used to construct the deep-link URI. Note that the
	// native experience is preferred over the web link and the web link is
	// used as a fallback.
	DeepLinkId string `json:"deepLinkId,omitempty"`

	// Url: Analogous web presence. Used as desktop fallback or when no
	// native link data is present.
	Url string `json:"url,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AppId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DeepLinkData) MarshalJSON() ([]byte, error) {
	type NoMethod DeepLinkData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeleteMetadata: A message delete in Dynamite inserts a Babel-only
// item containing this field. This is only inserted for messages before
// the source-of-truth flip. See go/hsc-message-deletions for more
// details.
type DeleteMetadata struct {
}

type DeleteQueueItemsRequest struct {
	// ConnectorName: The name of connector making this call. Format:
	// datasources/{source_id}/connectors/{ID}
	ConnectorName string `json:"connectorName,omitempty"`

	// DebugOptions: Common debug options.
	DebugOptions *DebugOptions `json:"debugOptions,omitempty"`

	// Queue: The name of a queue to delete items from.
	Queue string `json:"queue,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConnectorName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConnectorName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DeleteQueueItemsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DeleteQueueItemsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DeliveryMedium struct {
	// MediumType: Describes the medium the cent was sent/received. For
	// example, if I receive an SMS via GV, the medium_type will be GV.
	//
	// Possible values:
	//   "UNKNOWN_MEDIUM"
	//   "BABEL_MEDIUM"
	//   "GOOGLE_VOICE_MEDIUM"
	//   "LOCAL_SMS_MEDIUM"
	MediumType string `json:"mediumType,omitempty"`

	// SelfPhone: In the case of multiple GV/native numbers, this defines
	// the exact number to send from. It is used to differentiate mediums
	// that have the same type, but different addresses (e.g. two android
	// phones).
	SelfPhone *VoicePhoneNumber `json:"selfPhone,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MediumType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MediumType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DeliveryMedium) MarshalJSON() ([]byte, error) {
	type NoMethod DeliveryMedium
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DisplayedProperty: A reference to a top-level property within the
// object that should be displayed in search results. The values of the
// chosen properties is displayed in the search results along with the
// display label for that property if one is specified. If a display
// label is not specified, only the values is shown.
type DisplayedProperty struct {
	// PropertyName: The name of the top-level property as defined in a
	// property definition for the object. If the name is not a defined
	// property in the schema, an error is given when attempting to update
	// the schema.
	PropertyName string `json:"propertyName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PropertyName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PropertyName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DisplayedProperty) MarshalJSON() ([]byte, error) {
	type NoMethod DisplayedProperty
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type Divider struct {
}

// DlpScanSummary: A summary of a DLP scan event. This is a summary and
// should contain the minimum amount of data required to identify and
// process DLP scans. It is written to Starcast and encoded & returned
// to the client on attachment upload.
type DlpScanSummary struct {
	// ScanId: The scan ID of the corresponding {@link
	// DlpViolationScanRecord} in the {@link EphemeralDlpScans} Spanner
	// table. This can be used to fetch additional details about the scan,
	// e.g. for audit logging.
	ScanId string `json:"scanId,omitempty"`

	// ScanNotApplicableForContext: Indicates that was no attempt to scan a
	// message or attachment because it was not applicable in the given
	// context (e.g. atomic mutuate). If this is true, scan_outcome should
	// not be set. This flag is used to identify messages that DLP did not
	// attempt to scan for monitoring scan coverage. Contents that DLP
	// attempted to scan but skipped can be identified by
	// DlpScanOutcome.SCAN_SKIPPED_* reasons.
	ScanNotApplicableForContext bool `json:"scanNotApplicableForContext,omitempty"`

	// ScanOutcome: The outcome of a DLP Scan. If this is set,
	// scan_not_applicable_for_context should not be true.
	//
	// Possible values:
	//   "SCAN_UNKNOWN_OUTCOME"
	//   "SCAN_SUCCEEDED_NO_VIOLATION" - This means no violation is detected
	// on the given message/attachment.
	//   "SCAN_SUCCEEDED_BLOCK" - Violation is detected. The
	// message/attachment will be blocked (or deleted if this happens in
	// failure recovery), the user will be warned, and the violation will be
	// logged to BIP.
	//   "SCAN_SUCCEEDED_WARN" - Violation is detected. The user will be
	// warned, and the violation will be logged to BIP.
	//   "SCAN_SUCCEEDED_AUDIT_ONLY" - Violation is detected and will be
	// logged to BIP (no user-facing action performed).
	//   "SCAN_FAILURE_EXCEPTION" - Rule fetch and evaluation were attempted
	// but an exception occurred.
	//   "SCAN_FAILURE_RULE_FETCH_FAILED" - Rule fetch was attempted but
	// failed, so rule evaluation could not be performed.
	//   "SCAN_FAILURE_TIMEOUT" - Rule fetch and evaluation were attempted
	// but the scanning timed out.
	//   "SCAN_FAILURE_ALL_RULES_FAILED" - Rule fetch completed and
	// evaluation were attempted, but all of the rules failed to be
	// evaluated.
	//   "SCAN_FAILURE_ILLEGAL_STATE_FOR_ATTACHMENTS" - An
	// IllegalStateException is thrown when executing DLP on attachments.
	// This could happen if the space row is missing.
	//   "SCAN_SKIPPED_EXPERIMENT_DISABLED" - Rule fetch and evaluation is
	// skipped because DLP is not enabled for the user.
	//   "SCAN_SKIPPED_CONSUMER" - Rule fetch and evaluation are skipped
	// because the user sending message is consumer.
	//   "SCAN_SKIPPED_NON_HUMAN_USER" - Rule fetch and evaluation are
	// skipped because the user sending message is a non-human user (i.e. a
	// bot).
	//   "SCAN_SKIPPED_NO_MESSAGE" - Rule fetch and evaluation are skipped
	// because there is no message to scan. Deprecated: this should not
	// happen since there must be message or attachment for DLP scan.
	//   "SCAN_SKIPPED_USER_ACKNOWLEDGED_WARNING" - Rule fetch and
	// evaluation are skipped because the user has acknowledged the warning
	// on the message that triggered the Warn violation and sent the message
	// anyway.
	//   "SCAN_SKIPPED_MESSAGE_FROM_UNSUPPORTED_ORIGIN" - Scanning was
	// skipped because the message originated from Interop or Babel.
	//   "SCAN_SKIPPED_MESSAGE_SENT_DURING_SPACE_MIGRATION" - Scanning was
	// skipped because the message was sent while the space is in migration
	// mode. See go/migration-mode for details.
	//   "SCAN_RULE_EVALUATION_SKIPPED_NO_RULES_FOUND" - Rule fetch
	// happened, but rule evaluation is skipped because no rules were found.
	//
	// "SCAN_RULE_EVALUATION_SKIPPED_NO_APPLICABLE_RULES_FOR_ACTION_PARAMS"
	// - Rule fetch happened, but rule evaluation is skipped because none of
	// the rules are applicable to the given action params.
	//   "SCAN_RULE_EVALUATION_SKIPPED_NO_APPLICABLE_RULES_FOR_TRIGGER" -
	// Rule fetch happened, but rule evaluation is skipped because none of
	// the rules are applicable to the given trigger.
	//   "SCAN_RULE_EVALUATION_SKIPPED_CHANGELING_PERMANENT_ERROR" - Rule
	// fetch happened, but rule evaluation is skipped because Changeling
	// returned permanent failure while converting the attachment to text.
	//   "SCAN_RULE_EVALUATION_SKIPPED_CHANGELING_EMPTY_RESPONSE" - Rule
	// fetch happened, but rule evaluation is skipped because Changeling
	// returned an empty response while converting the attachment to text.
	//   "SCAN_RULE_EVALUATION_SKIPPED_UNSUPPORTED_FILE_TYPE" - Rule fetch
	// happened, but rule evaluation is skipped because file type is
	// unsupported.
	//   "SCAN_SUCCEEDED_WITH_FAILURES_NO_VIOLATION" - Rules were fetched
	// but some evaluations failed. No violation was found in the rules that
	// were successfully evaluated.
	//   "SCAN_SUCCEEDED_WITH_FAILURES_BLOCK" - Rules were fetched but some
	// evaluations failed. A blocking violation was found in the rules that
	// were successfully evaluated. The message/attachment will be blocked,
	// the user will be notified, and the violation will be logged to BIP. A
	// blocking violation takes precedence over all other violation types.
	//   "SCAN_SUCCEEDED_WITH_FAILURES_WARN" - Rules were fetched but some
	// evaluations failed. A warn violation was found in the rules that were
	// successfully evaluated. The user will be warned, and the violation
	// will be logged to BIP.
	//   "SCAN_SUCCEEDED_WITH_FAILURES_AUDIT_ONLY" - Rules were fetched but
	// some evaluations failed. An audit-only violation was found in the
	// rules that were successfully evaluated. The violation will be logged
	// to BIP (no user-facing action performed).
	ScanOutcome string `json:"scanOutcome,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ScanId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ScanId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DlpScanSummary) MarshalJSON() ([]byte, error) {
	type NoMethod DlpScanSummary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DmId struct {
	// DmId: Unique server assigned Id, per Direct Message Space.
	DmId string `json:"dmId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DmId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DmId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DmId) MarshalJSON() ([]byte, error) {
	type NoMethod DmId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DocumentInfo: Information on a document attached to an active
// conference.
type DocumentInfo struct {
	// WhiteboardInfo: A whiteboard document.
	WhiteboardInfo *WhiteboardInfo `json:"whiteboardInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "WhiteboardInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "WhiteboardInfo") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DocumentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod DocumentInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DoubleOperatorOptions: Used to provide a search operator for double
// properties. This is optional. Search operators let users restrict the
// query to specific fields relevant to the type of item being searched.
type DoubleOperatorOptions struct {
	// OperatorName: Indicates the operator name required in the query in
	// order to use the double property in sorting or as a facet. The
	// operator name can only contain lowercase letters (a-z). The maximum
	// length is 32 characters.
	OperatorName string `json:"operatorName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OperatorName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OperatorName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DoubleOperatorOptions) MarshalJSON() ([]byte, error) {
	type NoMethod DoubleOperatorOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DoublePropertyOptions: The options for double properties.
type DoublePropertyOptions struct {
	// OperatorOptions: If set, describes how the double should be used as a
	// search operator.
	OperatorOptions *DoubleOperatorOptions `json:"operatorOptions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OperatorOptions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OperatorOptions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DoublePropertyOptions) MarshalJSON() ([]byte, error) {
	type NoMethod DoublePropertyOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DoubleValues: List of double values.
type DoubleValues struct {
	Values []float64 `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Values") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DoubleValues) MarshalJSON() ([]byte, error) {
	type NoMethod DoubleValues
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DriveClientActionMarkup struct {
	RequestFileScope *RequestFileScope `json:"requestFileScope,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RequestFileScope") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RequestFileScope") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DriveClientActionMarkup) MarshalJSON() ([]byte, error) {
	type NoMethod DriveClientActionMarkup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DriveFollowUpRestrict: Drive follow-up search restricts (e.g.
// "followup:suggestions").
type DriveFollowUpRestrict struct {
	// Possible values:
	//   "UNSPECIFIED"
	//   "FOLLOWUP_SUGGESTIONS"
	//   "FOLLOWUP_ACTION_ITEMS"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DriveFollowUpRestrict) MarshalJSON() ([]byte, error) {
	type NoMethod DriveFollowUpRestrict
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DriveLocationRestrict: Drive location search restricts (e.g.
// "is:starred").
type DriveLocationRestrict struct {
	// Possible values:
	//   "UNSPECIFIED"
	//   "TRASHED"
	//   "STARRED"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DriveLocationRestrict) MarshalJSON() ([]byte, error) {
	type NoMethod DriveLocationRestrict
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DriveMetadata: Annotation metadata for Drive artifacts.
type DriveMetadata struct {
	AclFixRequest *AclFixRequest `json:"aclFixRequest,omitempty"`

	AclFixStatus *AclFixStatus `json:"aclFixStatus,omitempty"`

	// CanEdit: Can the current user edit this resource
	CanEdit bool `json:"canEdit,omitempty"`

	// CanShare: Can the current user share this resource
	CanShare bool `json:"canShare,omitempty"`

	// CanView: Can the current user view this resource
	CanView bool `json:"canView,omitempty"`

	// DriveAction: DriveAction for organizing this file in Drive. If the
	// user does not have access to the Drive file, the value will be
	// DriveAction.DRIVE_ACTION_UNSPECIFIED. This field is only set when
	// part of a FileResult in a ListFilesResponse.
	//
	// Possible values:
	//   "DRIVE_ACTION_UNSPECIFIED" - No organize action should be shown.
	//   "ADD_TO_DRIVE" - Show "Add to Drive" button, for adding file that
	// doesn't exist in Drive to Drive. Note that deleted Drive files that
	// still exist (i.e. in your Trash) will still be ORGANIZE (this is
	// consistent with Gmail Drive attachments).
	//   "ORGANIZE" - Show "Move" button, for organizing a Drive file the
	// user has permission to move.
	//   "ADD_SHORTCUT" - Show "Add shortcut" button, for adding a shortcut
	// to a Drive file the user does not have permission to move.
	//   "ADD_ANOTHER_SHORTCUT" - Show "Add another shortcut" button, for
	// Drive files the user has already created a shortcut to.
	DriveAction string `json:"driveAction,omitempty"`

	// Possible values:
	//   "DRIVE_STATE_UNSPECIFIED" - Default value
	//   "IN_MY_DRIVE" - File in My Drive
	//   "IN_TEAM_DRIVE" - File in Team Drive
	//   "SHARED_IN_DRIVE" - File in someone else's Drive, but is shared
	// with the current user
	//   "NOT_IN_DRIVE" - File not in drive
	DriveState string `json:"driveState,omitempty"`

	// EmbedUrl: Output only. Trusted Resource URL for drive file embedding.
	EmbedUrl *TrustedResourceUrlProto `json:"embedUrl,omitempty"`

	// EncryptedDocId: Indicates whether the Drive link contains an
	// encrypted doc ID. If true, Dynamite should not attempt to query the
	// doc ID in Drive Service. See go/docid-encryption for details.
	EncryptedDocId bool `json:"encryptedDocId,omitempty"`

	// EncryptedResourceKey: This is deprecated and unneeded. TODO
	// (b/182479059): Remove this.
	EncryptedResourceKey string `json:"encryptedResourceKey,omitempty"`

	// ExternalMimetype: External mimetype of the Drive Resource (Useful for
	// creating Drive URL) See: http://b/35219462
	ExternalMimetype string `json:"externalMimetype,omitempty"`

	// Id: Drive resource ID of the artifact.
	Id string `json:"id,omitempty"`

	// IsDownloadRestricted: Deprecated. Whether the setting to restrict
	// downloads is enabled for this file. This was previously used to
	// determine whether to hide the download and print buttons in the UI,
	// but is no longer used by clients, because Projector now independently
	// queries Drive to ensure that we have the most up-to-date value.
	IsDownloadRestricted bool `json:"isDownloadRestricted,omitempty"`

	// IsOwner: If the current user is the Drive file's owner. The field is
	// currently only set for Annotations for the ListFiles action (as
	// opposed to fetching Topics/Messages with Drive annotations).
	IsOwner bool `json:"isOwner,omitempty"`

	// LegacyUploadMetadata: Only present if this DriveMetadata is converted
	// from an UploadMetadata.
	LegacyUploadMetadata *LegacyUploadMetadata `json:"legacyUploadMetadata,omitempty"`

	// Mimetype: Mimetype of the Drive Resource
	Mimetype string `json:"mimetype,omitempty"`

	// OrganizationDisplayName: The display name of the organization owning
	// the Drive item.
	OrganizationDisplayName string `json:"organizationDisplayName,omitempty"`

	// ShortcutAuthorizedItemId: Shortcut ID of this drive file in the
	// shared drive, which is associated with a named room this file was
	// shared in. Shortcuts will not be created for DMs or unnamed rooms.
	// This is populated after the DriveMetadata is migrated to shared
	// drive. go/chat-shared-drive-uploads.
	ShortcutAuthorizedItemId *AuthorizedItemId `json:"shortcutAuthorizedItemId,omitempty"`

	// ShouldNotRender: If this field is set to true, server should still
	// contact external backends to get metadata for search but clients
	// should not render this chip.
	ShouldNotRender bool `json:"shouldNotRender,omitempty"`

	// ThumbnailHeight: Thumbnail image of the Drive Resource
	ThumbnailHeight int64 `json:"thumbnailHeight,omitempty"`

	// ThumbnailUrl: Thumbnail image of the Drive Resource
	ThumbnailUrl string `json:"thumbnailUrl,omitempty"`

	// ThumbnailWidth: Thumbnail image of the Drive Resource
	ThumbnailWidth int64 `json:"thumbnailWidth,omitempty"`

	// Title: Title of the Drive Resource
	Title string `json:"title,omitempty"`

	// UrlFragment: Url string fragment that generally indicates the
	// specific location in the linked file. Example: #header=h.123abc456.
	// If the fragment is not present this will not be present and therefore
	// default to an empty string. The "#" will not be included.
	UrlFragment string `json:"urlFragment,omitempty"`

	// WrappedResourceKey: This is considered SPII and should not be logged.
	WrappedResourceKey *WrappedResourceKey `json:"wrappedResourceKey,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AclFixRequest") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AclFixRequest") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DriveMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod DriveMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DriveMimeTypeRestrict: Drive mime-type search restricts (e.g.
// "type:pdf").
type DriveMimeTypeRestrict struct {
	// Possible values:
	//   "UNSPECIFIED"
	//   "PDF"
	//   "DOCUMENT"
	//   "PRESENTATION"
	//   "SPREADSHEET"
	//   "FORM"
	//   "DRAWING"
	//   "SCRIPT"
	//   "MAP"
	//   "IMAGE"
	//   "AUDIO"
	//   "VIDEO"
	//   "FOLDER"
	//   "ARCHIVE"
	//   "SITE"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DriveMimeTypeRestrict) MarshalJSON() ([]byte, error) {
	type NoMethod DriveMimeTypeRestrict
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DriveTimeSpanRestrict: The time span search restrict (e.g.
// "after:2017-09-11 before:2017-09-12").
type DriveTimeSpanRestrict struct {
	// Possible values:
	//   "UNSPECIFIED"
	//   "TODAY"
	//   "YESTERDAY"
	//   "LAST_7_DAYS"
	//   "LAST_30_DAYS" - Not Enabled
	//   "LAST_90_DAYS" - Not Enabled
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DriveTimeSpanRestrict) MarshalJSON() ([]byte, error) {
	type NoMethod DriveTimeSpanRestrict
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DynamiteMessagesScoringInfo: This is the proto for holding message
// level scoring information. This data is used for logging in query-api
// server and for testing purposes.
type DynamiteMessagesScoringInfo struct {
	CommonContactCount int64 `json:"commonContactCount,omitempty,string"`

	CommonCountToContactListCountRatio float64 `json:"commonCountToContactListCountRatio,omitempty"`

	CommonCountToMembershipCountRatio float64 `json:"commonCountToMembershipCountRatio,omitempty"`

	CreatorGaiaId int64 `json:"creatorGaiaId,omitempty,string"`

	CreatorInSearcherContactList bool `json:"creatorInSearcherContactList,omitempty"`

	DasContactCount int64 `json:"dasContactCount,omitempty,string"`

	FinalScore float64 `json:"finalScore,omitempty"`

	FreshnessScore float64 `json:"freshnessScore,omitempty"`

	JoinedSpaceAffinityScore float64 `json:"joinedSpaceAffinityScore,omitempty"`

	LastReadTimestampAgeInDays float64 `json:"lastReadTimestampAgeInDays,omitempty"`

	MessageAgeInDays float64 `json:"messageAgeInDays,omitempty"`

	MessageSenderAffinityScore float64 `json:"messageSenderAffinityScore,omitempty"`

	SpaceId int64 `json:"spaceId,omitempty,string"`

	SpaceMembershipCount int64 `json:"spaceMembershipCount,omitempty,string"`

	TopicalityScore float64 `json:"topicalityScore,omitempty"`

	UnjoinedSpaceAffinityScore float64 `json:"unjoinedSpaceAffinityScore,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonContactCount")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonContactCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DynamiteMessagesScoringInfo) MarshalJSON() ([]byte, error) {
	type NoMethod DynamiteMessagesScoringInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *DynamiteMessagesScoringInfo) UnmarshalJSON(data []byte) error {
	type NoMethod DynamiteMessagesScoringInfo
	var s1 struct {
		CommonCountToContactListCountRatio gensupport.JSONFloat64 `json:"commonCountToContactListCountRatio"`
		CommonCountToMembershipCountRatio  gensupport.JSONFloat64 `json:"commonCountToMembershipCountRatio"`
		FinalScore                         gensupport.JSONFloat64 `json:"finalScore"`
		FreshnessScore                     gensupport.JSONFloat64 `json:"freshnessScore"`
		JoinedSpaceAffinityScore           gensupport.JSONFloat64 `json:"joinedSpaceAffinityScore"`
		LastReadTimestampAgeInDays         gensupport.JSONFloat64 `json:"lastReadTimestampAgeInDays"`
		MessageAgeInDays                   gensupport.JSONFloat64 `json:"messageAgeInDays"`
		MessageSenderAffinityScore         gensupport.JSONFloat64 `json:"messageSenderAffinityScore"`
		TopicalityScore                    gensupport.JSONFloat64 `json:"topicalityScore"`
		UnjoinedSpaceAffinityScore         gensupport.JSONFloat64 `json:"unjoinedSpaceAffinityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CommonCountToContactListCountRatio = float64(s1.CommonCountToContactListCountRatio)
	s.CommonCountToMembershipCountRatio = float64(s1.CommonCountToMembershipCountRatio)
	s.FinalScore = float64(s1.FinalScore)
	s.FreshnessScore = float64(s1.FreshnessScore)
	s.JoinedSpaceAffinityScore = float64(s1.JoinedSpaceAffinityScore)
	s.LastReadTimestampAgeInDays = float64(s1.LastReadTimestampAgeInDays)
	s.MessageAgeInDays = float64(s1.MessageAgeInDays)
	s.MessageSenderAffinityScore = float64(s1.MessageSenderAffinityScore)
	s.TopicalityScore = float64(s1.TopicalityScore)
	s.UnjoinedSpaceAffinityScore = float64(s1.UnjoinedSpaceAffinityScore)
	return nil
}

// DynamiteSpacesScoringInfo: This is the proto for holding space level
// scoring information. This data is used for logging in query-api
// server and for testing purposes.
type DynamiteSpacesScoringInfo struct {
	AffinityScore float64 `json:"affinityScore,omitempty"`

	CommonContactCountAffinityScore float64 `json:"commonContactCountAffinityScore,omitempty"`

	ContactsIntersectionCount float64 `json:"contactsIntersectionCount,omitempty"`

	FinalScore float64 `json:"finalScore,omitempty"`

	FreshnessScore float64 `json:"freshnessScore,omitempty"`

	JoinedSpacesAffinityScore float64 `json:"joinedSpacesAffinityScore,omitempty"`

	LastMessagePostedTimestampSecs int64 `json:"lastMessagePostedTimestampSecs,omitempty,string"`

	LastReadTimestampSecs int64 `json:"lastReadTimestampSecs,omitempty,string"`

	MemberMetadataCount float64 `json:"memberMetadataCount,omitempty"`

	MessageScore float64 `json:"messageScore,omitempty"`

	NumAucContacts int64 `json:"numAucContacts,omitempty,string"`

	SmallContactListAffinityScore float64 `json:"smallContactListAffinityScore,omitempty"`

	SmallUnjoinedSpacesAffinityScore float64 `json:"smallUnjoinedSpacesAffinityScore,omitempty"`

	SpaceAgeInDays float64 `json:"spaceAgeInDays,omitempty"`

	SpaceCreationTimestampSecs int64 `json:"spaceCreationTimestampSecs,omitempty,string"`

	TopicalityScore float64 `json:"topicalityScore,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AffinityScore") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AffinityScore") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DynamiteSpacesScoringInfo) MarshalJSON() ([]byte, error) {
	type NoMethod DynamiteSpacesScoringInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *DynamiteSpacesScoringInfo) UnmarshalJSON(data []byte) error {
	type NoMethod DynamiteSpacesScoringInfo
	var s1 struct {
		AffinityScore                    gensupport.JSONFloat64 `json:"affinityScore"`
		CommonContactCountAffinityScore  gensupport.JSONFloat64 `json:"commonContactCountAffinityScore"`
		ContactsIntersectionCount        gensupport.JSONFloat64 `json:"contactsIntersectionCount"`
		FinalScore                       gensupport.JSONFloat64 `json:"finalScore"`
		FreshnessScore                   gensupport.JSONFloat64 `json:"freshnessScore"`
		JoinedSpacesAffinityScore        gensupport.JSONFloat64 `json:"joinedSpacesAffinityScore"`
		MemberMetadataCount              gensupport.JSONFloat64 `json:"memberMetadataCount"`
		MessageScore                     gensupport.JSONFloat64 `json:"messageScore"`
		SmallContactListAffinityScore    gensupport.JSONFloat64 `json:"smallContactListAffinityScore"`
		SmallUnjoinedSpacesAffinityScore gensupport.JSONFloat64 `json:"smallUnjoinedSpacesAffinityScore"`
		SpaceAgeInDays                   gensupport.JSONFloat64 `json:"spaceAgeInDays"`
		TopicalityScore                  gensupport.JSONFloat64 `json:"topicalityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AffinityScore = float64(s1.AffinityScore)
	s.CommonContactCountAffinityScore = float64(s1.CommonContactCountAffinityScore)
	s.ContactsIntersectionCount = float64(s1.ContactsIntersectionCount)
	s.FinalScore = float64(s1.FinalScore)
	s.FreshnessScore = float64(s1.FreshnessScore)
	s.JoinedSpacesAffinityScore = float64(s1.JoinedSpacesAffinityScore)
	s.MemberMetadataCount = float64(s1.MemberMetadataCount)
	s.MessageScore = float64(s1.MessageScore)
	s.SmallContactListAffinityScore = float64(s1.SmallContactListAffinityScore)
	s.SmallUnjoinedSpacesAffinityScore = float64(s1.SmallUnjoinedSpacesAffinityScore)
	s.SpaceAgeInDays = float64(s1.SpaceAgeInDays)
	s.TopicalityScore = float64(s1.TopicalityScore)
	return nil
}

// EditMetadata: A message edit in Dynamite inserts a Babel-only item
// containing this field.
type EditMetadata struct {
}

type EditorClientActionMarkup struct {
	RequestFileScopeForActiveDocument *RequestFileScopeForActiveDocument `json:"requestFileScopeForActiveDocument,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "RequestFileScopeForActiveDocument") to unconditionally include in
	// API requests. By default, fields with empty or default values are
	// omitted from API requests. However, any non-pointer, non-interface
	// field appearing in ForceSendFields will be sent to the server
	// regardless of whether the field is empty or not. This may be used to
	// include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "RequestFileScopeForActiveDocument") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EditorClientActionMarkup) MarshalJSON() ([]byte, error) {
	type NoMethod EditorClientActionMarkup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EmailAddress: A person's email address.
type EmailAddress struct {
	// CustomType: If the value of type is custom, this property contains
	// the custom type string.
	CustomType string `json:"customType,omitempty"`

	// EmailAddress: The email address.
	EmailAddress string `json:"emailAddress,omitempty"`

	// EmailUrl: The URL to send email.
	EmailUrl string `json:"emailUrl,omitempty"`

	// Primary: Indicates if this is the user's primary email. Only one
	// entry can be marked as primary.
	Primary bool `json:"primary,omitempty"`

	// Type: The type of the email account. Acceptable values are: "custom",
	// "home", "other", "work".
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CustomType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EmailAddress) MarshalJSON() ([]byte, error) {
	type NoMethod EmailAddress
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EmailOwnerProto: Represents a verified owner of the given email
// address. Note that a single address may have many owners, and a
// single user may own many addresses. (All lower-case, in display form
// -- see com.google.gaia.client.GaiaEmail)
type EmailOwnerProto struct {
	Email string `json:"email,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Email") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EmailOwnerProto) MarshalJSON() ([]byte, error) {
	type NoMethod EmailOwnerProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EmbedClientItem: Represents an embedded object in an update. This is
// a wrapper class that can contain a single specific item proto in an
// extension field. Think of it as a base class like `Message` in Java.
// Each item proto must declare that it extends this proto: message
// ExampleObject { option (item_type) = EXAMPLE_OBJECT; extend
// EmbedClientItem { optional ExampleObject example_object = ; } } See
// go/es-embeds for details.
type EmbedClientItem struct {
	// CanonicalId: The canonical ID of the embed. If absent, the canonical
	// ID is equal to the ID; if present, then the canonical ID represents
	// an "equivalence class" of embeds which really refer to the same
	// object. (For example, the URLs http://www.foo.com/ and
	// http://foo.com/ refer to the same object) This field may be updated
	// periodically by background processes.
	CanonicalId string `json:"canonicalId,omitempty"`

	// DeepLinkData: Deep-linking data to take the user to the right place
	// in a mobile app. This is only used for preview and attribution. Links
	// that are specific to a given embed type should live on that specific
	// embed's proto by using Link. See
	// http://goto.google.com/mariana-design.
	DeepLinkData *DeepLinkData `json:"deepLinkData,omitempty"`

	// Id: The ID of the embed. This corresponds to the schema.org ID, as
	// represented in the ItemScope.id field.
	Id string `json:"id,omitempty"`

	// Provenance: The provenance of the embed, populated when the embed
	// originated from a web fetch. The provenance captures information
	// about the web page the embed had originated, like the URL that was
	// retrieved and the retrieved URL's canonical form. This is useful in
	// the case where the URL shared by the URL redirects (e.g., in the case
	// of a shortened URL).
	Provenance *Provenance `json:"provenance,omitempty"`

	// RenderId: The ID used to identify the embed during rendering. This
	// field will match ID, if set, otherwise it will be the ID of the
	// parent activity. This field is only populated on the server for
	// client use and is not persisted to storage.
	RenderId string `json:"renderId,omitempty"`

	// Signature: Signature of the embed, used for verification.
	Signature string `json:"signature,omitempty"`

	// TransientData: Transient generic data that will not be saved on the
	// server.
	TransientData *TransientData `json:"transientData,omitempty"`

	// Type: The first value in `type` determines which extension field will
	// be set. When creating an EmbedClientItem, you only need to set the
	// first (primary) type in this field. When the server receives the
	// item, it will populate the full type list using the parent
	// annotations in the ItemType enum.
	//
	// Possible values:
	//   "UNKNOWN" - Largely deprecated, effectively an error condition and
	// should not be in storage.
	//   "ACTION_V2" - Embeds V2 types
	//   "ADD_ACTION_V2"
	//   "AGGREGATE_RATING_V2"
	//   "ARTICLE_V2"
	//   "ASSESS_ACTION_V2"
	//   "AUDIO_OBJECT_V2"
	//   "BASIC_INTERACTION_V2"
	//   "BLOG_POSTING_V2"
	//   "BLOG_V2"
	//   "BOOK_V2"
	//   "BUY_ACTION_V2"
	//   "CHECK_IN_ACTION_V2" - The action of checking in, as opposed to a
	// "check-in".
	//   "CHECKIN_V2"
	//   "COLLEXION_V2"
	//   "COMMENT_ACTION_V2" - The act of commenting, which might result in
	// a comment.
	//   "COMMENT_V2"
	//   "COMMUNICATE_ACTION_V2"
	//   "CONSUME_ACTION_V2"
	//   "CREATE_ACTION_V2"
	//   "CREATIVE_WORK_V2"
	//   "DISCOVER_ACTION_V2"
	//   "DOCUMENT_OBJECT_V2"
	//   "DRAWING_OBJECT_V2"
	//   "DRIVE_OBJECT_V2"
	//   "EMOTISHARE_V2"
	//   "ENTRY_POINT_V2"
	//   "EVENT_TIME_V2"
	//   "EVENT_V2"
	//   "FILE_OBJECT_V2"
	//   "FIND_ACTION_V2"
	//   "FINANCIAL_QUOTE_V2"
	//   "FORM_OBJECT_V2"
	//   "GEO_COORDINATES_V2"
	//   "GOOGLE_OFFER_V2"
	//   "HANGOUT_CHAT_MESSAGE"
	//   "HANGOUT_QUOTE"
	//   "HANGOUT_V2"
	//   "HOA_PLUS_EVENT_V2"
	//   "IMAGE_OBJECT_V2"
	//   "INTERACT_ACTION_V2"
	//   "INTERACTION_V2"
	//   "LISTEN_ACTION_V2"
	//   "LOCAL_BUSINESS_V2"
	//   "LOCAL_PLUS_PHOTO_ALBUM_V2"
	//   "MAGAZINE_V2"
	//   "MEDIA_OBJECT_V2"
	//   "MOBILE_APPLICATION_V2"
	//   "MOVIE_V2"
	//   "MUSIC_ALBUM_V2"
	//   "MUSIC_GROUP_V2"
	//   "MUSIC_PLAYLIST_V2"
	//   "MUSIC_RECORDING_V2"
	//   "NEWS_ARTICLE_V2"
	//   "OFFER_V2"
	//   "ORGANIZATION_V2"
	//   "ORGANIZE_ACTION_V2"
	//   "PERSON_V2"
	//   "PLACE_REVIEW_V2"
	//   "PLACE_V2"
	//   "PLAN_ACTION_V2"
	//   "PLAY_MUSIC_ALBUM_V2"
	//   "PLAY_MUSIC_TRACK_V2"
	//   "PLAY_OBJECT_V2"
	//   "PLUS_AUDIO_V2"
	//   "PLUS_EVENT_V2"
	//   "PLUS_MEDIA_COLLECTION_V2"
	//   "PLUS_MEDIA_OBJECT_V2"
	//   "PLUS_PAGE_V2"
	//   "PLUS_PHOTOS_ADDED_TO_COLLECTION_V2"
	//   "PLUS_PHOTO_ALBUM_V2"
	//   "PLUS_PHOTO_COLLECTION_V2"
	//   "PLUS_PHOTO_V2"
	//   "PLUS_POST_V2"
	//   "PLUS_RESHARE_V2"
	//   "PLUS_SOFTWARE_APPLICATION_V2"
	//   "POLL_OPTION_V2"
	//   "POLL_V2"
	//   "POSTAL_ADDRESS_V2"
	//   "PRESENTATION_OBJECT_V2"
	//   "PRODUCT_REVIEW_V2"
	//   "RATING_V2"
	//   "REACT_ACTION_V2"
	//   "RESERVATION_V2"
	//   "RESERVE_ACTION_V2"
	//   "REVIEW_V2"
	//   "REVIEW_ACTION_V2"
	//   "SOFTWARE_APPLICATION_V2"
	//   "SPREADSHEET_OBJECT_V2"
	//   "SQUARE_INVITE_V2"
	//   "SQUARE_V2"
	//   "STICKER_V2"
	//   "STORY_V2" - Boswell story (see goto/boswell)
	//   "THING_V2"
	//   "TRADE_ACTION_V2"
	//   "DEPRECATED_TOUR_OBJECT_V2"
	//   "TV_EPISODE_V2"
	//   "TV_SERIES_V2"
	//   "UPDATE_ACTION_V2"
	//   "VIEW_ACTION_V2"
	//   "VIDEO_OBJECT_V2"
	//   "VIDEO_GALLERY_V2"
	//   "WANT_ACTION_V2"
	//   "WEB_PAGE_V2"
	//   "WRITE_ACTION_V2"
	//   "YOUTUBE_CHANNEL_V2"
	//   "GOOGLE_USER_PHOTO_V2" - A photo stored in photo service owned by a
	// Google account user. This is distinct from PlusPhoto as it isn't tied
	// to GPlus, but is instead intended to be a more general photo tied to
	// a google user.
	//   "GOOGLE_USER_PHOTO_ALBUM" - A photo album in photo service owned by
	// a Google account user. This is distinct from PlusPhotoAlbum as it
	// isn't tied to GPlus, but is instead intended to be a general photo
	// album tied to a google user.
	//   "GOOGLE_PHOTO_RECIPE" - An embed used to create a single photo in
	// photo service. This type is never stored but is used to create a
	// GOOGLE_USER_PHOTO_V2 or PLUS_PHOTO_V2 embed.
	//   "THING" - Embeds V1 types
	//   "CREATIVE_WORK"
	//   "EVENT"
	//   "INTANGIBLE"
	//   "ORGANIZATION"
	//   "PERSON"
	//   "PLACE"
	//   "PRODUCT"
	//   "ARTICLE" - CREATIVE_WORK subtypes
	//   "BLOG_POSTING"
	//   "NEWS_ARTICLE"
	//   "SCHOLARLY_ARTICLE"
	//   "BLOG"
	//   "BOOK"
	//   "COMMENT"
	//   "ITEM_LIST"
	//   "MAP"
	//   "MEDIA_OBJECT"
	//   "AUDIO_OBJECT"
	//   "IMAGE_OBJECT"
	//   "MUSIC_VIDEO_OBJECT"
	//   "VIDEO_OBJECT"
	//   "MOVIE"
	//   "MUSIC_PLAYLIST"
	//   "MUSIC_ALBUM"
	//   "MUSIC_RECORDING"
	//   "PAINTING"
	//   "PHOTOGRAPH"
	//   "RECIPE"
	//   "REVIEW"
	//   "SCULPTURE"
	//   "SOFTWARE_APPLICATION"
	//   "MOBILE_APPLICATION"
	//   "WEB_APPLICATION"
	//   "TV_EPISODE"
	//   "TV_SEASON"
	//   "TV_SERIES"
	//   "WEB_PAGE"
	//   "ABOUT_PAGE"
	//   "CHECKOUT_PAGE"
	//   "COLLECTION_PAGE"
	//   "IMAGE_GALLERY"
	//   "VIDEO_GALLERY"
	//   "CONTACT_PAGE"
	//   "ITEM_PAGE"
	//   "PROFILE_PAGE"
	//   "SEARCH_RESULTS_PAGE"
	//   "WEB_PAGE_ELEMENT"
	//   "SITE_NAVIGATION_ELEMENT"
	//   "TABLE"
	//   "WP_AD_BLOCK"
	//   "WP_FOOTER"
	//   "WP_HEADER"
	//   "WP_SIDEBAR"
	//   "APP_INVITE"
	//   "EMOTISHARE"
	//   "BUSINESS_EVENT" - EVENT subtypes
	//   "CHILDRENS_EVENT"
	//   "COMEDY_EVENT"
	//   "DANCE_EVENT"
	//   "EDUCATION_EVENT"
	//   "FESTIVAL"
	//   "FOOD_EVENT"
	//   "LITERARY_EVENT"
	//   "MUSIC_EVENT"
	//   "SALE_EVENT"
	//   "SOCIAL_EVENT"
	//   "SPORTS_EVENT"
	//   "THEATER_EVENT"
	//   "VISUAL_ARTS_EVENT"
	//   "RESERVATION"
	//   "TRAVEL_EVENT"
	//   "CORPORATION" - ORGANIZATION subtypes
	//   "EDUCATIONAL_ORGANIZATION"
	//   "COLLEGE_OR_UNIVERSITY"
	//   "ELEMENTARY_SCHOOL"
	//   "HIGH_SCHOOL"
	//   "MIDDLE_SCHOOL"
	//   "PRESCHOOL"
	//   "SCHOOL"
	//   "GOVERNMENT_ORGANIZATION"
	//   "LOCAL_BUSINESS"
	//   "ANIMAL_SHELTER"
	//   "AUTOMOTIVE_BUSINESS"
	//   "AUTO_BODY_SHOP"
	//   "AUTO_DEALER"
	//   "AUTO_PARTS_STORE"
	//   "AUTO_RENTAL"
	//   "AUTO_REPAIR"
	//   "AUTO_WASH"
	//   "GAS_STATION"
	//   "MOTORCYCLE_DEALER"
	//   "MOTORCYCLE_REPAIR"
	//   "CHILD_CARE"
	//   "DRY_CLEANING_OR_LAUNDRY"
	//   "EMERGENCY_SERVICE"
	//   "FIRE_STATION"
	//   "HOSPITAL"
	//   "POLICE_STATION"
	//   "EMPLOYMENT_AGENGY"
	//   "ENTERTAINMENT_BUSINESS"
	//   "ADULT_ENTERTAINMENT"
	//   "AMUSEMENT_PARK"
	//   "ART_GALLERY"
	//   "CASINO"
	//   "COMEDY_CLUB"
	//   "MOVIE_THEATER"
	//   "NIGHT_CLUB"
	//   "FINANCIAL_SERVICE"
	//   "ACCOUNTING_SERVICE"
	//   "AUTOMATED_TELLER"
	//   "BANK_OR_CREDIT_UNION"
	//   "INSURANCE_AGENCY"
	//   "FOOD_ESTABLISHMENT"
	//   "BAKERY"
	//   "BAR_OR_PUB"
	//   "BREWERY"
	//   "CAFE_OR_COFFEE_SHOP"
	//   "FAST_FOOD_RESTAURANT"
	//   "ICE_CREAM_SHOP"
	//   "RESTAURANT"
	//   "WINERY"
	//   "GOVERNMENT_OFFICE"
	//   "POST_OFFICE"
	//   "HEALTH_AND_BEAUTY_BUSINESS"
	//   "BEAUTY_SALON"
	//   "DAY_SPA"
	//   "HAIR_SALON"
	//   "HEALTH_CLUB"
	//   "NAIL_SALON"
	//   "TATTOO_PARLOR"
	//   "HOME_AND_CONSTRUCTION_BUSINESS"
	//   "ELECTRICIAN"
	//   "GENERAL_CONTRACTOR"
	//   "HVAC_BUSINESS"
	//   "HOUSE_PAINTER"
	//   "LOCKSMITH"
	//   "MOVING_COMPANY"
	//   "PLUMBER"
	//   "ROOFING_CONTRACTOR"
	//   "INTERNET_CAFE"
	//   "LIBRARY"
	//   "LODGING_BUSINESS"
	//   "BED_AND_BREAKFAST"
	//   "HOSTEL"
	//   "HOTEL"
	//   "MOTEL"
	//   "MEDICAL_ORGANIZATION"
	//   "DENTIST"
	//   "MEDICAL_CLINIC"
	//   "OPTICIAN"
	//   "PHARMACY"
	//   "PHYSICIAN"
	//   "VETERINARY_CARE"
	//   "PROFESSIONAL_SERVICE"
	//   "ATTORNEY"
	//   "NOTARY"
	//   "RADIO_STATION"
	//   "REAL_ESTATE_AGENT"
	//   "RECYCLING_CENTER"
	//   "SELF_STORAGE"
	//   "SHOPPING_CENTER"
	//   "SPORTS_ACTIVITY_LOCATION"
	//   "BOWLING_ALLEY"
	//   "EXERCISE_GYM"
	//   "GOLF_COURSE"
	//   "PUBLIC_SWIMMING_POOL"
	//   "SKI_RESORT"
	//   "SPORTS_CLUB"
	//   "STADIUM_OR_ARENA"
	//   "TENNIS_COMPLEX"
	//   "STORE"
	//   "BIKE_STORE"
	//   "BOOK_STORE"
	//   "CLOTHING_STORE"
	//   "COMPUTER_STORE"
	//   "CONVENIENCE_STORE"
	//   "DEPARTMENT_STORE"
	//   "ELECTRONICS_STORE"
	//   "FLORIST"
	//   "FURNITURE_STORE"
	//   "GARDEN_STORE"
	//   "GROCERY_STORE"
	//   "HARDWARE_STORE"
	//   "HOBBY_SHOP"
	//   "HOME_GOODS_STORE"
	//   "JEWELRY_STORE"
	//   "LIQUOR_STORE"
	//   "MENS_CLOTHING_STORE"
	//   "MOBILE_PHONE_STORE"
	//   "MOVIE_RENTAL_STORE"
	//   "MUSIC_STORE"
	//   "OFFICE_EQUIPMENT_STORE"
	//   "OUTLET_STORE"
	//   "PAWN_SHOP"
	//   "PET_STORE"
	//   "SHOE_STORE"
	//   "SPORTING_GOODS_STORE"
	//   "TIRE_SHOP"
	//   "TOY_STORE"
	//   "WHOLESALE_STORE"
	//   "TELEVISION_STATION"
	//   "TOURIST_INFORMATION_CENTER"
	//   "TRAVEL_AGENCY"
	//   "PERFORMING_GROUP"
	//   "MUSIC_GROUP"
	//   "ADMINISTRATIVE_AREA" - PLACE subtypes
	//   "CITY"
	//   "COUNTRY"
	//   "STATE"
	//   "CIVIC_STRUCTURE"
	//   "AIRPORT"
	//   "AQUARIUM"
	//   "BEACH"
	//   "BUS_STATION"
	//   "BUS_STOP"
	//   "CAMPGROUND"
	//   "CEMETERY"
	//   "CREMATORIUM"
	//   "EVENT_VENUE"
	//   "GOVERNMENT_BUILDING"
	//   "CITY_HALL"
	//   "COURTHOUSE"
	//   "DEFENCE_ESTABLISHMENT"
	//   "EMBASSY"
	//   "LEGISLATIVE_BUILDING"
	//   "MUSEUM"
	//   "MUSIC_VENUE"
	//   "PARK"
	//   "PARKING_FACILITY"
	//   "PERFORMING_ARTS_THEATER"
	//   "PLACE_OF_WORSHIP"
	//   "BUDDHIST_TEMPLE"
	//   "CATHOLIC_CHURCH"
	//   "CHURCH"
	//   "HINDU_TEMPLE"
	//   "MOSQUE"
	//   "SYNAGOGUE"
	//   "PLAYGROUND"
	//   "R_V_PARK"
	//   "RESIDENCE"
	//   "APARTMENT_COMPLEX"
	//   "GATED_RESIDENCE_COMMUNITY"
	//   "SINGLE_FAMILY_RESIDENCE"
	//   "TOURIST_ATTRACTION"
	//   "SUBWAY_STATION"
	//   "TAXI_STAND"
	//   "TRAIN_STATION"
	//   "ZOO"
	//   "LANDFORM"
	//   "BODY_OF_WATER"
	//   "CANAL"
	//   "LAKE_BODY_OF_WATER"
	//   "OCEAN_BODY_OF_WATER"
	//   "POND"
	//   "RESERVOIR"
	//   "RIVER_BODY_OF_WATER"
	//   "SEA_BODY_OF_WATER"
	//   "WATERFALL"
	//   "CONTINENT"
	//   "MOUNTAIN"
	//   "VOLCANO"
	//   "LANDMARKS_OR_HISTORICAL_BUILDINGS"
	//   "USER_INTERACTION" - NOTE(jpanzer): This is a badly designed
	// hierarchy and we should avoid depending on Event properties inside
	// UserInteractions as much as possible IMHO.
	//   "USER_PLUS_ONES"
	//   "ENUMERATION" - Intangibles, primarily used as sub-objects of other
	// types
	//   "BOOK_FORMAT_TYPE"
	//   "ITEM_AVAILABILITY"
	//   "OFFER_ITEM_CONDITION"
	//   "JOB_POSTING"
	//   "LANGUAGE"
	//   "OFFER"
	//   "QUANTITY"
	//   "DISTANCE"
	//   "DURATION"
	//   "ENERGY"
	//   "MASS"
	//   "RATING"
	//   "AGGREGATE_RATING"
	//   "STRUCTURED_VALUE"
	//   "CONTACT_POINT"
	//   "POSTAL_ADDRESS"
	//   "GEO_COORDINATES"
	//   "GEO_SHAPE"
	//   "NUTRITION_INFORMATION"
	//   "PRESENTATION_OBJECT" - CREATIVE_WORK extensions
	//   "DOCUMENT_OBJECT"
	//   "SPREADSHEET_OBJECT"
	//   "FORM_OBJECT"
	//   "DRAWING_OBJECT"
	//   "PLACE_REVIEW"
	//   "FILE_OBJECT"
	//   "PLAY_MUSIC_TRACK"
	//   "PLAY_MUSIC_ALBUM"
	//   "MAGAZINE"
	//   "CAROUSEL_FRAME" - Single frame for http://goto/carousel.
	//   "PLUS_EVENT" - EVENT extensions
	//   "HANGOUT" - No declared proto. Used only as a base type for now.
	//   "HANGOUT_BROADCAST"
	//   "HANGOUT_CONSUMER"
	//   "CHECKIN"
	//   "EXAMPLE_OBJECT"
	//   "SQUARE" - NOTE(melchang): These correspond to
	// http://schema.org/WebPage/Community and
	// http://schema.org/WebPage/CommunityInvite. See b/7653610 for why
	// these are "SQUARE" and not "COMMUNITY".
	//   "SQUARE_INVITE"
	//   "PLUS_PHOTO"
	//   "PLUS_PHOTO_ALBUM"
	//   "LOCAL_PLUS_PHOTO_ALBUM"
	//   "PRODUCT_REVIEW"
	//   "FINANCIAL_QUOTE"
	//   "DEPRECATED_TOUR_OBJECT"
	//   "PLUS_PAGE"
	//   "GOOGLE_CHART" - Data visualizations. See
	// http://code.google.com/apis/chart/index.html
	//   "PLUS_PHOTOS_ADDED_TO_COLLECTION"
	//   "RECOMMENDED_PEOPLE" - A collection of people that have been
	// recommended to a user.
	//   "PLUS_POST" - A Google+ post.
	//   "DATE" - An http://schema.org/Date unstructured ISO-8859 timestamp
	// string.
	//   "DRIVE_OBJECT_COLLECTION" - Embed representing a collection of
	// multiple Drive objects.
	//   "NEWS_MEDIA_ORGANIZATION" -
	// https://schema.org/NewsMediaOrganization
	//   "DYNAMITE_ATTACHMENT_METADATA" - Deprecated in favor of
	// DYNAMITE_MESSAGE_METADATA
	//   "DYNAMITE_MESSAGE_METADATA" - Used for Dynamite message metadata in
	// Hangouts
	Type []string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanonicalId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanonicalId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EmbedClientItem) MarshalJSON() ([]byte, error) {
	type NoMethod EmbedClientItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EnumOperatorOptions: Used to provide a search operator for enum
// properties. This is optional. Search operators let users restrict the
// query to specific fields relevant to the type of item being searched.
// For example, if you provide no operator for a *priority* enum
// property with possible values *p0* and *p1*, a query that contains
// the term *p0* returns items that have *p0* as the value of the
// *priority* property, as well as any items that contain the string
// *p0* in other fields. If you provide an operator name for the enum,
// such as *priority*, then search users can use that operator to refine
// results to only items that have *p0* as this property's value, with
// the query *priority:p0*.
type EnumOperatorOptions struct {
	// OperatorName: Indicates the operator name required in the query in
	// order to isolate the enum property. For example, if operatorName is
	// *priority* and the property's name is *priorityVal*, then queries
	// like *priority:<value>* show results only where the value of the
	// property named *priorityVal* matches *<value>*. By contrast, a search
	// that uses the same *<value>* without an operator returns all items
	// where *<value>* matches the value of any String properties or text
	// within the content field for the item. The operator name can only
	// contain lowercase letters (a-z). The maximum length is 32 characters.
	OperatorName string `json:"operatorName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OperatorName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OperatorName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EnumOperatorOptions) MarshalJSON() ([]byte, error) {
	type NoMethod EnumOperatorOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EnumPropertyOptions: The options for enum properties, which allow you
// to define a restricted set of strings to match user queries, set
// rankings for those string values, and define an operator name to be
// paired with those strings so that users can narrow results to only
// items with a specific value. For example, for items in a request
// tracking system with priority information, you could define *p0* as
// an allowable enum value and tie this enum to the operator name
// *priority* so that search users could add *priority:p0* to their
// query to restrict the set of results to only those items indexed with
// the value *p0*.
type EnumPropertyOptions struct {
	// OperatorOptions: If set, describes how the enum should be used as a
	// search operator.
	OperatorOptions *EnumOperatorOptions `json:"operatorOptions,omitempty"`

	// OrderedRanking: Used to specify the ordered ranking for the
	// enumeration that determines how the integer values provided in the
	// possible EnumValuePairs are used to rank results. If specified,
	// integer values must be provided for all possible EnumValuePair values
	// given for this property. Can only be used if isRepeatable is false.
	//
	// Possible values:
	//   "NO_ORDER" - There is no ranking order for the property. Results
	// aren't adjusted by this property's value.
	//   "ASCENDING" - This property is ranked in ascending order. Lower
	// values indicate lower ranking.
	//   "DESCENDING" - This property is ranked in descending order. Lower
	// values indicate higher ranking.
	OrderedRanking string `json:"orderedRanking,omitempty"`

	// PossibleValues: The list of possible values for the enumeration
	// property. All EnumValuePairs must provide a string value. If you
	// specify an integer value for one EnumValuePair, then all possible
	// EnumValuePairs must provide an integer value. Both the string value
	// and integer value must be unique over all possible values. Once set,
	// possible values cannot be removed or modified. If you supply an
	// ordered ranking and think you might insert additional enum values in
	// the future, leave gaps in the initial integer values to allow adding
	// a value in between previously registered values. The maximum number
	// of elements is 100.
	PossibleValues []*EnumValuePair `json:"possibleValues,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OperatorOptions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OperatorOptions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *EnumPropertyOptions) MarshalJSON() ([]byte, error) {
	type NoMethod EnumPropertyOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EnumValuePair: The enumeration value pair defines two things: a
// required string value and an optional integer value. The string value
// defines the necessary query term required to retrieve that item, such
// as *p0* for a priority item. The integer value determines the ranking
// of that string value relative to other enumerated values for the same
// property. For example, you might associate *p0* with *0* and define
// another enum pair such as *p1* and *1*. You must use the integer
// value in combination with ordered ranking to set the ranking of a
// given value relative to other enumerated values for the same property
// name. Here, a ranking order of DESCENDING for *priority* properties
// results in a ranking boost for items indexed with a value of *p0*
// compared to items indexed with a value of *p1*. Without a specified
// ranking order, the integer value has no effect on item ranking.
type EnumValuePair struct {
	// IntegerValue: The integer value of the EnumValuePair which must be
	// non-negative. Optional.
	IntegerValue int64 `json:"integerValue,omitempty"`

	// StringValue: The string value of the EnumValuePair. The maximum
	// length is 32 characters.
	StringValue string `json:"stringValue,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IntegerValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IntegerValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EnumValuePair) MarshalJSON() ([]byte, error) {
	type NoMethod EnumValuePair
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EnumValues: List of enum values.
type EnumValues struct {
	// Values: The maximum allowable length for string values is 32
	// characters.
	Values []string `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Values") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EnumValues) MarshalJSON() ([]byte, error) {
	type NoMethod EnumValues
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ErrorInfo: Error information about the response.
type ErrorInfo struct {
	ErrorMessages []*ErrorMessage `json:"errorMessages,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorMessages") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorMessages") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ErrorInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ErrorInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ErrorMessage: Error message per source response.
type ErrorMessage struct {
	ErrorMessage string `json:"errorMessage,omitempty"`

	Source *Source `json:"source,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorMessage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorMessage") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ErrorMessage) MarshalJSON() ([]byte, error) {
	type NoMethod ErrorMessage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type EventAnnotation struct {
	Type int64 `json:"type,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EventAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod EventAnnotation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EventProto: Represents the invitees or other users associated with a
// Google+ Event (see http://goto/events-backend-design).
type EventProto struct {
	// EventId: Event IDs consist of alphanumeric characters and colons.
	// Currently required.
	EventId string `json:"eventId,omitempty"`

	// MemberType: The type of Event members to consider, e.g. "all members"
	// vs. "owners" vs. "admins". These are defined by legacy_relation_id
	// values in social.graph.storage.EdgeTypeEnum.EdgeType enum options in
	// social/graph/storage/proto/id.proto. See event.pb (defined in
	// production/config/cdd/socialgraph/mixer_config/prod/node_type_config)
	// for all valid edge types associated with event. Currently required.
	MemberType int64 `json:"memberType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EventId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EventId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EventProto) MarshalJSON() ([]byte, error) {
	type NoMethod EventProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FacetBucket: A bucket in a facet is the basic unit of operation. A
// bucket can comprise either a single value OR a contiguous range of
// values, depending on the type of the field bucketed. FacetBucket is
// currently used only for returning the response object.
type FacetBucket struct {
	// Count: Number of results that match the bucket value. Counts are only
	// returned for searches when count accuracy is ensured. Cloud Search
	// does not guarantee facet counts for any query and facet counts might
	// be present only intermittently, even for identical queries. Do not
	// build dependencies on facet count existence; instead use facet ount
	// percentages which are always returned.
	Count int64 `json:"count,omitempty"`

	// Filter: Filter to be passed in the search request if the
	// corresponding bucket is selected.
	Filter *Filter `json:"filter,omitempty"`

	// Percentage: Percent of results that match the bucket value. The
	// returned value is between (0-100], and is rounded down to an integer
	// if fractional. If the value is not explicitly returned, it represents
	// a percentage value that rounds to 0. Percentages are returned for all
	// searches, but are an estimate. Because percentages are always
	// returned, you should render percentages instead of counts.
	Percentage int64 `json:"percentage,omitempty"`

	Value *Value `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Count") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FacetBucket) MarshalJSON() ([]byte, error) {
	type NoMethod FacetBucket
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FacetOptions: Specifies operators to return facet results for. There
// will be one FacetResult for every
// source_name/object_type/operator_name combination.
type FacetOptions struct {
	// IntegerFacetingOptions: If set, describes integer faceting options
	// for the given integer property. The corresponding integer property in
	// the schema should be marked isFacetable. The number of buckets
	// returned would be minimum of this and num_facet_buckets.
	IntegerFacetingOptions *IntegerFacetingOptions `json:"integerFacetingOptions,omitempty"`

	// NumFacetBuckets: Maximum number of facet buckets that should be
	// returned for this facet. Defaults to 10. Maximum value is 100.
	NumFacetBuckets int64 `json:"numFacetBuckets,omitempty"`

	// ObjectType: If object_type is set, only those objects of that type
	// will be used to compute facets. If empty, then all objects will be
	// used to compute facets.
	ObjectType string `json:"objectType,omitempty"`

	// OperatorName: The name of the operator chosen for faceting. @see
	// cloudsearch.SchemaPropertyOptions
	OperatorName string `json:"operatorName,omitempty"`

	// SourceName: Source name to facet on. Format: datasources/{source_id}
	// If empty, all data sources will be used.
	SourceName string `json:"sourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "IntegerFacetingOptions") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IntegerFacetingOptions")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *FacetOptions) MarshalJSON() ([]byte, error) {
	type NoMethod FacetOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FacetResult: Source specific facet response
type FacetResult struct {
	// Buckets: FacetBuckets for values in response containing at least a
	// single result with the corresponding filter.
	Buckets []*FacetBucket `json:"buckets,omitempty"`

	// ObjectType: Object type for which facet results are returned. Can be
	// empty.
	ObjectType string `json:"objectType,omitempty"`

	// OperatorName: The name of the operator chosen for faceting. @see
	// cloudsearch.SchemaPropertyOptions
	OperatorName string `json:"operatorName,omitempty"`

	// SourceName: Source name for which facet results are returned. Will
	// not be empty.
	SourceName string `json:"sourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Buckets") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Buckets") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FacetResult) MarshalJSON() ([]byte, error) {
	type NoMethod FacetResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FieldViolation struct {
	// Description: The description of the error.
	Description string `json:"description,omitempty"`

	// Field: Path of field with violation.
	Field string `json:"field,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FieldViolation) MarshalJSON() ([]byte, error) {
	type NoMethod FieldViolation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Filter: A generic way of expressing filters in a query, which
// supports two approaches: **1. Setting a ValueFilter.** The name must
// match an operator_name defined in the schema for your data source.
// **2. Setting a CompositeFilter.** The filters are evaluated using the
// logical operator. The top-level operators can only be either an AND
// or a NOT. AND can appear only at the top-most level. OR can appear
// only under a top-level AND.
type Filter struct {
	CompositeFilter *CompositeFilter `json:"compositeFilter,omitempty"`

	ValueFilter *ValueFilter `json:"valueFilter,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CompositeFilter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CompositeFilter") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Filter) MarshalJSON() ([]byte, error) {
	type NoMethod Filter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FilterCreated: A filter was created.
type FilterCreated struct {
}

// FilterDeleted: A filter was deleted.
type FilterDeleted struct {
}

// FilterOptions: Filter options to be applied on query.
type FilterOptions struct {
	// Filter: Generic filter to restrict the search, such as `lang:en`,
	// `site:xyz`.
	Filter *Filter `json:"filter,omitempty"`

	// ObjectType: If object_type is set, only objects of that type are
	// returned. This should correspond to the name of the object that was
	// registered within the definition of schema. The maximum length is 256
	// characters.
	ObjectType string `json:"objectType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FilterOptions) MarshalJSON() ([]byte, error) {
	type NoMethod FilterOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FilterUpdate: HistoryRecord for changes associated with a filter,
// namely: FILTER_CREATED FILTER_DELETED
type FilterUpdate struct {
	FilterCreated *FilterCreated `json:"filterCreated,omitempty"`

	FilterDeleted *FilterDeleted `json:"filterDeleted,omitempty"`

	FilterId string `json:"filterId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FilterCreated") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FilterCreated") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FilterUpdate) MarshalJSON() ([]byte, error) {
	type NoMethod FilterUpdate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FixedFooter: A persistent (sticky) footer that is added to the bottom
// of the card.
type FixedFooter struct {
	Buttons []*Button `json:"buttons,omitempty"`

	PrimaryButton *TextButton `json:"primaryButton,omitempty"`

	SecondaryButton *TextButton `json:"secondaryButton,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Buttons") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Buttons") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FixedFooter) MarshalJSON() ([]byte, error) {
	type NoMethod FixedFooter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type Folder struct {
	// Id: Folder mapping id.
	Id uint64 `json:"id,omitempty,string"`

	// Message: One for each copy of the message in the IMAP folder.
	Message []*ImapsyncFolderAttributeFolderMessage `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Folder) MarshalJSON() ([]byte, error) {
	type NoMethod Folder
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FolderAttribute: This is the content of //imapsync/folder attribute.
type FolderAttribute struct {
	// Folder: List of all IMAP folders where the message presents.
	Folder []*Folder `json:"folder,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Folder") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Folder") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FolderAttribute) MarshalJSON() ([]byte, error) {
	type NoMethod FolderAttribute
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FormAction struct {
	// ActionMethodName: Apps script function that should be invoked in the
	// developer's apps script when the containing element is
	// clicked/activated.
	ActionMethodName string `json:"actionMethodName,omitempty"`

	// Possible values:
	//   "SPINNER"
	//   "NONE"
	LoadIndicator string `json:"loadIndicator,omitempty"`

	Parameters []*ActionParameter `json:"parameters,omitempty"`

	// PersistValues: Indicates whether form values persist after the
	// action. When false, the Apps Script is responsible for persisting
	// values, by setting any form field values using the formInputs in the
	// event. Disabling this behavior can be used if the add-on needs the
	// ability to clear form fields, for example, as with persistent values,
	// there is no means for clearing existing values. When disabling
	// persistent values, it is strongly recommended that the add-on use
	// LoadIndicator.SPINNER for all events, as this locks the UI to ensure
	// no changes are made by the user while the action is being processed.
	// When using LoadIndicator.NONE for any of the actions, persistent
	// values are recommended, as it ensures that any changes made by the
	// user after form / on change actions are sent to the server are not
	// overwritten by the response. Persistent values disabled by default.
	// While we recommend persistent values be used in the typical use case,
	// we do not enable by default, as doing so would change the current
	// behavior of existing add-ons in prod.
	PersistValues bool `json:"persistValues,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ActionMethodName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActionMethodName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *FormAction) MarshalJSON() ([]byte, error) {
	type NoMethod FormAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FormatMetadata: Annotation metadata for markup formatting
type FormatMetadata struct {
	// FontColor: Font color is set if and only if format_type is
	// FONT_COLOR. The components are stored as (alpha << 24) | (red << 16)
	// | (green << 8) | blue. Clients should always set the alpha component
	// to 0xFF. NEXT TAG: 3
	FontColor int64 `json:"fontColor,omitempty"`

	// FormatType:
	// LINT.ThenChange(//depot/google3/apps/dynamite/v1/web/datakeys/annotate
	// d_span.proto)
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value for the enum.
	//   "BOLD"
	//   "ITALIC"
	//   "STRIKE"
	//   "SOURCE_CODE"
	//   "MONOSPACE" - Inline monospace.
	//   "HIDDEN"
	//   "MONOSPACE_BLOCK" - Multi-line monospace block.
	//   "UNDERLINE"
	//   "FONT_COLOR"
	//   "BULLETED_LIST" - Encloses BULLETED_LIST_ITEM annotations.
	//   "BULLETED_LIST_ITEM" - Must cover the whole line including the
	// newline
	//   "CLIENT_HIDDEN" - character at the end. Not used anymore.
	FormatType string `json:"formatType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FontColor") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FontColor") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FormatMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod FormatMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Formatting: Formatting information for a segment.
type Formatting struct {
	Bold bool `json:"bold,omitempty"`

	// Highlight: This indicates that the segment should be rendered as
	// highlighted or visually emphasized.
	Highlight bool `json:"highlight,omitempty"`

	Italics bool `json:"italics,omitempty"`

	Strikethrough bool `json:"strikethrough,omitempty"`

	// Style: If set, this indicates that the segment should be rendered
	// with the specified style. The absence of an explicit style represents
	// "no style", i.e. the segment can be rendered with the default style
	// chosen by the application.
	//
	// Possible values:
	//   "UNKNOWN_STYLE" - This represents a style that is unknown (e.g. a
	// new style was introduced but not supported by older mobile app
	// versions) and should generally not be used as a value in a proto. If
	// the segment does not need to be rendered with a special style, the
	// 'style' field should simply be left unset. A reasonable fallback for
	// an unknown style is to render the segment in the default style.
	//   "HEADING_1" - The most important heading to the least important
	// heading.
	//   "HEADING_2"
	//   "HEADING_3"
	//   "HEADING_4"
	Style string `json:"style,omitempty"`

	Underline bool `json:"underline,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Bold") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Bold") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Formatting) MarshalJSON() ([]byte, error) {
	type NoMethod Formatting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FreshnessOptions: Indicates which freshness property to use when
// adjusting search ranking for an item. Fresher, more recent dates
// indicate higher quality. Use the freshness option property that best
// works with your data. For fileshare documents, last modified time is
// most relevant. For calendar event data, the time when the event
// occurs is a more relevant freshness indicator. In this way, calendar
// events that occur closer to the time of the search query are
// considered higher quality and ranked accordingly.
type FreshnessOptions struct {
	// FreshnessDuration: The duration after which an object should be
	// considered stale. The default value is 180 days (in seconds).
	FreshnessDuration string `json:"freshnessDuration,omitempty"`

	// FreshnessProperty: This property indicates the freshness level of the
	// object in the index. If set, this property must be a top-level
	// property within the property definitions and it must be a timestamp
	// type or date type. Otherwise, the Indexing API uses updateTime as the
	// freshness indicator. The maximum length is 256 characters. When a
	// property is used to calculate freshness, the value defaults to 2
	// years from the current time.
	FreshnessProperty string `json:"freshnessProperty,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FreshnessDuration")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FreshnessDuration") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *FreshnessOptions) MarshalJSON() ([]byte, error) {
	type NoMethod FreshnessOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FuseboxItem: The Item message is the read interface for user data
// (traditionally referred to as a "message", such as a mail message or
// a chat message, but generalized to encompass other types such as
// tasks) and stored in Tingle. Each Item is associated with a single
// Thread. An Item contains three classes of data. (1): Item "fields"
// are common to items of all message types (e.g. mail, chat, task,
// etc.) and are identified by the ItemFieldSpec.FetchType enum when
// fetching Items. (2): Item "attributes" represent data associated with
// an Item that is stored on behalf of the client but to which the
// fusebox and storage layers are otherwise agnostic. (3): Item "parts"
// are application-defined protocol buffers that affect how the Item is
// indexed. Item parts are referenced as extensions to the ItemParts
// message. By default the application specifies the index terms
// associated with an Item part. For performance sensitive applications,
// the storage layer can be modified to understand and index data types
// natively.
type FuseboxItem struct {
	Attributes *Attributes `json:"attributes,omitempty"`

	// CreationTimeMicroseconds: The creation time of the Item in micro
	// seconds.
	CreationTimeMicroseconds uint64 `json:"creationTimeMicroseconds,omitempty,string"`

	History *History `json:"history,omitempty"`

	// ItemKey: The key is used to refer to an item. Note that every field
	// of the MultiKey is unique to the Item, and thus the Item can be
	// looked up by any of the fields.
	ItemKey *MultiKey `json:"itemKey,omitempty"`

	Labels *Labels `json:"labels,omitempty"`

	// LastModificationTimeUs: The modification time of the Item in micro
	// seconds. Modifications to the message include label addition,
	// deletion, etc.
	LastModificationTimeUs uint64 `json:"lastModificationTimeUs,omitempty,string"`

	// LockerReferences: go/lockpicker Locker counterpart of references.
	LockerReferences *References `json:"lockerReferences,omitempty"`

	MatchInfo *MatchInfo `json:"matchInfo,omitempty"`

	// Parts: Type-specific data are represented as extensions to the
	// ItemParts message.
	Parts *ItemParts `json:"parts,omitempty"`

	// ReadTs: The read timestamp at which this item was read. This is a
	// temporary field used to check if two items streamed during dual
	// reading were read at the same timestamp. This will be populated by
	// Fusebox RPCs. "DO NOT USE UNLESS YOU TALK TO FUSEBOX TEAM
	// (gmail-fusebox@)".
	ReadTs int64 `json:"readTs,omitempty,string"`

	// References: References to attachments, video attachments in Youtube
	// and Hangout messages.
	References *References `json:"references,omitempty"`

	// Snippet: The snippet is a brief bit of text describing this item.
	Snippet string `json:"snippet,omitempty"`

	// ThreadKey: The key of the Thread with which this Item is associated.
	ThreadKey *MultiKey `json:"threadKey,omitempty"`

	// ThreadLocator: A base64 encoded and encrypted string generated from
	// the Gaia Id and the thread id. Used to generate the permalink for
	// this thread, exposed from Gmail API.
	ThreadLocator string `json:"threadLocator,omitempty"`

	Triggers *Triggers `json:"triggers,omitempty"`

	// Version: The latest history operation id that resulted in a mutation
	// of the item.
	Version uint64 `json:"version,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attributes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FuseboxItem) MarshalJSON() ([]byte, error) {
	type NoMethod FuseboxItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FuseboxItemThreadMatchInfo: In the context of a search, the MatchInfo
// contains information about which Items matched the query.
type FuseboxItemThreadMatchInfo struct {
	// ClusterId: If SearchQuery.Options.Clustering is present, the query
	// will be treated as a cluster query, and this field may be populated
	// with the cluster ID of the cluster to which this thread belongs, if
	// any. The cluster ID will be a label on the message.
	ClusterId string `json:"clusterId,omitempty"`

	// LastMatchingItemId: The server id of the last item that matched the
	// query. This is always set, regardless of the
	// compute_matching_items_per_thread option. This is the value by which
	// search results are sorted, in descending (i.e. newest first) order.
	LastMatchingItemId uint64 `json:"lastMatchingItemId,omitempty,string"`

	// LastMatchingItemKey: The MultiKey of the last item that matched the
	// query. This is always set, regardless of the
	// compute_matching_items_per_thread option. This is the value by which
	// search results are sorted, in descending (i.e. newest first) order.
	LastMatchingItemKey *MultiKey `json:"lastMatchingItemKey,omitempty"`

	// MatchingItemKey: If
	// SearchQuery.Options.compute_matching_items_per_thread, this field
	// will contain the keys of all items that matched the query, in
	// ascending order. Note that this option requires extra computation.
	MatchingItemKey []*MultiKey `json:"matchingItemKey,omitempty"`

	// Rank: The rank of this ItemThread in the result set of the query.
	// This rank may be used to sort ItemThreads in proper order. Ranks are
	// specific to a query, and stable for a given query at a specific time.
	Rank *Rank `json:"rank,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClusterId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FuseboxItemThreadMatchInfo) MarshalJSON() ([]byte, error) {
	type NoMethod FuseboxItemThreadMatchInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FuseboxPrefUpdatePreState: If the Value field is not set this means
// the pref did not exist.
type FuseboxPrefUpdatePreState struct {
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Value") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FuseboxPrefUpdatePreState) MarshalJSON() ([]byte, error) {
	type NoMethod FuseboxPrefUpdatePreState
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GSuitePrincipal struct {
	// GsuiteDomain: This principal represents all users of the Google
	// Workspace domain of the customer.
	GsuiteDomain bool `json:"gsuiteDomain,omitempty"`

	// GsuiteGroupEmail: This principal references a Google Workspace group
	// name.
	GsuiteGroupEmail string `json:"gsuiteGroupEmail,omitempty"`

	// GsuiteUserEmail: This principal references a Google Workspace user
	// account.
	GsuiteUserEmail string `json:"gsuiteUserEmail,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GsuiteDomain") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GsuiteDomain") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GSuitePrincipal) MarshalJSON() ([]byte, error) {
	type NoMethod GSuitePrincipal
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GaiaGroupProto struct {
	GroupId int64 `json:"groupId,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "GroupId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GroupId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GaiaGroupProto) MarshalJSON() ([]byte, error) {
	type NoMethod GaiaGroupProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GaiaUserProto: A Gaia account, which may represent a user, device,
// service account, etc. For prod (@prod.google.com) accounts, use
// MdbUserProto instead.
type GaiaUserProto struct {
	UserId int64 `json:"userId,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "UserId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GaiaUserProto) MarshalJSON() ([]byte, error) {
	type NoMethod GaiaUserProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GatewayAccess: Details on the third-party interoperability settings
// for the meeting space.
type GatewayAccess struct {
	// Enabled: Whether third-party gateway accesses are enabled for this
	// meeting space. If enabled, the actual access code can be retrieved by
	// calling the GetGatewayAccess RPC method.
	Enabled bool `json:"enabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GatewayAccess) MarshalJSON() ([]byte, error) {
	type NoMethod GatewayAccess
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GatewaySipAccess: Details how to join the conference via a SIP
// gateway.
type GatewaySipAccess struct {
	// SipAccessCode: Permanent numeric code for manual entry on specially
	// configured devices, currently the same as the PSTN "Universal pin".
	SipAccessCode string `json:"sipAccessCode,omitempty"`

	// Uri: The SIP URI the conference can be reached through. The string is
	// on one of the formats: "sip:@" "sips:@" where currently is the
	// 13-digit universal pin (with the future option to support using a
	// Meet meeting code as well), and is a valid address to be resolved
	// using a DNS SRV lookup, or a dotted quad.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SipAccessCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SipAccessCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GatewaySipAccess) MarshalJSON() ([]byte, error) {
	type NoMethod GatewaySipAccess
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GetCustomerIndexStatsResponse struct {
	// AverageIndexedItemCount: Average item count for the given date range
	// for which billing is done.
	AverageIndexedItemCount int64 `json:"averageIndexedItemCount,omitempty,string"`

	// Stats: Summary of indexed item counts, one for each day in the
	// requested range.
	Stats []*CustomerIndexStats `json:"stats,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AverageIndexedItemCount") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AverageIndexedItemCount")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GetCustomerIndexStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetCustomerIndexStatsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GetCustomerQueryStatsResponse struct {
	Stats []*CustomerQueryStats `json:"stats,omitempty"`

	// TotalQueryCount: Total successful query count (status code 200) for
	// the given date range.
	TotalQueryCount int64 `json:"totalQueryCount,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Stats") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Stats") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GetCustomerQueryStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetCustomerQueryStatsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GetCustomerSearchApplicationStatsResponse: Response format for search
// application stats for a customer.
type GetCustomerSearchApplicationStatsResponse struct {
	// AverageSearchApplicationCount: Average search application count for
	// the given date range.
	AverageSearchApplicationCount int64 `json:"averageSearchApplicationCount,omitempty,string"`

	// Stats: Search application stats by date.
	Stats []*CustomerSearchApplicationStats `json:"stats,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AverageSearchApplicationCount") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AverageSearchApplicationCount") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GetCustomerSearchApplicationStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetCustomerSearchApplicationStatsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GetCustomerSessionStatsResponse struct {
	Stats []*CustomerSessionStats `json:"stats,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Stats") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Stats") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GetCustomerSessionStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetCustomerSessionStatsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GetCustomerUserStatsResponse struct {
	Stats []*CustomerUserStats `json:"stats,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Stats") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Stats") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GetCustomerUserStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetCustomerUserStatsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GetDataSourceIndexStatsResponse struct {
	// AverageIndexedItemCount: Average item count for the given date range
	// for which billing is done.
	AverageIndexedItemCount int64 `json:"averageIndexedItemCount,omitempty,string"`

	// Stats: Summary of indexed item counts, one for each day in the
	// requested range.
	Stats []*DataSourceIndexStats `json:"stats,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AverageIndexedItemCount") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AverageIndexedItemCount")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GetDataSourceIndexStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetDataSourceIndexStatsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GetSearchApplicationQueryStatsResponse: Response format for getting
// query stats for a search application between given dates.
type GetSearchApplicationQueryStatsResponse struct {
	// Stats: Query stats per date for a search application.
	Stats []*SearchApplicationQueryStats `json:"stats,omitempty"`

	// TotalQueryCount: Total successful query count (status code 200) for
	// the given date range.
	TotalQueryCount int64 `json:"totalQueryCount,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Stats") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Stats") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GetSearchApplicationQueryStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetSearchApplicationQueryStatsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GetSearchApplicationSessionStatsResponse struct {
	Stats []*SearchApplicationSessionStats `json:"stats,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Stats") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Stats") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GetSearchApplicationSessionStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetSearchApplicationSessionStatsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GetSearchApplicationUserStatsResponse struct {
	Stats []*SearchApplicationUserStats `json:"stats,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Stats") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Stats") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GetSearchApplicationUserStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetSearchApplicationUserStatsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GmailClientActionMarkup struct {
	AddonComposeUiActionMarkup *AddonComposeUiActionMarkup `json:"addonComposeUiActionMarkup,omitempty"`

	OpenCreatedDraftActionMarkup *OpenCreatedDraftActionMarkup `json:"openCreatedDraftActionMarkup,omitempty"`

	TaskAction *TaskActionMarkup `json:"taskAction,omitempty"`

	UpdateDraftActionMarkup *UpdateDraftActionMarkup `json:"updateDraftActionMarkup,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AddonComposeUiActionMarkup") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AddonComposeUiActionMarkup") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GmailClientActionMarkup) MarshalJSON() ([]byte, error) {
	type NoMethod GmailClientActionMarkup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChatV1ContextualAddOnMarkup: The markup for developers to
// specify the contents of a contextual AddOn.
type GoogleChatV1ContextualAddOnMarkup struct {
	// Cards: A list of cards. A card must contain a header and at least 1
	// section.
	Cards []*GoogleChatV1ContextualAddOnMarkupCard `json:"cards,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cards") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cards") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChatV1ContextualAddOnMarkup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChatV1ContextualAddOnMarkup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChatV1ContextualAddOnMarkupCard: A card is a UI element that
// can contain UI widgets such as texts, images.
type GoogleChatV1ContextualAddOnMarkupCard struct {
	// CardActions: The actions of this card.
	CardActions []*GoogleChatV1ContextualAddOnMarkupCardCardAction `json:"cardActions,omitempty"`

	// Header: The header of the card. A header usually contains a title and
	// an image.
	Header *GoogleChatV1ContextualAddOnMarkupCardCardHeader `json:"header,omitempty"`

	// Name: Name of the card.
	Name string `json:"name,omitempty"`

	// Sections: Sections are separated by a line divider.
	Sections []*GoogleChatV1ContextualAddOnMarkupCardSection `json:"sections,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CardActions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CardActions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChatV1ContextualAddOnMarkupCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChatV1ContextualAddOnMarkupCard
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChatV1ContextualAddOnMarkupCardCardAction: A card action is the
// action associated with the card. For an invoice card, a typical
// action would be: delete invoice, email invoice or open the invoice in
// browser. Not supported by Google Chat apps.
type GoogleChatV1ContextualAddOnMarkupCardCardAction struct {
	// ActionLabel: The label used to be displayed in the action menu item.
	ActionLabel string `json:"actionLabel,omitempty"`

	// OnClick: The onclick action for this action item.
	OnClick *GoogleChatV1WidgetMarkupOnClick `json:"onClick,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ActionLabel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActionLabel") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChatV1ContextualAddOnMarkupCardCardAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChatV1ContextualAddOnMarkupCardCardAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleChatV1ContextualAddOnMarkupCardCardHeader struct {
	// ImageStyle: The image's type (e.g. square border or circular border).
	//
	// Possible values:
	//   "IMAGE_STYLE_UNSPECIFIED"
	//   "IMAGE" - Square border.
	//   "AVATAR" - Circular border.
	ImageStyle string `json:"imageStyle,omitempty"`

	// ImageUrl: The URL of the image in the card header.
	ImageUrl string `json:"imageUrl,omitempty"`

	// Subtitle: The subtitle of the card header.
	Subtitle string `json:"subtitle,omitempty"`

	// Title: The title must be specified. The header has a fixed height: if
	// both a title and subtitle is specified, each will take up 1 line. If
	// only the title is specified, it will take up both lines.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ImageStyle") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ImageStyle") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChatV1ContextualAddOnMarkupCardCardHeader) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChatV1ContextualAddOnMarkupCardCardHeader
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChatV1ContextualAddOnMarkupCardSection: A section contains a
// collection of widgets that are rendered (vertically) in the order
// that they are specified. Across all platforms, cards have a narrow
// fixed width, so there is currently no need for layout properties
// (e.g. float).
type GoogleChatV1ContextualAddOnMarkupCardSection struct {
	// Header: The header of the section, text formatted supported.
	Header string `json:"header,omitempty"`

	// Widgets: A section must contain at least 1 widget.
	Widgets []*GoogleChatV1WidgetMarkup `json:"widgets,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Header") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Header") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChatV1ContextualAddOnMarkupCardSection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChatV1ContextualAddOnMarkupCardSection
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChatV1WidgetMarkup: A widget is a UI element that presents
// texts, images, etc.
type GoogleChatV1WidgetMarkup struct {
	// Buttons: A list of buttons. Buttons is also oneof data and only one
	// of these fields should be set.
	Buttons []*GoogleChatV1WidgetMarkupButton `json:"buttons,omitempty"`

	// Image: Display an image in this widget.
	Image *GoogleChatV1WidgetMarkupImage `json:"image,omitempty"`

	// KeyValue: Display a key value item in this widget.
	KeyValue *GoogleChatV1WidgetMarkupKeyValue `json:"keyValue,omitempty"`

	// TextParagraph: Display a text paragraph in this widget.
	TextParagraph *GoogleChatV1WidgetMarkupTextParagraph `json:"textParagraph,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Buttons") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Buttons") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChatV1WidgetMarkup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChatV1WidgetMarkup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChatV1WidgetMarkupButton: A button. Can be a text button or an
// image button.
type GoogleChatV1WidgetMarkupButton struct {
	// ImageButton: A button with image and onclick action.
	ImageButton *GoogleChatV1WidgetMarkupImageButton `json:"imageButton,omitempty"`

	// TextButton: A button with text and onclick action.
	TextButton *GoogleChatV1WidgetMarkupTextButton `json:"textButton,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ImageButton") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ImageButton") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChatV1WidgetMarkupButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChatV1WidgetMarkupButton
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChatV1WidgetMarkupFormAction: A form action describes the
// behavior when the form is submitted. For example, an Apps Script can
// be invoked to handle the form.
type GoogleChatV1WidgetMarkupFormAction struct {
	// ActionMethodName: The method name is used to identify which part of
	// the form triggered the form submission. This information is echoed
	// back to the Chat app as part of the card click event. The same method
	// name can be used for several elements that trigger a common behavior
	// if desired.
	ActionMethodName string `json:"actionMethodName,omitempty"`

	// Parameters: List of action parameters.
	Parameters []*GoogleChatV1WidgetMarkupFormActionActionParameter `json:"parameters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ActionMethodName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActionMethodName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChatV1WidgetMarkupFormAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChatV1WidgetMarkupFormAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChatV1WidgetMarkupFormActionActionParameter: List of string
// parameters to supply when the action method is invoked. For example,
// consider three snooze buttons: snooze now, snooze 1 day, snooze next
// week. You might use action method = snooze(), passing the snooze type
// and snooze time in the list of string parameters.
type GoogleChatV1WidgetMarkupFormActionActionParameter struct {
	// Key: The name of the parameter for the action script.
	Key string `json:"key,omitempty"`

	// Value: The value of the parameter.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChatV1WidgetMarkupFormActionActionParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChatV1WidgetMarkupFormActionActionParameter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChatV1WidgetMarkupImage: An image that is specified by a URL
// and can have an onclick action.
type GoogleChatV1WidgetMarkupImage struct {
	// AspectRatio: The aspect ratio of this image (width/height). This
	// field allows clients to reserve the right height for the image while
	// waiting for it to load. It's not meant to override the native aspect
	// ratio of the image. If unset, the server fills it by prefetching the
	// image.
	AspectRatio float64 `json:"aspectRatio,omitempty"`

	// ImageUrl: The URL of the image.
	ImageUrl string `json:"imageUrl,omitempty"`

	// OnClick: The onclick action.
	OnClick *GoogleChatV1WidgetMarkupOnClick `json:"onClick,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AspectRatio") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AspectRatio") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChatV1WidgetMarkupImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChatV1WidgetMarkupImage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleChatV1WidgetMarkupImage) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleChatV1WidgetMarkupImage
	var s1 struct {
		AspectRatio gensupport.JSONFloat64 `json:"aspectRatio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AspectRatio = float64(s1.AspectRatio)
	return nil
}

// GoogleChatV1WidgetMarkupImageButton: An image button with an onclick
// action.
type GoogleChatV1WidgetMarkupImageButton struct {
	// Icon: The icon specified by an enum that indices to an icon provided
	// by Chat API.
	//
	// Possible values:
	//   "ICON_UNSPECIFIED"
	//   "AIRPLANE"
	//   "BOOKMARK"
	//   "BUS"
	//   "CAR"
	//   "CLOCK"
	//   "CONFIRMATION_NUMBER_ICON"
	//   "DOLLAR"
	//   "DESCRIPTION"
	//   "EMAIL"
	//   "EVENT_PERFORMER"
	//   "EVENT_SEAT"
	//   "FLIGHT_ARRIVAL"
	//   "FLIGHT_DEPARTURE"
	//   "HOTEL"
	//   "HOTEL_ROOM_TYPE"
	//   "INVITE"
	//   "MAP_PIN"
	//   "MEMBERSHIP"
	//   "MULTIPLE_PEOPLE"
	//   "OFFER"
	//   "PERSON"
	//   "PHONE"
	//   "RESTAURANT_ICON"
	//   "SHOPPING_CART"
	//   "STAR"
	//   "STORE"
	//   "TICKET"
	//   "TRAIN"
	//   "VIDEO_CAMERA"
	//   "VIDEO_PLAY"
	Icon string `json:"icon,omitempty"`

	// IconUrl: The icon specified by a URL.
	IconUrl string `json:"iconUrl,omitempty"`

	// Name: The name of this image_button which will be used for
	// accessibility. Default value will be provided if developers don't
	// specify.
	Name string `json:"name,omitempty"`

	// OnClick: The onclick action.
	OnClick *GoogleChatV1WidgetMarkupOnClick `json:"onClick,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Icon") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Icon") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChatV1WidgetMarkupImageButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChatV1WidgetMarkupImageButton
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChatV1WidgetMarkupKeyValue: A UI element contains a key (label)
// and a value (content). And this element may also contain some actions
// such as onclick button.
type GoogleChatV1WidgetMarkupKeyValue struct {
	// BottomLabel: The text of the bottom label. Formatted text supported.
	BottomLabel string `json:"bottomLabel,omitempty"`

	// Button: A button that can be clicked to trigger an action.
	Button *GoogleChatV1WidgetMarkupButton `json:"button,omitempty"`

	// Content: The text of the content. Formatted text supported and always
	// required.
	Content string `json:"content,omitempty"`

	// ContentMultiline: If the content should be multiline.
	ContentMultiline bool `json:"contentMultiline,omitempty"`

	// Icon: An enum value that will be replaced by the Chat API with the
	// corresponding icon image.
	//
	// Possible values:
	//   "ICON_UNSPECIFIED"
	//   "AIRPLANE"
	//   "BOOKMARK"
	//   "BUS"
	//   "CAR"
	//   "CLOCK"
	//   "CONFIRMATION_NUMBER_ICON"
	//   "DOLLAR"
	//   "DESCRIPTION"
	//   "EMAIL"
	//   "EVENT_PERFORMER"
	//   "EVENT_SEAT"
	//   "FLIGHT_ARRIVAL"
	//   "FLIGHT_DEPARTURE"
	//   "HOTEL"
	//   "HOTEL_ROOM_TYPE"
	//   "INVITE"
	//   "MAP_PIN"
	//   "MEMBERSHIP"
	//   "MULTIPLE_PEOPLE"
	//   "OFFER"
	//   "PERSON"
	//   "PHONE"
	//   "RESTAURANT_ICON"
	//   "SHOPPING_CART"
	//   "STAR"
	//   "STORE"
	//   "TICKET"
	//   "TRAIN"
	//   "VIDEO_CAMERA"
	//   "VIDEO_PLAY"
	Icon string `json:"icon,omitempty"`

	// IconUrl: The icon specified by a URL.
	IconUrl string `json:"iconUrl,omitempty"`

	// OnClick: The onclick action. Only the top label, bottom label and
	// content region are clickable.
	OnClick *GoogleChatV1WidgetMarkupOnClick `json:"onClick,omitempty"`

	// TopLabel: The text of the top label. Formatted text supported.
	TopLabel string `json:"topLabel,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BottomLabel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BottomLabel") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChatV1WidgetMarkupKeyValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChatV1WidgetMarkupKeyValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChatV1WidgetMarkupOnClick: An onclick action (e.g. open a
// link).
type GoogleChatV1WidgetMarkupOnClick struct {
	// Action: A form action will be triggered by this onclick if specified.
	Action *GoogleChatV1WidgetMarkupFormAction `json:"action,omitempty"`

	// OpenLink: This onclick triggers an open link action if specified.
	OpenLink *GoogleChatV1WidgetMarkupOpenLink `json:"openLink,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChatV1WidgetMarkupOnClick) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChatV1WidgetMarkupOnClick
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChatV1WidgetMarkupOpenLink: A link that opens a new window.
type GoogleChatV1WidgetMarkupOpenLink struct {
	// Url: The URL to open.
	Url string `json:"url,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Url") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Url") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChatV1WidgetMarkupOpenLink) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChatV1WidgetMarkupOpenLink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChatV1WidgetMarkupTextButton: A button with text and onclick
// action.
type GoogleChatV1WidgetMarkupTextButton struct {
	// OnClick: The onclick action of the button.
	OnClick *GoogleChatV1WidgetMarkupOnClick `json:"onClick,omitempty"`

	// Text: The text of the button.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OnClick") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OnClick") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChatV1WidgetMarkupTextButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChatV1WidgetMarkupTextButton
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChatV1WidgetMarkupTextParagraph: A paragraph of text. Formatted
// text supported.
type GoogleChatV1WidgetMarkupTextParagraph struct {
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Text") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Text") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChatV1WidgetMarkupTextParagraph) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChatV1WidgetMarkupTextParagraph
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleDocsMetadata: The corpus specific metadata for office-type
// documents, from Google Docs and other sources. This message is passed
// to the scorer and beyond. Next tag: 9
type GoogleDocsMetadata struct {
	// AclInfo: Contains number of users and groups which can access the
	// document.
	AclInfo *AclInfo `json:"aclInfo,omitempty"`

	// DocumentType: The conceptual type (presentation, document, etc.) of
	// this document.
	//
	// Possible values:
	//   "UNKNOWN" - If the type is unknown or not represented in this enum.
	//   "DOCUMENT" - Writely, Word, etc.
	//   "PRESENTATION" - Presently, PowerPoint, etc.
	//   "SPREADSHEET" - Trix, Excel, etc.
	//   "PDF" - File types for Gdrive objects are below.
	//   "IMAGE"
	//   "BINARY_BLOB" - Fall-back for unknown Gdrive types.
	//   "FUSION_TABLE"
	//   "FOLDER"
	//   "DRAWING"
	//   "VIDEO"
	//   "FORM"
	//   "DRAFT_SITE" - For Atari page and site drafts
	//   "DRAFT_SITE_PAGE"
	//   "JAM" - Jamboard Jams (go/jam)
	//   "SHORTCUT" - Drive Shortcuts (go/shortcuts)
	//   "SCRIPT"
	DocumentType string `json:"documentType,omitempty"`

	// FileExtension: The file extension of the document. NOTE: As of
	// October 2018 this field is not backfilled for old documents.
	FileExtension string `json:"fileExtension,omitempty"`

	// LastContentModifiedTimestamp: The last time this document was
	// modified, in seconds since epoch. Only counts content modifications.
	LastContentModifiedTimestamp int64 `json:"lastContentModifiedTimestamp,omitempty,string"`

	// NumSubscribers: Contains number of subscribers for the document.
	NumSubscribers int64 `json:"numSubscribers,omitempty"`

	// NumViewers: Size of untruncated viewers list.
	NumViewers int64 `json:"numViewers,omitempty"`

	// ResultInfo: Additional per-result information, akin to Gmail's
	// SingleThreadResponse. Note: GWS no longer seems to use this field,
	// but there's still one reference to it for Scribe, so we can't remove
	// it.
	ResultInfo *GoogleDocsResultInfo `json:"resultInfo,omitempty"`

	// TypeInfo: Contains additional information about the document
	// depending on its type.
	TypeInfo *TypeInfo `json:"typeInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AclInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AclInfo") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleDocsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDocsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleDocsResultInfo: A message containing information about a
// specific result. This information is passed to the scorer and beyond;
// in particular, GWS relies on it to format the result in the UI. Split
// from GoogleDocsMetadata in case we later want to reuse the message.
type GoogleDocsResultInfo struct {
	// AttachmentSha1: The SHA1 hash of the object in Drive, if any.
	AttachmentSha1 string `json:"attachmentSha1,omitempty"`

	// CosmoId: The storage identifier for the object in Cosmo. This field
	// is intended to used by Stratus/Moonshine integration only. It should
	// not be exposed externally (please refer to encrypted_id for that
	// purpose).
	CosmoId *Id `json:"cosmoId,omitempty"`

	// CosmoNameSpace: For Cosmo objects, the Cosmo namespace the object was
	// in. This allows downstream clients to identify whether a document was
	// created in Writely or Kix, Presently or Punch, or whether it was
	// uploaded from GDrive. See storage_cosmo.Id.NAME_SPACE for a list of
	// all Cosmo name spaces.
	CosmoNameSpace int64 `json:"cosmoNameSpace,omitempty"`

	// EncryptedId: The encrypted (user-visible) id of this object. Knowing
	// the id is sufficient to create a canonical URL for this document.
	EncryptedId string `json:"encryptedId,omitempty"`

	// MimeType: The mimetype of the document.
	MimeType string `json:"mimeType,omitempty"`

	// ShareScope: The visibility indicator in the UI will be based upon
	// this.
	ShareScope *ShareScope `json:"shareScope,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AttachmentSha1") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttachmentSha1") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleDocsResultInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDocsResultInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type Grid struct {
	// BorderStyle: The border style to apply to each grid item.
	BorderStyle *BorderStyle `json:"borderStyle,omitempty"`

	// Items: The items to display in the grid.
	Items []*GridItem `json:"items,omitempty"`

	// NumColumns: The number of columns to display in the grid. Note that a
	// default value will be used if this field is not specified, and that
	// default value will be different depending on where the grid is shown
	// (dialog vs companion).
	NumColumns int64 `json:"numColumns,omitempty"`

	// OnClick: This callback will be reused by each individual GridItem,
	// but with the item's identifier and index in the items list added to
	// the callback's parameters.
	OnClick *OnClick `json:"onClick,omitempty"`

	// Title: The text to display in the grid header.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BorderStyle") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BorderStyle") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Grid) MarshalJSON() ([]byte, error) {
	type NoMethod Grid
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GridItem struct {
	// Identifier: A user-specified identifier for this grid item. This
	// identifier will be returned in the parent Grid's on_click callback's
	// parameters.
	Identifier string `json:"identifier,omitempty"`

	Image *ImageComponent `json:"image,omitempty"`

	// Possible values:
	//   "NOT_SET"
	//   "TEXT_BELOW" - The title and subtitle are shown below the grid
	// item's image.
	//   "TEXT_ABOVE" - The title and subtitle are shown above the grid
	// item's image.
	Layout string `json:"layout,omitempty"`

	Subtitle string `json:"subtitle,omitempty"`

	// Possible values:
	//   "HORIZONTAL_ALIGNMENT_UNSPECIFIED"
	//   "START"
	//   "CENTER"
	//   "END"
	TextAlignment string `json:"textAlignment,omitempty"`

	// Title: Text properties.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Identifier") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Identifier") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GridItem) MarshalJSON() ([]byte, error) {
	type NoMethod GridItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GroupDetailsUpdatedMetadata struct {
	NewGroupDetails *AppsDynamiteSharedGroupDetails `json:"newGroupDetails,omitempty"`

	PrevGroupDetails *AppsDynamiteSharedGroupDetails `json:"prevGroupDetails,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NewGroupDetails") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NewGroupDetails") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GroupDetailsUpdatedMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GroupDetailsUpdatedMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GroupId: Id representing a group that could be a space, a chat, or a
// direct message space. Which ID is set here will determine which group
type GroupId struct {
	// DmId: Unique, immutable ID of the Direct Message Space
	DmId *DmId `json:"dmId,omitempty"`

	// SpaceId: Unique, immutable ID of the Space
	SpaceId *SpaceId `json:"spaceId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DmId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DmId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GroupId) MarshalJSON() ([]byte, error) {
	type NoMethod GroupId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GroupLinkSharingModificationEvent struct {
	// Possible values:
	//   "UNKNOWN_LINK_SHARING_STATUS"
	//   "LINK_SHARING_ON" - Link sharing is turned on.
	//   "LINK_SHARING_OFF" - Link sharing is turned off.
	//   "NOT_AVAILABLE" - Link sharing is not available for the
	// conversation.
	NewStatus string `json:"newStatus,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NewStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NewStatus") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GroupLinkSharingModificationEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GroupLinkSharingModificationEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GroupRetentionSettingsUpdatedMetaData struct {
	// Initiator: The user who triggered the retention settings update
	Initiator *UserId `json:"initiator,omitempty"`

	// RetentionSettings: The updated space retention settings
	RetentionSettings *AppsDynamiteSharedRetentionSettings `json:"retentionSettings,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Initiator") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Initiator") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GroupRetentionSettingsUpdatedMetaData) MarshalJSON() ([]byte, error) {
	type NoMethod GroupRetentionSettingsUpdatedMetaData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GsuiteIntegrationMetadata: Annotation metadata for an
// GsuiteIntegration artifact.
type GsuiteIntegrationMetadata struct {
	ActivityFeedData *AppsDynamiteSharedActivityFeedAnnotationData `json:"activityFeedData,omitempty"`

	AssistantData *AppsDynamiteSharedAssistantAnnotationData `json:"assistantData,omitempty"`

	CalendarEventData *AppsDynamiteSharedCalendarEventAnnotationData `json:"calendarEventData,omitempty"`

	// CallData: Data used to render call artifacts.
	CallData *AppsDynamiteSharedCallAnnotationData `json:"callData,omitempty"`

	// Possible values:
	//   "UNKNOWN_CLIENT_TYPE"
	//   "MEET"
	//   "TASKS"
	//   "CALENDAR_EVENT"
	//   "ASSISTANT"
	//   "ACTIVITY_FEED_SERVICE"
	ClientType string `json:"clientType,omitempty"`

	// IndexableTexts: A list of all strings that are to be indexed for this
	// 1P chip. Each string in this list would be the contents of a single
	// string field in the 1P chip. Eg. For Tasks[title = “hello world”,
	// description = “good bye”]. If we want to index only the title,
	// this would be set to [“hello world”]. If both title and
	// description, then this would be [“hello world”, “good bye”].
	// Please make sure that the contents of this field is a subset of
	// strings that are rendered as part of the 1P Chip.
	IndexableTexts []string `json:"indexableTexts,omitempty"`

	TasksData *AppsDynamiteSharedTasksAnnotationData `json:"tasksData,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ActivityFeedData") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActivityFeedData") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GsuiteIntegrationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GsuiteIntegrationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HangoutEvent struct {
	HangoutDurationSecs int64 `json:"hangoutDurationSecs,omitempty,string"`

	// Possible values:
	//   "AUDIO_VIDEO"
	//   "AUDIO_ONLY"
	//   "PUSH_TO_TALK" - A user has started a PTT broadcast. When receiving
	// a notification with this HangoutMediaType, other users in the
	// conversation will take different actions depending on their active
	// clients: a) If there is a recent "reasonable" active client, the user
	// will join hangout and play audio. b) If there is no "reasonable"
	// active client an invite will be displayed on all clients.
	MediaType string `json:"mediaType,omitempty"`

	ParticipantId []*StoredParticipantId `json:"participantId,omitempty"`

	// Possible values:
	//   "START_HANGOUT"
	//   "JOIN_HANGOUT"
	//   "LEAVE_HANGOUT"
	//   "END_HANGOUT"
	//   "HANGOUT_COMING_SOON"
	//   "ONGOING_HANGOUT"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HangoutDurationSecs")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HangoutDurationSecs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *HangoutEvent) MarshalJSON() ([]byte, error) {
	type NoMethod HangoutEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HangoutVideoEventMetadata: A message representing the Hangout video
// start/end events in Babel
type HangoutVideoEventMetadata struct {
	// Possible values:
	//   "UNKNOWN_HANGOUT_VIDEO_EVENT_TYPE"
	//   "VIDEO_START"
	//   "VIDEO_END"
	HangoutVideoType string `json:"hangoutVideoType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HangoutVideoType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HangoutVideoType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *HangoutVideoEventMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod HangoutVideoEventMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HashtagData: Hashtag metadata, for HASHTAG segments. For a hashtag,
// the "text" field should contain the display text, and the search_text
// field should represent the topic being referenced, without the hash
// symbol; for example, we might have: text = "#Google"
// hashtag_data.search_text = "Google" Another example: text =
// "#pikachu" hashtag_data.search_text = "Pokemon" Both strings should
// be considered part of the searchable text. In go/sbe, both are
// indexed and searchable.
type HashtagData struct {
	SearchText string `json:"searchText,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SearchText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SearchText") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HashtagData) MarshalJSON() ([]byte, error) {
	type NoMethod HashtagData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// History: The most recent history records associated with the item.
type History struct {
	Record []*HistoryRecord `json:"record,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Record") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Record") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *History) MarshalJSON() ([]byte, error) {
	type NoMethod History
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HistoryRecord struct {
	// ClientContext: This will almost always be set, but there are corner
	// cases in which the information is not available, and thus
	// applications must handle its absence appropriately.
	ClientContext *ClientContext `json:"clientContext,omitempty"`

	FilterUpdate *FilterUpdate `json:"filterUpdate,omitempty"`

	ImapUpdate *ImapUpdate `json:"imapUpdate,omitempty"`

	LabelUpdate *LabelUpdate `json:"labelUpdate,omitempty"`

	PrefUpdate *PrefUpdate `json:"prefUpdate,omitempty"`

	// RecordId: Each HistoryRecord has a unique id. Ids are monotonically
	// increasing, and not necessarily contiguous.
	RecordId uint64 `json:"recordId,omitempty,string"`

	ThreadUpdate *ThreadUpdate `json:"threadUpdate,omitempty"`

	// TransactionContext: This will almost always be set, but there are
	// corner cases in which the information is not available, and thus
	// applications must handle its absence appropriately.
	TransactionContext *TransactionContext `json:"transactionContext,omitempty"`

	TxnDebugInfo *TransactionDebugInfo `json:"txnDebugInfo,omitempty"`

	// Possible values:
	//   "UNKNOWN" - Represents a type that is deprecated or not known by
	// the executing code. Even if Fusebox sends a HistoryRecord with Type
	// not UNKNOWN, it may send Type values that are not yet defined on the
	// client-side, in which case they will be appear as Type.UNKNOWN on the
	// client.
	//   "INTERNAL" - Represents a change internal to the Fusebox.
	// HistoryRecords for Fusebox internal changes contribute to the user's
	// version, which is defined as the latest HistoryRecord's record_id.
	// INTERNAL HistoryRecords exist to allow a client to update its notion
	// of the latest record_id it has processed, but do not necessarily
	// contain any other information.
	//   "MESSAGE_ADDED" - ThreadUpdate:
	//   "MESSAGE_DELETED"
	//   "LABEL_ADDED"
	//   "LABEL_REMOVED"
	//   "ATTRIBUTE_SET"
	//   "ATTRIBUTE_REMOVED"
	//   "THREAD_KEY_SET"
	//   "LABEL_CREATED" - LabelUpdate:
	//   "LABEL_DELETED"
	//   "LABEL_RENAMED"
	//   "LABEL_UPDATED"
	//   "PREF_WRITTEN" - PrefUpdate:
	//   "PREF_DELETED"
	//   "FILTER_CREATED" - FilterUpdate:
	//   "FILTER_DELETED"
	//   "IMAP_UIDS_REASSIGN" - IMAP
	//   "TOPIC_STATE_UPDATED" - EAI
	//   "TXN_DEBUG_INFO" - TXN_DEBUG_INFO
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ClientContext") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClientContext") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HistoryRecord) MarshalJSON() ([]byte, error) {
	type NoMethod HistoryRecord
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HostAppActionMarkup: Actions handled by individual host apps.
type HostAppActionMarkup struct {
	// CalendarAction: Actions handled by Calendar.
	CalendarAction *CalendarClientActionMarkup `json:"calendarAction,omitempty"`

	// ChatAction: Actions handled by Chat.
	ChatAction *ChatClientActionMarkup `json:"chatAction,omitempty"`

	// DriveAction: Actions handled by Drive.
	DriveAction *DriveClientActionMarkup `json:"driveAction,omitempty"`

	// EditorAction: Actions handled by Docs, Sheets, or Slides.
	EditorAction *EditorClientActionMarkup `json:"editorAction,omitempty"`

	// GmailAction: Actions handled by Gmail.
	GmailAction *GmailClientActionMarkup `json:"gmailAction,omitempty"`

	// SheetsAction: Actions handled by Sheets.
	SheetsAction *SheetsClientActionMarkup `json:"sheetsAction,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CalendarAction") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CalendarAction") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *HostAppActionMarkup) MarshalJSON() ([]byte, error) {
	type NoMethod HostAppActionMarkup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HostProto: Represents a single host. Optionally, the MDB owner of the
// host can be specified.
type HostProto struct {
	// HostName: Lower-case, fully qualified hostname.
	HostName string `json:"hostName,omitempty"`

	// HostOwner: If present, then any checks that compare this Principal to
	// LOAS peer info must confirm the peer's machine owner is equal to
	// 'host_owner'. If absent, then any peer machine owner is acceptable.
	HostOwner string `json:"hostOwner,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HostName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HostName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HostProto) MarshalJSON() ([]byte, error) {
	type NoMethod HostProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HtmlOperatorOptions: Used to provide a search operator for html
// properties. This is optional. Search operators let users restrict the
// query to specific fields relevant to the type of item being searched.
type HtmlOperatorOptions struct {
	// OperatorName: Indicates the operator name required in the query in
	// order to isolate the html property. For example, if operatorName is
	// *subject* and the property's name is *subjectLine*, then queries like
	// *subject:<value>* show results only where the value of the property
	// named *subjectLine* matches *<value>*. By contrast, a search that
	// uses the same *<value>* without an operator return all items where
	// *<value>* matches the value of any html properties or text within the
	// content field for the item. The operator name can only contain
	// lowercase letters (a-z). The maximum length is 32 characters.
	OperatorName string `json:"operatorName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OperatorName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OperatorName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HtmlOperatorOptions) MarshalJSON() ([]byte, error) {
	type NoMethod HtmlOperatorOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HtmlPropertyOptions: The options for html properties.
type HtmlPropertyOptions struct {
	// OperatorOptions: If set, describes how the property should be used as
	// a search operator.
	OperatorOptions *HtmlOperatorOptions `json:"operatorOptions,omitempty"`

	// RetrievalImportance: Indicates the search quality importance of the
	// tokens within the field when used for retrieval. Can only be set to
	// DEFAULT or NONE.
	RetrievalImportance *RetrievalImportance `json:"retrievalImportance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OperatorOptions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OperatorOptions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *HtmlPropertyOptions) MarshalJSON() ([]byte, error) {
	type NoMethod HtmlPropertyOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HtmlValues: List of html values.
type HtmlValues struct {
	// Values: The maximum allowable length for html values is 2048
	// characters.
	Values []string `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Values") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HtmlValues) MarshalJSON() ([]byte, error) {
	type NoMethod HtmlValues
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type IconImage struct {
	// AltText: The alternative text of this icon_url which will be used for
	// accessibility.
	AltText string `json:"altText,omitempty"`

	// Possible values:
	//   "NONE"
	//   "AIRPLANE"
	//   "BOOKMARK"
	//   "BUS"
	//   "CAR"
	//   "CLOCK"
	//   "CONFIRMATION_NUMBER_ICON"
	//   "DOLLAR"
	//   "DESCRIPTION"
	//   "EDIT"
	//   "EDIT_NOTE"
	//   "EMAIL"
	//   "EVENT_PERFORMER"
	//   "EVENT_SEAT"
	//   "FLIGHT_ARRIVAL"
	//   "FLIGHT_DEPARTURE"
	//   "HOTEL"
	//   "HOTEL_ROOM_TYPE"
	//   "INVITE"
	//   "MAP_PIN"
	//   "MEMBERSHIP"
	//   "MULTIPLE_PEOPLE"
	//   "OFFER"
	//   "OPEN_IN_NEW"
	//   "PERSON"
	//   "PHONE"
	//   "RESTAURANT_ICON"
	//   "SHOPPING_CART"
	//   "STAR"
	//   "STORE"
	//   "TICKET"
	//   "TRAIN"
	//   "VIDEO_CAMERA"
	//   "VIDEO_PLAY" - Add new items in alphabetical order. Next Available
	// ID: 34
	Icon string `json:"icon,omitempty"`

	IconUrl string `json:"iconUrl,omitempty"`

	// ImageStyle: The image cropping style. Note that icons with a CIRCLE
	// style are rendered larger than the default icon size.
	//
	// Possible values:
	//   "CROP_TYPE_NOT_SET" - No value specified.
	//   "SQUARE" - Applies a square crop.
	//   "CIRCLE" - Applies a circular crop.
	//   "RECTANGLE_CUSTOM" - Applies a rectangular crop with a custom
	// aspect ratio.
	//   "RECTANGLE_4_3" - Applies a rectangular crop with a 4:3 aspect
	// ratio.
	ImageStyle string `json:"imageStyle,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AltText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AltText") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *IconImage) MarshalJSON() ([]byte, error) {
	type NoMethod IconImage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Id: Identifies a particular object, including both Users and
// DirEntries. This Id is unique across the entire server instance, such
// as the production or qa instance.
type Id struct {
	// CreatorUserId: The User account in which the DirEntry was originally
	// created. If name_space==GAIA, then it's the gaia_id of the user this
	// id is referring to.
	CreatorUserId uint64 `json:"creatorUserId,omitempty,string"`

	// LocalId: The local identifier for the DirEntry (local to the
	// creator's account). local_id + app_name is guaranteed to be unique
	// within the creator account, but not across all User accounts. The
	// string is case sensitive. Ignore if name_space==GAIA. NB For
	// name_space==COSMO, all local_id's should be defined in
	// google3/java/com/google/storage/cosmo/server/api/SpecialObjectIds.java
	//  as they have a special predefined meaning. See
	// cosmo.client.CosmoIdFactory.createObjectId(long,String) for IMPORTANT
	// recommendations when generating IDs.
	LocalId string `json:"localId,omitempty"`

	// NameSpace: The name space in which this id is unique (typically the
	// application that created it). Values should be drawn from the above
	// enum, but for experimentation, use values greater than 1000.
	NameSpace int64 `json:"nameSpace,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreatorUserId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreatorUserId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Id) MarshalJSON() ([]byte, error) {
	type NoMethod Id
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type Image struct {
	// AltText: The alternative text of this image which will be used for
	// accessibility.
	AltText string `json:"altText,omitempty"`

	// AspectRatio: The aspect ratio of this image (width/height).
	AspectRatio float64 `json:"aspectRatio,omitempty"`

	// ImageUrl: Image url specified by developers. Server side, we will
	// wrap with FIFE so client apps can configure size/cropping/etc.
	ImageUrl string `json:"imageUrl,omitempty"`

	OnClick *OnClick `json:"onClick,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AltText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AltText") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Image) MarshalJSON() ([]byte, error) {
	type NoMethod Image
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *Image) UnmarshalJSON(data []byte) error {
	type NoMethod Image
	var s1 struct {
		AspectRatio gensupport.JSONFloat64 `json:"aspectRatio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AspectRatio = float64(s1.AspectRatio)
	return nil
}

type ImageButton struct {
	// Possible values:
	//   "NONE"
	//   "AIRPLANE"
	//   "BOOKMARK"
	//   "BUS"
	//   "CAR"
	//   "CLOCK"
	//   "CONFIRMATION_NUMBER_ICON"
	//   "DOLLAR"
	//   "DESCRIPTION"
	//   "EDIT"
	//   "EDIT_NOTE"
	//   "EMAIL"
	//   "EVENT_PERFORMER"
	//   "EVENT_SEAT"
	//   "FLIGHT_ARRIVAL"
	//   "FLIGHT_DEPARTURE"
	//   "HOTEL"
	//   "HOTEL_ROOM_TYPE"
	//   "INVITE"
	//   "MAP_PIN"
	//   "MEMBERSHIP"
	//   "MULTIPLE_PEOPLE"
	//   "OFFER"
	//   "OPEN_IN_NEW"
	//   "PERSON"
	//   "PHONE"
	//   "RESTAURANT_ICON"
	//   "SHOPPING_CART"
	//   "STAR"
	//   "STORE"
	//   "TICKET"
	//   "TRAIN"
	//   "VIDEO_CAMERA"
	//   "VIDEO_PLAY" - Add new items in alphabetical order. Next Available
	// ID: 34
	Icon string `json:"icon,omitempty"`

	IconUrl string `json:"iconUrl,omitempty"`

	Name string `json:"name,omitempty"`

	OnClick *OnClick `json:"onClick,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Icon") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Icon") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImageButton) MarshalJSON() ([]byte, error) {
	type NoMethod ImageButton
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ImageComponent: NOTE: Through future refactoring work, this image
// component will eventually be used in the Image widget, and will
// likely replace the Icon proto as well.
type ImageComponent struct {
	AltText string `json:"altText,omitempty"`

	BorderStyle *BorderStyle `json:"borderStyle,omitempty"`

	CropStyle *ImageCropStyle `json:"cropStyle,omitempty"`

	ImageUrl string `json:"imageUrl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AltText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AltText") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImageComponent) MarshalJSON() ([]byte, error) {
	type NoMethod ImageComponent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ImageCropStyle: Represents a crop style that can be applied to an
// image.
type ImageCropStyle struct {
	// AspectRatio: The aspect ratio to use if the crop type is
	// RECTANGLE_CUSTOM.
	AspectRatio float64 `json:"aspectRatio,omitempty"`

	// Type: The crop type.
	//
	// Possible values:
	//   "CROP_TYPE_NOT_SET" - No value specified.
	//   "SQUARE" - Applies a square crop.
	//   "CIRCLE" - Applies a circular crop.
	//   "RECTANGLE_CUSTOM" - Applies a rectangular crop with a custom
	// aspect ratio.
	//   "RECTANGLE_4_3" - Applies a rectangular crop with a 4:3 aspect
	// ratio.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AspectRatio") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AspectRatio") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImageCropStyle) MarshalJSON() ([]byte, error) {
	type NoMethod ImageCropStyle
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *ImageCropStyle) UnmarshalJSON(data []byte) error {
	type NoMethod ImageCropStyle
	var s1 struct {
		AspectRatio gensupport.JSONFloat64 `json:"aspectRatio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AspectRatio = float64(s1.AspectRatio)
	return nil
}

// ImageKeyValue: This is deprecated and please use KeyValue.
type ImageKeyValue struct {
	// Possible values:
	//   "NONE"
	//   "AIRPLANE"
	//   "BOOKMARK"
	//   "BUS"
	//   "CAR"
	//   "CLOCK"
	//   "CONFIRMATION_NUMBER_ICON"
	//   "DOLLAR"
	//   "DESCRIPTION"
	//   "EDIT"
	//   "EDIT_NOTE"
	//   "EMAIL"
	//   "EVENT_PERFORMER"
	//   "EVENT_SEAT"
	//   "FLIGHT_ARRIVAL"
	//   "FLIGHT_DEPARTURE"
	//   "HOTEL"
	//   "HOTEL_ROOM_TYPE"
	//   "INVITE"
	//   "MAP_PIN"
	//   "MEMBERSHIP"
	//   "MULTIPLE_PEOPLE"
	//   "OFFER"
	//   "OPEN_IN_NEW"
	//   "PERSON"
	//   "PHONE"
	//   "RESTAURANT_ICON"
	//   "SHOPPING_CART"
	//   "STAR"
	//   "STORE"
	//   "TICKET"
	//   "TRAIN"
	//   "VIDEO_CAMERA"
	//   "VIDEO_PLAY" - Add new items in alphabetical order. Next Available
	// ID: 34
	Icon string `json:"icon,omitempty"`

	IconUrl string `json:"iconUrl,omitempty"`

	OnClick *OnClick `json:"onClick,omitempty"`

	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Icon") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Icon") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImageKeyValue) MarshalJSON() ([]byte, error) {
	type NoMethod ImageKeyValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ImapSessionContext struct {
	// Possible values:
	//   "OTHER_APP" - Unknown
	//   "CHROME" - Browsers Google Chrome
	//   "FIREFOX" - Mozilla Firefox
	//   "MSIE" - Microsoft Internet Explorer
	//   "SAFARI" - Apple Safari
	//   "OPERA" - Opera
	//   "EDGE" - Tag #7 used to be CHROME_WEBVIEW, which was deprecated and
	// replaced by CHROME_WEBVIEW_APP. When adding a new browser, skip #7
	// for safety. Microsoft Edge
	//   "MSIE_COMPATIBILITY" - MSIE in Compatibility View. See b/22467241.
	//   "OTHER_BROWSER" - Browser not otherwise specified
	//   "SAMSUNG_BROWSER" - Samsung browser on Android
	//   "UC_BROWSER" - UC Browser
	//   "ANDROID_BROWSER" - Android's legacy default AOSP browser (distinct
	//   "YANDEX_BROWSER" - from customized OEM flavours). Yandex Browser
	//   "SILK_BROWSER" - Amazon Silk browser
	//   "COC_COC_BROWSER" - Popoular browser in Vietnam
	//   "MAX_BROWSER_APP_VALUE" - Tag for the maximum enum value that
	// represents a browser. Enum values (strictly) between OTHER_APP and
	// this value represent browsers. This should never appear in real data.
	//   "GMAIL_APP" - Email apps Gmail
	//   "GMAIL_INBOX_APP" - Inbox by Gmail
	//   "ANDROID_EMAIL_APP" - Native Android email app
	//   "SAMSUNG_MAIL_APP" - (replaced by Gmail in Lollipop) Samsung mail
	//   "MOTO_EMAIL_APP" - Motorola email app
	//   "BOXER_APP" - Boxer
	//   "LIMILABS_MAIL_DLL" - Mail.dll by Limilabs
	//   "BIS_APP" - BlackBerry Internet Service
	//   "OUTLOOK_MAIL_APP" - Microsoft Outlook
	//   "APPLE_NATIVE_APP" - Apple apps (mail, contacts & calendar)
	//   "CHROME_WEBVIEW_APP" - Chrome Webview
	//   "SAFARI_WEBVIEW_APP" - Safari Webview
	//   "CHROME_SYNC_APP" - Chrome Sync
	//   "GSA_APP" - Includes both Now and Search on GSA.
	//   "GMM_APP" - Maps
	//   "CALENDAR_APP" - Calendar
	//   "PLUS_APP" - Google+
	//   "HANGOUTS_APP" - Hangouts Classic
	//   "HANGOUTS_MEET_APP" - Hangouts Meet
	//   "JAMBOARD_APP" - Jamboard app (go/jamboard)
	//   "VOICE_APP" - Google Voice
	//   "PHOTOS_APP" - Photos
	//   "DRIVE_SYNC_APP" - Drive Sync
	//   "DRIVE_APP" - Drive
	//   "DOCS_APP" - Docs
	//   "SHEETS_APP" - Sheets
	//   "SLIDES_APP" - Slides
	//   "KEEP_APP" - Keep
	//   "WHATS_APP_IN_DRIVE_APP" - WhatsApp in Drive
	//   "TRANSLATE_APP" - Translate
	//   "YOUTUBE_APP" - YouTube
	//   "YOUTUBE_MUSIC_APP" - YouTube Music
	//   "YOUTUBE_GAMING_APP" - YouTube Gaming
	//   "YOUTUBE_KIDS_APP" - YouTube Kids
	//   "YOUTUBE_CAPTURE_APP" - YouTube Capture
	//   "YOUTUBE_CREATOR_APP" - YouTube Creator Studio
	//   "YOUTUBE_GO_APP" - YouTube Go
	//   "YOUTUBE_TV_APP" - YouTube TV
	//   "YOUTUBE_VR_APP" - YouTube VR
	//   "PLAY_APP" - Google Play
	//   "PLAY_MUSIC_APP" - Google Play Music
	//   "PLAY_BOOKS_APP" - Google Play Books
	//   "PLAY_MOVIES_APP" - Google Play Movies & TV
	//   "PLAY_NEWSSTAND_APP" - Google Play Newsstand
	//   "PLAY_GAMES_APP" - Google Play Games
	//   "POKEMON_GO_APP" - Pokemon GO (uses Google to sign in)
	//   "ALLO_APP" - Allo
	//   "DUO_APP" - Duo
	//   "CLASSROOM_APP" - Google Classroom
	//   "TRIPS_APP" - Google Trips
	//   "GOOGLE_PAY_APP" - Google Pay (formerly Android Pay)
	//   "WAZE_APP" - Waze
	//   "ASSISTANT_APP" - Google Assistant standalone app. iOS only,
	//   "GBOARD_APP" - since on Android OPA is integrated in GSA. Gboard -
	// the Google Keyboard
	//   "NEWS_APP" - Google News & Weather
	//   "HOME_APP" - Google Home app (rebranded from Chromecast app)
	//   "EARTH_APP" - Google Earth
	//   "STREET_VIEW_APP" - Google Street View
	//   "TEZ_APP" - Tez payment app for India (go/paisa)
	//   "GOOGLE_ANALYTICS_APP" - Google Analytics
	//   "ADSENSE_APP" - AdSense
	//   "ADWORDS_APP" - AdWords
	//   "EXPRESS_APP" - Google Express (formerly Shopping Express)
	//   "WEAR_APP" - Android Wear companion app
	//   "GOOGLE_MY_BUSINESS_APP" - Google My Business
	//   "FAMILY_LINK_APP" - Google Family Link
	//   "OPINION_REWARDS_APP" - Google Opinion Rewards
	//   "WALLET_APP" - Google Wallet
	//   "ARTS_AND_CULTURE_APP" - Google Arts & Culture
	//   "ANDROID_DEVICE_MANAGER_APP" - Android Device Manager
	//   "GOOGLE_GO_APP" - Google Go
	//   "FILES_GO_APP" - Files Go
	//   "DATALLY_APP" - Datally
	//   "WIFI_APP" - Google Wifi (incl. OnHub)
	//   "STADIA_APP" - Stadia (go/stadia)
	//   "BATTLESTAR_APP" - Battlestar (go/battlestar)
	//   "SMART_LOCK_APP" - SmartLock
	//   "LOGDOG_APP" - Non-browser, non-mail, non-first-party apps LogDog
	// (https://getlogdog.com/)
	//   "DEPRECATED_MAC_OSX_MAIL_APP" - Do not remove this fields -
	// remvoing them caused issues in the past (see cl/180425348 for
	// reference).
	//   "DEPRECATED_IOS_MAIL_APP"
	App string `json:"app,omitempty"`

	// DeviceType: User agent information
	//
	// Possible values:
	//   "UNKNOWN" - Unknown device type.
	//   "PC" - PCs (incl. Macs). Desktops, laptops and various niche form
	// factors that typically run desktop-class OSes (all-in-ones, HTPCs
	// etc.).
	//   "MOBILE" - Primarily used for phones, but also set as default for
	// OSes that are predominantly for phones (Android, iOS etc.) when we
	// can't determine otherwise.
	//   "TABLET" - Tablets.
	//   "PORTABLE_MEDIA_PLAYER" - Mobile devices which are not phones, but
	// are capable of storing and playing digital media such as audio,
	// images, and video files. Example: iPod.
	//   "TV" - Smart TVs which interact with Google products without an
	// external additional device. Includes TV sets which run Android TV
	// directly. Refers to actual TV screens, rather than connected boxes or
	// dongles.
	//   "GAME_CONSOLE" - Devices whose primary purpose is playing games.
	// Examples: Xbox, Playstation.
	//   "MEDIA_PLAYER" - Add-on devices (i.e. devices which require
	// connecting to another device, such as screens/TVs/speakers) whose
	// primary purpose is media consumption (excludes physical TV screens).
	// Examples: Chromecast, Roku, Apple TV, Nexus Player.
	//   "SMART_SPEAKER" - Examples: Google Home, Amazon Echo.
	//   "SMART_DISPLAY" - Examples: Google Home Display
	// (Quartz/Manhattan/Jasper/Dragonglass), Amazon Echo Spot, Amazon Echo
	// Show.
	//   "CONNECTED_HOME_OTHER" - Other connected home devices which do not
	// fit in any of the above categories; that is, neither media- or
	// gaming-focused, nor primarily a voice-enabled speaker.
	//   "WEARABLE" - Wearable devices such as smartwatches.
	//   "GLASS" - Google Glass.
	//   "CAR" - Examples: Android Auto (Embedded mode, not mirrored from
	// phone).
	//   "VR_HEADSET" - Standalone VR headsets, such as the Lenovo Mirage
	// Solo. Does not include phone-based VR (such as Daydream View or Gear
	// VR) or PC/Console-based such as Oculus Rift, HTC Vive and PSVR; in
	// such cases, the form factor may be PHONE, PC or GAME_CONSOLE as
	// applicable.
	DeviceType string `json:"deviceType,omitempty"`

	// GuidFingerprint: As agreed with Bond team, this holds the fingerprint
	// of any "aguid" or "guid" provided by the ID command. The fingerprint
	// should be calculated by fingerprint2011. Note that not all clients
	// will provide aguid or guid through ID command.
	GuidFingerprint uint64 `json:"guidFingerprint,omitempty,string"`

	// Possible values:
	//   "UNKNOWN_OS"
	//   "ANDROID_OS" - Mobile operating systems (1-99).
	//   "IOS_OS"
	//   "BLACKBERRY_OS"
	//   "WIN_PHONE_OS"
	//   "FIRE_OS" - Amazon Fire OS (for Kindle Fire devices or Fire TV).
	//   "MAX_MOBILE_OS_VALUE" - Tag for the maximum enum value that
	// represents a mobile OS. Enum values (strictly) between UNKNOWN_OS and
	// this value represent mobile OSes. This should never appear in real
	// data.
	//   "WINDOWS_OS" - PC operating systems.
	//   "LINUX_OS"
	//   "MAC_OS"
	//   "CHROME_OS"
	//   "PLAYSTATION_OS" - The OS powering Playstation consoles. Ignores OS
	// changes across console generations.
	//   "XBOX_OS" - The Windows-derived OS used on Xbox consoles.
	//   "TIZEN_OS" - Tizen OS, popular in Samsung TVs, watches and more.
	//   "APPLE_TV_OS" - Apple tvOS (powering the Apple TV).
	//   "KAI_OS" - KaiOS, a fork from Firefox OS that is between a full
	// smartphone and a feature phone. Notably, it supports the Google
	// Assistant. go/kaiosama
	//   "ANDROID_THINGS_OS" - Android optimized for IoT devices. go/things
	//   "CAST_OS" - Cast family devices, including Chromecast, Google Home,
	// and third-party speaker with integrated Assistant.
	//   "STADIA_OS" - Stadia on Cast devices. This is not truly an OS, but
	// it's a temporary setting since Stadia uses a different sign-in flow
	// (and is revoked differently) from Cast. See
	// http://go/stadia-in-google-account. Do not use without discussing
	// with id-devices-eng@.
	Os string `json:"os,omitempty"`

	OsVersion *OsVersion `json:"osVersion,omitempty"`

	PossiblyTrimmedModel *PossiblyTrimmedModel `json:"possiblyTrimmedModel,omitempty"`

	// ForceSendFields is a list of field names (e.g. "App") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "App") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImapSessionContext) MarshalJSON() ([]byte, error) {
	type NoMethod ImapSessionContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ImapSyncDelete: Message delete history record extension that exports
// //imapsync/folder attribute of deleted messages which have ^is label.
type ImapSyncDelete struct {
	// Mappings: Contains the value of //imapsync/folder attribute of
	// deleted message.
	Mappings *FolderAttribute `json:"mappings,omitempty"`

	MsgId uint64 `json:"msgId,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Mappings") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Mappings") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImapSyncDelete) MarshalJSON() ([]byte, error) {
	type NoMethod ImapSyncDelete
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ImapUidsReassign struct {
	// LabelId: Label
	LabelId string `json:"labelId,omitempty"`

	// MessageId: The message Ids
	MessageId googleapi.Uint64s `json:"messageId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LabelId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LabelId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImapUidsReassign) MarshalJSON() ([]byte, error) {
	type NoMethod ImapUidsReassign
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ImapUpdate: HistoryRecord for changes associated with IMAP, namely:
// IMAP_UIDS_REASSIGN
type ImapUpdate struct {
	ImapUidsReassign *ImapUidsReassign `json:"imapUidsReassign,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ImapUidsReassign") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ImapUidsReassign") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ImapUpdate) MarshalJSON() ([]byte, error) {
	type NoMethod ImapUpdate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ImapsyncFolderAttributeFolderMessage struct {
	// Flags: Flags of the message. Represents unseen and flagged state.
	Flags *ImapsyncFolderAttributeFolderMessageFlags `json:"flags,omitempty"`

	// Uid: UID of the message.
	Uid uint64 `json:"uid,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Flags") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Flags") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImapsyncFolderAttributeFolderMessage) MarshalJSON() ([]byte, error) {
	type NoMethod ImapsyncFolderAttributeFolderMessage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ImapsyncFolderAttributeFolderMessageFlags struct {
	// Flagged: Flagged state of the message.
	Flagged bool `json:"flagged,omitempty"`

	// Seen: Seen state of the message.
	Seen bool `json:"seen,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Flagged") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Flagged") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImapsyncFolderAttributeFolderMessageFlags) MarshalJSON() ([]byte, error) {
	type NoMethod ImapsyncFolderAttributeFolderMessageFlags
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IncomingWebhookChangedMetadata: Annotation metadata to display system
// messages for incoming webhook events. Next Tag: 7
type IncomingWebhookChangedMetadata struct {
	// IncomingWebhookName: The webhook name at the time of the change. Used
	// in Spanner storage, BE API responses and FE API responses.
	IncomingWebhookName string `json:"incomingWebhookName,omitempty"`

	// InitiatorId: The user id of the user whose action triggered this
	// system message. Used in Spanner storage, BE API responses and FE API
	// responses.
	InitiatorId *UserId `json:"initiatorId,omitempty"`

	// InitiatorProfile: Complete profile when ListTopicsRequest
	// FetchOptions.USER is set. Otherwise, only the id will be filled in.
	// Used in FE API responses.
	InitiatorProfile *User `json:"initiatorProfile,omitempty"`

	// ObfuscatedIncomingWebhookId: The webhook id of the incoming webhook
	// in question. This field should not be used to load webhook
	// information dynamically and is only present for debugging purposes.
	// Used in Spanner storage, BE API responses and FE API responses.
	ObfuscatedIncomingWebhookId string `json:"obfuscatedIncomingWebhookId,omitempty"`

	// OldIncomingWebhookName: Only populated for UPDATED_NAME and
	// UPDATED_NAME_AND_AVATAR events, where the webhook name was changed.
	// Used in Spanner storage, BE API responses and FE API responses.
	OldIncomingWebhookName string `json:"oldIncomingWebhookName,omitempty"`

	// Type: Used in Spanner storage, BE API responses and FE API responses.
	//
	// Possible values:
	//   "UNSPECIFIED"
	//   "ADDED"
	//   "UPDATED" - TODO (b/154857280): remove UPDATED field.
	//   "REMOVED"
	//   "UPDATED_NAME"
	//   "UPDATED_AVATAR"
	//   "UPDATED_NAME_AND_AVATAR"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IncomingWebhookName")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IncomingWebhookName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *IncomingWebhookChangedMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod IncomingWebhookChangedMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type IndexItemOptions struct {
	// AllowUnknownGsuitePrincipals: Specifies if the index request should
	// allow Google Workspace principals that do not exist or are deleted.
	AllowUnknownGsuitePrincipals bool `json:"allowUnknownGsuitePrincipals,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllowUnknownGsuitePrincipals") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AllowUnknownGsuitePrincipals") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *IndexItemOptions) MarshalJSON() ([]byte, error) {
	type NoMethod IndexItemOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type IndexItemRequest struct {
	// ConnectorName: The name of connector making this call. Format:
	// datasources/{source_id}/connectors/{ID}
	ConnectorName string `json:"connectorName,omitempty"`

	// DebugOptions: Common debug options.
	DebugOptions *DebugOptions `json:"debugOptions,omitempty"`

	IndexItemOptions *IndexItemOptions `json:"indexItemOptions,omitempty"`

	// Item: The name of the item. Format:
	// datasources/{source_id}/items/{item_id}
	Item *Item `json:"item,omitempty"`

	// Mode: Required. The RequestMode for this request.
	//
	// Possible values:
	//   "UNSPECIFIED" - The priority is not specified in the update
	// request. Leaving priority unspecified results in an update failure.
	//   "SYNCHRONOUS" - For real-time updates.
	//   "ASYNCHRONOUS" - For changes that are executed after the response
	// is sent back to the caller.
	Mode string `json:"mode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConnectorName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConnectorName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *IndexItemRequest) MarshalJSON() ([]byte, error) {
	type NoMethod IndexItemRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InitializeCustomerRequest: Request message for `InitializeCustomer`
// method.
type InitializeCustomerRequest struct {
}

type InsertContent struct {
	// Content: The content to be inserted.
	Content string `json:"content,omitempty"`

	// ContentType: The type of inserted content.
	//
	// Possible values:
	//   "UNSPECIFIED_CONTENT_TYPE" - Default value when nothing is set for
	// ContentType.
	//   "TEXT" - Specifies that the content is in plain text.
	//   "MUTABLE_HTML" - Specifies that the content is in HTML and is
	// mutable (can be edited).
	//   "IMMUTABLE_HTML" - Specifies that the content is in HTML and is
	// immutable (cannot be edited).
	ContentType string `json:"contentType,omitempty"`

	// Possible values:
	//   "UNSPECIFIED_EMAIL_MIME_TYPE" - Default value when nothing is set
	// for EmailMimeType.
	//   "PLAIN_TEXT" - Specifies that the inserted content is in plain
	// text.
	//   "HTML" - Specifies that the inserted content is in HTML.
	MimeType string `json:"mimeType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InsertContent) MarshalJSON() ([]byte, error) {
	type NoMethod InsertContent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IntegerFacetingOptions: Used to specify integer faceting options.
type IntegerFacetingOptions struct {
	// IntegerBuckets: Buckets for given integer values should be in
	// strictly ascending order. For example, if values supplied are
	// (1,5,10,100), the following facet buckets will be formed {<1, [1,5),
	// [5-10), [10-100), >=100}.
	IntegerBuckets googleapi.Int64s `json:"integerBuckets,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IntegerBuckets") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IntegerBuckets") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *IntegerFacetingOptions) MarshalJSON() ([]byte, error) {
	type NoMethod IntegerFacetingOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IntegerOperatorOptions: Used to provide a search operator for integer
// properties. This is optional. Search operators let users restrict the
// query to specific fields relevant to the type of item being searched.
type IntegerOperatorOptions struct {
	// GreaterThanOperatorName: Indicates the operator name required in the
	// query in order to isolate the integer property using the greater-than
	// operator. For example, if greaterThanOperatorName is *priorityabove*
	// and the property's name is *priorityVal*, then queries like
	// *priorityabove:<value>* show results only where the value of the
	// property named *priorityVal* is greater than *<value>*. The operator
	// name can only contain lowercase letters (a-z). The maximum length is
	// 32 characters.
	GreaterThanOperatorName string `json:"greaterThanOperatorName,omitempty"`

	// LessThanOperatorName: Indicates the operator name required in the
	// query in order to isolate the integer property using the less-than
	// operator. For example, if lessThanOperatorName is *prioritybelow* and
	// the property's name is *priorityVal*, then queries like
	// *prioritybelow:<value>* show results only where the value of the
	// property named *priorityVal* is less than *<value>*. The operator
	// name can only contain lowercase letters (a-z). The maximum length is
	// 32 characters.
	LessThanOperatorName string `json:"lessThanOperatorName,omitempty"`

	// OperatorName: Indicates the operator name required in the query in
	// order to isolate the integer property. For example, if operatorName
	// is *priority* and the property's name is *priorityVal*, then queries
	// like *priority:<value>* show results only where the value of the
	// property named *priorityVal* matches *<value>*. By contrast, a search
	// that uses the same *<value>* without an operator returns all items
	// where *<value>* matches the value of any String properties or text
	// within the content field for the item. The operator name can only
	// contain lowercase letters (a-z). The maximum length is 32 characters.
	OperatorName string `json:"operatorName,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "GreaterThanOperatorName") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GreaterThanOperatorName")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *IntegerOperatorOptions) MarshalJSON() ([]byte, error) {
	type NoMethod IntegerOperatorOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IntegerPropertyOptions: The options for integer properties.
type IntegerPropertyOptions struct {
	// IntegerFacetingOptions: If set, describes integer faceting options
	// for the given integer property. The corresponding integer property
	// should be marked isFacetable.
	IntegerFacetingOptions *IntegerFacetingOptions `json:"integerFacetingOptions,omitempty"`

	// MaximumValue: The maximum value of the property. The minimum and
	// maximum values for the property are used to rank results according to
	// the ordered ranking. Indexing requests with values greater than the
	// maximum are accepted and ranked with the same weight as items indexed
	// with the maximum value.
	MaximumValue int64 `json:"maximumValue,omitempty,string"`

	// MinimumValue: The minimum value of the property. The minimum and
	// maximum values for the property are used to rank results according to
	// the ordered ranking. Indexing requests with values less than the
	// minimum are accepted and ranked with the same weight as items indexed
	// with the minimum value.
	MinimumValue int64 `json:"minimumValue,omitempty,string"`

	// OperatorOptions: If set, describes how the integer should be used as
	// a search operator.
	OperatorOptions *IntegerOperatorOptions `json:"operatorOptions,omitempty"`

	// OrderedRanking: Used to specify the ordered ranking for the integer.
	// Can only be used if isRepeatable is false.
	//
	// Possible values:
	//   "NO_ORDER" - There is no ranking order for the property. Results
	// are not adjusted by this property's value.
	//   "ASCENDING" - This property is ranked in ascending order. Lower
	// values indicate lower ranking.
	//   "DESCENDING" - This property is ranked in descending order. Lower
	// values indicate higher ranking.
	OrderedRanking string `json:"orderedRanking,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "IntegerFacetingOptions") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IntegerFacetingOptions")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *IntegerPropertyOptions) MarshalJSON() ([]byte, error) {
	type NoMethod IntegerPropertyOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IntegerValues: List of integer values.
type IntegerValues struct {
	Values googleapi.Int64s `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Values") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *IntegerValues) MarshalJSON() ([]byte, error) {
	type NoMethod IntegerValues
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type IntegrationConfigMutation struct {
	// AddApp: Add an app using its identifier.
	AddApp *AppId `json:"addApp,omitempty"`

	// AddPinnedItem: Add a pinned tab using its identifier.
	AddPinnedItem *PinnedItemId `json:"addPinnedItem,omitempty"`

	// RemoveApp: Remove an active app using its identifier.
	RemoveApp *AppId `json:"removeApp,omitempty"`

	// RemovePinnedItem: Remove an active pinned tab using its identifier.
	RemovePinnedItem *PinnedItemId `json:"removePinnedItem,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AddApp") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddApp") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *IntegrationConfigMutation) MarshalJSON() ([]byte, error) {
	type NoMethod IntegrationConfigMutation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IntegrationConfigUpdatedMetadata: Annotation metadata to display
// system message for integration config updated event. This metadata is
// stored in spanner, and can be dispatched to clients without any field
// modification or transformation.
type IntegrationConfigUpdatedMetadata struct {
	// InitiatorId: The user whose action triggered this system message.
	InitiatorId *UserId `json:"initiatorId,omitempty"`

	// Mutations: A list of updates applied on the integration config.
	Mutations []*IntegrationConfigMutation `json:"mutations,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InitiatorId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InitiatorId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *IntegrationConfigUpdatedMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod IntegrationConfigUpdatedMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Interaction: Represents an interaction between a user and an item.
type Interaction struct {
	// InteractionTime: The time when the user acted on the item. If
	// multiple actions of the same type exist for a single user, only the
	// most recent action is recorded.
	InteractionTime string `json:"interactionTime,omitempty"`

	// Principal: The user that acted on the item.
	Principal *Principal `json:"principal,omitempty"`

	// Possible values:
	//   "UNSPECIFIED" - Invalid value.
	//   "VIEW" - This interaction indicates the user viewed the item.
	//   "EDIT" - This interaction indicates the user edited the item.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InteractionTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InteractionTime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Interaction) MarshalJSON() ([]byte, error) {
	type NoMethod Interaction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InviteAcceptedEvent struct {
	ParticipantId []*StoredParticipantId `json:"participantId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ParticipantId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ParticipantId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InviteAcceptedEvent) MarshalJSON() ([]byte, error) {
	type NoMethod InviteAcceptedEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InviteeInfo: Invitee information from a Dynamite invitation. See
// go/dynamite-invitee-mgmt.
type InviteeInfo struct {
	// Email: Email as typed by the user when invited to Room or DM. This
	// value will be canonicalized and hashed before retained in storage.
	Email string `json:"email,omitempty"`

	// UserId: Unique, immutable ID of the User.
	UserId *UserId `json:"userId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Email") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InviteeInfo) MarshalJSON() ([]byte, error) {
	type NoMethod InviteeInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Item: Represents a single object that is an item in the search index,
// such as a file, folder, or a database record.
type Item struct {
	// Acl: Access control list for this item.
	Acl *ItemAcl `json:"acl,omitempty"`

	// Content: Item content to be indexed and made text searchable.
	Content *ItemContent `json:"content,omitempty"`

	// ItemType: The type for this item.
	//
	// Possible values:
	//   "UNSPECIFIED"
	//   "CONTENT_ITEM" - An item that is indexed for the only purpose of
	// serving information. These items cannot be referred in containerName
	// or inheritAclFrom fields.
	//   "CONTAINER_ITEM" - An item that gets indexed and whose purpose is
	// to supply other items with ACLs and/or contain other items.
	//   "VIRTUAL_CONTAINER_ITEM" - An item that does not get indexed, but
	// otherwise has the same purpose as CONTAINER_ITEM.
	ItemType string `json:"itemType,omitempty"`

	// Metadata: The metadata information.
	Metadata *ItemMetadata `json:"metadata,omitempty"`

	// Name: The name of the Item. Format:
	// datasources/{source_id}/items/{item_id} This is a required field. The
	// maximum length is 1536 characters.
	Name string `json:"name,omitempty"`

	// Payload: Additional state connector can store for this item. The
	// maximum length is 10000 bytes.
	Payload string `json:"payload,omitempty"`

	// Queue: Queue this item belongs to. The maximum length is 100
	// characters.
	Queue string `json:"queue,omitempty"`

	// Status: Status of the item. Output only field.
	Status *ItemStatus `json:"status,omitempty"`

	// StructuredData: The structured data for the item that should conform
	// to a registered object definition in the schema for the data source.
	StructuredData *ItemStructuredData `json:"structuredData,omitempty"`

	// Version: Required. The indexing system stores the version from the
	// datasource as a byte string and compares the Item version in the
	// index to the version of the queued Item using lexical ordering. Cloud
	// Search Indexing won't index or delete any queued item with a version
	// value that is less than or equal to the version of the currently
	// indexed item. The maximum length for this field is 1024 bytes. For
	// information on how item version affects the deletion process, refer
	// to Handle revisions after manual deletes
	// (https://developers.google.com/cloud-search/docs/guides/operations).
	Version string `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Acl") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Acl") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Item) MarshalJSON() ([]byte, error) {
	type NoMethod Item
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ItemAcl: Access control list information for the item. For more
// information see Map ACLs
// (https://developers.google.com/cloud-search/docs/guides/acls).
type ItemAcl struct {
	// AclInheritanceType: Sets the type of access rules to apply when an
	// item inherits its ACL from a parent. This should always be set in
	// tandem with the inheritAclFrom field. Also, when the inheritAclFrom
	// field is set, this field should be set to a valid AclInheritanceType.
	//
	// Possible values:
	//   "NOT_APPLICABLE" - The default value when this item does not
	// inherit an ACL. Use NOT_APPLICABLE when inheritAclFrom is empty. An
	// item without ACL inheritance can still have ACLs supplied by its own
	// readers and deniedReaders fields.
	//   "CHILD_OVERRIDE" - During an authorization conflict, the ACL of the
	// child item determines its read access.
	//   "PARENT_OVERRIDE" - During an authorization conflict, the ACL of
	// the parent item specified in the inheritAclFrom field determines read
	// access.
	//   "BOTH_PERMIT" - Access is granted only if this item and the parent
	// item specified in the inheritAclFrom field both permit read access.
	AclInheritanceType string `json:"aclInheritanceType,omitempty"`

	// DeniedReaders: List of principals who are explicitly denied access to
	// the item in search results. While principals are denied access by
	// default, use denied readers to handle exceptions and override the
	// list allowed readers. The maximum number of elements is 100.
	DeniedReaders []*Principal `json:"deniedReaders,omitempty"`

	// InheritAclFrom: The name of the item to inherit the Access Permission
	// List (ACL) from. Note: ACL inheritance *only* provides access
	// permissions to child items and does not define structural
	// relationships, nor does it provide convenient ways to delete large
	// groups of items. Deleting an ACL parent from the index only alters
	// the access permissions of child items that reference the parent in
	// the inheritAclFrom field. The item is still in the index, but may not
	// visible in search results. By contrast, deletion of a container item
	// also deletes all items that reference the container via the
	// containerName field. The maximum length for this field is 1536
	// characters.
	InheritAclFrom string `json:"inheritAclFrom,omitempty"`

	// Owners: Optional. List of owners for the item. This field has no
	// bearing on document access permissions. It does, however, offer a
	// slight ranking boosts items where the querying user is an owner. The
	// maximum number of elements is 5.
	Owners []*Principal `json:"owners,omitempty"`

	// Readers: List of principals who are allowed to see the item in search
	// results. Optional if inheriting permissions from another item or if
	// the item is not intended to be visible, such as virtual containers.
	// The maximum number of elements is 1000.
	Readers []*Principal `json:"readers,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AclInheritanceType")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AclInheritanceType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ItemAcl) MarshalJSON() ([]byte, error) {
	type NoMethod ItemAcl
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ItemContent: Content of an item to be indexed and surfaced by Cloud
// Search. Only UTF-8 encoded strings are allowed as inlineContent. If
// the content is uploaded and not binary, it must be UTF-8 encoded.
type ItemContent struct {
	// ContentDataRef: Upload reference ID of a previously uploaded content
	// via write method.
	ContentDataRef *UploadItemRef `json:"contentDataRef,omitempty"`

	// Possible values:
	//   "UNSPECIFIED" - Invalid value.
	//   "HTML" - contentFormat is HTML.
	//   "TEXT" - contentFormat is free text.
	//   "RAW" - contentFormat is raw bytes.
	ContentFormat string `json:"contentFormat,omitempty"`

	// Hash: Hashing info calculated and provided by the API client for
	// content. Can be used with the items.push method to calculate modified
	// state. The maximum length is 2048 characters.
	Hash string `json:"hash,omitempty"`

	// InlineContent: Content that is supplied inlined within the update
	// method. The maximum length is 102400 bytes (100 KiB).
	InlineContent string `json:"inlineContent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContentDataRef") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentDataRef") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ItemContent) MarshalJSON() ([]byte, error) {
	type NoMethod ItemContent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ItemCountByStatus struct {
	// Count: Number of items matching the status code.
	Count int64 `json:"count,omitempty,string"`

	// IndexedItemsCount: Number of items matching the status code for which
	// billing is done. This excludes virtual container items from the total
	// count. This count would not be applicable for items with ERROR or
	// NEW_ITEM status code.
	IndexedItemsCount int64 `json:"indexedItemsCount,omitempty,string"`

	// StatusCode: Status of the items.
	//
	// Possible values:
	//   "CODE_UNSPECIFIED" - Input-only value. Used with Items.list to list
	// all items in the queue, regardless of status.
	//   "ERROR" - Error encountered by Cloud Search while processing this
	// item. Details of the error are in repositoryError.
	//   "MODIFIED" - Item has been modified in the repository, and is out
	// of date with the version previously accepted into Cloud Search.
	//   "NEW_ITEM" - Item is known to exist in the repository, but is not
	// yet accepted by Cloud Search. An item can be in this state when
	// Items.push has been called for an item of this name that did not
	// exist previously.
	//   "ACCEPTED" - API has accepted the up-to-date data of this item.
	StatusCode string `json:"statusCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Count") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ItemCountByStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ItemCountByStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ItemMetadata: Available metadata fields for the item.
type ItemMetadata struct {
	// ContainerName: The name of the container for this item. Deletion of
	// the container item leads to automatic deletion of this item. Note:
	// ACLs are not inherited from a container item. To provide ACL
	// inheritance for an item, use the inheritAclFrom field. The maximum
	// length is 1536 characters.
	ContainerName string `json:"containerName,omitempty"`

	// ContentLanguage: The BCP-47 language code for the item, such as
	// "en-US" or "sr-Latn". For more information, see
	// http://www.unicode.org/reports/tr35/#Unicode_locale_identifier. The
	// maximum length is 32 characters.
	ContentLanguage string `json:"contentLanguage,omitempty"`

	// ContextAttributes: A set of named attributes associated with the
	// item. This can be used for influencing the ranking of the item based
	// on the context in the request. The maximum number of elements is 10.
	ContextAttributes []*ContextAttribute `json:"contextAttributes,omitempty"`

	// CreateTime: The time when the item was created in the source
	// repository.
	CreateTime string `json:"createTime,omitempty"`

	// Hash: Hashing value provided by the API caller. This can be used with
	// the items.push method to calculate modified state. The maximum length
	// is 2048 characters.
	Hash string `json:"hash,omitempty"`

	// Interactions: A list of interactions for the item. Interactions are
	// used to improve Search quality, but are not exposed to end users. The
	// maximum number of elements is 1000.
	Interactions []*Interaction `json:"interactions,omitempty"`

	// Keywords: Additional keywords or phrases that should match the item.
	// Used internally for user generated content. The maximum number of
	// elements is 100. The maximum length is 8192 characters.
	Keywords []string `json:"keywords,omitempty"`

	// MimeType: The original mime-type of ItemContent.content in the source
	// repository. The maximum length is 256 characters.
	MimeType string `json:"mimeType,omitempty"`

	// ObjectType: The type of the item. This should correspond to the name
	// of an object definition in the schema registered for the data source.
	// For example, if the schema for the data source contains an object
	// definition with name 'document', then item indexing requests for
	// objects of that type should set objectType to 'document'. The maximum
	// length is 256 characters.
	ObjectType string `json:"objectType,omitempty"`

	// SearchQualityMetadata: Additional search quality metadata of the item
	SearchQualityMetadata *SearchQualityMetadata `json:"searchQualityMetadata,omitempty"`

	// SourceRepositoryUrl: Link to the source repository serving the data.
	// Seach results apply this link to the title. Whitespace or special
	// characters may cause Cloud Seach result links to trigger a redirect
	// notice; to avoid this, encode the URL. The maximum length is 2048
	// characters.
	SourceRepositoryUrl string `json:"sourceRepositoryUrl,omitempty"`

	// Title: The title of the item. If given, this will be the displayed
	// title of the Search result. The maximum length is 2048 characters.
	Title string `json:"title,omitempty"`

	// UpdateTime: The time when the item was last modified in the source
	// repository.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContainerName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContainerName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ItemMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod ItemMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ItemParts: Container for type-specific extensions of an Item. This
// protobuf is defined in a separate file to allow types to
// reference/extend the message without depending on other fusebox
// protobufs. See items.proto.
type ItemParts struct {
}

// ItemStatus: This contains item's status and any errors.
type ItemStatus struct {
	// Code: Status code.
	//
	// Possible values:
	//   "CODE_UNSPECIFIED" - Input-only value. Used with Items.list to list
	// all items in the queue, regardless of status.
	//   "ERROR" - Error encountered by Cloud Search while processing this
	// item. Details of the error are in repositoryError.
	//   "MODIFIED" - Item has been modified in the repository, and is out
	// of date with the version previously accepted into Cloud Search.
	//   "NEW_ITEM" - Item is known to exist in the repository, but is not
	// yet accepted by Cloud Search. An item can be in this state when
	// Items.push has been called for an item of this name that did not
	// exist previously.
	//   "ACCEPTED" - API has accepted the up-to-date data of this item.
	Code string `json:"code,omitempty"`

	// ProcessingErrors: Error details in case the item is in ERROR state.
	ProcessingErrors []*ProcessingError `json:"processingErrors,omitempty"`

	// RepositoryErrors: Repository error reported by connector.
	RepositoryErrors []*RepositoryError `json:"repositoryErrors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ItemStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ItemStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ItemStructuredData: Available structured data fields for the item.
type ItemStructuredData struct {
	// Hash: Hashing value provided by the API caller. This can be used with
	// the items.push method to calculate modified state. The maximum length
	// is 2048 characters.
	Hash string `json:"hash,omitempty"`

	// Object: The structured data object that should conform to a
	// registered object definition in the schema for the data source.
	Object *StructuredDataObject `json:"object,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Hash") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Hash") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ItemStructuredData) MarshalJSON() ([]byte, error) {
	type NoMethod ItemStructuredData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ItemThread: An ItemThread is an ordered list of Items. An ItemThread
// corresponds to a "conversation" in the context of mail. An Item
// belongs to exactly one ItemThread.
type ItemThread struct {
	ClusterInfo *ClusterInfo `json:"clusterInfo,omitempty"`

	// Item: The Items in the ItemThread. In the context of a search, the
	// list of Items may be a subset of those that logically belong to the
	// ItemThread. The details of which items are included are available in
	// the ItemThreadView returned in the overall rpc response.
	Item []*FuseboxItem `json:"item,omitempty"`

	// LastItemId: The server id of the last item returned in the
	// ItemThread. This can be deduced from the [item] list but is provided
	// for convenience. When manually constructing an ItemThreadViewSpec to
	// perform operations on the ItemThread, this value can be used as the
	// [high_item_id_watermark].
	LastItemId uint64 `json:"lastItemId,omitempty,string"`

	MatchInfo *FuseboxItemThreadMatchInfo `json:"matchInfo,omitempty"`

	// Snippet: A snippet summarizing the thread. This field is only
	// populated for searches.
	Snippet string `json:"snippet,omitempty"`

	// ThreadKey: The MultiKey that identifies this thread. This value never
	// changes, i.e. remains constant across modifications to the thread,
	// including addition, relabeling, or deletion of contained Items. As
	// such, the thread key may not necessarily correspond to the key of an
	// contained Item. Legacy note: The "server_id" of the thread key is
	// equivalent to the notion of the "original thread id" in the CSS API.
	ThreadKey *MultiKey `json:"threadKey,omitempty"`

	// ThreadLocator: A base64 encoded and encrypted string generated from
	// the Gaia Id and the thread id. Used to generate the permalink for
	// this thread, exposed from Gmail API.
	ThreadLocator string `json:"threadLocator,omitempty"`

	// TopicState: Next available id : 10
	TopicState *TopicState `json:"topicState,omitempty"`

	// Version: The latest history operation id that resulted in a mutation
	// of any item in the thread.
	Version uint64 `json:"version,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ClusterInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClusterInfo") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ItemThread) MarshalJSON() ([]byte, error) {
	type NoMethod ItemThread
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// JobsettedServerSpec: Identifies a jobsetted server as a target for
// Trigger dispatch.
type JobsettedServerSpec struct {
	// PortName: E.g. "gateway", "stubby" etc. Leave unset to use the
	// default unnamed port.
	PortName string `json:"portName,omitempty"`

	// ServerName: E.g. "satellite-server", "bigtop-sync", etc.
	ServerName string `json:"serverName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PortName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PortName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *JobsettedServerSpec) MarshalJSON() ([]byte, error) {
	type NoMethod JobsettedServerSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type KeyValue struct {
	// BottomLabel: Formatted text supported.
	BottomLabel string `json:"bottomLabel,omitempty"`

	Button *Button `json:"button,omitempty"`

	// Content: Formatted text supported and always required.
	Content string `json:"content,omitempty"`

	ContentMultiline bool `json:"contentMultiline,omitempty"`

	EndIcon *IconImage `json:"endIcon,omitempty"`

	// Possible values:
	//   "NONE"
	//   "AIRPLANE"
	//   "BOOKMARK"
	//   "BUS"
	//   "CAR"
	//   "CLOCK"
	//   "CONFIRMATION_NUMBER_ICON"
	//   "DOLLAR"
	//   "DESCRIPTION"
	//   "EDIT"
	//   "EDIT_NOTE"
	//   "EMAIL"
	//   "EVENT_PERFORMER"
	//   "EVENT_SEAT"
	//   "FLIGHT_ARRIVAL"
	//   "FLIGHT_DEPARTURE"
	//   "HOTEL"
	//   "HOTEL_ROOM_TYPE"
	//   "INVITE"
	//   "MAP_PIN"
	//   "MEMBERSHIP"
	//   "MULTIPLE_PEOPLE"
	//   "OFFER"
	//   "OPEN_IN_NEW"
	//   "PERSON"
	//   "PHONE"
	//   "RESTAURANT_ICON"
	//   "SHOPPING_CART"
	//   "STAR"
	//   "STORE"
	//   "TICKET"
	//   "TRAIN"
	//   "VIDEO_CAMERA"
	//   "VIDEO_PLAY" - Add new items in alphabetical order. Next Available
	// ID: 34
	Icon string `json:"icon,omitempty"`

	// IconAltText: The alternative text of this icon_url which will be used
	// for accessibility.
	IconAltText string `json:"iconAltText,omitempty"`

	IconUrl string `json:"iconUrl,omitempty"`

	// Possible values:
	//   "CROP_TYPE_NOT_SET" - No value specified.
	//   "SQUARE" - Applies a square crop.
	//   "CIRCLE" - Applies a circular crop.
	//   "RECTANGLE_CUSTOM" - Applies a rectangular crop with a custom
	// aspect ratio.
	//   "RECTANGLE_4_3" - Applies a rectangular crop with a 4:3 aspect
	// ratio.
	ImageStyle string `json:"imageStyle,omitempty"`

	// OnClick: Only the top/bottom label + content region is clickable.
	OnClick *OnClick `json:"onClick,omitempty"`

	// StartIcon: The optional icon to display before the text content.
	StartIcon *IconImage `json:"startIcon,omitempty"`

	SwitchWidget *SwitchWidget `json:"switchWidget,omitempty"`

	// TopLabel: Formatted text supported.
	TopLabel string `json:"topLabel,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BottomLabel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BottomLabel") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *KeyValue) MarshalJSON() ([]byte, error) {
	type NoMethod KeyValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LabelAdded: A label was added to some (subset of the) messages in
// this thread.
type LabelAdded struct {
	LabelId string `json:"labelId,omitempty"`

	LabelName string `json:"labelName,omitempty"`

	MessageKeys []*MultiKey `json:"messageKeys,omitempty"`

	SyncId int64 `json:"syncId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LabelId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LabelId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LabelAdded) MarshalJSON() ([]byte, error) {
	type NoMethod LabelAdded
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LabelCreated: A label was created.
type LabelCreated struct {
}

// LabelDeleted: A label was deleted.
type LabelDeleted struct {
}

// LabelRemoved: A label was removed from some (subset of the) messages
// in this thread.
type LabelRemoved struct {
	LabelId string `json:"labelId,omitempty"`

	LabelName string `json:"labelName,omitempty"`

	MessageKeys []*MultiKey `json:"messageKeys,omitempty"`

	SyncId int64 `json:"syncId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LabelId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LabelId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LabelRemoved) MarshalJSON() ([]byte, error) {
	type NoMethod LabelRemoved
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LabelRenamed: A label was renamed.
type LabelRenamed struct {
	OldCanonicalName string `json:"oldCanonicalName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OldCanonicalName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OldCanonicalName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *LabelRenamed) MarshalJSON() ([]byte, error) {
	type NoMethod LabelRenamed
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LabelUpdate: HistoryRecord for changes associated with a label,
// namely: LABEL_CREATED LABEL_DELETED LABEL_RENAMED LABEL_UPDATED
type LabelUpdate struct {
	CanonicalName string `json:"canonicalName,omitempty"`

	LabelCreated *LabelCreated `json:"labelCreated,omitempty"`

	LabelDeleted *LabelDeleted `json:"labelDeleted,omitempty"`

	LabelId string `json:"labelId,omitempty"`

	LabelRenamed *LabelRenamed `json:"labelRenamed,omitempty"`

	LabelUpdated *LabelUpdated `json:"labelUpdated,omitempty"`

	SyncId int64 `json:"syncId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanonicalName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanonicalName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LabelUpdate) MarshalJSON() ([]byte, error) {
	type NoMethod LabelUpdate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LabelUpdated: A label pref was updated outside of a rename, create,
// or delete.
type LabelUpdated struct {
}

type Labels struct {
	// DisplayName: The display name of the labels. This is populated
	// (instead of the id) when the request fetch_spec has
	// LABEL_DISPLAY_NAMES.
	DisplayName []string `json:"displayName,omitempty"`

	// Id: The ids of the labels attached to the Item, e.g. "^i", "^x_1"
	Id []string `json:"id,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Labels) MarshalJSON() ([]byte, error) {
	type NoMethod Labels
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LanguageConfig: The language configuration for the session.
type LanguageConfig struct {
	// SpokenLanguages: The spoken language(s) in BCP47 language code.
	SpokenLanguages []string `json:"spokenLanguages,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SpokenLanguages") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SpokenLanguages") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *LanguageConfig) MarshalJSON() ([]byte, error) {
	type NoMethod LanguageConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LdapGroupProto struct {
	GroupName string `json:"groupName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GroupName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GroupName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LdapGroupProto) MarshalJSON() ([]byte, error) {
	type NoMethod LdapGroupProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type LdapUserProto struct {
	UserName string `json:"userName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "UserName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LdapUserProto) MarshalJSON() ([]byte, error) {
	type NoMethod LdapUserProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LegacyUploadMetadata: The original UploadMetadata that this
// DriveMetadata was converted from.
type LegacyUploadMetadata struct {
	// LegacyUniqueId: A unique ID generated from legacy UploadMetadata.
	// This is used for interopping URLs after uploading blob to shared
	// drive. Links in Classic might break without this.
	// go/drive-file-attachment-interop-from-dynamite.
	LegacyUniqueId string `json:"legacyUniqueId,omitempty"`

	// UploadMetadata: The blob in this UploadMetadata has been uploaded to
	// shared drive. This UploadMetadata is no longer attached to a message.
	// go/shared-drive-data-migration.
	UploadMetadata *UploadMetadata `json:"uploadMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LegacyUniqueId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LegacyUniqueId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *LegacyUploadMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod LegacyUploadMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LinkData: Link metadata, for LINK segments. Anchor text should be
// stored in the "text" field of the Segment, which can also serve as a
// fallback.
type LinkData struct {
	// Attachment: An Attachment represents the structured entity to which
	// we are linking. It contains an Embed
	// (apps/tacotown/proto/embeds/embed_client.proto) with fields specific
	// to the appropriate type of linked entity. For example, if we are
	// linking to a photo album, the Embed may include the album ID and gaia
	// ID of the creator. Clients that understand the Embed type within the
	// Attachment may construct and/or decorate their link appropriately
	// e.g. to make use of type-specific functionality or first-party
	// integrations. The link_target and (if appropriate) display_url fields
	// must still be set even when an Attachment is present, so that clients
	// who do not know how to interpret the Attachment can fall back to
	// those fields, and render the Segment as an ordinary web link. N.B.
	// Even when an Attachment is present, the intention of a "LINK" Segment
	// is for the Segment to be presented inline with the rest of the text
	// of a post or comment, with a clickable link or other UI suitable for
	// inlining (though the client may modify the UI based on Attachment
	// data, e.g. to add appropriate hovers, icons, etc.). When an entity is
	// intended to be rendered separately from the main body of the
	// post/comment, a separate Attachment proto can be added outside the
	// set of Segments. N.B. Within the Attachment, fields of
	// EmbedClientItem have their own visibility annotations, which should
	// be enforced separately from Segment visibility annotations. See:
	// apps/tacotown/proto/embeds/embed_annotations.proto
	Attachment *SocialCommonAttachmentAttachment `json:"attachment,omitempty"`

	// AttachmentRenderHint: The hint to use when rendering the associated
	// attachment. Ignored if there is no associated attachment.
	//
	// Possible values:
	//   "ATTACHMENT_RENDER_HINT_UNKNOWN" - No rendering hint; should not be
	// used (equivalent to having no hint)
	//   "ATTACHMENT_RENDER_HINT_AFTER" - Render any associated attachment
	// at the end of the block, after all sibling Segments. Leave the link
	// in place in the text and render it normally as well.
	//   "ATTACHMENT_RENDER_HINT_INTERLEAVED" - Render any associated
	// attachment inline in the text in place of the link text, forcing a
	// line break before and after the attachment so the text and the
	// attachment are "interleaved". If this is not possible, render as if
	// AFTER.
	AttachmentRenderHint string `json:"attachmentRenderHint,omitempty"`

	// DisplayUrl: If we wish to show the user a different (e.g. shortened)
	// version of the URL for display purposes, then that version should be
	// set here. If this field isn't set, link_target will be used for both
	// purposes.
	DisplayUrl string `json:"displayUrl,omitempty"`

	// LinkTarget: link_target is the URL to navigate to when clicked. This
	// could be the original URL, or a URL signed by the GWS URL signing
	// service.
	LinkTarget string `json:"linkTarget,omitempty"`

	// LinkType: LinkType is an optional field that provides additional
	// information regarding link target. For example, link type can be
	// identified as the SELF_LINK when the request was executed from the
	// same link as the link target.
	//
	// Possible values:
	//   "UNKNOWN_LINK_TYPE" - No link type specified.
	//   "SELF_LINK" - This indicates that the link target points to the
	// same object related to this segment. Example: A YouTube link with
	// text="0.07" and link_target:
	// "https://www.youtube.com/watch?v=leHVmSqd4_w&t=0m07s" points to the
	// same YouTube video where this segment appears. See
	// http://go/ignore-badwords-filtering-for-selflink for adding link_type
	// design document.
	LinkType string `json:"linkType,omitempty"`

	// Title: Title is an optional field that provides a short string that
	// describes the link or its destination. User interfaces often use
	// title as a tooltip or for accessibility purposes. However, they are
	// of course free to present this data in any form. This field is plain
	// text.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Attachment") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attachment") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LinkData) MarshalJSON() ([]byte, error) {
	type NoMethod LinkData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ListDataSourceResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	Sources []*DataSource `json:"sources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListDataSourceResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDataSourceResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ListItemNamesForUnmappedIdentityResponse struct {
	ItemNames []string `json:"itemNames,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ItemNames") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ItemNames") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListItemNamesForUnmappedIdentityResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListItemNamesForUnmappedIdentityResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ListItemsResponse struct {
	Items []*Item `json:"items,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Items") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListItemsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListItemsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for
// Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Operations: A list of operations that matches the specified filter in
	// the request.
	Operations []*Operation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListQuerySourcesResponse: List sources response.
type ListQuerySourcesResponse struct {
	NextPageToken string `json:"nextPageToken,omitempty"`

	Sources []*QuerySource `json:"sources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListQuerySourcesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListQuerySourcesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ListSearchApplicationsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	SearchApplications []*SearchApplication `json:"searchApplications,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListSearchApplicationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSearchApplicationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ListUnmappedIdentitiesResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	UnmappedIdentities []*UnmappedIdentity `json:"unmappedIdentities,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListUnmappedIdentitiesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListUnmappedIdentitiesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type MatchInfo struct {
	// MatchingImageReferenceKey: Reference keys for image attachments that
	// matches search query.
	MatchingImageReferenceKey []string `json:"matchingImageReferenceKey,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "MatchingImageReferenceKey") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "MatchingImageReferenceKey") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MatchInfo) MarshalJSON() ([]byte, error) {
	type NoMethod MatchInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MatchRange: Matched range of a snippet [start, end).
type MatchRange struct {
	// End: End of the match in the snippet.
	End int64 `json:"end,omitempty"`

	// Start: Starting position of the match in the snippet.
	Start int64 `json:"start,omitempty"`

	// ForceSendFields is a list of field names (e.g. "End") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "End") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MatchRange) MarshalJSON() ([]byte, error) {
	type NoMethod MatchRange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MdbGroupProto: An entity from the MDB namespace that is to be
// interpreted as a group. If using this for authorization, you should
// do an exact match of the peer role against group_name or any of the
// names in the Chubby expansion of the MDB group named group_name.
type MdbGroupProto struct {
	GroupName string `json:"groupName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GroupName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GroupName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MdbGroupProto) MarshalJSON() ([]byte, error) {
	type NoMethod MdbGroupProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MdbUserProto: An entity from the MDB namespace that is to be
// interpreted as a user. If using this for authorization, you should
// only do an exact match on the peer role against user_name.
type MdbUserProto struct {
	// GaiaId: Do not set this field. Contact credentials-eng@ if you
	// believe you absolutely need to use it. This is the @prod.google.com
	// Gaia ID that corresponds to the MDB user, see go/authn-merge for
	// details. This field may always be safely ignored when performing an
	// authorization check.
	GaiaId int64 `json:"gaiaId,omitempty,string"`

	UserName string `json:"userName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GaiaId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GaiaId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MdbUserProto) MarshalJSON() ([]byte, error) {
	type NoMethod MdbUserProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Media: Media resource.
type Media struct {
	// ResourceName: Name of the media resource.
	ResourceName string `json:"resourceName,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ResourceName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Media) MarshalJSON() ([]byte, error) {
	type NoMethod Media
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MeetingSpace:  A meeting space is a persistent object that is the
// context for one or more calls. The meeting space is what makes users
// find each other when they want to meet and to find shared resources.
// With two exceptions, all the fields in the meeting space resource are
// visible publicly to any client, even anonymous users. The exceptions
// are that * The call_info field is only visible to clients that have a
// device (as indicated by the meeting token) in the JOINED or HIDDEN
// state. * The meeting_alias field will only be set for users who are
// in the same domain as the meeting space. The meeting space resource
// (outside call_info) should only contain information necessary to join
// a call in the meeting space, and not any other metadata about the
// meeting space, such as what organization it belongs to or things
// related to ongoing calls.
type MeetingSpace struct {
	// AcceptedNumberClass: Which number classes are accepted by this
	// meeting at the moment? When there is no ongoing conference, this
	// field may change independent of the version number of the
	// MeetingSpace. When a conference starts, this field will be locked to
	// the value at that time, and then will be unlocked again at the end of
	// the conference.
	//
	// Possible values:
	//   "NUMBER_CLASS_UNSPECIFIED" - No number class has been specified.
	//   "LOW_COST" - The number has a low cost to receive calls on.
	//   "HIGH_COST" - The number has a high cost to receive calls on.
	//   "LEGACY" - Class for legacy numbers.
	AcceptedNumberClass []string `json:"acceptedNumberClass,omitempty"`

	// BroadcastAccess: Broadcast access information for this meeting space.
	BroadcastAccess *BroadcastAccess `json:"broadcastAccess,omitempty"`

	// CallInfo: Information relevant to an ongoing conference. This field
	// will be set in responses if the client requesting the meeting space
	// has a device in one of the JOINED, HIDDEN, or MISSING_PREREQUISITES
	// states. The field will also be set without a created device if the
	// client requesting the meeting space is eligible to directly create a
	// device in the JOINED state without knocking, eg a same-domain joiner.
	// Can also only be updated by clients with a device in the JOINED
	// state.
	CallInfo *CallInfo `json:"callInfo,omitempty"`

	// GatewayAccess: The interop gateway access information for the meeting
	// space. A gateway access can be used when joining conferences from
	// non-Google equipment through an interop gateway.
	GatewayAccess *GatewayAccess `json:"gatewayAccess,omitempty"`

	// GatewaySipAccess: The SIP based access methods that can be used to
	// join the conference.
	GatewaySipAccess []*GatewaySipAccess `json:"gatewaySipAccess,omitempty"`

	// MeetingAlias: An optional alias for the meeting space. The alias can
	// in some cases be resolved to the meeting space, similar to the
	// meeting code. The limitation is that the user needs to be in the same
	// meeting domain as the meeting space.
	MeetingAlias string `json:"meetingAlias,omitempty"`

	// MeetingCode: A meeting code is a globally unique code which points to
	// a meeting space. Note: Meeting codes may be regenerated, which will
	// cause old meeting codes to become invalid.
	MeetingCode string `json:"meetingCode,omitempty"`

	// MeetingSpaceId: A unique server-generated ID for the meeting space.
	// This is the resource name of the meeting space resource and has the
	// form `spaces/`, where is a sequence of characters in the base64url
	// set (https://tools.ietf.org/html/rfc4648#section-5), without any `=`
	// characters.
	MeetingSpaceId string `json:"meetingSpaceId,omitempty"`

	// MeetingUrl: A URL to identify and access the meeting space. Output
	// only.
	MeetingUrl string `json:"meetingUrl,omitempty"`

	// MoreJoinUrl: Output only. A URL that clients (e.g. Calendar) can use
	// to show the web page with all join methods available for this meeting
	// space. This link is also used in iOS universal links and Android
	// intents, used for opening the "More ways to join" view in the Meet
	// mobile apps. Example: https://tel.meet/mee-ting-cod?pin=1234567891011
	// Here, "pin" is the universal phone PIN. We include it explicitly to
	// better support the offline case on the mobile. This is set when the
	// meeting space has either a universal PIN or an interop PIN and
	// clients who can show a "more ways to join" button should show it
	// whenever this field is set.
	MoreJoinUrl string `json:"moreJoinUrl,omitempty"`

	// PhoneAccess: All regional phone access methods for this meeting
	// space. Can be empty.
	PhoneAccess []*PhoneAccess `json:"phoneAccess,omitempty"`

	// Settings: Settings of the meeting space.
	Settings *Settings `json:"settings,omitempty"`

	// UniversalPhoneAccess: A universal phone access method for this
	// meeting space. Can be unset.
	UniversalPhoneAccess *UniversalPhoneAccess `json:"universalPhoneAccess,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AcceptedNumberClass")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AcceptedNumberClass") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *MeetingSpace) MarshalJSON() ([]byte, error) {
	type NoMethod MeetingSpace
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type Member struct {
	Roster *Roster `json:"roster,omitempty"`

	User *User `json:"user,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Roster") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Roster") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Member) MarshalJSON() ([]byte, error) {
	type NoMethod Member
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MemberId: Eventually this can be updated to a oneOf User, Space (for
// nested spaces), Bots or Service, as and when these use cases come up.
type MemberId struct {
	// RosterId: Unique, immutable ID of the Roster.
	RosterId *RosterId `json:"rosterId,omitempty"`

	// UserId: Unique, immutable ID of the User.
	UserId *UserId `json:"userId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RosterId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RosterId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MemberId) MarshalJSON() ([]byte, error) {
	type NoMethod MemberId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type MembershipChangeEvent struct {
	// LeaveReason: This should only be set when MembershipChange type is
	// LEAVE.
	//
	// Possible values:
	//   "LEAVE_REASON_UNKNOWN"
	//   "FORCE_HISTORY_POLICY_CHANGE"
	//   "USER_INITIATED"
	LeaveReason string `json:"leaveReason,omitempty"`

	ParticipantId []*StoredParticipantId `json:"participantId,omitempty"`

	// Possible values:
	//   "JOIN"
	//   "LEAVE"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LeaveReason") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LeaveReason") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MembershipChangeEvent) MarshalJSON() ([]byte, error) {
	type NoMethod MembershipChangeEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MembershipChangedMetadata: Annotation metadata to display system
// messages for membership changes. Next Tag: 8
type MembershipChangedMetadata struct {
	AffectedMemberProfiles []*Member `json:"affectedMemberProfiles,omitempty"`

	// AffectedMembers: List of users and rosters whose membership status
	// changed.
	AffectedMembers []*MemberId `json:"affectedMembers,omitempty"`

	AffectedMemberships []*AffectedMembership `json:"affectedMemberships,omitempty"`

	// Initiator: The user whose action triggered this system message.
	Initiator *UserId `json:"initiator,omitempty"`

	// InitiatorProfile: Complete member profiles, when ListTopicsRequest
	// FetchOptions.USER is set. Otherwise, only the id will be filled in.
	InitiatorProfile *User `json:"initiatorProfile,omitempty"`

	// InitiatorType: The type of the user who initiated this membership
	// change.
	//
	// Possible values:
	//   "INITIATOR_TYPE_UNSPECIFIED"
	//   "INITIATOR_TYPE_END_USER"
	//   "INITIATOR_TYPE_ADMIN"
	InitiatorType string `json:"initiatorType,omitempty"`

	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value for the enum. DO NOT USE.
	//   "INVITED" - Non-member -> Can join. Multiple groups and users.
	//   "JOINED" - Can join -> Member. One user.
	//   "ADDED" - Non-member -> Member. Multiple users.
	//   "REMOVED" - Can join -> Non-member. One group or user.
	//   "LEFT" - Member -> Can join. One user.
	//   "BOT_ADDED" - Bot added to the room.
	//   "BOT_REMOVED" - Bot removed from the room.
	//   "KICKED_DUE_TO_OTR_CONFLICT" - This signifies the user is kicked
	// because the user's OTR policy is conflicted with the room history
	// settings. Joined -> Non-member. One user.
	//   "ROLE_UPDATED" - MembershipRole changed. Multiple users.
	//   "ROLE_TARGET_AUDIENCE_UPDATED" - The room is now joinable by an
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AffectedMemberProfiles") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AffectedMemberProfiles")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *MembershipChangedMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod MembershipChangedMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Menu: This is deprecated and please use SelectionControl by setting
// type to DROPDOWN.
type Menu struct {
	Items []*MenuItem `json:"items,omitempty"`

	// Label: Label used to be displayed ahead of the menu. It is optional.
	Label string `json:"label,omitempty"`

	// Name: The name of the text field which is will be used in FormInput.
	Name string `json:"name,omitempty"`

	// OnChange: If specified, form is submitted when selection changed. If
	// not specified, developer will need to specify a separate button.
	OnChange *FormAction `json:"onChange,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Items") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Menu) MarshalJSON() ([]byte, error) {
	type NoMethod Menu
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type MenuItem struct {
	Selected bool `json:"selected,omitempty"`

	// Text: The text to be displayed.
	Text string `json:"text,omitempty"`

	// Value: The value associated with this item which will be sent back to
	// app scripts. Client should use as a form input value.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Selected") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Selected") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MenuItem) MarshalJSON() ([]byte, error) {
	type NoMethod MenuItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Message: Message posted to a Space.
type Message struct {
	// Annotations: Annotations parsed and extracted from the text body.
	Annotations []*Annotation `json:"annotations,omitempty"`

	// AppProfile: Custom display profile info for apps. Leave the field
	// empty for real users.
	AppProfile *AppsDynamiteSharedAppProfile `json:"appProfile,omitempty"`

	// Attachments: Attachments parsed from incoming webhooks
	Attachments []*Attachment `json:"attachments,omitempty"`

	// Attributes: Lightweight message attributes which values are
	// calculated and set in the servers.
	Attributes *MessageAttributes `json:"attributes,omitempty"`

	// BotResponses: Responses from bots indicating if extra auth/config is
	// needed.
	BotResponses []*BotResponse `json:"botResponses,omitempty"`

	// CommunalLabels: Communal labels associated with a message. These
	// exist on the message itself regardless of which user fetches them.
	// Order of entries is arbitrary and will not list duplicates of the
	// same label_id. See go/chat-labels-design for details.
	CommunalLabels []*CommunalLabelTag `json:"communalLabels,omitempty"`

	ContentReportSummary *ContentReportSummary `json:"contentReportSummary,omitempty"`

	// CreateTime: Time when the Message was posted in microseconds.
	CreateTime int64 `json:"createTime,omitempty,string"`

	// CreatorId: ID of the User who posted the Message. This includes
	// information to identify if this was posted by an App on behalf of a
	// user.
	CreatorId *UserId `json:"creatorId,omitempty"`

	// DeletableBy: Indicates who can delete the message. This field is set
	// on the read path (e.g. ListTopics) but doesn’t have any effect on
	// the write path (e.g. CreateMessageRequest).
	//
	// Possible values:
	//   "PERMISSION_UNSPECIFIED" - Default case, should never be used. If
	// this data is encountered in the DB any request should throw an
	// exception.
	//   "PERMISSION_NO_ONE" - No one except for the message creator/origin
	// pair can mutate. This permission checks both gaia id and the request
	// origin. Request origin can be Chat API or Chat UI. Mutation is
	// allowed iff both attributes of the request match the original message
	// creation. Use case: this allows historical 1P apps lock down message
	// edit permission i.e. In Chat UI, humans cannot edit their messages
	// created via these 1P apps. Do not use this for additional use cases.
	//   "PERMISSION_CREATOR" - The message creator can mutate regardless of
	// request origin. Use case: for messages created by human via Chat UI
	// or Chat API. These messages can be mutated by the same human user via
	// Chat UI or via any app on Chat API.
	//   "PERMISSION_MEMBER" - Every human member of a space or the creator
	// can mutate the entity. This excludes app acting on behalf of human
	// via Chat API. Use case: This is to enable humans to delete messages
	// created by apps.
	DeletableBy string `json:"deletableBy,omitempty"`

	// DeleteTime: Time when the Message was deleted in microseconds. This
	// field is set to nonzero value only for Messages deleted globally.
	DeleteTime int64 `json:"deleteTime,omitempty,string"`

	// DeleteTimeForRequester: Time when the Message was per-user deleted by
	// the message requester in microseconds. This field is set to nonzero
	// value only for Message per-user deleted by the requester.
	DeleteTimeForRequester int64 `json:"deleteTimeForRequester,omitempty,string"`

	// DeletedByVault: Was this message deleted by Vault (Only used for
	// Vault support) This is false if message is live or message was
	// deleted by user.
	DeletedByVault bool `json:"deletedByVault,omitempty"`

	// DlpScanOutcome: Data Loss Prevention scan information for this
	// message. Messages are evaluated in the backend on create
	// message/topic and edit message actions. DEPRECATED: use
	// dlp_scan_summary instead.
	//
	// Possible values:
	//   "SCAN_UNKNOWN_OUTCOME"
	//   "SCAN_SUCCEEDED_NO_VIOLATION" - This means no violation is detected
	// on the given message/attachment.
	//   "SCAN_SUCCEEDED_BLOCK" - Violation is detected. The
	// message/attachment will be blocked (or deleted if this happens in
	// failure recovery), the user will be warned, and the violation will be
	// logged to BIP.
	//   "SCAN_SUCCEEDED_WARN" - Violation is detected. The user will be
	// warned, and the violation will be logged to BIP.
	//   "SCAN_SUCCEEDED_AUDIT_ONLY" - Violation is detected and will be
	// logged to BIP (no user-facing action performed).
	//   "SCAN_FAILURE_EXCEPTION" - Rule fetch and evaluation were attempted
	// but an exception occurred.
	//   "SCAN_FAILURE_RULE_FETCH_FAILED" - Rule fetch was attempted but
	// failed, so rule evaluation could not be performed.
	//   "SCAN_FAILURE_TIMEOUT" - Rule fetch and evaluation were attempted
	// but the scanning timed out.
	//   "SCAN_FAILURE_ALL_RULES_FAILED" - Rule fetch completed and
	// evaluation were attempted, but all of the rules failed to be
	// evaluated.
	//   "SCAN_FAILURE_ILLEGAL_STATE_FOR_ATTACHMENTS" - An
	// IllegalStateException is thrown when executing DLP on attachments.
	// This could happen if the space row is missing.
	//   "SCAN_SKIPPED_EXPERIMENT_DISABLED" - Rule fetch and evaluation is
	// skipped because DLP is not enabled for the user.
	//   "SCAN_SKIPPED_CONSUMER" - Rule fetch and evaluation are skipped
	// because the user sending message is consumer.
	//   "SCAN_SKIPPED_NON_HUMAN_USER" - Rule fetch and evaluation are
	// skipped because the user sending message is a non-human user (i.e. a
	// bot).
	//   "SCAN_SKIPPED_NO_MESSAGE" - Rule fetch and evaluation are skipped
	// because there is no message to scan. Deprecated: this should not
	// happen since there must be message or attachment for DLP scan.
	//   "SCAN_SKIPPED_USER_ACKNOWLEDGED_WARNING" - Rule fetch and
	// evaluation are skipped because the user has acknowledged the warning
	// on the message that triggered the Warn violation and sent the message
	// anyway.
	//   "SCAN_SKIPPED_MESSAGE_FROM_UNSUPPORTED_ORIGIN" - Scanning was
	// skipped because the message originated from Interop or Babel.
	//   "SCAN_SKIPPED_MESSAGE_SENT_DURING_SPACE_MIGRATION" - Scanning was
	// skipped because the message was sent while the space is in migration
	// mode. See go/migration-mode for details.
	//   "SCAN_RULE_EVALUATION_SKIPPED_NO_RULES_FOUND" - Rule fetch
	// happened, but rule evaluation is skipped because no rules were found.
	//
	// "SCAN_RULE_EVALUATION_SKIPPED_NO_APPLICABLE_RULES_FOR_ACTION_PARAMS"
	// - Rule fetch happened, but rule evaluation is skipped because none of
	// the rules are applicable to the given action params.
	//   "SCAN_RULE_EVALUATION_SKIPPED_NO_APPLICABLE_RULES_FOR_TRIGGER" -
	// Rule fetch happened, but rule evaluation is skipped because none of
	// the rules are applicable to the given trigger.
	//   "SCAN_RULE_EVALUATION_SKIPPED_CHANGELING_PERMANENT_ERROR" - Rule
	// fetch happened, but rule evaluation is skipped because Changeling
	// returned permanent failure while converting the attachment to text.
	//   "SCAN_RULE_EVALUATION_SKIPPED_CHANGELING_EMPTY_RESPONSE" - Rule
	// fetch happened, but rule evaluation is skipped because Changeling
	// returned an empty response while converting the attachment to text.
	//   "SCAN_RULE_EVALUATION_SKIPPED_UNSUPPORTED_FILE_TYPE" - Rule fetch
	// happened, but rule evaluation is skipped because file type is
	// unsupported.
	//   "SCAN_SUCCEEDED_WITH_FAILURES_NO_VIOLATION" - Rules were fetched
	// but some evaluations failed. No violation was found in the rules that
	// were successfully evaluated.
	//   "SCAN_SUCCEEDED_WITH_FAILURES_BLOCK" - Rules were fetched but some
	// evaluations failed. A blocking violation was found in the rules that
	// were successfully evaluated. The message/attachment will be blocked,
	// the user will be notified, and the violation will be logged to BIP. A
	// blocking violation takes precedence over all other violation types.
	//   "SCAN_SUCCEEDED_WITH_FAILURES_WARN" - Rules were fetched but some
	// evaluations failed. A warn violation was found in the rules that were
	// successfully evaluated. The user will be warned, and the violation
	// will be logged to BIP.
	//   "SCAN_SUCCEEDED_WITH_FAILURES_AUDIT_ONLY" - Rules were fetched but
	// some evaluations failed. An audit-only violation was found in the
	// rules that were successfully evaluated. The violation will be logged
	// to BIP (no user-facing action performed).
	DlpScanOutcome string `json:"dlpScanOutcome,omitempty"`

	// DlpScanSummary: Data Loss Prevention scan information for this
	// message. Messages are evaluated in the backend on create
	// message/topic and edit message actions.
	DlpScanSummary *DlpScanSummary `json:"dlpScanSummary,omitempty"`

	// EditableBy: Indicates who can edit the message. This field is set on
	// the read path (e.g. ListTopics) but doesn’t have any effect on the
	// write path (e.g. CreateMessageRequest).
	//
	// Possible values:
	//   "PERMISSION_UNSPECIFIED" - Default case, should never be used. If
	// this data is encountered in the DB any request should throw an
	// exception.
	//   "PERMISSION_NO_ONE" - No one except for the message creator/origin
	// pair can mutate. This permission checks both gaia id and the request
	// origin. Request origin can be Chat API or Chat UI. Mutation is
	// allowed iff both attributes of the request match the original message
	// creation. Use case: this allows historical 1P apps lock down message
	// edit permission i.e. In Chat UI, humans cannot edit their messages
	// created via these 1P apps. Do not use this for additional use cases.
	//   "PERMISSION_CREATOR" - The message creator can mutate regardless of
	// request origin. Use case: for messages created by human via Chat UI
	// or Chat API. These messages can be mutated by the same human user via
	// Chat UI or via any app on Chat API.
	//   "PERMISSION_MEMBER" - Every human member of a space or the creator
	// can mutate the entity. This excludes app acting on behalf of human
	// via Chat API. Use case: This is to enable humans to delete messages
	// created by apps.
	EditableBy string `json:"editableBy,omitempty"`

	// FallbackText: A plain-text description of the attachment, used when
	// clients cannot display formatted attachment (e.g. mobile push
	// notifications).
	FallbackText string `json:"fallbackText,omitempty"`

	// Id: ID of the resource.
	Id *MessageId `json:"id,omitempty"`

	// IsContentPurged: Whether the message is content purged. Content
	// purged messages contain only data required for tombstone (see
	// go/chat-infinite-tombstone). This field is only used by Vault to
	// display tombstone and should only be set to true if the message is a
	// tombstone.
	IsContentPurged bool `json:"isContentPurged,omitempty"`

	// IsInlineReply: Output only. Indicates if the message is an inline
	// reply. Set to true only if the message's ParentPath is non-NULL.
	// Currently, only inline replies have non-NULL ParentPath. See
	// go/chat-be-inline-reply-indicator.
	IsInlineReply bool `json:"isInlineReply,omitempty"`

	// LastEditTime: If the message was edited by a user, timestamp of the
	// last edit, in microseconds.
	LastEditTime int64 `json:"lastEditTime,omitempty,string"`

	// LastUpdateTime: Time when the Message text was last updated in
	// microseconds.
	LastUpdateTime int64 `json:"lastUpdateTime,omitempty,string"`

	// LocalId: A unique id specified on the client side.
	LocalId string `json:"localId,omitempty"`

	// MessageIntegrationPayload: An optional payload (restricted to 1P
	// applications) that will be stored with this message. This can only be
	// set by the 1P API and should be used to deliver additional data such
	// a 1P sync version, 1P entity ID to the client for more advanced
	// functionality [Eg. inform Group Tasks tab of new version while
	// linking, fetch & render a live Task/Meet call tile].
	MessageIntegrationPayload *AppsDynamiteSharedMessageIntegrationPayload `json:"messageIntegrationPayload,omitempty"`

	// MessageOrigin: Where the message was posted from
	//
	// Possible values:
	//   "ORIGIN_NOT_SET"
	//   "ORIGIN_DYNAMITE"
	//   "ORIGIN_BABEL_INTEROP_LIVE" - The message is from Babel (Hangouts
	// Classic) interop.
	//   "ORIGIN_BABEL_INTEROP_RETRY" - The message is from Babel interop
	// retries from Manifold queue.
	//   "ORIGIN_BABEL" - The message came directly from Babel as
	// source-of-truth
	//   "ORIGIN_BABEL_DUAL_WRITE" - The message came directly from Babel
	// during dual-write
	//   "ORIGIN_BABEL_DUAL_WRITE_RETRY" - The message came directly from
	// Babel Manifold queue during dual write
	//   "ORIGIN_BACKFILL_FROM_PAPYRUS" - The message was backfilled by
	// go/dinnertrain as part of go/storage-consolidation. The backfill
	// origin corresponds to the BackfillState in which the message was
	// created.
	//   "ORIGIN_BACKFILL_FROM_GMAIL_ARCHIVE"
	MessageOrigin string `json:"messageOrigin,omitempty"`

	// MessageState: State of the message, indicating whether the message is
	// visible to all members in the group or is only visible to the sender
	// only, or the private_message_viewer if it is set.
	//
	// Possible values:
	//   "PUBLIC" - Default - visible to the room / DM.
	//   "PRIVATE" - Private state - only visible to the message creator,
	// and the private_message_viewer if set.
	MessageState string `json:"messageState,omitempty"`

	// OriginAppSuggestions: Indicates if this message contains any
	// suggestions that were provided by any Apps.
	OriginAppSuggestions []*AppsDynamiteSharedOriginAppSuggestion `json:"originAppSuggestions,omitempty"`

	// PersonalLabels: Personal labels associated with a message for the
	// viewing user. Order of entries is arbitrary and will not list
	// duplicates of the same label_id. See go/chat-labels-design for
	// details. NOTE: This will be unpopulated in the case of SpaceChangelog
	// events.
	PersonalLabels []*PersonalLabelTag `json:"personalLabels,omitempty"`

	// PrivateMessageInfos: A list of per-user private information. This is
	// deprecated, because we no longer plan to support partially private
	// messages or private messages for multiple users. The message_state
	// and private_message_viewer fields should be sufficient for this
	// infrastructure.
	PrivateMessageInfos []*PrivateMessageInfo `json:"privateMessageInfos,omitempty"`

	// PrivateMessageViewer: Should only be set if the Message State is
	// PRIVATE. If set, the message content is only visible to this user
	// (and any apps associated with the message), as well as the message
	// creator. If unset, a private message is visible to the message
	// creator only.
	PrivateMessageViewer *UserId `json:"privateMessageViewer,omitempty"`

	// Props: Contains additional (currently Hangouts Classic only)
	// properties applicable to this message.
	Props *MessageProps `json:"props,omitempty"`

	// QuotedByState: Output only. Whether this message has been quoted by
	// another message or not. Used by clients to handle message edit flows
	// for messages that have been quoted.
	//
	// Possible values:
	//   "QUOTED_BY_STATE_UNSPECIFIED" - Unspecified state for
	// QuotedByState.
	//   "QUOTED_BY_STATE_HAS_BEEN_QUOTED" - State to indicate that this
	// message is quoted by another message (excluding purged message).
	//   "QUOTED_BY_STATE_HAS_NOT_BEEN_QUOTED" - State to indicate that this
	// message are not quoted by another message.
	QuotedByState string `json:"quotedByState,omitempty"`

	// QuotedMessageMetadata: Output only. Metadata for a message that is
	// quoted by this message.
	QuotedMessageMetadata *QuotedMessageMetadata `json:"quotedMessageMetadata,omitempty"`

	// Reactions: A list of user reactions to this message. Ordered by the
	// timestamp of the first reaction, ascending (oldest to newest).
	Reactions []*AppsDynamiteSharedReaction `json:"reactions,omitempty"`

	// Reports: Output only. Details of content reports. Set only when the
	// request asks for it.
	Reports []*ContentReport `json:"reports,omitempty"`

	// RetentionSettings: The retention settings of the message.
	RetentionSettings *AppsDynamiteSharedRetentionSettings `json:"retentionSettings,omitempty"`

	// RichTextFormattingType: Used by clients to correctly log format type
	// for message creation due to complexity with client side optimistic
	// update (see go/content-metric-post-send-logging for details).
	// Currently, only set by server in the message or topic creation path.
	//
	// Possible values:
	//   "NONE"
	//   "MARKDOWN" - The formatting was specified as *markdown characters*
	// in message text.
	//   "FORMAT_ANNOTATIONS" - The formatting was specified as {@link
	// com.google.apps.dynamite.v1.shared.FormatMetadata} annotations.
	//   "FORMAT_ANNOTATIONS_IGNORED" - The client sent the format
	// annotations, but didn't set the accept_format_annotations field to
	// true. This shouldn't happen, but there might be some old clients that
	// end up here.
	//   "FORMAT_ANNOTATIONS_IGNORED_WITH_MARKDOWN" - A combination of
	// MARKDOWN and FORMAT_ANNOTATIONS_IGNORED.
	RichTextFormattingType string `json:"richTextFormattingType,omitempty"`

	// SecondaryMessageKey: A client-specified string that can be used to
	// uniquely identify a message in a space, in lieu of `id.message_id`.
	SecondaryMessageKey string `json:"secondaryMessageKey,omitempty"`

	// TextBody: Plaintext body of the Message.
	TextBody string `json:"textBody,omitempty"`

	// TombstoneMetadata: Information for the stoning of a Message.
	TombstoneMetadata *TombstoneMetadata `json:"tombstoneMetadata,omitempty"`

	// UpdaterId: ID of the User who last updated (created/edited/deleted)
	// the Message. This includes information to identify if this was
	// updated by an App on behalf of a user.
	UpdaterId *UserId `json:"updaterId,omitempty"`

	// UploadMetadata: UploadMetadata b/36864213 is an ongoing effort to
	// move UploadMetadata out of annotations field and save it to
	// upload_metadata field only. After the migration, UploadMetadata will
	// only be saved in this field.
	UploadMetadata []*UploadMetadata `json:"uploadMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Annotations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Message) MarshalJSON() ([]byte, error) {
	type NoMethod Message
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MessageAdded: A message was added. Specifying id and initial labels.
type MessageAdded struct {
	AttributeIds []string `json:"attributeIds,omitempty"`

	LabelIds []string `json:"labelIds,omitempty"`

	MessageKey *MultiKey `json:"messageKey,omitempty"`

	// SyncIds: Note that there can be fewer sync ids than label ids.
	SyncIds []int64 `json:"syncIds,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AttributeIds") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttributeIds") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MessageAdded) MarshalJSON() ([]byte, error) {
	type NoMethod MessageAdded
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MessageAttributes: Stores tombstone message attributes:
// go/tombstone-message-attributes-overview
type MessageAttributes struct {
	// IsTombstone: If true: message is a tombstone in the client. Default
	// false.
	IsTombstone bool `json:"isTombstone,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IsTombstone") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IsTombstone") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MessageAttributes) MarshalJSON() ([]byte, error) {
	type NoMethod MessageAttributes
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MessageDeleted: Some (subset of the) messages in this thread were
// deleted.
type MessageDeleted struct {
	// ImapSyncMappings: Value of coproc's message delete history record
	// extension that exports /imapsync/folder attribute of deleted messages
	// which have ^is label.
	ImapSyncMappings []*ImapSyncDelete `json:"imapSyncMappings,omitempty"`

	MessageKeys []*MultiKey `json:"messageKeys,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ImapSyncMappings") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ImapSyncMappings") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *MessageDeleted) MarshalJSON() ([]byte, error) {
	type NoMethod MessageDeleted
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MessageId: Primary key for Message resource.
type MessageId struct {
	// MessageId: Opaque, server-assigned ID of the Message. While this ID
	// is guaranteed to be unique within the Space, it's not guaranteed to
	// be globally unique.
	MessageId string `json:"messageId,omitempty"`

	// ParentId: ID of the Message's immediate parent.
	ParentId *MessageParentId `json:"parentId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MessageId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MessageId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MessageId) MarshalJSON() ([]byte, error) {
	type NoMethod MessageId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type MessageInfo struct {
	// Message: The content of a matching message.
	Message *Message `json:"message,omitempty"`

	// SearcherMembershipState: Searcher's membership state in the space
	// where the message is posted.
	//
	// Possible values:
	//   "MEMBER_UNKNOWN" - Default state, do not use
	//   "MEMBER_INVITED" - An invitation to the space has been sent
	//   "MEMBER_JOINED" - User has joined the space
	//   "MEMBER_NOT_A_MEMBER" - User is not a member
	//   "MEMBER_FAILED" - This state should never be stored in Spanner. It
	// is a state for responses to the clients to indicate that membership
	// mutations have failed and the member is in its previous state.
	SearcherMembershipState string `json:"searcherMembershipState,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Message") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Message") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MessageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod MessageInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MessageParentId: Primary key identifying Message resource's immediate
// parent. For top-level Messages, either topic_id or chat_id is
// populated. For replies, message_id is populated with the topic
// Message's ID.
type MessageParentId struct {
	// TopicId: ID of the Topic this Message is posted to. NEXT TAG : 5
	TopicId *TopicId `json:"topicId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TopicId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TopicId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MessageParentId) MarshalJSON() ([]byte, error) {
	type NoMethod MessageParentId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MessageProps: Container for storing properties applicable to
// messages. For now (until storage consolidation is complete), it will
// only be used for babel props. In the future it could be used to house
// Dynamite properties for experimenting/rapid prototyping.
type MessageProps struct {
	BabelProps *BabelMessageProps `json:"babelProps,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BabelProps") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BabelProps") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MessageProps) MarshalJSON() ([]byte, error) {
	type NoMethod MessageProps
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MessageSet: This is proto2's version of MessageSet.
type MessageSet struct {
}

// Metadata: Metadata of a matched search result.
type Metadata struct {
	// CreateTime: The creation time for this document or object in the
	// search result.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayOptions: Options that specify how to display a structured data
	// search result.
	DisplayOptions *ResultDisplayMetadata `json:"displayOptions,omitempty"`

	// Fields: Indexed fields in structured data, returned as a generic
	// named property.
	Fields []*NamedProperty `json:"fields,omitempty"`

	// MimeType: Mime type of the search result.
	MimeType string `json:"mimeType,omitempty"`

	// ObjectType: Object type of the search result.
	ObjectType string `json:"objectType,omitempty"`

	// Owner: Owner (usually creator) of the document or object of the
	// search result.
	Owner *Person `json:"owner,omitempty"`

	// Source: The named source for the result, such as Gmail.
	Source *Source `json:"source,omitempty"`

	// ThumbnailUrl: The thumbnail URL of the result.
	ThumbnailUrl string `json:"thumbnailUrl,omitempty"`

	// UpdateTime: The last modified date for the object in the search
	// result. If not set in the item, the value returned here is empty.
	// When `updateTime` is used for calculating freshness and is not set,
	// this value defaults to 2 years from the current time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Metadata) MarshalJSON() ([]byte, error) {
	type NoMethod Metadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Metaline: A metaline is a list of properties that are displayed along
// with the search result to provide context.
type Metaline struct {
	// Properties: The list of displayed properties for the metaline. The
	// maximum number of properties is 5.
	Properties []*DisplayedProperty `json:"properties,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Properties") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Properties") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Metaline) MarshalJSON() ([]byte, error) {
	type NoMethod Metaline
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MultiKey: A union-like type for identifiying an object in storage.
// MultiKeys contain multiple key fields, each in a separate key space.
// At least one key field must be set. More than one key field may be
// set as long as all key values refer to the same object. All objects
// in storage have unique server_id keys. All MultiKeys returned from
// storage to storage clients will always have the server_id field set.
// When creating an object, if a MultiKey without a server_id is
// supplied to storage, the storage system will auto-assign a server ID
// to the new object. For all other storage requests (i.e. those not
// creating new objects), clients may omit server_id (as long as they
// supply another key). Instead of server ids, clients can specify
// string based client_assigned_perm_id keys. Mail message drafts are a
// prime example of these kinds of objects. Each time a user saves a new
// version of a draft, the storage system needs to create a new object
// with the updated draft content and needs to delete the object
// containing the old content. The new object gets a new SERVER_ID but
// should get the same CLIENT_ASSIGNED_PERM_ID as the now-deleted object
// containing the old content. Carrying forward the perm ID allows it to
// be used to consistently refer to the same logical object across
// revisions. These perm IDs save sync clients from having to deal with
// changing object IDs. For example, assume there's a mail message in
// storage with SERVER_ID = 123 and CLIENT_ASSIGNED_PERM_ID = "foo". The
// following are all valid ways of addressing the object using
// MultiKeys: 1) MultiKey { server_id = 123 } 2) MultiKey { server_id =
// 123, client_assigned_perm_id = "foo" } 3) MultiKey {
// client_assigned_perm_id = "foo" } Multikeys are never serialized in
// the storage. The individual keys are extracted and processed
// separately. Both the integer ids as well as string ids are indexed
// for efficient retrieval using the same fields in the backend. See
// go/tingle-multikeys for more information on background and
// motivation.
type MultiKey struct {
	// ClientAssignedPermId: A client-assigned string based key.
	ClientAssignedPermId string `json:"clientAssignedPermId,omitempty"`

	// ServerId: A server-assigned ID. This ID must be used only by Gmail
	// and is constructed using millesecond ts << 20 + randomness. The ID
	// affects the sort order of the index.
	ServerId uint64 `json:"serverId,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "ClientAssignedPermId") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClientAssignedPermId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *MultiKey) MarshalJSON() ([]byte, error) {
	type NoMethod MultiKey
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Name: A person's name.
type Name struct {
	// DisplayName: The read-only display name formatted according to the
	// locale specified by the viewer's account or the `Accept-Language`
	// HTTP header.
	DisplayName string `json:"displayName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Name) MarshalJSON() ([]byte, error) {
	type NoMethod Name
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// NamedProperty: A typed name-value pair for structured data. The type
// of the value should be the same as the registered type for the `name`
// property in the object definition of `objectType`.
type NamedProperty struct {
	BooleanValue bool `json:"booleanValue,omitempty"`

	DateValues *DateValues `json:"dateValues,omitempty"`

	DoubleValues *DoubleValues `json:"doubleValues,omitempty"`

	EnumValues *EnumValues `json:"enumValues,omitempty"`

	HtmlValues *HtmlValues `json:"htmlValues,omitempty"`

	IntegerValues *IntegerValues `json:"integerValues,omitempty"`

	// Name: The name of the property. This name should correspond to the
	// name of the property that was registered for object definition in the
	// schema. The maximum allowable length for this property is 256
	// characters.
	Name string `json:"name,omitempty"`

	ObjectValues *ObjectValues `json:"objectValues,omitempty"`

	TextValues *TextValues `json:"textValues,omitempty"`

	TimestampValues *TimestampValues `json:"timestampValues,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BooleanValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BooleanValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *NamedProperty) MarshalJSON() ([]byte, error) {
	type NoMethod NamedProperty
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OAuthConsumerProto: Represents an OAuth consumer, a/k/a AuthSub
// target. These principals are identified by domain name (e.g.,
// example.com). Historically, Dasher domain GAIA group IDs have been
// used instead, but that doesn't work: http://go/tricky-gaia-ids
type OAuthConsumerProto struct {
	Domain string `json:"domain,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Domain") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Domain") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OAuthConsumerProto) MarshalJSON() ([]byte, error) {
	type NoMethod OAuthConsumerProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ObjectDefinition: The definition for an object within a data source.
type ObjectDefinition struct {
	// Name: The name for the object, which then defines its type. Item
	// indexing requests should set the objectType field equal to this
	// value. For example, if *name* is *Document*, then indexing requests
	// for items of type Document should set objectType equal to *Document*.
	// Each object definition must be uniquely named within a schema. The
	// name must start with a letter and can only contain letters (A-Z, a-z)
	// or numbers (0-9). The maximum length is 256 characters.
	Name string `json:"name,omitempty"`

	// Options: The optional object-specific options.
	Options *ObjectOptions `json:"options,omitempty"`

	// PropertyDefinitions: The property definitions for the object. The
	// maximum number of elements is 1000.
	PropertyDefinitions []*PropertyDefinition `json:"propertyDefinitions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ObjectDefinition) MarshalJSON() ([]byte, error) {
	type NoMethod ObjectDefinition
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ObjectDisplayOptions: The display options for an object.
type ObjectDisplayOptions struct {
	// Metalines: Defines the properties that are displayed in the metalines
	// of the search results. The property values are displayed in the order
	// given here. If a property holds multiple values, all of the values
	// are displayed before the next properties. For this reason, it is a
	// good practice to specify singular properties before repeated
	// properties in this list. All of the properties must set is_returnable
	// to true. The maximum number of metalines is 3.
	Metalines []*Metaline `json:"metalines,omitempty"`

	// ObjectDisplayLabel: The user friendly label to display in the search
	// result to indicate the type of the item. This is OPTIONAL; if not
	// provided, an object label isn't displayed on the context line of the
	// search results. The maximum length is 64 characters.
	ObjectDisplayLabel string `json:"objectDisplayLabel,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metalines") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metalines") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ObjectDisplayOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ObjectDisplayOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ObjectOptions: The options for an object.
type ObjectOptions struct {
	// DisplayOptions: The options that determine how the object is
	// displayed in the Cloud Search results page.
	DisplayOptions *ObjectDisplayOptions `json:"displayOptions,omitempty"`

	// FreshnessOptions: The freshness options for an object.
	FreshnessOptions *FreshnessOptions `json:"freshnessOptions,omitempty"`

	// SuggestionFilteringOperators: Operators that can be used to filter
	// suggestions. For Suggest API, only operators mentioned here will be
	// honored in the FilterOptions. Only TEXT and ENUM operators are
	// supported. NOTE: "objecttype", "type" and "mimetype" are already
	// supported. This property is to configure schema specific operators.
	// Even though this is an array, only one operator can be specified.
	// This is an array for future extensibility. Operators mapping to
	// multiple properties within the same object are not supported. If the
	// operator spans across different object types, this option has to be
	// set once for each object definition.
	SuggestionFilteringOperators []string `json:"suggestionFilteringOperators,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayOptions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayOptions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ObjectOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ObjectOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ObjectPropertyOptions: The options for object properties.
type ObjectPropertyOptions struct {
	// SubobjectProperties: The properties of the sub-object. These
	// properties represent a nested object. For example, if this property
	// represents a postal address, the subobjectProperties might be named
	// *street*, *city*, and *state*. The maximum number of elements is
	// 1000.
	SubobjectProperties []*PropertyDefinition `json:"subobjectProperties,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SubobjectProperties")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SubobjectProperties") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ObjectPropertyOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ObjectPropertyOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ObjectValues: List of object values.
type ObjectValues struct {
	Values []*StructuredDataObject `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Values") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ObjectValues) MarshalJSON() ([]byte, error) {
	type NoMethod ObjectValues
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OnClick struct {
	Action *FormAction `json:"action,omitempty"`

	// Link: This can be used as a short form for OpenLink with the default
	// OpenAs and OnClose. It may be undeprecated if this proves to be handy
	// for developers.
	Link string `json:"link,omitempty"`

	OpenLink *OpenLink `json:"openLink,omitempty"`

	// OpenLinkAction: An add-on triggers this action when the form action
	// needs to open a link. This differs from the open_link above in that
	// this needs to talk to server to get the link. Thus some preparation
	// work is required for web client to do before the open link action
	// response comes back.
	OpenLinkAction *FormAction `json:"openLinkAction,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OnClick) MarshalJSON() ([]byte, error) {
	type NoMethod OnClick
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OpenCreatedDraftActionMarkup struct {
	// DraftId: The ID of the newly created draft in the form "r123".
	DraftId string `json:"draftId,omitempty"`

	// DraftStorageId: The server storage ID in hex format, for
	// example,"15e9fa622ce1029d".
	DraftStorageId string `json:"draftStorageId,omitempty"`

	// DraftThreadId: The ID of the thread containing the newly created
	// draft, for example, "15e9fa622ce1029d".
	DraftThreadId string `json:"draftThreadId,omitempty"`

	// DraftThreadServerPermId: The server permanent ID for the draft's
	// thread. This field isn't set anywhere, and it's ignored when
	// processing OpenCreatedDraftActionMarkup. Supply and use
	// draftThreadStorageId instead.
	DraftThreadServerPermId string `json:"draftThreadServerPermId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DraftId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DraftId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OpenCreatedDraftActionMarkup) MarshalJSON() ([]byte, error) {
	type NoMethod OpenCreatedDraftActionMarkup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OpenLink struct {
	// LoadIndicator: Next available ID: 5
	//
	// Possible values:
	//   "NONE"
	//   "SPINNER"
	LoadIndicator string `json:"loadIndicator,omitempty"`

	// Possible values:
	//   "NOTHING"
	//   "RELOAD_ADD_ON"
	OnClose string `json:"onClose,omitempty"`

	// Possible values:
	//   "FULL_SIZE"
	//   "OVERLAY"
	OpenAs string `json:"openAs,omitempty"`

	Url string `json:"url,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LoadIndicator") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LoadIndicator") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OpenLink) MarshalJSON() ([]byte, error) {
	type NoMethod OpenLink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is
// the result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in
	// progress. If `true`, the operation is completed, and either `error`
	// or `response` is available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *Status `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as
	// create time. Some services might not provide such metadata. Any
	// method that returns a long-running operation should document the
	// metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that originally returns it. If you use the default HTTP
	// mapping, the `name` should be a resource name ending with
	// `operations/{unique_id}`.
	Name string `json:"name,omitempty"`

	// Response: The normal response of the operation in case of success. If
	// the original method returns no data on success, such as `Delete`, the
	// response is `google.protobuf.Empty`. If the original method is
	// standard `Get`/`Create`/`Update`, the response should be the
	// resource. For other methods, the response should have the type
	// `XxxResponse`, where `Xxx` is the original method name. For example,
	// if the original method name is `TakeSnapshot()`, the inferred
	// response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OsVersion struct {
	MajorVersion int64 `json:"majorVersion,omitempty"`

	MinorVersion int64 `json:"minorVersion,omitempty"`

	TertiaryVersion int64 `json:"tertiaryVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MajorVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MajorVersion") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OsVersion) MarshalJSON() ([]byte, error) {
	type NoMethod OsVersion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OtrChatMessageEvent struct {
	ExpirationTimestampUsec int64 `json:"expirationTimestampUsec,omitempty,string"`

	KansasRowId string `json:"kansasRowId,omitempty"`

	KansasVersionInfo string `json:"kansasVersionInfo,omitempty"`

	// Possible values:
	//   "OFF_THE_RECORD" - The conversation is completely off the record.
	//   "ON_THE_RECORD" - The conversation is completely on the record.
	MessageOtrStatus string `json:"messageOtrStatus,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ExpirationTimestampUsec") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExpirationTimestampUsec")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OtrChatMessageEvent) MarshalJSON() ([]byte, error) {
	type NoMethod OtrChatMessageEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type OtrModificationEvent struct {
	// Possible values:
	//   "OFF_THE_RECORD" - The conversation is completely off the record.
	//   "ON_THE_RECORD" - The conversation is completely on the record.
	NewOtrStatus string `json:"newOtrStatus,omitempty"`

	// Possible values:
	//   "ENABLED" - The conversation can be toggled
	//   "DISABLED" - The conversation cannot be toggled
	NewOtrToggle string `json:"newOtrToggle,omitempty"`

	// Possible values:
	//   "OFF_THE_RECORD" - The conversation is completely off the record.
	//   "ON_THE_RECORD" - The conversation is completely on the record.
	OldOtrStatus string `json:"oldOtrStatus,omitempty"`

	// Possible values:
	//   "ENABLED" - The conversation can be toggled
	//   "DISABLED" - The conversation cannot be toggled
	OldOtrToggle string `json:"oldOtrToggle,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NewOtrStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NewOtrStatus") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OtrModificationEvent) MarshalJSON() ([]byte, error) {
	type NoMethod OtrModificationEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PackagingServiceClient: Developers register a client in Google API
// Console to get the deep-linking feature on Google+ posts or frames
// about their apps. The client data is stored in this proto.
type PackagingServiceClient struct {
	// AndroidPackageName: Android app's package name to generate the
	// deep-link URI.
	AndroidPackageName string `json:"androidPackageName,omitempty"`

	// IosAppStoreId: iOS app's App Store ID to generate the App Store URL
	// when app is not installed on device.
	IosAppStoreId string `json:"iosAppStoreId,omitempty"`

	// IosBundleId: iOS app's bundle ID to generate the deep-link URI.
	IosBundleId string `json:"iosBundleId,omitempty"`

	// Type: Type of Google API Console client.
	//
	// Possible values:
	//   "ANDROID" - Client for Android app.
	//   "IOS" - Client for iOS app.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AndroidPackageName")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AndroidPackageName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *PackagingServiceClient) MarshalJSON() ([]byte, error) {
	type NoMethod PackagingServiceClient
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PaygateInfo: Information provided to clients so that they can show
// upgrade promos and warnings on call ending early (for non-paying
// users).
type PaygateInfo struct {
	// CallEndingSoonWarningTime: Time when client should show message that
	// the call is ending soon.
	CallEndingSoonWarningTime string `json:"callEndingSoonWarningTime,omitempty"`

	// CallEndingTime: Time when the call will end if the user does not
	// upgrade (after in-call upgrade support check has been implemented).
	CallEndingTime string `json:"callEndingTime,omitempty"`

	// ShowUpgradePromos: This boolean is used by clients to decide whether
	// the user should be shown promos to upgrade.
	ShowUpgradePromos bool `json:"showUpgradePromos,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CallEndingSoonWarningTime") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "CallEndingSoonWarningTime") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PaygateInfo) MarshalJSON() ([]byte, error) {
	type NoMethod PaygateInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PeopleSuggestion: This field contains information about the person
// being suggested.
type PeopleSuggestion struct {
	// Person: Suggested person. All fields of the person object might not
	// be populated.
	Person *Person `json:"person,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Person") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Person") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PeopleSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod PeopleSuggestion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Person: Object to represent a person.
type Person struct {
	// EmailAddresses: The person's email addresses
	EmailAddresses []*EmailAddress `json:"emailAddresses,omitempty"`

	// Name: The resource name of the person to provide information about.
	// See `People.get`
	// (https://developers.google.com/people/api/rest/v1/people/get) from
	// the Google People API.
	Name string `json:"name,omitempty"`

	// ObfuscatedId: Obfuscated ID of a person.
	ObfuscatedId string `json:"obfuscatedId,omitempty"`

	// PersonNames: The person's name
	PersonNames []*Name `json:"personNames,omitempty"`

	// PhoneNumbers: The person's phone numbers
	PhoneNumbers []*PhoneNumber `json:"phoneNumbers,omitempty"`

	// Photos: A person's read-only photo. A picture shown next to the
	// person's name to help others recognize the person in search results.
	Photos []*Photo `json:"photos,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EmailAddresses") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EmailAddresses") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Person) MarshalJSON() ([]byte, error) {
	type NoMethod Person
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PersonalLabelTag: An individual instance (or "tag") of a label
// configured as a personal type that's associated with a message.
type PersonalLabelTag struct {
	// LabelId: A string ID representing the label. Possible ID values are
	// documented at go/chat-labels-howto:ids. Examples: "^t" for "Starred",
	// "^nu" for "Nudged".
	LabelId string `json:"labelId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LabelId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LabelId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PersonalLabelTag) MarshalJSON() ([]byte, error) {
	type NoMethod PersonalLabelTag
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PhoneAccess: Phone access contains information required to dial into
// a conference using a regional phone number and a PIN that is specific
// to that phone number.
type PhoneAccess struct {
	// FormattedPhoneNumber: The phone number to dial for this meeting space
	// in INTERNATIONAL format. Full phone number with a leading '+'
	// character and whitespace separations.
	FormattedPhoneNumber string `json:"formattedPhoneNumber,omitempty"`

	// LanguageCode: The BCP 47/LDML language code for the language
	// associated with this phone access. To be parsed by the i18n
	// LanguageCode utility. Examples: "es-419" for Latin American Spanish,
	// "fr-CA" for Canadian French.
	LanguageCode string `json:"languageCode,omitempty"`

	// PhoneNumber: The phone number to dial for this meeting space in E.164
	// format. Full phone number with a leading '+' character.
	PhoneNumber string `json:"phoneNumber,omitempty"`

	// Pin: The PIN that users must enter after dialing the given number.
	// The PIN consists of only decimal digits and the length may vary.
	Pin string `json:"pin,omitempty"`

	// RegionCode: The CLDR/ISO 3166 region code for the country associated
	// with this phone access. To be parsed by the i18n RegionCode utility.
	// Example: "SE" for Sweden.
	RegionCode string `json:"regionCode,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "FormattedPhoneNumber") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FormattedPhoneNumber") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *PhoneAccess) MarshalJSON() ([]byte, error) {
	type NoMethod PhoneAccess
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PhoneNumber: A person's Phone Number
type PhoneNumber struct {
	// PhoneNumber: The phone number of the person.
	PhoneNumber string `json:"phoneNumber,omitempty"`

	// Possible values:
	//   "OTHER"
	//   "MOBILE"
	//   "OFFICE"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PhoneNumber") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PhoneNumber) MarshalJSON() ([]byte, error) {
	type NoMethod PhoneNumber
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Photo: A person's photo.
type Photo struct {
	// Url: The URL of the photo.
	Url string `json:"url,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Url") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Url") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Photo) MarshalJSON() ([]byte, error) {
	type NoMethod Photo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type PinnedItemId struct {
	// DriveId: Identifier for a Drive file (e.g. Docs, Sheets, Slides).
	DriveId string `json:"driveId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DriveId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DriveId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PinnedItemId) MarshalJSON() ([]byte, error) {
	type NoMethod PinnedItemId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type PollItemsRequest struct {
	// ConnectorName: The name of connector making this call. Format:
	// datasources/{source_id}/connectors/{ID}
	ConnectorName string `json:"connectorName,omitempty"`

	// DebugOptions: Common debug options.
	DebugOptions *DebugOptions `json:"debugOptions,omitempty"`

	// Limit: Maximum number of items to return. The maximum value is 100
	// and the default value is 20.
	Limit int64 `json:"limit,omitempty"`

	// Queue: Queue name to fetch items from. If unspecified, PollItems will
	// fetch from 'default' queue. The maximum length is 100 characters.
	Queue string `json:"queue,omitempty"`

	// StatusCodes: Limit the items polled to the ones with these statuses.
	//
	// Possible values:
	//   "CODE_UNSPECIFIED" - Input-only value. Used with Items.list to list
	// all items in the queue, regardless of status.
	//   "ERROR" - Error encountered by Cloud Search while processing this
	// item. Details of the error are in repositoryError.
	//   "MODIFIED" - Item has been modified in the repository, and is out
	// of date with the version previously accepted into Cloud Search.
	//   "NEW_ITEM" - Item is known to exist in the repository, but is not
	// yet accepted by Cloud Search. An item can be in this state when
	// Items.push has been called for an item of this name that did not
	// exist previously.
	//   "ACCEPTED" - API has accepted the up-to-date data of this item.
	StatusCodes []string `json:"statusCodes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConnectorName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConnectorName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PollItemsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod PollItemsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type PollItemsResponse struct {
	// Items: Set of items from the queue available for connector to
	// process. These items have the following subset of fields populated:
	// version metadata.hash structured_data.hash content.hash payload
	// status queue
	Items []*Item `json:"items,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Items") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PollItemsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod PollItemsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PossiblyTrimmedModel: This message contains either the device model,
// or a prefix of the device model (AKA a trimmed device model). The
// "is_trimmed" field indicates which one it is.
type PossiblyTrimmedModel struct {
	IsTrimmed bool `json:"isTrimmed,omitempty"`

	Model string `json:"model,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IsTrimmed") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IsTrimmed") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PossiblyTrimmedModel) MarshalJSON() ([]byte, error) {
	type NoMethod PossiblyTrimmedModel
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PostiniUserProto: See
// http://s/?fileprint=//depot/google3/security/authentication/postini/auth_token.proto
type PostiniUserProto struct {
	PostiniUserId int64 `json:"postiniUserId,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "PostiniUserId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PostiniUserId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PostiniUserProto) MarshalJSON() ([]byte, error) {
	type NoMethod PostiniUserProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PreState: State of the thread previous to the update. This really
// just describes the label state of all messages before the update.
type PreState struct {
	LabelIds []string `json:"labelIds,omitempty"`

	MessageKey *MultiKey `json:"messageKey,omitempty"`

	// SyncIds: Note that there can be fewer sync ids than label ids.
	SyncIds []int64 `json:"syncIds,omitempty"`

	ThreadKey *MultiKey `json:"threadKey,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LabelIds") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LabelIds") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PreState) MarshalJSON() ([]byte, error) {
	type NoMethod PreState
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PrefDeleted: PREF_DELETED
type PrefDeleted struct {
}

// PrefUpdate: HistoryRecord for changes associated with prefs, namely:
// PREF_WRITTEN PREF_DELETED
type PrefUpdate struct {
	// Name: Name of the affected preference.
	Name string `json:"name,omitempty"`

	PreState *FuseboxPrefUpdatePreState `json:"preState,omitempty"`

	PrefDeleted *PrefDeleted `json:"prefDeleted,omitempty"`

	PrefWritten *PrefWritten `json:"prefWritten,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PrefUpdate) MarshalJSON() ([]byte, error) {
	type NoMethod PrefUpdate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PrefWritten: PREF_WRITTEN
type PrefWritten struct {
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Value") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PrefWritten) MarshalJSON() ([]byte, error) {
	type NoMethod PrefWritten
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Presenter: Presenter contains information about which device is
// currently presenting as well as which device requested the presenter
// to be set.
type Presenter struct {
	// ByDeviceId: The device resource name of the device which requested
	// the current presenter to be set. This field can not be modified by
	// clients.
	ByDeviceId string `json:"byDeviceId,omitempty"`

	// CopresenterDeviceIds: The device resource names of other devices
	// which can control the current presentation.
	CopresenterDeviceIds []string `json:"copresenterDeviceIds,omitempty"`

	// PresenterDeviceId: The device resource name of the currently
	// presenting device.
	PresenterDeviceId string `json:"presenterDeviceId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ByDeviceId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ByDeviceId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Presenter) MarshalJSON() ([]byte, error) {
	type NoMethod Presenter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Principal: Reference to a user, group, or domain.
type Principal struct {
	// GroupResourceName: This principal is a group identified using an
	// external identity. The name field must specify the group resource
	// name with this format: identitysources/{source_id}/groups/{ID}
	GroupResourceName string `json:"groupResourceName,omitempty"`

	// GsuitePrincipal: This principal is a Google Workspace user, group or
	// domain.
	GsuitePrincipal *GSuitePrincipal `json:"gsuitePrincipal,omitempty"`

	// UserResourceName: This principal is a user identified using an
	// external identity. The name field must specify the user resource name
	// with this format: identitysources/{source_id}/users/{ID}
	UserResourceName string `json:"userResourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GroupResourceName")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GroupResourceName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Principal) MarshalJSON() ([]byte, error) {
	type NoMethod Principal
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PrincipalProto: A Principal represents something to which permissions
// are assigned, often but not always a user or group of some kind. It
// is most appropriate for use in ACLs and authorization checks. Callers
// should prefer to use the wrapper classes in
// google3/security/credentials/public/principal.h
// google3/java/com/google/security/credentials/Principal.java
// google3/security/credentials/go/principal.go unless direct proto
// access is essential. If you update this protocol buffer, please
// update the wrapper classes as well. LINT.IfChange
type PrincipalProto struct {
	// AllAuthenticatedUsers: scope = ALL_AUTHENTICATED_USERS
	AllAuthenticatedUsers *AllAuthenticatedUsersProto `json:"allAuthenticatedUsers,omitempty"`

	// CapTokenHolder: scope = CAP_TOKEN_HOLDER
	CapTokenHolder *CapTokenHolderProto `json:"capTokenHolder,omitempty"`

	// Chat: scope = CHAT
	Chat *ChatProto `json:"chat,omitempty"`

	// Circle: scope = CIRCLE
	Circle *CircleProto `json:"circle,omitempty"`

	// CloudPrincipal: scope = CLOUD_PRINCIPAL
	CloudPrincipal *CloudPrincipalProto `json:"cloudPrincipal,omitempty"`

	// ContactGroup: scope = CONTACT_GROUP
	ContactGroup *ContactGroupProto `json:"contactGroup,omitempty"`

	// EmailOwner: scope = EMAIL_OWNER
	EmailOwner *EmailOwnerProto `json:"emailOwner,omitempty"`

	// Event: scope = EVENT
	Event *EventProto `json:"event,omitempty"`

	// GaiaGroup: scope = GAIA_GROUP
	GaiaGroup *GaiaGroupProto `json:"gaiaGroup,omitempty"`

	// GaiaUser: scope = GAIA_USER
	GaiaUser *GaiaUserProto `json:"gaiaUser,omitempty"`

	// Host: scope = HOST
	Host *HostProto `json:"host,omitempty"`

	// LdapGroup: scope = LDAP_GROUP
	LdapGroup *LdapGroupProto `json:"ldapGroup,omitempty"`

	// LdapUser: scope = LDAP_USER
	LdapUser *LdapUserProto `json:"ldapUser,omitempty"`

	// MdbGroup: scope = MDB_GROUP
	MdbGroup *MdbGroupProto `json:"mdbGroup,omitempty"`

	// MdbUser: scope = MDB_USER
	MdbUser *MdbUserProto `json:"mdbUser,omitempty"`

	// OauthConsumer: scope = OAUTH_CONSUMER;
	OauthConsumer *OAuthConsumerProto `json:"oauthConsumer,omitempty"`

	// PostiniUser: scope = POSTINI_USER
	PostiniUser *PostiniUserProto `json:"postiniUser,omitempty"`

	// RbacRole: scope = RBAC_ROLE
	RbacRole *RbacRoleProto `json:"rbacRole,omitempty"`

	// RbacSubject: scope = RBAC_SUBJECT
	RbacSubject *RbacSubjectProto `json:"rbacSubject,omitempty"`

	// ResourceRole: scope = RESOURCE_ROLE
	ResourceRole *ResourceRoleProto `json:"resourceRole,omitempty"`

	// Scope: This is only optional because required enums cannot be
	// extended. Currently required.
	//
	// Possible values:
	//   "INVALID"
	//   "GAIA_USER"
	//   "GAIA_GROUP"
	//   "LDAP_USER"
	//   "LDAP_GROUP"
	//   "MDB_USER"
	//   "MDB_GROUP"
	//   "POSTINI_USER"
	//   "CONTACT_GROUP"
	//   "SIMPLE_SECRET_HOLDER"
	//   "SIGNING_KEY_POSSESSOR"
	//   "ALL_AUTHENTICATED_USERS"
	//   "OAUTH_CONSUMER"
	//   "HOST"
	//   "SOCIAL_GRAPH_NODE"
	//   "EMAIL_OWNER"
	//   "CAP_TOKEN_HOLDER"
	//   "CIRCLE"
	//   "SQUARE"
	//   "EVENT"
	//   "RESOURCE_ROLE"
	//   "CHAT"
	//   "YOUTUBE_USER"
	//   "UNUSED_ZWIEBACK_SESSION"
	//   "ZWIEBACK_SESSION"
	//   "RBAC_ROLE"
	//   "RBAC_SUBJECT"
	//   "CLOUD_PRINCIPAL" - next tag: 29
	Scope string `json:"scope,omitempty"`

	// SigningKeyPossessor: scope = SIGNING_KEY_POSSESSOR
	SigningKeyPossessor *SigningKeyPossessorProto `json:"signingKeyPossessor,omitempty"`

	// SimpleSecretHolder: scope = SIMPLE_SECRET_HOLDER
	SimpleSecretHolder *SimpleSecretHolderProto `json:"simpleSecretHolder,omitempty"`

	// SocialGraphNode: scope = SOCIAL_GRAPH_NODE
	SocialGraphNode *SocialGraphNodeProto `json:"socialGraphNode,omitempty"`

	// Square: scope = SQUARE
	Square *SquareProto `json:"square,omitempty"`

	// YoutubeUser: scope = YOUTUBE_USER
	YoutubeUser *YoutubeUserProto `json:"youtubeUser,omitempty"`

	// ZwiebackSession: scope = ZWIEBACK_SESSION
	ZwiebackSession *ZwiebackSessionProto `json:"zwiebackSession,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllAuthenticatedUsers") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllAuthenticatedUsers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *PrincipalProto) MarshalJSON() ([]byte, error) {
	type NoMethod PrincipalProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PrivateMessageInfo: Private message information specific to a given
// user. DEPRECATED: Use the privateMessageViewer field in
// CreateMessageInfo instead.
type PrivateMessageInfo struct {
	// Annotations: Annotations private to {@code userId}.
	Annotations []*Annotation `json:"annotations,omitempty"`

	// Attachments: Attachments private to {@code userId}.
	Attachments []*Attachment `json:"attachments,omitempty"`

	ContextualAddOnMarkup []*GoogleChatV1ContextualAddOnMarkup `json:"contextualAddOnMarkup,omitempty"`

	GsuiteIntegrationMetadata []*GsuiteIntegrationMetadata `json:"gsuiteIntegrationMetadata,omitempty"`

	// Text: Text private to {@code user_id}. Initial restriction: Only one
	// of public text or private text is rendered on the client. So if
	// public text is set, private text is ignored.
	Text string `json:"text,omitempty"`

	// UserId: Required. The elements in this struct are visible to this
	// user.
	UserId *UserId `json:"userId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Annotations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PrivateMessageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod PrivateMessageInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ProcessingError struct {
	// Code: Error code indicating the nature of the error.
	//
	// Possible values:
	//   "PROCESSING_ERROR_CODE_UNSPECIFIED" - Input only value. Use this
	// value in Items.
	//   "MALFORMED_REQUEST" - Item's ACL, metadata, or content is malformed
	// or in invalid state. FieldViolations contains more details on where
	// the problem is.
	//   "UNSUPPORTED_CONTENT_FORMAT" - Countent format is unsupported.
	//   "INDIRECT_BROKEN_ACL" - Items with incomplete ACL information due
	// to inheriting other items with broken ACL or having groups with
	// unmapped descendants.
	//   "ACL_CYCLE" - ACL inheritance graph formed a cycle.
	Code string `json:"code,omitempty"`

	// ErrorMessage: The description of the error.
	ErrorMessage string `json:"errorMessage,omitempty"`

	// FieldViolations: In case the item fields are invalid, this field
	// contains the details about the validation errors.
	FieldViolations []*FieldViolation `json:"fieldViolations,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProcessingError) MarshalJSON() ([]byte, error) {
	type NoMethod ProcessingError
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PropertyDefinition: The definition of a property within an object.
type PropertyDefinition struct {
	BooleanPropertyOptions *BooleanPropertyOptions `json:"booleanPropertyOptions,omitempty"`

	DatePropertyOptions *DatePropertyOptions `json:"datePropertyOptions,omitempty"`

	// DisplayOptions: The options that determine how the property is
	// displayed in the Cloud Search results page if it's specified to be
	// displayed in the object's display options.
	DisplayOptions *PropertyDisplayOptions `json:"displayOptions,omitempty"`

	DoublePropertyOptions *DoublePropertyOptions `json:"doublePropertyOptions,omitempty"`

	EnumPropertyOptions *EnumPropertyOptions `json:"enumPropertyOptions,omitempty"`

	HtmlPropertyOptions *HtmlPropertyOptions `json:"htmlPropertyOptions,omitempty"`

	IntegerPropertyOptions *IntegerPropertyOptions `json:"integerPropertyOptions,omitempty"`

	// IsFacetable: Indicates that the property can be used for generating
	// facets. Cannot be true for properties whose type is object.
	// IsReturnable must be true to set this option. Only supported for
	// boolean, enum, integer, and text properties.
	IsFacetable bool `json:"isFacetable,omitempty"`

	// IsRepeatable: Indicates that multiple values are allowed for the
	// property. For example, a document only has one description but can
	// have multiple comments. Cannot be true for properties whose type is a
	// boolean. If set to false, properties that contain more than one value
	// cause the indexing request for that item to be rejected.
	IsRepeatable bool `json:"isRepeatable,omitempty"`

	// IsReturnable: Indicates that the property identifies data that should
	// be returned in search results via the Query API. If set to *true*,
	// indicates that Query API users can use matching property fields in
	// results. However, storing fields requires more space allocation and
	// uses more bandwidth for search queries, which impacts performance
	// over large datasets. Set to *true* here only if the field is needed
	// for search results. Cannot be true for properties whose type is an
	// object.
	IsReturnable bool `json:"isReturnable,omitempty"`

	// IsSortable: Indicates that the property can be used for sorting.
	// Cannot be true for properties that are repeatable. Cannot be true for
	// properties whose type is object. IsReturnable must be true to set
	// this option. Only supported for boolean, date, double, integer, and
	// timestamp properties.
	IsSortable bool `json:"isSortable,omitempty"`

	// IsSuggestable: Indicates that the property can be used for generating
	// query suggestions.
	IsSuggestable bool `json:"isSuggestable,omitempty"`

	// IsWildcardSearchable: Indicates that users can perform wildcard
	// search for this property. Only supported for Text properties.
	// IsReturnable must be true to set this option. In a given datasource
	// maximum of 5 properties can be marked as is_wildcard_searchable. For
	// more details, see Define object properties
	// (https://developers.google.com/cloud-search/docs/guides/schema-guide#properties)
	IsWildcardSearchable bool `json:"isWildcardSearchable,omitempty"`

	// Name: The name of the property. Item indexing requests sent to the
	// Indexing API should set the property name equal to this value. For
	// example, if name is *subject_line*, then indexing requests for
	// document items with subject fields should set the name for that field
	// equal to *subject_line*. Use the name as the identifier for the
	// object property. Once registered as a property for an object, you
	// cannot re-use this name for another property within that object. The
	// name must start with a letter and can only contain letters (A-Z, a-z)
	// or numbers (0-9). The maximum length is 256 characters.
	Name string `json:"name,omitempty"`

	ObjectPropertyOptions *ObjectPropertyOptions `json:"objectPropertyOptions,omitempty"`

	TextPropertyOptions *TextPropertyOptions `json:"textPropertyOptions,omitempty"`

	TimestampPropertyOptions *TimestampPropertyOptions `json:"timestampPropertyOptions,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BooleanPropertyOptions") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BooleanPropertyOptions")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *PropertyDefinition) MarshalJSON() ([]byte, error) {
	type NoMethod PropertyDefinition
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PropertyDisplayOptions: The display options for a property.
type PropertyDisplayOptions struct {
	// DisplayLabel: The user friendly label for the property that is used
	// if the property is specified to be displayed in ObjectDisplayOptions.
	// If provided, the display label is shown in front of the property
	// values when the property is part of the object display options. For
	// example, if the property value is '1', the value by itself may not be
	// useful context for the user. If the display name given was
	// 'priority', then the user sees 'priority : 1' in the search results
	// which provides clear context to search users. This is OPTIONAL; if
	// not given, only the property values are displayed. The maximum length
	// is 64 characters.
	DisplayLabel string `json:"displayLabel,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayLabel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayLabel") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PropertyDisplayOptions) MarshalJSON() ([]byte, error) {
	type NoMethod PropertyDisplayOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Provenance: This field records where the ItemScope was retrieved, if
// it was created via a web fetch.
type Provenance struct {
	// AnnotationBlob: Annotation blob from Annotation Service.
	AnnotationBlob string `json:"annotationBlob,omitempty"`

	// CanonicalUrl: Canonical url of the retrieved_url, if one was resolved
	// during retrieval, for example, if a rel="canonical" link tag was
	// provided in the retrieved web page.
	CanonicalUrl string `json:"canonicalUrl,omitempty"`

	// InputUrl: The url originally passed in the PRS request, which should
	// be used to re-discover the content. Note that this URL may be a
	// forwarding service or link shortener (bit.ly), so it should not be
	// assumed to be canonical, but should be used for navigation back to
	// the original source of the itemscope.
	InputUrl string `json:"inputUrl,omitempty"`

	// Itemtype: Contains exact types as parsed, whether or not we
	// recognized that type at parse time. If an itemscope is created by
	// merging SchemaOrg markup and open graph markup then the first
	// itemtype would be schemaorg type, the second would be open graph and
	// so on. example: http://schema.org/VideoObject, og:video.movie Plain
	// text; usually a URL
	Itemtype []string `json:"itemtype,omitempty"`

	// RetrievedTimestampMsec: The server retrieved timestamp (in msec).
	RetrievedTimestampMsec uint64 `json:"retrievedTimestampMsec,omitempty,string"`

	// RetrievedUrl: The final URL that was the actual source of the
	// itemscope, after any redirects.
	RetrievedUrl string `json:"retrievedUrl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnnotationBlob") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnnotationBlob") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Provenance) MarshalJSON() ([]byte, error) {
	type NoMethod Provenance
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PushItem: Represents an item to be pushed to the indexing queue.
type PushItem struct {
	// ContentHash: Content hash of the item according to the repository. If
	// specified, this is used to determine how to modify this item's
	// status. Setting this field and the type field results in argument
	// error. The maximum length is 2048 characters.
	ContentHash string `json:"contentHash,omitempty"`

	// MetadataHash: The metadata hash of the item according to the
	// repository. If specified, this is used to determine how to modify
	// this item's status. Setting this field and the type field results in
	// argument error. The maximum length is 2048 characters.
	MetadataHash string `json:"metadataHash,omitempty"`

	// Payload: Provides additional document state information for the
	// connector, such as an alternate repository ID and other metadata. The
	// maximum length is 8192 bytes.
	Payload string `json:"payload,omitempty"`

	// Queue: Queue to which this item belongs. The `default` queue is
	// chosen if this field is not specified. The maximum length is 512
	// characters.
	Queue string `json:"queue,omitempty"`

	// RepositoryError: Populate this field to store Connector or repository
	// error details. This information is displayed in the Admin Console.
	// This field may only be populated when the Type is REPOSITORY_ERROR.
	RepositoryError *RepositoryError `json:"repositoryError,omitempty"`

	// StructuredDataHash: Structured data hash of the item according to the
	// repository. If specified, this is used to determine how to modify
	// this item's status. Setting this field and the type field results in
	// argument error. The maximum length is 2048 characters.
	StructuredDataHash string `json:"structuredDataHash,omitempty"`

	// Type: The type of the push operation that defines the push behavior.
	//
	// Possible values:
	//   "UNSPECIFIED" - Default UNSPECIFIED. Specifies that the push
	// operation should not modify ItemStatus
	//   "MODIFIED" - Indicates that the repository document has been
	// modified or updated since the previous update call. This changes
	// status to MODIFIED state for an existing item. If this is called on a
	// non existing item, the status is changed to NEW_ITEM.
	//   "NOT_MODIFIED" - Item in the repository has not been modified since
	// the last update call. This push operation will set status to ACCEPTED
	// state.
	//   "REPOSITORY_ERROR" - Connector is facing a repository error
	// regarding this item. Change status to REPOSITORY_ERROR state. Item is
	// unreserved and rescheduled at a future time determined by exponential
	// backoff.
	//   "REQUEUE" - Call push with REQUEUE only for items that have been
	// reserved. This action unreserves the item and resets its available
	// time to the wall clock time.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContentHash") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentHash") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PushItem) MarshalJSON() ([]byte, error) {
	type NoMethod PushItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type PushItemRequest struct {
	// ConnectorName: The name of connector making this call. Format:
	// datasources/{source_id}/connectors/{ID}
	ConnectorName string `json:"connectorName,omitempty"`

	// DebugOptions: Common debug options.
	DebugOptions *DebugOptions `json:"debugOptions,omitempty"`

	// Item: Item to push onto the queue.
	Item *PushItem `json:"item,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConnectorName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConnectorName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PushItemRequest) MarshalJSON() ([]byte, error) {
	type NoMethod PushItemRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type QueryCountByStatus struct {
	Count int64 `json:"count,omitempty,string"`

	// StatusCode: This represents the http status code.
	StatusCode int64 `json:"statusCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Count") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *QueryCountByStatus) MarshalJSON() ([]byte, error) {
	type NoMethod QueryCountByStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type QueryInterpretation struct {
	// Possible values:
	//   "NONE" - Neither the natural language interpretation, nor a broader
	// version of the query is used to fetch the search results.
	//   "BLEND" - The results from original query are blended with other
	// results. The reason for blending these other results with the results
	// from original query is populated in the 'Reason' field below.
	//   "REPLACE" - The results from original query are replaced. The
	// reason for replacing the results from original query is populated in
	// the 'Reason' field below.
	InterpretationType string `json:"interpretationType,omitempty"`

	// InterpretedQuery: The interpretation of the query used in search. For
	// example, queries with natural language intent like "email from john"
	// will be interpreted as "from:john source:mail". This field will not
	// be filled when the reason is NOT_ENOUGH_RESULTS_FOUND_FOR_USER_QUERY.
	InterpretedQuery string `json:"interpretedQuery,omitempty"`

	// Reason: The reason for interpretation of the query. This field will
	// not be UNSPECIFIED if the interpretation type is not NONE.
	//
	// Possible values:
	//   "UNSPECIFIED"
	//   "QUERY_HAS_NATURAL_LANGUAGE_INTENT" - Natural language
	// interpretation of the query is used to fetch the search results.
	//   "NOT_ENOUGH_RESULTS_FOUND_FOR_USER_QUERY" - Query and document
	// terms similarity is used to selectively broaden the query to retrieve
	// additional search results since enough results were not found for the
	// user query. Interpreted query will be empty for this case.
	Reason string `json:"reason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InterpretationType")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InterpretationType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *QueryInterpretation) MarshalJSON() ([]byte, error) {
	type NoMethod QueryInterpretation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// QueryInterpretationConfig: Default options to interpret user query.
type QueryInterpretationConfig struct {
	// ForceDisableSupplementalResults: Set this flag to disable
	// supplemental results retrieval, setting a flag here will not retrieve
	// supplemental results for queries associated with a given search
	// application. If this flag is set to True, it will take precedence
	// over the option set at Query level. For the default value of False,
	// query level flag will set the correct interpretation for supplemental
	// results.
	ForceDisableSupplementalResults bool `json:"forceDisableSupplementalResults,omitempty"`

	// ForceVerbatimMode: Enable this flag to turn off all internal
	// optimizations like natural language (NL) interpretation of queries,
	// supplemental results retrieval, and usage of synonyms including
	// custom ones. If this flag is set to True, it will take precedence
	// over the option set at Query level. For the default value of False,
	// query level flag will set the correct interpretation for verbatim
	// mode.
	ForceVerbatimMode bool `json:"forceVerbatimMode,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ForceDisableSupplementalResults") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ForceDisableSupplementalResults") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *QueryInterpretationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod QueryInterpretationConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// QueryInterpretationOptions: Options to interpret user query.
type QueryInterpretationOptions struct {
	// DisableNlInterpretation: Flag to disable natural language (NL)
	// interpretation of queries. Default is false, Set to true to disable
	// natural language interpretation. NL interpretation only applies to
	// predefined datasources.
	DisableNlInterpretation bool `json:"disableNlInterpretation,omitempty"`

	// DisableSupplementalResults: Use this flag to disable supplemental
	// results for a query. Supplemental results setting chosen at
	// SearchApplication level will take precedence if set to True.
	DisableSupplementalResults bool `json:"disableSupplementalResults,omitempty"`

	// EnableVerbatimMode: Enable this flag to turn off all internal
	// optimizations like natural language (NL) interpretation of queries,
	// supplemental result retrieval, and usage of synonyms including custom
	// ones. Nl interpretation will be disabled if either one of the two
	// flags is true.
	EnableVerbatimMode bool `json:"enableVerbatimMode,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DisableNlInterpretation") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisableNlInterpretation")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *QueryInterpretationOptions) MarshalJSON() ([]byte, error) {
	type NoMethod QueryInterpretationOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// QueryItem: Information relevant only to a query entry.
type QueryItem struct {
	// IsSynthetic: True if the text was generated by means other than a
	// previous user search.
	IsSynthetic bool `json:"isSynthetic,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IsSynthetic") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IsSynthetic") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *QueryItem) MarshalJSON() ([]byte, error) {
	type NoMethod QueryItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// QueryOperator: The definition of a operator that can be used in a
// Search/Suggest request.
type QueryOperator struct {
	// DisplayName: Display name of the operator
	DisplayName string `json:"displayName,omitempty"`

	// EnumValues: Potential list of values for the opeatror field. This
	// field is only filled when we can safely enumerate all the possible
	// values of this operator.
	EnumValues []string `json:"enumValues,omitempty"`

	// GreaterThanOperatorName: Indicates the operator name that can be used
	// to isolate the property using the greater-than operator.
	GreaterThanOperatorName string `json:"greaterThanOperatorName,omitempty"`

	// IsFacetable: Can this operator be used to get facets.
	IsFacetable bool `json:"isFacetable,omitempty"`

	// IsRepeatable: Indicates if multiple values can be set for this
	// property.
	IsRepeatable bool `json:"isRepeatable,omitempty"`

	// IsReturnable: Will the property associated with this facet be
	// returned as part of search results.
	IsReturnable bool `json:"isReturnable,omitempty"`

	// IsSortable: Can this operator be used to sort results.
	IsSortable bool `json:"isSortable,omitempty"`

	// IsSuggestable: Can get suggestions for this field.
	IsSuggestable bool `json:"isSuggestable,omitempty"`

	// LessThanOperatorName: Indicates the operator name that can be used to
	// isolate the property using the less-than operator.
	LessThanOperatorName string `json:"lessThanOperatorName,omitempty"`

	// ObjectType: The name of the object corresponding to the operator.
	// This field is only filled for schema-specific operators, and is unset
	// for common operators.
	ObjectType string `json:"objectType,omitempty"`

	// OperatorName: The name of the operator.
	OperatorName string `json:"operatorName,omitempty"`

	// Type: The type of the operator.
	//
	// Possible values:
	//   "UNKNOWN" - Invalid value.
	//   "INTEGER"
	//   "DOUBLE"
	//   "TIMESTAMP"
	//   "BOOLEAN"
	//   "ENUM"
	//   "DATE"
	//   "TEXT"
	//   "HTML"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *QueryOperator) MarshalJSON() ([]byte, error) {
	type NoMethod QueryOperator
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// QuerySource: List of sources that the user can search using the query
// API.
type QuerySource struct {
	// DisplayName: Display name of the data source.
	DisplayName string `json:"displayName,omitempty"`

	// Operators: List of all operators applicable for this source.
	Operators []*QueryOperator `json:"operators,omitempty"`

	// ShortName: A short name or alias for the source. This value can be
	// used with the 'source' operator.
	ShortName string `json:"shortName,omitempty"`

	// Source: The name of the source
	Source *Source `json:"source,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *QuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod QuerySource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// QuerySuggestion: This field does not contain anything as of now and
// is just used as an indicator that the suggest result was a phrase
// completion.
type QuerySuggestion struct {
}

// QuotedMessageMetadata: Quote metadata: go/message-quoting-be-dd-v2.
// This proto is only used on the read path. For the request proto,
// refer to `QuotedMessagePayload`. Fields are either derived from
// storage directly from the Item this metadata belongs to, or is
// hydrated at read time from another Item read. Note:
// QuotedMessageMetadata proto is similar to Message proto with less
// field. Reasons to differtiate QuotedMessageMetadata from Message are:
// 1. Not all fields for original message is applicable for quoted
// message. (E.g. reactions, is_inline_reply, etc.), thus separting out
// for confusion. 2. We don't support nested message quoting. For more
// detailed discussion, please see http://shortn/_VsSXQb2C7P. For future
// reference: if your new feature/field will be supported in message
// quoting feature (go/chat-quoting-prd), you will need to add that
// field within QuotedMessageMetadata
type QuotedMessageMetadata struct {
	// Annotations: Output only. Snapshot of the annotations of the quoted
	// message.
	Annotations []*Annotation `json:"annotations,omitempty"`

	// AppProfile: Output only. Custom display profile info for apps. Will
	// be empty for real users.
	AppProfile *AppsDynamiteSharedAppProfile `json:"appProfile,omitempty"`

	// BotAttachmentState: Output only. The bot attachment state of the
	// quoted message. Used by clients to display a bot attachment indicator
	// in the UI.
	//
	// Possible values:
	//   "BOT_ATTACHMENT_STATE_UNSPECIFIED"
	//   "BOT_ATTACHMENT_STATE_HAS_BOT_ATTACHMENT"
	//   "BOT_ATTACHMENT_STATE_NO_BOT_ATTACHMENT"
	BotAttachmentState string `json:"botAttachmentState,omitempty"`

	// CreateTimeMicros: Output only. Time when the quoted message was
	// posted in microseconds.
	CreateTimeMicros int64 `json:"createTimeMicros,omitempty,string"`

	// CreatorId: Output only. ID of the User who posted the quoted message.
	// This includes information to identify if the quoted message was
	// posted by an App on behalf of a user.
	CreatorId *UserId `json:"creatorId,omitempty"`

	// LastEditTimeMicros: Output only. Time when the quoted message was
	// last edited by a user at the time when quoting action happens. Time
	// is in microseconds.
	LastEditTimeMicros int64 `json:"lastEditTimeMicros,omitempty,string"`

	// LastUpdateTimeWhenQuotedMicros: The `last_update_time` of the
	// original message when the client initiated the quote creation. This
	// is derived from the request payload passed from clients. Used to
	// fetch the quoted message contents at a specific time on the read
	// path. This field is populated from storage directly.
	LastUpdateTimeWhenQuotedMicros int64 `json:"lastUpdateTimeWhenQuotedMicros,omitempty,string"`

	// MessageId: MessageId of the original message that is being quoted.
	// This is derived from the request payload passed from clients. This
	// field is populated from storage directly.
	MessageId *MessageId `json:"messageId,omitempty"`

	// MessageState: Output only. The state of the quoted message. Used by
	// clients to display tombstones for quotes that reference a deleted
	// message.
	//
	// Possible values:
	//   "MESSAGE_STATE_UNSPECIFIED"
	//   "MESSAGE_STATE_ACTIVE" - The original message is present in storage
	// and not deleted; the message contents can be hydrated.
	//   "MESSAGE_STATE_DELETED" - The original message has been deleted;
	// the message contents cannot be hydrated.
	//   "MESSAGE_STATE_OTR_EDITED" - The OTR original message was edited
	// and therefore no longer retrievable from storage; the message
	// contents cannot be hydrated. See go/message-quoting-otr-edits for
	// more context.
	MessageState string `json:"messageState,omitempty"`

	// RetentionSettings: Output only. The retention (OTR) settings of the
	// quoted message.
	RetentionSettings *AppsDynamiteSharedRetentionSettings `json:"retentionSettings,omitempty"`

	// TextBody: Output only. Snapshot of the text body of the quoted
	// message.
	TextBody string `json:"textBody,omitempty"`

	// UpdaterId: Output only. ID of the User who last updated
	// (created/edited/deleted) the quoted message at the time when quoting
	// action happens. This includes information to identify if the quoted
	// message was posted by an App on behalf of a user.
	UpdaterId *UserId `json:"updaterId,omitempty"`

	// UploadMetadata: Output only. Upload metadata of the quoted message.
	UploadMetadata []*UploadMetadata `json:"uploadMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Annotations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *QuotedMessageMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod QuotedMessageMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Rank: The rank contains a tuple of numbers which may be used as a
// general sort order. The rank should be treated as an ordered set of
// numbers, where the ordering is done in descending order of the most
// significant rank member. For example, given the following ranks
// described as (primary, secondary): (1,1), (1,2), (2,2) (2,1) The
// descending rank-order is: (2,2) > (2,1) > (1,2) > (1,1)
type Rank struct {
	// Primary: The primary rank is the most significant rank member. This
	// rank element should always be present. Items with higher primary rank
	// are always considered of higher rank than those of lower primary
	// rank.
	Primary int64 `json:"primary,omitempty,string"`

	// Secondary: The secondary rank may be used to rank items of identical
	// primary rank. This rank element should always be present.
	Secondary int64 `json:"secondary,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Primary") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Primary") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Rank) MarshalJSON() ([]byte, error) {
	type NoMethod Rank
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RbacRoleProto: Principal associated with a given RBAC role. This
// principal is used by Sphinx Provisioning Service for RBAC
// provisionable (go/sphinx-rbacz).
type RbacRoleProto struct {
	Name string `json:"name,omitempty"`

	ObjectId string `json:"objectId,omitempty"`

	// RbacNamespace: DEPRECATED as of 01.11.2019
	RbacNamespace string `json:"rbacNamespace,omitempty"`

	// RbacRoleName: Format: "role/z?" - "role" is the Sphinx globally
	// unique name of the Sphinx role that provisions the RBAC role. - "/z?"
	// suffix indicates which Zanzibar environment stores the role
	// membership data ("/zd": dev, "/zs": staging, "/zp": prod, "/zt":
	// local test instance). Example: "mysystem_myrole/zp"
	RbacRoleName string `json:"rbacRoleName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RbacRoleProto) MarshalJSON() ([]byte, error) {
	type NoMethod RbacRoleProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RbacSubjectProto: Principal associated with a given RBAC subject.
// This principal is used by Sphinx Provisioning Service for RBAC
// provisionable (go/sphinx-rbacz).
type RbacSubjectProto struct {
	// Username: Format "username" without "@domain", e.g., "bogdand".
	Username string `json:"username,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Username") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Username") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RbacSubjectProto) MarshalJSON() ([]byte, error) {
	type NoMethod RbacSubjectProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReactionInfo: Contains information about an emoji reaction.
type ReactionInfo struct {
	// Emoji: Unicode string representing a single emoji.
	Emoji string `json:"emoji,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Emoji") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Emoji") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReactionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ReactionInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ReadReceiptsSettingsUpdatedMetadata struct {
	// ReadReceiptsEnabled: The new read receipts state.
	ReadReceiptsEnabled bool `json:"readReceiptsEnabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ReadReceiptsEnabled")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ReadReceiptsEnabled") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ReadReceiptsSettingsUpdatedMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod ReadReceiptsSettingsUpdatedMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type Recipient struct {
	Email string `json:"email,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Email") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Recipient) MarshalJSON() ([]byte, error) {
	type NoMethod Recipient
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RecordingEvent: A recording event is something that happens to the
// recording in a conference.
type RecordingEvent struct {
	// DeviceId: The initiator of the latest event of the recording. It will
	// be set for all user events (`type` is 100-199) and unset for all
	// server events (`type` is 200-299).
	DeviceId string `json:"deviceId,omitempty"`

	// Type: The type of event.
	//
	// Possible values:
	//   "RECORDING_EVENT_UNSPECIFIED" - This is never used.
	//   "USER_ACTION" - Deprecated, use detailed user actions instead.
	//   "STARTED_BY_USER" - Recording was started or is being started by a
	// user.
	//   "STOPPED_BY_USER" - Recording was stopped by a user.
	//   "CANCELLED_BY_USER" - Recording was cancelled by a user.
	//   "CANCELLED_INITIALIZATION_FAILED" - Recording was cancelled by the
	// server because of a failure during recording initialization.
	//   "CANCELLED_INITIATOR_LEFT" - Recording was cancelled by the server
	// because the recording initiator left the conference during
	// initialization. When the initiator leaves after the recording is
	// started, no event is triggered.
	//   "ACTIVE_ABOUT_TO_STOP_TOO_LONG" - Recording is about to be stopped
	// by the server because the recording is about to reach the maximum
	// duration.
	//   "STOPPED_TOO_LONG" - Recording was stopped because the recording
	// reached the maximum duration.
	//   "STOPPED_ALL_DEVICES_LEFT" - Recording was stopped because there
	// were no devices left in the conference.
	//   "STOPPED_INTERNAL_FAILURES" - Recording was stopped because of an
	// internal error.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RecordingEvent) MarshalJSON() ([]byte, error) {
	type NoMethod RecordingEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RecordingInfo: This message is deprecated, please use
// RecordingSessionInfo instead. Information about recording in the
// current conference.
type RecordingInfo struct {
	// LatestRecordingEvent: The latest recording event. This can be used by
	// clients to help explain what is going on, why recording stopped, etc.
	// This will always be set if there is or was an active recording, which
	// means there can be latest event when recording is INACTIVE.
	LatestRecordingEvent *RecordingEvent `json:"latestRecordingEvent,omitempty"`

	// OwnerDisplayName: The display name of the owner of the recording
	// output. Email notifications about uploaded recordings will also be
	// sent to this owner.
	OwnerDisplayName string `json:"ownerDisplayName,omitempty"`

	// ProducerDeviceId: The device resource name of the producer device for
	// the currently active recording. Note that, after the producer
	// drops/leaves the conference, this field will be cleaned up by the
	// server after a delay.
	ProducerDeviceId string `json:"producerDeviceId,omitempty"`

	// RecordingApplicationType: The application type of the current active
	// recording. `RECORDING_APPLICATION_TYPE_UNSPECIFIED` if
	// `recording_status` is inactive.
	//
	// Possible values:
	//   "RECORDING_APPLICATION_TYPE_UNSPECIFIED" - This is never used.
	//   "RECORDING" - A meeting recording saved to a video file in Google
	// Drive.
	//   "GLIVE_STREAM" - A *Google Live* managed stream.
	//   "BROADCAST" - A meeting broadcast.
	RecordingApplicationType string `json:"recordingApplicationType,omitempty"`

	// RecordingId: An identifier for the current recording, if any. This is
	// returned whenever recording_status is either `RECORDING_STARTING` or
	// `RECORDING_STARTED`.
	RecordingId string `json:"recordingId,omitempty"`

	// RecordingStatus: The current status of the recording. This can be
	// used by clients to show a recording dot or similar to indicated to
	// the user that a recording is taking place.
	//
	// Possible values:
	//   "RECORDING_UNSPECIFIED" - This value is never used.
	//   "RECORDING_INACTIVE" - The conference is not being recorded. This
	// can mean either that no recording has been started, or that a
	// previous recording has stopped.
	//   "RECORDING_STARTING" - Recording is about to begin. The status will
	// be updated to RECORDING_STARTED when the recording actually starts,
	// which happens when all the backend plumbing is set up.
	//   "RECORDING_STARTED" - The recording is started. Any media sent to
	// the conference may be included in the resulting recording.
	RecordingStatus string `json:"recordingStatus,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "LatestRecordingEvent") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LatestRecordingEvent") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RecordingInfo) MarshalJSON() ([]byte, error) {
	type NoMethod RecordingInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RecordingSessionInfo: Information about a recording session.
type RecordingSessionInfo struct {
	// OwnerEmail: Input only. Deprecated field, should not be used.
	OwnerEmail string `json:"ownerEmail,omitempty"`

	// RecordingSessionId: A unique server-generated ID for the recording
	// session.
	RecordingSessionId string `json:"recordingSessionId,omitempty"`

	// SessionStateInfo: Recording session's state information.
	SessionStateInfo *SessionStateInfo `json:"sessionStateInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OwnerEmail") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OwnerEmail") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RecordingSessionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod RecordingSessionInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Reference: All fields in this proto are now columns in spanner see
// google3/storage/slice/production/gmail/user_data_tables.pi for
// documentation.
type Reference struct {
	BlobId string `json:"blobId,omitempty"`

	ContentType string `json:"contentType,omitempty"`

	Hash string `json:"hash,omitempty"`

	// Key: LINT.IfChange
	Key string `json:"key,omitempty"`

	// Name: LINT.ThenChange(//depot/google3/storage/slice/production/gmail/
	// user_data_tables.pi)
	Name string `json:"name,omitempty"`

	Size int64 `json:"size,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "BlobId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BlobId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Reference) MarshalJSON() ([]byte, error) {
	type NoMethod Reference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type References struct {
	References []*Reference `json:"references,omitempty"`

	// ForceSendFields is a list of field names (e.g. "References") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "References") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *References) MarshalJSON() ([]byte, error) {
	type NoMethod References
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type RenameEvent struct {
	NewName string `json:"newName,omitempty"`

	OriginalName string `json:"originalName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NewName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NewName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RenameEvent) MarshalJSON() ([]byte, error) {
	type NoMethod RenameEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RepositoryError: Errors when the connector is communicating to the
// source repository.
type RepositoryError struct {
	// ErrorMessage: Message that describes the error. The maximum allowable
	// length of the message is 8192 characters.
	ErrorMessage string `json:"errorMessage,omitempty"`

	// HttpStatusCode: Error codes. Matches the definition of HTTP status
	// codes.
	HttpStatusCode int64 `json:"httpStatusCode,omitempty"`

	// Type: The type of error.
	//
	// Possible values:
	//   "UNKNOWN" - Unknown error.
	//   "NETWORK_ERROR" - Unknown or unreachable host.
	//   "DNS_ERROR" - DNS problem, such as the DNS server is not
	// responding.
	//   "CONNECTION_ERROR" - Cannot connect to the repository server.
	//   "AUTHENTICATION_ERROR" - Failed authentication due to incorrect
	// credentials.
	//   "AUTHORIZATION_ERROR" - Service account is not authorized for the
	// repository.
	//   "SERVER_ERROR" - Repository server error.
	//   "QUOTA_EXCEEDED" - Quota exceeded.
	//   "SERVICE_UNAVAILABLE" - Server temporarily unavailable.
	//   "CLIENT_ERROR" - Client-related error, such as an invalid request
	// from the connector to the repository server.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorMessage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorMessage") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RepositoryError) MarshalJSON() ([]byte, error) {
	type NoMethod RepositoryError
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type RequestFileScope struct {
	ItemId string `json:"itemId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ItemId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ItemId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RequestFileScope) MarshalJSON() ([]byte, error) {
	type NoMethod RequestFileScope
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type RequestFileScopeForActiveDocument struct {
}

// RequestOptions: Shared request options for all RPC methods.
type RequestOptions struct {
	// DebugOptions: Debug options of the request
	DebugOptions *DebugOptions `json:"debugOptions,omitempty"`

	// LanguageCode: The BCP-47 language code, such as "en-US" or "sr-Latn".
	// For more information, see
	// http://www.unicode.org/reports/tr35/#Unicode_locale_identifier. For
	// translations. Set this field using the language set in browser or for
	// the page. In the event that the user's language preference is known,
	// set this field to the known user language. When specified, the
	// documents in search results are biased towards the specified
	// language. From Suggest API perspective, for 3p suggest this is used
	// as a hint while making predictions to add language boosting.
	LanguageCode string `json:"languageCode,omitempty"`

	// SearchApplicationId: The ID generated when you create a search
	// application using the admin console
	// (https://support.google.com/a/answer/9043922).
	SearchApplicationId string `json:"searchApplicationId,omitempty"`

	// TimeZone: Current user's time zone id, such as "America/Los_Angeles"
	// or "Australia/Sydney". These IDs are defined by Unicode Common Locale
	// Data Repository (CLDR) (http://cldr.unicode.org/) project, and
	// currently available in the file timezone.xml
	// (http://unicode.org/repos/cldr/trunk/common/bcp47/timezone.xml). This
	// field is used to correctly interpret date and time queries. If this
	// field is not specified, the default time zone (UTC) is used.
	TimeZone string `json:"timeZone,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DebugOptions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DebugOptions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RequestOptions) MarshalJSON() ([]byte, error) {
	type NoMethod RequestOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RequiredMessageFeaturesMetadata: A list of capabilities that are used
// in this message.
type RequiredMessageFeaturesMetadata struct {
	// Possible values:
	//   "REQUIRED_FEATURE_UNSPECIFIED"
	//   "REQUIRED_FEATURE_MESSAGE_QUOTING"
	//   "REQUIRED_FEATURE_TOMBSTONES_IN_DMS_AND_UFRS"
	//   "REQUIRED_FEATURE_CUSTOM_HYPERLINK"
	RequiredFeatures []string `json:"requiredFeatures,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RequiredFeatures") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RequiredFeatures") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RequiredMessageFeaturesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod RequiredMessageFeaturesMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ResetSearchApplicationRequest struct {
	// DebugOptions: Common debug options.
	DebugOptions *DebugOptions `json:"debugOptions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DebugOptions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DebugOptions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ResetSearchApplicationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ResetSearchApplicationRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ResourceRoleProto: A type of sharing target that points to some
// resource's ACL. Used to refer to the set of Principals that have the
// given privilege ('role_id') for the given resource ('application_id',
// 'object_id', 'object_part'). The meaning of 'role_id' is interpreted
// only by implementations of AclRpcService and is usually dependent on
// 'application_id' All fields except object_part are required. If
// present, object_part must be non-empty.
type ResourceRoleProto struct {
	ApplicationId string `json:"applicationId,omitempty"`

	ObjectId string `json:"objectId,omitempty"`

	ObjectPart string `json:"objectPart,omitempty"`

	RoleId int64 `json:"roleId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApplicationId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApplicationId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ResourceRoleProto) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceRoleProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ResponseDebugInfo: Debugging information about the response.
type ResponseDebugInfo struct {
	// FormattedDebugInfo: General debug info formatted for display.
	FormattedDebugInfo string `json:"formattedDebugInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FormattedDebugInfo")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FormattedDebugInfo") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ResponseDebugInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ResponseDebugInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RestrictItem: Information relevant only to a restrict entry. NextId:
// 12
type RestrictItem struct {
	DriveFollowUpRestrict *DriveFollowUpRestrict `json:"driveFollowUpRestrict,omitempty"`

	DriveLocationRestrict *DriveLocationRestrict `json:"driveLocationRestrict,omitempty"`

	// DriveMimeTypeRestrict: Drive Types.
	DriveMimeTypeRestrict *DriveMimeTypeRestrict `json:"driveMimeTypeRestrict,omitempty"`

	DriveTimeSpanRestrict *DriveTimeSpanRestrict `json:"driveTimeSpanRestrict,omitempty"`

	// SearchOperator: The search restrict (e.g. "after:2017-09-11
	// before:2017-09-12").
	SearchOperator string `json:"searchOperator,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DriveFollowUpRestrict") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DriveFollowUpRestrict") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RestrictItem) MarshalJSON() ([]byte, error) {
	type NoMethod RestrictItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ResultCounts: Result count information
type ResultCounts struct {
	// SourceResultCounts: Result count information for each source with
	// results.
	SourceResultCounts []*SourceResultCount `json:"sourceResultCounts,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SourceResultCounts")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SourceResultCounts") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ResultCounts) MarshalJSON() ([]byte, error) {
	type NoMethod ResultCounts
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ResultDebugInfo: Debugging information about the result.
type ResultDebugInfo struct {
	// FormattedDebugInfo: General debug info formatted for display.
	FormattedDebugInfo string `json:"formattedDebugInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FormattedDebugInfo")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FormattedDebugInfo") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ResultDebugInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ResultDebugInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ResultDisplayField: Display Fields for Search Results
type ResultDisplayField struct {
	// Label: The display label for the property.
	Label string `json:"label,omitempty"`

	// OperatorName: The operator name of the property.
	OperatorName string `json:"operatorName,omitempty"`

	// Property: The name value pair for the property.
	Property *NamedProperty `json:"property,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Label") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Label") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ResultDisplayField) MarshalJSON() ([]byte, error) {
	type NoMethod ResultDisplayField
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ResultDisplayLine: The collection of fields that make up a displayed
// line
type ResultDisplayLine struct {
	Fields []*ResultDisplayField `json:"fields,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Fields") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Fields") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ResultDisplayLine) MarshalJSON() ([]byte, error) {
	type NoMethod ResultDisplayLine
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ResultDisplayMetadata struct {
	// Metalines: The metalines content to be displayed with the result.
	Metalines []*ResultDisplayLine `json:"metalines,omitempty"`

	// ObjectTypeLabel: The display label for the object.
	ObjectTypeLabel string `json:"objectTypeLabel,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metalines") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metalines") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ResultDisplayMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod ResultDisplayMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type RetrievalImportance struct {
	// Importance: Indicates the ranking importance given to property when
	// it is matched during retrieval. Once set, the token importance of a
	// property cannot be changed.
	//
	// Possible values:
	//   "DEFAULT" - Treat the match like a body text match.
	//   "HIGHEST" - Treat the match like a match against title of the item.
	//   "HIGH" - Treat the match with higher importance than body text.
	//   "LOW" - Treat the match with lower importance than body text.
	//   "NONE" - Do not match against this field during retrieval. The
	// property can still be used for operator matching, faceting, and
	// suggest if desired.
	Importance string `json:"importance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Importance") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Importance") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RetrievalImportance) MarshalJSON() ([]byte, error) {
	type NoMethod RetrievalImportance
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type RoomRenameMetadata struct {
	NewName string `json:"newName,omitempty"`

	// PrevName: NEXT_TAG: 3
	PrevName string `json:"prevName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NewName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NewName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RoomRenameMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod RoomRenameMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type RoomUpdatedMetadata struct {
	GroupDetailsMetadata *GroupDetailsUpdatedMetadata `json:"groupDetailsMetadata,omitempty"`

	GroupLinkSharingEnabled bool `json:"groupLinkSharingEnabled,omitempty"`

	// Initiator: The user who initiated this room update. Complete member
	// profiles, when ListTopicsRequest FetchOptions.USER is set. Otherwise,
	// only the id will be filled in.
	Initiator *User `json:"initiator,omitempty"`

	// InitiatorType: The type of the user who initiated this room update.
	//
	// Possible values:
	//   "INITIATOR_TYPE_UNSPECIFIED"
	//   "INITIATOR_TYPE_END_USER"
	//   "INITIATOR_TYPE_ADMIN"
	InitiatorType string `json:"initiatorType,omitempty"`

	// Name: What was updated in the room.
	Name string `json:"name,omitempty"`

	RenameMetadata *RoomRenameMetadata `json:"renameMetadata,omitempty"`

	// Visibility: DEPRECATED: See GroupVisibility proto definition.
	Visibility *AppsDynamiteSharedGroupVisibility `json:"visibility,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "GroupDetailsMetadata") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GroupDetailsMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RoomUpdatedMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod RoomUpdatedMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Roster: Roster profile information.
type Roster struct {
	AvatarUrl string `json:"avatarUrl,omitempty"`

	Id *RosterId `json:"id,omitempty"`

	// IsMembershipVisibleToCaller: Whether caller has visibility into
	// members of the roster.
	IsMembershipVisibleToCaller bool `json:"isMembershipVisibleToCaller,omitempty"`

	MembershipCount int64 `json:"membershipCount,omitempty"`

	Name string `json:"name,omitempty"`

	// RosterGaiaKey: Roster gaia key, usually an email address. Set in
	// looking up rosters response.
	RosterGaiaKey string `json:"rosterGaiaKey,omitempty"`

	// RosterState: Roster deletion state - considered active unless set to
	// deleted
	//
	// Possible values:
	//   "ROSTER_STATE_UNKNOWN"
	//   "ROSTER_ACTIVE" - Roster is active
	//   "ROSTER_DELETED" - Roster deleted
	RosterState string `json:"rosterState,omitempty"`

	// SegmentedMembershipCounts: Roster membership count. May contain
	// counts based on member type and membership state.
	SegmentedMembershipCounts *AppsDynamiteSharedSegmentedMembershipCounts `json:"segmentedMembershipCounts,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AvatarUrl") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AvatarUrl") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Roster) MarshalJSON() ([]byte, error) {
	type NoMethod Roster
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RosterId: Primary key for Roster resource.
type RosterId struct {
	// Id: Opaque, server-assigned ID of the Roster.
	Id string `json:"id,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RosterId) MarshalJSON() ([]byte, error) {
	type NoMethod RosterId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RpcOptions: Options for Triggers dispatched via RPC.
type RpcOptions struct {
	// RequestExtensions: The RPC's request extensions (i.e.
	// RPC::request_extensions(), a.k.a. the Stubby side channel) will be
	// merged with the specified [request_extensions]. When Triggers are
	// batched, the RPC's request extensions will be merged with all of the
	// [request_extensions] of the Triggers in the batch. Note that merging
	// of request extensions follows standard protocol buffer semantics;
	// values of singular fields override previous values, and values of
	// repeated fields are appended (In the case of Triggers, Triggers with
	// later fire times will be merged after Triggers with earlier fire
	// times in the same batch). It is not advised to specify extensions
	// with repeated fields on batchable Triggers.
	RequestExtensions *MessageSet `json:"requestExtensions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RequestExtensions")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RequestExtensions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RpcOptions) MarshalJSON() ([]byte, error) {
	type NoMethod RpcOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SafeUrlProto: Message containing a string that is safe to use in URL
// contexts in DOM APIs and HTML documents, where the URL context does
// not refer to a resource that loads code.
type SafeUrlProto struct {
	// PrivateDoNotAccessOrElseSafeUrlWrappedValue: IMPORTANT: Never set or
	// read this field, even from tests, it is private. See documentation at
	// the top of .proto file for programming language packages with which
	// to create or read this message.
	PrivateDoNotAccessOrElseSafeUrlWrappedValue string `json:"privateDoNotAccessOrElseSafeUrlWrappedValue,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "PrivateDoNotAccessOrElseSafeUrlWrappedValue") to unconditionally
	// include in API requests. By default, fields with empty or default
	// values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "PrivateDoNotAccessOrElseSafeUrlWrappedValue") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SafeUrlProto) MarshalJSON() ([]byte, error) {
	type NoMethod SafeUrlProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Schema: The schema definition for a data source.
type Schema struct {
	// ObjectDefinitions: The list of top-level objects for the data source.
	// The maximum number of elements is 10.
	ObjectDefinitions []*ObjectDefinition `json:"objectDefinitions,omitempty"`

	// OperationIds: IDs of the Long Running Operations (LROs) currently
	// running for this schema. After modifying the schema, wait for
	// operations to complete before indexing additional content.
	OperationIds []string `json:"operationIds,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ObjectDefinitions")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ObjectDefinitions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Schema) MarshalJSON() ([]byte, error) {
	type NoMethod Schema
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ScoringConfig: Scoring configurations for a source while processing a
// Search or Suggest request.
type ScoringConfig struct {
	// DisableFreshness: Whether to use freshness as a ranking signal. By
	// default, freshness is used as a ranking signal. Note that this
	// setting is not available in the Admin UI.
	DisableFreshness bool `json:"disableFreshness,omitempty"`

	// DisablePersonalization: Whether to personalize the results. By
	// default, personal signals will be used to boost results.
	DisablePersonalization bool `json:"disablePersonalization,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisableFreshness") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisableFreshness") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ScoringConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ScoringConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SearchApplication: SearchApplication
type SearchApplication struct {
	// DataSourceRestrictions: Retrictions applied to the configurations.
	// The maximum number of elements is 10.
	DataSourceRestrictions []*DataSourceRestriction `json:"dataSourceRestrictions,omitempty"`

	// DefaultFacetOptions: The default fields for returning facet results.
	// The sources specified here also have been included in
	// data_source_restrictions above.
	DefaultFacetOptions []*FacetOptions `json:"defaultFacetOptions,omitempty"`

	// DefaultSortOptions: The default options for sorting the search
	// results
	DefaultSortOptions *SortOptions `json:"defaultSortOptions,omitempty"`

	// DisplayName: Display name of the Search Application. The maximum
	// length is 300 characters.
	DisplayName string `json:"displayName,omitempty"`

	// EnableAuditLog: Indicates whether audit logging is on/off for
	// requests made for the search application in query APIs.
	EnableAuditLog bool `json:"enableAuditLog,omitempty"`

	// Name: The name of the Search Application. Format:
	// searchapplications/{application_id}.
	Name string `json:"name,omitempty"`

	// OperationIds: Output only. IDs of the Long Running Operations (LROs)
	// currently running for this schema. Output only field.
	OperationIds []string `json:"operationIds,omitempty"`

	// QueryInterpretationConfig: The default options for query
	// interpretation
	QueryInterpretationConfig *QueryInterpretationConfig `json:"queryInterpretationConfig,omitempty"`

	// ReturnResultThumbnailUrls: With each result we should return the URI
	// for its thumbnail (when applicable)
	ReturnResultThumbnailUrls bool `json:"returnResultThumbnailUrls,omitempty"`

	// ScoringConfig: Configuration for ranking results.
	ScoringConfig *ScoringConfig `json:"scoringConfig,omitempty"`

	// SourceConfig: Configuration for a sources specified in
	// data_source_restrictions.
	SourceConfig []*SourceConfig `json:"sourceConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "DataSourceRestrictions") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataSourceRestrictions")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SearchApplication) MarshalJSON() ([]byte, error) {
	type NoMethod SearchApplication
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SearchApplicationQueryStats: Search application level query stats per
// date
type SearchApplicationQueryStats struct {
	// Date: The date for which query stats were calculated. Stats
	// calculated on the next day close to midnight are returned.
	Date *Date `json:"date,omitempty"`

	QueryCountByStatus []*QueryCountByStatus `json:"queryCountByStatus,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Date") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Date") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SearchApplicationQueryStats) MarshalJSON() ([]byte, error) {
	type NoMethod SearchApplicationQueryStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type SearchApplicationSessionStats struct {
	// Date: The date for which session stats were calculated. Stats are
	// calculated on the following day, close to midnight PST, and then
	// returned.
	Date *Date `json:"date,omitempty"`

	// SearchSessionsCount: The count of search sessions on the day
	SearchSessionsCount int64 `json:"searchSessionsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Date") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Date") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SearchApplicationSessionStats) MarshalJSON() ([]byte, error) {
	type NoMethod SearchApplicationSessionStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type SearchApplicationUserStats struct {
	// Date: The date for which session stats were calculated. Stats
	// calculated on the next day close to midnight are returned.
	Date *Date `json:"date,omitempty"`

	// OneDayActiveUsersCount: The count of unique active users in the past
	// one day
	OneDayActiveUsersCount int64 `json:"oneDayActiveUsersCount,omitempty,string"`

	// SevenDaysActiveUsersCount: The count of unique active users in the
	// past seven days
	SevenDaysActiveUsersCount int64 `json:"sevenDaysActiveUsersCount,omitempty,string"`

	// ThirtyDaysActiveUsersCount: The count of unique active users in the
	// past thirty days
	ThirtyDaysActiveUsersCount int64 `json:"thirtyDaysActiveUsersCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Date") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Date") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SearchApplicationUserStats) MarshalJSON() ([]byte, error) {
	type NoMethod SearchApplicationUserStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type SearchItemsByViewUrlRequest struct {
	// DebugOptions: Common debug options.
	DebugOptions *DebugOptions `json:"debugOptions,omitempty"`

	// PageToken: The next_page_token value returned from a previous
	// request, if any.
	PageToken string `json:"pageToken,omitempty"`

	// ViewUrl: Specify the full view URL to find the corresponding item.
	// The maximum length is 2048 characters.
	ViewUrl string `json:"viewUrl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DebugOptions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DebugOptions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SearchItemsByViewUrlRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SearchItemsByViewUrlRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type SearchItemsByViewUrlResponse struct {
	Items []*Item `json:"items,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Items") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SearchItemsByViewUrlResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchItemsByViewUrlResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SearchQualityMetadata: Additional search quality metadata of the
// item.
type SearchQualityMetadata struct {
	// Quality: An indication of the quality of the item, used to influence
	// search quality. Value should be between 0.0 (lowest quality) and 1.0
	// (highest quality). The default value is 0.0.
	Quality float64 `json:"quality,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Quality") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Quality") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SearchQualityMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod SearchQualityMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *SearchQualityMetadata) UnmarshalJSON(data []byte) error {
	type NoMethod SearchQualityMetadata
	var s1 struct {
		Quality gensupport.JSONFloat64 `json:"quality"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Quality = float64(s1.Quality)
	return nil
}

// SearchRequest: The search API request.
type SearchRequest struct {
	// ContextAttributes: Context attributes for the request which will be
	// used to adjust ranking of search results. The maximum number of
	// elements is 10.
	ContextAttributes []*ContextAttribute `json:"contextAttributes,omitempty"`

	// DataSourceRestrictions: The sources to use for querying. If not
	// specified, all data sources from the current search application are
	// used.
	DataSourceRestrictions []*DataSourceRestriction `json:"dataSourceRestrictions,omitempty"`

	FacetOptions []*FacetOptions `json:"facetOptions,omitempty"`

	// PageSize: Maximum number of search results to return in one page.
	// Valid values are between 1 and 100, inclusive. Default value is 10.
	// Minimum value is 50 when results beyond 2000 are requested.
	PageSize int64 `json:"pageSize,omitempty"`

	// Query: The raw query string. See supported search operators in the
	// Narrow your search with operators
	// (https://support.google.com/cloudsearch/answer/6172299)
	Query string `json:"query,omitempty"`

	// QueryInterpretationOptions: Options to interpret the user query.
	QueryInterpretationOptions *QueryInterpretationOptions `json:"queryInterpretationOptions,omitempty"`

	// RequestOptions: Request options, such as the search application and
	// user timezone.
	RequestOptions *RequestOptions `json:"requestOptions,omitempty"`

	// SortOptions: The options for sorting the search results
	SortOptions *SortOptions `json:"sortOptions,omitempty"`

	// Start: Starting index of the results.
	Start int64 `json:"start,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContextAttributes")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContextAttributes") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SearchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SearchRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SearchResponse: The search API response.
type SearchResponse struct {
	// DebugInfo: Debugging information about the response.
	DebugInfo *ResponseDebugInfo `json:"debugInfo,omitempty"`

	// ErrorInfo: Error information about the response.
	ErrorInfo *ErrorInfo `json:"errorInfo,omitempty"`

	// FacetResults: Repeated facet results.
	FacetResults []*FacetResult `json:"facetResults,omitempty"`

	// HasMoreResults: Whether there are more search results matching the
	// query.
	HasMoreResults bool `json:"hasMoreResults,omitempty"`

	// QueryInterpretation: Query interpretation result for user query.
	// Empty if query interpretation is disabled.
	QueryInterpretation *QueryInterpretation `json:"queryInterpretation,omitempty"`

	// ResultCountEstimate: The estimated result count for this query.
	ResultCountEstimate int64 `json:"resultCountEstimate,omitempty,string"`

	// ResultCountExact: The exact result count for this query.
	ResultCountExact int64 `json:"resultCountExact,omitempty,string"`

	// ResultCounts: Expanded result count information.
	ResultCounts *ResultCounts `json:"resultCounts,omitempty"`

	// Results: Results from a search query.
	Results []*SearchResult `json:"results,omitempty"`

	// SpellResults: Suggested spelling for the query.
	SpellResults []*SpellResult `json:"spellResults,omitempty"`

	// StructuredResults: Structured results for the user query. These
	// results are not counted against the page_size.
	StructuredResults []*StructuredResult `json:"structuredResults,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DebugInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DebugInfo") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SearchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SearchResult: Results containing indexed information for a document.
type SearchResult struct {
	// ClusteredResults: If source is clustered, provide list of clustered
	// results. There will only be one level of clustered results. If
	// current source is not enabled for clustering, this field will be
	// empty.
	ClusteredResults []*SearchResult `json:"clusteredResults,omitempty"`

	// DebugInfo: Debugging information about this search result.
	DebugInfo *ResultDebugInfo `json:"debugInfo,omitempty"`

	// Metadata: Metadata of the search result.
	Metadata *Metadata `json:"metadata,omitempty"`

	// Snippet: The concatenation of all snippets (summaries) available for
	// this result.
	Snippet *Snippet `json:"snippet,omitempty"`

	// Title: Title of the search result.
	Title string `json:"title,omitempty"`

	// Url: The URL of the search result. The URL contains a Google redirect
	// to the actual item. This URL is signed and shouldn't be changed.
	Url string `json:"url,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ClusteredResults") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClusteredResults") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod SearchResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Section: Sections are separated by a line divider. They contain a
// collection of widgets that are rendered (vertically) in the order
// that they are specified. Across all platforms, AddOns have a narrow
// fixed width, so there is currently no need for layout properties
// (e.g. float).
type Section struct {
	// Collapsable: Indicating whether this section is collapsable. If a
	// section is collapsable, the description must be given.
	Collapsable bool `json:"collapsable,omitempty"`

	// Description: The header of the section, text formatted supported.
	Description string `json:"description,omitempty"`

	// NumUncollapsableWidgets: The number of uncollapsable widgets. For
	// example, when a section contains 5 widgets and the
	// num_uncollapsable_widget are set to be 2, The first 2 widgets will
	// always shown and the last 3 is collapsed as default. Only when
	// collapsable is set to be true, the num_uncollapsable_widget will be
	// taken into account.
	NumUncollapsableWidgets int64 `json:"numUncollapsableWidgets,omitempty"`

	// Widgets: A section must contain at least 1 widget.
	Widgets []*WidgetMarkup `json:"widgets,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Collapsable") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Collapsable") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Section) MarshalJSON() ([]byte, error) {
	type NoMethod Section
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type Segment struct {
	// Formatting: Formatting to be applied when rendering the Segment. For
	// all segment types, this is the standard way of representing that the
	// Segment should be rendered in bold, italics, etc.
	Formatting *Formatting `json:"formatting,omitempty"`

	// HashtagData: For HASHTAG type:
	HashtagData *HashtagData `json:"hashtagData,omitempty"`

	// LinkData: Type-specific metadata. At most one of these should be
	// populated, and the one that is populated should correspond to the
	// type of the Segment. For LINK type:
	LinkData *LinkData `json:"linkData,omitempty"`

	// Text: Text content of the Segment. As a general rule, this field
	// should contain the actual text that should be rendered in the UI.
	// Thus, for a hashtag, it should be "#Foo", and for a link, it should
	// be the display text. Clients that do not understand a particular
	// segment type may use this text, along with the Formatting info below,
	// as a fallback for display. The field is not required -- if all
	// relevant information is carried in other metadata fields and there is
	// no need for a fallback, or it is not practical for a fallback to be
	// provided for any other reason, the field may be left blank. A
	// standard example would be a user reference being transmitted between
	// server layers, where a gaia-ID representation may be sufficient and
	// there is no need for a textual fallback. In such a case, it would be
	// valid and useful - though not required - for servers to compute and
	// populate a fallback on the serving path.
	Text string `json:"text,omitempty"`

	// Type: Type of Segment.
	//
	// Possible values:
	//   "TEXT" - A TEXT segment represents plain-text subject to particular
	// formatting constraints (as represented in the "formatting" field of
	// the Segment).
	//   "LINE_BREAK" - A LINE_BREAK segment is simply a placeholder to
	// represent a line break between other segments. The "text" variable
	// may be set to a newline as a fallback, but clients that understand
	// this segment type should simply insert a line break without needing
	// to reference any fields.
	//   "LINK" - A LINK segment represents a link to a web entity. The
	// "text" field should be used for anchor text. Additional link data
	// should be put in the link_data protobuf.
	//   "USER_MENTION" - A USER_MENTION segment represents a reference to a
	// (possibly non-Gaia, possibly off-network) user. The "text" field may
	// be populated as a fallback, but information identifying the user
	// should be contained in the user_mention_data protobuf. (The set of
	// fields that are populated in user_mention_data may differ depending
	// on the context in which the segment is viewed, but the interpretation
	// of the fields is uniform. See comments over UserMentionData).
	//   "ALL_USER_MENTION" - An ALL_USER_MENTION segment represents a
	// reference to all users in the context, that is, the conversation,
	// discussion, or other context containing the segment. For example, an
	// ALL_USER_MENTION segment ("@all") can be useful to ping all
	// participants in a conversation if the notification setting of the
	// conversation is not set to ping on normal messages. An
	// ALL_USER_MENTION should be treated as a USER_MENTION for all users
	// who receives the segment.
	//   "HASHTAG" - A HASHTAG segment represents a structured reference to
	// a topic. The "text" field should represent display text (e.g.
	// "#Google"), and additional metadata should be put in the Segment's
	// hashtag_data field.
	Type string `json:"type,omitempty"`

	// UserMentionData: For USER_MENTION type:
	UserMentionData *UserMentionData `json:"userMentionData,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Formatting") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Formatting") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Segment) MarshalJSON() ([]byte, error) {
	type NoMethod Segment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type SelectionControl struct {
	// Items: For radio button, at most one of the items will be selected.
	Items []*SelectionItem `json:"items,omitempty"`

	// Label: Label used to be displayed ahead of the selection control. It
	// is optional.
	Label string `json:"label,omitempty"`

	// Name: The name of the text field which is will be used in FormInput.
	Name string `json:"name,omitempty"`

	// OnChange: If specified, form is submitted when selection changed. If
	// not specified, developer will need to specify a separate button.
	OnChange *FormAction `json:"onChange,omitempty"`

	// Possible values:
	//   "CHECK_BOX"
	//   "RADIO_BUTTON"
	//   "SWITCH"
	//   "DROPDOWN"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Items") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SelectionControl) MarshalJSON() ([]byte, error) {
	type NoMethod SelectionControl
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type SelectionItem struct {
	// Selected: If more than one items are selected for RADIO_BUTTON and
	// DROPDOWN, the first selected item is treated as sElected and the
	// after ones are all ignored.
	Selected bool `json:"selected,omitempty"`

	// Text: The text to be displayed.
	Text string `json:"text,omitempty"`

	// Value: The value associated with this item which will be sent back to
	// app scripts. Client should use as a form input value.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Selected") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Selected") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SelectionItem) MarshalJSON() ([]byte, error) {
	type NoMethod SelectionItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type SessionContext struct {
	// AuthTime: Time at which this activity's session was authenticated, in
	// seconds since the epoch.
	AuthTime int64 `json:"authTime,omitempty,string"`

	// DelegateUserId: Gaia ID of the authenticated user when delegate
	// access is active. In such sessions the main gaia ID is that of the
	// delegator, i.e. the account being accessed.
	DelegateUserId int64 `json:"delegateUserId,omitempty,string"`

	// Dusi: Device User Session ID, see go/dusi.
	Dusi string `json:"dusi,omitempty"`

	// ImapSessionContext: Imap session context for Bond/Gmail integration
	ImapSessionContext *ImapSessionContext `json:"imapSessionContext,omitempty"`

	// OauthLoginId: OAuth login ID.
	OauthLoginId int64 `json:"oauthLoginId,omitempty"`

	// OauthProjectId: The devconsole project ID of the developer who
	// authenticated with OAuth.
	OauthProjectId int64 `json:"oauthProjectId,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "AuthTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuthTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SessionContext) MarshalJSON() ([]byte, error) {
	type NoMethod SessionContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SessionEvent: A session event is something that happens to the
// streaming session in a conference.
type SessionEvent struct {
	// DeviceId: The initiator of the latest event of the streaming session.
	// It will be set for all user events (`type` is 100-199) and unset for
	// all server events(`type` is 200-299).
	DeviceId string `json:"deviceId,omitempty"`

	// Type: The type of event.
	//
	// Possible values:
	//   "EVENT_UNSPECIFIED" - This is never used.
	//   "STARTED_BY_USER" - Streaming session was started or is being
	// started by a user.
	//   "STOPPED_BY_USER" - Streaming session was stopped by a user.
	//   "CANCELLED_BY_USER" - Streaming session was cancelled by a user.
	//   "CANCELLED_INITIALIZATION_FAILED" - Streaming session was cancelled
	// by the server because of a failure during session initialization.
	//   "CANCELLED_INITIATOR_LEFT" - Streaming session was cancelled by the
	// server because the session initiator left the conference during
	// initialization. When the initiator leaves after the session is
	// started, no event is triggered.
	//   "ACTIVE_ABOUT_TO_STOP_TOO_LONG" - Streaming session is about to be
	// stopped by the server because the session is about to reach the
	// maximum duration.
	//   "STOPPED_TOO_LONG" - Streaming session was stopped because the
	// session reached the maximum duration.
	//   "STOPPED_ALL_DEVICES_LEFT" - Streaming session was stopped because
	// there were no devices left in the conference.
	//   "STOPPED_INTERNAL_FAILURES" - Streaming session was stopped because
	// of an internal error.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SessionEvent) MarshalJSON() ([]byte, error) {
	type NoMethod SessionEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SessionStateInfo: Information about the state of a (recording,
// broadcast, transcription...) session in a conference.
type SessionStateInfo struct {
	// AckInfo: Output only. The ack info of the session.
	AckInfo *AckInfo `json:"ackInfo,omitempty"`

	// LanguageConfig: Immutable. The language configuration used by this
	// session. When empty, captions will be disabled. It's a required field
	// for transcription sessions.
	LanguageConfig *LanguageConfig `json:"languageConfig,omitempty"`

	// LastActorDeviceId: Output only. The device id of the actor is set if
	// the current state is a result of a user action, is empty otherwise.
	LastActorDeviceId string `json:"lastActorDeviceId,omitempty"`

	// MaxEndTime: Output only. The max end time of the session, at this
	// time the session will be force stopped/terminated. Clients are
	// expected to use this timestamp to warn users about the force stop.
	MaxEndTime string `json:"maxEndTime,omitempty"`

	// SessionState: State of the session.
	//
	// Possible values:
	//   "SESSION_STATE_UNSPECIFIED" - Unspecified session state.
	//   "STARTING" - The session is starting.
	//   "ACTIVE" - The session is active/ongoing.
	//   "STOPPED" - The session has stopped.
	SessionState string `json:"sessionState,omitempty"`

	// SessionStopReason: Output only. The reason the session was
	// transitioned to STOPPED state.
	//
	// Possible values:
	//   "SESSION_STOP_REASON_UNSPECIFIED" - Session stop reason
	// unspecified.
	//   "USER_ACTION" - Stopped by user action.
	//   "STOPPED_INITIALIZATION_FAILED" - Stopped by the server because of
	// an initialization failure.
	//   "STOPPED_TOO_LONG" - Stopped because the session reached the
	// maximum duration.
	//   "STOPPED_ALL_DEVICES_LEFT" - Stopped because there were no devices
	// left in the conference.
	//   "STOPPED_INTERNAL_FAILURES" - Stopped because of an internal error.
	//   "STOPPED_YOU_TUBE_LIVE_EVENT_ENDED" - Stopped because the broadcast
	// event ended on YouTube.
	SessionStopReason string `json:"sessionStopReason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AckInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AckInfo") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SessionStateInfo) MarshalJSON() ([]byte, error) {
	type NoMethod SessionStateInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Settings: Settings of a meeting space that can be edited by users
// with corresponding manage privilege. These settings are always
// populated in responses.
type Settings struct {
	// AccessLock: The access lock of the meeting space that lets hosts
	// control who can join the meeting.
	AccessLock bool `json:"accessLock,omitempty"`

	// AccessType: The access type of the meeting space.
	//
	// Possible values:
	//   "ACCESS_TYPE_UNSPECIFIED" - Default value. This value is unused.
	//   "ACCESS_TYPE_OPEN" - Anyone with meeting join information (url,
	// phone access...) can join, no knocking required. (Subject to
	// organization policies)
	//   "ACCESS_TYPE_TRUSTED" - Members of the Host's organization, invited
	// external users, and dial-in users can join without knocking, everyone
	// else must knock. (Subject to organization policies)
	//   "ACCESS_TYPE_RESTRICTED" - Only participants invited by a host can
	// automatically join, everyone else must knock and be admitted.
	// (Subject to organization policies) Participants cannot dial out from
	// the meeting. And only hosts can accept knocks.
	AccessType string `json:"accessType,omitempty"`

	// AllowJoiningBeforeHost: Whether users can join before host in the
	// conferences of this meeting space.
	AllowJoiningBeforeHost bool `json:"allowJoiningBeforeHost,omitempty"`

	// AttendanceReportEnabled: Whether attendance report is enabled for the
	// meeting space.
	AttendanceReportEnabled bool `json:"attendanceReportEnabled,omitempty"`

	// ChatLock: The chat lock of the meeting space that lets owner control
	// whether the participants can send chat messages.
	ChatLock bool `json:"chatLock,omitempty"`

	// CohostArtifactSharingEnabled: Whether meeting artifacts will be
	// shared with cohosts.
	CohostArtifactSharingEnabled bool `json:"cohostArtifactSharingEnabled,omitempty"`

	// CseEnabled: Whether Client-side Encryption is enabled for the meeting
	// space.
	CseEnabled bool `json:"cseEnabled,omitempty"`

	// DefaultAsViewer: Whether the default role is viewer or not.
	DefaultAsViewer bool `json:"defaultAsViewer,omitempty"`

	// ModerationEnabled: Indicates whether the meeting space is moderated.
	ModerationEnabled bool `json:"moderationEnabled,omitempty"`

	// PresentLock: The present lock of the meeting space that lets owner
	// control whether the participants can present their screen.
	PresentLock bool `json:"presentLock,omitempty"`

	// ReactionsLock: The reactions lock of the meeting space that lets
	// owner control whether the participants can send reactions.
	ReactionsLock bool `json:"reactionsLock,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessLock") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessLock") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Settings) MarshalJSON() ([]byte, error) {
	type NoMethod Settings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ShareScope struct {
	// Domain: If scope is DOMAIN, this field contains the dasher domain,
	// for example "google.com".
	Domain string `json:"domain,omitempty"`

	// Scope: The scope to which the content was shared.
	//
	// Possible values:
	//   "UNKNOWN"
	//   "PRIVATE" - Only the author can view the post.
	//   "LIMITED" - Viewable only by a set of people.
	//   "EXTENDED" - Viewable by extended circles.
	//   "DASHER_DOMAIN"
	//   "PUBLIC"
	Scope string `json:"scope,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Domain") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Domain") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ShareScope) MarshalJSON() ([]byte, error) {
	type NoMethod ShareScope
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type SheetsClientActionMarkup struct {
	CustomFunctionReturnValueMarkup *CustomFunctionReturnValueMarkup `json:"customFunctionReturnValueMarkup,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CustomFunctionReturnValueMarkup") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "CustomFunctionReturnValueMarkup") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SheetsClientActionMarkup) MarshalJSON() ([]byte, error) {
	type NoMethod SheetsClientActionMarkup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SigningKeyPossessorProto: Represents a principal who possesses a
// signing key corresponding to the verification key or keyset described
// here.
type SigningKeyPossessorProto struct {
	// KeymasterKeyType: This value must be from the KeyMetadata.Type enum
	// in keymaster.proto.
	KeymasterKeyType int64 `json:"keymasterKeyType,omitempty"`

	// SerializedVerificationKey: The actual verification key bytes
	// corresponding to the above type.
	SerializedVerificationKey string `json:"serializedVerificationKey,omitempty"`

	// SerializedVerificationKeyset: The binary serialized Keymaster
	// SerializedReader of a public keyset. The keyset must contain exactly
	// one key. N.B.: If this field is populated,
	// serialized_verification_key should be set to the empty string and
	// keymaster_key_type should be set to zero.
	SerializedVerificationKeyset string `json:"serializedVerificationKeyset,omitempty"`

	// ForceSendFields is a list of field names (e.g. "KeymasterKeyType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "KeymasterKeyType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SigningKeyPossessorProto) MarshalJSON() ([]byte, error) {
	type NoMethod SigningKeyPossessorProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SimpleSecretHolderProto: Represents a principal which possesses a
// particular, presumably secret, string. Useful for things like "auth
// keys," used for anonymous sharing. Since representing this principal
// with the actual secret included reveals the secret, it's best if the
// requisite condition is enforced in some other way, for example via
// Keystore wrapping attributes (Keystore will unwrap only if the
// specified secret, aka "attribute", is presented). All that's stored
// here is an identifying label.
type SimpleSecretHolderProto struct {
	// Label: A descriptive label to help identify a relevant ACL entry or
	// otherwise disambiguate this instance.
	Label *SimpleSecretLabelProto `json:"label,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Label") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Label") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SimpleSecretHolderProto) MarshalJSON() ([]byte, error) {
	type NoMethod SimpleSecretHolderProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SimpleSecretLabelProto: SimpleSecretProto (in authenticator.proto)
// and SimpleSecretHolderProto (below) share the notion of a "label",
// which identifies a particular secret without (hopefully) revealing
// the secret. Note that a SimpleSecretLabel only disambiguates between
// secrets used to get access to some particular object. Two different
// secrets that apply to two different objects could have the same
// label. For example, in the common sharing model, each object has no
// more than one "auth key". Therefore, the label for an auth key simply
// has type = AUTH_KEY with no additional information. In theory, we
// could add some sort of resource ID to SimpleSecretLabel to make it
// more explicit. However, in practice, this is never really needed. A
// SimpleSecret for one object is never used to authorize a request on
// some other object, so there is no ambiguity. Also, since
// SimpleSecrets must obviously be unguessable, there is no risk that a
// SimpleSecret intended for one object will accidentally grant access
// to another.
type SimpleSecretLabelProto struct {
	// CapabilityId: ***DEPRECATED (3-Oct-2011) *** This field should be
	// deleted when code stops using CAP_TOKEN labels. Used when type =
	// CAP_TOKEN. When a CAP_TOKEN label appears in a SimpleSecretHolder
	// Principal, |capability_id| must be filled in to identify one of the
	// capabilities on the ACL. When a CAP_TOKEN label appears in a
	// SimpleSecret Authenticator, it is NOT necessary to fill in
	// |capability_id| -- ACL Service will find the ID by searching all
	// capabilities on the ACL for one associated with the token given by
	// the SimpleSecret's secret data. If |capability_id| is specified,
	// though, then the Authenticator will only be accepted if it actually
	// matches that particular token ID.
	CapabilityId int64 `json:"capabilityId,omitempty"`

	// GenericLabel: Used when type = GENERIC_SECRET
	GenericLabel string `json:"genericLabel,omitempty"`

	// InviteId: Used when type == INVITE.
	InviteId int64 `json:"inviteId,omitempty,string"`

	// Type: This is optional because required enums cannot be extended.
	//
	// Possible values:
	//   "INVALID" - Used as a default value.
	//   "AUTH_KEY" - The singleton auth key for a common-sharing ACL. No
	// other fields of SimpleSecretLabelProto need to be filled in, since
	// there is only one of these per ACL. The corresponding secret is the
	// auth key encoded in 64-bit big-endian.
	//   "INVITE" - A common-sharing invite token. |invite_id| (below) must
	// be set to identify the invite. The corresponding secret is the
	// SecretMaterial, as defined by InviteToken.SecretMaterial in
	// acl.proto, encoded in 64-bit big-endian. If there is no
	// SecretMaterial, the secret should be omitted; in this case the invite
	// ID itself is the secret, which is less secure.
	//   "GENERIC_SECRET" - A generic secret value. Do not use this if any
	// more specific type is appropriate.
	//   "CAP_TOKEN" - ***DEPRECATED (3-Oct-2011)*** Use the new
	// CapTokenProto and CapTokenHolderProto instead. A capability token.
	// The corresponding secret is an arbitrary-length random byte string
	// (recommended: 128 bits). |capability_id| may be filled in (see
	// below). See CapTokenMetadata in acl.proto.
	//   "REKE" - Identifies a principal that can perform a successful REKE
	// handshake. The holder is not authenticated by presenting a
	// SimpleSecretProto, but rather by knowing either the REKE resumption
	// ticket secret or the private key corresponding to a public key
	// specified outside the PrincipalProto. For more information, see:
	// http://goto.google.com/loas2cert
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CapabilityId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CapabilityId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SimpleSecretLabelProto) MarshalJSON() ([]byte, error) {
	type NoMethod SimpleSecretLabelProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SlashCommandMetadata: Annotation metadata for slash commands (/).
type SlashCommandMetadata struct {
	// ArgumentsHint: Hint string for the arguments expected by the slash
	// command.
	ArgumentsHint string `json:"argumentsHint,omitempty"`

	// CommandId: Unique id for the slash command.
	CommandId int64 `json:"commandId,omitempty,string"`

	// CommandName: Name of the slash command.
	CommandName string `json:"commandName,omitempty"`

	// Id: ID of the bot which owns the slash command.
	Id *UserId `json:"id,omitempty"`

	// TriggersDialog: Whether or not this slash command should trigger a
	// dialog.
	TriggersDialog bool `json:"triggersDialog,omitempty"`

	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value for the enum. DO NOT USE.
	//   "ADD" - If a bot is added by a Slash Command, it means the bot was
	// invoked by the user but hasn't yet been added to the group. Attaching
	// an ADD annotation both add and invoke the bot.
	//   "INVOKE"
	//   "FAILED_TO_ADD" - Server-generated slash command metadata, for
	// clients to strikethrough.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ArgumentsHint") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ArgumentsHint") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SlashCommandMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod SlashCommandMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Snippet: Snippet of the search result, which summarizes the content
// of the resulting page.
type Snippet struct {
	// MatchRanges: The matched ranges in the snippet.
	MatchRanges []*MatchRange `json:"matchRanges,omitempty"`

	// Snippet: The snippet of the document. The snippet of the document.
	// May contain escaped HTML character that should be unescaped prior to
	// rendering.
	Snippet string `json:"snippet,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MatchRanges") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MatchRanges") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Snippet) MarshalJSON() ([]byte, error) {
	type NoMethod Snippet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SocialCommonAttachmentAttachment: An Attachment represents a linked
// entity associated with a piece of social content. This may be a
// 1st-party or 3rd-party entity. In the Papyrus context, an Attachment
// is part of a Cent, and sits alongside the main content of the cent,
// which is represented as a sequence of Segments. Right now an
// Attachment is just a wrapper around an Embed, but we provide the
// extra layer of abstraction since, as Embeds move to separate storage
// in Briefcase, we may want to add additional fields that are not part
// of the Embed proper, but that (for example) relate to the usage of
// the linked content within the particular post/cent.
type SocialCommonAttachmentAttachment struct {
	// EmbedItem: An embed represents an external entity. See go/es-embeds.
	EmbedItem *EmbedClientItem `json:"embedItem,omitempty"`

	// Id: An id to uniquely identify an attachment when several attachments
	// are in a collection.
	Id string `json:"id,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EmbedItem") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EmbedItem") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SocialCommonAttachmentAttachment) MarshalJSON() ([]byte, error) {
	type NoMethod SocialCommonAttachmentAttachment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SocialGraphNodeProto: Represents a user pseudonym. Pseudonyms are
// linked accounts on Google and third-party services (e.g. YouTube or
// Twitter) and are described by a Social Graph Node.
type SocialGraphNodeProto struct {
	// SgnDomain: The fields from
	// ccc/socialgraph/socialgraphnode.proto:SgnNode that uniquely identify
	// a social graph node. The 'ident' field is not included here because
	// its value can be changed.
	SgnDomain string `json:"sgnDomain,omitempty"`

	SgnPk string `json:"sgnPk,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SgnDomain") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SgnDomain") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SocialGraphNodeProto) MarshalJSON() ([]byte, error) {
	type NoMethod SocialGraphNodeProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type SortOptions struct {
	// OperatorName: The name of the operator corresponding to the field to
	// sort on. The corresponding property must be marked as sortable.
	OperatorName string `json:"operatorName,omitempty"`

	// SortOrder: Ascending is the default sort order
	//
	// Possible values:
	//   "ASCENDING"
	//   "DESCENDING"
	SortOrder string `json:"sortOrder,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OperatorName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OperatorName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SortOptions) MarshalJSON() ([]byte, error) {
	type NoMethod SortOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Source: Defines sources for the suggest/search APIs.
type Source struct {
	// Name: Source name for content indexed by the Indexing API.
	Name string `json:"name,omitempty"`

	// PredefinedSource: Predefined content source for Google Apps.
	//
	// Possible values:
	//   "NONE"
	//   "QUERY_HISTORY" - Suggests queries issued by the user in the past.
	// Only valid when used with the suggest API. Ignored when used in the
	// query API.
	//   "PERSON" - Suggests people in the organization. Only valid when
	// used with the suggest API. Results in an error when used in the query
	// API.
	//   "GOOGLE_DRIVE"
	//   "GOOGLE_GMAIL"
	//   "GOOGLE_SITES"
	//   "GOOGLE_GROUPS"
	//   "GOOGLE_CALENDAR"
	//   "GOOGLE_KEEP"
	PredefinedSource string `json:"predefinedSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Source) MarshalJSON() ([]byte, error) {
	type NoMethod Source
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SourceConfig: Configurations for a source while processing a Search
// or Suggest request.
type SourceConfig struct {
	// CrowdingConfig: The crowding configuration for the source.
	CrowdingConfig *SourceCrowdingConfig `json:"crowdingConfig,omitempty"`

	// ScoringConfig: The scoring configuration for the source.
	ScoringConfig *SourceScoringConfig `json:"scoringConfig,omitempty"`

	// Source: The source for which this configuration is to be used.
	Source *Source `json:"source,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CrowdingConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CrowdingConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SourceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SourceConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SourceCrowdingConfig: Set search results crowding limits. Crowding is
// a situation in which multiple results from the same source or host
// "crowd out" other results, diminishing the quality of search for
// users. To foster better search quality and source diversity in search
// results, you can set a condition to reduce repetitive results by
// source.
type SourceCrowdingConfig struct {
	// NumResults: Maximum number of results allowed from a datasource in a
	// result page as long as results from other sources are not exhausted.
	// Value specified must not be negative. A default value is used if this
	// value is equal to 0. To disable crowding, set the value greater than
	// 100.
	NumResults int64 `json:"numResults,omitempty"`

	// NumSuggestions: Maximum number of suggestions allowed from a source.
	// No limits will be set on results if this value is less than or equal
	// to 0.
	NumSuggestions int64 `json:"numSuggestions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NumResults") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NumResults") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SourceCrowdingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SourceCrowdingConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SourceResultCount: Per source result count information.
type SourceResultCount struct {
	// HasMoreResults: Whether there are more search results for this
	// source.
	HasMoreResults bool `json:"hasMoreResults,omitempty"`

	// ResultCountEstimate: The estimated result count for this source.
	ResultCountEstimate int64 `json:"resultCountEstimate,omitempty,string"`

	// ResultCountExact: The exact result count for this source.
	ResultCountExact int64 `json:"resultCountExact,omitempty,string"`

	// Source: The source the result count information is associated with.
	Source *Source `json:"source,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HasMoreResults") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HasMoreResults") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SourceResultCount) MarshalJSON() ([]byte, error) {
	type NoMethod SourceResultCount
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SourceScoringConfig: Set the scoring configuration. This allows
// modifying the ranking of results for a source.
type SourceScoringConfig struct {
	// SourceImportance: Importance of the source.
	//
	// Possible values:
	//   "DEFAULT"
	//   "LOW"
	//   "HIGH"
	SourceImportance string `json:"sourceImportance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SourceImportance") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SourceImportance") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SourceScoringConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SourceScoringConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SpaceId: Primary key for Space resource.
type SpaceId struct {
	// SpaceId: Unique, immutable ID of the Space
	SpaceId string `json:"spaceId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SpaceId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SpaceId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SpaceId) MarshalJSON() ([]byte, error) {
	type NoMethod SpaceId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type SpellResult struct {
	// SuggestedQuery: The suggested spelling of the query.
	SuggestedQuery string `json:"suggestedQuery,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SuggestedQuery") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SuggestedQuery") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SpellResult) MarshalJSON() ([]byte, error) {
	type NoMethod SpellResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SquareProto: Represents the set of members (of a given type) in a
// Google+ Square (see http://go/squares). A Square with default
// member_type is currently (1/2012) identical to the GaiaGroup with the
// same ID, but that is expected to change soon (see
// http://go/superglue). Support for this principal type is currently
// (1/2012) incomplete -- e.g., Keystore does not support it yet (see
// b/5703421).
type SquareProto struct {
	// MemberType: The type of Square members to consider, e.g. "all
	// members" vs. "owners" vs. "admins". These are defined by
	// legacy_relation_id values in
	// social.graph.storage.EdgeTypeEnum.EdgeType enum options in
	// social/graph/storage/proto/id.proto. See square.pb (defined in
	// production/config/cdd/socialgraph/mixer_config/prod/node_type_config)
	// for all valid edge types associated with square. Currently required.
	MemberType int64 `json:"memberType,omitempty"`

	// SquareId: Currently required.
	SquareId int64 `json:"squareId,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "MemberType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MemberType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SquareProto) MarshalJSON() ([]byte, error) {
	type NoMethod SquareProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// StartUploadItemRequest: Start upload file request.
type StartUploadItemRequest struct {
	// ConnectorName: The name of connector making this call. Format:
	// datasources/{source_id}/connectors/{ID}
	ConnectorName string `json:"connectorName,omitempty"`

	// DebugOptions: Common debug options.
	DebugOptions *DebugOptions `json:"debugOptions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConnectorName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConnectorName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *StartUploadItemRequest) MarshalJSON() ([]byte, error) {
	type NoMethod StartUploadItemRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs
// and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type StoredParticipantId struct {
	GaiaId int64 `json:"gaiaId,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "GaiaId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GaiaId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *StoredParticipantId) MarshalJSON() ([]byte, error) {
	type NoMethod StoredParticipantId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// StreamViewerStats: Information about viewers of the stream.
type StreamViewerStats struct {
	// EstimatedViewerCount: The estimate of the current viewer count.
	EstimatedViewerCount int64 `json:"estimatedViewerCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "EstimatedViewerCount") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EstimatedViewerCount") to
	// include in API requests with the JSON null value. By def