// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package osconfig aliases all exported identifiers in package
// "cloud.google.com/go/osconfig/apiv1alpha/osconfigpb".
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package osconfig

import (
	src "cloud.google.com/go/osconfig/apiv1alpha/osconfigpb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
const (
	CVSSv3_ATTACK_COMPLEXITY_HIGH                                                                                                          = src.CVSSv3_ATTACK_COMPLEXITY_HIGH
	CVSSv3_ATTACK_COMPLEXITY_LOW                                                                                                           = src.CVSSv3_ATTACK_COMPLEXITY_LOW
	CVSSv3_ATTACK_COMPLEXITY_UNSPECIFIED                                                                                                   = src.CVSSv3_ATTACK_COMPLEXITY_UNSPECIFIED
	CVSSv3_ATTACK_VECTOR_ADJACENT                                                                                                          = src.CVSSv3_ATTACK_VECTOR_ADJACENT
	CVSSv3_ATTACK_VECTOR_LOCAL                                                                                                             = src.CVSSv3_ATTACK_VECTOR_LOCAL
	CVSSv3_ATTACK_VECTOR_NETWORK                                                                                                           = src.CVSSv3_ATTACK_VECTOR_NETWORK
	CVSSv3_ATTACK_VECTOR_PHYSICAL                                                                                                          = src.CVSSv3_ATTACK_VECTOR_PHYSICAL
	CVSSv3_ATTACK_VECTOR_UNSPECIFIED                                                                                                       = src.CVSSv3_ATTACK_VECTOR_UNSPECIFIED
	CVSSv3_IMPACT_HIGH                                                                                                                     = src.CVSSv3_IMPACT_HIGH
	CVSSv3_IMPACT_LOW                                                                                                                      = src.CVSSv3_IMPACT_LOW
	CVSSv3_IMPACT_NONE                                                                                                                     = src.CVSSv3_IMPACT_NONE
	CVSSv3_IMPACT_UNSPECIFIED                                                                                                              = src.CVSSv3_IMPACT_UNSPECIFIED
	CVSSv3_PRIVILEGES_REQUIRED_HIGH                                                                                                        = src.CVSSv3_PRIVILEGES_REQUIRED_HIGH
	CVSSv3_PRIVILEGES_REQUIRED_LOW                                                                                                         = src.CVSSv3_PRIVILEGES_REQUIRED_LOW
	CVSSv3_PRIVILEGES_REQUIRED_NONE                                                                                                        = src.CVSSv3_PRIVILEGES_REQUIRED_NONE
	CVSSv3_PRIVILEGES_REQUIRED_UNSPECIFIED                                                                                                 = src.CVSSv3_PRIVILEGES_REQUIRED_UNSPECIFIED
	CVSSv3_SCOPE_CHANGED                                                                                                                   = src.CVSSv3_SCOPE_CHANGED
	CVSSv3_SCOPE_UNCHANGED                                                                                                                 = src.CVSSv3_SCOPE_UNCHANGED
	CVSSv3_SCOPE_UNSPECIFIED                                                                                                               = src.CVSSv3_SCOPE_UNSPECIFIED
	CVSSv3_USER_INTERACTION_NONE                                                                                                           = src.CVSSv3_USER_INTERACTION_NONE
	CVSSv3_USER_INTERACTION_REQUIRED                                                                                                       = src.CVSSv3_USER_INTERACTION_REQUIRED
	CVSSv3_USER_INTERACTION_UNSPECIFIED                                                                                                    = src.CVSSv3_USER_INTERACTION_UNSPECIFIED
	InventoryView_BASIC                                                                                                                    = src.InventoryView_BASIC
	InventoryView_FULL                                                                                                                     = src.InventoryView_FULL
	InventoryView_INVENTORY_VIEW_UNSPECIFIED                                                                                               = src.InventoryView_INVENTORY_VIEW_UNSPECIFIED
	Inventory_Item_AVAILABLE_PACKAGE                                                                                                       = src.Inventory_Item_AVAILABLE_PACKAGE
	Inventory_Item_INSTALLED_PACKAGE                                                                                                       = src.Inventory_Item_INSTALLED_PACKAGE
	Inventory_Item_INVENTORY_REPORT                                                                                                        = src.Inventory_Item_INVENTORY_REPORT
	Inventory_Item_ORIGIN_TYPE_UNSPECIFIED                                                                                                 = src.Inventory_Item_ORIGIN_TYPE_UNSPECIFIED
	Inventory_Item_TYPE_UNSPECIFIED                                                                                                        = src.Inventory_Item_TYPE_UNSPECIFIED
	OSPolicyAssignmentOperationMetadata_API_METHOD_UNSPECIFIED                                                                             = src.OSPolicyAssignmentOperationMetadata_API_METHOD_UNSPECIFIED
	OSPolicyAssignmentOperationMetadata_CANCELLED                                                                                          = src.OSPolicyAssignmentOperationMetadata_CANCELLED
	OSPolicyAssignmentOperationMetadata_CANCELLING                                                                                         = src.OSPolicyAssignmentOperationMetadata_CANCELLING
	OSPolicyAssignmentOperationMetadata_CREATE                                                                                             = src.OSPolicyAssignmentOperationMetadata_CREATE
	OSPolicyAssignmentOperationMetadata_DELETE                                                                                             = src.OSPolicyAssignmentOperationMetadata_DELETE
	OSPolicyAssignmentOperationMetadata_IN_PROGRESS                                                                                        = src.OSPolicyAssignmentOperationMetadata_IN_PROGRESS
	OSPolicyAssignmentOperationMetadata_ROLLOUT_STATE_UNSPECIFIED                                                                          = src.OSPolicyAssignmentOperationMetadata_ROLLOUT_STATE_UNSPECIFIED
	OSPolicyAssignmentOperationMetadata_SUCCEEDED                                                                                          = src.OSPolicyAssignmentOperationMetadata_SUCCEEDED
	OSPolicyAssignmentOperationMetadata_UPDATE                                                                                             = src.OSPolicyAssignmentOperationMetadata_UPDATE
	OSPolicyAssignmentReport_OSPolicyCompliance_COMPLIANT                                                                                  = src.OSPolicyAssignmentReport_OSPolicyCompliance_COMPLIANT
	OSPolicyAssignmentReport_OSPolicyCompliance_NON_COMPLIANT                                                                              = src.OSPolicyAssignmentReport_OSPolicyCompliance_NON_COMPLIANT
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_COMPLIANT                                                       = src.OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_COMPLIANT
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_NON_COMPLIANT                                                   = src.OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_NON_COMPLIANT
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_DESIRED_STATE_CHECK                  = src.OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_DESIRED_STATE_CHECK
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_DESIRED_STATE_CHECK_POST_ENFORCEMENT = src.OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_DESIRED_STATE_CHECK_POST_ENFORCEMENT
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_DESIRED_STATE_ENFORCEMENT            = src.OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_DESIRED_STATE_ENFORCEMENT
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_TYPE_UNSPECIFIED                     = src.OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_TYPE_UNSPECIFIED
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_VALIDATION                           = src.OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_VALIDATION
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_UNKNOWN                                                         = src.OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_UNKNOWN
	OSPolicyAssignmentReport_OSPolicyCompliance_UNKNOWN                                                                                    = src.OSPolicyAssignmentReport_OSPolicyCompliance_UNKNOWN
	OSPolicyAssignment_CANCELLED                                                                                                           = src.OSPolicyAssignment_CANCELLED
	OSPolicyAssignment_CANCELLING                                                                                                          = src.OSPolicyAssignment_CANCELLING
	OSPolicyAssignment_IN_PROGRESS                                                                                                         = src.OSPolicyAssignment_IN_PROGRESS
	OSPolicyAssignment_ROLLOUT_STATE_UNSPECIFIED                                                                                           = src.OSPolicyAssignment_ROLLOUT_STATE_UNSPECIFIED
	OSPolicyAssignment_SUCCEEDED                                                                                                           = src.OSPolicyAssignment_SUCCEEDED
	OSPolicyComplianceState_COMPLIANT                                                                                                      = src.OSPolicyComplianceState_COMPLIANT
	OSPolicyComplianceState_NON_COMPLIANT                                                                                                  = src.OSPolicyComplianceState_NON_COMPLIANT
	OSPolicyComplianceState_NO_OS_POLICIES_APPLICABLE                                                                                      = src.OSPolicyComplianceState_NO_OS_POLICIES_APPLICABLE
	OSPolicyComplianceState_OS_POLICY_COMPLIANCE_STATE_UNSPECIFIED                                                                         = src.OSPolicyComplianceState_OS_POLICY_COMPLIANCE_STATE_UNSPECIFIED
	OSPolicyComplianceState_UNKNOWN                                                                                                        = src.OSPolicyComplianceState_UNKNOWN
	OSPolicyResourceConfigStep_DESIRED_STATE_CHECK                                                                                         = src.OSPolicyResourceConfigStep_DESIRED_STATE_CHECK
	OSPolicyResourceConfigStep_DESIRED_STATE_CHECK_POST_ENFORCEMENT                                                                        = src.OSPolicyResourceConfigStep_DESIRED_STATE_CHECK_POST_ENFORCEMENT
	OSPolicyResourceConfigStep_DESIRED_STATE_ENFORCEMENT                                                                                   = src.OSPolicyResourceConfigStep_DESIRED_STATE_ENFORCEMENT
	OSPolicyResourceConfigStep_FAILED                                                                                                      = src.OSPolicyResourceConfigStep_FAILED
	OSPolicyResourceConfigStep_OUTCOME_UNSPECIFIED                                                                                         = src.OSPolicyResourceConfigStep_OUTCOME_UNSPECIFIED
	OSPolicyResourceConfigStep_SUCCEEDED                                                                                                   = src.OSPolicyResourceConfigStep_SUCCEEDED
	OSPolicyResourceConfigStep_TYPE_UNSPECIFIED                                                                                            = src.OSPolicyResourceConfigStep_TYPE_UNSPECIFIED
	OSPolicyResourceConfigStep_VALIDATION                                                                                                  = src.OSPolicyResourceConfigStep_VALIDATION
	OSPolicy_ENFORCEMENT                                                                                                                   = src.OSPolicy_ENFORCEMENT
	OSPolicy_MODE_UNSPECIFIED                                                                                                              = src.OSPolicy_MODE_UNSPECIFIED
	OSPolicy_Resource_ExecResource_Exec_INTERPRETER_UNSPECIFIED                                                                            = src.OSPolicy_Resource_ExecResource_Exec_INTERPRETER_UNSPECIFIED
	OSPolicy_Resource_ExecResource_Exec_NONE                                                                                               = src.OSPolicy_Resource_ExecResource_Exec_NONE
	OSPolicy_Resource_ExecResource_Exec_POWERSHELL                                                                                         = src.OSPolicy_Resource_ExecResource_Exec_POWERSHELL
	OSPolicy_Resource_ExecResource_Exec_SHELL                                                                                              = src.OSPolicy_Resource_ExecResource_Exec_SHELL
	OSPolicy_Resource_FileResource_ABSENT                                                                                                  = src.OSPolicy_Resource_FileResource_ABSENT
	OSPolicy_Resource_FileResource_CONTENTS_MATCH                                                                                          = src.OSPolicy_Resource_FileResource_CONTENTS_MATCH
	OSPolicy_Resource_FileResource_DESIRED_STATE_UNSPECIFIED                                                                               = src.OSPolicy_Resource_FileResource_DESIRED_STATE_UNSPECIFIED
	OSPolicy_Resource_FileResource_PRESENT                                                                                                 = src.OSPolicy_Resource_FileResource_PRESENT
	OSPolicy_Resource_PackageResource_DESIRED_STATE_UNSPECIFIED                                                                            = src.OSPolicy_Resource_PackageResource_DESIRED_STATE_UNSPECIFIED
	OSPolicy_Resource_PackageResource_INSTALLED                                                                                            = src.OSPolicy_Resource_PackageResource_INSTALLED
	OSPolicy_Resource_PackageResource_REMOVED                                                                                              = src.OSPolicy_Resource_PackageResource_REMOVED
	OSPolicy_Resource_RepositoryResource_AptRepository_ARCHIVE_TYPE_UNSPECIFIED                                                            = src.OSPolicy_Resource_RepositoryResource_AptRepository_ARCHIVE_TYPE_UNSPECIFIED
	OSPolicy_Resource_RepositoryResource_AptRepository_DEB                                                                                 = src.OSPolicy_Resource_RepositoryResource_AptRepository_DEB
	OSPolicy_Resource_RepositoryResource_AptRepository_DEB_SRC                                                                             = src.OSPolicy_Resource_RepositoryResource_AptRepository_DEB_SRC
	OSPolicy_VALIDATION                                                                                                                    = src.OSPolicy_VALIDATION
)

// Deprecated: Please use vars in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
var (
	CVSSv3_AttackComplexity_name                                                                                 = src.CVSSv3_AttackComplexity_name
	CVSSv3_AttackComplexity_value                                                                                = src.CVSSv3_AttackComplexity_value
	CVSSv3_AttackVector_name                                                                                     = src.CVSSv3_AttackVector_name
	CVSSv3_AttackVector_value                                                                                    = src.CVSSv3_AttackVector_value
	CVSSv3_Impact_name                                                                                           = src.CVSSv3_Impact_name
	CVSSv3_Impact_value                                                                                          = src.CVSSv3_Impact_value
	CVSSv3_PrivilegesRequired_name                                                                               = src.CVSSv3_PrivilegesRequired_name
	CVSSv3_PrivilegesRequired_value                                                                              = src.CVSSv3_PrivilegesRequired_value
	CVSSv3_Scope_name                                                                                            = src.CVSSv3_Scope_name
	CVSSv3_Scope_value                                                                                           = src.CVSSv3_Scope_value
	CVSSv3_UserInteraction_name                                                                                  = src.CVSSv3_UserInteraction_name
	CVSSv3_UserInteraction_value                                                                                 = src.CVSSv3_UserInteraction_value
	File_google_cloud_osconfig_v1alpha_config_common_proto                                                       = src.File_google_cloud_osconfig_v1alpha_config_common_proto
	File_google_cloud_osconfig_v1alpha_instance_os_policies_compliance_proto                                     = src.File_google_cloud_osconfig_v1alpha_instance_os_policies_compliance_proto
	File_google_cloud_osconfig_v1alpha_inventory_proto                                                           = src.File_google_cloud_osconfig_v1alpha_inventory_proto
	File_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto                                        = src.File_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto
	File_google_cloud_osconfig_v1alpha_os_policy_assignments_proto                                               = src.File_google_cloud_osconfig_v1alpha_os_policy_assignments_proto
	File_google_cloud_osconfig_v1alpha_os_policy_proto                                                           = src.File_google_cloud_osconfig_v1alpha_os_policy_proto
	File_google_cloud_osconfig_v1alpha_osconfig_common_proto                                                     = src.File_google_cloud_osconfig_v1alpha_osconfig_common_proto
	File_google_cloud_osconfig_v1alpha_osconfig_zonal_service_proto                                              = src.File_google_cloud_osconfig_v1alpha_osconfig_zonal_service_proto
	File_google_cloud_osconfig_v1alpha_vulnerability_proto                                                       = src.File_google_cloud_osconfig_v1alpha_vulnerability_proto
	InventoryView_name                                                                                           = src.InventoryView_name
	InventoryView_value                                                                                          = src.InventoryView_value
	Inventory_Item_OriginType_name                                                                               = src.Inventory_Item_OriginType_name
	Inventory_Item_OriginType_value                                                                              = src.Inventory_Item_OriginType_value
	Inventory_Item_Type_name                                                                                     = src.Inventory_Item_Type_name
	Inventory_Item_Type_value                                                                                    = src.Inventory_Item_Type_value
	OSPolicyAssignmentOperationMetadata_APIMethod_name                                                           = src.OSPolicyAssignmentOperationMetadata_APIMethod_name
	OSPolicyAssignmentOperationMetadata_APIMethod_value                                                          = src.OSPolicyAssignmentOperationMetadata_APIMethod_value
	OSPolicyAssignmentOperationMetadata_RolloutState_name                                                        = src.OSPolicyAssignmentOperationMetadata_RolloutState_name
	OSPolicyAssignmentOperationMetadata_RolloutState_value                                                       = src.OSPolicyAssignmentOperationMetadata_RolloutState_value
	OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState_name                                             = src.OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState_name
	OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState_value                                            = src.OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState_value
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState_name                  = src.OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState_name
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState_value                 = src.OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState_value
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type_name  = src.OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type_name
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type_value = src.OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type_value
	OSPolicyAssignment_RolloutState_name                                                                         = src.OSPolicyAssignment_RolloutState_name
	OSPolicyAssignment_RolloutState_value                                                                        = src.OSPolicyAssignment_RolloutState_value
	OSPolicyComplianceState_name                                                                                 = src.OSPolicyComplianceState_name
	OSPolicyComplianceState_value                                                                                = src.OSPolicyComplianceState_value
	OSPolicyResourceConfigStep_Outcome_name                                                                      = src.OSPolicyResourceConfigStep_Outcome_name
	OSPolicyResourceConfigStep_Outcome_value                                                                     = src.OSPolicyResourceConfigStep_Outcome_value
	OSPolicyResourceConfigStep_Type_name                                                                         = src.OSPolicyResourceConfigStep_Type_name
	OSPolicyResourceConfigStep_Type_value                                                                        = src.OSPolicyResourceConfigStep_Type_value
	OSPolicy_Mode_name                                                                                           = src.OSPolicy_Mode_name
	OSPolicy_Mode_value                                                                                          = src.OSPolicy_Mode_value
	OSPolicy_Resource_ExecResource_Exec_Interpreter_name                                                         = src.OSPolicy_Resource_ExecResource_Exec_Interpreter_name
	OSPolicy_Resource_ExecResource_Exec_Interpreter_value                                                        = src.OSPolicy_Resource_ExecResource_Exec_Interpreter_value
	OSPolicy_Resource_FileResource_DesiredState_name                                                             = src.OSPolicy_Resource_FileResource_DesiredState_name
	OSPolicy_Resource_FileResource_DesiredState_value                                                            = src.OSPolicy_Resource_FileResource_DesiredState_value
	OSPolicy_Resource_PackageResource_DesiredState_name                                                          = src.OSPolicy_Resource_PackageResource_DesiredState_name
	OSPolicy_Resource_PackageResource_DesiredState_value                                                         = src.OSPolicy_Resource_PackageResource_DesiredState_value
	OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType_name                                          = src.OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType_name
	OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType_value                                         = src.OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType_value
)

// Common Vulnerability Scoring System version 3. For details, see
// https://www.first.org/cvss/specification-document
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type CVSSv3 = src.CVSSv3

// This metric describes the conditions beyond the attacker's control that
// must exist in order to exploit the vulnerability.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type CVSSv3_AttackComplexity = src.CVSSv3_AttackComplexity

// This metric reflects the context by which vulnerability exploitation is
// possible.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type CVSSv3_AttackVector = src.CVSSv3_AttackVector

// The Impact metrics capture the effects of a successfully exploited
// vulnerability on the component that suffers the worst outcome that is most
// directly and predictably associated with the attack.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type CVSSv3_Impact = src.CVSSv3_Impact

// This metric describes the level of privileges an attacker must possess
// before successfully exploiting the vulnerability.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type CVSSv3_PrivilegesRequired = src.CVSSv3_PrivilegesRequired

// The Scope metric captures whether a vulnerability in one vulnerable
// component impacts resources in components beyond its security scope.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type CVSSv3_Scope = src.CVSSv3_Scope

// This metric captures the requirement for a human user, other than the
// attacker, to participate in the successful compromise of the vulnerable
// component.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type CVSSv3_UserInteraction = src.CVSSv3_UserInteraction

// A request message to create an OS policy assignment
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type CreateOSPolicyAssignmentRequest = src.CreateOSPolicyAssignmentRequest

// A request message for deleting a OS policy assignment.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type DeleteOSPolicyAssignmentRequest = src.DeleteOSPolicyAssignmentRequest

// Message encapsulating a value that can be either absolute ("fixed") or
// relative ("percent") to a value.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type FixedOrPercent = src.FixedOrPercent
type FixedOrPercent_Fixed = src.FixedOrPercent_Fixed
type FixedOrPercent_Percent = src.FixedOrPercent_Percent

// A request message for getting OS policies compliance data for the given
// Compute Engine VM instance. Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type GetInstanceOSPoliciesComplianceRequest = src.GetInstanceOSPoliciesComplianceRequest

// A request message for getting inventory data for the specified VM.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type GetInventoryRequest = src.GetInventoryRequest

// Get a report of the OS policy assignment for a VM instance.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type GetOSPolicyAssignmentReportRequest = src.GetOSPolicyAssignmentReportRequest

// A request message to get an OS policy assignment
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type GetOSPolicyAssignmentRequest = src.GetOSPolicyAssignmentRequest

// A request message for getting the vulnerability report for the specified
// VM.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type GetVulnerabilityReportRequest = src.GetVulnerabilityReportRequest

// This API resource represents the OS policies compliance data for a Compute
// Engine virtual machine (VM) instance at a given point in time. A Compute
// Engine VM can have multiple OS policy assignments, and each assignment can
// have multiple OS policies. As a result, multiple OS policies could be
// applied to a single VM. You can use this API resource to determine both the
// compliance state of your VM as well as the compliance state of an individual
// OS policy. For more information, see [View
// compliance](https://cloud.google.com/compute/docs/os-configuration-management/view-compliance).
// Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type InstanceOSPoliciesCompliance = src.InstanceOSPoliciesCompliance

// Compliance data for an OS policy Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type InstanceOSPoliciesCompliance_OSPolicyCompliance = src.InstanceOSPoliciesCompliance_OSPolicyCompliance

// This API resource represents the available inventory data for a Compute
// Engine virtual machine (VM) instance at a given point in time. You can use
// this API resource to determine the inventory data of your VM. For more
// information, see [Information provided by OS inventory
// management](https://cloud.google.com/compute/docs/instances/os-inventory-management#data-collected).
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type Inventory = src.Inventory

// The view for inventory objects.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type InventoryView = src.InventoryView

// A single piece of inventory on a VM.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type Inventory_Item = src.Inventory_Item
type Inventory_Item_AvailablePackage = src.Inventory_Item_AvailablePackage
type Inventory_Item_InstalledPackage = src.Inventory_Item_InstalledPackage

// The origin of a specific inventory item.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type Inventory_Item_OriginType = src.Inventory_Item_OriginType

// The different types of inventory that are tracked on a VM.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type Inventory_Item_Type = src.Inventory_Item_Type

// Operating system information for the VM.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type Inventory_OsInfo = src.Inventory_OsInfo

// Software package information of the operating system.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type Inventory_SoftwarePackage = src.Inventory_SoftwarePackage
type Inventory_SoftwarePackage_AptPackage = src.Inventory_SoftwarePackage_AptPackage
type Inventory_SoftwarePackage_CosPackage = src.Inventory_SoftwarePackage_CosPackage
type Inventory_SoftwarePackage_GoogetPackage = src.Inventory_SoftwarePackage_GoogetPackage
type Inventory_SoftwarePackage_QfePackage = src.Inventory_SoftwarePackage_QfePackage
type Inventory_SoftwarePackage_WindowsApplication = src.Inventory_SoftwarePackage_WindowsApplication
type Inventory_SoftwarePackage_WuaPackage = src.Inventory_SoftwarePackage_WuaPackage
type Inventory_SoftwarePackage_YumPackage = src.Inventory_SoftwarePackage_YumPackage
type Inventory_SoftwarePackage_ZypperPackage = src.Inventory_SoftwarePackage_ZypperPackage
type Inventory_SoftwarePackage_ZypperPatch = src.Inventory_SoftwarePackage_ZypperPatch

// Information related to the a standard versioned package. This includes
// package info for APT, Yum, Zypper, and Googet package managers.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type Inventory_VersionedPackage = src.Inventory_VersionedPackage

// Contains information about a Windows application that is retrieved from the
// Windows Registry. For more information about these fields, see:
// https://docs.microsoft.com/en-us/windows/win32/msi/uninstall-registry-key
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type Inventory_WindowsApplication = src.Inventory_WindowsApplication

// Information related to a Quick Fix Engineering package. Fields are taken
// from Windows QuickFixEngineering Interface and match the source names:
// https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type Inventory_WindowsQuickFixEngineeringPackage = src.Inventory_WindowsQuickFixEngineeringPackage

// Details related to a Windows Update package. Field data and names are taken
// from Windows Update API IUpdate Interface:
// https://docs.microsoft.com/en-us/windows/win32/api/_wua/ Descriptive fields
// like title, and description are localized based on the locale of the VM
// being updated.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type Inventory_WindowsUpdatePackage = src.Inventory_WindowsUpdatePackage

// Categories specified by the Windows Update.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type Inventory_WindowsUpdatePackage_WindowsUpdateCategory = src.Inventory_WindowsUpdatePackage_WindowsUpdateCategory

// Details related to a Zypper Patch.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type Inventory_ZypperPatch = src.Inventory_ZypperPatch

// A request message for listing OS policies compliance data for all Compute
// Engine VMs in the given location. Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type ListInstanceOSPoliciesCompliancesRequest = src.ListInstanceOSPoliciesCompliancesRequest

// A response message for listing OS policies compliance data for all Compute
// Engine VMs in the given location. Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type ListInstanceOSPoliciesCompliancesResponse = src.ListInstanceOSPoliciesCompliancesResponse

// A request message for listing inventory data for all VMs in the specified
// location.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type ListInventoriesRequest = src.ListInventoriesRequest

// A response message for listing inventory data for all VMs in a specified
// location.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type ListInventoriesResponse = src.ListInventoriesResponse

// List the OS policy assignment reports for VM instances.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type ListOSPolicyAssignmentReportsRequest = src.ListOSPolicyAssignmentReportsRequest

// A response message for listing OS Policy assignment reports including the
// page of results and page token.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type ListOSPolicyAssignmentReportsResponse = src.ListOSPolicyAssignmentReportsResponse

// A request message to list revisions for a OS policy assignment
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type ListOSPolicyAssignmentRevisionsRequest = src.ListOSPolicyAssignmentRevisionsRequest

// A response message for listing all revisions for a OS policy assignment.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type ListOSPolicyAssignmentRevisionsResponse = src.ListOSPolicyAssignmentRevisionsResponse

// A request message to list OS policy assignments for a parent resource
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type ListOSPolicyAssignmentsRequest = src.ListOSPolicyAssignmentsRequest

// A response message for listing all assignments under given parent.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type ListOSPolicyAssignmentsResponse = src.ListOSPolicyAssignmentsResponse

// A request message for listing vulnerability reports for all VM instances in
// the specified location.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type ListVulnerabilityReportsRequest = src.ListVulnerabilityReportsRequest

// A response message for listing vulnerability reports for all VM instances
// in the specified location.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type ListVulnerabilityReportsResponse = src.ListVulnerabilityReportsResponse

// An OS policy defines the desired state configuration for a VM.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy = src.OSPolicy

// OS policy assignment is an API resource that is used to apply a set of OS
// policies to a dynamically targeted group of Compute Engine VM instances. An
// OS policy is used to define the desired state configuration for a Compute
// Engine VM instance through a set of configuration resources that provide
// capabilities such as installing or removing software packages, or executing
// a script. For more information, see [OS policy and OS policy
// assignment](https://cloud.google.com/compute/docs/os-configuration-management/working-with-os-policies).
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyAssignment = src.OSPolicyAssignment

// OS policy assignment operation metadata provided by OS policy assignment
// API methods that return long running operations.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyAssignmentOperationMetadata = src.OSPolicyAssignmentOperationMetadata

// The OS policy assignment API method.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyAssignmentOperationMetadata_APIMethod = src.OSPolicyAssignmentOperationMetadata_APIMethod

// State of the rollout
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyAssignmentOperationMetadata_RolloutState = src.OSPolicyAssignmentOperationMetadata_RolloutState

// A report of the OS policy assignment status for a given instance.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyAssignmentReport = src.OSPolicyAssignmentReport

// Compliance data for an OS policy
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyAssignmentReport_OSPolicyCompliance = src.OSPolicyAssignmentReport_OSPolicyCompliance

// Possible compliance states for an os policy.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState = src.OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState

// Compliance data for an OS policy resource.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance = src.OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance

// Possible compliance states for a resource.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState = src.OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState

// ExecResource specific output.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput = src.OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput
type OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput_ = src.OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput_

// Step performed by the OS Config agent for configuring an `OSPolicy`
// resource to its desired state.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep = src.OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep

// Supported configuration step types
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type = src.OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type

// Filters to select target VMs for an assignment. If more than one filter
// criteria is specified below, a VM will be selected if and only if it
// satisfies all of them.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyAssignment_InstanceFilter = src.OSPolicyAssignment_InstanceFilter

// VM inventory details.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyAssignment_InstanceFilter_Inventory = src.OSPolicyAssignment_InstanceFilter_Inventory

// Message representing label set. - A label is a key value pair set for a VM.
// - A LabelSet is a set of labels. - Labels within a LabelSet are ANDed. In
// other words, a LabelSet is applicable for a VM only if it matches all the
// labels in the LabelSet. - Example: A LabelSet with 2 labels: `env=prod` and
// `type=webserver` will only be applicable for those VMs with both labels
// present.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyAssignment_LabelSet = src.OSPolicyAssignment_LabelSet

// Message to configure the rollout at the zonal level for the OS policy
// assignment.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyAssignment_Rollout = src.OSPolicyAssignment_Rollout

// OS policy assignment rollout state
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyAssignment_RolloutState = src.OSPolicyAssignment_RolloutState

// Supported OSPolicy compliance states. Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyComplianceState = src.OSPolicyComplianceState

// Compliance data for an OS policy resource. Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyResourceCompliance = src.OSPolicyResourceCompliance

// ExecResource specific output. Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyResourceCompliance_ExecResourceOutput = src.OSPolicyResourceCompliance_ExecResourceOutput
type OSPolicyResourceCompliance_ExecResourceOutput_ = src.OSPolicyResourceCompliance_ExecResourceOutput_

// Step performed by the OS Config agent for configuring an `OSPolicyResource`
// to its desired state. Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyResourceConfigStep = src.OSPolicyResourceConfigStep

// Supported outcomes for a configuration step. Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyResourceConfigStep_Outcome = src.OSPolicyResourceConfigStep_Outcome

// Supported configuration step types Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicyResourceConfigStep_Type = src.OSPolicyResourceConfigStep_Type

// Filtering criteria to select VMs based on inventory details.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_InventoryFilter = src.OSPolicy_InventoryFilter

// Policy mode
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Mode = src.OSPolicy_Mode

// Filtering criteria to select VMs based on OS details.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_OSFilter = src.OSPolicy_OSFilter

// An OS policy resource is used to define the desired state configuration and
// provides a specific functionality like installing/removing packages,
// executing a script etc. The system ensures that resources are always in
// their desired state by taking necessary actions if they have drifted from
// their desired state.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource = src.OSPolicy_Resource

// Resource groups provide a mechanism to group OS policy resources. Resource
// groups enable OS policy authors to create a single OS policy to be applied
// to VMs running different operating Systems. When the OS policy is applied to
// a target VM, the appropriate resource group within the OS policy is selected
// based on the `OSFilter` specified within the resource group.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_ResourceGroup = src.OSPolicy_ResourceGroup
type OSPolicy_Resource_Exec = src.OSPolicy_Resource_Exec

// A resource that allows executing scripts on the VM. The `ExecResource` has
// 2 stages: `validate` and `enforce` and both stages accept a script as an
// argument to execute. When the `ExecResource` is applied by the agent, it
// first executes the script in the `validate` stage. The `validate` stage can
// signal that the `ExecResource` is already in the desired state by returning
// an exit code of `100`. If the `ExecResource` is not in the desired state, it
// should return an exit code of `101`. Any other exit code returned by this
// stage is considered an error. If the `ExecResource` is not in the desired
// state based on the exit code from the `validate` stage, the agent proceeds
// to execute the script from the `enforce` stage. If the `ExecResource` is
// already in the desired state, the `enforce` stage will not be run. Similar
// to `validate` stage, the `enforce` stage should return an exit code of `100`
// to indicate that the resource in now in its desired state. Any other exit
// code is considered an error. NOTE: An exit code of `100` was chosen over `0`
// (and `101` vs `1`) to have an explicit indicator of `in desired state`, `not
// in desired state` and errors. Because, for example, Powershell will always
// return an exit code of `0` unless an `exit` statement is provided in the
// script. So, for reasons of consistency and being explicit, exit codes `100`
// and `101` were chosen.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_ExecResource = src.OSPolicy_Resource_ExecResource

// A file or script to execute.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_ExecResource_Exec = src.OSPolicy_Resource_ExecResource_Exec
type OSPolicy_Resource_ExecResource_Exec_File = src.OSPolicy_Resource_ExecResource_Exec_File

// The interpreter to use.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_ExecResource_Exec_Interpreter = src.OSPolicy_Resource_ExecResource_Exec_Interpreter
type OSPolicy_Resource_ExecResource_Exec_Script = src.OSPolicy_Resource_ExecResource_Exec_Script

// A remote or local file.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_File = src.OSPolicy_Resource_File

// A resource that manages the state of a file.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_FileResource = src.OSPolicy_Resource_FileResource
type OSPolicy_Resource_FileResource_Content = src.OSPolicy_Resource_FileResource_Content

// Desired state of the file.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_FileResource_DesiredState = src.OSPolicy_Resource_FileResource_DesiredState
type OSPolicy_Resource_FileResource_File = src.OSPolicy_Resource_FileResource_File
type OSPolicy_Resource_File_ = src.OSPolicy_Resource_File_

// Specifies a file available as a Cloud Storage Object.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_File_Gcs = src.OSPolicy_Resource_File_Gcs
type OSPolicy_Resource_File_Gcs_ = src.OSPolicy_Resource_File_Gcs_
type OSPolicy_Resource_File_LocalPath = src.OSPolicy_Resource_File_LocalPath

// Specifies a file available via some URI.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_File_Remote = src.OSPolicy_Resource_File_Remote
type OSPolicy_Resource_File_Remote_ = src.OSPolicy_Resource_File_Remote_

// A resource that manages a system package.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_PackageResource = src.OSPolicy_Resource_PackageResource

// A package managed by APT. - install: `apt-get update && apt-get -y install
// [name]` - remove: `apt-get -y remove [name]`
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_PackageResource_APT = src.OSPolicy_Resource_PackageResource_APT
type OSPolicy_Resource_PackageResource_Apt = src.OSPolicy_Resource_PackageResource_Apt

// A deb package file. dpkg packages only support INSTALLED state.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_PackageResource_Deb = src.OSPolicy_Resource_PackageResource_Deb
type OSPolicy_Resource_PackageResource_Deb_ = src.OSPolicy_Resource_PackageResource_Deb_

// The desired state that the OS Config agent maintains on the VM.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_PackageResource_DesiredState = src.OSPolicy_Resource_PackageResource_DesiredState

// A package managed by GooGet. - install: `googet -noconfirm install package`
// - remove: `googet -noconfirm remove package`
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_PackageResource_GooGet = src.OSPolicy_Resource_PackageResource_GooGet
type OSPolicy_Resource_PackageResource_Googet = src.OSPolicy_Resource_PackageResource_Googet

// An MSI package. MSI packages only support INSTALLED state.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_PackageResource_MSI = src.OSPolicy_Resource_PackageResource_MSI
type OSPolicy_Resource_PackageResource_Msi = src.OSPolicy_Resource_PackageResource_Msi

// An RPM package file. RPM packages only support INSTALLED state.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_PackageResource_RPM = src.OSPolicy_Resource_PackageResource_RPM
type OSPolicy_Resource_PackageResource_Rpm = src.OSPolicy_Resource_PackageResource_Rpm

// A package managed by YUM. - install: `yum -y install package` - remove:
// `yum -y remove package`
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_PackageResource_YUM = src.OSPolicy_Resource_PackageResource_YUM
type OSPolicy_Resource_PackageResource_Yum = src.OSPolicy_Resource_PackageResource_Yum

// A package managed by Zypper. - install: `zypper -y install package` -
// remove: `zypper -y rm package`
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_PackageResource_Zypper = src.OSPolicy_Resource_PackageResource_Zypper
type OSPolicy_Resource_PackageResource_Zypper_ = src.OSPolicy_Resource_PackageResource_Zypper_
type OSPolicy_Resource_Pkg = src.OSPolicy_Resource_Pkg
type OSPolicy_Resource_Repository = src.OSPolicy_Resource_Repository

// A resource that manages a package repository.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_RepositoryResource = src.OSPolicy_Resource_RepositoryResource
type OSPolicy_Resource_RepositoryResource_Apt = src.OSPolicy_Resource_RepositoryResource_Apt

// Represents a single apt package repository. These will be added to a repo
// file that will be managed at `/etc/apt/sources.list.d/google_osconfig.list`.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_RepositoryResource_AptRepository = src.OSPolicy_Resource_RepositoryResource_AptRepository

// Type of archive.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType = src.OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType
type OSPolicy_Resource_RepositoryResource_Goo = src.OSPolicy_Resource_RepositoryResource_Goo

// Represents a Goo package repository. These are added to a repo file that is
// managed at `C:/ProgramData/GooGet/repos/google_osconfig.repo`.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_RepositoryResource_GooRepository = src.OSPolicy_Resource_RepositoryResource_GooRepository
type OSPolicy_Resource_RepositoryResource_Yum = src.OSPolicy_Resource_RepositoryResource_Yum

// Represents a single yum package repository. These are added to a repo file
// that is managed at `/etc/yum.repos.d/google_osconfig.repo`.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_RepositoryResource_YumRepository = src.OSPolicy_Resource_RepositoryResource_YumRepository
type OSPolicy_Resource_RepositoryResource_Zypper = src.OSPolicy_Resource_RepositoryResource_Zypper

// Represents a single zypper package repository. These are added to a repo
// file that is managed at `/etc/zypp/repos.d/google_osconfig.repo`.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OSPolicy_Resource_RepositoryResource_ZypperRepository = src.OSPolicy_Resource_RepositoryResource_ZypperRepository

// OsConfigZonalServiceClient is the client API for OsConfigZonalService
// service. For semantics around ctx use and closing/ending streaming RPCs,
// please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OsConfigZonalServiceClient = src.OsConfigZonalServiceClient

// OsConfigZonalServiceServer is the server API for OsConfigZonalService
// service.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type OsConfigZonalServiceServer = src.OsConfigZonalServiceServer

// UnimplementedOsConfigZonalServiceServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type UnimplementedOsConfigZonalServiceServer = src.UnimplementedOsConfigZonalServiceServer

// A request message to update an OS policy assignment
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type UpdateOSPolicyAssignmentRequest = src.UpdateOSPolicyAssignmentRequest

// This API resource represents the vulnerability report for a specified
// Compute Engine virtual machine (VM) instance at a given point in time. For
// more information, see [Vulnerability
// reports](https://cloud.google.com/compute/docs/instances/os-inventory-management#vulnerability-reports).
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type VulnerabilityReport = src.VulnerabilityReport

// A vulnerability affecting the VM instance.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type VulnerabilityReport_Vulnerability = src.VulnerabilityReport_Vulnerability

// Contains metadata information for the vulnerability. This information is
// collected from the upstream feed of the operating system.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type VulnerabilityReport_Vulnerability_Details = src.VulnerabilityReport_Vulnerability_Details

// A reference for this vulnerability.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type VulnerabilityReport_Vulnerability_Details_Reference = src.VulnerabilityReport_Vulnerability_Details_Reference

// OS inventory item that is affected by a vulnerability or fixed as a result
// of a vulnerability.
//
// Deprecated: Please use types in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
type VulnerabilityReport_Vulnerability_Item = src.VulnerabilityReport_Vulnerability_Item

// Deprecated: Please use funcs in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
func NewOsConfigZonalServiceClient(cc grpc.ClientConnInterface) OsConfigZonalServiceClient {
	return src.NewOsConfigZonalServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/osconfig/apiv1alpha/osconfigpb
func RegisterOsConfigZonalServiceServer(s *grpc.Server, srv OsConfigZonalServiceServer) {
	src.RegisterOsConfigZonalServiceServer(s, srv)
}
