/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2002 Pascal Bourut (toweld@rocketmail.com)

    Network part from grrrreg (greg@doodoo.darktech.org)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "NetClient.h"


NetClient::NetClient() {

  SDLNet_Init();
  type = CLIENT;
  connected = false;
  server_address = NULL;
  ip_server = NET_DEFAULT_SERVER_IP;
  port=NET_DEFAULT_PORT;
  
}

NetClient::NetClient(Uint16 le_port,char* l_ip) {
  SDLNet_Init();
  ip_server = l_ip;
  port=le_port;
  type = CLIENT;
  connected = false;
  server_address = NULL;
}

NetClient::~NetClient() {
 
  SDLNet_Quit();
}


int NetClient::init_connection(void){
	return init_connection(NET_DEFAULT_SERVER_IP,NET_DEFAULT_PORT);
}

int NetClient::init_connection(char* l_ip){
	return init_connection(l_ip,NET_DEFAULT_PORT);
}

int NetClient::init_connection(Uint16 le_port){
	return init_connection(NET_DEFAULT_SERVER_IP,le_port);
}

int NetClient::init_connection(char* l_ip,Uint16 le_port){
	ip_server = l_ip;
	port = le_port;

	if(SDLNet_ResolveHost(&serverIP,ip_server,port)==-1) {
		printf("SDLNet_ResolveHost: %s\n", SDLNet_GetError());
		return(0);
	}

	socketSet = SDLNet_AllocSocketSet(2);
	return(1);
}

int NetClient::connect() { 
  parloteSocket = SDLNet_TCP_Open(&serverIP); 
  
  if (!parloteSocket) {
    printf("NetClient::connect()\n");
    return (0);
  }

  SDLNet_TCP_AddSocket(socketSet, parloteSocket);
  connected = true;
  return(1);
}

void NetClient::set_server_address(char* ip){
	server_address = (char*)malloc( CHAR_64 );
	sprintf(server_address,"%s",ip);
 }

 char* NetClient::get_server_address(void){
	return server_address;	
 }

 bool NetClient::is_connected(){
	return connected;
 }
