/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.commons.java.xml.digest;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.onemind.commons.java.xml.digest.ElementDigester;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxDigesterHandler
extends DefaultHandler {
    private static final Logger _logger = Logger.getLogger((class$org$onemind$commons$java$xml$digest$SaxDigesterHandler == null ? (class$org$onemind$commons$java$xml$digest$SaxDigesterHandler = SaxDigesterHandler.class$("org.onemind.commons.java.xml.digest.SaxDigesterHandler")) : class$org$onemind$commons$java$xml$digest$SaxDigesterHandler).getName());
    private Map _digesters = new HashMap();
    private List _elementPath = new ArrayList();
    static /* synthetic */ Class class$org$onemind$commons$java$xml$digest$SaxDigesterHandler;

    public void addDigester(ElementDigester dig) {
        this.addDigester(null, dig);
    }

    public void addDigester(String path, ElementDigester dig) {
        if (path == null) {
            this._digesters.put(dig.getElementName(), dig);
        } else {
            this._digesters.put(path + "/" + dig.getElementName(), dig);
        }
    }

    public void addSubDigester(ElementDigester dig) {
        String path = this.getCurrentPath();
        this.addDigester(path, dig);
    }

    public void addSubDigester(String prefixPath, ElementDigester dig) {
        String path = this.getCurrentPath();
        if (path == null) {
            this.addDigester(prefixPath, dig);
        } else if (prefixPath == null) {
            this.addDigester(path, dig);
        } else {
            this.addDigester(path + "/" + prefixPath, dig);
        }
    }

    private String appendElementPath(String name) {
        int i = this._elementPath.size();
        if (i > 0) {
            String str = (String)this._elementPath.get(i - 1);
            String newStr = str + "/" + name;
            this._elementPath.add(newStr);
            return newStr;
        }
        this._elementPath.add(name);
        return name;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        ElementDigester dig = this.getDigester(this.getCurrentPath());
        if (dig != null) {
            dig.characters(this, ch, start, length);
        }
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        String str = this.removeElementPath(qName);
        ElementDigester dig = this.getDigester(str);
        if (dig != null) {
            dig.endDigest(this);
        }
    }

    public String getCurrentPath() {
        int i = this._elementPath.size();
        if (i > 0) {
            return (String)this._elementPath.get(i - 1);
        }
        return null;
    }

    private ElementDigester getDigester(String path) {
        return (ElementDigester)this._digesters.get(path);
    }

    private String removeElementPath(String qname) {
        int i = this._elementPath.size();
        if (i > 0) {
            String str = (String)this._elementPath.remove(i - 1);
            return str;
        }
        throw new IllegalStateException("Cannot remove element path " + qname);
    }

    public void startDocument() throws SAXException {
    }

    private void startDigest(String path, Attributes attr) throws SAXException {
        ElementDigester dig;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Digesting " + path);
        }
        if ((dig = this.getDigester(path)) != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("with " + dig);
            }
            dig.startDigest(this, attr);
        }
    }

    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        String newPath = this.appendElementPath(qName);
        this.startDigest(newPath, attrs);
    }

    public synchronized void parse(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory fac = SAXParserFactory.newInstance();
        SAXParser parser = fac.newSAXParser();
        parser.parse(stream, (DefaultHandler)this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

