// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteStorageGeneralFileNoContentCode is the HTTP code returned for type DeleteStorageGeneralFileNoContent
const DeleteStorageGeneralFileNoContentCode int = 204

/*
DeleteStorageGeneralFileNoContent General use file deleted

swagger:response deleteStorageGeneralFileNoContent
*/
type DeleteStorageGeneralFileNoContent struct {
}

// NewDeleteStorageGeneralFileNoContent creates DeleteStorageGeneralFileNoContent with default headers values
func NewDeleteStorageGeneralFileNoContent() *DeleteStorageGeneralFileNoContent {

	return &DeleteStorageGeneralFileNoContent{}
}

// WriteResponse to the client
func (o *DeleteStorageGeneralFileNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteStorageGeneralFileNotFoundCode is the HTTP code returned for type DeleteStorageGeneralFileNotFound
const DeleteStorageGeneralFileNotFoundCode int = 404

/*
DeleteStorageGeneralFileNotFound The specified resource was not found

swagger:response deleteStorageGeneralFileNotFound
*/
type DeleteStorageGeneralFileNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteStorageGeneralFileNotFound creates DeleteStorageGeneralFileNotFound with default headers values
func NewDeleteStorageGeneralFileNotFound() *DeleteStorageGeneralFileNotFound {

	return &DeleteStorageGeneralFileNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete storage general file not found response
func (o *DeleteStorageGeneralFileNotFound) WithConfigurationVersion(configurationVersion string) *DeleteStorageGeneralFileNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete storage general file not found response
func (o *DeleteStorageGeneralFileNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete storage general file not found response
func (o *DeleteStorageGeneralFileNotFound) WithPayload(payload *models.Error) *DeleteStorageGeneralFileNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete storage general file not found response
func (o *DeleteStorageGeneralFileNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteStorageGeneralFileNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteStorageGeneralFileDefault General Error

swagger:response deleteStorageGeneralFileDefault
*/
type DeleteStorageGeneralFileDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteStorageGeneralFileDefault creates DeleteStorageGeneralFileDefault with default headers values
func NewDeleteStorageGeneralFileDefault(code int) *DeleteStorageGeneralFileDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteStorageGeneralFileDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete storage general file default response
func (o *DeleteStorageGeneralFileDefault) WithStatusCode(code int) *DeleteStorageGeneralFileDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete storage general file default response
func (o *DeleteStorageGeneralFileDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete storage general file default response
func (o *DeleteStorageGeneralFileDefault) WithConfigurationVersion(configurationVersion string) *DeleteStorageGeneralFileDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete storage general file default response
func (o *DeleteStorageGeneralFileDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete storage general file default response
func (o *DeleteStorageGeneralFileDefault) WithPayload(payload *models.Error) *DeleteStorageGeneralFileDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete storage general file default response
func (o *DeleteStorageGeneralFileDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteStorageGeneralFileDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
