// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceLogTargetGlobalOKCode is the HTTP code returned for type ReplaceLogTargetGlobalOK
const ReplaceLogTargetGlobalOKCode int = 200

/*
ReplaceLogTargetGlobalOK Log Target replaced

swagger:response replaceLogTargetGlobalOK
*/
type ReplaceLogTargetGlobalOK struct {

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewReplaceLogTargetGlobalOK creates ReplaceLogTargetGlobalOK with default headers values
func NewReplaceLogTargetGlobalOK() *ReplaceLogTargetGlobalOK {

	return &ReplaceLogTargetGlobalOK{}
}

// WithPayload adds the payload to the replace log target global o k response
func (o *ReplaceLogTargetGlobalOK) WithPayload(payload *models.LogTarget) *ReplaceLogTargetGlobalOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target global o k response
func (o *ReplaceLogTargetGlobalOK) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetGlobalOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogTargetGlobalAcceptedCode is the HTTP code returned for type ReplaceLogTargetGlobalAccepted
const ReplaceLogTargetGlobalAcceptedCode int = 202

/*
ReplaceLogTargetGlobalAccepted Configuration change accepted and reload requested

swagger:response replaceLogTargetGlobalAccepted
*/
type ReplaceLogTargetGlobalAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewReplaceLogTargetGlobalAccepted creates ReplaceLogTargetGlobalAccepted with default headers values
func NewReplaceLogTargetGlobalAccepted() *ReplaceLogTargetGlobalAccepted {

	return &ReplaceLogTargetGlobalAccepted{}
}

// WithReloadID adds the reloadId to the replace log target global accepted response
func (o *ReplaceLogTargetGlobalAccepted) WithReloadID(reloadID string) *ReplaceLogTargetGlobalAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace log target global accepted response
func (o *ReplaceLogTargetGlobalAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace log target global accepted response
func (o *ReplaceLogTargetGlobalAccepted) WithPayload(payload *models.LogTarget) *ReplaceLogTargetGlobalAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target global accepted response
func (o *ReplaceLogTargetGlobalAccepted) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetGlobalAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogTargetGlobalBadRequestCode is the HTTP code returned for type ReplaceLogTargetGlobalBadRequest
const ReplaceLogTargetGlobalBadRequestCode int = 400

/*
ReplaceLogTargetGlobalBadRequest Bad request

swagger:response replaceLogTargetGlobalBadRequest
*/
type ReplaceLogTargetGlobalBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogTargetGlobalBadRequest creates ReplaceLogTargetGlobalBadRequest with default headers values
func NewReplaceLogTargetGlobalBadRequest() *ReplaceLogTargetGlobalBadRequest {

	return &ReplaceLogTargetGlobalBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace log target global bad request response
func (o *ReplaceLogTargetGlobalBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceLogTargetGlobalBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log target global bad request response
func (o *ReplaceLogTargetGlobalBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log target global bad request response
func (o *ReplaceLogTargetGlobalBadRequest) WithPayload(payload *models.Error) *ReplaceLogTargetGlobalBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target global bad request response
func (o *ReplaceLogTargetGlobalBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetGlobalBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogTargetGlobalNotFoundCode is the HTTP code returned for type ReplaceLogTargetGlobalNotFound
const ReplaceLogTargetGlobalNotFoundCode int = 404

/*
ReplaceLogTargetGlobalNotFound The specified resource was not found

swagger:response replaceLogTargetGlobalNotFound
*/
type ReplaceLogTargetGlobalNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogTargetGlobalNotFound creates ReplaceLogTargetGlobalNotFound with default headers values
func NewReplaceLogTargetGlobalNotFound() *ReplaceLogTargetGlobalNotFound {

	return &ReplaceLogTargetGlobalNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace log target global not found response
func (o *ReplaceLogTargetGlobalNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceLogTargetGlobalNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log target global not found response
func (o *ReplaceLogTargetGlobalNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log target global not found response
func (o *ReplaceLogTargetGlobalNotFound) WithPayload(payload *models.Error) *ReplaceLogTargetGlobalNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target global not found response
func (o *ReplaceLogTargetGlobalNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetGlobalNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceLogTargetGlobalDefault General Error

swagger:response replaceLogTargetGlobalDefault
*/
type ReplaceLogTargetGlobalDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogTargetGlobalDefault creates ReplaceLogTargetGlobalDefault with default headers values
func NewReplaceLogTargetGlobalDefault(code int) *ReplaceLogTargetGlobalDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceLogTargetGlobalDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace log target global default response
func (o *ReplaceLogTargetGlobalDefault) WithStatusCode(code int) *ReplaceLogTargetGlobalDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace log target global default response
func (o *ReplaceLogTargetGlobalDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace log target global default response
func (o *ReplaceLogTargetGlobalDefault) WithConfigurationVersion(configurationVersion string) *ReplaceLogTargetGlobalDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log target global default response
func (o *ReplaceLogTargetGlobalDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log target global default response
func (o *ReplaceLogTargetGlobalDefault) WithPayload(payload *models.Error) *ReplaceLogTargetGlobalDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target global default response
func (o *ReplaceLogTargetGlobalDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetGlobalDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
