/*
  File: bootcreator.h

  Copyright (C) 2007
  Marcin 'Morgoth' Kurek <morgoth6@box43.pl>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef BOOT_CREATOR_H
#define BOOT_CREATOR_H

#ifndef BOOTCREATOR_CONFIG_H
#include "config.h"
#endif /* BOOTCREATOR_CONFIG_H */

#ifndef SUPPORT_H
#include "support.h"
#endif /* SUPPORT_H */

/*
 * Version
 */

#define PROGRAM_NAME    "BootCreator"
#define PROGRAM_VERSION    "1.2"
#define PROGRAM_DATE    __DATE
#define PROGRAM_DESCRIPTION

#define VERSION_STRING  PROGRAM_NAME " " PROGRAM_VERSION " (" PROGRAM_DATE ") " PROGRAM_DESCRIPTION

/*
 * Return Codes
 */

#define RETURN_OK (0)
#define RETURN_FAILURE  (20)

/*
 * Parse Args
 */

#define ARGS_OK      (1 << 0)
#define ARGS_VERSION (1 << 1)
#define ARGS_HELP (1 << 2)
#define ARGS_MISSING (1 << 3)
#define ARGS_INTERNAL   (1 << 4)
#define ARGS_CONFIG  (1 << 5)

/* 
 * Args Struct
 */

struct Args
{
	/* Required */
	char source_file[ARGS_BUF_SIZE];
	char destination_file[ARGS_BUF_SIZE];

	/* Optional */
	bool verbose;

	/* Files */
	int source_fh;
	int destination_fh;
};

/*
 * Prototypes
 */

int bootcreator(void);

/*
 * Macros
 */

#define VERBOSE(_cmd_) if(args.verbose) {_cmd_;}

#define INSIDE_READLINE if(get_line(args.source_fh, FILE_BUF_SIZE, buffer, &stat_line, false) <= 0) \
         {    res = RETURN_FAILURE; goto unexpected_eof; }

#define INSIDE_PURELINE if(get_line(args.source_fh, FILE_BUF_SIZE, buffer, &stat_line, true) < 0) \
                        {    res = RETURN_FAILURE; goto unexpected_eof; }

#define PARSE_MSG(_cmd_)   printf("%d: ", stat_line); { _cmd_;}

#define VERIFYLINE(_str_)  if(!verifyline(_str_)) { PARSE_MSG(printf("possible illegal character detected at %s\n", _str_)); }

#define SAVELINE(_file_, _buffer_, _size_)   { if(save_line(_file_, _buffer_, _size_) < 0) { res = RETURN_FAILURE; goto write_err; } }

#endif /* BOOT_CREATOR_H */
