/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.stub;

import junit.framework.Assert;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;

public class ThrowStub
extends Assert
implements Stub {
    private Throwable throwable;

    public ThrowStub(Throwable throwable) {
        this.throwable = throwable;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (this.isThrowingCheckedException()) {
            this.checkTypeCompatiblity(invocation.invokedMethod.getExceptionTypes());
        }
        this.throwable.fillInStackTrace();
        throw this.throwable;
    }

    public StringBuffer describeTo(StringBuffer buffer) {
        return buffer.append("throws <").append(this.throwable).append(">");
    }

    private void checkTypeCompatiblity(Class[] allowedExceptionTypes) {
        for (int i = 0; i < allowedExceptionTypes.length; ++i) {
            if (!allowedExceptionTypes[i].isInstance(this.throwable)) continue;
            return;
        }
        this.reportIncompatibleCheckedException(allowedExceptionTypes);
    }

    private void reportIncompatibleCheckedException(Class[] allowedTypes) {
        StringBuffer message = new StringBuffer();
        message.append("tried to throw a ");
        message.append(this.throwable.getClass().getName());
        message.append(" from a method that throws ");
        if (allowedTypes.length == 0) {
            message.append("no exceptions");
        } else {
            for (int i = 0; i < allowedTypes.length; ++i) {
                if (i > 0) {
                    message.append(",");
                }
                message.append(allowedTypes[i].getName());
            }
        }
        ThrowStub.fail((String)message.toString());
    }

    private boolean isThrowingCheckedException() {
        return !(this.throwable instanceof RuntimeException) && !(this.throwable instanceof Error);
    }
}

