// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/storage/control/v2/storage_control.proto

#include "google/cloud/storagecontrol/v2/internal/storage_control_option_defaults.h"
#include "google/cloud/storagecontrol/v2/storage_control_connection.h"
#include "google/cloud/storagecontrol/v2/storage_control_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace storagecontrol_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options StorageControlDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_STORAGE_CONTROL_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_STORAGE_CONTROL_AUTHORITY", "storage.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<storagecontrol_v2::StorageControlRetryPolicyOption>()) {
    options.set<storagecontrol_v2::StorageControlRetryPolicyOption>(
        storagecontrol_v2::StorageControlLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<storagecontrol_v2::StorageControlBackoffPolicyOption>()) {
    options.set<storagecontrol_v2::StorageControlBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<storagecontrol_v2::StorageControlPollingPolicyOption>()) {
    options.set<storagecontrol_v2::StorageControlPollingPolicyOption>(
        GenericPollingPolicy<
            storagecontrol_v2::StorageControlRetryPolicyOption::Type,
            storagecontrol_v2::StorageControlBackoffPolicyOption::Type>(
            options.get<storagecontrol_v2::StorageControlRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<storagecontrol_v2::
                       StorageControlConnectionIdempotencyPolicyOption>()) {
    options.set<
        storagecontrol_v2::StorageControlConnectionIdempotencyPolicyOption>(
        storagecontrol_v2::
            MakeDefaultStorageControlConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storagecontrol_v2_internal
}  // namespace cloud
}  // namespace google
