// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/netapp/v1/cloud_netapp_service.proto

#include "google/cloud/netapp/v1/internal/net_app_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace netapp_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

NetAppTracingConnection::NetAppTracingConnection(
    std::shared_ptr<netapp_v1::NetAppConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::netapp::v1::StoragePool>
NetAppTracingConnection::ListStoragePools(
    google::cloud::netapp::v1::ListStoragePoolsRequest request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::ListStoragePools");
  internal::OTelScope scope(span);
  auto sr = child_->ListStoragePools(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::netapp::v1::StoragePool>(std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::netapp::v1::StoragePool>>
NetAppTracingConnection::CreateStoragePool(
    google::cloud::netapp::v1::CreateStoragePoolRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::CreateStoragePool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateStoragePool(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::CreateStoragePool(
    NoAwaitTag,
    google::cloud::netapp::v1::CreateStoragePoolRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::CreateStoragePool");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateStoragePool(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::StoragePool>>
NetAppTracingConnection::CreateStoragePool(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::CreateStoragePool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateStoragePool(operation));
}

StatusOr<google::cloud::netapp::v1::StoragePool>
NetAppTracingConnection::GetStoragePool(
    google::cloud::netapp::v1::GetStoragePoolRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::GetStoragePool");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetStoragePool(request));
}

future<StatusOr<google::cloud::netapp::v1::StoragePool>>
NetAppTracingConnection::UpdateStoragePool(
    google::cloud::netapp::v1::UpdateStoragePoolRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::UpdateStoragePool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateStoragePool(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::UpdateStoragePool(
    NoAwaitTag,
    google::cloud::netapp::v1::UpdateStoragePoolRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::UpdateStoragePool");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateStoragePool(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::StoragePool>>
NetAppTracingConnection::UpdateStoragePool(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::UpdateStoragePool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateStoragePool(operation));
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppTracingConnection::DeleteStoragePool(
    google::cloud::netapp::v1::DeleteStoragePoolRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::DeleteStoragePool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteStoragePool(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::DeleteStoragePool(
    NoAwaitTag,
    google::cloud::netapp::v1::DeleteStoragePoolRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::DeleteStoragePool");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteStoragePool(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppTracingConnection::DeleteStoragePool(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::DeleteStoragePool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteStoragePool(operation));
}

future<StatusOr<google::cloud::netapp::v1::StoragePool>>
NetAppTracingConnection::SwitchActiveReplicaZone(
    google::cloud::netapp::v1::SwitchActiveReplicaZoneRequest const& request) {
  auto span = internal::MakeSpan(
      "netapp_v1::NetAppConnection::SwitchActiveReplicaZone");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->SwitchActiveReplicaZone(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::SwitchActiveReplicaZone(
    NoAwaitTag,
    google::cloud::netapp::v1::SwitchActiveReplicaZoneRequest const& request) {
  auto span = internal::MakeSpan(
      "netapp_v1::NetAppConnection::SwitchActiveReplicaZone");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->SwitchActiveReplicaZone(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::StoragePool>>
NetAppTracingConnection::SwitchActiveReplicaZone(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "netapp_v1::NetAppConnection::SwitchActiveReplicaZone");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->SwitchActiveReplicaZone(operation));
}

StreamRange<google::cloud::netapp::v1::Volume>
NetAppTracingConnection::ListVolumes(
    google::cloud::netapp::v1::ListVolumesRequest request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::ListVolumes");
  internal::OTelScope scope(span);
  auto sr = child_->ListVolumes(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::netapp::v1::Volume>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::netapp::v1::Volume> NetAppTracingConnection::GetVolume(
    google::cloud::netapp::v1::GetVolumeRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::GetVolume");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetVolume(request));
}

future<StatusOr<google::cloud::netapp::v1::Volume>>
NetAppTracingConnection::CreateVolume(
    google::cloud::netapp::v1::CreateVolumeRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::CreateVolume");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateVolume(request));
}

StatusOr<google::longrunning::Operation> NetAppTracingConnection::CreateVolume(
    NoAwaitTag, google::cloud::netapp::v1::CreateVolumeRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::CreateVolume");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateVolume(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::Volume>>
NetAppTracingConnection::CreateVolume(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::CreateVolume");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateVolume(operation));
}

future<StatusOr<google::cloud::netapp::v1::Volume>>
NetAppTracingConnection::UpdateVolume(
    google::cloud::netapp::v1::UpdateVolumeRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::UpdateVolume");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateVolume(request));
}

StatusOr<google::longrunning::Operation> NetAppTracingConnection::UpdateVolume(
    NoAwaitTag, google::cloud::netapp::v1::UpdateVolumeRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::UpdateVolume");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateVolume(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::Volume>>
NetAppTracingConnection::UpdateVolume(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::UpdateVolume");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateVolume(operation));
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppTracingConnection::DeleteVolume(
    google::cloud::netapp::v1::DeleteVolumeRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::DeleteVolume");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteVolume(request));
}

StatusOr<google::longrunning::Operation> NetAppTracingConnection::DeleteVolume(
    NoAwaitTag, google::cloud::netapp::v1::DeleteVolumeRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::DeleteVolume");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteVolume(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppTracingConnection::DeleteVolume(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::DeleteVolume");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteVolume(operation));
}

future<StatusOr<google::cloud::netapp::v1::Volume>>
NetAppTracingConnection::RevertVolume(
    google::cloud::netapp::v1::RevertVolumeRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::RevertVolume");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RevertVolume(request));
}

StatusOr<google::longrunning::Operation> NetAppTracingConnection::RevertVolume(
    NoAwaitTag, google::cloud::netapp::v1::RevertVolumeRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::RevertVolume");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->RevertVolume(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::Volume>>
NetAppTracingConnection::RevertVolume(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::RevertVolume");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RevertVolume(operation));
}

StreamRange<google::cloud::netapp::v1::Snapshot>
NetAppTracingConnection::ListSnapshots(
    google::cloud::netapp::v1::ListSnapshotsRequest request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::ListSnapshots");
  internal::OTelScope scope(span);
  auto sr = child_->ListSnapshots(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::netapp::v1::Snapshot>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::netapp::v1::Snapshot>
NetAppTracingConnection::GetSnapshot(
    google::cloud::netapp::v1::GetSnapshotRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::GetSnapshot");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSnapshot(request));
}

future<StatusOr<google::cloud::netapp::v1::Snapshot>>
NetAppTracingConnection::CreateSnapshot(
    google::cloud::netapp::v1::CreateSnapshotRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::CreateSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateSnapshot(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::CreateSnapshot(
    NoAwaitTag,
    google::cloud::netapp::v1::CreateSnapshotRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::CreateSnapshot");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateSnapshot(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::Snapshot>>
NetAppTracingConnection::CreateSnapshot(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::CreateSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateSnapshot(operation));
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppTracingConnection::DeleteSnapshot(
    google::cloud::netapp::v1::DeleteSnapshotRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::DeleteSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteSnapshot(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::DeleteSnapshot(
    NoAwaitTag,
    google::cloud::netapp::v1::DeleteSnapshotRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::DeleteSnapshot");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteSnapshot(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppTracingConnection::DeleteSnapshot(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::DeleteSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteSnapshot(operation));
}

future<StatusOr<google::cloud::netapp::v1::Snapshot>>
NetAppTracingConnection::UpdateSnapshot(
    google::cloud::netapp::v1::UpdateSnapshotRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::UpdateSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateSnapshot(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::UpdateSnapshot(
    NoAwaitTag,
    google::cloud::netapp::v1::UpdateSnapshotRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::UpdateSnapshot");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateSnapshot(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::Snapshot>>
NetAppTracingConnection::UpdateSnapshot(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::UpdateSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateSnapshot(operation));
}

StreamRange<google::cloud::netapp::v1::ActiveDirectory>
NetAppTracingConnection::ListActiveDirectories(
    google::cloud::netapp::v1::ListActiveDirectoriesRequest request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::ListActiveDirectories");
  internal::OTelScope scope(span);
  auto sr = child_->ListActiveDirectories(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::netapp::v1::ActiveDirectory>(std::move(span),
                                                  std::move(sr));
}

StatusOr<google::cloud::netapp::v1::ActiveDirectory>
NetAppTracingConnection::GetActiveDirectory(
    google::cloud::netapp::v1::GetActiveDirectoryRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::GetActiveDirectory");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetActiveDirectory(request));
}

future<StatusOr<google::cloud::netapp::v1::ActiveDirectory>>
NetAppTracingConnection::CreateActiveDirectory(
    google::cloud::netapp::v1::CreateActiveDirectoryRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::CreateActiveDirectory");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateActiveDirectory(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::CreateActiveDirectory(
    NoAwaitTag,
    google::cloud::netapp::v1::CreateActiveDirectoryRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::CreateActiveDirectory");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->CreateActiveDirectory(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::ActiveDirectory>>
NetAppTracingConnection::CreateActiveDirectory(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::CreateActiveDirectory");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateActiveDirectory(operation));
}

future<StatusOr<google::cloud::netapp::v1::ActiveDirectory>>
NetAppTracingConnection::UpdateActiveDirectory(
    google::cloud::netapp::v1::UpdateActiveDirectoryRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::UpdateActiveDirectory");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateActiveDirectory(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::UpdateActiveDirectory(
    NoAwaitTag,
    google::cloud::netapp::v1::UpdateActiveDirectoryRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::UpdateActiveDirectory");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->UpdateActiveDirectory(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::ActiveDirectory>>
NetAppTracingConnection::UpdateActiveDirectory(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::UpdateActiveDirectory");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateActiveDirectory(operation));
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppTracingConnection::DeleteActiveDirectory(
    google::cloud::netapp::v1::DeleteActiveDirectoryRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::DeleteActiveDirectory");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteActiveDirectory(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::DeleteActiveDirectory(
    NoAwaitTag,
    google::cloud::netapp::v1::DeleteActiveDirectoryRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::DeleteActiveDirectory");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeleteActiveDirectory(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppTracingConnection::DeleteActiveDirectory(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::DeleteActiveDirectory");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteActiveDirectory(operation));
}

StreamRange<google::cloud::netapp::v1::KmsConfig>
NetAppTracingConnection::ListKmsConfigs(
    google::cloud::netapp::v1::ListKmsConfigsRequest request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::ListKmsConfigs");
  internal::OTelScope scope(span);
  auto sr = child_->ListKmsConfigs(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::netapp::v1::KmsConfig>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::netapp::v1::KmsConfig>>
NetAppTracingConnection::CreateKmsConfig(
    google::cloud::netapp::v1::CreateKmsConfigRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::CreateKmsConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateKmsConfig(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::CreateKmsConfig(
    NoAwaitTag,
    google::cloud::netapp::v1::CreateKmsConfigRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::CreateKmsConfig");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateKmsConfig(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::KmsConfig>>
NetAppTracingConnection::CreateKmsConfig(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::CreateKmsConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateKmsConfig(operation));
}

StatusOr<google::cloud::netapp::v1::KmsConfig>
NetAppTracingConnection::GetKmsConfig(
    google::cloud::netapp::v1::GetKmsConfigRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::GetKmsConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetKmsConfig(request));
}

future<StatusOr<google::cloud::netapp::v1::KmsConfig>>
NetAppTracingConnection::UpdateKmsConfig(
    google::cloud::netapp::v1::UpdateKmsConfigRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::UpdateKmsConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateKmsConfig(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::UpdateKmsConfig(
    NoAwaitTag,
    google::cloud::netapp::v1::UpdateKmsConfigRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::UpdateKmsConfig");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateKmsConfig(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::KmsConfig>>
NetAppTracingConnection::UpdateKmsConfig(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::UpdateKmsConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateKmsConfig(operation));
}

future<StatusOr<google::cloud::netapp::v1::KmsConfig>>
NetAppTracingConnection::EncryptVolumes(
    google::cloud::netapp::v1::EncryptVolumesRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::EncryptVolumes");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->EncryptVolumes(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::EncryptVolumes(
    NoAwaitTag,
    google::cloud::netapp::v1::EncryptVolumesRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::EncryptVolumes");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->EncryptVolumes(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::KmsConfig>>
NetAppTracingConnection::EncryptVolumes(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::EncryptVolumes");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->EncryptVolumes(operation));
}

StatusOr<google::cloud::netapp::v1::VerifyKmsConfigResponse>
NetAppTracingConnection::VerifyKmsConfig(
    google::cloud::netapp::v1::VerifyKmsConfigRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::VerifyKmsConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->VerifyKmsConfig(request));
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppTracingConnection::DeleteKmsConfig(
    google::cloud::netapp::v1::DeleteKmsConfigRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::DeleteKmsConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteKmsConfig(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::DeleteKmsConfig(
    NoAwaitTag,
    google::cloud::netapp::v1::DeleteKmsConfigRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::DeleteKmsConfig");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteKmsConfig(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppTracingConnection::DeleteKmsConfig(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::DeleteKmsConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteKmsConfig(operation));
}

StreamRange<google::cloud::netapp::v1::Replication>
NetAppTracingConnection::ListReplications(
    google::cloud::netapp::v1::ListReplicationsRequest request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::ListReplications");
  internal::OTelScope scope(span);
  auto sr = child_->ListReplications(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::netapp::v1::Replication>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::netapp::v1::Replication>
NetAppTracingConnection::GetReplication(
    google::cloud::netapp::v1::GetReplicationRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::GetReplication");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetReplication(request));
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppTracingConnection::CreateReplication(
    google::cloud::netapp::v1::CreateReplicationRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::CreateReplication");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateReplication(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::CreateReplication(
    NoAwaitTag,
    google::cloud::netapp::v1::CreateReplicationRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::CreateReplication");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateReplication(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppTracingConnection::CreateReplication(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::CreateReplication");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateReplication(operation));
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppTracingConnection::DeleteReplication(
    google::cloud::netapp::v1::DeleteReplicationRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::DeleteReplication");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteReplication(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::DeleteReplication(
    NoAwaitTag,
    google::cloud::netapp::v1::DeleteReplicationRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::DeleteReplication");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteReplication(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppTracingConnection::DeleteReplication(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::DeleteReplication");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteReplication(operation));
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppTracingConnection::UpdateReplication(
    google::cloud::netapp::v1::UpdateReplicationRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::UpdateReplication");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateReplication(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::UpdateReplication(
    NoAwaitTag,
    google::cloud::netapp::v1::UpdateReplicationRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::UpdateReplication");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateReplication(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppTracingConnection::UpdateReplication(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::UpdateReplication");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateReplication(operation));
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppTracingConnection::StopReplication(
    google::cloud::netapp::v1::StopReplicationRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::StopReplication");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->StopReplication(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::StopReplication(
    NoAwaitTag,
    google::cloud::netapp::v1::StopReplicationRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::StopReplication");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->StopReplication(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppTracingConnection::StopReplication(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::StopReplication");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->StopReplication(operation));
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppTracingConnection::ResumeReplication(
    google::cloud::netapp::v1::ResumeReplicationRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::ResumeReplication");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ResumeReplication(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::ResumeReplication(
    NoAwaitTag,
    google::cloud::netapp::v1::ResumeReplicationRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::ResumeReplication");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->ResumeReplication(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppTracingConnection::ResumeReplication(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::ResumeReplication");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->ResumeReplication(operation));
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppTracingConnection::ReverseReplicationDirection(
    google::cloud::netapp::v1::ReverseReplicationDirectionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "netapp_v1::NetAppConnection::ReverseReplicationDirection");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->ReverseReplicationDirection(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::ReverseReplicationDirection(
    NoAwaitTag,
    google::cloud::netapp::v1::ReverseReplicationDirectionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "netapp_v1::NetAppConnection::ReverseReplicationDirection");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->ReverseReplicationDirection(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppTracingConnection::ReverseReplicationDirection(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "netapp_v1::NetAppConnection::ReverseReplicationDirection");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->ReverseReplicationDirection(operation));
}

future<StatusOr<google::cloud::netapp::v1::BackupVault>>
NetAppTracingConnection::CreateBackupVault(
    google::cloud::netapp::v1::CreateBackupVaultRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::CreateBackupVault");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateBackupVault(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::CreateBackupVault(
    NoAwaitTag,
    google::cloud::netapp::v1::CreateBackupVaultRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::CreateBackupVault");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateBackupVault(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::BackupVault>>
NetAppTracingConnection::CreateBackupVault(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::CreateBackupVault");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateBackupVault(operation));
}

StatusOr<google::cloud::netapp::v1::BackupVault>
NetAppTracingConnection::GetBackupVault(
    google::cloud::netapp::v1::GetBackupVaultRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::GetBackupVault");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetBackupVault(request));
}

StreamRange<google::cloud::netapp::v1::BackupVault>
NetAppTracingConnection::ListBackupVaults(
    google::cloud::netapp::v1::ListBackupVaultsRequest request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::ListBackupVaults");
  internal::OTelScope scope(span);
  auto sr = child_->ListBackupVaults(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::netapp::v1::BackupVault>(std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::netapp::v1::BackupVault>>
NetAppTracingConnection::UpdateBackupVault(
    google::cloud::netapp::v1::UpdateBackupVaultRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::UpdateBackupVault");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateBackupVault(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::UpdateBackupVault(
    NoAwaitTag,
    google::cloud::netapp::v1::UpdateBackupVaultRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::UpdateBackupVault");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateBackupVault(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::BackupVault>>
NetAppTracingConnection::UpdateBackupVault(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::UpdateBackupVault");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateBackupVault(operation));
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppTracingConnection::DeleteBackupVault(
    google::cloud::netapp::v1::DeleteBackupVaultRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::DeleteBackupVault");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteBackupVault(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::DeleteBackupVault(
    NoAwaitTag,
    google::cloud::netapp::v1::DeleteBackupVaultRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::DeleteBackupVault");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteBackupVault(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppTracingConnection::DeleteBackupVault(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::DeleteBackupVault");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteBackupVault(operation));
}

future<StatusOr<google::cloud::netapp::v1::Backup>>
NetAppTracingConnection::CreateBackup(
    google::cloud::netapp::v1::CreateBackupRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::CreateBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateBackup(request));
}

StatusOr<google::longrunning::Operation> NetAppTracingConnection::CreateBackup(
    NoAwaitTag, google::cloud::netapp::v1::CreateBackupRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::CreateBackup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateBackup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::Backup>>
NetAppTracingConnection::CreateBackup(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::CreateBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateBackup(operation));
}

StatusOr<google::cloud::netapp::v1::Backup> NetAppTracingConnection::GetBackup(
    google::cloud::netapp::v1::GetBackupRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::GetBackup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetBackup(request));
}

StreamRange<google::cloud::netapp::v1::Backup>
NetAppTracingConnection::ListBackups(
    google::cloud::netapp::v1::ListBackupsRequest request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::ListBackups");
  internal::OTelScope scope(span);
  auto sr = child_->ListBackups(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::netapp::v1::Backup>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppTracingConnection::DeleteBackup(
    google::cloud::netapp::v1::DeleteBackupRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::DeleteBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteBackup(request));
}

StatusOr<google::longrunning::Operation> NetAppTracingConnection::DeleteBackup(
    NoAwaitTag, google::cloud::netapp::v1::DeleteBackupRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::DeleteBackup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteBackup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppTracingConnection::DeleteBackup(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::DeleteBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteBackup(operation));
}

future<StatusOr<google::cloud::netapp::v1::Backup>>
NetAppTracingConnection::UpdateBackup(
    google::cloud::netapp::v1::UpdateBackupRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::UpdateBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateBackup(request));
}

StatusOr<google::longrunning::Operation> NetAppTracingConnection::UpdateBackup(
    NoAwaitTag, google::cloud::netapp::v1::UpdateBackupRequest const& request) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::UpdateBackup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateBackup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::Backup>>
NetAppTracingConnection::UpdateBackup(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("netapp_v1::NetAppConnection::UpdateBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateBackup(operation));
}

future<StatusOr<google::cloud::netapp::v1::BackupPolicy>>
NetAppTracingConnection::CreateBackupPolicy(
    google::cloud::netapp::v1::CreateBackupPolicyRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::CreateBackupPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateBackupPolicy(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::CreateBackupPolicy(
    NoAwaitTag,
    google::cloud::netapp::v1::CreateBackupPolicyRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::CreateBackupPolicy");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateBackupPolicy(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::BackupPolicy>>
NetAppTracingConnection::CreateBackupPolicy(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::CreateBackupPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateBackupPolicy(operation));
}

StatusOr<google::cloud::netapp::v1::BackupPolicy>
NetAppTracingConnection::GetBackupPolicy(
    google::cloud::netapp::v1::GetBackupPolicyRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::GetBackupPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetBackupPolicy(request));
}

StreamRange<google::cloud::netapp::v1::BackupPolicy>
NetAppTracingConnection::ListBackupPolicies(
    google::cloud::netapp::v1::ListBackupPoliciesRequest request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::ListBackupPolicies");
  internal::OTelScope scope(span);
  auto sr = child_->ListBackupPolicies(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::netapp::v1::BackupPolicy>(std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::netapp::v1::BackupPolicy>>
NetAppTracingConnection::UpdateBackupPolicy(
    google::cloud::netapp::v1::UpdateBackupPolicyRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::UpdateBackupPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateBackupPolicy(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::UpdateBackupPolicy(
    NoAwaitTag,
    google::cloud::netapp::v1::UpdateBackupPolicyRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::UpdateBackupPolicy");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateBackupPolicy(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::BackupPolicy>>
NetAppTracingConnection::UpdateBackupPolicy(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::UpdateBackupPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateBackupPolicy(operation));
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppTracingConnection::DeleteBackupPolicy(
    google::cloud::netapp::v1::DeleteBackupPolicyRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::DeleteBackupPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteBackupPolicy(request));
}

StatusOr<google::longrunning::Operation>
NetAppTracingConnection::DeleteBackupPolicy(
    NoAwaitTag,
    google::cloud::netapp::v1::DeleteBackupPolicyRequest const& request) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::DeleteBackupPolicy");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteBackupPolicy(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppTracingConnection::DeleteBackupPolicy(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("netapp_v1::NetAppConnection::DeleteBackupPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteBackupPolicy(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<netapp_v1::NetAppConnection> MakeNetAppTracingConnection(
    std::shared_ptr<netapp_v1::NetAppConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<NetAppTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace netapp_v1_internal
}  // namespace cloud
}  // namespace google
