// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/kms/v1/autokey.proto

#include "google/cloud/kms/v1/autokey_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace kms_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AutokeyClient::AutokeyClient(std::shared_ptr<AutokeyConnection> connection,
                             Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
AutokeyClient::~AutokeyClient() = default;

future<StatusOr<google::cloud::kms::v1::KeyHandle>>
AutokeyClient::CreateKeyHandle(
    std::string const& parent,
    google::cloud::kms::v1::KeyHandle const& key_handle,
    std::string const& key_handle_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::kms::v1::CreateKeyHandleRequest request;
  request.set_parent(parent);
  *request.mutable_key_handle() = key_handle;
  request.set_key_handle_id(key_handle_id);
  return connection_->CreateKeyHandle(request);
}

StatusOr<google::longrunning::Operation> AutokeyClient::CreateKeyHandle(
    NoAwaitTag, std::string const& parent,
    google::cloud::kms::v1::KeyHandle const& key_handle,
    std::string const& key_handle_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::kms::v1::CreateKeyHandleRequest request;
  request.set_parent(parent);
  *request.mutable_key_handle() = key_handle;
  request.set_key_handle_id(key_handle_id);
  return connection_->CreateKeyHandle(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::kms::v1::KeyHandle>>
AutokeyClient::CreateKeyHandle(
    google::cloud::kms::v1::CreateKeyHandleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateKeyHandle(request);
}

StatusOr<google::longrunning::Operation> AutokeyClient::CreateKeyHandle(
    NoAwaitTag, google::cloud::kms::v1::CreateKeyHandleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateKeyHandle(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::kms::v1::KeyHandle>>
AutokeyClient::CreateKeyHandle(google::longrunning::Operation const& operation,
                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateKeyHandle(operation);
}

StatusOr<google::cloud::kms::v1::KeyHandle> AutokeyClient::GetKeyHandle(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::kms::v1::GetKeyHandleRequest request;
  request.set_name(name);
  return connection_->GetKeyHandle(request);
}

StatusOr<google::cloud::kms::v1::KeyHandle> AutokeyClient::GetKeyHandle(
    google::cloud::kms::v1::GetKeyHandleRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetKeyHandle(request);
}

StreamRange<google::cloud::kms::v1::KeyHandle> AutokeyClient::ListKeyHandles(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::kms::v1::ListKeyHandlesRequest request;
  request.set_parent(parent);
  return connection_->ListKeyHandles(request);
}

StreamRange<google::cloud::kms::v1::KeyHandle> AutokeyClient::ListKeyHandles(
    google::cloud::kms::v1::ListKeyHandlesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListKeyHandles(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace kms_v1
}  // namespace cloud
}  // namespace google
