// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/session_templates.proto

#include "google/cloud/dataproc/v1/internal/session_template_controller_connection_impl.h"
#include "google/cloud/dataproc/v1/internal/session_template_controller_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataproc_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<dataproc_v1::SessionTemplateControllerRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<dataproc_v1::SessionTemplateControllerRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<dataproc_v1::SessionTemplateControllerBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<
    dataproc_v1::SessionTemplateControllerConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<dataproc_v1::
               SessionTemplateControllerConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

SessionTemplateControllerConnectionImpl::
    SessionTemplateControllerConnectionImpl(
        std::unique_ptr<google::cloud::BackgroundThreads> background,
        std::shared_ptr<dataproc_v1_internal::SessionTemplateControllerStub>
            stub,
        Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), SessionTemplateControllerConnection::options())) {
}

StatusOr<google::cloud::dataproc::v1::SessionTemplate>
SessionTemplateControllerConnectionImpl::CreateSessionTemplate(
    google::cloud::dataproc::v1::CreateSessionTemplateRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateSessionTemplate(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataproc::v1::CreateSessionTemplateRequest const&
                 request) {
        return stub_->CreateSessionTemplate(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::dataproc::v1::SessionTemplate>
SessionTemplateControllerConnectionImpl::UpdateSessionTemplate(
    google::cloud::dataproc::v1::UpdateSessionTemplateRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateSessionTemplate(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataproc::v1::UpdateSessionTemplateRequest const&
                 request) {
        return stub_->UpdateSessionTemplate(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::dataproc::v1::SessionTemplate>
SessionTemplateControllerConnectionImpl::GetSessionTemplate(
    google::cloud::dataproc::v1::GetSessionTemplateRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetSessionTemplate(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataproc::v1::GetSessionTemplateRequest const&
                 request) {
        return stub_->GetSessionTemplate(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::dataproc::v1::SessionTemplate>
SessionTemplateControllerConnectionImpl::ListSessionTemplates(
    google::cloud::dataproc::v1::ListSessionTemplatesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListSessionTemplates(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataproc::v1::SessionTemplate>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<dataproc_v1::SessionTemplateControllerRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::dataproc::v1::ListSessionTemplatesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::dataproc::v1::ListSessionTemplatesRequest const&
                    request) {
              return stub->ListSessionTemplates(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::dataproc::v1::ListSessionTemplatesResponse r) {
        std::vector<google::cloud::dataproc::v1::SessionTemplate> result(
            r.session_templates().size());
        auto& messages = *r.mutable_session_templates();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

Status SessionTemplateControllerConnectionImpl::DeleteSessionTemplate(
    google::cloud::dataproc::v1::DeleteSessionTemplateRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteSessionTemplate(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataproc::v1::DeleteSessionTemplateRequest const&
                 request) {
        return stub_->DeleteSessionTemplate(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1_internal
}  // namespace cloud
}  // namespace google
