// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/http_health_checks/v1/http_health_checks.proto

#include "google/cloud/compute/http_health_checks/v1/internal/http_health_checks_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_http_health_checks_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

HttpHealthChecksTracingConnection::HttpHealthChecksTracingConnection(
    std::shared_ptr<compute_http_health_checks_v1::HttpHealthChecksConnection>
        child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpHealthChecksTracingConnection::DeleteHttpHealthCheck(
    google::cloud::cpp::compute::http_health_checks::v1::
        DeleteHttpHealthCheckRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_http_health_checks_v1::HttpHealthChecksConnection::"
      "DeleteHttpHealthCheck");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteHttpHealthCheck(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
HttpHealthChecksTracingConnection::DeleteHttpHealthCheck(
    NoAwaitTag, google::cloud::cpp::compute::http_health_checks::v1::
                    DeleteHttpHealthCheckRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_http_health_checks_v1::HttpHealthChecksConnection::"
      "DeleteHttpHealthCheck");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeleteHttpHealthCheck(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpHealthChecksTracingConnection::DeleteHttpHealthCheck(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_http_health_checks_v1::HttpHealthChecksConnection::"
      "DeleteHttpHealthCheck");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteHttpHealthCheck(operation));
}

StatusOr<google::cloud::cpp::compute::v1::HttpHealthCheck>
HttpHealthChecksTracingConnection::GetHttpHealthCheck(
    google::cloud::cpp::compute::http_health_checks::v1::
        GetHttpHealthCheckRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_http_health_checks_v1::HttpHealthChecksConnection::"
      "GetHttpHealthCheck");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetHttpHealthCheck(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpHealthChecksTracingConnection::InsertHttpHealthCheck(
    google::cloud::cpp::compute::http_health_checks::v1::
        InsertHttpHealthCheckRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_http_health_checks_v1::HttpHealthChecksConnection::"
      "InsertHttpHealthCheck");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->InsertHttpHealthCheck(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
HttpHealthChecksTracingConnection::InsertHttpHealthCheck(
    NoAwaitTag, google::cloud::cpp::compute::http_health_checks::v1::
                    InsertHttpHealthCheckRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_http_health_checks_v1::HttpHealthChecksConnection::"
      "InsertHttpHealthCheck");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->InsertHttpHealthCheck(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpHealthChecksTracingConnection::InsertHttpHealthCheck(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_http_health_checks_v1::HttpHealthChecksConnection::"
      "InsertHttpHealthCheck");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->InsertHttpHealthCheck(operation));
}

StreamRange<google::cloud::cpp::compute::v1::HttpHealthCheck>
HttpHealthChecksTracingConnection::ListHttpHealthChecks(
    google::cloud::cpp::compute::http_health_checks::v1::
        ListHttpHealthChecksRequest request) {
  auto span = internal::MakeSpan(
      "compute_http_health_checks_v1::HttpHealthChecksConnection::"
      "ListHttpHealthChecks");
  internal::OTelScope scope(span);
  auto sr = child_->ListHttpHealthChecks(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::HttpHealthCheck>(std::move(span),
                                                        std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpHealthChecksTracingConnection::PatchHttpHealthCheck(
    google::cloud::cpp::compute::http_health_checks::v1::
        PatchHttpHealthCheckRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_http_health_checks_v1::HttpHealthChecksConnection::"
      "PatchHttpHealthCheck");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->PatchHttpHealthCheck(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
HttpHealthChecksTracingConnection::PatchHttpHealthCheck(
    NoAwaitTag, google::cloud::cpp::compute::http_health_checks::v1::
                    PatchHttpHealthCheckRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_http_health_checks_v1::HttpHealthChecksConnection::"
      "PatchHttpHealthCheck");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->PatchHttpHealthCheck(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpHealthChecksTracingConnection::PatchHttpHealthCheck(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_http_health_checks_v1::HttpHealthChecksConnection::"
      "PatchHttpHealthCheck");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->PatchHttpHealthCheck(operation));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpHealthChecksTracingConnection::UpdateHttpHealthCheck(
    google::cloud::cpp::compute::http_health_checks::v1::
        UpdateHttpHealthCheckRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_http_health_checks_v1::HttpHealthChecksConnection::"
      "UpdateHttpHealthCheck");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateHttpHealthCheck(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
HttpHealthChecksTracingConnection::UpdateHttpHealthCheck(
    NoAwaitTag, google::cloud::cpp::compute::http_health_checks::v1::
                    UpdateHttpHealthCheckRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_http_health_checks_v1::HttpHealthChecksConnection::"
      "UpdateHttpHealthCheck");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->UpdateHttpHealthCheck(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpHealthChecksTracingConnection::UpdateHttpHealthCheck(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_http_health_checks_v1::HttpHealthChecksConnection::"
      "UpdateHttpHealthCheck");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateHttpHealthCheck(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_http_health_checks_v1::HttpHealthChecksConnection>
MakeHttpHealthChecksTracingConnection(
    std::shared_ptr<compute_http_health_checks_v1::HttpHealthChecksConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<HttpHealthChecksTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_http_health_checks_v1_internal
}  // namespace cloud
}  // namespace google
