// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/storage/v1/storage.proto

#include "google/cloud/bigquery/storage/v1/bigquery_write_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquery_storage_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BigQueryWriteClient::BigQueryWriteClient(
    std::shared_ptr<BigQueryWriteConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
BigQueryWriteClient::~BigQueryWriteClient() = default;

StatusOr<google::cloud::bigquery::storage::v1::WriteStream>
BigQueryWriteClient::CreateWriteStream(
    std::string const& parent,
    google::cloud::bigquery::storage::v1::WriteStream const& write_stream,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::storage::v1::CreateWriteStreamRequest request;
  request.set_parent(parent);
  *request.mutable_write_stream() = write_stream;
  return connection_->CreateWriteStream(request);
}

StatusOr<google::cloud::bigquery::storage::v1::WriteStream>
BigQueryWriteClient::CreateWriteStream(
    google::cloud::bigquery::storage::v1::CreateWriteStreamRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateWriteStream(request);
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::cloud::bigquery::storage::v1::AppendRowsRequest,
    google::cloud::bigquery::storage::v1::AppendRowsResponse>>
BigQueryWriteClient::AsyncAppendRows(Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AsyncAppendRows();
}

StatusOr<google::cloud::bigquery::storage::v1::WriteStream>
BigQueryWriteClient::GetWriteStream(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::storage::v1::GetWriteStreamRequest request;
  request.set_name(name);
  return connection_->GetWriteStream(request);
}

StatusOr<google::cloud::bigquery::storage::v1::WriteStream>
BigQueryWriteClient::GetWriteStream(
    google::cloud::bigquery::storage::v1::GetWriteStreamRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetWriteStream(request);
}

StatusOr<google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>
BigQueryWriteClient::FinalizeWriteStream(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest request;
  request.set_name(name);
  return connection_->FinalizeWriteStream(request);
}

StatusOr<google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>
BigQueryWriteClient::FinalizeWriteStream(
    google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->FinalizeWriteStream(request);
}

StatusOr<google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>
BigQueryWriteClient::BatchCommitWriteStreams(std::string const& parent,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest request;
  request.set_parent(parent);
  return connection_->BatchCommitWriteStreams(request);
}

StatusOr<google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>
BigQueryWriteClient::BatchCommitWriteStreams(
    google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchCommitWriteStreams(request);
}

StatusOr<google::cloud::bigquery::storage::v1::FlushRowsResponse>
BigQueryWriteClient::FlushRows(std::string const& write_stream, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::storage::v1::FlushRowsRequest request;
  request.set_write_stream(write_stream);
  return connection_->FlushRows(request);
}

StatusOr<google::cloud::bigquery::storage::v1::FlushRowsResponse>
BigQueryWriteClient::FlushRows(
    google::cloud::bigquery::storage::v1::FlushRowsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->FlushRows(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_storage_v1
}  // namespace cloud
}  // namespace google
