// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/job_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_JOB_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_JOB_CLIENT_H

#include "google/cloud/aiplatform/v1/job_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// A service for creating and managing Vertex AI's jobs.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class JobServiceClient {
 public:
  explicit JobServiceClient(std::shared_ptr<JobServiceConnection> connection,
                            Options opts = {});
  ~JobServiceClient();

  ///@{
  /// @name Copy and move support
  JobServiceClient(JobServiceClient const&) = default;
  JobServiceClient& operator=(JobServiceClient const&) = default;
  JobServiceClient(JobServiceClient&&) = default;
  JobServiceClient& operator=(JobServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(JobServiceClient const& a, JobServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(JobServiceClient const& a, JobServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a CustomJob. A created CustomJob right away
  /// will be attempted to be run.
  ///
  /// @param parent  Required. The resource name of the Location to create the CustomJob in.
  ///  Format: `projects/{project}/locations/{location}`
  /// @param custom_job  Required. The CustomJob to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.CustomJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateCustomJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L467}
  /// [google.cloud.aiplatform.v1.CustomJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/custom_job.proto#L42}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::CustomJob> CreateCustomJob(
      std::string const& parent,
      google::cloud::aiplatform::v1::CustomJob const& custom_job,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a CustomJob. A created CustomJob right away
  /// will be attempted to be run.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateCustomJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.CustomJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateCustomJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L467}
  /// [google.cloud.aiplatform.v1.CustomJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/custom_job.proto#L42}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::CustomJob> CreateCustomJob(
      google::cloud::aiplatform::v1::CreateCustomJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a CustomJob.
  ///
  /// @param name  Required. The name of the CustomJob resource.
  ///  Format:
  ///  `projects/{project}/locations/{location}/customJobs/{custom_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.CustomJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CustomJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/custom_job.proto#L42}
  /// [google.cloud.aiplatform.v1.GetCustomJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L483}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::CustomJob> GetCustomJob(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a CustomJob.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetCustomJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.CustomJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CustomJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/custom_job.proto#L42}
  /// [google.cloud.aiplatform.v1.GetCustomJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L483}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::CustomJob> GetCustomJob(
      google::cloud::aiplatform::v1::GetCustomJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists CustomJobs in a Location.
  ///
  /// @param parent  Required. The resource name of the Location to list the CustomJobs from.
  ///  Format: `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.CustomJob], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CustomJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/custom_job.proto#L42}
  /// [google.cloud.aiplatform.v1.ListCustomJobsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L497}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::CustomJob> ListCustomJobs(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists CustomJobs in a Location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListCustomJobsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.CustomJob], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CustomJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/custom_job.proto#L42}
  /// [google.cloud.aiplatform.v1.ListCustomJobsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L497}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::CustomJob> ListCustomJobs(
      google::cloud::aiplatform::v1::ListCustomJobsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a CustomJob.
  ///
  /// @param name  Required. The name of the CustomJob resource to be deleted.
  ///  Format:
  ///  `projects/{project}/locations/{location}/customJobs/{custom_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteCustomJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L559}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteCustomJob(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCustomJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteCustomJob(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a CustomJob.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteCustomJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteCustomJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L559}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteCustomJob(
      google::cloud::aiplatform::v1::DeleteCustomJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCustomJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteCustomJob(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteCustomJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCustomJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteCustomJob(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Cancels a CustomJob.
  /// Starts asynchronous cancellation on the CustomJob. The server
  /// makes a best effort to cancel the job, but success is not
  /// guaranteed. Clients can use
  /// [JobService.GetCustomJob][google.cloud.aiplatform.v1.JobService.GetCustomJob]
  /// or other methods to check whether the cancellation succeeded or whether the
  /// job completed despite cancellation. On successful cancellation,
  /// the CustomJob is not deleted; instead it becomes a job with
  /// a [CustomJob.error][google.cloud.aiplatform.v1.CustomJob.error] value with
  /// a [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
  /// `Code.CANCELLED`, and
  /// [CustomJob.state][google.cloud.aiplatform.v1.CustomJob.state] is set to
  /// `CANCELLED`.
  ///
  /// @param name  Required. The name of the CustomJob to cancel.
  ///  Format:
  ///  `projects/{project}/locations/{location}/customJobs/{custom_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CancelCustomJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L573}
  /// [google.cloud.aiplatform.v1.CustomJob.error]: @googleapis_reference_link{google/cloud/aiplatform/v1/custom_job.proto#L82}
  /// [google.cloud.aiplatform.v1.CustomJob.state]: @googleapis_reference_link{google/cloud/aiplatform/v1/custom_job.proto#L60}
  /// [google.cloud.aiplatform.v1.JobService.GetCustomJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L61}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelCustomJob(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Cancels a CustomJob.
  /// Starts asynchronous cancellation on the CustomJob. The server
  /// makes a best effort to cancel the job, but success is not
  /// guaranteed. Clients can use
  /// [JobService.GetCustomJob][google.cloud.aiplatform.v1.JobService.GetCustomJob]
  /// or other methods to check whether the cancellation succeeded or whether the
  /// job completed despite cancellation. On successful cancellation,
  /// the CustomJob is not deleted; instead it becomes a job with
  /// a [CustomJob.error][google.cloud.aiplatform.v1.CustomJob.error] value with
  /// a [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
  /// `Code.CANCELLED`, and
  /// [CustomJob.state][google.cloud.aiplatform.v1.CustomJob.state] is set to
  /// `CANCELLED`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CancelCustomJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CancelCustomJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L573}
  /// [google.cloud.aiplatform.v1.CustomJob.error]: @googleapis_reference_link{google/cloud/aiplatform/v1/custom_job.proto#L82}
  /// [google.cloud.aiplatform.v1.CustomJob.state]: @googleapis_reference_link{google/cloud/aiplatform/v1/custom_job.proto#L60}
  /// [google.cloud.aiplatform.v1.JobService.GetCustomJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L61}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelCustomJob(
      google::cloud::aiplatform::v1::CancelCustomJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a DataLabelingJob.
  ///
  /// @param parent  Required. The parent of the DataLabelingJob.
  ///  Format: `projects/{project}/locations/{location}`
  /// @param data_labeling_job  Required. The DataLabelingJob to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.DataLabelingJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateDataLabelingJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L587}
  /// [google.cloud.aiplatform.v1.DataLabelingJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/data_labeling_job.proto#L38}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::DataLabelingJob>
  CreateDataLabelingJob(
      std::string const& parent,
      google::cloud::aiplatform::v1::DataLabelingJob const& data_labeling_job,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a DataLabelingJob.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateDataLabelingJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.DataLabelingJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateDataLabelingJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L587}
  /// [google.cloud.aiplatform.v1.DataLabelingJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/data_labeling_job.proto#L38}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::DataLabelingJob>
  CreateDataLabelingJob(
      google::cloud::aiplatform::v1::CreateDataLabelingJobRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a DataLabelingJob.
  ///
  /// @param name  Required. The name of the DataLabelingJob.
  ///  Format:
  ///  `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.DataLabelingJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DataLabelingJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/data_labeling_job.proto#L38}
  /// [google.cloud.aiplatform.v1.GetDataLabelingJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L604}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::DataLabelingJob> GetDataLabelingJob(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a DataLabelingJob.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetDataLabelingJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.DataLabelingJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DataLabelingJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/data_labeling_job.proto#L38}
  /// [google.cloud.aiplatform.v1.GetDataLabelingJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L604}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::DataLabelingJob> GetDataLabelingJob(
      google::cloud::aiplatform::v1::GetDataLabelingJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists DataLabelingJobs in a Location.
  ///
  /// @param parent  Required. The parent of the DataLabelingJob.
  ///  Format: `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.DataLabelingJob], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DataLabelingJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/data_labeling_job.proto#L38}
  /// [google.cloud.aiplatform.v1.ListDataLabelingJobsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L618}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::DataLabelingJob>
  ListDataLabelingJobs(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists DataLabelingJobs in a Location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListDataLabelingJobsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.DataLabelingJob], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DataLabelingJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/data_labeling_job.proto#L38}
  /// [google.cloud.aiplatform.v1.ListDataLabelingJobsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L618}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::DataLabelingJob>
  ListDataLabelingJobs(
      google::cloud::aiplatform::v1::ListDataLabelingJobsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a DataLabelingJob.
  ///
  /// @param name  Required. The name of the DataLabelingJob to be deleted.
  ///  Format:
  ///  `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteDataLabelingJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L681}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteDataLabelingJob(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteDataLabelingJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteDataLabelingJob(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a DataLabelingJob.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteDataLabelingJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteDataLabelingJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L681}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteDataLabelingJob(
      google::cloud::aiplatform::v1::DeleteDataLabelingJobRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteDataLabelingJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteDataLabelingJob(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteDataLabelingJobRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteDataLabelingJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteDataLabelingJob(google::longrunning::Operation const& operation,
                        Options opts = {});

  // clang-format off
  ///
  /// Cancels a DataLabelingJob. Success of cancellation is not guaranteed.
  ///
  /// @param name  Required. The name of the DataLabelingJob.
  ///  Format:
  ///  `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CancelDataLabelingJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L695}
  ///
  // clang-format on
  Status CancelDataLabelingJob(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Cancels a DataLabelingJob. Success of cancellation is not guaranteed.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CancelDataLabelingJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CancelDataLabelingJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L695}
  ///
  // clang-format on
  Status CancelDataLabelingJob(
      google::cloud::aiplatform::v1::CancelDataLabelingJobRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a HyperparameterTuningJob
  ///
  /// @param parent  Required. The resource name of the Location to create the
  ///  HyperparameterTuningJob in. Format:
  ///  `projects/{project}/locations/{location}`
  /// @param hyperparameter_tuning_job  Required. The HyperparameterTuningJob to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.HyperparameterTuningJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateHyperparameterTuningJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L709}
  /// [google.cloud.aiplatform.v1.HyperparameterTuningJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/hyperparameter_tuning_job.proto#L39}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::HyperparameterTuningJob>
  CreateHyperparameterTuningJob(
      std::string const& parent,
      google::cloud::aiplatform::v1::HyperparameterTuningJob const&
          hyperparameter_tuning_job,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a HyperparameterTuningJob
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateHyperparameterTuningJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.HyperparameterTuningJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateHyperparameterTuningJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L709}
  /// [google.cloud.aiplatform.v1.HyperparameterTuningJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/hyperparameter_tuning_job.proto#L39}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::HyperparameterTuningJob>
  CreateHyperparameterTuningJob(
      google::cloud::aiplatform::v1::CreateHyperparameterTuningJobRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a HyperparameterTuningJob
  ///
  /// @param name  Required. The name of the HyperparameterTuningJob resource.
  ///  Format:
  ///  `projects/{project}/locations/{location}/hyperparameterTuningJobs/{hyperparameter_tuning_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.HyperparameterTuningJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetHyperparameterTuningJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L727}
  /// [google.cloud.aiplatform.v1.HyperparameterTuningJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/hyperparameter_tuning_job.proto#L39}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::HyperparameterTuningJob>
  GetHyperparameterTuningJob(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a HyperparameterTuningJob
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetHyperparameterTuningJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.HyperparameterTuningJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetHyperparameterTuningJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L727}
  /// [google.cloud.aiplatform.v1.HyperparameterTuningJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/hyperparameter_tuning_job.proto#L39}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::HyperparameterTuningJob>
  GetHyperparameterTuningJob(
      google::cloud::aiplatform::v1::GetHyperparameterTuningJobRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists HyperparameterTuningJobs in a Location.
  ///
  /// @param parent  Required. The resource name of the Location to list the
  ///  HyperparameterTuningJobs from. Format:
  ///  `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.HyperparameterTuningJob], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.HyperparameterTuningJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/hyperparameter_tuning_job.proto#L39}
  /// [google.cloud.aiplatform.v1.ListHyperparameterTuningJobsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L741}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::HyperparameterTuningJob>
  ListHyperparameterTuningJobs(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists HyperparameterTuningJobs in a Location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListHyperparameterTuningJobsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.HyperparameterTuningJob], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.HyperparameterTuningJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/hyperparameter_tuning_job.proto#L39}
  /// [google.cloud.aiplatform.v1.ListHyperparameterTuningJobsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L741}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::HyperparameterTuningJob>
  ListHyperparameterTuningJobs(
      google::cloud::aiplatform::v1::ListHyperparameterTuningJobsRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a HyperparameterTuningJob.
  ///
  /// @param name  Required. The name of the HyperparameterTuningJob resource to be deleted.
  ///  Format:
  ///  `projects/{project}/locations/{location}/hyperparameterTuningJobs/{hyperparameter_tuning_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteHyperparameterTuningJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L806}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteHyperparameterTuningJob(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteHyperparameterTuningJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteHyperparameterTuningJob(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a HyperparameterTuningJob.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteHyperparameterTuningJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteHyperparameterTuningJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L806}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteHyperparameterTuningJob(
      google::cloud::aiplatform::v1::DeleteHyperparameterTuningJobRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteHyperparameterTuningJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteHyperparameterTuningJob(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteHyperparameterTuningJobRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteHyperparameterTuningJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteHyperparameterTuningJob(google::longrunning::Operation const& operation,
                                Options opts = {});

  // clang-format off
  ///
  /// Cancels a HyperparameterTuningJob.
  /// Starts asynchronous cancellation on the HyperparameterTuningJob. The server
  /// makes a best effort to cancel the job, but success is not
  /// guaranteed. Clients can use
  /// [JobService.GetHyperparameterTuningJob][google.cloud.aiplatform.v1.JobService.GetHyperparameterTuningJob]
  /// or other methods to check whether the cancellation succeeded or whether the
  /// job completed despite cancellation. On successful cancellation,
  /// the HyperparameterTuningJob is not deleted; instead it becomes a job with
  /// a
  /// [HyperparameterTuningJob.error][google.cloud.aiplatform.v1.HyperparameterTuningJob.error]
  /// value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
  /// corresponding to `Code.CANCELLED`, and
  /// [HyperparameterTuningJob.state][google.cloud.aiplatform.v1.HyperparameterTuningJob.state]
  /// is set to `CANCELLED`.
  ///
  /// @param name  Required. The name of the HyperparameterTuningJob to cancel.
  ///  Format:
  ///  `projects/{project}/locations/{location}/hyperparameterTuningJobs/{hyperparameter_tuning_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CancelHyperparameterTuningJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L820}
  /// [google.cloud.aiplatform.v1.HyperparameterTuningJob.error]: @googleapis_reference_link{google/cloud/aiplatform/v1/hyperparameter_tuning_job.proto#L101}
  /// [google.cloud.aiplatform.v1.HyperparameterTuningJob.state]: @googleapis_reference_link{google/cloud/aiplatform/v1/hyperparameter_tuning_job.proto#L77}
  /// [google.cloud.aiplatform.v1.JobService.GetHyperparameterTuningJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L171}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelHyperparameterTuningJob(std::string const& name,
                                       Options opts = {});

  // clang-format off
  ///
  /// Cancels a HyperparameterTuningJob.
  /// Starts asynchronous cancellation on the HyperparameterTuningJob. The server
  /// makes a best effort to cancel the job, but success is not
  /// guaranteed. Clients can use
  /// [JobService.GetHyperparameterTuningJob][google.cloud.aiplatform.v1.JobService.GetHyperparameterTuningJob]
  /// or other methods to check whether the cancellation succeeded or whether the
  /// job completed despite cancellation. On successful cancellation,
  /// the HyperparameterTuningJob is not deleted; instead it becomes a job with
  /// a
  /// [HyperparameterTuningJob.error][google.cloud.aiplatform.v1.HyperparameterTuningJob.error]
  /// value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
  /// corresponding to `Code.CANCELLED`, and
  /// [HyperparameterTuningJob.state][google.cloud.aiplatform.v1.HyperparameterTuningJob.state]
  /// is set to `CANCELLED`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CancelHyperparameterTuningJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CancelHyperparameterTuningJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L820}
  /// [google.cloud.aiplatform.v1.HyperparameterTuningJob.error]: @googleapis_reference_link{google/cloud/aiplatform/v1/hyperparameter_tuning_job.proto#L101}
  /// [google.cloud.aiplatform.v1.HyperparameterTuningJob.state]: @googleapis_reference_link{google/cloud/aiplatform/v1/hyperparameter_tuning_job.proto#L77}
  /// [google.cloud.aiplatform.v1.JobService.GetHyperparameterTuningJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L171}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelHyperparameterTuningJob(
      google::cloud::aiplatform::v1::CancelHyperparameterTuningJobRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a NasJob
  ///
  /// @param parent  Required. The resource name of the Location to create the NasJob in.
  ///  Format: `projects/{project}/locations/{location}`
  /// @param nas_job  Required. The NasJob to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.NasJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateNasJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L834}
  /// [google.cloud.aiplatform.v1.NasJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/nas_job.proto#L37}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::NasJob> CreateNasJob(
      std::string const& parent,
      google::cloud::aiplatform::v1::NasJob const& nas_job, Options opts = {});

  // clang-format off
  ///
  /// Creates a NasJob
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateNasJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.NasJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateNasJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L834}
  /// [google.cloud.aiplatform.v1.NasJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/nas_job.proto#L37}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::NasJob> CreateNasJob(
      google::cloud::aiplatform::v1::CreateNasJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a NasJob
  ///
  /// @param name  Required. The name of the NasJob resource.
  ///  Format:
  ///  `projects/{project}/locations/{location}/nasJobs/{nas_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.NasJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetNasJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L850}
  /// [google.cloud.aiplatform.v1.NasJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/nas_job.proto#L37}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::NasJob> GetNasJob(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a NasJob
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetNasJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.NasJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetNasJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L850}
  /// [google.cloud.aiplatform.v1.NasJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/nas_job.proto#L37}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::NasJob> GetNasJob(
      google::cloud::aiplatform::v1::GetNasJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists NasJobs in a Location.
  ///
  /// @param parent  Required. The resource name of the Location to list the NasJobs
  ///  from. Format: `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.NasJob], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListNasJobsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L864}
  /// [google.cloud.aiplatform.v1.NasJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/nas_job.proto#L37}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::NasJob> ListNasJobs(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists NasJobs in a Location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListNasJobsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.NasJob], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListNasJobsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L864}
  /// [google.cloud.aiplatform.v1.NasJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/nas_job.proto#L37}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::NasJob> ListNasJobs(
      google::cloud::aiplatform::v1::ListNasJobsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a NasJob.
  ///
  /// @param name  Required. The name of the NasJob resource to be deleted.
  ///  Format:
  ///  `projects/{project}/locations/{location}/nasJobs/{nas_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteNasJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L928}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteNasJob(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteNasJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteNasJob(NoAwaitTag,
                                                        std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Deletes a NasJob.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteNasJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteNasJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L928}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteNasJob(
      google::cloud::aiplatform::v1::DeleteNasJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteNasJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteNasJob(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteNasJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteNasJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteNasJob(google::longrunning::Operation const& operation,
               Options opts = {});

  // clang-format off
  ///
  /// Cancels a NasJob.
  /// Starts asynchronous cancellation on the NasJob. The server
  /// makes a best effort to cancel the job, but success is not
  /// guaranteed. Clients can use
  /// [JobService.GetNasJob][google.cloud.aiplatform.v1.JobService.GetNasJob] or
  /// other methods to check whether the cancellation succeeded or whether the
  /// job completed despite cancellation. On successful cancellation,
  /// the NasJob is not deleted; instead it becomes a job with
  /// a [NasJob.error][google.cloud.aiplatform.v1.NasJob.error] value with a
  /// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
  /// `Code.CANCELLED`, and
  /// [NasJob.state][google.cloud.aiplatform.v1.NasJob.state] is set to
  /// `CANCELLED`.
  ///
  /// @param name  Required. The name of the NasJob to cancel.
  ///  Format:
  ///  `projects/{project}/locations/{location}/nasJobs/{nas_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CancelNasJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L942}
  /// [google.cloud.aiplatform.v1.JobService.GetNasJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L234}
  /// [google.cloud.aiplatform.v1.NasJob.error]: @googleapis_reference_link{google/cloud/aiplatform/v1/nas_job.proto#L80}
  /// [google.cloud.aiplatform.v1.NasJob.state]: @googleapis_reference_link{google/cloud/aiplatform/v1/nas_job.proto#L58}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelNasJob(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Cancels a NasJob.
  /// Starts asynchronous cancellation on the NasJob. The server
  /// makes a best effort to cancel the job, but success is not
  /// guaranteed. Clients can use
  /// [JobService.GetNasJob][google.cloud.aiplatform.v1.JobService.GetNasJob] or
  /// other methods to check whether the cancellation succeeded or whether the
  /// job completed despite cancellation. On successful cancellation,
  /// the NasJob is not deleted; instead it becomes a job with
  /// a [NasJob.error][google.cloud.aiplatform.v1.NasJob.error] value with a
  /// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
  /// `Code.CANCELLED`, and
  /// [NasJob.state][google.cloud.aiplatform.v1.NasJob.state] is set to
  /// `CANCELLED`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CancelNasJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CancelNasJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L942}
  /// [google.cloud.aiplatform.v1.JobService.GetNasJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L234}
  /// [google.cloud.aiplatform.v1.NasJob.error]: @googleapis_reference_link{google/cloud/aiplatform/v1/nas_job.proto#L80}
  /// [google.cloud.aiplatform.v1.NasJob.state]: @googleapis_reference_link{google/cloud/aiplatform/v1/nas_job.proto#L58}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelNasJob(
      google::cloud::aiplatform::v1::CancelNasJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a NasTrialDetail.
  ///
  /// @param name  Required. The name of the NasTrialDetail resource.
  ///  Format:
  ///  `projects/{project}/locations/{location}/nasJobs/{nas_job}/nasTrialDetails/{nas_trial_detail}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.NasTrialDetail])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetNasTrialDetailRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L956}
  /// [google.cloud.aiplatform.v1.NasTrialDetail]: @googleapis_reference_link{google/cloud/aiplatform/v1/nas_job.proto#L110}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::NasTrialDetail> GetNasTrialDetail(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a NasTrialDetail.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetNasTrialDetailRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.NasTrialDetail])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetNasTrialDetailRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L956}
  /// [google.cloud.aiplatform.v1.NasTrialDetail]: @googleapis_reference_link{google/cloud/aiplatform/v1/nas_job.proto#L110}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::NasTrialDetail> GetNasTrialDetail(
      google::cloud::aiplatform::v1::GetNasTrialDetailRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List top NasTrialDetails of a NasJob.
  ///
  /// @param parent  Required. The name of the NasJob resource.
  ///  Format:
  ///  `projects/{project}/locations/{location}/nasJobs/{nas_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.NasTrialDetail], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListNasTrialDetailsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L970}
  /// [google.cloud.aiplatform.v1.NasTrialDetail]: @googleapis_reference_link{google/cloud/aiplatform/v1/nas_job.proto#L110}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::NasTrialDetail>
  ListNasTrialDetails(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List top NasTrialDetails of a NasJob.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListNasTrialDetailsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.NasTrialDetail], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListNasTrialDetailsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L970}
  /// [google.cloud.aiplatform.v1.NasTrialDetail]: @googleapis_reference_link{google/cloud/aiplatform/v1/nas_job.proto#L110}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::NasTrialDetail>
  ListNasTrialDetails(
      google::cloud::aiplatform::v1::ListNasTrialDetailsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a BatchPredictionJob. A BatchPredictionJob once created will
  /// right away be attempted to start.
  ///
  /// @param parent  Required. The resource name of the Location to create the
  ///  BatchPredictionJob in. Format: `projects/{project}/locations/{location}`
  /// @param batch_prediction_job  Required. The BatchPredictionJob to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.BatchPredictionJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.BatchPredictionJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/batch_prediction_job.proto#L47}
  /// [google.cloud.aiplatform.v1.CreateBatchPredictionJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1008}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::BatchPredictionJob>
  CreateBatchPredictionJob(
      std::string const& parent,
      google::cloud::aiplatform::v1::BatchPredictionJob const&
          batch_prediction_job,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a BatchPredictionJob. A BatchPredictionJob once created will
  /// right away be attempted to start.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateBatchPredictionJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.BatchPredictionJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.BatchPredictionJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/batch_prediction_job.proto#L47}
  /// [google.cloud.aiplatform.v1.CreateBatchPredictionJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1008}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::BatchPredictionJob>
  CreateBatchPredictionJob(
      google::cloud::aiplatform::v1::CreateBatchPredictionJobRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a BatchPredictionJob
  ///
  /// @param name  Required. The name of the BatchPredictionJob resource.
  ///  Format:
  ///  `projects/{project}/locations/{location}/batchPredictionJobs/{batch_prediction_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.BatchPredictionJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.BatchPredictionJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/batch_prediction_job.proto#L47}
  /// [google.cloud.aiplatform.v1.GetBatchPredictionJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1025}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::BatchPredictionJob>
  GetBatchPredictionJob(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a BatchPredictionJob
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetBatchPredictionJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.BatchPredictionJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.BatchPredictionJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/batch_prediction_job.proto#L47}
  /// [google.cloud.aiplatform.v1.GetBatchPredictionJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1025}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::BatchPredictionJob>
  GetBatchPredictionJob(
      google::cloud::aiplatform::v1::GetBatchPredictionJobRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists BatchPredictionJobs in a Location.
  ///
  /// @param parent  Required. The resource name of the Location to list the BatchPredictionJobs
  ///  from. Format: `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.BatchPredictionJob], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.BatchPredictionJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/batch_prediction_job.proto#L47}
  /// [google.cloud.aiplatform.v1.ListBatchPredictionJobsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1039}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::BatchPredictionJob>
  ListBatchPredictionJobs(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists BatchPredictionJobs in a Location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListBatchPredictionJobsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.BatchPredictionJob], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.BatchPredictionJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/batch_prediction_job.proto#L47}
  /// [google.cloud.aiplatform.v1.ListBatchPredictionJobsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1039}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::BatchPredictionJob>
  ListBatchPredictionJobs(
      google::cloud::aiplatform::v1::ListBatchPredictionJobsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a BatchPredictionJob. Can only be called on jobs that already
  /// finished.
  ///
  /// @param name  Required. The name of the BatchPredictionJob resource to be deleted.
  ///  Format:
  ///  `projects/{project}/locations/{location}/batchPredictionJobs/{batch_prediction_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteBatchPredictionJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1102}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteBatchPredictionJob(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteBatchPredictionJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteBatchPredictionJob(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a BatchPredictionJob. Can only be called on jobs that already
  /// finished.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteBatchPredictionJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteBatchPredictionJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1102}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteBatchPredictionJob(
      google::cloud::aiplatform::v1::DeleteBatchPredictionJobRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteBatchPredictionJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteBatchPredictionJob(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteBatchPredictionJobRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteBatchPredictionJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteBatchPredictionJob(google::longrunning::Operation const& operation,
                           Options opts = {});

  // clang-format off
  ///
  /// Cancels a BatchPredictionJob.
  ///
  /// Starts asynchronous cancellation on the BatchPredictionJob. The server
  /// makes the best effort to cancel the job, but success is not
  /// guaranteed. Clients can use
  /// [JobService.GetBatchPredictionJob][google.cloud.aiplatform.v1.JobService.GetBatchPredictionJob]
  /// or other methods to check whether the cancellation succeeded or whether the
  /// job completed despite cancellation. On a successful cancellation,
  /// the BatchPredictionJob is not deleted;instead its
  /// [BatchPredictionJob.state][google.cloud.aiplatform.v1.BatchPredictionJob.state]
  /// is set to `CANCELLED`. Any files already outputted by the job are not
  /// deleted.
  ///
  /// @param name  Required. The name of the BatchPredictionJob to cancel.
  ///  Format:
  ///  `projects/{project}/locations/{location}/batchPredictionJobs/{batch_prediction_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.BatchPredictionJob.state]: @googleapis_reference_link{google/cloud/aiplatform/v1/batch_prediction_job.proto#L394}
  /// [google.cloud.aiplatform.v1.CancelBatchPredictionJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1116}
  /// [google.cloud.aiplatform.v1.JobService.GetBatchPredictionJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L311}
  ///
  // clang-format on
  Status CancelBatchPredictionJob(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Cancels a BatchPredictionJob.
  ///
  /// Starts asynchronous cancellation on the BatchPredictionJob. The server
  /// makes the best effort to cancel the job, but success is not
  /// guaranteed. Clients can use
  /// [JobService.GetBatchPredictionJob][google.cloud.aiplatform.v1.JobService.GetBatchPredictionJob]
  /// or other methods to check whether the cancellation succeeded or whether the
  /// job completed despite cancellation. On a successful cancellation,
  /// the BatchPredictionJob is not deleted;instead its
  /// [BatchPredictionJob.state][google.cloud.aiplatform.v1.BatchPredictionJob.state]
  /// is set to `CANCELLED`. Any files already outputted by the job are not
  /// deleted.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CancelBatchPredictionJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.BatchPredictionJob.state]: @googleapis_reference_link{google/cloud/aiplatform/v1/batch_prediction_job.proto#L394}
  /// [google.cloud.aiplatform.v1.CancelBatchPredictionJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1116}
  /// [google.cloud.aiplatform.v1.JobService.GetBatchPredictionJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L311}
  ///
  // clang-format on
  Status CancelBatchPredictionJob(
      google::cloud::aiplatform::v1::CancelBatchPredictionJobRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a ModelDeploymentMonitoringJob. It will run periodically on a
  /// configured interval.
  ///
  /// @param parent  Required. The parent of the ModelDeploymentMonitoringJob.
  ///  Format: `projects/{project}/locations/{location}`
  /// @param model_deployment_monitoring_job  Required. The ModelDeploymentMonitoringJob to create
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateModelDeploymentMonitoringJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1130}
  /// [google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/model_deployment_monitoring_job.proto#L64}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>
  CreateModelDeploymentMonitoringJob(
      std::string const& parent,
      google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob const&
          model_deployment_monitoring_job,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a ModelDeploymentMonitoringJob. It will run periodically on a
  /// configured interval.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateModelDeploymentMonitoringJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateModelDeploymentMonitoringJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1130}
  /// [google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/model_deployment_monitoring_job.proto#L64}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>
  CreateModelDeploymentMonitoringJob(
      google::cloud::aiplatform::v1::
          CreateModelDeploymentMonitoringJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Searches Model Monitoring Statistics generated within a given time window.
  ///
  /// @param model_deployment_monitoring_job  Required. ModelDeploymentMonitoring Job resource name.
  ///  Format:
  ///  `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
  /// @param deployed_model_id  Required. The DeployedModel ID of the
  ///  [ModelDeploymentMonitoringObjectiveConfig.deployed_model_id].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.ModelMonitoringStatsAnomalies], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ModelMonitoringStatsAnomalies]: @googleapis_reference_link{google/cloud/aiplatform/v1/model_deployment_monitoring_job.proto#L309}
  /// [google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1147}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::ModelMonitoringStatsAnomalies>
  SearchModelDeploymentMonitoringStatsAnomalies(
      std::string const& model_deployment_monitoring_job,
      std::string const& deployed_model_id, Options opts = {});

  // clang-format off
  ///
  /// Searches Model Monitoring Statistics generated within a given time window.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.ModelMonitoringStatsAnomalies], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ModelMonitoringStatsAnomalies]: @googleapis_reference_link{google/cloud/aiplatform/v1/model_deployment_monitoring_job.proto#L309}
  /// [google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1147}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::ModelMonitoringStatsAnomalies>
  SearchModelDeploymentMonitoringStatsAnomalies(
      google::cloud::aiplatform::v1::
          SearchModelDeploymentMonitoringStatsAnomaliesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a ModelDeploymentMonitoringJob.
  ///
  /// @param name  Required. The resource name of the ModelDeploymentMonitoringJob.
  ///  Format:
  ///  `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetModelDeploymentMonitoringJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1220}
  /// [google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/model_deployment_monitoring_job.proto#L64}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>
  GetModelDeploymentMonitoringJob(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a ModelDeploymentMonitoringJob.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetModelDeploymentMonitoringJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetModelDeploymentMonitoringJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1220}
  /// [google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/model_deployment_monitoring_job.proto#L64}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>
  GetModelDeploymentMonitoringJob(
      google::cloud::aiplatform::v1::
          GetModelDeploymentMonitoringJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists ModelDeploymentMonitoringJobs in a Location.
  ///
  /// @param parent  Required. The parent of the ModelDeploymentMonitoringJob.
  ///  Format: `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListModelDeploymentMonitoringJobsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1234}
  /// [google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/model_deployment_monitoring_job.proto#L64}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>
  ListModelDeploymentMonitoringJobs(std::string const& parent,
                                    Options opts = {});

  // clang-format off
  ///
  /// Lists ModelDeploymentMonitoringJobs in a Location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListModelDeploymentMonitoringJobsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListModelDeploymentMonitoringJobsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1234}
  /// [google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/model_deployment_monitoring_job.proto#L64}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>
  ListModelDeploymentMonitoringJobs(
      google::cloud::aiplatform::v1::ListModelDeploymentMonitoringJobsRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a ModelDeploymentMonitoringJob.
  ///
  /// @param model_deployment_monitoring_job  Required. The model monitoring configuration which replaces the resource on
  ///  the server.
  /// @param update_mask  Required. The update mask is used to specify the fields to be overwritten
  ///  in the ModelDeploymentMonitoringJob resource by the update. The fields
  ///  specified in the update_mask are relative to the resource, not the full
  ///  request. A field will be overwritten if it is in the mask. If the user does
  ///  not provide a mask then only the non-empty fields present in the request
  ///  will be overwritten. Set the update_mask to `*` to override all fields. For
  ///  the objective config, the user can either provide the update mask for
  ///  model_deployment_monitoring_objective_configs or any combination of its
  ///  nested fields, such as:
  ///  model_deployment_monitoring_objective_configs.objective_config.training_dataset.
  ///  @n
  ///  For more information, see [UpdateModelDeploymentMonitoringJobRequest][google.cloud.aiplatform.v1.UpdateModelDeploymentMonitoringJobRequest].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/model_deployment_monitoring_job.proto#L64}
  /// [google.cloud.aiplatform.v1.UpdateModelDeploymentMonitoringJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1289}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>>
  UpdateModelDeploymentMonitoringJob(
      google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob const&
          model_deployment_monitoring_job,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateModelDeploymentMonitoringJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateModelDeploymentMonitoringJob(
      NoAwaitTag,
      google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob const&
          model_deployment_monitoring_job,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a ModelDeploymentMonitoringJob.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.UpdateModelDeploymentMonitoringJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/model_deployment_monitoring_job.proto#L64}
  /// [google.cloud.aiplatform.v1.UpdateModelDeploymentMonitoringJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1289}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>>
  UpdateModelDeploymentMonitoringJob(
      google::cloud::aiplatform::v1::
          UpdateModelDeploymentMonitoringJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateModelDeploymentMonitoringJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateModelDeploymentMonitoringJob(
      NoAwaitTag,
      google::cloud::aiplatform::v1::
          UpdateModelDeploymentMonitoringJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateModelDeploymentMonitoringJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>>
  UpdateModelDeploymentMonitoringJob(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes a ModelDeploymentMonitoringJob.
  ///
  /// @param name  Required. The resource name of the model monitoring job to delete.
  ///  Format:
  ///  `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteModelDeploymentMonitoringJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1327}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteModelDeploymentMonitoringJob(std::string const& name,
                                     Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteModelDeploymentMonitoringJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteModelDeploymentMonitoringJob(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a ModelDeploymentMonitoringJob.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteModelDeploymentMonitoringJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteModelDeploymentMonitoringJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1327}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteModelDeploymentMonitoringJob(
      google::cloud::aiplatform::v1::
          DeleteModelDeploymentMonitoringJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteModelDeploymentMonitoringJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteModelDeploymentMonitoringJob(
      NoAwaitTag,
      google::cloud::aiplatform::v1::
          DeleteModelDeploymentMonitoringJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteModelDeploymentMonitoringJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteModelDeploymentMonitoringJob(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Pauses a ModelDeploymentMonitoringJob. If the job is running, the server
  /// makes a best effort to cancel the job. Will mark
  /// [ModelDeploymentMonitoringJob.state][google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob.state]
  /// to 'PAUSED'.
  ///
  /// @param name  Required. The resource name of the ModelDeploymentMonitoringJob to pause.
  ///  Format:
  ///  `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob.state]: @googleapis_reference_link{google/cloud/aiplatform/v1/model_deployment_monitoring_job.proto#L118}
  /// [google.cloud.aiplatform.v1.PauseModelDeploymentMonitoringJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1341}
  ///
  // clang-format on
  Status PauseModelDeploymentMonitoringJob(std::string const& name,
                                           Options opts = {});

  // clang-format off
  ///
  /// Pauses a ModelDeploymentMonitoringJob. If the job is running, the server
  /// makes a best effort to cancel the job. Will mark
  /// [ModelDeploymentMonitoringJob.state][google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob.state]
  /// to 'PAUSED'.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.PauseModelDeploymentMonitoringJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob.state]: @googleapis_reference_link{google/cloud/aiplatform/v1/model_deployment_monitoring_job.proto#L118}
  /// [google.cloud.aiplatform.v1.PauseModelDeploymentMonitoringJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1341}
  ///
  // clang-format on
  Status PauseModelDeploymentMonitoringJob(
      google::cloud::aiplatform::v1::
          PauseModelDeploymentMonitoringJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Resumes a paused ModelDeploymentMonitoringJob. It will start to run from
  /// next scheduled time. A deleted ModelDeploymentMonitoringJob can't be
  /// resumed.
  ///
  /// @param name  Required. The resource name of the ModelDeploymentMonitoringJob to resume.
  ///  Format:
  ///  `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ResumeModelDeploymentMonitoringJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1355}
  ///
  // clang-format on
  Status ResumeModelDeploymentMonitoringJob(std::string const& name,
                                            Options opts = {});

  // clang-format off
  ///
  /// Resumes a paused ModelDeploymentMonitoringJob. It will start to run from
  /// next scheduled time. A deleted ModelDeploymentMonitoringJob can't be
  /// resumed.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ResumeModelDeploymentMonitoringJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ResumeModelDeploymentMonitoringJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/job_service.proto#L1355}
  ///
  // clang-format on
  Status ResumeModelDeploymentMonitoringJob(
      google::cloud::aiplatform::v1::
          ResumeModelDeploymentMonitoringJobRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<JobServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_JOB_CLIENT_H
