// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test.proto

#include "generator/integration_tests/golden/v1/internal/golden_kitchen_sink_round_robin_decorator.h"
#include <memory>
#include <mutex>
#include <vector>

namespace google {
namespace cloud {
namespace golden_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GoldenKitchenSinkRoundRobin::GoldenKitchenSinkRoundRobin(
    std::vector<std::shared_ptr<GoldenKitchenSinkStub>> children)
    : children_(std::move(children)) {}

StatusOr<google::test::admin::database::v1::GenerateAccessTokenResponse> GoldenKitchenSinkRoundRobin::GenerateAccessToken(
    grpc::ClientContext& context,
    Options const& options,
    google::test::admin::database::v1::GenerateAccessTokenRequest const& request) {
  return Child()->GenerateAccessToken(context, options, request);
}

StatusOr<google::test::admin::database::v1::GenerateIdTokenResponse> GoldenKitchenSinkRoundRobin::GenerateIdToken(
    grpc::ClientContext& context,
    Options const& options,
    google::test::admin::database::v1::GenerateIdTokenRequest const& request) {
  return Child()->GenerateIdToken(context, options, request);
}

StatusOr<google::test::admin::database::v1::WriteLogEntriesResponse> GoldenKitchenSinkRoundRobin::WriteLogEntries(
    grpc::ClientContext& context,
    Options const& options,
    google::test::admin::database::v1::WriteLogEntriesRequest const& request) {
  return Child()->WriteLogEntries(context, options, request);
}

StatusOr<google::test::admin::database::v1::ListLogsResponse> GoldenKitchenSinkRoundRobin::ListLogs(
    grpc::ClientContext& context,
    Options const& options,
    google::test::admin::database::v1::ListLogsRequest const& request) {
  return Child()->ListLogs(context, options, request);
}

StatusOr<google::test::admin::database::v1::ListServiceAccountKeysResponse> GoldenKitchenSinkRoundRobin::ListServiceAccountKeys(
    grpc::ClientContext& context,
    Options const& options,
    google::test::admin::database::v1::ListServiceAccountKeysRequest const& request) {
  return Child()->ListServiceAccountKeys(context, options, request);
}

Status GoldenKitchenSinkRoundRobin::DoNothing(
    grpc::ClientContext& context,
    Options const& options,
    google::protobuf::Empty const& request) {
  return Child()->DoNothing(context, options, request);
}

Status GoldenKitchenSinkRoundRobin::Deprecated2(
    grpc::ClientContext& context,
    Options const& options,
    google::test::admin::database::v1::GenerateAccessTokenRequest const& request) {
  return Child()->Deprecated2(context, options, request);
}

std::unique_ptr<google::cloud::internal::StreamingReadRpc<google::test::admin::database::v1::Response>>
GoldenKitchenSinkRoundRobin::StreamingRead(
    std::shared_ptr<grpc::ClientContext> context,
    Options const& options,
    google::test::admin::database::v1::Request const& request) {
  return Child()->StreamingRead(std::move(context), options, request);
}

std::unique_ptr<google::cloud::internal::StreamingWriteRpc<
    google::test::admin::database::v1::Request, google::test::admin::database::v1::Response>>
GoldenKitchenSinkRoundRobin::StreamingWrite(
    std::shared_ptr<grpc::ClientContext> context,
    Options const& options) {
  return Child()->StreamingWrite(std::move(context), options);
}

std::unique_ptr<google::cloud::AsyncStreamingReadWriteRpc<
    google::test::admin::database::v1::Request,
    google::test::admin::database::v1::Response>>
GoldenKitchenSinkRoundRobin::AsyncStreamingReadWrite(
    google::cloud::CompletionQueue const& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options) {
  return Child()->AsyncStreamingReadWrite(
      cq, std::move(context), std::move(options));
}

Status GoldenKitchenSinkRoundRobin::ExplicitRouting1(
    grpc::ClientContext& context,
    Options const& options,
    google::test::admin::database::v1::ExplicitRoutingRequest const& request) {
  return Child()->ExplicitRouting1(context, options, request);
}

Status GoldenKitchenSinkRoundRobin::ExplicitRouting2(
    grpc::ClientContext& context,
    Options const& options,
    google::test::admin::database::v1::ExplicitRoutingRequest const& request) {
  return Child()->ExplicitRouting2(context, options, request);
}

std::unique_ptr<google::cloud::internal::AsyncStreamingReadRpc<
    google::test::admin::database::v1::Response>>
GoldenKitchenSinkRoundRobin::AsyncStreamingRead(
    google::cloud::CompletionQueue const& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::test::admin::database::v1::Request const& request) {
  return Child()->AsyncStreamingRead(
      cq, std::move(context), std::move(options), request);
}

std::unique_ptr<google::cloud::internal::AsyncStreamingWriteRpc<
    google::test::admin::database::v1::Request,
    google::test::admin::database::v1::Response>>
GoldenKitchenSinkRoundRobin::AsyncStreamingWrite(
    google::cloud::CompletionQueue const& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options) {
  return Child()->AsyncStreamingWrite(
      cq, std::move(context), std::move(options));
}

std::shared_ptr<GoldenKitchenSinkStub>
GoldenKitchenSinkRoundRobin::Child() {
  std::unique_lock<std::mutex> lk(mu_);
  auto const current = current_;
  if (++current_ == children_.size()) current_ = 0;
  lk.unlock();
  return children_[current];
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1_internal
}  // namespace cloud
}  // namespace google
