/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.netty;

import io.netty.util.ByteProcessor;

class VarintByteDecoder
implements ByteProcessor {
    private int readVarint;
    private int bytesRead;
    private DecodeResult result = DecodeResult.TOO_SHORT;

    VarintByteDecoder() {
    }

    @Override
    public boolean process(byte k) {
        this.readVarint |= (k & 0x7F) << this.bytesRead++ * 7;
        if (this.bytesRead > 3) {
            this.result = DecodeResult.TOO_BIG;
            return false;
        }
        if ((k & 0x80) != 128) {
            this.result = DecodeResult.SUCCESS;
            return false;
        }
        return true;
    }

    public int getReadVarint() {
        return this.readVarint;
    }

    public int getBytesRead() {
        return this.bytesRead;
    }

    public DecodeResult getResult() {
        return this.result;
    }

    public static enum DecodeResult {
        SUCCESS,
        TOO_SHORT,
        TOO_BIG;

    }
}

