/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.util;

import com.jgoodies.binding.value.DelayedReadValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.jsdl.internal.MyListeners;
import com.jgoodies.framework.util.ScreenUtils;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;

public final class WindowUtils {
    private static final String WINDOW_BOUNDS_KEYPART = "window_bounds";
    private static final String FRAME_STATE_KEYPART = "frame_state";

    private WindowUtils() {
    }

    public static void storeBounds(Preferences prefs, JWindow window) {
        WindowUtils.storeBounds0(prefs, window);
    }

    public static void storeBounds(Preferences prefs, JDialog dialog) {
        WindowUtils.storeBounds0(prefs, dialog);
    }

    public static void storeBounds(Preferences prefs, Frame frame) {
        boolean maximizedBoth;
        boolean bl = maximizedBoth = frame.getExtendedState() == 6;
        if (frame.isVisible() && !maximizedBoth) {
            WindowUtils.storeBounds0(prefs, frame);
        }
    }

    public static void storeState(Preferences prefs, Frame frame) {
        Preferences screenConfigNode = ScreenUtils.screenConfigurationNode(prefs);
        screenConfigNode.putInt(WindowUtils.frameStateKey(frame), frame.getExtendedState());
    }

    public static void restoreBounds(JWindow window, Preferences prefs) {
        WindowUtils.restoreBounds0(window, prefs);
    }

    public static void restoreBounds(JDialog dialog, Preferences prefs) {
        WindowUtils.restoreBounds0(dialog, prefs);
    }

    public static boolean restoreBounds(JFrame frame, Preferences prefs) {
        return WindowUtils.restoreBounds0(frame, prefs);
    }

    public static void restoreState(Frame frame, Preferences prefs) {
        WindowUtils.restoreState(frame, prefs, true);
    }

    public static void restoreState(Frame frame, Preferences prefs, boolean restoreIconified) {
        int state = WindowUtils.getStoredState(frame, prefs);
        if (state == -1) {
            return;
        }
        if (state != 1 || !restoreIconified) {
            frame.setExtendedState(state);
        }
    }

    public static void clearBounds(Preferences prefs, Window window) {
        ScreenUtils.screenConfigurationNode(prefs).put(WindowUtils.windowBoundsKey(window), "");
    }

    public static void clearState(Preferences prefs, Frame frame) {
        ScreenUtils.screenConfigurationNode(prefs).putInt(WindowUtils.frameStateKey(frame), -1);
    }

    private static void storeBounds0(Preferences prefs, Window window) {
        Preferences screenConfigNode = ScreenUtils.screenConfigurationNode(prefs);
        screenConfigNode.put(WindowUtils.windowBoundsKey(window), WindowUtils.encodeRectangle(window.getBounds()));
    }

    private static boolean restoreBounds0(Window window, Preferences prefs) {
        Rectangle bounds = WindowUtils.getStoredBounds(prefs, window);
        if (bounds != null) {
            window.setBounds(bounds);
            return true;
        }
        return false;
    }

    private static Rectangle getStoredBounds(Preferences prefs, Window window) {
        Preferences screenConfigNode = ScreenUtils.screenConfigurationNode(prefs);
        return WindowUtils.decodeRectangle(screenConfigNode.get(WindowUtils.windowBoundsKey(window), ""));
    }

    private static int getStoredState(Frame frame, Preferences prefs) {
        Preferences screenConfigNode = ScreenUtils.screenConfigurationNode(prefs);
        return screenConfigNode.getInt(WindowUtils.frameStateKey(frame), -1);
    }

    private static String windowBoundsKey(Window window) {
        Preconditions.checkNotNull(window, "The %s must not be null.", "window");
        Preconditions.checkArgument(Strings.isNotBlank(window.getName()), "The window must have a non-blank name.");
        return window.getName() + '.' + WINDOW_BOUNDS_KEYPART;
    }

    private static String frameStateKey(Frame frame) {
        Preconditions.checkNotNull(frame, "The %s must not be null.", "frame");
        Preconditions.checkArgument(Strings.isNotBlank(frame.getName()), "The frame must have a non-blank name.");
        return frame.getName() + '.' + FRAME_STATE_KEYPART;
    }

    private static String encodeRectangle(Rectangle r) {
        return Integer.toString(r.x) + ", " + r.y + ", " + r.width + ", " + r.height;
    }

    private static Rectangle decodeRectangle(String encodedRectangle) {
        StringTokenizer tokenizer = new StringTokenizer(encodedRectangle, " ,");
        try {
            int x = Integer.parseInt(tokenizer.nextToken());
            int y = Integer.parseInt(tokenizer.nextToken());
            int w = Integer.parseInt(tokenizer.nextToken());
            int h = Integer.parseInt(tokenizer.nextToken());
            return new Rectangle(x, y, w, h);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final class PersistencyHandler
    extends ComponentAdapter {
        private static final int COMPONENT_MOVED_DELAY = 50;
        private final Preferences preferences;
        private final Window window;
        private ValueModel componentMovedModel;

        public PersistencyHandler(JDialog dialog, Preferences preferences) {
            this.window = dialog;
            this.preferences = preferences;
            this.init();
        }

        public PersistencyHandler(JFrame frame, Preferences preferences) {
            this.window = frame;
            this.preferences = preferences;
            this.init();
        }

        public PersistencyHandler(JWindow window, Preferences preferences) {
            this.window = window;
            this.preferences = preferences;
            this.init();
        }

        private void init() {
            this.componentMovedModel = new ValueHolder();
            DelayedReadValueModel delayedComponentMovedModel = new DelayedReadValueModel(this.componentMovedModel, 50, true);
            delayedComponentMovedModel.addValueChangeListener(MyListeners.delayed(this::delayedComponentMoved));
        }

        @Override
        public void componentMoved(ComponentEvent evt) {
            this.componentMovedModel.setValue(this.window.getBounds());
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            if (this.window instanceof JFrame) {
                WindowUtils.storeBounds(this.preferences, (JFrame)this.window);
                WindowUtils.storeState(this.preferences, (JFrame)this.window);
            } else {
                WindowUtils.storeBounds0(this.preferences, this.window);
            }
        }

        private void delayedComponentMoved(PropertyChangeEvent evt) {
            WindowUtils.storeBounds0(this.preferences, this.window);
            if (this.window instanceof JFrame) {
                WindowUtils.storeState(this.preferences, (JFrame)this.window);
            }
        }
    }
}

