/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.search;

import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.binder.BinderUtils;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.components.JGTextField;
import com.jgoodies.framework.search.BusyIcons;
import com.jgoodies.framework.search.FieldSearchModel;
import com.jgoodies.search.CompletionManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.Timer;

public final class FieldSearchBindings {
    private static final ResourceMap RESOURCES = Application.getResourceMap(FieldSearchBindings.class);
    private static final Icon[] BUSY_ICONS = BusyIcons.getIcons();

    private FieldSearchBindings() {
    }

    public static void bind(JGTextField field, PresentationModel<?> model, String propertyName, CompletionManager manager) {
        FieldSearchBindings.bind(field, model.getComponentModel(propertyName), manager);
        BinderUtils.setValidationMessageKey(field, propertyName);
    }

    public static void bind(JGTextField field, ValueModel valueModel, CompletionManager manager) {
        FieldSearchBindings.bind(field, valueModel, manager, FieldSearchModel.InvalidTextBehavior.PERSIST);
    }

    public static void bind(JGTextField field, ValueModel valueModel, CompletionManager manager, FieldSearchModel.InvalidTextBehavior invalidTextBehavior) {
        FieldSearchBindings.bind(field, new FieldSearchModel(valueModel, manager, invalidTextBehavior));
    }

    public static void bind(JGTextField field, FieldSearchModel<?> searchModel) {
        Bindings.bind(field, searchModel.getTextModel(), false);
        Bindings.addComponentPropertyHandler(field, searchModel.getValueModel());
        FieldSearchModel.setFindModel(field, searchModel);
        field.addFocusListener(FieldSearchModel.HANDLER);
        field.addKeyListener(FieldSearchModel.HANDLER);
        searchModel.getManager().install(field);
        searchModel.addPropertyChangeListener(new Handler(field));
    }

    private static final class Animator
    implements ActionListener {
        private final JGTextField field;
        private final Timer timer;
        private int iconIndex = 0;
        private Icon oldIcon;
        private boolean oldIconVisibleAlways;

        Animator(JGTextField field, int frameRate, int initialDelay) {
            this.field = field;
            int delay = 1000 / frameRate;
            this.timer = new Timer(delay, this);
            this.timer.setInitialDelay(initialDelay);
        }

        void start() {
            this.oldIcon = this.field.getIcon();
            this.oldIconVisibleAlways = this.field.isIconVisibleAlways();
            this.field.setIconVisibleAlways(true);
            this.timer.start();
        }

        void stop() {
            this.timer.stop();
            this.field.setIcon(this.oldIcon);
            this.field.setIconVisibleAlways(this.oldIconVisibleAlways);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.field.setIcon(BUSY_ICONS[this.iconIndex]);
            this.iconIndex = (this.iconIndex + 1) % BUSY_ICONS.length;
        }
    }

    private static final class Handler
    implements PropertyChangeListener {
        private final JGTextField field;
        private final Animator animator;

        Handler(JGTextField field) {
            this.field = field;
            this.animator = new Animator(field, RESOURCES.getInt("FieldSearch.animation.frameRate"), RESOURCES.getInt("FieldSearch.animation.initialDelay"));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            FieldSearchModel model = (FieldSearchModel)evt.getSource();
            switch (evt.getPropertyName()) {
                case "searching": {
                    if (model.isSearching()) {
                        this.animator.start();
                        break;
                    }
                    this.animator.stop();
                    break;
                }
                case "textValid": {
                    this.field.setErrorUnderlinePainted(!model.isTextValid());
                    break;
                }
            }
        }
    }
}

