/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.jsdl.list;

import com.jgoodies.common.jsdl.list.ListViewModel;
import com.jgoodies.common.swing.collect.ArrayListModel;
import com.jgoodies.common.swing.collect.ObservableList2;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.event.ListDataEvent;

public class FilteredListViewModel<E>
extends ListViewModel<E> {
    private final ObservableList2<E> filteredItems = new ArrayListModel();
    private Predicate<E> filter;

    public final Predicate<E> getFilter() {
        return this.filter;
    }

    public final void setFilter(Predicate<E> newFilter) {
        Predicate<E> oldFilter = this.getFilter();
        if (oldFilter == newFilter) {
            return;
        }
        this.filter = newFilter;
        this.filter();
    }

    public final List<E> getFilteredItems() {
        return Collections.unmodifiableList(this.filteredItems);
    }

    public final void filter() {
        List oldSelection = this.getSelectedItems();
        List oldInclusions = this.getIncludedItems();
        this.filterWithoutRestore();
        this.restoreSelection(oldSelection);
        this.restoreInclusions(oldInclusions);
    }

    public final E filteredGet(int index) {
        return this.filteredItems.get(index);
    }

    public final boolean filteredContains(E element) {
        return this.filteredItems.contains(element);
    }

    public final boolean filteredIsEmpty() {
        return this.filteredItems.isEmpty();
    }

    public final int filteredSize() {
        return this.filteredItems.size();
    }

    @Override
    public void includeAll() {
        super.includeAll();
        this.filter();
    }

    @Override
    public void clearInclusions() {
        super.clearInclusions();
        this.filter();
    }

    @Override
    protected ObservableList2<E> displayedList() {
        return this.filteredItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void setItemsImpl(List<E> rawItems) {
        List oldSelection = this.getSelectedItems();
        List oldInclusions = this.getIncludedItems();
        this.items.removeListDataListener(this.listDataListener);
        try {
            this.items.clear();
            this.items.addAll(rawItems);
            this.filterWithoutRestore();
        }
        finally {
            this.items.addListDataListener(this.listDataListener);
        }
        this.restoreSelection(oldSelection);
        this.restoreInclusions(oldInclusions);
    }

    @Override
    protected void onListDataChanged(ListDataEvent evt) {
        super.onListDataChanged(evt);
        this.filter();
    }

    private void filterWithoutRestore() {
        this.filteredItems.clear();
        List includedElements = this.items.stream().filter(this::include).collect(Collectors.toList());
        this.filteredItems.addAll(includedElements);
    }

    private boolean include(E element) {
        return this.filter == null || this.filter.test(element);
    }
}

