/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.binder;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.binder.BinderUtils;
import com.jgoodies.binding.binder.SelectionInListBindingBuilder;
import com.jgoodies.binding.binder.SelectionInListBindingBuilderImpl;
import com.jgoodies.binding.binder.ValueModelBindable;
import com.jgoodies.binding.binder.ValueModelBindingBuilder;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterFactory;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import java.text.Format;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;

public class ValueModelBindingBuilderImpl
implements ValueModelBindingBuilder {
    private final ValueModel valueModel;
    private final String propertyName;

    public ValueModelBindingBuilderImpl(ValueModel valueModel) {
        this(valueModel, null);
    }

    public ValueModelBindingBuilderImpl(ValueModel valueModel, String propertyName) {
        this.valueModel = Preconditions.checkNotNull(valueModel, "The %s must not be null.", "ValueModel");
        this.propertyName = propertyName;
        if (propertyName != null) {
            Preconditions.checkNotBlank(propertyName, "The bean property name must not be empty, or whitespace.");
        }
    }

    @Override
    public <S, T> ValueModelBindingBuilder converted(BindingConverter<S, T> converter) {
        return new ValueModelBindingBuilderImpl(new ConverterValueModel<S, T>(this.getValueModel(), converter), this.getPropertyName());
    }

    @Override
    public ValueModelBindingBuilder formatted(Format format) {
        return new ValueModelBindingBuilderImpl(ConverterFactory.createStringConverter(this.getValueModel(), format), this.getPropertyName());
    }

    @Override
    public <E> SelectionInListBindingBuilder<E> asSelectionIn(E[] array) {
        Preconditions.checkNotNull(array, "The %s must not be null.", "array");
        SelectionInList<E> selectionInList = new SelectionInList<E>(array, this.getValueModel());
        return new SelectionInListBindingBuilderImpl<E>(selectionInList, this.getPropertyName());
    }

    @Override
    public <E> SelectionInListBindingBuilder<E> asSelectionIn(List<E> list) {
        Preconditions.checkNotNull(list, "The %s must not be null.", "List");
        SelectionInList<E> selectionInList = new SelectionInList<E>(list, this.getValueModel());
        return new SelectionInListBindingBuilderImpl<E>(selectionInList, this.getPropertyName());
    }

    @Override
    public <E> SelectionInListBindingBuilder<E> asSelectionIn(ListModel<E> listModel) {
        Preconditions.checkNotNull(listModel, "The %s must not be null.", "ListModel");
        SelectionInList<E> selectionInList = new SelectionInList<E>(listModel, this.getValueModel());
        return new SelectionInListBindingBuilderImpl<E>(selectionInList, this.getPropertyName());
    }

    @Override
    public void to(AbstractButton toggleButton) {
        Preconditions.checkNotNull(toggleButton, "The %s must not be null.", "toggle button");
        Bindings.bind(toggleButton, this.valueModel);
        this.setValidationMessageKey(toggleButton);
    }

    @Override
    public void to(AbstractButton toggleButton, Object selectedValue, Object deselectedValue) {
        Preconditions.checkNotNull(toggleButton, "The %s must not be null.", "toggle button");
        Bindings.bind(toggleButton, this.valueModel, selectedValue, deselectedValue);
        this.setValidationMessageKey(toggleButton);
    }

    @Override
    public void to(AbstractButton toggleButton, Object choice) {
        Preconditions.checkNotNull(toggleButton, "The %s must not be null.", "toggle button");
        Bindings.bind(toggleButton, this.valueModel, choice);
        this.setValidationMessageKey(toggleButton);
    }

    @Override
    public void to(JComboBox<?> comboBox) {
        Preconditions.checkNotNull(comboBox, "The %s must not be null.", "combo box");
        Bindings.bind(comboBox, this.valueModel);
        this.setValidationMessageKey(comboBox);
    }

    @Override
    public void to(JComboBox<?> comboBox, String nullText) {
        Preconditions.checkNotNull(comboBox, "The %s must not be null.", "combo box");
        Bindings.bind(comboBox, this.valueModel, nullText);
        this.setValidationMessageKey(comboBox);
    }

    @Override
    public void to(JFormattedTextField formattedTextField) {
        Preconditions.checkNotNull(formattedTextField, "The %s must not be null.", "formatted text field");
        Bindings.bind(formattedTextField, this.valueModel);
        this.setValidationMessageKey(formattedTextField);
    }

    @Override
    public void to(JLabel label) {
        Preconditions.checkNotNull(label, "The %s must not be null.", "label");
        Bindings.bind(label, this.valueModel);
    }

    @Override
    public void to(JTextArea textArea) {
        this.to(textArea, ValueModelBindingBuilder.Commit.ON_FOCUS_LOST);
    }

    @Override
    public void to(JTextArea textArea, ValueModelBindingBuilder.Commit commitType) {
        Preconditions.checkNotNull(textArea, "The %s must not be null.", "text area");
        Preconditions.checkNotNull(commitType, "The %s must not be null.", "commit type");
        Bindings.bind(textArea, this.valueModel, commitType == ValueModelBindingBuilder.Commit.ON_FOCUS_LOST);
        this.setValidationMessageKey(textArea);
    }

    @Override
    public void to(JTextField textField) {
        if (textField instanceof JFormattedTextField) {
            this.to((JFormattedTextField)textField);
        } else {
            this.to(textField, ValueModelBindingBuilder.Commit.ON_FOCUS_LOST);
        }
    }

    @Override
    public void to(JTextField textField, ValueModelBindingBuilder.Commit commitType) {
        Preconditions.checkNotNull(textField, "The %s must not be null.", "text field");
        Preconditions.checkNotNull(commitType, "The %s must not be null.", "commit type");
        Preconditions.checkArgument(!(textField instanceof JFormattedTextField), "For JFormattedTextField use method #to(JFormattedTextField)");
        Bindings.bind(textField, this.valueModel, commitType == ValueModelBindingBuilder.Commit.ON_FOCUS_LOST);
        this.setValidationMessageKey(textField);
    }

    @Override
    public void to(String propertyName, Object bean) {
        Preconditions.checkNotNull(bean, "The %s must not be null.", "bean");
        Preconditions.checkNotBlank(propertyName, "The %s must not be null, empty, or whitespace.", "property name");
        PropertyConnector.connectAndUpdate(this.getValueModel(), bean, propertyName);
    }

    @Override
    public void to(ValueModelBindable bindable) {
        Preconditions.checkNotNull(bindable, "The %s must not be null.", "bindable");
        bindable.bind(this.valueModel, this.propertyName);
    }

    protected final ValueModel getValueModel() {
        return this.valueModel;
    }

    protected final String getPropertyName() {
        return this.propertyName;
    }

    protected final void setValidationMessageKey(JComponent comp) {
        if (this.getPropertyName() != null) {
            BinderUtils.setValidationMessageKey(comp, this.getPropertyName());
        }
    }
}

