/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.builder.dependency;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jfrog.build.api.dependency.BuildDependency;

public class BuildDependencyBuilder {
    private String name;
    private String number;
    private String started;
    private String url;

    public BuildDependency build() {
        if (this.name == null) {
            throw new IllegalArgumentException("BuildDependency must have a name.");
        }
        if (this.number == null) {
            throw new IllegalArgumentException("BuildDependency must have a number.");
        }
        if (this.started == null) {
            throw new IllegalArgumentException("BuildDependency must have a started time.");
        }
        BuildDependency buildDependency = new BuildDependency();
        buildDependency.setName(this.name);
        buildDependency.setNumber(this.number);
        buildDependency.setStarted(this.started);
        buildDependency.setUrl(this.url);
        return buildDependency;
    }

    public BuildDependencyBuilder name(String name) {
        this.name = name;
        return this;
    }

    public BuildDependencyBuilder number(String number) {
        this.number = number;
        return this;
    }

    public BuildDependencyBuilder started(String started) {
        this.started = started;
        return this;
    }

    public BuildDependencyBuilder startedDate(Date startedDate) {
        if (startedDate == null) {
            throw new IllegalArgumentException("Cannot format a null date.");
        }
        this.started = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(startedDate);
        return this;
    }

    public BuildDependencyBuilder url(String url) {
        this.url = url;
        return this;
    }
}

