// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceLogTargetDefaultsOKCode is the HTTP code returned for type ReplaceLogTargetDefaultsOK
const ReplaceLogTargetDefaultsOKCode int = 200

/*
ReplaceLogTargetDefaultsOK Log Target replaced

swagger:response replaceLogTargetDefaultsOK
*/
type ReplaceLogTargetDefaultsOK struct {

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewReplaceLogTargetDefaultsOK creates ReplaceLogTargetDefaultsOK with default headers values
func NewReplaceLogTargetDefaultsOK() *ReplaceLogTargetDefaultsOK {

	return &ReplaceLogTargetDefaultsOK{}
}

// WithPayload adds the payload to the replace log target defaults o k response
func (o *ReplaceLogTargetDefaultsOK) WithPayload(payload *models.LogTarget) *ReplaceLogTargetDefaultsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target defaults o k response
func (o *ReplaceLogTargetDefaultsOK) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetDefaultsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogTargetDefaultsAcceptedCode is the HTTP code returned for type ReplaceLogTargetDefaultsAccepted
const ReplaceLogTargetDefaultsAcceptedCode int = 202

/*
ReplaceLogTargetDefaultsAccepted Configuration change accepted and reload requested

swagger:response replaceLogTargetDefaultsAccepted
*/
type ReplaceLogTargetDefaultsAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewReplaceLogTargetDefaultsAccepted creates ReplaceLogTargetDefaultsAccepted with default headers values
func NewReplaceLogTargetDefaultsAccepted() *ReplaceLogTargetDefaultsAccepted {

	return &ReplaceLogTargetDefaultsAccepted{}
}

// WithReloadID adds the reloadId to the replace log target defaults accepted response
func (o *ReplaceLogTargetDefaultsAccepted) WithReloadID(reloadID string) *ReplaceLogTargetDefaultsAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace log target defaults accepted response
func (o *ReplaceLogTargetDefaultsAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace log target defaults accepted response
func (o *ReplaceLogTargetDefaultsAccepted) WithPayload(payload *models.LogTarget) *ReplaceLogTargetDefaultsAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target defaults accepted response
func (o *ReplaceLogTargetDefaultsAccepted) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetDefaultsAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogTargetDefaultsBadRequestCode is the HTTP code returned for type ReplaceLogTargetDefaultsBadRequest
const ReplaceLogTargetDefaultsBadRequestCode int = 400

/*
ReplaceLogTargetDefaultsBadRequest Bad request

swagger:response replaceLogTargetDefaultsBadRequest
*/
type ReplaceLogTargetDefaultsBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogTargetDefaultsBadRequest creates ReplaceLogTargetDefaultsBadRequest with default headers values
func NewReplaceLogTargetDefaultsBadRequest() *ReplaceLogTargetDefaultsBadRequest {

	return &ReplaceLogTargetDefaultsBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace log target defaults bad request response
func (o *ReplaceLogTargetDefaultsBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceLogTargetDefaultsBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log target defaults bad request response
func (o *ReplaceLogTargetDefaultsBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log target defaults bad request response
func (o *ReplaceLogTargetDefaultsBadRequest) WithPayload(payload *models.Error) *ReplaceLogTargetDefaultsBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target defaults bad request response
func (o *ReplaceLogTargetDefaultsBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetDefaultsBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogTargetDefaultsNotFoundCode is the HTTP code returned for type ReplaceLogTargetDefaultsNotFound
const ReplaceLogTargetDefaultsNotFoundCode int = 404

/*
ReplaceLogTargetDefaultsNotFound The specified resource was not found

swagger:response replaceLogTargetDefaultsNotFound
*/
type ReplaceLogTargetDefaultsNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogTargetDefaultsNotFound creates ReplaceLogTargetDefaultsNotFound with default headers values
func NewReplaceLogTargetDefaultsNotFound() *ReplaceLogTargetDefaultsNotFound {

	return &ReplaceLogTargetDefaultsNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace log target defaults not found response
func (o *ReplaceLogTargetDefaultsNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceLogTargetDefaultsNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log target defaults not found response
func (o *ReplaceLogTargetDefaultsNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log target defaults not found response
func (o *ReplaceLogTargetDefaultsNotFound) WithPayload(payload *models.Error) *ReplaceLogTargetDefaultsNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target defaults not found response
func (o *ReplaceLogTargetDefaultsNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetDefaultsNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceLogTargetDefaultsDefault General Error

swagger:response replaceLogTargetDefaultsDefault
*/
type ReplaceLogTargetDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogTargetDefaultsDefault creates ReplaceLogTargetDefaultsDefault with default headers values
func NewReplaceLogTargetDefaultsDefault(code int) *ReplaceLogTargetDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceLogTargetDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace log target defaults default response
func (o *ReplaceLogTargetDefaultsDefault) WithStatusCode(code int) *ReplaceLogTargetDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace log target defaults default response
func (o *ReplaceLogTargetDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace log target defaults default response
func (o *ReplaceLogTargetDefaultsDefault) WithConfigurationVersion(configurationVersion string) *ReplaceLogTargetDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log target defaults default response
func (o *ReplaceLogTargetDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log target defaults default response
func (o *ReplaceLogTargetDefaultsDefault) WithPayload(payload *models.Error) *ReplaceLogTargetDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target defaults default response
func (o *ReplaceLogTargetDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
