// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_check

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllHTTPCheckBackendOKCode is the HTTP code returned for type GetAllHTTPCheckBackendOK
const GetAllHTTPCheckBackendOKCode int = 200

/*
GetAllHTTPCheckBackendOK Successful operation

swagger:response getAllHttpCheckBackendOK
*/
type GetAllHTTPCheckBackendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.HTTPChecks `json:"body,omitempty"`
}

// NewGetAllHTTPCheckBackendOK creates GetAllHTTPCheckBackendOK with default headers values
func NewGetAllHTTPCheckBackendOK() *GetAllHTTPCheckBackendOK {

	return &GetAllHTTPCheckBackendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all Http check backend o k response
func (o *GetAllHTTPCheckBackendOK) WithConfigurationVersion(configurationVersion string) *GetAllHTTPCheckBackendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all Http check backend o k response
func (o *GetAllHTTPCheckBackendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all Http check backend o k response
func (o *GetAllHTTPCheckBackendOK) WithPayload(payload models.HTTPChecks) *GetAllHTTPCheckBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all Http check backend o k response
func (o *GetAllHTTPCheckBackendOK) SetPayload(payload models.HTTPChecks) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllHTTPCheckBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.HTTPChecks{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllHTTPCheckBackendDefault General Error

swagger:response getAllHttpCheckBackendDefault
*/
type GetAllHTTPCheckBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllHTTPCheckBackendDefault creates GetAllHTTPCheckBackendDefault with default headers values
func NewGetAllHTTPCheckBackendDefault(code int) *GetAllHTTPCheckBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllHTTPCheckBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all HTTP check backend default response
func (o *GetAllHTTPCheckBackendDefault) WithStatusCode(code int) *GetAllHTTPCheckBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all HTTP check backend default response
func (o *GetAllHTTPCheckBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all HTTP check backend default response
func (o *GetAllHTTPCheckBackendDefault) WithConfigurationVersion(configurationVersion string) *GetAllHTTPCheckBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all HTTP check backend default response
func (o *GetAllHTTPCheckBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all HTTP check backend default response
func (o *GetAllHTTPCheckBackendDefault) WithPayload(payload *models.Error) *GetAllHTTPCheckBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all HTTP check backend default response
func (o *GetAllHTTPCheckBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllHTTPCheckBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
